-- Softaculous SQL Dump
-- http://www.softaculous.com
--
-- Host: localhost
-- Generation Time: November 13, 2023, 9:48 pm
-- Server version: 8.0.35
-- PHP Version: 8.1.16

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `gyasi_mood586`
--

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_adminpresets`
--

CREATE TABLE `mdlxd_adminpresets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `comments` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `site` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `author` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `moodleversion` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `moodlerelease` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `iscore` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timeimported` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Table to store presets data';

--
-- Dumping data for table `mdlxd_adminpresets`
--

INSERT INTO `mdlxd_adminpresets` VALUES
(1, 0, 'Starter', 'Moodle with all of the most popular features, including Assignment, Feedback, Forum, H5P, Quiz and Completion tracking.', 'https://astitt.tech/unilearn', '', '', '', 1, 1698644927, 0),
(2, 0, 'Full', 'All the Starter features plus External (LTI) tool, SCORM, Workshop, Analytics, Badges, Competencies, Learning plans and lots more.', 'https://astitt.tech/unilearn', '', '', '', 2, 1698644927, 0);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_adminpresets_app`
--

CREATE TABLE `mdlxd_adminpresets_app` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `time` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_admiapp_adm_ix` (`adminpresetid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Applied presets';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_adminpresets_app_it`
--

CREATE TABLE `mdlxd_adminpresets_app_it` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetapplyid` bigint NOT NULL,
  `configlogid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_admiappit_con_ix` (`configlogid`),
  KEY `mdlxd_admiappit_adm_ix` (`adminpresetapplyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Admin presets applied items. To maintain the relation with c';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_adminpresets_app_it_a`
--

CREATE TABLE `mdlxd_adminpresets_app_it_a` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetapplyid` bigint NOT NULL,
  `configlogid` bigint NOT NULL,
  `itemname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_admiappita_con_ix` (`configlogid`),
  KEY `mdlxd_admiappita_adm_ix` (`adminpresetapplyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Attributes of the applied items';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_adminpresets_app_plug`
--

CREATE TABLE `mdlxd_adminpresets_app_plug` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetapplyid` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `value` smallint NOT NULL DEFAULT '0',
  `oldvalue` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_admiappplug_adm_ix` (`adminpresetapplyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Admin presets plugins applied';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_adminpresets_it`
--

CREATE TABLE `mdlxd_adminpresets_it` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetid` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `mdlxd_admiit_adm_ix` (`adminpresetid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Table to store settings';

--
-- Dumping data for table `mdlxd_adminpresets_it`
--

INSERT INTO `mdlxd_adminpresets_it` VALUES
(1, 1, 'none', 'usecomments', '0'),
(2, 1, 'none', 'usetags', '0'),
(3, 1, 'none', 'enablenotes', '0'),
(4, 1, 'none', 'enableblogs', '0'),
(5, 1, 'none', 'enablebadges', '0'),
(6, 1, 'none', 'enableanalytics', '0'),
(7, 1, 'core_competency', 'enabled', '0'),
(8, 1, 'core_competency', 'pushcourseratingstouserplans', '0'),
(9, 1, 'tool_dataprivacy', 'showdataretentionsummary', '0'),
(10, 1, 'none', 'forum_maxattachments', '3'),
(11, 1, 'none', 'guestloginbutton', '0'),
(12, 1, 'none', 'activitychoosertabmode', '4'),
(13, 2, 'none', 'usecomments', '1'),
(14, 2, 'none', 'usetags', '1'),
(15, 2, 'none', 'enablenotes', '1'),
(16, 2, 'none', 'enableblogs', '1'),
(17, 2, 'none', 'enablebadges', '1'),
(18, 2, 'none', 'enableanalytics', '1'),
(19, 2, 'core_competency', 'enabled', '1'),
(20, 2, 'core_competency', 'pushcourseratingstouserplans', '1'),
(21, 2, 'tool_dataprivacy', 'showdataretentionsummary', '1'),
(22, 2, 'none', 'forum_maxattachments', '9'),
(23, 2, 'none', 'guestloginbutton', '1'),
(24, 2, 'none', 'activitychoosertabmode', '3');

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_adminpresets_it_a`
--

CREATE TABLE `mdlxd_adminpresets_it_a` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `itemid` bigint NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `mdlxd_admiita_ite_ix` (`itemid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Admin presets items attributes. For settings with attributes';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_adminpresets_plug`
--

CREATE TABLE `mdlxd_adminpresets_plug` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `adminpresetid` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `enabled` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_admiplug_adm_ix` (`adminpresetid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Admin presets plugins status, to store information about whe';

--
-- Dumping data for table `mdlxd_adminpresets_plug`
--

INSERT INTO `mdlxd_adminpresets_plug` VALUES
(1, 1, 'mod', 'chat', 0),
(2, 1, 'mod', 'data', 0),
(3, 1, 'mod', 'lti', 0),
(4, 1, 'mod', 'imscp', 0),
(5, 1, 'mod', 'lesson', 0),
(6, 1, 'mod', 'scorm', 0),
(7, 1, 'mod', 'survey', 0),
(8, 1, 'mod', 'wiki', 0),
(9, 1, 'mod', 'workshop', 0),
(10, 1, 'availability', 'grouping', 0),
(11, 1, 'availability', 'profile', 0),
(12, 1, 'block', 'activity_modules', 0),
(13, 1, 'block', 'blog_menu', 0),
(14, 1, 'block', 'blog_tags', 0),
(15, 1, 'block', 'comments', 0),
(16, 1, 'block', 'completionstatus', 0),
(17, 1, 'block', 'course_summary', 0),
(18, 1, 'block', 'course_list', 0),
(19, 1, 'block', 'tag_flickr', 0),
(20, 1, 'block', 'globalsearch', 0),
(21, 1, 'block', 'badges', 0),
(22, 1, 'block', 'lp', 0),
(23, 1, 'block', 'myprofile', 0),
(24, 1, 'block', 'login', 0),
(25, 1, 'block', 'site_main_menu', 0),
(26, 1, 'block', 'mentees', 0),
(27, 1, 'block', 'mnet_hosts', 0),
(28, 1, 'block', 'private_files', 0),
(29, 1, 'block', 'blog_recent', 0),
(30, 1, 'block', 'rss_client', 0),
(31, 1, 'block', 'search_forums', 0),
(32, 1, 'block', 'section_links', 0),
(33, 1, 'block', 'selfcompletion', 0),
(34, 1, 'block', 'social_activities', 0),
(35, 1, 'block', 'tags', 0),
(36, 1, 'block', 'tag_youtube', 0),
(37, 1, 'block', 'feedback', 0),
(38, 1, 'block', 'online_users', 0),
(39, 1, 'block', 'recentlyaccessedcourses', 0),
(40, 1, 'block', 'starredcourses', 0),
(41, 1, 'format', 'social', 0),
(42, 1, 'dataformat', 'json', 0),
(43, 1, 'enrol', 'cohort', 0),
(44, 1, 'enrol', 'guest', 0),
(45, 1, 'filter', 'mathjaxloader', -9999),
(46, 1, 'filter', 'activitynames', -9999),
(47, 1, 'qbehaviour', 'adaptivenopenalty', 0),
(48, 1, 'qbehaviour', 'deferredcbm', 0),
(49, 1, 'qbehaviour', 'immediatecbm', 0),
(50, 1, 'qtype', 'calculated', 0),
(51, 1, 'qtype', 'calculatedmulti', 0),
(52, 1, 'qtype', 'calculatedsimple', 0),
(53, 1, 'qtype', 'ddmarker', 0),
(54, 1, 'qtype', 'ddimageortext', 0),
(55, 1, 'qtype', 'multianswer', 0),
(56, 1, 'qtype', 'numerical', 0),
(57, 1, 'qtype', 'randomsamatch', 0),
(58, 1, 'repository', 'local', 0),
(59, 1, 'repository', 'url', 0),
(60, 1, 'repository', 'wikimedia', 0),
(61, 2, 'mod', 'chat', 1),
(62, 2, 'mod', 'data', 1),
(63, 2, 'mod', 'lti', 1),
(64, 2, 'mod', 'imscp', 1),
(65, 2, 'mod', 'lesson', 1),
(66, 2, 'mod', 'scorm', 1),
(67, 2, 'mod', 'survey', 1),
(68, 2, 'mod', 'wiki', 1),
(69, 2, 'mod', 'workshop', 1),
(70, 2, 'availability', 'grouping', 1),
(71, 2, 'availability', 'profile', 1),
(72, 2, 'block', 'activity_modules', 1),
(73, 2, 'block', 'blog_menu', 1),
(74, 2, 'block', 'blog_tags', 1),
(75, 2, 'block', 'comments', 1),
(76, 2, 'block', 'completionstatus', 1),
(77, 2, 'block', 'course_list', 1),
(78, 2, 'block', 'tag_flickr', 1),
(79, 2, 'block', 'globalsearch', 1),
(80, 2, 'block', 'badges', 1),
(81, 2, 'block', 'lp', 1),
(82, 2, 'block', 'myprofile', 1),
(83, 2, 'block', 'login', 1),
(84, 2, 'block', 'site_main_menu', 1),
(85, 2, 'block', 'mentees', 1),
(86, 2, 'block', 'mnet_hosts', 1),
(87, 2, 'block', 'private_files', 1),
(88, 2, 'block', 'blog_recent', 1),
(89, 2, 'block', 'search_forums', 1),
(90, 2, 'block', 'section_links', 1),
(91, 2, 'block', 'social_activities', 1),
(92, 2, 'block', 'tags', 1),
(93, 2, 'block', 'online_users', 1),
(94, 2, 'block', 'recentlyaccessedcourses', 1),
(95, 2, 'block', 'starredcourses', 1),
(96, 2, 'format', 'social', 1),
(97, 2, 'dataformat', 'json', 1),
(98, 2, 'enrol', 'cohort', 1),
(99, 2, 'enrol', 'guest', 1),
(100, 2, 'filter', 'mathjaxloader', 1),
(101, 2, 'filter', 'activitynames', 1),
(102, 2, 'qbehaviour', 'adaptivenopenalty', 1),
(103, 2, 'qbehaviour', 'deferredcbm', 1),
(104, 2, 'qbehaviour', 'immediatecbm', 1),
(105, 2, 'qtype', 'calculated', 1),
(106, 2, 'qtype', 'calculatedmulti', 1),
(107, 2, 'qtype', 'calculatedsimple', 1),
(108, 2, 'qtype', 'ddmarker', 1),
(109, 2, 'qtype', 'ddimageortext', 1),
(110, 2, 'qtype', 'multianswer', 1),
(111, 2, 'qtype', 'numerical', 1),
(112, 2, 'qtype', 'randomsamatch', 1),
(113, 2, 'repository', 'local', 1),
(114, 2, 'repository', 'url', 1),
(115, 2, 'repository', 'wikimedia', 1);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_analytics_indicator_calc`
--

CREATE TABLE `mdlxd_analytics_indicator_calc` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `starttime` bigint NOT NULL,
  `endtime` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `sampleorigin` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `sampleid` bigint NOT NULL,
  `indicator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `value` decimal(10,2) DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_analindicalc_staendco_ix` (`starttime`,`endtime`,`contextid`),
  KEY `mdlxd_analindicalc_con_ix` (`contextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stored indicator calculations';

--
-- Dumping data for table `mdlxd_analytics_indicator_calc`
--

INSERT INTO `mdlxd_analytics_indicator_calc` VALUES
(1, 1698644927, 1698746401, 1, 'course', 3, '\\core_course\\analytics\\indicator\\no_teacher', '1.00', 1698746401),
(2, 1698644927, 1698746401, 1, 'course', 2, '\\core_course\\analytics\\indicator\\no_teacher', '1.00', 1698746401),
(3, 1698644927, 1698746401, 1, 'course', 3, '\\core_course\\analytics\\indicator\\no_student', '-1.00', 1698746401),
(4, 1698644927, 1698746401, 1, 'course', 2, '\\core_course\\analytics\\indicator\\no_student', '-1.00', 1698746401);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_analytics_models`
--

CREATE TABLE `mdlxd_analytics_models` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `trained` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(1333) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `target` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `indicators` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `predictionsprocessor` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `version` bigint NOT NULL,
  `contextids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `timecreated` bigint DEFAULT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_analmode_enatra_ix` (`enabled`,`trained`),
  KEY `mdlxd_analmode_use_ix` (`usermodified`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Analytic models.';

--
-- Dumping data for table `mdlxd_analytics_models`
--

INSERT INTO `mdlxd_analytics_models` VALUES
(1, 0, 0, NULL, '\\core_course\\analytics\\target\\course_dropout', '["\\\\core\\\\analytics\\\\indicator\\\\any_access_after_end","\\\\core\\\\analytics\\\\indicator\\\\any_access_before_start","\\\\core\\\\analytics\\\\indicator\\\\any_write_action_in_course","\\\\core\\\\analytics\\\\indicator\\\\read_actions","\\\\core_course\\\\analytics\\\\indicator\\\\completion_enabled","\\\\core_course\\\\analytics\\\\indicator\\\\potential_cognitive_depth","\\\\core_course\\\\analytics\\\\indicator\\\\potential_social_breadth","\\\\mod_assign\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_assign\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_book\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_book\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_chat\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_chat\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_choice\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_choice\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_data\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_data\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_folder\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_folder\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_forum\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_forum\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_label\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_label\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lti\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lti\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_page\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_page\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_resource\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_resource\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_survey\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_survey\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_url\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_url\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\social_breadth"]', NULL, NULL, 1698644927, NULL, 1698644927, 1698644927, 0),
(2, 1, 1, NULL, '\\core_course\\analytics\\target\\no_teaching', '["\\\\core_course\\\\analytics\\\\indicator\\\\no_teacher","\\\\core_course\\\\analytics\\\\indicator\\\\no_student"]', '\\core\\analytics\\time_splitting\\single_range', NULL, 1698644927, NULL, 1698644927, 1698644927, 0),
(3, 1, 1, NULL, '\\core_user\\analytics\\target\\upcoming_activities_due', '["\\\\core_course\\\\analytics\\\\indicator\\\\activities_due"]', '\\core\\analytics\\time_splitting\\upcoming_week', NULL, 1698644927, NULL, 1698644927, 1698644927, 0),
(4, 1, 1, NULL, '\\core_course\\analytics\\target\\no_access_since_course_start', '["\\\\core\\\\analytics\\\\indicator\\\\any_course_access"]', '\\core\\analytics\\time_splitting\\one_month_after_start', NULL, 1698644927, NULL, 1698644927, 1698644927, 0),
(5, 1, 1, NULL, '\\core_course\\analytics\\target\\no_recent_accesses', '["\\\\core\\\\analytics\\\\indicator\\\\any_course_access"]', '\\core\\analytics\\time_splitting\\past_month', NULL, 1698644927, NULL, 1698644927, 1698644927, 0);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_analytics_models_log`
--

CREATE TABLE `mdlxd_analytics_models_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `version` bigint NOT NULL,
  `evaluationmode` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `target` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `indicators` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `score` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `info` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `dir` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timecreated` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_analmodelog_mod_ix` (`modelid`),
  KEY `mdlxd_analmodelog_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Analytic models changes during evaluation.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_analytics_predictions`
--

CREATE TABLE `mdlxd_analytics_predictions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `sampleid` bigint NOT NULL,
  `rangeindex` mediumint NOT NULL,
  `prediction` decimal(10,2) NOT NULL,
  `predictionscore` decimal(10,5) NOT NULL,
  `calculations` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timestart` bigint DEFAULT NULL,
  `timeend` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_analpred_modcon_ix` (`modelid`,`contextid`),
  KEY `mdlxd_analpred_mod_ix` (`modelid`),
  KEY `mdlxd_analpred_con_ix` (`contextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Predictions';

--
-- Dumping data for table `mdlxd_analytics_predictions`
--

INSERT INTO `mdlxd_analytics_predictions` VALUES
(1, 2, 1, 3, 0, '1.00', '1.00000', '{"\\\\core_course\\\\analytics\\\\indicator\\\\no_teacher":1,"\\\\core_course\\\\analytics\\\\indicator\\\\no_student":-1}', 1698746402, 1698644927, 1698746402),
(2, 2, 1, 2, 0, '1.00', '1.00000', '{"\\\\core_course\\\\analytics\\\\indicator\\\\no_teacher":1,"\\\\core_course\\\\analytics\\\\indicator\\\\no_student":-1}', 1698746402, 1698644927, 1698746402);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_analytics_prediction_actions`
--

CREATE TABLE `mdlxd_analytics_prediction_actions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `predictionid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `actionname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_analpredacti_preuseac_ix` (`predictionid`,`userid`,`actionname`),
  KEY `mdlxd_analpredacti_pre_ix` (`predictionid`),
  KEY `mdlxd_analpredacti_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Register of user actions over predictions.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_analytics_predict_samples`
--

CREATE TABLE `mdlxd_analytics_predict_samples` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `analysableid` bigint NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `rangeindex` bigint NOT NULL,
  `sampleids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_analpredsamp_modanati_ix` (`modelid`,`analysableid`,`timesplitting`,`rangeindex`),
  KEY `mdlxd_analpredsamp_mod_ix` (`modelid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Samples already used for predictions.';

--
-- Dumping data for table `mdlxd_analytics_predict_samples`
--

INSERT INTO `mdlxd_analytics_predict_samples` VALUES
(1, 2, 1, '\\core\\analytics\\time_splitting\\single_range', 0, '{"3":3,"2":2}', 1698746402, 1698746402),
(2, 3, 3, '\\core\\analytics\\time_splitting\\upcoming_week', 0, '{"3":"3"}', 1699441202, 1699441202);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_analytics_train_samples`
--

CREATE TABLE `mdlxd_analytics_train_samples` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `analysableid` bigint NOT NULL,
  `timesplitting` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `sampleids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_analtraisamp_modanati_ix` (`modelid`,`analysableid`,`timesplitting`),
  KEY `mdlxd_analtraisamp_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Samples used for training';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_analytics_used_analysables`
--

CREATE TABLE `mdlxd_analytics_used_analysables` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL,
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `analysableid` bigint NOT NULL,
  `firstanalysis` bigint NOT NULL,
  `timeanalysed` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_analusedanal_modact_ix` (`modelid`,`action`),
  KEY `mdlxd_analusedanal_ana_ix` (`analysableid`),
  KEY `mdlxd_analusedanal_mod_ix` (`modelid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='List of analysables used by each model';

--
-- Dumping data for table `mdlxd_analytics_used_analysables`
--

INSERT INTO `mdlxd_analytics_used_analysables` VALUES
(1, 2, 'prediction', 1, 1698644943, 1699873201),
(2, 5, 'prediction', 3, 1698746402, 1699873201),
(3, 5, 'prediction', 2, 1698746402, 1699873201),
(4, 4, 'prediction', 3, 1698746402, 1699873201),
(5, 4, 'prediction', 2, 1698746402, 1699873201),
(6, 3, 'prediction', 3, 1699441202, 1699441202);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_analytics_used_files`
--

CREATE TABLE `mdlxd_analytics_used_files` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `modelid` bigint NOT NULL DEFAULT '0',
  `fileid` bigint NOT NULL DEFAULT '0',
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `time` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_analusedfile_modactfi_ix` (`modelid`,`action`,`fileid`),
  KEY `mdlxd_analusedfile_mod_ix` (`modelid`),
  KEY `mdlxd_analusedfile_fil_ix` (`fileid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Files that have already been used for training and predictio';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assign`
--

CREATE TABLE `mdlxd_assign` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `alwaysshowdescription` tinyint NOT NULL DEFAULT '0',
  `nosubmissions` tinyint NOT NULL DEFAULT '0',
  `submissiondrafts` tinyint NOT NULL DEFAULT '0',
  `sendnotifications` tinyint NOT NULL DEFAULT '0',
  `sendlatenotifications` tinyint NOT NULL DEFAULT '0',
  `duedate` bigint NOT NULL DEFAULT '0',
  `allowsubmissionsfromdate` bigint NOT NULL DEFAULT '0',
  `grade` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `requiresubmissionstatement` tinyint NOT NULL DEFAULT '0',
  `completionsubmit` tinyint NOT NULL DEFAULT '0',
  `cutoffdate` bigint NOT NULL DEFAULT '0',
  `gradingduedate` bigint NOT NULL DEFAULT '0',
  `teamsubmission` tinyint NOT NULL DEFAULT '0',
  `requireallteammemberssubmit` tinyint NOT NULL DEFAULT '0',
  `teamsubmissiongroupingid` bigint NOT NULL DEFAULT '0',
  `blindmarking` tinyint NOT NULL DEFAULT '0',
  `hidegrader` tinyint NOT NULL DEFAULT '0',
  `revealidentities` tinyint NOT NULL DEFAULT '0',
  `attemptreopenmethod` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'none',
  `maxattempts` mediumint NOT NULL DEFAULT '-1',
  `markingworkflow` tinyint NOT NULL DEFAULT '0',
  `markingallocation` tinyint NOT NULL DEFAULT '0',
  `sendstudentnotifications` tinyint NOT NULL DEFAULT '1',
  `preventsubmissionnotingroup` tinyint NOT NULL DEFAULT '0',
  `activity` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `activityformat` smallint NOT NULL DEFAULT '0',
  `timelimit` bigint NOT NULL DEFAULT '0',
  `submissionattachments` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_assi_cou_ix` (`course`),
  KEY `mdlxd_assi_tea_ix` (`teamsubmissiongroupingid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='This table saves information about an instance of mod_assign';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assignfeedback_comments`
--

CREATE TABLE `mdlxd_assignfeedback_comments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `grade` bigint NOT NULL DEFAULT '0',
  `commenttext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `commentformat` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_assicomm_ass_ix` (`assignment`),
  KEY `mdlxd_assicomm_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Text feedback for submitted assignments';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assignfeedback_editpdf_annot`
--

CREATE TABLE `mdlxd_assignfeedback_editpdf_annot` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gradeid` bigint NOT NULL DEFAULT '0',
  `pageno` bigint NOT NULL DEFAULT '0',
  `x` bigint DEFAULT '0',
  `y` bigint DEFAULT '0',
  `endx` bigint DEFAULT '0',
  `endy` bigint DEFAULT '0',
  `path` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'line',
  `colour` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'black',
  `draft` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdlxd_assieditanno_grapag_ix` (`gradeid`,`pageno`),
  KEY `mdlxd_assieditanno_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='stores annotations added to pdfs submitted by students';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assignfeedback_editpdf_cmnt`
--

CREATE TABLE `mdlxd_assignfeedback_editpdf_cmnt` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gradeid` bigint NOT NULL DEFAULT '0',
  `x` bigint DEFAULT '0',
  `y` bigint DEFAULT '0',
  `width` bigint DEFAULT '120',
  `rawtext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `pageno` bigint NOT NULL DEFAULT '0',
  `colour` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'black',
  `draft` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdlxd_assieditcmnt_grapag_ix` (`gradeid`,`pageno`),
  KEY `mdlxd_assieditcmnt_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stores comments added to pdfs';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assignfeedback_editpdf_quick`
--

CREATE TABLE `mdlxd_assignfeedback_editpdf_quick` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `rawtext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `width` bigint NOT NULL DEFAULT '120',
  `colour` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'yellow',
  PRIMARY KEY (`id`),
  KEY `mdlxd_assieditquic_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stores teacher specified quicklist comments';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assignfeedback_editpdf_rot`
--

CREATE TABLE `mdlxd_assignfeedback_editpdf_rot` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gradeid` bigint NOT NULL DEFAULT '0',
  `pageno` bigint NOT NULL DEFAULT '0',
  `pathnamehash` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `isrotated` tinyint(1) NOT NULL DEFAULT '0',
  `degree` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_assieditrot_grapag_uix` (`gradeid`,`pageno`),
  KEY `mdlxd_assieditrot_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stores rotation information of a page.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assignfeedback_file`
--

CREATE TABLE `mdlxd_assignfeedback_file` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `grade` bigint NOT NULL DEFAULT '0',
  `numfiles` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_assifile_ass2_ix` (`assignment`),
  KEY `mdlxd_assifile_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stores info about the number of files submitted by a student';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assignsubmission_file`
--

CREATE TABLE `mdlxd_assignsubmission_file` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `submission` bigint NOT NULL DEFAULT '0',
  `numfiles` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_assifile_ass_ix` (`assignment`),
  KEY `mdlxd_assifile_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Info about file submissions for assignments';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assignsubmission_onlinetext`
--

CREATE TABLE `mdlxd_assignsubmission_onlinetext` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `submission` bigint NOT NULL DEFAULT '0',
  `onlinetext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `onlineformat` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_assionli_ass_ix` (`assignment`),
  KEY `mdlxd_assionli_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Info about onlinetext submission';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assign_grades`
--

CREATE TABLE `mdlxd_assign_grades` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `grader` bigint NOT NULL DEFAULT '0',
  `grade` decimal(10,5) DEFAULT '0.00000',
  `attemptnumber` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_assigrad_assuseatt_uix` (`assignment`,`userid`,`attemptnumber`),
  KEY `mdlxd_assigrad_use_ix` (`userid`),
  KEY `mdlxd_assigrad_att_ix` (`attemptnumber`),
  KEY `mdlxd_assigrad_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Grading information about a single assignment submission.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assign_overrides`
--

CREATE TABLE `mdlxd_assign_overrides` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint DEFAULT NULL,
  `userid` bigint DEFAULT NULL,
  `sortorder` bigint DEFAULT NULL,
  `allowsubmissionsfromdate` bigint DEFAULT NULL,
  `duedate` bigint DEFAULT NULL,
  `cutoffdate` bigint DEFAULT NULL,
  `timelimit` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_assiover_ass_ix` (`assignid`),
  KEY `mdlxd_assiover_gro_ix` (`groupid`),
  KEY `mdlxd_assiover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='The overrides to assign settings.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assign_plugin_config`
--

CREATE TABLE `mdlxd_assign_plugin_config` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `plugin` varchar(28) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `subtype` varchar(28) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `name` varchar(28) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `mdlxd_assiplugconf_plu_ix` (`plugin`),
  KEY `mdlxd_assiplugconf_sub_ix` (`subtype`),
  KEY `mdlxd_assiplugconf_nam_ix` (`name`),
  KEY `mdlxd_assiplugconf_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Config data for an instance of a plugin in an assignment.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assign_submission`
--

CREATE TABLE `mdlxd_assign_submission` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `timestarted` bigint DEFAULT NULL,
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `groupid` bigint NOT NULL DEFAULT '0',
  `attemptnumber` bigint NOT NULL DEFAULT '0',
  `latest` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_assisubm_assusegroat_uix` (`assignment`,`userid`,`groupid`,`attemptnumber`),
  KEY `mdlxd_assisubm_use_ix` (`userid`),
  KEY `mdlxd_assisubm_att_ix` (`attemptnumber`),
  KEY `mdlxd_assisubm_assusegrolat_ix` (`assignment`,`userid`,`groupid`,`latest`),
  KEY `mdlxd_assisubm_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='This table keeps information about student interactions with';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assign_user_flags`
--

CREATE TABLE `mdlxd_assign_user_flags` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `assignment` bigint NOT NULL DEFAULT '0',
  `locked` bigint NOT NULL DEFAULT '0',
  `mailed` smallint NOT NULL DEFAULT '0',
  `extensionduedate` bigint NOT NULL DEFAULT '0',
  `workflowstate` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `allocatedmarker` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_assiuserflag_mai_ix` (`mailed`),
  KEY `mdlxd_assiuserflag_use_ix` (`userid`),
  KEY `mdlxd_assiuserflag_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='List of flags that can be set for a single user in a single ';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_assign_user_mapping`
--

CREATE TABLE `mdlxd_assign_user_mapping` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `assignment` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_assiusermapp_ass_ix` (`assignment`),
  KEY `mdlxd_assiusermapp_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Map an assignment specific id number to a user';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_auth_lti_linked_login`
--

CREATE TABLE `mdlxd_auth_lti_linked_login` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `issuer` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `issuer256` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `sub` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `sub256` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_authltilinklogi_usei_uix` (`userid`,`issuer256`,`sub256`),
  KEY `mdlxd_authltilinklogi_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Accounts linked to a users Moodle account.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_auth_oauth2_linked_login`
--

CREATE TABLE `mdlxd_auth_oauth2_linked_login` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `email` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `confirmtoken` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `confirmtokenexpires` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_authoautlinklogi_use_uix` (`userid`,`issuerid`,`username`),
  KEY `mdlxd_authoautlinklogi_issu_ix` (`issuerid`,`username`),
  KEY `mdlxd_authoautlinklogi_use_ix` (`usermodified`),
  KEY `mdlxd_authoautlinklogi_use2_ix` (`userid`),
  KEY `mdlxd_authoautlinklogi_iss_ix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Accounts linked to a users Moodle account.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_backup_controllers`
--

CREATE TABLE `mdlxd_backup_controllers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `operation` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'backup',
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `format` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `interactive` smallint NOT NULL,
  `purpose` smallint NOT NULL,
  `userid` bigint NOT NULL,
  `status` smallint NOT NULL,
  `execution` smallint NOT NULL,
  `executiontime` bigint NOT NULL,
  `checksum` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `progress` decimal(15,14) NOT NULL DEFAULT '0.00000000000000',
  `controller` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_backcont_bac_uix` (`backupid`),
  KEY `mdlxd_backcont_typite_ix` (`type`,`itemid`),
  KEY `mdlxd_backcont_useite_ix` (`userid`,`itemid`),
  KEY `mdlxd_backcont_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='To store the backup_controllers as they are used';

--
-- Dumping data for table `mdlxd_backup_controllers`
--

INSERT INTO `mdlxd_backup_controllers` VALUES
(1, '5138c50cb434e2d1ebefcb86cb5d61c7', 'backup', 'activity', 1, 'moodle2', 0, 50, 2, 1000, 1, 0, '3955357e65998f6befe4d90a6adff1b3', 1698730270, 1698730270, '0.00000000000000', ''),
(2, 'ff7fd35f1712aa8530dece33a3671cb8', 'backup', 'activity', 2, 'moodle2', 0, 50, 2, 1000, 1, 0, 'a0f98ae55b36d2f77bffa5046948ac82', 1698730448, 1698730449, '0.00000000000000', '');

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_backup_courses`
--

CREATE TABLE `mdlxd_backup_courses` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL DEFAULT '0',
  `laststarttime` bigint NOT NULL DEFAULT '0',
  `lastendtime` bigint NOT NULL DEFAULT '0',
  `laststatus` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '5',
  `nextstarttime` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_backcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='To store every course backup status';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_backup_logs`
--

CREATE TABLE `mdlxd_backup_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `loglevel` smallint NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_backlogs_bacid_uix` (`backupid`,`id`),
  KEY `mdlxd_backlogs_bac_ix` (`backupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='To store all the logs from backup and restore operations (by';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge`
--

CREATE TABLE `mdlxd_badge` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `usercreated` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `issuername` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `issuerurl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `issuercontact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `expiredate` bigint DEFAULT NULL,
  `expireperiod` bigint DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `courseid` bigint DEFAULT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `messagesubject` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `attachment` tinyint(1) NOT NULL DEFAULT '1',
  `notification` tinyint(1) NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `nextcron` bigint DEFAULT NULL,
  `version` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `language` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `imageauthorname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `imageauthoremail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `imageauthorurl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `imagecaption` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `mdlxd_badg_typ_ix` (`type`),
  KEY `mdlxd_badg_cou_ix` (`courseid`),
  KEY `mdlxd_badg_use_ix` (`usermodified`),
  KEY `mdlxd_badg_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines badge';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_alignment`
--

CREATE TABLE `mdlxd_badge_alignment` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `targetname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `targeturl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `targetdescription` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `targetframework` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `targetcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_badgalig_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines alignment for badges';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_backpack`
--

CREATE TABLE `mdlxd_badge_backpack` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `backpackuid` bigint NOT NULL,
  `autosync` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `externalbackpackid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_badgback_useext_uix` (`userid`,`externalbackpackid`),
  KEY `mdlxd_badgback_use_ix` (`userid`),
  KEY `mdlxd_badgback_ext_ix` (`externalbackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines settings for connecting external backpack';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_backpack_oauth2`
--

CREATE TABLE `mdlxd_badge_backpack_oauth2` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `externalbackpackid` bigint NOT NULL,
  `token` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `refreshtoken` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `expires` bigint DEFAULT NULL,
  `scope` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `mdlxd_badgbackoaut_use_ix` (`usermodified`),
  KEY `mdlxd_badgbackoaut_use2_ix` (`userid`),
  KEY `mdlxd_badgbackoaut_iss_ix` (`issuerid`),
  KEY `mdlxd_badgbackoaut_ext_ix` (`externalbackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Default comment for the table, please edit me';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_criteria`
--

CREATE TABLE `mdlxd_badge_criteria` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `criteriatype` bigint DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '1',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `descriptionformat` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_badgcrit_badcri_uix` (`badgeid`,`criteriatype`),
  KEY `mdlxd_badgcrit_cri_ix` (`criteriatype`),
  KEY `mdlxd_badgcrit_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines criteria for issuing badges';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_criteria_met`
--

CREATE TABLE `mdlxd_badge_criteria_met` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `issuedid` bigint DEFAULT NULL,
  `critid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `datemet` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_badgcritmet_cri_ix` (`critid`),
  KEY `mdlxd_badgcritmet_use_ix` (`userid`),
  KEY `mdlxd_badgcritmet_iss_ix` (`issuedid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines criteria that were met for an issued badge';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_criteria_param`
--

CREATE TABLE `mdlxd_badge_criteria_param` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `critid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_badgcritpara_cri_ix` (`critid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines parameters for badges criteria';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_endorsement`
--

CREATE TABLE `mdlxd_badge_endorsement` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `issuername` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `issuerurl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `issueremail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `claimid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `claimcomment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `dateissued` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_badgendo_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines endorsement for badge';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_external`
--

CREATE TABLE `mdlxd_badge_external` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backpackid` bigint NOT NULL,
  `collectionid` bigint NOT NULL,
  `entityid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `assertion` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `mdlxd_badgexte_bac_ix` (`backpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Setting for external badges display';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_external_backpack`
--

CREATE TABLE `mdlxd_badge_external_backpack` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `backpackapiurl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `backpackweburl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `apiversion` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '1.0',
  `sortorder` bigint NOT NULL DEFAULT '0',
  `oauth2_issuerid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_badgexteback_bac_uix` (`backpackapiurl`),
  UNIQUE KEY `mdlxd_badgexteback_bac2_uix` (`backpackweburl`),
  KEY `mdlxd_badgexteback_oau_ix` (`oauth2_issuerid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines settings for site level backpacks that a user can co';

--
-- Dumping data for table `mdlxd_badge_external_backpack`
--

INSERT INTO `mdlxd_badge_external_backpack` VALUES
(1, 'https://api.badgr.io/v2', 'https://badgr.io', '2', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_external_identifier`
--

CREATE TABLE `mdlxd_badge_external_identifier` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `sitebackpackid` bigint NOT NULL,
  `internalid` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `externalid` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `type` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_badgexteiden_sitinte_uix` (`sitebackpackid`,`internalid`,`externalid`,`type`),
  KEY `mdlxd_badgexteiden_sit_ix` (`sitebackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Setting for external badges mappings';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_issued`
--

CREATE TABLE `mdlxd_badge_issued` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `uniquehash` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `dateissued` bigint NOT NULL DEFAULT '0',
  `dateexpire` bigint DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '0',
  `issuernotified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_badgissu_baduse_uix` (`badgeid`,`userid`),
  KEY `mdlxd_badgissu_bad_ix` (`badgeid`),
  KEY `mdlxd_badgissu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines issued badges';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_manual_award`
--

CREATE TABLE `mdlxd_badge_manual_award` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL,
  `recipientid` bigint NOT NULL,
  `issuerid` bigint NOT NULL,
  `issuerrole` bigint NOT NULL,
  `datemet` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_badgmanuawar_bad_ix` (`badgeid`),
  KEY `mdlxd_badgmanuawar_rec_ix` (`recipientid`),
  KEY `mdlxd_badgmanuawar_iss_ix` (`issuerid`),
  KEY `mdlxd_badgmanuawar_iss2_ix` (`issuerrole`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Track manual award criteria for badges';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_badge_related`
--

CREATE TABLE `mdlxd_badge_related` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `badgeid` bigint NOT NULL DEFAULT '0',
  `relatedbadgeid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_badgrela_badrel_uix` (`badgeid`,`relatedbadgeid`),
  KEY `mdlxd_badgrela_bad_ix` (`badgeid`),
  KEY `mdlxd_badgrela_rel_ix` (`relatedbadgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines badge related for badges';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_bigbluebuttonbn`
--

CREATE TABLE `mdlxd_bigbluebuttonbn` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` tinyint NOT NULL DEFAULT '0',
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `introformat` smallint NOT NULL DEFAULT '1',
  `meetingid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `moderatorpass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `viewerpass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `wait` tinyint(1) NOT NULL DEFAULT '0',
  `record` tinyint(1) NOT NULL DEFAULT '0',
  `recordallfromstart` tinyint(1) NOT NULL DEFAULT '0',
  `recordhidebutton` tinyint(1) NOT NULL DEFAULT '0',
  `welcome` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `voicebridge` mediumint NOT NULL DEFAULT '0',
  `openingtime` bigint NOT NULL DEFAULT '0',
  `closingtime` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `presentation` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `participants` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `userlimit` smallint NOT NULL DEFAULT '0',
  `recordings_html` tinyint(1) NOT NULL DEFAULT '0',
  `recordings_deleted` tinyint(1) NOT NULL DEFAULT '1',
  `recordings_imported` tinyint(1) NOT NULL DEFAULT '0',
  `recordings_preview` tinyint(1) NOT NULL DEFAULT '0',
  `clienttype` tinyint(1) NOT NULL DEFAULT '0',
  `muteonstart` tinyint(1) NOT NULL DEFAULT '0',
  `disablecam` tinyint(1) NOT NULL DEFAULT '0',
  `disablemic` tinyint(1) NOT NULL DEFAULT '0',
  `disableprivatechat` tinyint(1) NOT NULL DEFAULT '0',
  `disablepublicchat` tinyint(1) NOT NULL DEFAULT '0',
  `disablenote` tinyint(1) NOT NULL DEFAULT '0',
  `hideuserlist` tinyint(1) NOT NULL DEFAULT '0',
  `completionattendance` int NOT NULL DEFAULT '0',
  `completionengagementchats` int NOT NULL DEFAULT '0',
  `completionengagementtalks` int NOT NULL DEFAULT '0',
  `completionengagementraisehand` int NOT NULL DEFAULT '0',
  `completionengagementpollvotes` int NOT NULL DEFAULT '0',
  `completionengagementemojis` int NOT NULL DEFAULT '0',
  `guestallowed` tinyint DEFAULT '0',
  `mustapproveuser` tinyint DEFAULT '1',
  `guestlinkuid` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `guestpassword` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='The bigbluebuttonbn table to store information about a meeti';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_bigbluebuttonbn_logs`
--

CREATE TABLE `mdlxd_bigbluebuttonbn_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `bigbluebuttonbnid` bigint NOT NULL,
  `userid` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `meetingid` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `log` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `mdlxd_bigblogs_cou_ix` (`courseid`),
  KEY `mdlxd_bigblogs_log_ix` (`log`),
  KEY `mdlxd_bigblogs_coubiguselog_ix` (`courseid`,`bigbluebuttonbnid`,`userid`,`log`),
  KEY `mdlxd_bigblogs_uselog_ix` (`userid`,`log`),
  KEY `mdlxd_bigblogs_coubig_ix` (`courseid`,`bigbluebuttonbnid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='The bigbluebuttonbn table to store meeting activity events';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_bigbluebuttonbn_recordings`
--

CREATE TABLE `mdlxd_bigbluebuttonbn_recordings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `bigbluebuttonbnid` bigint NOT NULL,
  `groupid` bigint DEFAULT NULL,
  `recordingid` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `headless` tinyint(1) NOT NULL DEFAULT '0',
  `imported` tinyint(1) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `importeddata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_bigbreco_cou_ix` (`courseid`),
  KEY `mdlxd_bigbreco_rec_ix` (`recordingid`),
  KEY `mdlxd_bigbreco_big_ix` (`bigbluebuttonbnid`),
  KEY `mdlxd_bigbreco_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='The bigbluebuttonbn table to store references to recordings';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_block`
--

CREATE TABLE `mdlxd_block` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `cron` bigint NOT NULL DEFAULT '0',
  `lastcron` bigint NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_bloc_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='contains all installed blocks';

--
-- Dumping data for table `mdlxd_block`
--

INSERT INTO `mdlxd_block` VALUES
(1, 'accessreview', 0, 0, 1),
(2, 'activity_modules', 0, 0, 1),
(3, 'activity_results', 0, 0, 1),
(4, 'admin_bookmarks', 0, 0, 1),
(5, 'badges', 0, 0, 1),
(6, 'blog_menu', 0, 0, 1),
(7, 'blog_recent', 0, 0, 1),
(8, 'blog_tags', 0, 0, 1),
(9, 'calendar_month', 0, 0, 1),
(10, 'calendar_upcoming', 0, 0, 1),
(11, 'comments', 0, 0, 1),
(12, 'completionstatus', 0, 0, 1),
(13, 'course_list', 0, 0, 1),
(14, 'course_summary', 0, 0, 0),
(15, 'feedback', 0, 0, 0),
(16, 'globalsearch', 0, 0, 1),
(17, 'glossary_random', 0, 0, 1),
(18, 'html', 0, 0, 1),
(19, 'login', 0, 0, 1),
(20, 'lp', 0, 0, 1),
(21, 'mentees', 0, 0, 1),
(22, 'mnet_hosts', 0, 0, 1),
(23, 'myoverview', 0, 0, 1),
(24, 'myprofile', 0, 0, 1),
(25, 'navigation', 0, 0, 1),
(26, 'news_items', 0, 0, 1),
(27, 'online_users', 0, 0, 1),
(28, 'private_files', 0, 0, 1),
(29, 'recent_activity', 0, 0, 1),
(30, 'recentlyaccessedcourses', 0, 0, 1),
(31, 'recentlyaccesseditems', 0, 0, 1),
(32, 'rss_client', 0, 0, 0),
(33, 'search_forums', 0, 0, 1),
(34, 'section_links', 0, 0, 1),
(35, 'selfcompletion', 0, 0, 0),
(36, 'settings', 0, 0, 1),
(37, 'site_main_menu', 0, 0, 1),
(38, 'social_activities', 0, 0, 1),
(39, 'starredcourses', 0, 0, 1),
(40, 'tag_flickr', 0, 0, 1),
(41, 'tag_youtube', 0, 0, 0),
(42, 'tags', 0, 0, 1),
(43, 'timeline', 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_block_instances`
--

CREATE TABLE `mdlxd_block_instances` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `blockname` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `parentcontextid` bigint NOT NULL,
  `showinsubcontexts` smallint NOT NULL,
  `requiredbytheme` smallint NOT NULL DEFAULT '0',
  `pagetypepattern` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `subpagepattern` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `defaultregion` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `defaultweight` bigint NOT NULL,
  `configdata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_blocinst_parshopagsub_ix` (`parentcontextid`,`showinsubcontexts`,`pagetypepattern`,`subpagepattern`),
  KEY `mdlxd_blocinst_tim_ix` (`timemodified`),
  KEY `mdlxd_blocinst_blo_ix` (`blockname`),
  KEY `mdlxd_blocinst_par_ix` (`parentcontextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='This table stores block instances. The type of block this is';

--
-- Dumping data for table `mdlxd_block_instances`
--

INSERT INTO `mdlxd_block_instances` VALUES
(1, 'admin_bookmarks', 1, 0, 0, 'admin-*', NULL, 'side-pre', 2, '', 1698644927, 1698644927),
(2, 'recentlyaccesseditems', 1, 0, 0, 'my-index', '2', 'side-post', 0, '', 1698644927, 1698644927),
(3, 'timeline', 1, 0, 0, 'my-index', '2', 'content', 0, '', 1698644927, 1698644927),
(4, 'calendar_month', 1, 0, 0, 'my-index', '2', 'content', 1, '', 1698644927, 1698644927),
(5, 'myoverview', 1, 0, 0, 'my-index', '3', 'content', 0, '', 1698644927, 1698644927),
(6, 'recentlyaccesseditems', 5, 0, 0, 'my-index', '4', 'side-post', 0, '', 1698645577, 1698645577),
(7, 'timeline', 5, 0, 0, 'my-index', '4', 'content', 0, '', 1698645577, 1698645577),
(8, 'calendar_month', 5, 0, 0, 'my-index', '4', 'content', 1, '', 1698645577, 1698645577),
(9, 'social_activities', 16, 0, 0, 'course-view-*', NULL, 'side-post', 0, '', 1698729643, 1698729643),
(10, 'recentlyaccesseditems', 25, 0, 0, 'my-index', '6', 'side-post', 0, '', 1699929347, 1699929347),
(11, 'timeline', 25, 0, 0, 'my-index', '6', 'content', 0, '', 1699929347, 1699929347),
(12, 'calendar_month', 25, 0, 0, 'my-index', '6', 'content', 1, '', 1699929347, 1699929347);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_block_positions`
--

CREATE TABLE `mdlxd_block_positions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `blockinstanceid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `pagetype` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `subpage` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `visible` smallint NOT NULL,
  `region` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `weight` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_blocposi_bloconpagsu_uix` (`blockinstanceid`,`contextid`,`pagetype`,`subpage`),
  KEY `mdlxd_blocposi_blo_ix` (`blockinstanceid`),
  KEY `mdlxd_blocposi_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the position of a sticky block_instance on a another ';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_block_recentlyaccesseditems`
--

CREATE TABLE `mdlxd_block_recentlyaccesseditems` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `cmid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `timeaccess` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_blocrece_usecoucmi_uix` (`userid`,`courseid`,`cmid`),
  KEY `mdlxd_blocrece_use_ix` (`userid`),
  KEY `mdlxd_blocrece_cou_ix` (`courseid`),
  KEY `mdlxd_blocrece_cmi_ix` (`cmid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Most recently accessed items accessed by a user';

--
-- Dumping data for table `mdlxd_block_recentlyaccesseditems`
--

INSERT INTO `mdlxd_block_recentlyaccesseditems` VALUES
(2, 2, 3, 2, 1698730412),
(3, 3, 4, 2, 1698730496);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_block_recent_activity`
--

CREATE TABLE `mdlxd_block_recent_activity` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `cmid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `action` tinyint(1) NOT NULL,
  `modname` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_blocreceacti_coutim_ix` (`courseid`,`timecreated`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Recent activity block';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_block_rss_client`
--

CREATE TABLE `mdlxd_block_rss_client` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `preferredtitle` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `shared` tinyint NOT NULL DEFAULT '0',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `skiptime` bigint NOT NULL DEFAULT '0',
  `skipuntil` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Remote news feed information. Contains the news feed id, the';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_blog_association`
--

CREATE TABLE `mdlxd_blog_association` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `blogid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_blogasso_con_ix` (`contextid`),
  KEY `mdlxd_blogasso_blo_ix` (`blogid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Associations of blog entries with courses and module instanc';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_blog_external`
--

CREATE TABLE `mdlxd_blog_external` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `url` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `filtertags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `failedlastsync` tinyint(1) NOT NULL DEFAULT '0',
  `timemodified` bigint DEFAULT NULL,
  `timefetched` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_blogexte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='External blog links used for RSS copying of blog entries to ';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_book`
--

CREATE TABLE `mdlxd_book` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `introformat` smallint NOT NULL DEFAULT '0',
  `numbering` smallint NOT NULL DEFAULT '0',
  `navstyle` smallint NOT NULL DEFAULT '1',
  `customtitles` tinyint NOT NULL DEFAULT '0',
  `revision` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_book_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines book';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_book_chapters`
--

CREATE TABLE `mdlxd_book_chapters` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `bookid` bigint NOT NULL DEFAULT '0',
  `pagenum` bigint NOT NULL DEFAULT '0',
  `subchapter` bigint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `contentformat` smallint NOT NULL DEFAULT '0',
  `hidden` tinyint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `importsrc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdlxd_bookchap_boo_ix` (`bookid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Defines book_chapters';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_cache_filters`
--

CREATE TABLE `mdlxd_cache_filters` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `version` bigint NOT NULL DEFAULT '0',
  `md5key` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `rawtext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_cachfilt_filmd5_ix` (`filter`,`md5key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='For keeping information about cached data';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_cache_flags`
--

CREATE TABLE `mdlxd_cache_flags` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `flagtype` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `expiry` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_cachflag_fla_ix` (`flagtype`),
  KEY `mdlxd_cachflag_nam_ix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Cache of time-sensitive flags';

--
-- Dumping data for table `mdlxd_cache_flags`
--

INSERT INTO `mdlxd_cache_flags` VALUES
(11, 'userpreferenceschanged', '2', 1699931666, '1', 1699960466),
(12, 'userpreferenceschanged', '4', 1699928624, '1', 1699957424),
(13, 'userpreferenceschanged', '5', 1699931653, '1', 1699960453),
(14, 'accesslib/dirtyusers', '4', 1699929463, '1', 1699958263),
(15, 'accesslib/dirtyusers', '5', 1699929463, '1', 1699958263),
(16, 'accesslib/dirtyusers', '3', 1699929463, '1', 1699958263);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_capabilities`
--

CREATE TABLE `mdlxd_capabilities` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `captype` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `contextlevel` bigint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `riskbitmask` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_capa_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='this defines all capabilities';

--
-- Dumping data for table `mdlxd_capabilities`
--

INSERT INTO `mdlxd_capabilities` VALUES
(1, 'moodle/site:config', 'write', 10, 'moodle', 62),
(2, 'moodle/site:configview', 'read', 10, 'moodle', 0),
(3, 'moodle/site:readallmessages', 'read', 10, 'moodle', 8),
(4, 'moodle/site:manageallmessaging', 'write', 10, 'moodle', 8),
(5, 'moodle/site:deleteanymessage', 'write', 10, 'moodle', 32),
(6, 'moodle/site:sendmessage', 'write', 10, 'moodle', 16),
(7, 'moodle/site:senderrormessage', 'write', 10, 'moodle', 16),
(8, 'moodle/site:deleteownmessage', 'write', 10, 'moodle', 0),
(9, 'moodle/site:approvecourse', 'write', 40, 'moodle', 4),
(10, 'moodle/backup:backupcourse', 'write', 50, 'moodle', 28),
(11, 'moodle/backup:backupsection', 'write', 50, 'moodle', 28),
(12, 'moodle/backup:backupactivity', 'write', 70, 'moodle', 28),
(13, 'moodle/backup:backuptargetimport', 'read', 50, 'moodle', 28),
(14, 'moodle/backup:downloadfile', 'write', 50, 'moodle', 28),
(15, 'moodle/backup:configure', 'write', 50, 'moodle', 28),
(16, 'moodle/backup:userinfo', 'read', 50, 'moodle', 8),
(17, 'moodle/backup:anonymise', 'read', 50, 'moodle', 8),
(18, 'moodle/restore:restorecourse', 'write', 50, 'moodle', 28),
(19, 'moodle/restore:restoresection', 'write', 50, 'moodle', 28),
(20, 'moodle/restore:restoreactivity', 'write', 50, 'moodle', 28),
(21, 'moodle/restore:viewautomatedfilearea', 'write', 50, 'moodle', 28),
(22, 'moodle/restore:restoretargetimport', 'write', 50, 'moodle', 28),
(23, 'moodle/restore:uploadfile', 'write', 50, 'moodle', 28),
(24, 'moodle/restore:configure', 'write', 50, 'moodle', 28),
(25, 'moodle/restore:rolldates', 'write', 50, 'moodle', 0),
(26, 'moodle/restore:userinfo', 'write', 50, 'moodle', 30),
(27, 'moodle/restore:createuser', 'write', 10, 'moodle', 24),
(28, 'moodle/site:manageblocks', 'write', 80, 'moodle', 20),
(29, 'moodle/site:accessallgroups', 'read', 70, 'moodle', 0),
(30, 'moodle/site:viewanonymousevents', 'read', 70, 'moodle', 8),
(31, 'moodle/site:viewfullnames', 'read', 70, 'moodle', 0),
(32, 'moodle/site:viewuseridentity', 'read', 70, 'moodle', 0),
(33, 'moodle/site:viewreports', 'read', 50, 'moodle', 8),
(34, 'moodle/site:trustcontent', 'write', 70, 'moodle', 4),
(35, 'moodle/site:uploadusers', 'write', 10, 'moodle', 24),
(36, 'moodle/filter:manage', 'write', 50, 'moodle', 0),
(37, 'moodle/user:create', 'write', 10, 'moodle', 24),
(38, 'moodle/user:delete', 'write', 10, 'moodle', 40),
(39, 'moodle/user:update', 'write', 10, 'moodle', 24),
(40, 'moodle/user:viewdetails', 'read', 50, 'moodle', 0),
(41, 'moodle/user:viewalldetails', 'read', 30, 'moodle', 8),
(42, 'moodle/user:viewlastip', 'read', 30, 'moodle', 8),
(43, 'moodle/user:viewhiddendetails', 'read', 50, 'moodle', 8),
(44, 'moodle/user:loginas', 'write', 50, 'moodle', 30),
(45, 'moodle/user:managesyspages', 'write', 10, 'moodle', 0),
(46, 'moodle/user:manageblocks', 'write', 30, 'moodle', 0),
(47, 'moodle/user:manageownblocks', 'write', 10, 'moodle', 0),
(48, 'moodle/user:manageownfiles', 'write', 10, 'moodle', 0),
(49, 'moodle/user:ignoreuserquota', 'write', 10, 'moodle', 0),
(50, 'moodle/my:configsyspages', 'write', 10, 'moodle', 0),
(51, 'moodle/role:assign', 'write', 50, 'moodle', 28),
(52, 'moodle/role:review', 'read', 50, 'moodle', 8),
(53, 'moodle/role:override', 'write', 50, 'moodle', 28),
(54, 'moodle/role:safeoverride', 'write', 50, 'moodle', 16),
(55, 'moodle/role:manage', 'write', 10, 'moodle', 28),
(56, 'moodle/role:switchroles', 'read', 50, 'moodle', 12),
(57, 'moodle/category:manage', 'write', 40, 'moodle', 4),
(58, 'moodle/category:viewcourselist', 'read', 40, 'moodle', 0),
(59, 'moodle/category:viewhiddencategories', 'read', 40, 'moodle', 0),
(60, 'moodle/cohort:manage', 'write', 40, 'moodle', 0),
(61, 'moodle/cohort:assign', 'write', 40, 'moodle', 0),
(62, 'moodle/cohort:view', 'read', 50, 'moodle', 0),
(63, 'moodle/cohort:configurecustomfields', 'write', 10, 'moodle', 16),
(64, 'moodle/group:configurecustomfields', 'write', 10, 'moodle', 16),
(65, 'moodle/course:create', 'write', 40, 'moodle', 4),
(66, 'moodle/course:creategroupconversations', 'write', 50, 'moodle', 4),
(67, 'moodle/course:request', 'write', 40, 'moodle', 0),
(68, 'moodle/course:delete', 'write', 50, 'moodle', 32),
(69, 'moodle/course:update', 'write', 50, 'moodle', 4),
(70, 'moodle/course:view', 'read', 50, 'moodle', 0),
(71, 'moodle/course:enrolreview', 'read', 50, 'moodle', 8),
(72, 'moodle/course:enrolconfig', 'write', 50, 'moodle', 8),
(73, 'moodle/course:reviewotherusers', 'read', 50, 'moodle', 0),
(74, 'moodle/course:bulkmessaging', 'write', 50, 'moodle', 16),
(75, 'moodle/course:viewhiddenuserfields', 'read', 50, 'moodle', 8),
(76, 'moodle/course:viewhiddencourses', 'read', 50, 'moodle', 0),
(77, 'moodle/course:visibility', 'write', 50, 'moodle', 0),
(78, 'moodle/course:managefiles', 'write', 50, 'moodle', 4),
(79, 'moodle/course:ignoreavailabilityrestrictions', 'read', 70, 'moodle', 0),
(80, 'moodle/course:ignorefilesizelimits', 'write', 50, 'moodle', 0),
(81, 'moodle/course:manageactivities', 'write', 70, 'moodle', 4),
(82, 'moodle/course:activityvisibility', 'write', 70, 'moodle', 0),
(83, 'moodle/course:viewhiddenactivities', 'read', 70, 'moodle', 0),
(84, 'moodle/course:viewparticipants', 'read', 50, 'moodle', 0),
(85, 'moodle/course:changefullname', 'write', 50, 'moodle', 4),
(86, 'moodle/course:changeshortname', 'write', 50, 'moodle', 4),
(87, 'moodle/course:changelockedcustomfields', 'write', 50, 'moodle', 16),
(88, 'moodle/course:configurecustomfields', 'write', 10, 'moodle', 16),
(89, 'moodle/course:renameroles', 'write', 50, 'moodle', 0),
(90, 'moodle/course:changeidnumber', 'write', 50, 'moodle', 4),
(91, 'moodle/course:changecategory', 'write', 50, 'moodle', 4),
(92, 'moodle/course:changesummary', 'write', 50, 'moodle', 4),
(93, 'moodle/course:setforcedlanguage', 'write', 50, 'moodle', 0),
(94, 'moodle/site:viewparticipants', 'read', 10, 'moodle', 0),
(95, 'moodle/course:isincompletionreports', 'read', 50, 'moodle', 0),
(96, 'moodle/course:viewscales', 'read', 50, 'moodle', 0),
(97, 'moodle/course:managescales', 'write', 50, 'moodle', 0),
(98, 'moodle/course:managegroups', 'write', 50, 'moodle', 4),
(99, 'moodle/course:viewhiddengroups', 'READ', 50, 'moodle', 8),
(100, 'moodle/course:reset', 'write', 50, 'moodle', 32),
(101, 'moodle/course:viewsuspendedusers', 'read', 50, 'moodle', 0),
(102, 'moodle/course:tag', 'write', 50, 'moodle', 16),
(103, 'moodle/blog:view', 'read', 10, 'moodle', 0),
(104, 'moodle/blog:search', 'read', 10, 'moodle', 0),
(105, 'moodle/blog:viewdrafts', 'read', 10, 'moodle', 8),
(106, 'moodle/blog:create', 'write', 10, 'moodle', 16),
(107, 'moodle/blog:manageentries', 'write', 10, 'moodle', 16),
(108, 'moodle/blog:manageexternal', 'write', 10, 'moodle', 16),
(109, 'moodle/calendar:manageownentries', 'write', 50, 'moodle', 16),
(110, 'moodle/calendar:managegroupentries', 'write', 50, 'moodle', 16),
(111, 'moodle/calendar:manageentries', 'write', 50, 'moodle', 16),
(112, 'moodle/user:editprofile', 'write', 30, 'moodle', 24),
(113, 'moodle/user:editownprofile', 'write', 10, 'moodle', 16),
(114, 'moodle/user:changeownpassword', 'write', 10, 'moodle', 0),
(115, 'moodle/user:readuserposts', 'read', 30, 'moodle', 0),
(116, 'moodle/user:readuserblogs', 'read', 30, 'moodle', 0),
(117, 'moodle/user:viewuseractivitiesreport', 'read', 30, 'moodle', 8),
(118, 'moodle/user:editmessageprofile', 'write', 30, 'moodle', 16),
(119, 'moodle/user:editownmessageprofile', 'write', 10, 'moodle', 0),
(120, 'moodle/question:managecategory', 'write', 50, 'moodle', 20),
(121, 'moodle/question:add', 'write', 50, 'moodle', 20),
(122, 'moodle/question:editmine', 'write', 50, 'moodle', 20),
(123, 'moodle/question:editall', 'write', 50, 'moodle', 20),
(124, 'moodle/question:viewmine', 'read', 50, 'moodle', 0),
(125, 'moodle/question:viewall', 'read', 50, 'moodle', 0),
(126, 'moodle/question:usemine', 'read', 50, 'moodle', 0),
(127, 'moodle/question:useall', 'read', 50, 'moodle', 0),
(128, 'moodle/question:movemine', 'write', 50, 'moodle', 0),
(129, 'moodle/question:moveall', 'write', 50, 'moodle', 0),
(130, 'moodle/question:config', 'write', 10, 'moodle', 2),
(131, 'moodle/question:flag', 'write', 50, 'moodle', 0),
(132, 'moodle/question:tagmine', 'write', 50, 'moodle', 0),
(133, 'moodle/question:tagall', 'write', 50, 'moodle', 0),
(134, 'moodle/site:doclinks', 'read', 10, 'moodle', 0),
(135, 'moodle/course:sectionvisibility', 'write', 50, 'moodle', 0),
(136, 'moodle/course:useremail', 'write', 50, 'moodle', 0),
(137, 'moodle/course:viewhiddensections', 'read', 50, 'moodle', 0),
(138, 'moodle/course:setcurrentsection', 'write', 50, 'moodle', 0),
(139, 'moodle/course:movesections', 'write', 50, 'moodle', 0),
(140, 'moodle/site:mnetlogintoremote', 'read', 10, 'moodle', 0),
(141, 'moodle/grade:viewall', 'read', 50, 'moodle', 8),
(142, 'moodle/grade:view', 'read', 50, 'moodle', 0),
(143, 'moodle/grade:viewhidden', 'read', 50, 'moodle', 8),
(144, 'moodle/grade:import', 'write', 50, 'moodle', 12),
(145, 'moodle/grade:export', 'read', 50, 'moodle', 8),
(146, 'moodle/grade:manage', 'write', 50, 'moodle', 12),
(147, 'moodle/grade:edit', 'write', 50, 'moodle', 12),
(148, 'moodle/grade:managegradingforms', 'write', 50, 'moodle', 12),
(149, 'moodle/grade:sharegradingforms', 'write', 10, 'moodle', 4),
(150, 'moodle/grade:managesharedforms', 'write', 10, 'moodle', 4),
(151, 'moodle/grade:manageoutcomes', 'write', 50, 'moodle', 0),
(152, 'moodle/grade:manageletters', 'write', 50, 'moodle', 0),
(153, 'moodle/grade:hide', 'write', 50, 'moodle', 0),
(154, 'moodle/grade:lock', 'write', 50, 'moodle', 0),
(155, 'moodle/grade:unlock', 'write', 50, 'moodle', 0),
(156, 'moodle/my:manageblocks', 'write', 10, 'moodle', 0),
(157, 'moodle/notes:view', 'read', 50, 'moodle', 0),
(158, 'moodle/notes:manage', 'write', 50, 'moodle', 16),
(159, 'moodle/tag:manage', 'write', 10, 'moodle', 16),
(160, 'moodle/tag:edit', 'write', 10, 'moodle', 16),
(161, 'moodle/tag:flag', 'write', 10, 'moodle', 16),
(162, 'moodle/tag:editblocks', 'write', 10, 'moodle', 0),
(163, 'moodle/block:view', 'read', 80, 'moodle', 0),
(164, 'moodle/block:edit', 'write', 80, 'moodle', 20),
(165, 'moodle/portfolio:export', 'read', 10, 'moodle', 0),
(166, 'moodle/comment:view', 'read', 50, 'moodle', 0),
(167, 'moodle/comment:post', 'write', 50, 'moodle', 24),
(168, 'moodle/comment:delete', 'write', 50, 'moodle', 32),
(169, 'moodle/webservice:createtoken', 'write', 10, 'moodle', 62),
(170, 'moodle/webservice:managealltokens', 'write', 10, 'moodle', 42),
(171, 'moodle/webservice:createmobiletoken', 'write', 10, 'moodle', 24),
(172, 'moodle/rating:view', 'read', 50, 'moodle', 0),
(173, 'moodle/rating:viewany', 'read', 50, 'moodle', 8),
(174, 'moodle/rating:viewall', 'read', 50, 'moodle', 8),
(175, 'moodle/rating:rate', 'write', 50, 'moodle', 0),
(176, 'moodle/course:markcomplete', 'write', 50, 'moodle', 0),
(177, 'moodle/course:overridecompletion', 'write', 50, 'moodle', 0),
(178, 'moodle/badges:manageglobalsettings', 'write', 10, 'moodle', 34),
(179, 'moodle/badges:viewbadges', 'read', 50, 'moodle', 0),
(180, 'moodle/badges:manageownbadges', 'write', 30, 'moodle', 0),
(181, 'moodle/badges:viewotherbadges', 'read', 30, 'moodle', 0),
(182, 'moodle/badges:earnbadge', 'write', 50, 'moodle', 0),
(183, 'moodle/badges:createbadge', 'write', 50, 'moodle', 16),
(184, 'moodle/badges:deletebadge', 'write', 50, 'moodle', 32),
(185, 'moodle/badges:configuredetails', 'write', 50, 'moodle', 16),
(186, 'moodle/badges:configurecriteria', 'write', 50, 'moodle', 4),
(187, 'moodle/badges:configuremessages', 'write', 50, 'moodle', 16),
(188, 'moodle/badges:awardbadge', 'write', 50, 'moodle', 16),
(189, 'moodle/badges:revokebadge', 'write', 50, 'moodle', 16),
(190, 'moodle/badges:viewawarded', 'read', 50, 'moodle', 8),
(191, 'moodle/site:forcelanguage', 'read', 10, 'moodle', 0),
(192, 'moodle/search:query', 'read', 10, 'moodle', 0),
(193, 'moodle/competency:competencymanage', 'write', 40, 'moodle', 0),
(194, 'moodle/competency:competencyview', 'read', 40, 'moodle', 0),
(195, 'moodle/competency:competencygrade', 'write', 50, 'moodle', 0),
(196, 'moodle/competency:coursecompetencymanage', 'write', 50, 'moodle', 0),
(197, 'moodle/competency:coursecompetencyconfigure', 'write', 70, 'moodle', 0),
(198, 'moodle/competency:coursecompetencygradable', 'read', 50, 'moodle', 0),
(199, 'moodle/competency:coursecompetencyview', 'read', 50, 'moodle', 0),
(200, 'moodle/competency:evidencedelete', 'write', 30, 'moodle', 0),
(201, 'moodle/competency:planmanage', 'write', 30, 'moodle', 0),
(202, 'moodle/competency:planmanagedraft', 'write', 30, 'moodle', 0),
(203, 'moodle/competency:planmanageown', 'write', 30, 'moodle', 0),
(204, 'moodle/competency:planmanageowndraft', 'write', 30, 'moodle', 0),
(205, 'moodle/competency:planview', 'read', 30, 'moodle', 0),
(206, 'moodle/competency:planviewdraft', 'read', 30, 'moodle', 0),
(207, 'moodle/competency:planviewown', 'read', 30, 'moodle', 0),
(208, 'moodle/competency:planviewowndraft', 'read', 30, 'moodle', 0),
(209, 'moodle/competency:planrequestreview', 'write', 30, 'moodle', 0),
(210, 'moodle/competency:planrequestreviewown', 'write', 30, 'moodle', 0),
(211, 'moodle/competency:planreview', 'write', 30, 'moodle', 0),
(212, 'moodle/competency:plancomment', 'write', 30, 'moodle', 0),
(213, 'moodle/competency:plancommentown', 'write', 30, 'moodle', 0),
(214, 'moodle/competency:usercompetencyview', 'read', 30, 'moodle', 0),
(215, 'moodle/competency:usercompetencyrequestreview', 'write', 30, 'moodle', 0),
(216, 'moodle/competency:usercompetencyrequestreviewown', 'write', 30, 'moodle', 0),
(217, 'moodle/competency:usercompetencyreview', 'write', 30, 'moodle', 0),
(218, 'moodle/competency:usercompetencycomment', 'write', 30, 'moodle', 0),
(219, 'moodle/competency:usercompetencycommentown', 'write', 30, 'moodle', 0),
(220, 'moodle/competency:templatemanage', 'write', 40, 'moodle', 0),
(221, 'moodle/analytics:listinsights', 'read', 50, 'moodle', 8),
(222, 'moodle/analytics:managemodels', 'write', 10, 'moodle', 2),
(223, 'moodle/competency:templateview', 'read', 40, 'moodle', 0),
(224, 'moodle/competency:userevidencemanage', 'write', 30, 'moodle', 0),
(225, 'moodle/competency:userevidencemanageown', 'write', 30, 'moodle', 0),
(226, 'moodle/competency:userevidenceview', 'read', 30, 'moodle', 0),
(227, 'moodle/site:maintenanceaccess', 'write', 10, 'moodle', 0),
(228, 'moodle/site:messageanyuser', 'write', 10, 'moodle', 16),
(229, 'moodle/site:managecontextlocks', 'write', 70, 'moodle', 0),
(230, 'moodle/course:togglecompletion', 'write', 70, 'moodle', 0),
(231, 'moodle/analytics:listowninsights', 'read', 10, 'moodle', 0),
(232, 'moodle/h5p:setdisplayoptions', 'write', 70, 'moodle', 0),
(233, 'moodle/h5p:deploy', 'write', 70, 'moodle', 4),
(234, 'moodle/h5p:updatelibraries', 'write', 70, 'moodle', 4),
(235, 'moodle/course:recommendactivity', 'write', 10, 'moodle', 0),
(236, 'moodle/contentbank:access', 'read', 50, 'moodle', 0),
(237, 'moodle/contentbank:upload', 'write', 50, 'moodle', 16),
(238, 'moodle/contentbank:deleteanycontent', 'write', 50, 'moodle', 32),
(239, 'moodle/contentbank:deleteowncontent', 'write', 50, 'moodle', 0),
(240, 'moodle/contentbank:manageanycontent', 'write', 50, 'moodle', 32),
(241, 'moodle/contentbank:manageowncontent', 'write', 50, 'moodle', 0),
(242, 'moodle/contentbank:useeditor', 'write', 50, 'moodle', 16),
(243, 'moodle/contentbank:downloadcontent', 'read', 50, 'moodle', 0),
(244, 'moodle/contentbank:copyanycontent', 'write', 50, 'moodle', 16),
(245, 'moodle/contentbank:copycontent', 'write', 50, 'moodle', 16),
(246, 'moodle/course:downloadcoursecontent', 'read', 50, 'moodle', 0),
(247, 'moodle/course:configuredownloadcontent', 'write', 50, 'moodle', 0),
(248, 'moodle/payment:manageaccounts', 'write', 50, 'moodle', 42),
(249, 'moodle/payment:viewpayments', 'read', 50, 'moodle', 8),
(250, 'moodle/contentbank:viewunlistedcontent', 'read', 50, 'moodle', 0),
(251, 'moodle/reportbuilder:view', 'read', 10, 'moodle', 0),
(252, 'moodle/reportbuilder:edit', 'write', 10, 'moodle', 0),
(253, 'moodle/reportbuilder:editall', 'write', 10, 'moodle', 0),
(254, 'moodle/reportbuilder:scheduleviewas', 'read', 10, 'moodle', 0),
(255, 'moodle/moodlenet:shareactivity', 'read', 50, 'moodle', 0),
(256, 'moodle/course:configurecoursecommunication', 'write', 50, 'moodle', 0),
(257, 'moodle/moodlenet:sharecourse', 'read', 50, 'moodle', 0),
(258, 'mod/assign:view', 'read', 70, 'mod_assign', 0),
(259, 'mod/assign:submit', 'write', 70, 'mod_assign', 0),
(260, 'mod/assign:grade', 'write', 70, 'mod_assign', 4),
(261, 'mod/assign:exportownsubmission', 'read', 70, 'mod_assign', 0),
(262, 'mod/assign:addinstance', 'write', 50, 'mod_assign', 4),
(263, 'mod/assign:editothersubmission', 'write', 70, 'mod_assign', 41),
(264, 'mod/assign:grantextension', 'write', 70, 'mod_assign', 0),
(265, 'mod/assign:revealidentities', 'write', 70, 'mod_assign', 0),
(266, 'mod/assign:reviewgrades', 'write', 70, 'mod_assign', 0),
(267, 'mod/assign:releasegrades', 'write', 70, 'mod_assign', 0),
(268, 'mod/assign:managegrades', 'write', 70, 'mod_assign', 0),
(269, 'mod/assign:manageallocations', 'write', 70, 'mod_assign', 0),
(270, 'mod/assign:viewgrades', 'read', 70, 'mod_assign', 0),
(271, 'mod/assign:viewblinddetails', 'write', 70, 'mod_assign', 8),
(272, 'mod/assign:receivegradernotifications', 'read', 70, 'mod_assign', 0),
(273, 'mod/assign:manageoverrides', 'write', 70, 'mod_assign', 0),
(274, 'mod/assign:showhiddengrader', 'read', 70, 'mod_assign', 0),
(275, 'mod/assign:viewownsubmissionsummary', 'read', 70, 'mod_assign', 0),
(276, 'mod/bigbluebuttonbn:addinstance', 'write', 50, 'mod_bigbluebuttonbn', 4),
(277, 'mod/bigbluebuttonbn:addinstancewithmeeting', 'write', 70, 'mod_bigbluebuttonbn', 0),
(278, 'mod/bigbluebuttonbn:addinstancewithrecording', 'write', 70, 'mod_bigbluebuttonbn', 0),
(279, 'mod/bigbluebuttonbn:join', 'read', 70, 'mod_bigbluebuttonbn', 0),
(280, 'mod/bigbluebuttonbn:view', 'read', 70, 'mod_bigbluebuttonbn', 0),
(281, 'mod/bigbluebuttonbn:managerecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(282, 'mod/bigbluebuttonbn:viewallrecordingformats', 'read', 70, 'mod_bigbluebuttonbn', 0),
(283, 'mod/bigbluebuttonbn:publishrecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(284, 'mod/bigbluebuttonbn:unpublishrecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(285, 'mod/bigbluebuttonbn:protectrecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(286, 'mod/bigbluebuttonbn:unprotectrecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(287, 'mod/bigbluebuttonbn:deleterecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(288, 'mod/bigbluebuttonbn:importrecordings', 'write', 70, 'mod_bigbluebuttonbn', 0),
(289, 'mod/book:addinstance', 'write', 50, 'mod_book', 4),
(290, 'mod/book:read', 'read', 70, 'mod_book', 0),
(291, 'mod/book:viewhiddenchapters', 'read', 70, 'mod_book', 0),
(292, 'mod/book:edit', 'write', 70, 'mod_book', 4),
(293, 'mod/chat:addinstance', 'write', 50, 'mod_chat', 4),
(294, 'mod/chat:chat', 'write', 70, 'mod_chat', 16),
(295, 'mod/chat:readlog', 'read', 70, 'mod_chat', 0),
(296, 'mod/chat:deletelog', 'write', 70, 'mod_chat', 0),
(297, 'mod/chat:exportparticipatedsession', 'read', 70, 'mod_chat', 8),
(298, 'mod/chat:exportsession', 'read', 70, 'mod_chat', 8),
(299, 'mod/chat:view', 'read', 70, 'mod_chat', 0),
(300, 'mod/choice:addinstance', 'write', 50, 'mod_choice', 4),
(301, 'mod/choice:choose', 'write', 70, 'mod_choice', 0),
(302, 'mod/choice:readresponses', 'read', 70, 'mod_choice', 0),
(303, 'mod/choice:deleteresponses', 'write', 70, 'mod_choice', 0),
(304, 'mod/choice:downloadresponses', 'read', 70, 'mod_choice', 0),
(305, 'mod/choice:view', 'read', 70, 'mod_choice', 0),
(306, 'mod/data:addinstance', 'write', 50, 'mod_data', 4),
(307, 'mod/data:viewentry', 'read', 70, 'mod_data', 0),
(308, 'mod/data:writeentry', 'write', 70, 'mod_data', 16),
(309, 'mod/data:comment', 'write', 70, 'mod_data', 16),
(310, 'mod/data:rate', 'write', 70, 'mod_data', 0),
(311, 'mod/data:viewrating', 'read', 70, 'mod_data', 0),
(312, 'mod/data:viewanyrating', 'read', 70, 'mod_data', 8),
(313, 'mod/data:viewallratings', 'read', 70, 'mod_data', 8),
(314, 'mod/data:approve', 'write', 70, 'mod_data', 16),
(315, 'mod/data:manageentries', 'write', 70, 'mod_data', 16),
(316, 'mod/data:managecomments', 'write', 70, 'mod_data', 16),
(317, 'mod/data:managetemplates', 'write', 70, 'mod_data', 20),
(318, 'mod/data:viewalluserpresets', 'read', 70, 'mod_data', 0),
(319, 'mod/data:manageuserpresets', 'write', 70, 'mod_data', 20),
(320, 'mod/data:exportentry', 'read', 70, 'mod_data', 8),
(321, 'mod/data:exportownentry', 'read', 70, 'mod_data', 0),
(322, 'mod/data:exportallentries', 'read', 70, 'mod_data', 8),
(323, 'mod/data:exportuserinfo', 'read', 70, 'mod_data', 8),
(324, 'mod/data:view', 'read', 70, 'mod_data', 0),
(325, 'mod/feedback:addinstance', 'write', 50, 'mod_feedback', 4),
(326, 'mod/feedback:view', 'read', 70, 'mod_feedback', 0),
(327, 'mod/feedback:complete', 'write', 70, 'mod_feedback', 16),
(328, 'mod/feedback:viewanalysepage', 'read', 70, 'mod_feedback', 8),
(329, 'mod/feedback:deletesubmissions', 'write', 70, 'mod_feedback', 0),
(330, 'mod/feedback:mapcourse', 'write', 70, 'mod_feedback', 0),
(331, 'mod/feedback:edititems', 'write', 70, 'mod_feedback', 20),
(332, 'mod/feedback:createprivatetemplate', 'write', 70, 'mod_feedback', 16),
(333, 'mod/feedback:createpublictemplate', 'write', 70, 'mod_feedback', 16),
(334, 'mod/feedback:deletetemplate', 'write', 70, 'mod_feedback', 0),
(335, 'mod/feedback:viewreports', 'read', 70, 'mod_feedback', 8),
(336, 'mod/feedback:receivemail', 'read', 70, 'mod_feedback', 8),
(337, 'mod/folder:addinstance', 'write', 50, 'mod_folder', 4),
(338, 'mod/folder:view', 'read', 70, 'mod_folder', 0),
(339, 'mod/folder:managefiles', 'write', 70, 'mod_folder', 20),
(340, 'mod/forum:addinstance', 'write', 50, 'mod_forum', 4),
(341, 'mod/forum:viewdiscussion', 'read', 70, 'mod_forum', 0),
(342, 'mod/forum:viewhiddentimedposts', 'read', 70, 'mod_forum', 0),
(343, 'mod/forum:startdiscussion', 'write', 70, 'mod_forum', 16),
(344, 'mod/forum:replypost', 'write', 70, 'mod_forum', 16),
(345, 'mod/forum:addnews', 'write', 70, 'mod_forum', 16),
(346, 'mod/forum:replynews', 'write', 70, 'mod_forum', 16),
(347, 'mod/forum:viewrating', 'read', 70, 'mod_forum', 0),
(348, 'mod/forum:viewanyrating', 'read', 70, 'mod_forum', 8),
(349, 'mod/forum:viewallratings', 'read', 70, 'mod_forum', 8),
(350, 'mod/forum:rate', 'write', 70, 'mod_forum', 0),
(351, 'mod/forum:postprivatereply', 'write', 70, 'mod_forum', 0),
(352, 'mod/forum:readprivatereplies', 'read', 70, 'mod_forum', 0),
(353, 'mod/forum:createattachment', 'write', 70, 'mod_forum', 16),
(354, 'mod/forum:deleteownpost', 'write', 70, 'mod_forum', 0),
(355, 'mod/forum:deleteanypost', 'write', 70, 'mod_forum', 0),
(356, 'mod/forum:splitdiscussions', 'write', 70, 'mod_forum', 0),
(357, 'mod/forum:movediscussions', 'write', 70, 'mod_forum', 0),
(358, 'mod/forum:pindiscussions', 'write', 70, 'mod_forum', 0),
(359, 'mod/forum:editanypost', 'write', 70, 'mod_forum', 16),
(360, 'mod/forum:viewqandawithoutposting', 'read', 70, 'mod_forum', 0),
(361, 'mod/forum:viewsubscribers', 'read', 70, 'mod_forum', 0),
(362, 'mod/forum:managesubscriptions', 'write', 70, 'mod_forum', 16),
(363, 'mod/forum:postwithoutthrottling', 'write', 70, 'mod_forum', 16),
(364, 'mod/forum:exportdiscussion', 'read', 70, 'mod_forum', 8),
(365, 'mod/forum:exportforum', 'read', 70, 'mod_forum', 8),
(366, 'mod/forum:exportpost', 'read', 70, 'mod_forum', 8),
(367, 'mod/forum:exportownpost', 'read', 70, 'mod_forum', 8),
(368, 'mod/forum:addquestion', 'write', 70, 'mod_forum', 16),
(369, 'mod/forum:allowforcesubscribe', 'read', 70, 'mod_forum', 0),
(370, 'mod/forum:canposttomygroups', 'write', 70, 'mod_forum', 0),
(371, 'mod/forum:canoverridediscussionlock', 'write', 70, 'mod_forum', 0),
(372, 'mod/forum:canoverridecutoff', 'write', 70, 'mod_forum', 0),
(373, 'mod/forum:cantogglefavourite', 'write', 70, 'mod_forum', 0),
(374, 'mod/forum:grade', 'write', 70, 'mod_forum', 0),
(375, 'mod/forum:canmailnow', 'write', 70, 'mod_forum', 16),
(376, 'mod/glossary:addinstance', 'write', 50, 'mod_glossary', 4),
(377, 'mod/glossary:view', 'read', 70, 'mod_glossary', 0),
(378, 'mod/glossary:write', 'write', 70, 'mod_glossary', 16),
(379, 'mod/glossary:manageentries', 'write', 70, 'mod_glossary', 16),
(380, 'mod/glossary:managecategories', 'write', 70, 'mod_glossary', 16),
(381, 'mod/glossary:comment', 'write', 70, 'mod_glossary', 16),
(382, 'mod/glossary:managecomments', 'write', 70, 'mod_glossary', 16),
(383, 'mod/glossary:import', 'write', 70, 'mod_glossary', 16),
(384, 'mod/glossary:export', 'read', 70, 'mod_glossary', 0),
(385, 'mod/glossary:approve', 'write', 70, 'mod_glossary', 16),
(386, 'mod/glossary:rate', 'write', 70, 'mod_glossary', 0),
(387, 'mod/glossary:viewrating', 'read', 70, 'mod_glossary', 0),
(388, 'mod/glossary:viewanyrating', 'read', 70, 'mod_glossary', 8),
(389, 'mod/glossary:viewallratings', 'read', 70, 'mod_glossary', 8),
(390, 'mod/glossary:exportentry', 'read', 70, 'mod_glossary', 8),
(391, 'mod/glossary:exportownentry', 'read', 70, 'mod_glossary', 0),
(392, 'mod/h5pactivity:view', 'read', 70, 'mod_h5pactivity', 0),
(393, 'mod/h5pactivity:addinstance', 'write', 50, 'mod_h5pactivity', 0),
(394, 'mod/h5pactivity:submit', 'write', 70, 'mod_h5pactivity', 0),
(395, 'mod/h5pactivity:reviewattempts', 'read', 70, 'mod_h5pactivity', 0),
(396, 'mod/imscp:view', 'read', 70, 'mod_imscp', 0),
(397, 'mod/imscp:addinstance', 'write', 50, 'mod_imscp', 4),
(398, 'mod/label:addinstance', 'write', 50, 'mod_label', 4),
(399, 'mod/label:view', 'read', 70, 'mod_label', 0),
(400, 'mod/lesson:addinstance', 'write', 50, 'mod_lesson', 4),
(401, 'mod/lesson:edit', 'write', 70, 'mod_lesson', 4),
(402, 'mod/lesson:grade', 'write', 70, 'mod_lesson', 20),
(403, 'mod/lesson:viewreports', 'read', 70, 'mod_lesson', 8),
(404, 'mod/lesson:manage', 'write', 70, 'mod_lesson', 0),
(405, 'mod/lesson:manageoverrides', 'write', 70, 'mod_lesson', 0),
(406, 'mod/lesson:view', 'read', 70, 'mod_lesson', 0),
(407, 'mod/lti:view', 'read', 70, 'mod_lti', 0),
(408, 'mod/lti:addinstance', 'write', 50, 'mod_lti', 4),
(409, 'mod/lti:manage', 'write', 70, 'mod_lti', 8),
(410, 'mod/lti:admin', 'write', 70, 'mod_lti', 8),
(411, 'mod/lti:addcoursetool', 'write', 50, 'mod_lti', 0),
(412, 'mod/lti:addpreconfiguredinstance', 'write', 50, 'mod_lti', 0),
(413, 'mod/lti:requesttooladd', 'write', 50, 'mod_lti', 0),
(414, 'mod/page:view', 'read', 70, 'mod_page', 0),
(415, 'mod/page:addinstance', 'write', 50, 'mod_page', 4),
(416, 'mod/quiz:view', 'read', 70, 'mod_quiz', 0),
(417, 'mod/quiz:addinstance', 'write', 50, 'mod_quiz', 4),
(418, 'mod/quiz:attempt', 'write', 70, 'mod_quiz', 16),
(419, 'mod/quiz:reviewmyattempts', 'read', 70, 'mod_quiz', 0),
(420, 'mod/quiz:manage', 'write', 70, 'mod_quiz', 16),
(421, 'mod/quiz:manageoverrides', 'write', 70, 'mod_quiz', 0),
(422, 'mod/quiz:viewoverrides', 'read', 70, 'mod_quiz', 0),
(423, 'mod/quiz:preview', 'write', 70, 'mod_quiz', 0),
(424, 'mod/quiz:grade', 'write', 70, 'mod_quiz', 20),
(425, 'mod/quiz:regrade', 'write', 70, 'mod_quiz', 16),
(426, 'mod/quiz:viewreports', 'read', 70, 'mod_quiz', 8),
(427, 'mod/quiz:deleteattempts', 'write', 70, 'mod_quiz', 32),
(428, 'mod/quiz:reopenattempts', 'write', 70, 'mod_quiz', 0),
(429, 'mod/quiz:ignoretimelimits', 'read', 70, 'mod_quiz', 0),
(430, 'mod/quiz:emailconfirmsubmission', 'read', 70, 'mod_quiz', 0),
(431, 'mod/quiz:emailnotifysubmission', 'read', 70, 'mod_quiz', 0),
(432, 'mod/quiz:emailwarnoverdue', 'read', 70, 'mod_quiz', 0),
(433, 'mod/quiz:emailnotifyattemptgraded', 'read', 70, 'mod_quiz', 0),
(434, 'mod/resource:view', 'read', 70, 'mod_resource', 0),
(435, 'mod/resource:addinstance', 'write', 50, 'mod_resource', 4),
(436, 'mod/scorm:addinstance', 'write', 50, 'mod_scorm', 4),
(437, 'mod/scorm:viewreport', 'read', 70, 'mod_scorm', 0),
(438, 'mod/scorm:skipview', 'read', 70, 'mod_scorm', 0),
(439, 'mod/scorm:savetrack', 'write', 70, 'mod_scorm', 0),
(440, 'mod/scorm:viewscores', 'read', 70, 'mod_scorm', 0),
(441, 'mod/scorm:deleteresponses', 'write', 70, 'mod_scorm', 0),
(442, 'mod/scorm:deleteownresponses', 'write', 70, 'mod_scorm', 0),
(443, 'mod/survey:addinstance', 'write', 50, 'mod_survey', 4),
(444, 'mod/survey:participate', 'read', 70, 'mod_survey', 0),
(445, 'mod/survey:readresponses', 'read', 70, 'mod_survey', 0),
(446, 'mod/survey:download', 'read', 70, 'mod_survey', 0),
(447, 'mod/url:view', 'read', 70, 'mod_url', 0),
(448, 'mod/url:addinstance', 'write', 50, 'mod_url', 4),
(449, 'mod/wiki:addinstance', 'write', 50, 'mod_wiki', 4),
(450, 'mod/wiki:viewpage', 'read', 70, 'mod_wiki', 0),
(451, 'mod/wiki:editpage', 'write', 70, 'mod_wiki', 16),
(452, 'mod/wiki:createpage', 'write', 70, 'mod_wiki', 16),
(453, 'mod/wiki:viewcomment', 'read', 70, 'mod_wiki', 0),
(454, 'mod/wiki:editcomment', 'write', 70, 'mod_wiki', 16),
(455, 'mod/wiki:managecomment', 'write', 70, 'mod_wiki', 0),
(456, 'mod/wiki:managefiles', 'write', 70, 'mod_wiki', 0),
(457, 'mod/wiki:overridelock', 'write', 70, 'mod_wiki', 0),
(458, 'mod/wiki:managewiki', 'write', 70, 'mod_wiki', 0),
(459, 'mod/workshop:view', 'read', 70, 'mod_workshop', 0),
(460, 'mod/workshop:addinstance', 'write', 50, 'mod_workshop', 4),
(461, 'mod/workshop:switchphase', 'write', 70, 'mod_workshop', 0),
(462, 'mod/workshop:editdimensions', 'write', 70, 'mod_workshop', 4),
(463, 'mod/workshop:submit', 'write', 70, 'mod_workshop', 0),
(464, 'mod/workshop:peerassess', 'write', 70, 'mod_workshop', 0),
(465, 'mod/workshop:manageexamples', 'write', 70, 'mod_workshop', 0),
(466, 'mod/workshop:allocate', 'write', 70, 'mod_workshop', 0),
(467, 'mod/workshop:publishsubmissions', 'write', 70, 'mod_workshop', 0),
(468, 'mod/workshop:viewauthornames', 'read', 70, 'mod_workshop', 0),
(469, 'mod/workshop:viewreviewernames', 'read', 70, 'mod_workshop', 0),
(470, 'mod/workshop:viewallsubmissions', 'read', 70, 'mod_workshop', 0),
(471, 'mod/workshop:viewpublishedsubmissions', 'read', 70, 'mod_workshop', 0),
(472, 'mod/workshop:viewauthorpublished', 'read', 70, 'mod_workshop', 0),
(473, 'mod/workshop:viewallassessments', 'read', 70, 'mod_workshop', 0),
(474, 'mod/workshop:overridegrades', 'write', 70, 'mod_workshop', 0),
(475, 'mod/workshop:ignoredeadlines', 'write', 70, 'mod_workshop', 0),
(476, 'mod/workshop:deletesubmissions', 'write', 70, 'mod_workshop', 0),
(477, 'mod/workshop:exportsubmissions', 'read', 70, 'mod_workshop', 0),
(478, 'auth/oauth2:managelinkedlogins', 'write', 30, 'auth_oauth2', 0),
(479, 'communication/matrix:moderator', 'read', 50, 'communication_matrix', 0),
(480, 'enrol/category:synchronised', 'write', 10, 'enrol_category', 0),
(481, 'enrol/category:config', 'write', 50, 'enrol_category', 0),
(482, 'enrol/cohort:config', 'write', 50, 'enrol_cohort', 0),
(483, 'enrol/cohort:unenrol', 'write', 50, 'enrol_cohort', 0),
(484, 'enrol/database:unenrol', 'write', 50, 'enrol_database', 0),
(485, 'enrol/database:config', 'write', 50, 'enrol_database', 0),
(486, 'enrol/fee:config', 'write', 50, 'enrol_fee', 0),
(487, 'enrol/fee:manage', 'write', 50, 'enrol_fee', 0),
(488, 'enrol/fee:unenrol', 'write', 50, 'enrol_fee', 0),
(489, 'enrol/fee:unenrolself', 'write', 50, 'enrol_fee', 0),
(490, 'enrol/flatfile:manage', 'write', 50, 'enrol_flatfile', 0),
(491, 'enrol/flatfile:unenrol', 'write', 50, 'enrol_flatfile', 0),
(492, 'enrol/guest:config', 'write', 50, 'enrol_guest', 0),
(493, 'enrol/imsenterprise:config', 'write', 50, 'enrol_imsenterprise', 0),
(494, 'enrol/ldap:manage', 'write', 50, 'enrol_ldap', 0),
(495, 'enrol/lti:config', 'write', 50, 'enrol_lti', 0),
(496, 'enrol/lti:unenrol', 'write', 50, 'enrol_lti', 0),
(497, 'enrol/manual:config', 'write', 50, 'enrol_manual', 0),
(498, 'enrol/manual:enrol', 'write', 50, 'enrol_manual', 0),
(499, 'enrol/manual:manage', 'write', 50, 'enrol_manual', 0),
(500, 'enrol/manual:unenrol', 'write', 50, 'enrol_manual', 0),
(501, 'enrol/manual:unenrolself', 'write', 50, 'enrol_manual', 0),
(502, 'enrol/meta:config', 'write', 50, 'enrol_meta', 0),
(503, 'enrol/meta:selectaslinked', 'read', 50, 'enrol_meta', 0),
(504, 'enrol/meta:unenrol', 'write', 50, 'enrol_meta', 0),
(505, 'enrol/mnet:config', 'write', 50, 'enrol_mnet', 0),
(506, 'enrol/paypal:config', 'write', 50, 'enrol_paypal', 0),
(507, 'enrol/paypal:manage', 'write', 50, 'enrol_paypal', 0),
(508, 'enrol/paypal:unenrol', 'write', 50, 'enrol_paypal', 0),
(509, 'enrol/paypal:unenrolself', 'write', 50, 'enrol_paypal', 0),
(510, 'enrol/self:config', 'write', 50, 'enrol_self', 0),
(511, 'enrol/self:manage', 'write', 50, 'enrol_self', 0),
(512, 'enrol/self:holdkey', 'write', 50, 'enrol_self', 0),
(513, 'enrol/self:unenrolself', 'write', 50, 'enrol_self', 0),
(514, 'enrol/self:unenrol', 'write', 50, 'enrol_self', 0),
(515, 'enrol/self:enrolself', 'write', 50, 'enrol_self', 0),
(516, 'message/airnotifier:managedevice', 'write', 10, 'message_airnotifier', 0),
(517, 'block/accessreview:addinstance', 'write', 80, 'block_accessreview', 0),
(518, 'block/accessreview:view', 'read', 80, 'block_accessreview', 0),
(519, 'block/activity_modules:addinstance', 'write', 80, 'block_activity_modules', 20),
(520, 'block/activity_results:addinstance', 'write', 80, 'block_activity_results', 20),
(521, 'block/admin_bookmarks:myaddinstance', 'write', 10, 'block_admin_bookmarks', 0),
(522, 'block/admin_bookmarks:addinstance', 'write', 80, 'block_admin_bookmarks', 20),
(523, 'block/badges:addinstance', 'read', 80, 'block_badges', 0),
(524, 'block/badges:myaddinstance', 'read', 10, 'block_badges', 8),
(525, 'block/blog_menu:addinstance', 'write', 80, 'block_blog_menu', 20),
(526, 'block/blog_recent:addinstance', 'write', 80, 'block_blog_recent', 20),
(527, 'block/blog_tags:addinstance', 'write', 80, 'block_blog_tags', 20),
(528, 'block/calendar_month:myaddinstance', 'write', 10, 'block_calendar_month', 0),
(529, 'block/calendar_month:addinstance', 'write', 80, 'block_calendar_month', 20),
(530, 'block/calendar_upcoming:myaddinstance', 'write', 10, 'block_calendar_upcoming', 0),
(531, 'block/calendar_upcoming:addinstance', 'write', 80, 'block_calendar_upcoming', 20),
(532, 'block/comments:myaddinstance', 'write', 10, 'block_comments', 0),
(533, 'block/comments:addinstance', 'write', 80, 'block_comments', 20),
(534, 'block/completionstatus:addinstance', 'write', 80, 'block_completionstatus', 20),
(535, 'block/course_list:myaddinstance', 'write', 10, 'block_course_list', 0),
(536, 'block/course_list:addinstance', 'write', 80, 'block_course_list', 20),
(537, 'block/course_summary:addinstance', 'write', 80, 'block_course_summary', 20),
(538, 'block/feedback:addinstance', 'write', 80, 'block_feedback', 20),
(539, 'block/globalsearch:myaddinstance', 'write', 10, 'block_globalsearch', 0),
(540, 'block/globalsearch:addinstance', 'write', 80, 'block_globalsearch', 0),
(541, 'block/glossary_random:myaddinstance', 'write', 10, 'block_glossary_random', 0),
(542, 'block/glossary_random:addinstance', 'write', 80, 'block_glossary_random', 20),
(543, 'block/html:myaddinstance', 'write', 10, 'block_html', 0),
(544, 'block/html:addinstance', 'write', 80, 'block_html', 20),
(545, 'block/login:addinstance', 'write', 80, 'block_login', 20),
(546, 'block/lp:addinstance', 'write', 10, 'block_lp', 0),
(547, 'block/lp:myaddinstance', 'write', 10, 'block_lp', 0),
(548, 'block/mentees:myaddinstance', 'write', 10, 'block_mentees', 0),
(549, 'block/mentees:addinstance', 'write', 80, 'block_mentees', 20),
(550, 'block/mnet_hosts:myaddinstance', 'write', 10, 'block_mnet_hosts', 0),
(551, 'block/mnet_hosts:addinstance', 'write', 80, 'block_mnet_hosts', 20),
(552, 'block/myoverview:myaddinstance', 'write', 10, 'block_myoverview', 0),
(553, 'block/myprofile:myaddinstance', 'write', 10, 'block_myprofile', 0),
(554, 'block/myprofile:addinstance', 'write', 80, 'block_myprofile', 20),
(555, 'block/navigation:myaddinstance', 'write', 10, 'block_navigation', 0),
(556, 'block/navigation:addinstance', 'write', 80, 'block_navigation', 20),
(557, 'block/news_items:myaddinstance', 'write', 10, 'block_news_items', 0),
(558, 'block/news_items:addinstance', 'write', 80, 'block_news_items', 20),
(559, 'block/online_users:myaddinstance', 'write', 10, 'block_online_users', 0),
(560, 'block/online_users:addinstance', 'write', 80, 'block_online_users', 20),
(561, 'block/online_users:viewlist', 'read', 80, 'block_online_users', 0),
(562, 'block/private_files:myaddinstance', 'write', 10, 'block_private_files', 0),
(563, 'block/private_files:addinstance', 'write', 80, 'block_private_files', 20),
(564, 'block/recent_activity:addinstance', 'write', 80, 'block_recent_activity', 20),
(565, 'block/recent_activity:viewaddupdatemodule', 'read', 50, 'block_recent_activity', 0),
(566, 'block/recent_activity:viewdeletemodule', 'read', 50, 'block_recent_activity', 0),
(567, 'block/recentlyaccessedcourses:myaddinstance', 'write', 10, 'block_recentlyaccessedcourses', 0),
(568, 'block/recentlyaccesseditems:myaddinstance', 'write', 10, 'block_recentlyaccesseditems', 0),
(569, 'block/rss_client:myaddinstance', 'write', 10, 'block_rss_client', 0),
(570, 'block/rss_client:addinstance', 'write', 80, 'block_rss_client', 20),
(571, 'block/rss_client:manageownfeeds', 'write', 80, 'block_rss_client', 0),
(572, 'block/rss_client:manageanyfeeds', 'write', 80, 'block_rss_client', 16),
(573, 'block/search_forums:addinstance', 'write', 80, 'block_search_forums', 20),
(574, 'block/section_links:addinstance', 'write', 80, 'block_section_links', 20),
(575, 'block/selfcompletion:addinstance', 'write', 80, 'block_selfcompletion', 20),
(576, 'block/settings:myaddinstance', 'write', 10, 'block_settings', 0),
(577, 'block/settings:addinstance', 'write', 80, 'block_settings', 20),
(578, 'block/site_main_menu:addinstance', 'write', 80, 'block_site_main_menu', 20),
(579, 'block/social_activities:addinstance', 'write', 80, 'block_social_activities', 20),
(580, 'block/starredcourses:myaddinstance', 'write', 10, 'block_starredcourses', 0),
(581, 'block/tag_flickr:addinstance', 'write', 80, 'block_tag_flickr', 20),
(582, 'block/tag_youtube:addinstance', 'write', 80, 'block_tag_youtube', 20),
(583, 'block/tags:myaddinstance', 'write', 10, 'block_tags', 0),
(584, 'block/tags:addinstance', 'write', 80, 'block_tags', 20),
(585, 'block/timeline:myaddinstance', 'write', 10, 'block_timeline', 0),
(586, 'report/completion:view', 'read', 50, 'report_completion', 8),
(587, 'report/courseoverview:view', 'read', 10, 'report_courseoverview', 8),
(588, 'report/log:view', 'read', 50, 'report_log', 8),
(589, 'report/log:viewtoday', 'read', 50, 'report_log', 8),
(590, 'report/loglive:view', 'read', 50, 'report_loglive', 8),
(591, 'report/outline:view', 'read', 50, 'report_outline', 8),
(592, 'report/outline:viewuserreport', 'read', 50, 'report_outline', 8),
(593, 'report/participation:view', 'read', 50, 'report_participation', 8),
(594, 'report/performance:view', 'read', 10, 'report_performance', 2),
(595, 'report/progress:view', 'read', 50, 'report_progress', 8),
(596, 'report/questioninstances:view', 'read', 10, 'report_questioninstances', 0),
(597, 'report/security:view', 'read', 10, 'report_security', 2),
(598, 'report/stats:view', 'read', 50, 'report_stats', 8),
(599, 'report/status:view', 'read', 10, 'report_status', 2),
(600, 'report/usersessions:manageownsessions', 'write', 30, 'report_usersessions', 0),
(601, 'gradeexport/ods:view', 'read', 50, 'gradeexport_ods', 8),
(602, 'gradeexport/ods:publish', 'read', 50, 'gradeexport_ods', 8),
(603, 'gradeexport/txt:view', 'read', 50, 'gradeexport_txt', 8),
(604, 'gradeexport/txt:publish', 'read', 50, 'gradeexport_txt', 8),
(605, 'gradeexport/xls:view', 'read', 50, 'gradeexport_xls', 8),
(606, 'gradeexport/xls:publish', 'read', 50, 'gradeexport_xls', 8),
(607, 'gradeexport/xml:view', 'read', 50, 'gradeexport_xml', 8),
(608, 'gradeexport/xml:publish', 'read', 50, 'gradeexport_xml', 8),
(609, 'gradeimport/csv:view', 'write', 50, 'gradeimport_csv', 0),
(610, 'gradeimport/direct:view', 'write', 50, 'gradeimport_direct', 0),
(611, 'gradeimport/xml:view', 'write', 50, 'gradeimport_xml', 0),
(612, 'gradeimport/xml:publish', 'write', 50, 'gradeimport_xml', 0),
(613, 'gradereport/grader:view', 'read', 50, 'gradereport_grader', 8),
(614, 'gradereport/history:view', 'read', 50, 'gradereport_history', 8),
(615, 'gradereport/outcomes:view', 'read', 50, 'gradereport_outcomes', 8),
(616, 'gradereport/overview:view', 'read', 50, 'gradereport_overview', 8),
(617, 'gradereport/singleview:view', 'read', 50, 'gradereport_singleview', 8),
(618, 'gradereport/summary:view', 'read', 50, 'gradereport_summary', 8),
(619, 'gradereport/user:view', 'read', 50, 'gradereport_user', 8),
(620, 'webservice/rest:use', 'read', 50, 'webservice_rest', 0),
(621, 'webservice/soap:use', 'read', 50, 'webservice_soap', 0),
(622, 'repository/areafiles:view', 'read', 70, 'repository_areafiles', 0),
(623, 'repository/contentbank:view', 'read', 70, 'repository_contentbank', 0),
(624, 'repository/contentbank:accesscoursecontent', 'read', 50, 'repository_contentbank', 0),
(625, 'repository/contentbank:accesscoursecategorycontent', 'read', 40, 'repository_contentbank', 0),
(626, 'repository/contentbank:accessgeneralcontent', 'read', 40, 'repository_contentbank', 0),
(627, 'repository/coursefiles:view', 'read', 70, 'repository_coursefiles', 0),
(628, 'repository/dropbox:view', 'read', 70, 'repository_dropbox', 0),
(629, 'repository/equella:view', 'read', 70, 'repository_equella', 0),
(630, 'repository/filesystem:view', 'read', 70, 'repository_filesystem', 0),
(631, 'repository/flickr:view', 'read', 70, 'repository_flickr', 0),
(632, 'repository/flickr_public:view', 'read', 70, 'repository_flickr_public', 0),
(633, 'repository/googledocs:view', 'read', 70, 'repository_googledocs', 0),
(634, 'repository/local:view', 'read', 70, 'repository_local', 0),
(635, 'repository/merlot:view', 'read', 70, 'repository_merlot', 0),
(636, 'repository/nextcloud:view', 'read', 70, 'repository_nextcloud', 0),
(637, 'repository/onedrive:view', 'read', 70, 'repository_onedrive', 0),
(638, 'repository/recent:view', 'read', 70, 'repository_recent', 0),
(639, 'repository/s3:view', 'read', 70, 'repository_s3', 0),
(640, 'repository/upload:view', 'read', 70, 'repository_upload', 0),
(641, 'repository/url:view', 'read', 70, 'repository_url', 0),
(642, 'repository/user:view', 'read', 70, 'repository_user', 0),
(643, 'repository/webdav:view', 'read', 70, 'repository_webdav', 0),
(644, 'repository/wikimedia:view', 'read', 70, 'repository_wikimedia', 0),
(645, 'repository/youtube:view', 'read', 70, 'repository_youtube', 0),
(646, 'moodle/question:commentmine', 'write', 50, 'qbank_comment', 0),
(647, 'moodle/question:commentall', 'write', 50, 'qbank_comment', 0),
(648, 'qbank/customfields:changelockedcustomfields', 'write', 50, 'qbank_customfields', 16),
(649, 'qbank/customfields:configurecustomfields', 'write', 10, 'qbank_customfields', 16),
(650, 'qbank/customfields:viewhiddencustomfields', 'read', 50, 'qbank_customfields', 0),
(651, 'tool/brickfield:viewcoursetools', 'read', 50, 'tool_brickfield', 8),
(652, 'tool/brickfield:viewsystemtools', 'read', 10, 'tool_brickfield', 2),
(653, 'tool/customlang:view', 'read', 10, 'tool_customlang', 2),
(654, 'tool/customlang:edit', 'write', 10, 'tool_customlang', 6),
(655, 'tool/customlang:export', 'read', 10, 'tool_customlang', 2),
(656, 'tool/dataprivacy:managedatarequests', 'write', 10, 'tool_dataprivacy', 60),
(657, 'tool/dataprivacy:requestdeleteforotheruser', 'write', 10, 'tool_dataprivacy', 60),
(658, 'tool/dataprivacy:managedataregistry', 'write', 10, 'tool_dataprivacy', 60),
(659, 'tool/dataprivacy:makedatarequestsforchildren', 'write', 30, 'tool_dataprivacy', 24),
(660, 'tool/dataprivacy:makedatadeletionrequestsforchildren', 'write', 30, 'tool_dataprivacy', 24),
(661, 'tool/dataprivacy:downloadownrequest', 'read', 30, 'tool_dataprivacy', 0),
(662, 'tool/dataprivacy:downloadallrequests', 'read', 30, 'tool_dataprivacy', 8),
(663, 'tool/dataprivacy:requestdelete', 'write', 30, 'tool_dataprivacy', 32),
(664, 'tool/lpmigrate:frameworksmigrate', 'write', 10, 'tool_lpmigrate', 0),
(665, 'tool/mfa:mfaaccess', 'write', 30, 'tool_mfa', 0),
(666, 'tool/monitor:subscribe', 'read', 50, 'tool_monitor', 8),
(667, 'tool/monitor:managerules', 'write', 50, 'tool_monitor', 4),
(668, 'tool/monitor:managetool', 'write', 10, 'tool_monitor', 4),
(669, 'tool/policy:accept', 'write', 10, 'tool_policy', 0),
(670, 'tool/policy:acceptbehalf', 'write', 30, 'tool_policy', 8),
(671, 'tool/policy:managedocs', 'write', 10, 'tool_policy', 0),
(672, 'tool/policy:viewacceptances', 'read', 10, 'tool_policy', 0),
(673, 'tool/recyclebin:deleteitems', 'write', 50, 'tool_recyclebin', 32),
(674, 'tool/recyclebin:restoreitems', 'write', 50, 'tool_recyclebin', 0),
(675, 'tool/recyclebin:viewitems', 'read', 50, 'tool_recyclebin', 0),
(676, 'tool/uploaduser:uploaduserpictures', 'write', 10, 'tool_uploaduser', 16),
(677, 'tool/usertours:managetours', 'write', 10, 'tool_usertours', 4),
(678, 'contenttype/h5p:access', 'read', 50, 'contenttype_h5p', 0),
(679, 'contenttype/h5p:upload', 'write', 50, 'contenttype_h5p', 16),
(680, 'contenttype/h5p:useeditor', 'write', 50, 'contenttype_h5p', 16),
(681, 'booktool/exportimscp:export', 'read', 70, 'booktool_exportimscp', 0),
(682, 'booktool/importhtml:import', 'write', 70, 'booktool_importhtml', 4),
(683, 'booktool/print:print', 'read', 70, 'booktool_print', 0),
(684, 'forumreport/summary:view', 'read', 70, 'forumreport_summary', 0),
(685, 'forumreport/summary:viewall', 'read', 70, 'forumreport_summary', 8),
(686, 'quiz/grading:viewstudentnames', 'read', 70, 'quiz_grading', 0),
(687, 'quiz/grading:viewidnumber', 'read', 70, 'quiz_grading', 0),
(688, 'quiz/statistics:view', 'read', 70, 'quiz_statistics', 0),
(689, 'quizaccess/seb:managetemplates', 'write', 10, 'quizaccess_seb', 0),
(690, 'quizaccess/seb:bypassseb', 'read', 70, 'quizaccess_seb', 0),
(691, 'quizaccess/seb:manage_seb_requiresafeexambrowser', 'write', 70, 'quizaccess_seb', 0),
(692, 'quizaccess/seb:manage_seb_templateid', 'read', 70, 'quizaccess_seb', 0),
(693, 'quizaccess/seb:manage_filemanager_sebconfigfile', 'write', 70, 'quizaccess_seb', 0),
(694, 'quizaccess/seb:manage_seb_showsebdownloadlink', 'write', 70, 'quizaccess_seb', 0),
(695, 'quizaccess/seb:manage_seb_allowedbrowserexamkeys', 'write', 70, 'quizaccess_seb', 0),
(696, 'quizaccess/seb:manage_seb_linkquitseb', 'write', 70, 'quizaccess_seb', 0),
(697, 'quizaccess/seb:manage_seb_userconfirmquit', 'write', 70, 'quizaccess_seb', 0),
(698, 'quizaccess/seb:manage_seb_allowuserquitseb', 'write', 70, 'quizaccess_seb', 0),
(699, 'quizaccess/seb:manage_seb_quitpassword', 'write', 70, 'quizaccess_seb', 0),
(700, 'quizaccess/seb:manage_seb_allowreloadinexam', 'write', 70, 'quizaccess_seb', 0),
(701, 'quizaccess/seb:manage_seb_showsebtaskbar', 'write', 70, 'quizaccess_seb', 0),
(702, 'quizaccess/seb:manage_seb_showreloadbutton', 'write', 70, 'quizaccess_seb', 0),
(703, 'quizaccess/seb:manage_seb_showtime', 'write', 70, 'quizaccess_seb', 0),
(704, 'quizaccess/seb:manage_seb_showkeyboardlayout', 'write', 70, 'quizaccess_seb', 0),
(705, 'quizaccess/seb:manage_seb_showwificontrol', 'write', 70, 'quizaccess_seb', 0),
(706, 'quizaccess/seb:manage_seb_enableaudiocontrol', 'write', 70, 'quizaccess_seb', 0),
(707, 'quizaccess/seb:manage_seb_muteonstartup', 'write', 70, 'quizaccess_seb', 0),
(708, 'quizaccess/seb:manage_seb_allowspellchecking', 'write', 70, 'quizaccess_seb', 0),
(709, 'quizaccess/seb:manage_seb_activateurlfiltering', 'write', 70, 'quizaccess_seb', 0),
(710, 'quizaccess/seb:manage_seb_filterembeddedcontent', 'write', 70, 'quizaccess_seb', 0),
(711, 'quizaccess/seb:manage_seb_expressionsallowed', 'write', 70, 'quizaccess_seb', 0),
(712, 'quizaccess/seb:manage_seb_regexallowed', 'write', 70, 'quizaccess_seb', 0),
(713, 'quizaccess/seb:manage_seb_expressionsblocked', 'write', 70, 'quizaccess_seb', 0),
(714, 'quizaccess/seb:manage_seb_regexblocked', 'write', 70, 'quizaccess_seb', 0),
(715, 'atto/h5p:addembed', 'write', 70, 'atto_h5p', 0),
(716, 'atto/recordrtc:recordaudio', 'write', 70, 'atto_recordrtc', 0),
(717, 'atto/recordrtc:recordvideo', 'write', 70, 'atto_recordrtc', 0),
(718, 'tiny/h5p:addembed', 'write', 70, 'tiny_h5p', 0),
(719, 'tiny/recordrtc:recordaudio', 'write', 70, 'tiny_recordrtc', 0),
(720, 'tiny/recordrtc:recordvideo', 'write', 70, 'tiny_recordrtc', 0),
(721, 'factor/capability:cannotpassfactor', 'read', 10, 'factor_capability', 0);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_chat`
--

CREATE TABLE `mdlxd_chat` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `keepdays` bigint NOT NULL DEFAULT '0',
  `studentlogs` smallint NOT NULL DEFAULT '0',
  `chattime` bigint NOT NULL DEFAULT '0',
  `schedule` smallint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_chat_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Each of these is a chat room';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_chat_messages`
--

CREATE TABLE `mdlxd_chat_messages` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `chatid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timestamp` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_chatmess_use_ix` (`userid`),
  KEY `mdlxd_chatmess_gro_ix` (`groupid`),
  KEY `mdlxd_chatmess_timcha_ix` (`timestamp`,`chatid`),
  KEY `mdlxd_chatmess_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stores all the actual chat messages';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_chat_messages_current`
--

CREATE TABLE `mdlxd_chat_messages_current` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `chatid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timestamp` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_chatmesscurr_use_ix` (`userid`),
  KEY `mdlxd_chatmesscurr_gro_ix` (`groupid`),
  KEY `mdlxd_chatmesscurr_timcha_ix` (`timestamp`,`chatid`),
  KEY `mdlxd_chatmesscurr_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stores current session';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_chat_users`
--

CREATE TABLE `mdlxd_chat_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `chatid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `version` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `firstping` bigint NOT NULL DEFAULT '0',
  `lastping` bigint NOT NULL DEFAULT '0',
  `lastmessageping` bigint NOT NULL DEFAULT '0',
  `sid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `course` bigint NOT NULL DEFAULT '0',
  `lang` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdlxd_chatuser_use_ix` (`userid`),
  KEY `mdlxd_chatuser_las_ix` (`lastping`),
  KEY `mdlxd_chatuser_gro_ix` (`groupid`),
  KEY `mdlxd_chatuser_cha_ix` (`chatid`),
  KEY `mdlxd_chatuser_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Keeps track of which users are in which chat rooms';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_choice`
--

CREATE TABLE `mdlxd_choice` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `publish` tinyint NOT NULL DEFAULT '0',
  `showresults` tinyint NOT NULL DEFAULT '0',
  `display` smallint NOT NULL DEFAULT '0',
  `allowupdate` tinyint NOT NULL DEFAULT '0',
  `allowmultiple` tinyint NOT NULL DEFAULT '0',
  `showunanswered` tinyint NOT NULL DEFAULT '0',
  `includeinactive` tinyint NOT NULL DEFAULT '1',
  `limitanswers` tinyint NOT NULL DEFAULT '0',
  `timeopen` bigint NOT NULL DEFAULT '0',
  `timeclose` bigint NOT NULL DEFAULT '0',
  `showpreview` tinyint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  `showavailable` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_choi_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Available choices are stored here';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_choice_answers`
--

CREATE TABLE `mdlxd_choice_answers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `choiceid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `optionid` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_choiansw_use_ix` (`userid`),
  KEY `mdlxd_choiansw_cho_ix` (`choiceid`),
  KEY `mdlxd_choiansw_opt_ix` (`optionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='choices performed by users';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_choice_options`
--

CREATE TABLE `mdlxd_choice_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `choiceid` bigint NOT NULL DEFAULT '0',
  `text` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `maxanswers` bigint DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_choiopti_cho_ix` (`choiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='available options to choice';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_cohort`
--

CREATE TABLE `mdlxd_cohort` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `name` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `descriptionformat` tinyint NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `theme` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_coho_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Each record represents one cohort (aka site-wide group).';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_cohort_members`
--

CREATE TABLE `mdlxd_cohort_members` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `cohortid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timeadded` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_cohomemb_cohuse_uix` (`cohortid`,`userid`),
  KEY `mdlxd_cohomemb_coh_ix` (`cohortid`),
  KEY `mdlxd_cohomemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Link a user to a cohort.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_comments`
--

CREATE TABLE `mdlxd_comments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `component` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `commentarea` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `format` tinyint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_comm_concomite_ix` (`contextid`,`commentarea`,`itemid`),
  KEY `mdlxd_comm_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='moodle comments module';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_communication`
--

CREATE TABLE `mdlxd_communication` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint NOT NULL,
  `instanceid` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `instancetype` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `provider` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `roomname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `avatarfilename` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `avatarsynced` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_comm_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Communication records';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_communication_customlink`
--

CREATE TABLE `mdlxd_communication_customlink` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `commid` bigint NOT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_commcust_com_ix` (`commid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the link associated with a custom link communication ';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_communication_user`
--

CREATE TABLE `mdlxd_communication_user` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `commid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `synced` tinyint(1) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_commuser_com_ix` (`commid`),
  KEY `mdlxd_commuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Communication user records mapping';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency`
--

CREATE TABLE `mdlxd_competency` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `idnumber` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `competencyframeworkid` bigint NOT NULL,
  `parentid` bigint NOT NULL DEFAULT '0',
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `sortorder` bigint NOT NULL,
  `ruletype` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ruleoutcome` tinyint NOT NULL DEFAULT '0',
  `ruleconfig` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `scaleid` bigint DEFAULT NULL,
  `scaleconfiguration` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_comp_comidn_uix` (`competencyframeworkid`,`idnumber`),
  KEY `mdlxd_comp_rul_ix` (`ruleoutcome`),
  KEY `mdlxd_comp_sca_ix` (`scaleid`),
  KEY `mdlxd_comp_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='This table contains the master record of each competency in ';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_coursecomp`
--

CREATE TABLE `mdlxd_competency_coursecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `ruleoutcome` tinyint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `sortorder` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_compcour_coucom_uix` (`courseid`,`competencyid`),
  KEY `mdlxd_compcour_courul_ix` (`courseid`,`ruleoutcome`),
  KEY `mdlxd_compcour_cou2_ix` (`courseid`),
  KEY `mdlxd_compcour_com_ix` (`competencyid`),
  KEY `mdlxd_compcour_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a course.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_coursecompsetting`
--

CREATE TABLE `mdlxd_competency_coursecompsetting` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `pushratingstouserplans` tinyint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_compcour_cou_uix` (`courseid`),
  KEY `mdlxd_compcour_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='This table contains the course specific settings for compete';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_evidence`
--

CREATE TABLE `mdlxd_competency_evidence` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `usercompetencyid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `action` tinyint NOT NULL,
  `actionuserid` bigint DEFAULT NULL,
  `descidentifier` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `desccomponent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `desca` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `note` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_compevid_use_ix` (`usercompetencyid`),
  KEY `mdlxd_compevid_con_ix` (`contextid`),
  KEY `mdlxd_compevid_act_ix` (`actionuserid`),
  KEY `mdlxd_compevid_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='The evidence linked to a user competency';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_framework`
--

CREATE TABLE `mdlxd_competency_framework` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contextid` bigint NOT NULL,
  `idnumber` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `scaleid` bigint DEFAULT NULL,
  `scaleconfiguration` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `visible` tinyint NOT NULL DEFAULT '1',
  `taxonomies` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_compfram_idn_uix` (`idnumber`),
  KEY `mdlxd_compfram_con_ix` (`contextid`),
  KEY `mdlxd_compfram_sca_ix` (`scaleid`),
  KEY `mdlxd_compfram_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='List of competency frameworks.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_modulecomp`
--

CREATE TABLE `mdlxd_competency_modulecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `cmid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `sortorder` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `ruleoutcome` tinyint NOT NULL,
  `overridegrade` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_compmodu_cmicom_uix` (`cmid`,`competencyid`),
  KEY `mdlxd_compmodu_cmirul_ix` (`cmid`,`ruleoutcome`),
  KEY `mdlxd_compmodu_cmi_ix` (`cmid`),
  KEY `mdlxd_compmodu_com_ix` (`competencyid`),
  KEY `mdlxd_compmodu_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a module.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_plan`
--

CREATE TABLE `mdlxd_competency_plan` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL,
  `templateid` bigint DEFAULT NULL,
  `origtemplateid` bigint DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `duedate` bigint DEFAULT '0',
  `reviewerid` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL DEFAULT '0',
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_compplan_usesta_ix` (`userid`,`status`),
  KEY `mdlxd_compplan_tem_ix` (`templateid`),
  KEY `mdlxd_compplan_stadue_ix` (`status`,`duedate`),
  KEY `mdlxd_compplan_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Learning plans';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_plancomp`
--

CREATE TABLE `mdlxd_competency_plancomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `planid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `sortorder` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_compplan_placom_uix` (`planid`,`competencyid`),
  KEY `mdlxd_compplan_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Plan competencies';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_relatedcomp`
--

CREATE TABLE `mdlxd_competency_relatedcomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `competencyid` bigint NOT NULL,
  `relatedcompetencyid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_comprela_com_ix` (`competencyid`),
  KEY `mdlxd_comprela_rel_ix` (`relatedcompetencyid`),
  KEY `mdlxd_comprela_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Related competencies';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_template`
--

CREATE TABLE `mdlxd_competency_template` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contextid` bigint NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `descriptionformat` smallint NOT NULL DEFAULT '0',
  `visible` tinyint NOT NULL DEFAULT '1',
  `duedate` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_comptemp_con_ix` (`contextid`),
  KEY `mdlxd_comptemp_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Learning plan templates.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_templatecohort`
--

CREATE TABLE `mdlxd_competency_templatecohort` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `templateid` bigint NOT NULL,
  `cohortid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_comptemp_temcoh_uix` (`templateid`,`cohortid`),
  KEY `mdlxd_comptemp_tem2_ix` (`templateid`),
  KEY `mdlxd_comptemp_use3_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Default comment for the table, please edit me';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_templatecomp`
--

CREATE TABLE `mdlxd_competency_templatecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `templateid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  `sortorder` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_comptemp_tem_ix` (`templateid`),
  KEY `mdlxd_comptemp_com_ix` (`competencyid`),
  KEY `mdlxd_comptemp_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a learning plan template.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_usercomp`
--

CREATE TABLE `mdlxd_competency_usercomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `status` tinyint NOT NULL DEFAULT '0',
  `reviewerid` bigint DEFAULT NULL,
  `proficiency` tinyint DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_compuser_usecom_uix` (`userid`,`competencyid`),
  KEY `mdlxd_compuser_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_usercompcourse`
--

CREATE TABLE `mdlxd_competency_usercompcourse` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `courseid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `proficiency` tinyint DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_compuser_usecoucom_uix` (`userid`,`courseid`,`competencyid`),
  KEY `mdlxd_compuser_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies in a course';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_usercompplan`
--

CREATE TABLE `mdlxd_competency_usercompplan` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `planid` bigint NOT NULL,
  `proficiency` tinyint DEFAULT NULL,
  `grade` bigint DEFAULT NULL,
  `sortorder` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_compuser_usecompla_uix` (`userid`,`competencyid`,`planid`),
  KEY `mdlxd_compuser_use3_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies plans';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_userevidence`
--

CREATE TABLE `mdlxd_competency_userevidence` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `descriptionformat` tinyint(1) NOT NULL,
  `url` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_compuser_use4_ix` (`userid`),
  KEY `mdlxd_compuser_use5_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='The evidence of prior learning';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_competency_userevidencecomp`
--

CREATE TABLE `mdlxd_competency_userevidencecomp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userevidenceid` bigint NOT NULL,
  `competencyid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `usermodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_compuser_usecom2_uix` (`userevidenceid`,`competencyid`),
  KEY `mdlxd_compuser_use6_ix` (`userevidenceid`),
  KEY `mdlxd_compuser_use7_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Relationship between user evidence and competencies';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_config`
--

CREATE TABLE `mdlxd_config` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_conf_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Moodle configuration variables';

--
-- Dumping data for table `mdlxd_config`
--

INSERT INTO `mdlxd_config` VALUES
(2, 'rolesactive', '1'),
(3, 'auth', 'email'),
(4, 'enrol_plugins_enabled', 'manual,guest,self,cohort'),
(5, 'theme', 'academi'),
(6, 'filter_multilang_converted', '1'),
(7, 'siteidentifier', 'uhbiazkzi5wy4wgfsv7v2tf8lfq2suoxastitt.tech'),
(8, 'backup_version', '2023100900'),
(9, 'backup_release', '4.3'),
(10, 'mnet_dispatcher_mode', 'off'),
(11, 'sessiontimeout', '28800'),
(12, 'stringfilters', ''),
(13, 'filterall', '0'),
(14, 'texteditors', 'tiny,atto,tinymce,textarea'),
(15, 'antiviruses', ''),
(16, 'media_plugins_sortorder', 'videojs,youtube'),
(17, 'upgrade_extracreditweightsstepignored', '1'),
(18, 'upgrade_calculatedgradeitemsignored', '1'),
(19, 'upgrade_letterboundarycourses', '1'),
(20, 'mnet_localhost_id', '1'),
(21, 'mnet_all_hosts_id', '2'),
(22, 'siteguest', '1'),
(23, 'siteadmins', '2'),
(24, 'themerev', '1699171880'),
(25, 'jsrev', '1699168705'),
(26, 'templaterev', '1699168705'),
(27, 'gdversion', '2'),
(28, 'licenses', 'unknown,allrightsreserved,public,cc-4.0,cc-nc-4.0,cc-nd-4.0,cc-nc-nd-4.0,cc-nc-sa-4.0,cc-sa-4.0'),
(29, 'sitedefaultlicense', 'unknown'),
(30, 'version', '2023100900'),
(31, 'enableuserfeedback', '0'),
(32, 'userfeedback_nextreminder', '1'),
(33, 'userfeedback_remindafter', '90'),
(34, 'enableoutcomes', '0'),
(35, 'usecomments', '1'),
(36, 'usetags', '1'),
(37, 'enablenotes', '1'),
(38, 'enableportfolios', '0'),
(39, 'enablewebservices', '0'),
(40, 'enablestats', '0'),
(41, 'enablerssfeeds', '0'),
(42, 'enableblogs', '1'),
(43, 'enablecompletion', '1'),
(44, 'enableavailability', '1'),
(45, 'enableplagiarism', '0'),
(46, 'enablebadges', '1'),
(47, 'enableglobalsearch', '0'),
(48, 'allowstealth', '0'),
(49, 'enableanalytics', '1'),
(50, 'messaging', '1'),
(51, 'enablecustomreports', '1'),
(52, 'allowemojipicker', '1'),
(53, 'userfiltersdefault', 'realname'),
(54, 'defaultpreference_maildisplay', '2'),
(55, 'defaultpreference_mailformat', '1'),
(56, 'defaultpreference_maildigest', '0'),
(57, 'defaultpreference_autosubscribe', '1'),
(58, 'defaultpreference_trackforums', '0'),
(59, 'defaultpreference_core_contentbank_visibility', '1'),
(60, 'enroladminnewcourse', '1'),
(61, 'autologinguests', '0'),
(62, 'hiddenuserfields', ''),
(63, 'showuseridentity', 'email'),
(64, 'fullnamedisplay', 'language'),
(65, 'alternativefullnameformat', 'language'),
(66, 'maxusersperpage', '100'),
(67, 'enablegravatar', '0'),
(68, 'gravatardefaulturl', 'mm'),
(69, 'agedigitalconsentverification', '0'),
(70, 'agedigitalconsentmap', '*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13'),
(71, 'sitepolicy', ''),
(72, 'sitepolicyguest', ''),
(73, 'downloadcoursecontentallowed', '0'),
(74, 'maxsizeperdownloadcoursefile', '52428800'),
(75, 'enablecourserequests', '1'),
(76, 'defaultrequestcategory', '2'),
(77, 'lockrequestcategory', '0'),
(78, 'courserequestnotify', ''),
(79, 'activitychoosertabmode', '3'),
(80, 'activitychooseractivefooter', 'tool_moodlenet'),
(81, 'enableasyncbackup', '0'),
(82, 'grade_profilereport', 'user'),
(83, 'grade_aggregationposition', '1'),
(84, 'grade_includescalesinaggregation', '1'),
(85, 'grade_hiddenasdate', '0'),
(86, 'gradepublishing', '0'),
(87, 'grade_export_exportfeedback', '0'),
(88, 'grade_export_displaytype', '1'),
(89, 'grade_export_decimalpoints', '2'),
(90, 'grade_export_userprofilefields', 'firstname,lastname,idnumber,institution,department,email'),
(91, 'grade_export_customprofilefields', ''),
(92, 'recovergradesdefault', '0'),
(93, 'gradeexport', ''),
(94, 'unlimitedgrades', '0'),
(95, 'grade_report_showmin', '1'),
(96, 'gradepointmax', '100'),
(97, 'gradepointdefault', '100'),
(98, 'grade_minmaxtouse', '1'),
(99, 'grade_mygrades_report', 'overview'),
(100, 'gradereport_mygradeurl', ''),
(101, 'grade_hideforcedsettings', '1'),
(102, 'grade_aggregation', '13'),
(103, 'grade_aggregation_flag', '0'),
(104, 'grade_aggregations_visible', '13'),
(105, 'grade_aggregateonlygraded', '1'),
(106, 'grade_aggregateonlygraded_flag', '2'),
(107, 'grade_aggregateoutcomes', '0'),
(108, 'grade_aggregateoutcomes_flag', '2'),
(109, 'grade_keephigh', '0'),
(110, 'grade_keephigh_flag', '3'),
(111, 'grade_droplow', '0'),
(112, 'grade_droplow_flag', '2'),
(113, 'grade_overridecat', '1'),
(114, 'grade_displaytype', '1'),
(115, 'grade_decimalpoints', '2'),
(116, 'grade_item_advanced', 'iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime'),
(117, 'grade_report_showonlyactiveenrol', '1'),
(118, 'grade_report_quickgrading', '1'),
(119, 'grade_report_meanselection', '1'),
(120, 'grade_report_showaverages', '1'),
(121, 'grade_report_showranges', '0'),
(122, 'grade_report_showuserimage', '1'),
(123, 'grade_report_shownumberofgrades', '0'),
(124, 'grade_report_averagesdisplaytype', 'inherit'),
(125, 'grade_report_rangesdisplaytype', 'inherit'),
(126, 'grade_report_averagesdecimalpoints', 'inherit'),
(127, 'grade_report_rangesdecimalpoints', 'inherit'),
(128, 'grade_report_historyperpage', '50'),
(129, 'grade_report_overview_showrank', '0'),
(130, 'grade_report_overview_showtotalsifcontainhidden', '0'),
(131, 'grade_report_user_showrank', '0'),
(132, 'grade_report_user_showpercentage', '1'),
(133, 'grade_report_user_showgrade', '1'),
(134, 'grade_report_user_showfeedback', '1'),
(135, 'grade_report_user_showrange', '1'),
(136, 'grade_report_user_showweight', '1'),
(137, 'grade_report_user_showaverage', '0'),
(138, 'grade_report_user_showlettergrade', '0'),
(139, 'grade_report_user_rangedecimals', '0'),
(140, 'grade_report_user_showhiddenitems', '1'),
(141, 'grade_report_user_showtotalsifcontainhidden', '0'),
(142, 'grade_report_user_showcontributiontocoursetotal', '1'),
(143, 'badges_defaultissuername', ''),
(144, 'badges_defaultissuercontact', ''),
(145, 'badges_badgesalt', 'badges1698644927'),
(146, 'badges_allowcoursebadges', '1'),
(147, 'badges_allowexternalbackpack', '1'),
(148, 'rememberuserlicensepref', '1'),
(150, 'forcetimezone', '99'),
(151, 'country', '0'),
(152, 'defaultcity', ''),
(153, 'geoip2file', '/home/gyasi/unilearn/geoip/GeoLite2-City.mmdb'),
(154, 'googlemapkey3', ''),
(155, 'allcountrycodes', ''),
(156, 'autolang', '1'),
(157, 'lang', 'en'),
(158, 'autolangusercreation', '1'),
(159, 'langmenu', '1'),
(160, 'langlist', ''),
(161, 'langrev', '1699168705'),
(162, 'langcache', '1'),
(163, 'langstringcache', '1'),
(164, 'locale', ''),
(165, 'latinexcelexport', '0'),
(166, 'enablepdfexportfont', '0'),
(167, 'messagingallusers', '0'),
(168, 'messagingdefaultpressenter', '1'),
(169, 'messagingdeletereadnotificationsdelay', '604800'),
(170, 'messagingdeleteallnotificationsdelay', '2620800'),
(171, 'messagingallowemailoverride', '0'),
(172, 'requiremodintro', '0'),
(174, 'authloginviaemail', '0'),
(175, 'allowaccountssameemail', '0'),
(176, 'authpreventaccountcreation', '0'),
(177, 'loginpageautofocus', '0'),
(178, 'guestloginbutton', '0'),
(179, 'limitconcurrentlogins', '0'),
(180, 'alternateloginurl', ''),
(181, 'forgottenpasswordurl', ''),
(182, 'auth_instructions', ''),
(183, 'allowemailaddresses', ''),
(184, 'denyemailaddresses', ''),
(185, 'verifychangedemail', '1'),
(186, 'enableloginrecaptcha', '0'),
(187, 'recaptchapublickey', ''),
(188, 'recaptchaprivatekey', ''),
(189, 'filteruploadedfiles', '0'),
(190, 'filtermatchoneperpage', '0'),
(191, 'filtermatchonepertext', '0'),
(192, 'filternavigationwithsystemcontext', '0'),
(193, 'media_default_width', '640'),
(194, 'media_default_height', '360'),
(195, 'portfolio_moderate_filesize_threshold', '1048576'),
(196, 'portfolio_high_filesize_threshold', '5242880'),
(197, 'portfolio_moderate_db_threshold', '20'),
(198, 'portfolio_high_db_threshold', '50'),
(199, 'repositorycacheexpire', '120'),
(200, 'repositorygetfiletimeout', '30'),
(201, 'repositorysyncfiletimeout', '1'),
(202, 'repositorysyncimagetimeout', '3'),
(203, 'repositoryallowexternallinks', '1'),
(204, 'legacyfilesinnewcourses', '0'),
(205, 'legacyfilesaddallowed', '1'),
(206, 'searchengine', 'simpledb'),
(207, 'searchindexwhendisabled', '0'),
(208, 'searchindextime', '600'),
(209, 'searchallavailablecourses', '0'),
(210, 'searchincludeallcourses', '0'),
(211, 'searchenablecategories', '0'),
(212, 'searchdefaultcategory', 'core-all'),
(213, 'searchhideallcategory', '0'),
(214, 'searchmaxtopresults', '3'),
(215, 'searchteacherroles', ''),
(216, 'searchenginequeryonly', ''),
(217, 'searchbannerenable', '0'),
(218, 'searchbanner', ''),
(219, 'allowbeforeblock', '0'),
(220, 'allowedip', ''),
(221, 'blockedip', ''),
(222, 'protectusernames', '1'),
(223, 'forcelogin', '0'),
(224, 'forceloginforprofiles', '1'),
(225, 'forceloginforprofileimage', '0'),
(226, 'opentowebcrawlers', '0'),
(227, 'allowindexing', '0'),
(228, 'maxbytes', '0'),
(229, 'userquota', '104857600'),
(230, 'allowobjectembed', '0'),
(231, 'enabletrusttext', '0'),
(232, 'maxeditingtime', '1800'),
(233, 'extendedusernamechars', '0'),
(234, 'keeptagnamecase', '1'),
(235, 'profilesforenrolledusersonly', '1'),
(236, 'cronclionly', '1'),
(237, 'cronremotepassword', ''),
(238, 'lockoutthreshold', '0'),
(239, 'lockoutwindow', '1800'),
(240, 'lockoutduration', '1800'),
(241, 'passwordpolicy', '1'),
(242, 'minpasswordlength', '8'),
(243, 'minpassworddigits', '1'),
(244, 'minpasswordlower', '1'),
(245, 'minpasswordupper', '1'),
(246, 'minpasswordnonalphanum', '1'),
(247, 'maxconsecutiveidentchars', '0'),
(248, 'passwordpolicycheckonlogin', '0'),
(249, 'passwordreuselimit', '0'),
(250, 'pwresettime', '1800'),
(251, 'passwordchangelogout', '0'),
(252, 'passwordchangetokendeletion', '0'),
(253, 'tokenduration', '7257600'),
(254, 'groupenrolmentkeypolicy', '1'),
(255, 'disableuserimages', '0'),
(256, 'emailchangeconfirmation', '1'),
(257, 'rememberusername', '2'),
(258, 'strictformsrequired', '0'),
(259, 'cookiesecure', '1'),
(260, 'allowframembedding', '0'),
(261, 'curlsecurityblockedhosts', '127.0.0.0/8\n192.168.0.0/16\n10.0.0.0/8\n172.16.0.0/12\n0.0.0.0\nlocalhost\n169.254.169.254\n0000::1'),
(262, 'curlsecurityallowedport', '443\n80'),
(263, 'referrerpolicy', 'default'),
(264, 'displayloginfailures', '0'),
(265, 'notifyloginfailures', ''),
(266, 'notifyloginthreshold', '10'),
(267, 'themelist', ''),
(268, 'themedesignermode', '0'),
(269, 'allowuserthemes', '0'),
(270, 'allowcoursethemes', '0'),
(271, 'allowcategorythemes', '0'),
(272, 'allowcohortthemes', '0'),
(273, 'allowthemechangeonurl', '0'),
(274, 'allowuserblockhiding', '1'),
(275, 'langmenuinsecurelayout', '0'),
(276, 'logininfoinsecurelayout', '0'),
(277, 'custommenuitems', ''),
(278, 'customusermenuitems', 'profile,moodle|/user/profile.php\ngrades,grades|/grade/report/mygrades.php\ncalendar,core_calendar|/calendar/view.php?view=month\nprivatefiles,moodle|/user/files.php\nreports,core_reportbuilder|/reportbuilder/index.php'),
(279, 'calendartype', 'gregorian'),
(280, 'calendar_adminseesall', '0'),
(281, 'calendar_site_timeformat', '0'),
(282, 'calendar_startwday', '1'),
(283, 'calendar_weekend', '65'),
(284, 'calendar_lookahead', '21'),
(285, 'calendar_maxevents', '10'),
(286, 'enablecalendarexport', '1'),
(287, 'calendar_customexport', '1'),
(288, 'calendar_exportlookahead', '365'),
(289, 'calendar_exportlookback', '5'),
(290, 'calendar_exportsalt', 'vlanypzhixnivpeg2jex32mlhfekyecl5yluqs8g65etbsnmp4ock4sfvjus'),
(291, 'calendar_showicalsource', '1'),
(292, 'useblogassociations', '1'),
(293, 'bloglevel', '4'),
(294, 'useexternalblogs', '1'),
(295, 'externalblogcrontime', '86400'),
(296, 'maxexternalblogsperuser', '1'),
(297, 'blogusecomments', '1'),
(298, 'blogshowcommentscount', '1'),
(299, 'enabledashboard', '1'),
(300, 'defaulthomepage', '3'),
(301, 'navshowfullcoursenames', '1'),
(302, 'navshowcategories', '1'),
(303, 'navshowmycoursecategories', '0'),
(304, 'navshowallcourses', '0'),
(305, 'navsortmycoursessort', 'sortorder'),
(306, 'navsortmycourseshiddenlast', '1'),
(307, 'navcourselimit', '10'),
(308, 'usesitenameforsitepages', '0'),
(309, 'linkadmincategories', '1'),
(310, 'linkcoursesections', '1'),
(311, 'navshowfrontpagemods', '1'),
(312, 'navadduserpostslinks', '1'),
(313, 'sitenameintitle', 'shortname'),
(314, 'formatstringstriptags', '1'),
(315, 'emoticons', '[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]'),
(316, 'docroot', 'https://docs.moodle.org'),
(317, 'doclang', ''),
(318, 'doctonewwindow', '0'),
(319, 'coursecreationguide', 'https://moodle.academy/coursequickstart'),
(320, 'coursecontactduplicates', '0'),
(321, 'courselistshortnames', '0'),
(322, 'coursesperpage', '20'),
(323, 'courseswithsummarieslimit', '10'),
(324, 'courseoverviewfileslimit', '1'),
(325, 'courseoverviewfilesext', 'web_image'),
(326, 'coursegraceperiodbefore', '0'),
(327, 'coursegraceperiodafter', '0'),
(328, 'yuicomboloading', '1'),
(329, 'cachejs', '1'),
(330, 'additionalhtmlhead', ''),
(331, 'additionalhtmltopofbody', ''),
(332, 'additionalhtmlfooter', ''),
(333, 'cachetemplates', '1'),
(334, 'pathtophp', ''),
(335, 'pathtodu', ''),
(336, 'aspellpath', ''),
(337, 'pathtodot', ''),
(338, 'pathtogs', '/usr/bin/gs'),
(339, 'pathtopdftoppm', ''),
(340, 'pathtopython', ''),
(341, 'supportname', 'Admin User'),
(342, 'supportpage', ''),
(343, 'supportavailability', '1'),
(344, 'servicespage', ''),
(345, 'dbsessions', '0'),
(346, 'sessiontimeoutwarning', '1200'),
(347, 'sessioncookie', ''),
(348, 'sessioncookiepath', ''),
(349, 'sessioncookiedomain', ''),
(350, 'statsfirstrun', 'none'),
(351, 'statsmaxruntime', '0'),
(352, 'statsruntimedays', '31'),
(353, 'statsuserthreshold', '0'),
(354, 'slasharguments', '1'),
(355, 'getremoteaddrconf', '3'),
(356, 'reverseproxyignore', ''),
(357, 'proxyhost', ''),
(358, 'proxyport', '0'),
(359, 'proxytype', 'HTTP'),
(360, 'proxyuser', ''),
(361, 'proxypassword', ''),
(362, 'proxybypass', 'localhost, 127.0.0.1'),
(363, 'proxylogunsafe', '0'),
(364, 'proxyfixunsafe', '0'),
(365, 'maintenance_enabled', '0'),
(366, 'maintenance_message', ''),
(367, 'deleteunconfirmed', '168'),
(368, 'deleteincompleteusers', '0'),
(369, 'disablegradehistory', '0'),
(370, 'gradehistorylifetime', '0'),
(371, 'tempdatafoldercleanup', '168'),
(372, 'xapicleanupperiod', '4838400'),
(373, 'filescleanupperiod', '86400'),
(374, 'extramemorylimit', '512M'),
(375, 'maxtimelimit', '0'),
(376, 'curlcache', '120'),
(377, 'curltimeoutkbitrate', '56'),
(378, 'cron_enabled', '1'),
(379, 'cron_keepalive', '180'),
(380, 'task_scheduled_concurrency_limit', '3'),
(381, 'task_scheduled_max_runtime', '1800'),
(382, 'task_adhoc_concurrency_limit', '3'),
(383, 'task_adhoc_max_runtime', '1800'),
(384, 'task_logmode', '1'),
(385, 'task_logtostdout', '1'),
(386, 'task_logretention', '2419200'),
(387, 'task_logretainruns', '20'),
(388, 'smtphosts', ''),
(389, 'smtpsecure', ''),
(390, 'smtpauthtype', 'LOGIN'),
(391, 'smtpuser', ''),
(392, 'smtppass', ''),
(393, 'smtpmaxbulk', '1'),
(394, 'noreplyaddress', 'ftech868@gmail.com'),
(395, 'allowedemaildomains', ''),
(396, 'divertallemailsto', ''),
(397, 'divertallemailsexcept', ''),
(398, 'emaildkimselector', ''),
(399, 'sitemailcharset', '0'),
(400, 'allowusermailcharset', '0'),
(401, 'allowattachments', '1'),
(402, 'mailnewline', 'LF'),
(403, 'emailfromvia', '1'),
(404, 'emailsubjectprefix', ''),
(405, 'emailheaders', ''),
(406, 'updateautocheck', '1'),
(407, 'updateminmaturity', '200'),
(408, 'updatenotifybuilds', '0'),
(409, 'enablewsdocumentation', '0'),
(410, 'customreportslimit', '0'),
(411, 'customreportsliveediting', '1'),
(412, 'dndallowtextandlinks', '0'),
(413, 'pathtosassc', ''),
(414, 'contextlocking', '0'),
(415, 'contextlockappliestoadmin', '1'),
(416, 'forceclean', '0'),
(417, 'enablecourserelativedates', '0'),
(418, 'enablesharingtomoodlenet', '0'),
(419, 'enablecommunicationsubsystem', '0'),
(420, 'debug', '0'),
(421, 'debugdisplay', '0'),
(422, 'perfdebug', '7'),
(423, 'debugstringids', '0'),
(424, 'debugsqltrace', '0'),
(425, 'debugvalidators', '0'),
(426, 'debugpageinfo', '0'),
(427, 'debugtemplateinfo', '0'),
(428, 'profilingenabled', '0'),
(429, 'profilingincluded', ''),
(430, 'profilingexcluded', ''),
(431, 'profilingautofrec', '0'),
(432, 'profilingallowme', '0'),
(433, 'profilingallowall', '0'),
(434, 'profilingslow', '0'),
(435, 'profilinglifetime', '1440'),
(436, 'profilingimportprefix', '(I)'),
(437, 'allowguestmymoodle', '1'),
(438, 'release', '4.3 (Build: 20231009)'),
(439, 'localcachedirpurged', '1699168705'),
(440, 'scheduledtaskreset', '1699168705'),
(441, 'paygw_plugins_sortorder', 'paypal'),
(442, 'allversionshash', '57d4a3021d211fc6812e0e08bc2d4ac5ab38c5b9'),
(443, 'allcomponenthash', '170553ea80e49e31019da788991bf6c7cc10e110'),
(445, 'registrationpending', '0'),
(446, 'branch', '403'),
(447, 'enableaccessibilitytools', '1'),
(448, 'notloggedinroleid', '6'),
(449, 'guestroleid', '6'),
(450, 'defaultuserroleid', '7'),
(451, 'creatornewroleid', '3'),
(452, 'restorernewroleid', '3'),
(453, 'sitepolicyhandler', ''),
(454, 'gradebookroles', '5'),
(455, 'h5plibraryhandler', 'h5plib_v124'),
(456, 'airnotifierurl', 'https://messages.moodle.net'),
(457, 'airnotifierport', '443'),
(458, 'airnotifiermobileappname', 'com.moodle.moodlemobile'),
(459, 'airnotifierappname', 'commoodlemoodlemobile'),
(460, 'airnotifieraccesskey', ''),
(461, 'bigbluebuttonbn_default_dpa_accepted', '0'),
(462, 'bigbluebuttonbn_server_url', 'https://test-moodle.blindsidenetworks.com/bigbluebutton/'),
(463, 'bigbluebuttonbn_shared_secret', 'gsw2vs5aw32umvjm4utt4afndfafrgs3'),
(464, 'bigbluebuttonbn_checksum_algorithm', 'SHA1'),
(465, 'bigbluebuttonbn_poll_interval', '5'),
(466, 'bigbluebuttonbn_welcome_default', ''),
(467, 'bigbluebuttonbn_welcome_editable', '1'),
(468, 'bigbluebuttonbn_recording_default', '1'),
(469, 'bigbluebuttonbn_recording_refresh_period', '300'),
(470, 'bigbluebuttonbn_recording_editable', '1'),
(471, 'bigbluebuttonbn_recording_all_from_start_default', '0'),
(472, 'bigbluebuttonbn_recording_all_from_start_editable', '0'),
(473, 'bigbluebuttonbn_recording_hide_button_default', '0'),
(474, 'bigbluebuttonbn_recording_hide_button_editable', '0'),
(475, 'bigbluebuttonbn_recording_safe_formats', 'video,presentation'),
(476, 'bigbluebuttonbn_importrecordings_enabled', '0'),
(477, 'bigbluebuttonbn_importrecordings_from_deleted_enabled', '0'),
(478, 'bigbluebuttonbn_recordings_deleted_default', '1'),
(479, 'bigbluebuttonbn_recordings_deleted_editable', '0'),
(480, 'bigbluebuttonbn_recordings_imported_default', '0'),
(481, 'bigbluebuttonbn_recordings_imported_editable', '1'),
(482, 'bigbluebuttonbn_recordings_preview_default', '1'),
(483, 'bigbluebuttonbn_recordings_preview_editable', '0'),
(484, 'bigbluebuttonbn_recordings_asc_sort', '0'),
(485, 'bigbluebuttonbn_recording_protect_editable', '1'),
(486, 'bigbluebuttonbn_waitformoderator_default', '0'),
(487, 'bigbluebuttonbn_waitformoderator_editable', '1'),
(488, 'bigbluebuttonbn_waitformoderator_ping_interval', '10'),
(489, 'bigbluebuttonbn_waitformoderator_cache_ttl', '60'),
(490, 'bigbluebuttonbn_voicebridge_editable', '0'),
(491, 'bigbluebuttonbn_preuploadpresentation_editable', '0'),
(492, 'bigbluebuttonbn_userlimit_default', '0'),
(493, 'bigbluebuttonbn_userlimit_editable', '0'),
(494, 'bigbluebuttonbn_participant_moderator_default', '0'),
(495, 'bigbluebuttonbn_muteonstart_default', '0'),
(496, 'bigbluebuttonbn_muteonstart_editable', '0'),
(497, 'bigbluebuttonbn_disablecam_default', '0'),
(498, 'bigbluebuttonbn_disablecam_editable', '1'),
(499, 'bigbluebuttonbn_disablemic_default', '0'),
(500, 'bigbluebuttonbn_disablemic_editable', '1'),
(501, 'bigbluebuttonbn_disableprivatechat_default', '0'),
(502, 'bigbluebuttonbn_disableprivatechat_editable', '1'),
(503, 'bigbluebuttonbn_disablepublicchat_default', '0'),
(504, 'bigbluebuttonbn_disablepublicchat_editable', '1'),
(505, 'bigbluebuttonbn_disablenote_default', '0'),
(506, 'bigbluebuttonbn_disablenote_editable', '1'),
(507, 'bigbluebuttonbn_hideuserlist_default', '0'),
(508, 'bigbluebuttonbn_hideuserlist_editable', '1'),
(509, 'bigbluebuttonbn_recordingready_enabled', '0'),
(510, 'bigbluebuttonbn_profile_picture_enabled', '0'),
(511, 'bigbluebuttonbn_meetingevents_enabled', '0'),
(512, 'bigbluebuttonbn_guestaccess_enabled', '0'),
(513, 'chat_method', 'ajax'),
(514, 'chat_refresh_userlist', '10'),
(515, 'chat_old_ping', '35'),
(516, 'chat_refresh_room', '5'),
(517, 'chat_normal_updatemode', 'jsupdate'),
(518, 'chat_serverhost', 'astitt.tech'),
(519, 'chat_serverip', '127.0.0.1'),
(520, 'chat_serverport', '9111'),
(521, 'chat_servermax', '100'),
(522, 'data_enablerssfeeds', '0'),
(523, 'feedback_allowfullanonymous', '0'),
(524, 'forum_displaymode', '3'),
(525, 'forum_shortpost', '300'),
(526, 'forum_longpost', '600'),
(527, 'forum_manydiscussions', '100'),
(528, 'forum_maxbytes', '512000'),
(529, 'forum_maxattachments', '9'),
(530, 'forum_subscription', '0'),
(531, 'forum_trackingtype', '1'),
(532, 'forum_trackreadposts', '1'),
(533, 'forum_allowforcedreadtracking', '0'),
(534, 'forum_oldpostdays', '14'),
(535, 'forum_usermarksread', '0'),
(536, 'forum_cleanreadtime', '2'),
(537, 'digestmailtime', '17'),
(538, 'forum_enablerssfeeds', '0'),
(539, 'forum_enabletimedposts', '1'),
(540, 'glossary_entbypage', '10'),
(541, 'glossary_dupentries', '0'),
(542, 'glossary_allowcomments', '0'),
(543, 'glossary_linkbydefault', '1'),
(544, 'glossary_defaultapproval', '1'),
(545, 'glossary_enablerssfeeds', '0'),
(546, 'glossary_linkentries', '0'),
(547, 'glossary_casesensitive', '0'),
(548, 'glossary_fullmatch', '0'),
(549, 'block_course_list_adminview', 'all'),
(550, 'block_course_list_hideallcourseslink', '0'),
(551, 'block_online_users_timetosee', '5'),
(552, 'block_online_users_onlinestatushiding', '1'),
(553, 'block_rss_client_num_entries', '5'),
(554, 'block_rss_client_timeout', '30'),
(555, 'block_html_allowcssclasses', '0'),
(556, 'pathtounoconv', '/usr/bin/unoconv'),
(557, 'filter_multilang_force_old', '0'),
(558, 'profileroles', '5,4,3'),
(559, 'coursecontact', '3'),
(560, 'frontpage', '6'),
(561, 'frontpageloggedin', '6'),
(562, 'maxcategorydepth', '2'),
(563, 'frontpagecourselimit', '200'),
(564, 'commentsperpage', '15'),
(565, 'defaultfrontpageroleid', '8'),
(566, 'messageinbound_enabled', '0'),
(567, 'messageinbound_mailbox', ''),
(568, 'messageinbound_domain', ''),
(569, 'messageinbound_host', ''),
(570, 'messageinbound_hostssl', 'ssl'),
(571, 'messageinbound_hostuser', ''),
(572, 'messageinbound_hostpass', ''),
(573, 'mobilecssurl', ''),
(574, 'enablemobilewebservice', '0'),
(575, 'timezone', 'America/New_York'),
(576, 'registerauth', ''),
(577, 'supportemail', 'ftech868@gmail.com'),
(578, 'fileslastcleanup', '1699919701'),
(579, 'scorm_updatetimelast', '1699851601'),
(581, 'updatecronoffset', '8224'),
(583, 'reposecretkey', '1699168813xfGSQrkkcuVlef31yup9RB6lS6NrE8qc');

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_config_log`
--

CREATE TABLE `mdlxd_config_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `plugin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `oldvalue` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `mdlxd_conflog_tim_ix` (`timemodified`),
  KEY `mdlxd_conflog_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Changes done in server configuration through admin UI';

--
-- Dumping data for table `mdlxd_config_log`
--

INSERT INTO `mdlxd_config_log` VALUES
(1, 0, 1698644927, NULL, 'enableuserfeedback', '0', NULL),
(2, 0, 1698644927, NULL, 'userfeedback_nextreminder', '1', NULL),
(3, 0, 1698644927, NULL, 'userfeedback_remindafter', '90', NULL),
(4, 0, 1698644927, NULL, 'enableoutcomes', '0', NULL),
(5, 0, 1698644927, NULL, 'usecomments', '1', NULL),
(6, 0, 1698644927, NULL, 'usetags', '1', NULL),
(7, 0, 1698644927, NULL, 'enablenotes', '1', NULL),
(8, 0, 1698644927, NULL, 'enableportfolios', '0', NULL),
(9, 0, 1698644927, NULL, 'enablewebservices', '0', NULL),
(10, 0, 1698644927, NULL, 'enablestats', '0', NULL),
(11, 0, 1698644927, NULL, 'enablerssfeeds', '0', NULL),
(12, 0, 1698644927, NULL, 'enableblogs', '1', NULL),
(13, 0, 1698644927, NULL, 'enablecompletion', '1', NULL),
(14, 0, 1698644927, NULL, 'enableavailability', '1', NULL),
(15, 0, 1698644927, NULL, 'enableplagiarism', '0', NULL),
(16, 0, 1698644927, NULL, 'enablebadges', '1', NULL),
(17, 0, 1698644927, NULL, 'enableglobalsearch', '0', NULL),
(18, 0, 1698644927, NULL, 'allowstealth', '0', NULL),
(19, 0, 1698644927, NULL, 'enableanalytics', '1', NULL),
(20, 0, 1698644927, 'core_competency', 'enabled', '1', NULL),
(21, 0, 1698644927, NULL, 'messaging', '1', NULL),
(22, 0, 1698644927, NULL, 'enablecustomreports', '1', NULL),
(23, 0, 1698644927, NULL, 'allowemojipicker', '1', NULL),
(24, 0, 1698644927, NULL, 'userfiltersdefault', 'realname', NULL),
(25, 0, 1698644927, NULL, 'defaultpreference_maildisplay', '2', NULL),
(26, 0, 1698644927, NULL, 'defaultpreference_mailformat', '1', NULL),
(27, 0, 1698644927, NULL, 'defaultpreference_maildigest', '0', NULL),
(28, 0, 1698644927, NULL, 'defaultpreference_autosubscribe', '1', NULL),
(29, 0, 1698644927, NULL, 'defaultpreference_trackforums', '0', NULL),
(30, 0, 1698644927, NULL, 'defaultpreference_core_contentbank_visibility', '1', NULL),
(31, 0, 1698644927, NULL, 'enroladminnewcourse', '1', NULL),
(32, 0, 1698644927, NULL, 'autologinguests', '0', NULL),
(33, 0, 1698644927, NULL, 'hiddenuserfields', '', NULL),
(34, 0, 1698644927, NULL, 'showuseridentity', 'email', NULL),
(35, 0, 1698644927, NULL, 'fullnamedisplay', 'language', NULL),
(36, 0, 1698644927, NULL, 'alternativefullnameformat', 'language', NULL),
(37, 0, 1698644927, NULL, 'maxusersperpage', '100', NULL),
(38, 0, 1698644927, NULL, 'enablegravatar', '0', NULL),
(39, 0, 1698644927, NULL, 'gravatardefaulturl', 'mm', NULL),
(40, 0, 1698644927, NULL, 'agedigitalconsentverification', '0', NULL),
(41, 0, 1698644927, NULL, 'agedigitalconsentmap', '*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13', NULL),
(42, 0, 1698644927, NULL, 'sitepolicy', '', NULL),
(43, 0, 1698644927, NULL, 'sitepolicyguest', '', NULL),
(44, 0, 1698644927, NULL, 'downloadcoursecontentallowed', '0', NULL),
(45, 0, 1698644927, NULL, 'maxsizeperdownloadcoursefile', '52428800', NULL),
(46, 0, 1698644927, NULL, 'enablecourserequests', '1', NULL),
(47, 0, 1698644927, NULL, 'defaultrequestcategory', '1', NULL),
(48, 0, 1698644927, NULL, 'lockrequestcategory', '0', NULL),
(49, 0, 1698644927, NULL, 'courserequestnotify', '', NULL),
(50, 0, 1698644927, 'moodlecourse', 'visible', '1', NULL),
(51, 0, 1698644927, 'moodlecourse', 'downloadcontentsitedefault', '0', NULL),
(52, 0, 1698644927, 'moodlecourse', 'participantsperpage', '20', NULL),
(53, 0, 1698644927, 'moodlecourse', 'format', 'topics', NULL),
(54, 0, 1698644927, 'moodlecourse', 'maxsections', '52', NULL),
(55, 0, 1698644927, 'moodlecourse', 'numsections', '4', NULL),
(56, 0, 1698644927, 'moodlecourse', 'hiddensections', '1', NULL),
(57, 0, 1698644927, 'moodlecourse', 'coursedisplay', '0', NULL),
(58, 0, 1698644927, 'moodlecourse', 'courseenddateenabled', '1', NULL),
(59, 0, 1698644927, 'moodlecourse', 'courseduration', '31536000', NULL),
(60, 0, 1698644927, 'moodlecourse', 'lang', '', NULL),
(61, 0, 1698644927, 'moodlecourse', 'newsitems', '5', NULL),
(62, 0, 1698644927, 'moodlecourse', 'showgrades', '1', NULL),
(63, 0, 1698644927, 'moodlecourse', 'showreports', '0', NULL),
(64, 0, 1698644927, 'moodlecourse', 'showactivitydates', '1', NULL),
(65, 0, 1698644927, 'moodlecourse', 'maxbytes', '0', NULL),
(66, 0, 1698644927, 'moodlecourse', 'enablecompletion', '1', NULL),
(67, 0, 1698644927, 'moodlecourse', 'showcompletionconditions', '1', NULL),
(68, 0, 1698644927, 'moodlecourse', 'groupmode', '0', NULL),
(69, 0, 1698644927, 'moodlecourse', 'groupmodeforce', '0', NULL),
(70, 0, 1698644927, 'moodlecourse', 'coursecommunicationprovider', 'none', NULL),
(71, 0, 1698644927, NULL, 'activitychoosertabmode', '3', NULL),
(72, 0, 1698644927, NULL, 'activitychooseractivefooter', 'hidden', NULL),
(73, 0, 1698644927, 'backup', 'loglifetime', '30', NULL),
(74, 0, 1698644927, 'backup', 'backup_general_users', '1', NULL),
(75, 0, 1698644927, 'backup', 'backup_general_users_locked', '', NULL),
(76, 0, 1698644927, 'backup', 'backup_general_anonymize', '0', NULL),
(77, 0, 1698644927, 'backup', 'backup_general_anonymize_locked', '', NULL),
(78, 0, 1698644927, 'backup', 'backup_general_role_assignments', '1', NULL),
(79, 0, 1698644927, 'backup', 'backup_general_role_assignments_locked', '', NULL),
(80, 0, 1698644927, 'backup', 'backup_general_activities', '1', NULL),
(81, 0, 1698644927, 'backup', 'backup_general_activities_locked', '', NULL),
(82, 0, 1698644927, 'backup', 'backup_general_blocks', '1', NULL),
(83, 0, 1698644927, 'backup', 'backup_general_blocks_locked', '', NULL),
(84, 0, 1698644927, 'backup', 'backup_general_files', '1', NULL),
(85, 0, 1698644927, 'backup', 'backup_general_files_locked', '', NULL),
(86, 0, 1698644927, 'backup', 'backup_general_filters', '1', NULL),
(87, 0, 1698644927, 'backup', 'backup_general_filters_locked', '', NULL),
(88, 0, 1698644927, 'backup', 'backup_general_comments', '1', NULL),
(89, 0, 1698644927, 'backup', 'backup_general_comments_locked', '', NULL),
(90, 0, 1698644927, 'backup', 'backup_general_badges', '1', NULL),
(91, 0, 1698644927, 'backup', 'backup_general_badges_locked', '', NULL),
(92, 0, 1698644927, 'backup', 'backup_general_calendarevents', '1', NULL),
(93, 0, 1698644927, 'backup', 'backup_general_calendarevents_locked', '', NULL),
(94, 0, 1698644927, 'backup', 'backup_general_userscompletion', '1', NULL),
(95, 0, 1698644927, 'backup', 'backup_general_userscompletion_locked', '', NULL),
(96, 0, 1698644927, 'backup', 'backup_general_logs', '0', NULL),
(97, 0, 1698644927, 'backup', 'backup_general_logs_locked', '', NULL),
(98, 0, 1698644927, 'backup', 'backup_general_histories', '0', NULL),
(99, 0, 1698644927, 'backup', 'backup_general_histories_locked', '', NULL),
(100, 0, 1698644927, 'backup', 'backup_general_questionbank', '1', NULL),
(101, 0, 1698644927, 'backup', 'backup_general_questionbank_locked', '', NULL),
(102, 0, 1698644927, 'backup', 'backup_general_groups', '1', NULL),
(103, 0, 1698644927, 'backup', 'backup_general_groups_locked', '', NULL),
(104, 0, 1698644927, 'backup', 'backup_general_competencies', '1', NULL),
(105, 0, 1698644927, 'backup', 'backup_general_competencies_locked', '', NULL),
(106, 0, 1698644927, 'backup', 'backup_general_contentbankcontent', '1', NULL),
(107, 0, 1698644927, 'backup', 'backup_general_contentbankcontent_locked', '', NULL),
(108, 0, 1698644927, 'backup', 'backup_general_xapistate', '1', NULL),
(109, 0, 1698644927, 'backup', 'backup_general_xapistate_locked', '', NULL),
(110, 0, 1698644927, 'backup', 'backup_general_legacyfiles', '1', NULL),
(111, 0, 1698644927, 'backup', 'backup_general_legacyfiles_locked', '', NULL),
(112, 0, 1698644927, 'backup', 'import_general_maxresults', '10', NULL),
(113, 0, 1698644927, 'backup', 'import_general_duplicate_admin_allowed', '0', NULL),
(114, 0, 1698644927, 'backup', 'backup_import_permissions', '0', NULL),
(115, 0, 1698644927, 'backup', 'backup_import_permissions_locked', '', NULL),
(116, 0, 1698644927, 'backup', 'backup_import_activities', '1', NULL),
(117, 0, 1698644927, 'backup', 'backup_import_activities_locked', '', NULL),
(118, 0, 1698644927, 'backup', 'backup_import_blocks', '1', NULL),
(119, 0, 1698644927, 'backup', 'backup_import_blocks_locked', '', NULL),
(120, 0, 1698644927, 'backup', 'backup_import_filters', '1', NULL),
(121, 0, 1698644927, 'backup', 'backup_import_filters_locked', '', NULL),
(122, 0, 1698644927, 'backup', 'backup_import_calendarevents', '1', NULL),
(123, 0, 1698644927, 'backup', 'backup_import_calendarevents_locked', '', NULL),
(124, 0, 1698644927, 'backup', 'backup_import_questionbank', '1', NULL),
(125, 0, 1698644927, 'backup', 'backup_import_questionbank_locked', '', NULL),
(126, 0, 1698644927, 'backup', 'backup_import_groups', '1', NULL),
(127, 0, 1698644927, 'backup', 'backup_import_groups_locked', '', NULL),
(128, 0, 1698644927, 'backup', 'backup_import_competencies', '1', NULL),
(129, 0, 1698644927, 'backup', 'backup_import_competencies_locked', '', NULL),
(130, 0, 1698644927, 'backup', 'backup_import_contentbankcontent', '1', NULL),
(131, 0, 1698644927, 'backup', 'backup_import_contentbankcontent_locked', '', NULL),
(132, 0, 1698644927, 'backup', 'backup_import_legacyfiles', '1', NULL),
(133, 0, 1698644927, 'backup', 'backup_import_legacyfiles_locked', '', NULL),
(134, 0, 1698644927, 'backup', 'backup_auto_active', '0', NULL),
(135, 0, 1698644927, 'backup', 'backup_auto_weekdays', '0000000', NULL),
(136, 0, 1698644927, 'backup', 'backup_auto_hour', '0', NULL),
(137, 0, 1698644927, 'backup', 'backup_auto_minute', '0', NULL),
(138, 0, 1698644927, 'backup', 'backup_auto_storage', '0', NULL),
(139, 0, 1698644927, 'backup', 'backup_auto_destination', '', NULL),
(140, 0, 1698644927, 'backup', 'backup_auto_max_kept', '1', NULL),
(141, 0, 1698644927, 'backup', 'backup_auto_delete_days', '0', NULL),
(142, 0, 1698644927, 'backup', 'backup_auto_min_kept', '0', NULL),
(143, 0, 1698644927, 'backup', 'backup_shortname', '0', NULL),
(144, 0, 1698644927, 'backup', 'backup_auto_skip_hidden', '1', NULL),
(145, 0, 1698644927, 'backup', 'backup_auto_skip_modif_days', '30', NULL),
(146, 0, 1698644927, 'backup', 'backup_auto_skip_modif_prev', '0', NULL),
(147, 0, 1698644927, 'backup', 'backup_auto_users', '1', NULL),
(148, 0, 1698644927, 'backup', 'backup_auto_role_assignments', '1', NULL),
(149, 0, 1698644927, 'backup', 'backup_auto_activities', '1', NULL),
(150, 0, 1698644927, 'backup', 'backup_auto_blocks', '1', NULL),
(151, 0, 1698644927, 'backup', 'backup_auto_files', '1', NULL),
(152, 0, 1698644927, 'backup', 'backup_auto_filters', '1', NULL),
(153, 0, 1698644927, 'backup', 'backup_auto_comments', '1', NULL),
(154, 0, 1698644927, 'backup', 'backup_auto_badges', '1', NULL),
(155, 0, 1698644927, 'backup', 'backup_auto_calendarevents', '1', NULL),
(156, 0, 1698644927, 'backup', 'backup_auto_userscompletion', '1', NULL),
(157, 0, 1698644927, 'backup', 'backup_auto_logs', '0', NULL),
(158, 0, 1698644927, 'backup', 'backup_auto_histories', '0', NULL),
(159, 0, 1698644927, 'backup', 'backup_auto_questionbank', '1', NULL),
(160, 0, 1698644927, 'backup', 'backup_auto_groups', '1', NULL),
(161, 0, 1698644927, 'backup', 'backup_auto_competencies', '1', NULL),
(162, 0, 1698644927, 'backup', 'backup_auto_contentbankcontent', '1', NULL),
(163, 0, 1698644927, 'backup', 'backup_auto_xapistate', '1', NULL),
(164, 0, 1698644927, 'backup', 'backup_auto_legacyfiles', '1', NULL),
(165, 0, 1698644927, 'restore', 'restore_general_users', '1', NULL),
(166, 0, 1698644927, 'restore', 'restore_general_users_locked', '', NULL),
(167, 0, 1698644927, 'restore', 'restore_general_enrolments', '1', NULL),
(168, 0, 1698644927, 'restore', 'restore_general_enrolments_locked', '', NULL),
(169, 0, 1698644927, 'restore', 'restore_general_role_assignments', '1', NULL),
(170, 0, 1698644927, 'restore', 'restore_general_role_assignments_locked', '', NULL),
(171, 0, 1698644927, 'restore', 'restore_general_permissions', '1', NULL),
(172, 0, 1698644927, 'restore', 'restore_general_permissions_locked', '', NULL),
(173, 0, 1698644927, 'restore', 'restore_general_activities', '1', NULL),
(174, 0, 1698644927, 'restore', 'restore_general_activities_locked', '', NULL),
(175, 0, 1698644927, 'restore', 'restore_general_blocks', '1', NULL),
(176, 0, 1698644927, 'restore', 'restore_general_blocks_locked', '', NULL),
(177, 0, 1698644927, 'restore', 'restore_general_filters', '1', NULL),
(178, 0, 1698644927, 'restore', 'restore_general_filters_locked', '', NULL),
(179, 0, 1698644927, 'restore', 'restore_general_comments', '1', NULL),
(180, 0, 1698644927, 'restore', 'restore_general_comments_locked', '', NULL),
(181, 0, 1698644927, 'restore', 'restore_general_badges', '1', NULL),
(182, 0, 1698644927, 'restore', 'restore_general_badges_locked', '', NULL),
(183, 0, 1698644927, 'restore', 'restore_general_calendarevents', '1', NULL),
(184, 0, 1698644927, 'restore', 'restore_general_calendarevents_locked', '', NULL),
(185, 0, 1698644927, 'restore', 'restore_general_userscompletion', '1', NULL),
(186, 0, 1698644927, 'restore', 'restore_general_userscompletion_locked', '', NULL),
(187, 0, 1698644927, 'restore', 'restore_general_logs', '1', NULL),
(188, 0, 1698644927, 'restore', 'restore_general_logs_locked', '', NULL),
(189, 0, 1698644927, 'restore', 'restore_general_histories', '1', NULL),
(190, 0, 1698644927, 'restore', 'restore_general_histories_locked', '', NULL),
(191, 0, 1698644927, 'restore', 'restore_general_groups', '1', NULL),
(192, 0, 1698644927, 'restore', 'restore_general_groups_locked', '', NULL),
(193, 0, 1698644927, 'restore', 'restore_general_competencies', '1', NULL),
(194, 0, 1698644927, 'restore', 'restore_general_competencies_locked', '', NULL),
(195, 0, 1698644927, 'restore', 'restore_general_contentbankcontent', '1', NULL),
(196, 0, 1698644927, 'restore', 'restore_general_contentbankcontent_locked', '', NULL),
(197, 0, 1698644927, 'restore', 'restore_general_xapistate', '1', NULL),
(198, 0, 1698644927, 'restore', 'restore_general_xapistate_locked', '', NULL),
(199, 0, 1698644927, 'restore', 'restore_general_legacyfiles', '1', NULL),
(200, 0, 1698644927, 'restore', 'restore_general_legacyfiles_locked', '', NULL),
(201, 0, 1698644927, 'restore', 'restore_merge_overwrite_conf', '0', NULL),
(202, 0, 1698644927, 'restore', 'restore_merge_overwrite_conf_locked', '', NULL),
(203, 0, 1698644927, 'restore', 'restore_merge_course_fullname', '1', NULL),
(204, 0, 1698644927, 'restore', 'restore_merge_course_fullname_locked', '', NULL),
(205, 0, 1698644927, 'restore', 'restore_merge_course_shortname', '1', NULL),
(206, 0, 1698644927, 'restore', 'restore_merge_course_shortname_locked', '', NULL),
(207, 0, 1698644927, 'restore', 'restore_merge_course_startdate', '1', NULL),
(208, 0, 1698644927, 'restore', 'restore_merge_course_startdate_locked', '', NULL),
(209, 0, 1698644927, 'restore', 'restore_replace_overwrite_conf', '0', NULL),
(210, 0, 1698644927, 'restore', 'restore_replace_overwrite_conf_locked', '', NULL),
(211, 0, 1698644927, 'restore', 'restore_replace_course_fullname', '1', NULL),
(212, 0, 1698644927, 'restore', 'restore_replace_course_fullname_locked', '', NULL),
(213, 0, 1698644927, 'restore', 'restore_replace_course_shortname', '1', NULL),
(214, 0, 1698644927, 'restore', 'restore_replace_course_shortname_locked', '', NULL),
(215, 0, 1698644927, 'restore', 'restore_replace_course_startdate', '1', NULL),
(216, 0, 1698644927, 'restore', 'restore_replace_course_startdate_locked', '', NULL),
(217, 0, 1698644927, 'restore', 'restore_replace_keep_roles_and_enrolments', '0', NULL),
(218, 0, 1698644927, 'restore', 'restore_replace_keep_roles_and_enrolments_locked', '', NULL),
(219, 0, 1698644927, 'restore', 'restore_replace_keep_groups_and_groupings', '0', NULL),
(220, 0, 1698644927, 'restore', 'restore_replace_keep_groups_and_groupings_locked', '', NULL),
(221, 0, 1698644927, NULL, 'enableasyncbackup', '0', NULL),
(222, 0, 1698644927, 'backup', 'backup_async_message_users', '0', NULL),
(223, 0, 1698644927, 'backup', 'backup_async_message_subject', 'Moodle {operation} completed successfully', NULL),
(224, 0, 1698644927, 'backup', 'backup_async_message', 'Your {operation} (ID: {backupid}) has completed successfully. You can access it here: <a href="{link}">{link}</a>.', NULL),
(225, 0, 1698644927, NULL, 'grade_profilereport', 'user', NULL),
(226, 0, 1698644927, NULL, 'grade_aggregationposition', '1', NULL),
(227, 0, 1698644927, NULL, 'grade_includescalesinaggregation', '1', NULL),
(228, 0, 1698644927, NULL, 'grade_hiddenasdate', '0', NULL),
(229, 0, 1698644927, NULL, 'gradepublishing', '0', NULL),
(230, 0, 1698644927, NULL, 'grade_export_exportfeedback', '0', NULL),
(231, 0, 1698644927, NULL, 'grade_export_displaytype', '1', NULL),
(232, 0, 1698644927, NULL, 'grade_export_decimalpoints', '2', NULL),
(233, 0, 1698644927, NULL, 'grade_export_userprofilefields', 'firstname,lastname,idnumber,institution,department,email', NULL),
(234, 0, 1698644927, NULL, 'grade_export_customprofilefields', '', NULL),
(235, 0, 1698644927, NULL, 'recovergradesdefault', '0', NULL),
(236, 0, 1698644927, NULL, 'gradeexport', '', NULL),
(237, 0, 1698644927, NULL, 'unlimitedgrades', '0', NULL),
(238, 0, 1698644927, NULL, 'grade_report_showmin', '1', NULL),
(239, 0, 1698644927, NULL, 'gradepointmax', '100', NULL),
(240, 0, 1698644927, NULL, 'gradepointdefault', '100', NULL),
(241, 0, 1698644927, NULL, 'grade_minmaxtouse', '1', NULL),
(242, 0, 1698644927, NULL, 'grade_mygrades_report', 'overview', NULL),
(243, 0, 1698644927, NULL, 'gradereport_mygradeurl', '', NULL),
(244, 0, 1698644927, NULL, 'grade_hideforcedsettings', '1', NULL),
(245, 0, 1698644927, NULL, 'grade_aggregation', '13', NULL),
(246, 0, 1698644927, NULL, 'grade_aggregation_flag', '0', NULL),
(247, 0, 1698644927, NULL, 'grade_aggregations_visible', '13', NULL),
(248, 0, 1698644927, NULL, 'grade_aggregateonlygraded', '1', NULL),
(249, 0, 1698644927, NULL, 'grade_aggregateonlygraded_flag', '2', NULL),
(250, 0, 1698644927, NULL, 'grade_aggregateoutcomes', '0', NULL),
(251, 0, 1698644927, NULL, 'grade_aggregateoutcomes_flag', '2', NULL),
(252, 0, 1698644927, NULL, 'grade_keephigh', '0', NULL),
(253, 0, 1698644927, NULL, 'grade_keephigh_flag', '3', NULL),
(254, 0, 1698644927, NULL, 'grade_droplow', '0', NULL),
(255, 0, 1698644927, NULL, 'grade_droplow_flag', '2', NULL),
(256, 0, 1698644927, NULL, 'grade_overridecat', '1', NULL),
(257, 0, 1698644927, NULL, 'grade_displaytype', '1', NULL),
(258, 0, 1698644927, NULL, 'grade_decimalpoints', '2', NULL),
(259, 0, 1698644927, NULL, 'grade_item_advanced', 'iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime', NULL),
(260, 0, 1698644927, NULL, 'grade_report_showonlyactiveenrol', '1', NULL),
(261, 0, 1698644927, NULL, 'grade_report_quickgrading', '1', NULL),
(262, 0, 1698644927, NULL, 'grade_report_meanselection', '1', NULL),
(263, 0, 1698644927, NULL, 'grade_report_showaverages', '1', NULL),
(264, 0, 1698644927, NULL, 'grade_report_showranges', '0', NULL),
(265, 0, 1698644927, NULL, 'grade_report_showuserimage', '1', NULL),
(266, 0, 1698644927, NULL, 'grade_report_shownumberofgrades', '0', NULL),
(267, 0, 1698644927, NULL, 'grade_report_averagesdisplaytype', 'inherit', NULL),
(268, 0, 1698644927, NULL, 'grade_report_rangesdisplaytype', 'inherit', NULL),
(269, 0, 1698644927, NULL, 'grade_report_averagesdecimalpoints', 'inherit', NULL),
(270, 0, 1698644927, NULL, 'grade_report_rangesdecimalpoints', 'inherit', NULL),
(271, 0, 1698644927, NULL, 'grade_report_historyperpage', '50', NULL),
(272, 0, 1698644927, NULL, 'grade_report_overview_showrank', '0', NULL),
(273, 0, 1698644927, NULL, 'grade_report_overview_showtotalsifcontainhidden', '0', NULL),
(274, 0, 1698644927, NULL, 'grade_report_user_showrank', '0', NULL),
(275, 0, 1698644927, NULL, 'grade_report_user_showpercentage', '1', NULL),
(276, 0, 1698644927, NULL, 'grade_report_user_showgrade', '1', NULL),
(277, 0, 1698644927, NULL, 'grade_report_user_showfeedback', '1', NULL),
(278, 0, 1698644927, NULL, 'grade_report_user_showrange', '1', NULL),
(279, 0, 1698644927, NULL, 'grade_report_user_showweight', '1', NULL),
(280, 0, 1698644927, NULL, 'grade_report_user_showaverage', '0', NULL),
(281, 0, 1698644927, NULL, 'grade_report_user_showlettergrade', '0', NULL),
(282, 0, 1698644927, NULL, 'grade_report_user_rangedecimals', '0', NULL),
(283, 0, 1698644927, NULL, 'grade_report_user_showhiddenitems', '1', NULL),
(284, 0, 1698644927, NULL, 'grade_report_user_showtotalsifcontainhidden', '0', NULL),
(285, 0, 1698644927, NULL, 'grade_report_user_showcontributiontocoursetotal', '1', NULL),
(286, 0, 1698644927, 'analytics', 'modeinstruction', '', NULL),
(287, 0, 1698644927, 'analytics', 'percentonline', '0', NULL),
(288, 0, 1698644927, 'analytics', 'typeinstitution', '', NULL),
(289, 0, 1698644927, 'analytics', 'levelinstitution', '', NULL),
(290, 0, 1698644927, 'analytics', 'predictionsprocessor', '\\mlbackend_php\\processor', NULL),
(291, 0, 1698644927, 'analytics', 'defaulttimesplittingsevaluation', '\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range', NULL),
(292, 0, 1698644927, 'analytics', 'modeloutputdir', '', NULL),
(293, 0, 1698644927, 'analytics', 'onlycli', '1', NULL),
(294, 0, 1698644927, 'analytics', 'modeltimelimit', '1200', NULL),
(295, 0, 1698644927, 'analytics', 'calclifetime', '35', NULL),
(296, 0, 1698644927, NULL, 'badges_defaultissuername', '', NULL),
(297, 0, 1698644927, NULL, 'badges_defaultissuercontact', '', NULL),
(298, 0, 1698644927, NULL, 'badges_badgesalt', 'badges1698644927', NULL),
(299, 0, 1698644927, NULL, 'badges_allowcoursebadges', '1', NULL),
(300, 0, 1698644927, NULL, 'badges_allowexternalbackpack', '1', NULL),
(301, 0, 1698644927, NULL, 'rememberuserlicensepref', '1', NULL),
(302, 0, 1698644927, NULL, 'timezone', 'America/New_York', NULL),
(303, 0, 1698644927, NULL, 'forcetimezone', '99', NULL),
(304, 0, 1698644927, NULL, 'country', '0', NULL),
(305, 0, 1698644927, NULL, 'defaultcity', '', NULL),
(306, 0, 1698644927, NULL, 'geoip2file', '/home/gyasi/unilearn/geoip/GeoLite2-City.mmdb', NULL),
(307, 0, 1698644927, NULL, 'googlemapkey3', '', NULL),
(308, 0, 1698644927, NULL, 'allcountrycodes', '', NULL),
(309, 0, 1698644927, NULL, 'autolang', '1', NULL),
(310, 0, 1698644927, NULL, 'lang', 'en', NULL),
(311, 0, 1698644927, NULL, 'autolangusercreation', '1', NULL),
(312, 0, 1698644927, NULL, 'langmenu', '1', NULL),
(313, 0, 1698644927, NULL, 'langlist', '', NULL),
(314, 0, 1698644927, NULL, 'langcache', '1', NULL),
(315, 0, 1698644927, NULL, 'langstringcache', '1', NULL),
(316, 0, 1698644927, NULL, 'locale', '', NULL),
(317, 0, 1698644927, NULL, 'latinexcelexport', '0', NULL),
(318, 0, 1698644927, NULL, 'enablepdfexportfont', '0', NULL),
(319, 0, 1698644927, NULL, 'messagingallusers', '0', NULL),
(320, 0, 1698644927, NULL, 'messagingdefaultpressenter', '1', NULL),
(321, 0, 1698644927, NULL, 'messagingdeletereadnotificationsdelay', '604800', NULL),
(322, 0, 1698644927, NULL, 'messagingdeleteallnotificationsdelay', '2620800', NULL),
(323, 0, 1698644927, NULL, 'messagingallowemailoverride', '0', NULL),
(324, 0, 1698644927, NULL, 'requiremodintro', '0', NULL),
(325, 0, 1698644927, 'antivirus', 'notifyemail', '', NULL),
(326, 0, 1698644927, 'antivirus', 'notifylevel', '2', NULL),
(327, 0, 1698644927, 'antivirus', 'threshold', '1200', NULL),
(328, 0, 1698644927, 'antivirus', 'enablequarantine', '0', NULL),
(329, 0, 1698644927, 'antivirus', 'quarantinetime', '2419200', NULL),
(330, 0, 1698644927, NULL, 'registerauth', '', NULL),
(331, 0, 1698644927, NULL, 'authloginviaemail', '0', NULL),
(332, 0, 1698644927, NULL, 'allowaccountssameemail', '0', NULL),
(333, 0, 1698644927, NULL, 'authpreventaccountcreation', '0', NULL),
(334, 0, 1698644927, NULL, 'loginpageautofocus', '0', NULL),
(335, 0, 1698644927, NULL, 'guestloginbutton', '1', NULL),
(336, 0, 1698644927, NULL, 'limitconcurrentlogins', '0', NULL),
(337, 0, 1698644927, NULL, 'alternateloginurl', '', NULL),
(338, 0, 1698644927, NULL, 'forgottenpasswordurl', '', NULL),
(339, 0, 1698644927, NULL, 'auth_instructions', '', NULL),
(340, 0, 1698644927, NULL, 'allowemailaddresses', '', NULL),
(341, 0, 1698644927, NULL, 'denyemailaddresses', '', NULL),
(342, 0, 1698644927, NULL, 'verifychangedemail', '1', NULL),
(343, 0, 1698644927, NULL, 'enableloginrecaptcha', '0', NULL),
(344, 0, 1698644927, NULL, 'recaptchapublickey', '', NULL),
(345, 0, 1698644927, NULL, 'recaptchaprivatekey', '', NULL),
(346, 0, 1698644927, 'cachestore_apcu', 'testperformance', '0', NULL),
(347, 0, 1698644927, 'cachestore_redis', 'test_server', '', NULL),
(348, 0, 1698644927, 'cachestore_redis', 'test_encryption', '0', NULL),
(349, 0, 1698644927, 'cachestore_redis', 'test_cafile', '', NULL),
(350, 0, 1698644927, 'cachestore_redis', 'test_password', '', NULL),
(351, 0, 1698644927, 'cachestore_redis', 'test_serializer', '1', NULL),
(352, 0, 1698644927, 'cachestore_redis', 'test_ttl', '0', NULL),
(353, 0, 1698644927, NULL, 'filteruploadedfiles', '0', NULL),
(354, 0, 1698644927, NULL, 'filtermatchoneperpage', '0', NULL),
(355, 0, 1698644927, NULL, 'filtermatchonepertext', '0', NULL),
(356, 0, 1698644927, NULL, 'filternavigationwithsystemcontext', '0', NULL),
(357, 0, 1698644927, NULL, 'media_default_width', '640', NULL),
(358, 0, 1698644927, NULL, 'media_default_height', '360', NULL),
(359, 0, 1698644927, NULL, 'portfolio_moderate_filesize_threshold', '1048576', NULL),
(360, 0, 1698644927, NULL, 'portfolio_high_filesize_threshold', '5242880', NULL),
(361, 0, 1698644927, NULL, 'portfolio_moderate_db_threshold', '20', NULL),
(362, 0, 1698644927, NULL, 'portfolio_high_db_threshold', '50', NULL),
(363, 0, 1698644927, 'question_preview', 'behaviour', 'deferredfeedback', NULL),
(364, 0, 1698644927, 'question_preview', 'correctness', '1', NULL),
(365, 0, 1698644927, 'question_preview', 'marks', '2', NULL),
(366, 0, 1698644927, 'question_preview', 'markdp', '2', NULL),
(367, 0, 1698644927, 'question_preview', 'feedback', '1', NULL),
(368, 0, 1698644927, 'question_preview', 'generalfeedback', '1', NULL),
(369, 0, 1698644927, 'question_preview', 'rightanswer', '1', NULL),
(370, 0, 1698644927, 'question_preview', 'history', '0', NULL),
(371, 0, 1698644927, NULL, 'repositorycacheexpire', '120', NULL),
(372, 0, 1698644927, NULL, 'repositorygetfiletimeout', '30', NULL),
(373, 0, 1698644927, NULL, 'repositorysyncfiletimeout', '1', NULL),
(374, 0, 1698644927, NULL, 'repositorysyncimagetimeout', '3', NULL),
(375, 0, 1698644927, NULL, 'repositoryallowexternallinks', '1', NULL),
(376, 0, 1698644927, NULL, 'legacyfilesinnewcourses', '0', NULL),
(377, 0, 1698644927, NULL, 'legacyfilesaddallowed', '1', NULL),
(378, 0, 1698644927, NULL, 'searchengine', 'simpledb', NULL),
(379, 0, 1698644927, NULL, 'searchindexwhendisabled', '0', NULL),
(380, 0, 1698644927, NULL, 'searchindextime', '600', NULL),
(381, 0, 1698644927, NULL, 'searchallavailablecourses', '0', NULL),
(382, 0, 1698644927, NULL, 'searchincludeallcourses', '0', NULL),
(383, 0, 1698644927, NULL, 'searchenablecategories', '0', NULL),
(384, 0, 1698644927, NULL, 'searchdefaultcategory', 'core-all', NULL),
(385, 0, 1698644927, NULL, 'searchhideallcategory', '0', NULL),
(386, 0, 1698644927, NULL, 'searchmaxtopresults', '3', NULL),
(387, 0, 1698644927, NULL, 'searchteacherroles', '', NULL),
(388, 0, 1698644927, NULL, 'searchenginequeryonly', '', NULL),
(389, 0, 1698644927, NULL, 'searchbannerenable', '0', NULL),
(390, 0, 1698644927, NULL, 'searchbanner', '', NULL),
(391, 0, 1698644927, NULL, 'allowbeforeblock', '0', NULL),
(392, 0, 1698644927, NULL, 'allowedip', '', NULL),
(393, 0, 1698644927, NULL, 'blockedip', '', NULL),
(394, 0, 1698644927, NULL, 'protectusernames', '1', NULL),
(395, 0, 1698644927, NULL, 'forcelogin', '0', NULL),
(396, 0, 1698644927, NULL, 'forceloginforprofiles', '1', NULL),
(397, 0, 1698644927, NULL, 'forceloginforprofileimage', '0', NULL),
(398, 0, 1698644927, NULL, 'opentowebcrawlers', '0', NULL),
(399, 0, 1698644927, NULL, 'allowindexing', '0', NULL),
(400, 0, 1698644927, NULL, 'maxbytes', '0', NULL),
(401, 0, 1698644927, NULL, 'userquota', '104857600', NULL),
(402, 0, 1698644927, NULL, 'allowobjectembed', '0', NULL),
(403, 0, 1698644927, NULL, 'enabletrusttext', '0', NULL),
(404, 0, 1698644927, NULL, 'maxeditingtime', '1800', NULL),
(405, 0, 1698644927, NULL, 'extendedusernamechars', '0', NULL),
(406, 0, 1698644927, NULL, 'keeptagnamecase', '1', NULL),
(407, 0, 1698644927, NULL, 'profilesforenrolledusersonly', '1', NULL),
(408, 0, 1698644927, NULL, 'cronclionly', '1', NULL),
(409, 0, 1698644927, NULL, 'cronremotepassword', '', NULL),
(410, 0, 1698644927, 'tool_task', 'enablerunnow', '1', NULL),
(411, 0, 1698644927, NULL, 'lockoutthreshold', '0', NULL),
(412, 0, 1698644927, NULL, 'lockoutwindow', '1800', NULL),
(413, 0, 1698644927, NULL, 'lockoutduration', '1800', NULL),
(414, 0, 1698644927, NULL, 'passwordpolicy', '1', NULL),
(415, 0, 1698644927, NULL, 'minpasswordlength', '8', NULL),
(416, 0, 1698644927, NULL, 'minpassworddigits', '1', NULL),
(417, 0, 1698644927, NULL, 'minpasswordlower', '1', NULL),
(418, 0, 1698644927, NULL, 'minpasswordupper', '1', NULL),
(419, 0, 1698644927, NULL, 'minpasswordnonalphanum', '1', NULL),
(420, 0, 1698644927, NULL, 'maxconsecutiveidentchars', '0', NULL),
(421, 0, 1698644927, NULL, 'passwordpolicycheckonlogin', '0', NULL),
(422, 0, 1698644927, NULL, 'passwordreuselimit', '0', NULL),
(423, 0, 1698644927, NULL, 'pwresettime', '1800', NULL),
(424, 0, 1698644927, NULL, 'passwordchangelogout', '0', NULL),
(425, 0, 1698644927, NULL, 'passwordchangetokendeletion', '0', NULL),
(426, 0, 1698644927, NULL, 'tokenduration', '7257600', NULL),
(427, 0, 1698644927, NULL, 'groupenrolmentkeypolicy', '1', NULL),
(428, 0, 1698644927, NULL, 'disableuserimages', '0', NULL),
(429, 0, 1698644927, NULL, 'emailchangeconfirmation', '1', NULL),
(430, 0, 1698644927, NULL, 'rememberusername', '2', NULL),
(431, 0, 1698644927, NULL, 'strictformsrequired', '0', NULL),
(432, 0, 1698644927, 'adminpresets', 'sensiblesettings', 'recaptchapublickey@@none, recaptchaprivatekey@@none, googlemapkey3@@none, secretphrase@@url, cronremotepassword@@none, smtpuser@@none, smtppass@@none, proxypassword@@none, quizpassword@@quiz, allowedip@@none, blockedip@@none, dbpass@@logstore_database, messageinbound_hostpass@@none, bind_pw@@auth_cas, pass@@auth_db, bind_pw@@auth_ldap, dbpass@@enrol_database, bind_pw@@enrol_ldap, server_password@@search_solr, ssl_keypassword@@search_solr, alternateserver_password@@search_solr, alternatessl_keypassword@@search_solr, test_password@@cachestore_redis, password@@mlbackend_python, badges_badgesalt@@none, calendar_exportsalt@@none', NULL),
(433, 0, 1698644927, NULL, 'cookiesecure', '1', NULL),
(434, 0, 1698644927, NULL, 'allowframembedding', '0', NULL),
(435, 0, 1698644927, NULL, 'curlsecurityblockedhosts', '127.0.0.0/8\n192.168.0.0/16\n10.0.0.0/8\n172.16.0.0/12\n0.0.0.0\nlocalhost\n169.254.169.254\n0000::1', NULL),
(436, 0, 1698644927, NULL, 'curlsecurityallowedport', '443\n80', NULL),
(437, 0, 1698644927, NULL, 'referrerpolicy', 'default', NULL),
(438, 0, 1698644927, NULL, 'displayloginfailures', '0', NULL),
(439, 0, 1698644927, NULL, 'notifyloginfailures', '', NULL),
(440, 0, 1698644927, NULL, 'notifyloginthreshold', '10', NULL),
(441, 0, 1698644927, NULL, 'themelist', '', NULL),
(442, 0, 1698644927, NULL, 'themedesignermode', '0', NULL),
(443, 0, 1698644927, NULL, 'allowuserthemes', '0', NULL),
(444, 0, 1698644927, NULL, 'allowcoursethemes', '0', NULL),
(445, 0, 1698644927, NULL, 'allowcategorythemes', '0', NULL),
(446, 0, 1698644927, NULL, 'allowcohortthemes', '0', NULL),
(447, 0, 1698644927, NULL, 'allowthemechangeonurl', '0', NULL),
(448, 0, 1698644927, NULL, 'allowuserblockhiding', '1', NULL),
(449, 0, 1698644927, NULL, 'langmenuinsecurelayout', '0', NULL),
(450, 0, 1698644927, NULL, 'logininfoinsecurelayout', '0', NULL),
(451, 0, 1698644927, NULL, 'custommenuitems', '', NULL),
(452, 0, 1698644927, NULL, 'customusermenuitems', 'profile,moodle|/user/profile.php\ngrades,grades|/grade/report/mygrades.php\ncalendar,core_calendar|/calendar/view.php?view=month\nprivatefiles,moodle|/user/files.php\nreports,core_reportbuilder|/reportbuilder/index.php', NULL),
(453, 0, 1698644927, 'theme_boost', 'unaddableblocks', 'navigation,settings,course_list,section_links', NULL),
(454, 0, 1698644927, 'theme_boost', 'preset', 'default.scss', NULL),
(455, 0, 1698644927, 'theme_boost', 'presetfiles', '', NULL),
(456, 0, 1698644927, 'theme_boost', 'backgroundimage', '', NULL),
(457, 0, 1698644927, 'theme_boost', 'loginbackgroundimage', '', NULL),
(458, 0, 1698644927, 'theme_boost', 'brandcolor', '', NULL),
(459, 0, 1698644927, 'theme_boost', 'scsspre', '', NULL),
(460, 0, 1698644927, 'theme_boost', 'scss', '', NULL),
(461, 0, 1698644927, 'theme_classic', 'navbardark', '0', NULL),
(462, 0, 1698644927, 'theme_classic', 'unaddableblocks', '', NULL),
(463, 0, 1698644927, 'theme_classic', 'preset', 'default.scss', NULL),
(464, 0, 1698644927, 'theme_classic', 'presetfiles', '', NULL),
(465, 0, 1698644927, 'theme_classic', 'backgroundimage', '', NULL),
(466, 0, 1698644927, 'theme_classic', 'loginbackgroundimage', '', NULL),
(467, 0, 1698644927, 'theme_classic', 'brandcolor', '', NULL),
(468, 0, 1698644927, 'theme_classic', 'scsspre', '', NULL),
(469, 0, 1698644927, 'theme_classic', 'scss', '', NULL),
(470, 0, 1698644927, 'core_admin', 'logo', '', NULL),
(471, 0, 1698644927, 'core_admin', 'logocompact', '', NULL),
(472, 0, 1698644927, 'core_admin', 'favicon', '', NULL),
(473, 0, 1698644927, 'core_admin', 'coursecolor1', '#81ecec', NULL),
(474, 0, 1698644927, 'core_admin', 'coursecolor2', '#74b9ff', NULL),
(475, 0, 1698644927, 'core_admin', 'coursecolor3', '#a29bfe', NULL),
(476, 0, 1698644927, 'core_admin', 'coursecolor4', '#dfe6e9', NULL),
(477, 0, 1698644927, 'core_admin', 'coursecolor5', '#00b894', NULL),
(478, 0, 1698644927, 'core_admin', 'coursecolor6', '#0984e3', NULL),
(479, 0, 1698644927, 'core_admin', 'coursecolor7', '#b2bec3', NULL),
(480, 0, 1698644927, 'core_admin', 'coursecolor8', '#fdcb6e', NULL),
(481, 0, 1698644927, 'core_admin', 'coursecolor9', '#fd79a8', NULL),
(482, 0, 1698644927, 'core_admin', 'coursecolor10', '#6c5ce7', NULL),
(483, 0, 1698644927, NULL, 'calendartype', 'gregorian', NULL),
(484, 0, 1698644927, NULL, 'calendar_adminseesall', '0', NULL),
(485, 0, 1698644927, NULL, 'calendar_site_timeformat', '0', NULL),
(486, 0, 1698644927, NULL, 'calendar_startwday', '1', NULL),
(487, 0, 1698644927, NULL, 'calendar_weekend', '65', NULL),
(488, 0, 1698644927, NULL, 'calendar_lookahead', '21', NULL),
(489, 0, 1698644927, NULL, 'calendar_maxevents', '10', NULL),
(490, 0, 1698644927, NULL, 'enablecalendarexport', '1', NULL),
(491, 0, 1698644927, NULL, 'calendar_customexport', '1', NULL),
(492, 0, 1698644927, NULL, 'calendar_exportlookahead', '365', NULL),
(493, 0, 1698644927, NULL, 'calendar_exportlookback', '5', NULL),
(494, 0, 1698644927, NULL, 'calendar_exportsalt', 'zfptqgibihyr7aljajqh7zqf6d7i6qtwnl26fydut7cqamjr9ltqayhcuux4', NULL),
(495, 0, 1698644927, NULL, 'calendar_showicalsource', '1', NULL),
(496, 0, 1698644927, NULL, 'useblogassociations', '1', NULL),
(497, 0, 1698644927, NULL, 'bloglevel', '4', NULL),
(498, 0, 1698644927, NULL, 'useexternalblogs', '1', NULL),
(499, 0, 1698644927, NULL, 'externalblogcrontime', '86400', NULL),
(500, 0, 1698644927, NULL, 'maxexternalblogsperuser', '1', NULL),
(501, 0, 1698644927, NULL, 'blogusecomments', '1', NULL),
(502, 0, 1698644927, NULL, 'blogshowcommentscount', '1', NULL),
(503, 0, 1698644927, NULL, 'enabledashboard', '1', NULL),
(504, 0, 1698644927, NULL, 'defaulthomepage', '3', NULL),
(505, 0, 1698644927, NULL, 'navshowfullcoursenames', '0', NULL),
(506, 0, 1698644927, NULL, 'navshowcategories', '1', NULL),
(507, 0, 1698644927, NULL, 'navshowmycoursecategories', '0', NULL),
(508, 0, 1698644927, NULL, 'navshowallcourses', '0', NULL),
(509, 0, 1698644927, NULL, 'navsortmycoursessort', 'sortorder', NULL),
(510, 0, 1698644927, NULL, 'navsortmycourseshiddenlast', '1', NULL),
(511, 0, 1698644927, NULL, 'navcourselimit', '10', NULL),
(512, 0, 1698644927, NULL, 'usesitenameforsitepages', '0', NULL),
(513, 0, 1698644927, NULL, 'linkadmincategories', '1', NULL),
(514, 0, 1698644927, NULL, 'linkcoursesections', '1', NULL),
(515, 0, 1698644927, NULL, 'navshowfrontpagemods', '1', NULL),
(516, 0, 1698644927, NULL, 'navadduserpostslinks', '1', NULL),
(517, 0, 1698644927, NULL, 'sitenameintitle', 'shortname', NULL),
(518, 0, 1698644927, NULL, 'formatstringstriptags', '1', NULL),
(519, 0, 1698644927, NULL, 'emoticons', '[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]', NULL),
(520, 0, 1698644927, NULL, 'docroot', 'https://docs.moodle.org', NULL),
(521, 0, 1698644927, NULL, 'doclang', '', NULL),
(522, 0, 1698644927, NULL, 'doctonewwindow', '0', NULL),
(523, 0, 1698644927, NULL, 'coursecreationguide', 'https://moodle.academy/coursequickstart', NULL),
(524, 0, 1698644927, NULL, 'coursecontactduplicates', '0', NULL),
(525, 0, 1698644927, NULL, 'courselistshortnames', '0', NULL),
(526, 0, 1698644927, NULL, 'coursesperpage', '20', NULL),
(527, 0, 1698644927, NULL, 'courseswithsummarieslimit', '10', NULL),
(528, 0, 1698644927, NULL, 'courseoverviewfileslimit', '1', NULL),
(529, 0, 1698644927, NULL, 'courseoverviewfilesext', 'web_image', NULL),
(530, 0, 1698644927, NULL, 'coursegraceperiodbefore', '0', NULL),
(531, 0, 1698644927, NULL, 'coursegraceperiodafter', '0', NULL),
(532, 0, 1698644927, NULL, 'yuicomboloading', '1', NULL),
(533, 0, 1698644927, NULL, 'cachejs', '1', NULL),
(534, 0, 1698644927, NULL, 'additionalhtmlhead', '', NULL),
(535, 0, 1698644927, NULL, 'additionalhtmltopofbody', '', NULL),
(536, 0, 1698644927, NULL, 'additionalhtmlfooter', '', NULL),
(537, 0, 1698644927, NULL, 'cachetemplates', '1', NULL),
(538, 0, 1698644927, NULL, 'pathtophp', '', NULL),
(539, 0, 1698644927, NULL, 'pathtodu', '', NULL),
(540, 0, 1698644927, NULL, 'aspellpath', '', NULL),
(541, 0, 1698644927, NULL, 'pathtodot', '', NULL),
(542, 0, 1698644927, NULL, 'pathtogs', '/usr/bin/gs', NULL),
(543, 0, 1698644927, NULL, 'pathtopdftoppm', '', NULL),
(544, 0, 1698644927, NULL, 'pathtopython', '', NULL),
(545, 0, 1698644927, NULL, 'supportname', 'Admin User', NULL),
(546, 0, 1698644927, NULL, 'supportpage', '', NULL),
(547, 0, 1698644927, NULL, 'supportavailability', '1', NULL),
(548, 0, 1698644927, NULL, 'servicespage', '', NULL),
(549, 0, 1698644927, NULL, 'dbsessions', '0', NULL),
(550, 0, 1698644927, NULL, 'sessiontimeoutwarning', '1200', NULL),
(551, 0, 1698644927, NULL, 'sessioncookie', '', NULL),
(552, 0, 1698644927, NULL, 'sessioncookiepath', '', NULL),
(553, 0, 1698644927, NULL, 'sessioncookiedomain', '', NULL),
(554, 0, 1698644927, NULL, 'statsfirstrun', 'none', NULL),
(555, 0, 1698644927, NULL, 'statsmaxruntime', '0', NULL),
(556, 0, 1698644927, NULL, 'statsruntimedays', '31', NULL),
(557, 0, 1698644927, NULL, 'statsuserthreshold', '0', NULL),
(558, 0, 1698644927, NULL, 'slasharguments', '1', NULL),
(559, 0, 1698644927, NULL, 'getremoteaddrconf', '3', NULL),
(560, 0, 1698644927, NULL, 'reverseproxyignore', '', NULL),
(561, 0, 1698644927, NULL, 'proxyhost', '', NULL),
(562, 0, 1698644927, NULL, 'proxyport', '0', NULL),
(563, 0, 1698644927, NULL, 'proxytype', 'HTTP', NULL),
(564, 0, 1698644927, NULL, 'proxyuser', '', NULL),
(565, 0, 1698644927, NULL, 'proxypassword', '', NULL),
(566, 0, 1698644927, NULL, 'proxybypass', 'localhost, 127.0.0.1', NULL),
(567, 0, 1698644927, NULL, 'proxylogunsafe', '0', NULL),
(568, 0, 1698644927, NULL, 'proxyfixunsafe', '0', NULL),
(569, 0, 1698644927, NULL, 'maintenance_enabled', '0', NULL),
(570, 0, 1698644927, NULL, 'maintenance_message', '', NULL),
(571, 0, 1698644927, NULL, 'deleteunconfirmed', '168', NULL),
(572, 0, 1698644927, NULL, 'deleteincompleteusers', '0', NULL),
(573, 0, 1698644927, NULL, 'disablegradehistory', '0', NULL),
(574, 0, 1698644927, NULL, 'gradehistorylifetime', '0', NULL),
(575, 0, 1698644927, NULL, 'tempdatafoldercleanup', '168', NULL),
(576, 0, 1698644927, NULL, 'xapicleanupperiod', '4838400', NULL),
(577, 0, 1698644927, NULL, 'filescleanupperiod', '86400', NULL),
(578, 0, 1698644927, NULL, 'extramemorylimit', '512M', NULL),
(579, 0, 1698644927, NULL, 'maxtimelimit', '0', NULL),
(580, 0, 1698644927, NULL, 'curlcache', '120', NULL),
(581, 0, 1698644927, NULL, 'curltimeoutkbitrate', '56', NULL),
(582, 0, 1698644927, NULL, 'cron_enabled', '1', NULL),
(583, 0, 1698644927, NULL, 'cron_keepalive', '180', NULL),
(584, 0, 1698644927, NULL, 'task_scheduled_concurrency_limit', '3', NULL),
(585, 0, 1698644927, NULL, 'task_scheduled_max_runtime', '1800', NULL),
(586, 0, 1698644927, NULL, 'task_adhoc_concurrency_limit', '3', NULL),
(587, 0, 1698644927, NULL, 'task_adhoc_max_runtime', '1800', NULL),
(588, 0, 1698644927, NULL, 'task_logmode', '1', NULL),
(589, 0, 1698644927, NULL, 'task_logtostdout', '1', NULL),
(590, 0, 1698644927, NULL, 'task_logretention', '2419200', NULL),
(591, 0, 1698644927, NULL, 'task_logretainruns', '20', NULL),
(592, 0, 1698644927, NULL, 'smtphosts', '', NULL),
(593, 0, 1698644927, NULL, 'smtpsecure', '', NULL),
(594, 0, 1698644927, NULL, 'smtpauthtype', 'LOGIN', NULL),
(595, 0, 1698644927, NULL, 'smtpuser', '', NULL),
(596, 0, 1698644927, NULL, 'smtppass', '', NULL),
(597, 0, 1698644927, NULL, 'smtpmaxbulk', '1', NULL),
(598, 0, 1698644927, NULL, 'noreplyaddress', 'ftech868@gmail.com', NULL),
(599, 0, 1698644927, NULL, 'allowedemaildomains', '', NULL),
(600, 0, 1698644927, NULL, 'divertallemailsto', '', NULL),
(601, 0, 1698644927, NULL, 'divertallemailsexcept', '', NULL),
(602, 0, 1698644927, NULL, 'emaildkimselector', '', NULL),
(603, 0, 1698644927, NULL, 'sitemailcharset', '0', NULL),
(604, 0, 1698644927, NULL, 'allowusermailcharset', '0', NULL),
(605, 0, 1698644927, NULL, 'allowattachments', '1', NULL),
(606, 0, 1698644927, NULL, 'mailnewline', 'LF', NULL),
(607, 0, 1698644927, NULL, 'emailfromvia', '1', NULL),
(608, 0, 1698644927, NULL, 'emailsubjectprefix', '', NULL),
(609, 0, 1698644927, NULL, 'emailheaders', '', NULL),
(610, 0, 1698644927, NULL, 'updateautocheck', '1', NULL),
(611, 0, 1698644927, NULL, 'updateminmaturity', '200', NULL),
(612, 0, 1698644927, NULL, 'updatenotifybuilds', '0', NULL),
(613, 0, 1698644927, NULL, 'enablewsdocumentation', '0', NULL),
(614, 0, 1698644927, NULL, 'customreportslimit', '0', NULL),
(615, 0, 1698644927, NULL, 'customreportsliveediting', '1', NULL),
(616, 0, 1698644927, NULL, 'dndallowtextandlinks', '0', NULL),
(617, 0, 1698644927, NULL, 'pathtosassc', '', NULL),
(618, 0, 1698644927, NULL, 'contextlocking', '0', NULL),
(619, 0, 1698644927, NULL, 'contextlockappliestoadmin', '1', NULL),
(620, 0, 1698644927, NULL, 'forceclean', '0', NULL),
(621, 0, 1698644927, NULL, 'enablecourserelativedates', '0', NULL),
(622, 0, 1698644927, NULL, 'enablesharingtomoodlenet', '0', NULL),
(623, 0, 1698644927, NULL, 'enablecommunicationsubsystem', '0', NULL),
(624, 0, 1698644927, NULL, 'debug', '0', NULL),
(625, 0, 1698644927, NULL, 'debugdisplay', '0', NULL),
(626, 0, 1698644927, NULL, 'perfdebug', '7', NULL),
(627, 0, 1698644927, NULL, 'debugstringids', '0', NULL),
(628, 0, 1698644927, NULL, 'debugsqltrace', '0', NULL),
(629, 0, 1698644927, NULL, 'debugvalidators', '0', NULL),
(630, 0, 1698644927, NULL, 'debugpageinfo', '0', NULL),
(631, 0, 1698644927, NULL, 'debugtemplateinfo', '0', NULL),
(632, 0, 1698644927, NULL, 'profilingenabled', '0', NULL),
(633, 0, 1698644927, NULL, 'profilingincluded', '', NULL),
(634, 0, 1698644927, NULL, 'profilingexcluded', '', NULL),
(635, 0, 1698644927, NULL, 'profilingautofrec', '0', NULL),
(636, 0, 1698644927, NULL, 'profilingallowme', '0', NULL),
(637, 0, 1698644927, NULL, 'profilingallowall', '0', NULL),
(638, 0, 1698644927, NULL, 'profilingslow', '0', NULL),
(639, 0, 1698644927, NULL, 'profilinglifetime', '1440', NULL),
(640, 0, 1698644927, NULL, 'profilingimportprefix', '(I)', NULL),
(641, 0, 1698644927, 'core_competency', 'pushcourseratingstouserplans', '1', NULL),
(642, 0, 1698644927, NULL, 'allowguestmymoodle', '1', NULL),
(643, 0, 1698644927, 'activitynames', 'filter_active', '1', ''),
(644, 0, 1698644927, 'core_filter', 'order', 'activitynames', 'activitynames'),
(645, 0, 1698644927, 'displayh5p', 'filter_active', '1', ''),
(646, 0, 1698644927, 'core_filter', 'order', 'displayh5p, activitynames', 'activitynames, displayh5p'),
(647, 0, 1698644927, 'emoticon', 'filter_active', '1', ''),
(648, 0, 1698644927, 'mathjaxloader', 'filter_active', '1', ''),
(649, 0, 1698644927, 'core_filter', 'order', 'displayh5p, activitynames, mathjaxloader, emoticon', 'displayh5p, activitynames, emoticon, mathjaxloader'),
(650, 0, 1698644927, 'mediaplugin', 'filter_active', '1', ''),
(651, 0, 1698644927, 'urltolink', 'filter_active', '1', ''),
(652, 0, 1698644927, 'core_filter', 'order', 'displayh5p, activitynames, mathjaxloader, emoticon, urltolink, mediaplugin', 'displayh5p, activitynames, mathjaxloader, emoticon, mediaplugin, urltolink'),
(653, 0, 1698644927, 'tiny_noautolink', 'disabled', '1', '0'),
(654, 2, 1698644927, NULL, 'enableaccessibilitytools', '1', NULL),
(655, 2, 1698644927, 'tool_moodlenet', 'enablemoodlenet', '1', NULL),
(656, 2, 1698644927, NULL, 'notloggedinroleid', '6', NULL),
(657, 2, 1698644927, NULL, 'guestroleid', '6', NULL),
(658, 2, 1698644927, NULL, 'defaultuserroleid', '7', NULL),
(659, 2, 1698644927, NULL, 'creatornewroleid', '3', NULL),
(660, 2, 1698644927, NULL, 'restorernewroleid', '3', NULL),
(661, 2, 1698644927, 'tool_dataprivacy', 'contactdataprotectionofficer', '0', NULL),
(662, 2, 1698644927, 'tool_dataprivacy', 'automaticdataexportapproval', '0', NULL),
(663, 2, 1698644927, 'tool_dataprivacy', 'automaticdatadeletionapproval', '0', NULL),
(664, 2, 1698644927, 'tool_dataprivacy', 'automaticdeletionrequests', '1', NULL),
(665, 2, 1698644927, 'tool_dataprivacy', 'privacyrequestexpiry', '604800', NULL),
(666, 2, 1698644927, 'tool_dataprivacy', 'requireallenddatesforuserdeletion', '1', NULL),
(667, 2, 1698644927, 'tool_dataprivacy', 'showdataretentionsummary', '1', NULL),
(668, 2, 1698644927, 'tool_dataprivacy', 'allowfiltering', '0', NULL),
(669, 2, 1698644927, 'tool_log', 'exportlog', '1', NULL),
(670, 2, 1698644927, NULL, 'sitepolicyhandler', '', NULL),
(671, 2, 1698644927, NULL, 'gradebookroles', '5', NULL),
(672, 2, 1698644927, 'analytics', 'logstore', 'logstore_standard', NULL),
(673, 2, 1698644927, NULL, 'h5plibraryhandler', 'h5plib_v124', NULL),
(674, 2, 1698644927, NULL, 'airnotifierurl', 'https://messages.moodle.net', NULL),
(675, 2, 1698644927, NULL, 'airnotifierport', '443', NULL),
(676, 2, 1698644927, NULL, 'airnotifiermobileappname', 'com.moodle.moodlemobile', NULL),
(677, 2, 1698644927, NULL, 'airnotifierappname', 'commoodlemoodlemobile', NULL),
(678, 2, 1698644927, NULL, 'airnotifieraccesskey', '', NULL),
(679, 2, 1698644927, 'message_airnotifier', 'encryptnotifications', '0', NULL),
(680, 2, 1698644927, 'message_airnotifier', 'encryptprocessing', '0', NULL),
(681, 2, 1698644927, 'assign', 'feedback_plugin_for_gradebook', 'assignfeedback_comments', NULL),
(682, 2, 1698644927, 'assign', 'showrecentsubmissions', '0', NULL),
(683, 2, 1698644927, 'assign', 'submissionreceipts', '1', NULL),
(684, 2, 1698644927, 'assign', 'submissionstatement', 'This submission is my own work, except where I have acknowledged the use of the works of other people.', NULL),
(685, 2, 1698644927, 'assign', 'submissionstatementteamsubmission', 'This submission is the work of my group, except where we have acknowledged the use of the works of other people.', NULL),
(686, 2, 1698644927, 'assign', 'submissionstatementteamsubmissionallsubmit', 'This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.', NULL),
(687, 2, 1698644927, 'assign', 'maxperpage', '-1', NULL),
(688, 2, 1698644927, 'assign', 'alwaysshowdescription', '1', NULL),
(689, 2, 1698644927, 'assign', 'alwaysshowdescription_adv', '', NULL),
(690, 2, 1698644927, 'assign', 'alwaysshowdescription_locked', '', NULL),
(691, 2, 1698644927, 'assign', 'allowsubmissionsfromdate', '0', NULL),
(692, 2, 1698644927, 'assign', 'allowsubmissionsfromdate_enabled', '1', NULL),
(693, 2, 1698644927, 'assign', 'allowsubmissionsfromdate_adv', '', NULL),
(694, 2, 1698644927, 'assign', 'duedate', '604800', NULL),
(695, 2, 1698644927, 'assign', 'duedate_enabled', '1', NULL),
(696, 2, 1698644927, 'assign', 'duedate_adv', '', NULL),
(697, 2, 1698644927, 'assign', 'cutoffdate', '1209600', NULL),
(698, 2, 1698644927, 'assign', 'cutoffdate_enabled', '', NULL),
(699, 2, 1698644927, 'assign', 'cutoffdate_adv', '', NULL),
(700, 2, 1698644927, 'assign', 'enabletimelimit', '0', NULL),
(701, 2, 1698644927, 'assign', 'gradingduedate', '1209600', NULL),
(702, 2, 1698644927, 'assign', 'gradingduedate_enabled', '1', NULL),
(703, 2, 1698644927, 'assign', 'gradingduedate_adv', '', NULL),
(704, 2, 1698644927, 'assign', 'submissiondrafts', '0', NULL),
(705, 2, 1698644927, 'assign', 'submissiondrafts_adv', '', NULL),
(706, 2, 1698644927, 'assign', 'submissiondrafts_locked', '', NULL),
(707, 2, 1698644927, 'assign', 'requiresubmissionstatement', '0', NULL),
(708, 2, 1698644927, 'assign', 'requiresubmissionstatement_adv', '', NULL),
(709, 2, 1698644927, 'assign', 'requiresubmissionstatement_locked', '', NULL),
(710, 2, 1698644927, 'assign', 'attemptreopenmethod', 'none', NULL),
(711, 2, 1698644927, 'assign', 'attemptreopenmethod_adv', '', NULL),
(712, 2, 1698644927, 'assign', 'attemptreopenmethod_locked', '', NULL),
(713, 2, 1698644927, 'assign', 'maxattempts', '-1', NULL),
(714, 2, 1698644927, 'assign', 'maxattempts_adv', '', NULL),
(715, 2, 1698644927, 'assign', 'maxattempts_locked', '', NULL),
(716, 2, 1698644927, 'assign', 'teamsubmission', '0', NULL),
(717, 2, 1698644927, 'assign', 'teamsubmission_adv', '', NULL),
(718, 2, 1698644927, 'assign', 'teamsubmission_locked', '', NULL),
(719, 2, 1698644927, 'assign', 'preventsubmissionnotingroup', '0', NULL),
(720, 2, 1698644927, 'assign', 'preventsubmissionnotingroup_adv', '', NULL),
(721, 2, 1698644927, 'assign', 'preventsubmissionnotingroup_locked', '', NULL),
(722, 2, 1698644927, 'assign', 'requireallteammemberssubmit', '0', NULL),
(723, 2, 1698644927, 'assign', 'requireallteammemberssubmit_adv', '', NULL),
(724, 2, 1698644927, 'assign', 'requireallteammemberssubmit_locked', '', NULL),
(725, 2, 1698644927, 'assign', 'teamsubmissiongroupingid', '', NULL),
(726, 2, 1698644927, 'assign', 'teamsubmissiongroupingid_adv', '', NULL),
(727, 2, 1698644927, 'assign', 'sendnotifications', '0', NULL),
(728, 2, 1698644927, 'assign', 'sendnotifications_adv', '', NULL),
(729, 2, 1698644927, 'assign', 'sendnotifications_locked', '', NULL),
(730, 2, 1698644927, 'assign', 'sendlatenotifications', '0', NULL),
(731, 2, 1698644927, 'assign', 'sendlatenotifications_adv', '', NULL),
(732, 2, 1698644927, 'assign', 'sendlatenotifications_locked', '', NULL),
(733, 2, 1698644927, 'assign', 'sendstudentnotifications', '1', NULL),
(734, 2, 1698644927, 'assign', 'sendstudentnotifications_adv', '', NULL),
(735, 2, 1698644927, 'assign', 'sendstudentnotifications_locked', '', NULL),
(736, 2, 1698644927, 'assign', 'blindmarking', '0', NULL),
(737, 2, 1698644927, 'assign', 'blindmarking_adv', '', NULL),
(738, 2, 1698644927, 'assign', 'blindmarking_locked', '', NULL),
(739, 2, 1698644927, 'assign', 'hidegrader', '0', NULL),
(740, 2, 1698644927, 'assign', 'hidegrader_adv', '', NULL),
(741, 2, 1698644927, 'assign', 'hidegrader_locked', '', NULL),
(742, 2, 1698644927, 'assign', 'markingworkflow', '0', NULL),
(743, 2, 1698644927, 'assign', 'markingworkflow_adv', '', NULL),
(744, 2, 1698644927, 'assign', 'markingworkflow_locked', '', NULL),
(745, 2, 1698644927, 'assign', 'markingallocation', '0', NULL),
(746, 2, 1698644927, 'assign', 'markingallocation_adv', '', NULL),
(747, 2, 1698644927, 'assign', 'markingallocation_locked', '', NULL),
(748, 2, 1698644927, 'assignsubmission_file', 'default', '1', NULL),
(749, 2, 1698644927, 'assignsubmission_file', 'maxfiles', '20', NULL),
(750, 2, 1698644927, 'assignsubmission_file', 'filetypes', '', NULL),
(751, 2, 1698644927, 'assignsubmission_file', 'maxbytes', '0', NULL),
(752, 2, 1698644927, 'assignsubmission_onlinetext', 'default', '0', NULL),
(753, 2, 1698644927, 'assignfeedback_comments', 'default', '1', NULL),
(754, 2, 1698644927, 'assignfeedback_comments', 'inline', '0', NULL),
(755, 2, 1698644927, 'assignfeedback_comments', 'inline_adv', '', NULL),
(756, 2, 1698644927, 'assignfeedback_comments', 'inline_locked', '', NULL),
(757, 2, 1698644927, 'assignfeedback_editpdf', 'default', '1', NULL),
(758, 2, 1698644927, 'assignfeedback_editpdf', 'stamps', '', NULL),
(759, 2, 1698644927, 'assignfeedback_file', 'default', '0', NULL),
(760, 2, 1698644927, 'assignfeedback_offline', 'default', '0', NULL),
(761, 2, 1698644927, NULL, 'bigbluebuttonbn_default_dpa_accepted', '0', NULL),
(762, 2, 1698644927, NULL, 'bigbluebuttonbn_server_url', 'https://test-moodle.blindsidenetworks.com/bigbluebutton/', NULL),
(763, 2, 1698644927, NULL, 'bigbluebuttonbn_shared_secret', '********', NULL),
(764, 2, 1698644927, NULL, 'bigbluebuttonbn_checksum_algorithm', 'SHA1', NULL),
(765, 2, 1698644927, NULL, 'bigbluebuttonbn_poll_interval', '5', NULL),
(766, 2, 1698644927, NULL, 'bigbluebuttonbn_welcome_default', '', NULL),
(767, 2, 1698644927, NULL, 'bigbluebuttonbn_welcome_editable', '1', NULL),
(768, 2, 1698644927, NULL, 'bigbluebuttonbn_recording_default', '1', NULL),
(769, 2, 1698644927, NULL, 'bigbluebuttonbn_recording_refresh_period', '300', NULL),
(770, 2, 1698644927, NULL, 'bigbluebuttonbn_recording_editable', '1', NULL),
(771, 2, 1698644927, NULL, 'bigbluebuttonbn_recording_all_from_start_default', '0', NULL),
(772, 2, 1698644927, NULL, 'bigbluebuttonbn_recording_all_from_start_editable', '0', NULL),
(773, 2, 1698644927, NULL, 'bigbluebuttonbn_recording_hide_button_default', '0', NULL),
(774, 2, 1698644927, NULL, 'bigbluebuttonbn_recording_hide_button_editable', '0', NULL),
(775, 2, 1698644927, NULL, 'bigbluebuttonbn_recording_safe_formats', 'video,presentation', NULL),
(776, 2, 1698644927, NULL, 'bigbluebuttonbn_importrecordings_enabled', '0', NULL),
(777, 2, 1698644927, NULL, 'bigbluebuttonbn_importrecordings_from_deleted_enabled', '0', NULL),
(778, 2, 1698644927, NULL, 'bigbluebuttonbn_recordings_deleted_default', '1', NULL),
(779, 2, 1698644927, NULL, 'bigbluebuttonbn_recordings_deleted_editable', '0', NULL),
(780, 2, 1698644927, NULL, 'bigbluebuttonbn_recordings_imported_default', '0', NULL),
(781, 2, 1698644927, NULL, 'bigbluebuttonbn_recordings_imported_editable', '1', NULL),
(782, 2, 1698644927, NULL, 'bigbluebuttonbn_recordings_preview_default', '1', NULL),
(783, 2, 1698644927, NULL, 'bigbluebuttonbn_recordings_preview_editable', '0', NULL),
(784, 2, 1698644927, NULL, 'bigbluebuttonbn_recordings_asc_sort', '0', NULL),
(785, 2, 1698644927, NULL, 'bigbluebuttonbn_recording_protect_editable', '1', NULL),
(786, 2, 1698644927, NULL, 'bigbluebuttonbn_waitformoderator_default', '0', NULL),
(787, 2, 1698644927, NULL, 'bigbluebuttonbn_waitformoderator_editable', '1', NULL),
(788, 2, 1698644927, NULL, 'bigbluebuttonbn_waitformoderator_ping_interval', '10', NULL),
(789, 2, 1698644927, NULL, 'bigbluebuttonbn_waitformoderator_cache_ttl', '60', NULL),
(790, 2, 1698644927, NULL, 'bigbluebuttonbn_voicebridge_editable', '0', NULL),
(791, 2, 1698644927, NULL, 'bigbluebuttonbn_preuploadpresentation_editable', '0', NULL),
(792, 2, 1698644927, 'mod_bigbluebuttonbn', 'presentationdefault', '', NULL),
(793, 2, 1698644927, NULL, 'bigbluebuttonbn_userlimit_default', '0', NULL),
(794, 2, 1698644927, NULL, 'bigbluebuttonbn_userlimit_editable', '0', NULL),
(795, 2, 1698644927, NULL, 'bigbluebuttonbn_participant_moderator_default', '0', NULL),
(796, 2, 1698644927, NULL, 'bigbluebuttonbn_muteonstart_default', '0', NULL),
(797, 2, 1698644927, NULL, 'bigbluebuttonbn_muteonstart_editable', '0', NULL),
(798, 2, 1698644927, NULL, 'bigbluebuttonbn_disablecam_default', '0', NULL),
(799, 2, 1698644927, NULL, 'bigbluebuttonbn_disablecam_editable', '1', NULL),
(800, 2, 1698644927, NULL, 'bigbluebuttonbn_disablemic_default', '0', NULL),
(801, 2, 1698644927, NULL, 'bigbluebuttonbn_disablemic_editable', '1', NULL),
(802, 2, 1698644927, NULL, 'bigbluebuttonbn_disableprivatechat_default', '0', NULL),
(803, 2, 1698644927, NULL, 'bigbluebuttonbn_disableprivatechat_editable', '1', NULL),
(804, 2, 1698644927, NULL, 'bigbluebuttonbn_disablepublicchat_default', '0', NULL),
(805, 2, 1698644927, NULL, 'bigbluebuttonbn_disablepublicchat_editable', '1', NULL),
(806, 2, 1698644927, NULL, 'bigbluebuttonbn_disablenote_default', '0', NULL),
(807, 2, 1698644927, NULL, 'bigbluebuttonbn_disablenote_editable', '1', NULL),
(808, 2, 1698644927, NULL, 'bigbluebuttonbn_hideuserlist_default', '0', NULL),
(809, 2, 1698644927, NULL, 'bigbluebuttonbn_hideuserlist_editable', '1', NULL),
(810, 2, 1698644927, NULL, 'bigbluebuttonbn_recordingready_enabled', '0', NULL),
(811, 2, 1698644927, NULL, 'bigbluebuttonbn_profile_picture_enabled', '0', NULL),
(812, 2, 1698644927, NULL, 'bigbluebuttonbn_meetingevents_enabled', '0', NULL),
(813, 2, 1698644927, NULL, 'bigbluebuttonbn_guestaccess_enabled', '0', NULL),
(814, 2, 1698644927, 'book', 'numberingoptions', '0,1,2,3', NULL),
(815, 2, 1698644927, 'book', 'numbering', '1', NULL),
(816, 2, 1698644927, NULL, 'chat_method', 'ajax', NULL),
(817, 2, 1698644927, NULL, 'chat_refresh_userlist', '10', NULL),
(818, 2, 1698644927, NULL, 'chat_old_ping', '35', NULL),
(819, 2, 1698644927, NULL, 'chat_refresh_room', '5', NULL),
(820, 2, 1698644927, NULL, 'chat_normal_updatemode', 'jsupdate', NULL),
(821, 2, 1698644927, NULL, 'chat_serverhost', 'astitt.tech', NULL),
(822, 2, 1698644927, NULL, 'chat_serverip', '127.0.0.1', NULL),
(823, 2, 1698644927, NULL, 'chat_serverport', '9111', NULL),
(824, 2, 1698644927, NULL, 'chat_servermax', '100', NULL),
(825, 2, 1698644927, NULL, 'data_enablerssfeeds', '0', NULL),
(826, 2, 1698644927, NULL, 'feedback_allowfullanonymous', '0', NULL),
(827, 2, 1698644927, 'resource', 'framesize', '130', NULL),
(828, 2, 1698644927, 'resource', 'displayoptions', '0,1,4,5,6', NULL),
(829, 2, 1698644927, 'resource', 'printintro', '1', NULL),
(830, 2, 1698644927, 'resource', 'display', '0', NULL),
(831, 2, 1698644927, 'resource', 'showsize', '0', NULL),
(832, 2, 1698644927, 'resource', 'showtype', '1', NULL),
(833, 2, 1698644927, 'resource', 'showdate', '0', NULL),
(834, 2, 1698644927, 'resource', 'popupwidth', '620', NULL),
(835, 2, 1698644927, 'resource', 'popupheight', '450', NULL),
(836, 2, 1698644927, 'resource', 'filterfiles', '0', NULL),
(837, 2, 1698644927, 'folder', 'showexpanded', '1', NULL),
(838, 2, 1698644927, 'folder', 'maxsizetodownload', '0', NULL),
(839, 2, 1698644927, NULL, 'forum_displaymode', '3', NULL),
(840, 2, 1698644927, NULL, 'forum_shortpost', '300', NULL),
(841, 2, 1698644927, NULL, 'forum_longpost', '600', NULL),
(842, 2, 1698644927, NULL, 'forum_manydiscussions', '100', NULL),
(843, 2, 1698644927, NULL, 'forum_maxbytes', '512000', NULL),
(844, 2, 1698644927, NULL, 'forum_maxattachments', '9', NULL),
(845, 2, 1698644927, NULL, 'forum_subscription', '0', NULL),
(846, 2, 1698644927, NULL, 'forum_trackingtype', '1', NULL),
(847, 2, 1698644927, NULL, 'forum_trackreadposts', '1', NULL),
(848, 2, 1698644927, NULL, 'forum_allowforcedreadtracking', '0', NULL),
(849, 2, 1698644927, NULL, 'forum_oldpostdays', '14', NULL),
(850, 2, 1698644927, NULL, 'forum_usermarksread', '0', NULL),
(851, 2, 1698644927, NULL, 'forum_cleanreadtime', '2', NULL),
(852, 2, 1698644927, NULL, 'digestmailtime', '17', NULL),
(853, 2, 1698644927, NULL, 'forum_enablerssfeeds', '0', NULL),
(854, 2, 1698644927, NULL, 'forum_enabletimedposts', '1', NULL),
(855, 2, 1698644927, NULL, 'glossary_entbypage', '10', NULL),
(856, 2, 1698644927, NULL, 'glossary_dupentries', '0', NULL),
(857, 2, 1698644927, NULL, 'glossary_allowcomments', '0', NULL),
(858, 2, 1698644927, NULL, 'glossary_linkbydefault', '1', NULL),
(859, 2, 1698644927, NULL, 'glossary_defaultapproval', '1', NULL),
(860, 2, 1698644927, NULL, 'glossary_enablerssfeeds', '0', NULL),
(861, 2, 1698644927, NULL, 'glossary_linkentries', '0', NULL),
(862, 2, 1698644927, NULL, 'glossary_casesensitive', '0', NULL),
(863, 2, 1698644927, NULL, 'glossary_fullmatch', '0', NULL),
(864, 2, 1698644927, 'mod_h5pactivity', 'enablesavestate', '1', NULL),
(865, 2, 1698644927, 'mod_h5pactivity', 'savestatefreq', '60', NULL),
(866, 2, 1698644927, 'imscp', 'keepold', '1', NULL),
(867, 2, 1698644927, 'imscp', 'keepold_adv', '', NULL),
(868, 2, 1698644927, 'mod_lesson', 'mediafile', '', NULL),
(869, 2, 1698644927, 'mod_lesson', 'mediafile_adv', '1', NULL),
(870, 2, 1698644927, 'mod_lesson', 'mediawidth', '640', NULL),
(871, 2, 1698644927, 'mod_lesson', 'mediaheight', '480', NULL),
(872, 2, 1698644927, 'mod_lesson', 'mediaclose', '0', NULL),
(873, 2, 1698644927, 'mod_lesson', 'progressbar', '0', NULL),
(874, 2, 1698644927, 'mod_lesson', 'progressbar_adv', '', NULL),
(875, 2, 1698644927, 'mod_lesson', 'ongoing', '0', NULL),
(876, 2, 1698644927, 'mod_lesson', 'ongoing_adv', '1', NULL),
(877, 2, 1698644927, 'mod_lesson', 'displayleftmenu', '0', NULL),
(878, 2, 1698644927, 'mod_lesson', 'displayleftmenu_adv', '', NULL),
(879, 2, 1698644927, 'mod_lesson', 'displayleftif', '0', NULL),
(880, 2, 1698644927, 'mod_lesson', 'displayleftif_adv', '1', NULL),
(881, 2, 1698644927, 'mod_lesson', 'slideshow', '0', NULL),
(882, 2, 1698644927, 'mod_lesson', 'slideshow_adv', '1', NULL),
(883, 2, 1698644927, 'mod_lesson', 'slideshowwidth', '640', NULL),
(884, 2, 1698644927, 'mod_lesson', 'slideshowheight', '480', NULL),
(885, 2, 1698644927, 'mod_lesson', 'slideshowbgcolor', '#FFFFFF', NULL),
(886, 2, 1698644927, 'mod_lesson', 'maxanswers', '5', NULL),
(887, 2, 1698644927, 'mod_lesson', 'maxanswers_adv', '1', NULL),
(888, 2, 1698644927, 'mod_lesson', 'defaultfeedback', '0', NULL),
(889, 2, 1698644927, 'mod_lesson', 'defaultfeedback_adv', '1', NULL),
(890, 2, 1698644927, 'mod_lesson', 'activitylink', '', NULL),
(891, 2, 1698644927, 'mod_lesson', 'activitylink_adv', '1', NULL),
(892, 2, 1698644927, 'mod_lesson', 'timelimit', '0', NULL),
(893, 2, 1698644927, 'mod_lesson', 'timelimit_adv', '', NULL),
(894, 2, 1698644927, 'mod_lesson', 'password', '0', NULL),
(895, 2, 1698644927, 'mod_lesson', 'password_adv', '1', NULL),
(896, 2, 1698644927, 'mod_lesson', 'modattempts', '0', NULL),
(897, 2, 1698644927, 'mod_lesson', 'modattempts_adv', '', NULL),
(898, 2, 1698644927, 'mod_lesson', 'displayreview', '0', NULL),
(899, 2, 1698644927, 'mod_lesson', 'displayreview_adv', '', NULL),
(900, 2, 1698644927, 'mod_lesson', 'maximumnumberofattempts', '1', NULL),
(901, 2, 1698644927, 'mod_lesson', 'maximumnumberofattempts_adv', '', NULL),
(902, 2, 1698644927, 'mod_lesson', 'defaultnextpage', '0', NULL),
(903, 2, 1698644927, 'mod_lesson', 'defaultnextpage_adv', '1', NULL),
(904, 2, 1698644927, 'mod_lesson', 'numberofpagestoshow', '1', NULL),
(905, 2, 1698644927, 'mod_lesson', 'numberofpagestoshow_adv', '1', NULL),
(906, 2, 1698644927, 'mod_lesson', 'practice', '0', NULL),
(907, 2, 1698644927, 'mod_lesson', 'practice_adv', '', NULL),
(908, 2, 1698644927, 'mod_lesson', 'customscoring', '1', NULL),
(909, 2, 1698644927, 'mod_lesson', 'customscoring_adv', '1', NULL),
(910, 2, 1698644927, 'mod_lesson', 'retakesallowed', '0', NULL),
(911, 2, 1698644927, 'mod_lesson', 'retakesallowed_adv', '', NULL),
(912, 2, 1698644927, 'mod_lesson', 'handlingofretakes', '0', NULL),
(913, 2, 1698644927, 'mod_lesson', 'handlingofretakes_adv', '1', NULL),
(914, 2, 1698644927, 'mod_lesson', 'minimumnumberofquestions', '0', NULL),
(915, 2, 1698644927, 'mod_lesson', 'minimumnumberofquestions_adv', '1', NULL),
(916, 2, 1698644927, 'page', 'displayoptions', '5', NULL),
(917, 2, 1698644927, 'page', 'printintro', '0', NULL),
(918, 2, 1698644927, 'page', 'printlastmodified', '1', NULL),
(919, 2, 1698644927, 'page', 'display', '5', NULL),
(920, 2, 1698644927, 'page', 'popupwidth', '620', NULL),
(921, 2, 1698644927, 'page', 'popupheight', '450', NULL),
(922, 2, 1698644927, 'quiz', 'timelimit', '0', NULL),
(923, 2, 1698644927, 'quiz', 'timelimit_adv', '', NULL),
(924, 2, 1698644927, 'quiz', 'timelimit_locked', '', NULL),
(925, 2, 1698644927, 'quiz', 'notifyattemptgradeddelay', '18000', NULL),
(926, 2, 1698644927, 'quiz', 'overduehandling', 'autosubmit', NULL),
(927, 2, 1698644927, 'quiz', 'overduehandling_adv', '', NULL),
(928, 2, 1698644927, 'quiz', 'overduehandling_locked', '', NULL),
(929, 2, 1698644927, 'quiz', 'graceperiod', '86400', NULL),
(930, 2, 1698644927, 'quiz', 'graceperiod_adv', '', NULL),
(931, 2, 1698644927, 'quiz', 'graceperiod_locked', '', NULL),
(932, 2, 1698644927, 'quiz', 'graceperiodmin', '60', NULL),
(933, 2, 1698644927, 'quiz', 'attempts', '0', NULL),
(934, 2, 1698644927, 'quiz', 'attempts_adv', '', NULL),
(935, 2, 1698644927, 'quiz', 'attempts_locked', '', NULL),
(936, 2, 1698644927, 'quiz', 'grademethod', '1', NULL),
(937, 2, 1698644927, 'quiz', 'grademethod_adv', '', NULL),
(938, 2, 1698644927, 'quiz', 'grademethod_locked', '', NULL),
(939, 2, 1698644927, 'quiz', 'maximumgrade', '10', NULL),
(940, 2, 1698644927, 'quiz', 'maximumgrade_locked', '', NULL),
(941, 2, 1698644927, 'quiz', 'questionsperpage', '1', NULL),
(942, 2, 1698644927, 'quiz', 'questionsperpage_adv', '', NULL),
(943, 2, 1698644927, 'quiz', 'questionsperpage_locked', '', NULL),
(944, 2, 1698644927, 'quiz', 'navmethod', 'free', NULL),
(945, 2, 1698644927, 'quiz', 'navmethod_adv', '1', NULL),
(946, 2, 1698644927, 'quiz', 'navmethod_locked', '', NULL),
(947, 2, 1698644927, 'quiz', 'shuffleanswers', '1', NULL),
(948, 2, 1698644927, 'quiz', 'shuffleanswers_adv', '', NULL),
(949, 2, 1698644927, 'quiz', 'shuffleanswers_locked', '', NULL),
(950, 2, 1698644927, 'quiz', 'preferredbehaviour', 'deferredfeedback', NULL),
(951, 2, 1698644927, 'quiz', 'preferredbehaviour_locked', '', NULL),
(952, 2, 1698644927, 'quiz', 'canredoquestions', '0', NULL),
(953, 2, 1698644927, 'quiz', 'canredoquestions_adv', '1', NULL),
(954, 2, 1698644927, 'quiz', 'canredoquestions_locked', '', NULL),
(955, 2, 1698644927, 'quiz', 'attemptonlast', '0', NULL),
(956, 2, 1698644927, 'quiz', 'attemptonlast_adv', '1', NULL),
(957, 2, 1698644927, 'quiz', 'attemptonlast_locked', '', NULL),
(958, 2, 1698644927, 'quiz', 'reviewattempt', '69904', NULL),
(959, 2, 1698644927, 'quiz', 'reviewcorrectness', '69904', NULL),
(960, 2, 1698644927, 'quiz', 'reviewmaxmarks', '69904', NULL),
(961, 2, 1698644927, 'quiz', 'reviewmarks', '69904', NULL),
(962, 2, 1698644927, 'quiz', 'reviewspecificfeedback', '69904', NULL),
(963, 2, 1698644927, 'quiz', 'reviewgeneralfeedback', '69904', NULL),
(964, 2, 1698644927, 'quiz', 'reviewrightanswer', '69904', NULL),
(965, 2, 1698644927, 'quiz', 'reviewoverallfeedback', '4368', NULL),
(966, 2, 1698644927, 'quiz', 'showuserpicture', '0', NULL),
(967, 2, 1698644927, 'quiz', 'showuserpicture_adv', '', NULL),
(968, 2, 1698644927, 'quiz', 'showuserpicture_locked', '', NULL),
(969, 2, 1698644927, 'quiz', 'decimalpoints', '2', NULL),
(970, 2, 1698644927, 'quiz', 'decimalpoints_adv', '', NULL),
(971, 2, 1698644927, 'quiz', 'decimalpoints_locked', '', NULL),
(972, 2, 1698644927, 'quiz', 'questiondecimalpoints', '-1', NULL),
(973, 2, 1698644927, 'quiz', 'questiondecimalpoints_adv', '', NULL),
(974, 2, 1698644927, 'quiz', 'questiondecimalpoints_locked', '', NULL),
(975, 2, 1698644927, 'quiz', 'showblocks', '0', NULL),
(976, 2, 1698644927, 'quiz', 'showblocks_adv', '1', NULL),
(977, 2, 1698644927, 'quiz', 'showblocks_locked', '', NULL),
(978, 2, 1698644927, 'quiz', 'quizpassword', '', NULL),
(979, 2, 1698644927, 'quiz', 'quizpassword_adv', '', NULL),
(980, 2, 1698644927, 'quiz', 'quizpassword_required', '', NULL),
(981, 2, 1698644927, 'quiz', 'quizpassword_locked', '', NULL),
(982, 2, 1698644927, 'quiz', 'subnet', '', NULL),
(983, 2, 1698644927, 'quiz', 'subnet_adv', '1', NULL),
(984, 2, 1698644927, 'quiz', 'subnet_locked', '', NULL),
(985, 2, 1698644927, 'quiz', 'delay1', '0', NULL),
(986, 2, 1698644927, 'quiz', 'delay1_adv', '1', NULL),
(987, 2, 1698644927, 'quiz', 'delay1_locked', '', NULL),
(988, 2, 1698644927, 'quiz', 'delay2', '0', NULL),
(989, 2, 1698644927, 'quiz', 'delay2_adv', '1', NULL),
(990, 2, 1698644927, 'quiz', 'delay2_locked', '', NULL),
(991, 2, 1698644927, 'quiz', 'browsersecurity', '-', NULL),
(992, 2, 1698644927, 'quiz', 'browsersecurity_adv', '1', NULL),
(993, 2, 1698644927, 'quiz', 'browsersecurity_locked', '', NULL),
(994, 2, 1698644927, 'quiz', 'initialnumfeedbacks', '2', NULL),
(995, 2, 1698644927, 'quiz', 'autosaveperiod', '60', NULL),
(996, 2, 1698644927, 'quiz_statistics', 'getstatslocktimeout', '900', NULL),
(997, 2, 1698644927, 'quizaccess_seb', 'autoreconfigureseb', '1', NULL),
(998, 2, 1698644927, 'quizaccess_seb', 'showseblinks', 'seb,http', NULL),
(999, 2, 1698644927, 'quizaccess_seb', 'downloadlink', 'https://safeexambrowser.org/download_en.html', NULL),
(1000, 2, 1698644927, 'quizaccess_seb', 'quizpasswordrequired', '0', NULL),
(1001, 2, 1698644927, 'quizaccess_seb', 'displayblocksbeforestart', '0', NULL),
(1002, 2, 1698644927, 'quizaccess_seb', 'displayblockswhenfinished', '1', NULL),
(1003, 2, 1698644927, 'scorm', 'displaycoursestructure', '0', NULL),
(1004, 2, 1698644927, 'scorm', 'displaycoursestructure_adv', '', NULL),
(1005, 2, 1698644927, 'scorm', 'popup', '0', NULL),
(1006, 2, 1698644927, 'scorm', 'popup_adv', '', NULL),
(1007, 2, 1698644927, 'scorm', 'framewidth', '100', NULL),
(1008, 2, 1698644927, 'scorm', 'framewidth_adv', '1', NULL),
(1009, 2, 1698644927, 'scorm', 'frameheight', '500', NULL),
(1010, 2, 1698644927, 'scorm', 'frameheight_adv', '1', NULL),
(1011, 2, 1698644927, 'scorm', 'winoptgrp_adv', '1', NULL),
(1012, 2, 1698644927, 'scorm', 'scrollbars', '0', NULL),
(1013, 2, 1698644927, 'scorm', 'directories', '0', NULL),
(1014, 2, 1698644927, 'scorm', 'location', '0', NULL),
(1015, 2, 1698644927, 'scorm', 'menubar', '0', NULL),
(1016, 2, 1698644927, 'scorm', 'toolbar', '0', NULL),
(1017, 2, 1698644927, 'scorm', 'status', '0', NULL),
(1018, 2, 1698644927, 'scorm', 'skipview', '0', NULL),
(1019, 2, 1698644927, 'scorm', 'skipview_adv', '1', NULL),
(1020, 2, 1698644927, 'scorm', 'hidebrowse', '0', NULL),
(1021, 2, 1698644927, 'scorm', 'hidebrowse_adv', '1', NULL),
(1022, 2, 1698644927, 'scorm', 'hidetoc', '0', NULL),
(1023, 2, 1698644927, 'scorm', 'hidetoc_adv', '1', NULL),
(1024, 2, 1698644927, 'scorm', 'nav', '1', NULL),
(1025, 2, 1698644927, 'scorm', 'nav_adv', '1', NULL),
(1026, 2, 1698644927, 'scorm', 'navpositionleft', '-100', NULL),
(1027, 2, 1698644927, 'scorm', 'navpositionleft_adv', '1', NULL),
(1028, 2, 1698644927, 'scorm', 'navpositiontop', '-100', NULL),
(1029, 2, 1698644927, 'scorm', 'navpositiontop_adv', '1', NULL),
(1030, 2, 1698644927, 'scorm', 'collapsetocwinsize', '767', NULL),
(1031, 2, 1698644927, 'scorm', 'collapsetocwinsize_adv', '1', NULL),
(1032, 2, 1698644927, 'scorm', 'displayattemptstatus', '1', NULL),
(1033, 2, 1698644927, 'scorm', 'displayattemptstatus_adv', '', NULL),
(1034, 2, 1698644927, 'scorm', 'grademethod', '1', NULL),
(1035, 2, 1698644927, 'scorm', 'maxgrade', '100', NULL),
(1036, 2, 1698644927, 'scorm', 'maxattempt', '0', NULL),
(1037, 2, 1698644927, 'scorm', 'whatgrade', '0', NULL),
(1038, 2, 1698644927, 'scorm', 'forcecompleted', '0', NULL),
(1039, 2, 1698644927, 'scorm', 'forcenewattempt', '0', NULL),
(1040, 2, 1698644927, 'scorm', 'autocommit', '0', NULL),
(1041, 2, 1698644927, 'scorm', 'masteryoverride', '1', NULL),
(1042, 2, 1698644927, 'scorm', 'lastattemptlock', '0', NULL),
(1043, 2, 1698644927, 'scorm', 'auto', '0', NULL),
(1044, 2, 1698644927, 'scorm', 'updatefreq', '0', NULL),
(1045, 2, 1698644927, 'scorm', 'scormstandard', '0', NULL),
(1046, 2, 1698644927, 'scorm', 'allowtypeexternal', '0', NULL),
(1047, 2, 1698644927, 'scorm', 'allowtypelocalsync', '0', NULL),
(1048, 2, 1698644927, 'scorm', 'allowtypeexternalaicc', '0', NULL),
(1049, 2, 1698644927, 'scorm', 'allowaicchacp', '0', NULL),
(1050, 2, 1698644927, 'scorm', 'aicchacptimeout', '30', NULL),
(1051, 2, 1698644927, 'scorm', 'aicchacpkeepsessiondata', '1', NULL),
(1052, 2, 1698644927, 'scorm', 'aiccuserid', '1', NULL),
(1053, 2, 1698644927, 'scorm', 'forcejavascript', '1', NULL),
(1054, 2, 1698644927, 'scorm', 'allowapidebug', '0', NULL),
(1055, 2, 1698644927, 'scorm', 'apidebugmask', '.*', NULL),
(1056, 2, 1698644927, 'scorm', 'protectpackagedownloads', '0', NULL),
(1057, 2, 1698644927, 'label', 'dndmedia', '1', NULL),
(1058, 2, 1698644927, 'label', 'dndresizewidth', '400', NULL),
(1059, 2, 1698644927, 'label', 'dndresizeheight', '400', NULL),
(1060, 2, 1698644927, 'url', 'framesize', '130', NULL),
(1061, 2, 1698644927, 'url', 'secretphrase', '', NULL),
(1062, 2, 1698644927, 'url', 'rolesinparams', '0', NULL),
(1063, 2, 1698644927, 'url', 'displayoptions', '0,1,5,6', NULL),
(1064, 2, 1698644927, 'url', 'printintro', '1', NULL),
(1065, 2, 1698644927, 'url', 'display', '0', NULL),
(1066, 2, 1698644927, 'url', 'popupwidth', '620', NULL),
(1067, 2, 1698644927, 'url', 'popupheight', '450', NULL),
(1068, 2, 1698644927, 'workshop', 'grade', '80', NULL),
(1069, 2, 1698644927, 'workshop', 'gradinggrade', '20', NULL),
(1070, 2, 1698644927, 'workshop', 'gradedecimals', '0', NULL),
(1071, 2, 1698644927, 'workshop', 'maxbytes', '0', NULL),
(1072, 2, 1698644927, 'workshop', 'strategy', 'accumulative', NULL),
(1073, 2, 1698644927, 'workshop', 'examplesmode', '0', NULL),
(1074, 2, 1698644927, 'workshopallocation_random', 'numofreviews', '5', NULL),
(1075, 2, 1698644927, 'workshopform_numerrors', 'grade0', 'No', NULL),
(1076, 2, 1698644927, 'workshopform_numerrors', 'grade1', 'Yes', NULL),
(1077, 2, 1698644927, 'workshopeval_best', 'comparison', '5', NULL),
(1078, 2, 1698644927, 'tool_brickfield', 'analysistype', '0', NULL),
(1079, 2, 1698644927, 'tool_brickfield', 'deletehistoricaldata', '1', NULL),
(1080, 2, 1698644927, 'tool_brickfield', 'batch', '1000', NULL),
(1081, 2, 1698644927, 'tool_brickfield', 'perpage', '50', NULL),
(1082, 2, 1698644927, 'tool_mfa', 'enabled', '0', NULL),
(1083, 2, 1698644927, 'tool_mfa', 'lockout', '10', NULL),
(1084, 2, 1698644927, 'tool_mfa', 'debugmode', '0', NULL),
(1085, 2, 1698644927, 'tool_mfa', 'redir_exclusions', '', NULL),
(1086, 2, 1698644927, 'tool_mfa', 'guidance', '0', NULL),
(1087, 2, 1698644927, 'tool_mfa', 'guidancecontent', '', NULL),
(1088, 2, 1698644927, 'tool_mfa', 'guidancefiles', '', NULL),
(1089, 2, 1698644927, 'factor_admin', 'enabled', '0', NULL),
(1090, 2, 1698644927, 'factor_admin', 'weight', '100', NULL),
(1091, 2, 1698644927, 'factor_auth', 'enabled', '0', NULL),
(1092, 2, 1698644927, 'factor_auth', 'weight', '100', NULL),
(1093, 2, 1698644927, 'factor_auth', 'goodauth', '', NULL),
(1094, 2, 1698644927, 'factor_capability', 'enabled', '0', NULL),
(1095, 2, 1698644927, 'factor_capability', 'weight', '100', NULL),
(1096, 2, 1698644927, 'factor_capability', 'adminpasses', '1', NULL),
(1097, 2, 1698644927, 'factor_cohort', 'enabled', '0', NULL),
(1098, 2, 1698644927, 'factor_cohort', 'weight', '100', NULL),
(1099, 2, 1698644927, 'factor_email', 'enabled', '0', NULL),
(1100, 2, 1698644927, 'factor_email', 'weight', '100', NULL),
(1101, 2, 1698644927, 'factor_email', 'duration', '1800', NULL),
(1102, 2, 1698644927, 'factor_email', 'suspend', '0', NULL),
(1103, 2, 1698644927, 'factor_grace', 'enabled', '0', NULL),
(1104, 2, 1698644927, 'factor_grace', 'weight', '100', NULL),
(1105, 2, 1698644927, 'factor_grace', 'forcesetup', '0', NULL),
(1106, 2, 1698644927, 'factor_grace', 'graceperiod', '604800', NULL),
(1107, 2, 1698644927, 'factor_grace', 'ignorelist', '', NULL),
(1108, 2, 1698644927, 'factor_grace', 'customwarning', '', NULL),
(1109, 2, 1698644927, 'factor_iprange', 'enabled', '0', NULL),
(1110, 2, 1698644927, 'factor_iprange', 'weight', '100', NULL),
(1111, 2, 1698644927, 'factor_iprange', 'safeips', '', NULL),
(1112, 2, 1698644927, 'factor_nosetup', 'enabled', '0', NULL),
(1113, 2, 1698644927, 'factor_nosetup', 'weight', '100', NULL),
(1114, 2, 1698644927, 'factor_role', 'enabled', '0', NULL),
(1115, 2, 1698644927, 'factor_role', 'weight', '100', NULL),
(1116, 2, 1698644927, 'factor_role', 'roles', 'admin', NULL),
(1117, 2, 1698644927, 'factor_token', 'enabled', '0', NULL),
(1118, 2, 1698644927, 'factor_token', 'weight', '100', NULL),
(1119, 2, 1698644927, 'factor_token', 'expiry', '86400', NULL),
(1120, 2, 1698644927, 'factor_token', 'expireovernight', '1', NULL),
(1121, 2, 1698644927, 'factor_totp', 'enabled', '0', NULL),
(1122, 2, 1698644927, 'factor_totp', 'weight', '100', NULL),
(1123, 2, 1698644927, 'factor_totp', 'window', '30', NULL),
(1124, 2, 1698644927, 'factor_totp', 'totplink', '1', NULL),
(1125, 2, 1698644927, 'factor_webauthn', 'enabled', '0', NULL),
(1126, 2, 1698644927, 'factor_webauthn', 'weight', '100', NULL),
(1127, 2, 1698644927, 'factor_webauthn', 'authenticatortypes', 'usb,nfc,ble,hybrid,internal', NULL);
INSERT INTO `mdlxd_config_log` VALUES
(1128, 2, 1698644927, 'factor_webauthn', 'userverification', 'preferred', NULL),
(1129, 2, 1698644927, 'tool_recyclebin', 'coursebinenable', '1', NULL),
(1130, 2, 1698644927, 'tool_recyclebin', 'coursebinexpiry', '604800', NULL),
(1131, 2, 1698644927, 'tool_recyclebin', 'categorybinenable', '1', NULL),
(1132, 2, 1698644927, 'tool_recyclebin', 'categorybinexpiry', '604800', NULL),
(1133, 2, 1698644927, 'tool_recyclebin', 'autohide', '1', NULL),
(1134, 2, 1698644927, 'antivirus_clamav', 'runningmethod', 'commandline', NULL),
(1135, 2, 1698644927, 'antivirus_clamav', 'pathtoclam', '', NULL),
(1136, 2, 1698644927, 'antivirus_clamav', 'pathtounixsocket', '', NULL),
(1137, 2, 1698644927, 'antivirus_clamav', 'tcpsockethost', '', NULL),
(1138, 2, 1698644927, 'antivirus_clamav', 'tcpsocketport', '3310', NULL),
(1139, 2, 1698644927, 'antivirus_clamav', 'clamfailureonupload', 'tryagain', NULL),
(1140, 2, 1698644927, 'antivirus_clamav', 'tries', '1', NULL),
(1141, 2, 1698644927, 'auth_cas', 'auth_name', 'CAS', NULL),
(1142, 2, 1698644927, 'auth_cas', 'auth_logo', '', NULL),
(1143, 2, 1698644927, 'auth_cas', 'hostname', '', NULL),
(1144, 2, 1698644927, 'auth_cas', 'baseuri', '', NULL),
(1145, 2, 1698644927, 'auth_cas', 'port', '0', NULL),
(1146, 2, 1698644927, 'auth_cas', 'casversion', '2.0', NULL),
(1147, 2, 1698644927, 'auth_cas', 'language', 'CAS_Languages_English', NULL),
(1148, 2, 1698644927, 'auth_cas', 'proxycas', '0', NULL),
(1149, 2, 1698644927, 'auth_cas', 'logoutcas', '0', NULL),
(1150, 2, 1698644927, 'auth_cas', 'multiauth', '0', NULL),
(1151, 2, 1698644927, 'auth_cas', 'certificate_check', '0', NULL),
(1152, 2, 1698644927, 'auth_cas', 'certificate_path', '', NULL),
(1153, 2, 1698644927, 'auth_cas', 'curl_ssl_version', '', NULL),
(1154, 2, 1698644927, 'auth_cas', 'logout_return_url', '', NULL),
(1155, 2, 1698644927, 'auth_cas', 'host_url', '', NULL),
(1156, 2, 1698644927, 'auth_cas', 'ldap_version', '3', NULL),
(1157, 2, 1698644927, 'auth_cas', 'start_tls', '0', NULL),
(1158, 2, 1698644927, 'auth_cas', 'ldapencoding', 'utf-8', NULL),
(1159, 2, 1698644927, 'auth_cas', 'pagesize', '250', NULL),
(1160, 2, 1698644927, 'auth_cas', 'bind_dn', '', NULL),
(1161, 2, 1698644927, 'auth_cas', 'bind_pw', '', NULL),
(1162, 2, 1698644927, 'auth_cas', 'user_type', 'default', NULL),
(1163, 2, 1698644927, 'auth_cas', 'contexts', '', NULL),
(1164, 2, 1698644927, 'auth_cas', 'search_sub', '0', NULL),
(1165, 2, 1698644927, 'auth_cas', 'opt_deref', '0', NULL),
(1166, 2, 1698644927, 'auth_cas', 'user_attribute', '', NULL),
(1167, 2, 1698644927, 'auth_cas', 'memberattribute', '', NULL),
(1168, 2, 1698644927, 'auth_cas', 'memberattribute_isdn', '0', NULL),
(1169, 2, 1698644927, 'auth_cas', 'objectclass', '', NULL),
(1170, 2, 1698644927, 'auth_cas', 'attrcreators', '', NULL),
(1171, 2, 1698644927, 'auth_cas', 'groupecreators', '', NULL),
(1172, 2, 1698644927, 'auth_cas', 'removeuser', '0', NULL),
(1173, 2, 1698644927, 'auth_cas', 'field_map_firstname', '', NULL),
(1174, 2, 1698644927, 'auth_cas', 'field_updatelocal_firstname', 'oncreate', NULL),
(1175, 2, 1698644927, 'auth_cas', 'field_updateremote_firstname', '0', NULL),
(1176, 2, 1698644927, 'auth_cas', 'field_lock_firstname', 'unlocked', NULL),
(1177, 2, 1698644927, 'auth_cas', 'field_map_lastname', '', NULL),
(1178, 2, 1698644927, 'auth_cas', 'field_updatelocal_lastname', 'oncreate', NULL),
(1179, 2, 1698644927, 'auth_cas', 'field_updateremote_lastname', '0', NULL),
(1180, 2, 1698644927, 'auth_cas', 'field_lock_lastname', 'unlocked', NULL),
(1181, 2, 1698644927, 'auth_cas', 'field_map_email', '', NULL),
(1182, 2, 1698644927, 'auth_cas', 'field_updatelocal_email', 'oncreate', NULL),
(1183, 2, 1698644927, 'auth_cas', 'field_updateremote_email', '0', NULL),
(1184, 2, 1698644927, 'auth_cas', 'field_lock_email', 'unlocked', NULL),
(1185, 2, 1698644927, 'auth_cas', 'field_map_city', '', NULL),
(1186, 2, 1698644927, 'auth_cas', 'field_updatelocal_city', 'oncreate', NULL),
(1187, 2, 1698644927, 'auth_cas', 'field_updateremote_city', '0', NULL),
(1188, 2, 1698644927, 'auth_cas', 'field_lock_city', 'unlocked', NULL),
(1189, 2, 1698644927, 'auth_cas', 'field_map_country', '', NULL),
(1190, 2, 1698644927, 'auth_cas', 'field_updatelocal_country', 'oncreate', NULL),
(1191, 2, 1698644927, 'auth_cas', 'field_updateremote_country', '0', NULL),
(1192, 2, 1698644927, 'auth_cas', 'field_lock_country', 'unlocked', NULL),
(1193, 2, 1698644927, 'auth_cas', 'field_map_lang', '', NULL),
(1194, 2, 1698644927, 'auth_cas', 'field_updatelocal_lang', 'oncreate', NULL),
(1195, 2, 1698644927, 'auth_cas', 'field_updateremote_lang', '0', NULL),
(1196, 2, 1698644927, 'auth_cas', 'field_lock_lang', 'unlocked', NULL),
(1197, 2, 1698644927, 'auth_cas', 'field_map_description', '', NULL),
(1198, 2, 1698644927, 'auth_cas', 'field_updatelocal_description', 'oncreate', NULL),
(1199, 2, 1698644927, 'auth_cas', 'field_updateremote_description', '0', NULL),
(1200, 2, 1698644927, 'auth_cas', 'field_lock_description', 'unlocked', NULL),
(1201, 2, 1698644927, 'auth_cas', 'field_map_idnumber', '', NULL),
(1202, 2, 1698644927, 'auth_cas', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1203, 2, 1698644927, 'auth_cas', 'field_updateremote_idnumber', '0', NULL),
(1204, 2, 1698644927, 'auth_cas', 'field_lock_idnumber', 'unlocked', NULL),
(1205, 2, 1698644927, 'auth_cas', 'field_map_institution', '', NULL),
(1206, 2, 1698644927, 'auth_cas', 'field_updatelocal_institution', 'oncreate', NULL),
(1207, 2, 1698644927, 'auth_cas', 'field_updateremote_institution', '0', NULL),
(1208, 2, 1698644927, 'auth_cas', 'field_lock_institution', 'unlocked', NULL),
(1209, 2, 1698644927, 'auth_cas', 'field_map_department', '', NULL),
(1210, 2, 1698644927, 'auth_cas', 'field_updatelocal_department', 'oncreate', NULL),
(1211, 2, 1698644927, 'auth_cas', 'field_updateremote_department', '0', NULL),
(1212, 2, 1698644927, 'auth_cas', 'field_lock_department', 'unlocked', NULL),
(1213, 2, 1698644927, 'auth_cas', 'field_map_phone1', '', NULL),
(1214, 2, 1698644927, 'auth_cas', 'field_updatelocal_phone1', 'oncreate', NULL),
(1215, 2, 1698644927, 'auth_cas', 'field_updateremote_phone1', '0', NULL),
(1216, 2, 1698644927, 'auth_cas', 'field_lock_phone1', 'unlocked', NULL),
(1217, 2, 1698644927, 'auth_cas', 'field_map_phone2', '', NULL),
(1218, 2, 1698644927, 'auth_cas', 'field_updatelocal_phone2', 'oncreate', NULL),
(1219, 2, 1698644927, 'auth_cas', 'field_updateremote_phone2', '0', NULL),
(1220, 2, 1698644927, 'auth_cas', 'field_lock_phone2', 'unlocked', NULL),
(1221, 2, 1698644927, 'auth_cas', 'field_map_address', '', NULL),
(1222, 2, 1698644927, 'auth_cas', 'field_updatelocal_address', 'oncreate', NULL),
(1223, 2, 1698644927, 'auth_cas', 'field_updateremote_address', '0', NULL),
(1224, 2, 1698644927, 'auth_cas', 'field_lock_address', 'unlocked', NULL),
(1225, 2, 1698644927, 'auth_cas', 'field_map_firstnamephonetic', '', NULL),
(1226, 2, 1698644927, 'auth_cas', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1227, 2, 1698644927, 'auth_cas', 'field_updateremote_firstnamephonetic', '0', NULL),
(1228, 2, 1698644927, 'auth_cas', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1229, 2, 1698644927, 'auth_cas', 'field_map_lastnamephonetic', '', NULL),
(1230, 2, 1698644927, 'auth_cas', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1231, 2, 1698644927, 'auth_cas', 'field_updateremote_lastnamephonetic', '0', NULL),
(1232, 2, 1698644927, 'auth_cas', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1233, 2, 1698644927, 'auth_cas', 'field_map_middlename', '', NULL),
(1234, 2, 1698644927, 'auth_cas', 'field_updatelocal_middlename', 'oncreate', NULL),
(1235, 2, 1698644927, 'auth_cas', 'field_updateremote_middlename', '0', NULL),
(1236, 2, 1698644927, 'auth_cas', 'field_lock_middlename', 'unlocked', NULL),
(1237, 2, 1698644927, 'auth_cas', 'field_map_alternatename', '', NULL),
(1238, 2, 1698644927, 'auth_cas', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1239, 2, 1698644927, 'auth_cas', 'field_updateremote_alternatename', '0', NULL),
(1240, 2, 1698644927, 'auth_cas', 'field_lock_alternatename', 'unlocked', NULL),
(1241, 2, 1698644927, 'auth_email', 'recaptcha', '0', NULL),
(1242, 2, 1698644927, 'auth_email', 'field_lock_firstname', 'unlocked', NULL),
(1243, 2, 1698644927, 'auth_email', 'field_lock_lastname', 'unlocked', NULL),
(1244, 2, 1698644927, 'auth_email', 'field_lock_email', 'unlocked', NULL),
(1245, 2, 1698644927, 'auth_email', 'field_lock_city', 'unlocked', NULL),
(1246, 2, 1698644927, 'auth_email', 'field_lock_country', 'unlocked', NULL),
(1247, 2, 1698644927, 'auth_email', 'field_lock_lang', 'unlocked', NULL),
(1248, 2, 1698644927, 'auth_email', 'field_lock_description', 'unlocked', NULL),
(1249, 2, 1698644927, 'auth_email', 'field_lock_idnumber', 'unlocked', NULL),
(1250, 2, 1698644927, 'auth_email', 'field_lock_institution', 'unlocked', NULL),
(1251, 2, 1698644927, 'auth_email', 'field_lock_department', 'unlocked', NULL),
(1252, 2, 1698644927, 'auth_email', 'field_lock_phone1', 'unlocked', NULL),
(1253, 2, 1698644927, 'auth_email', 'field_lock_phone2', 'unlocked', NULL),
(1254, 2, 1698644927, 'auth_email', 'field_lock_address', 'unlocked', NULL),
(1255, 2, 1698644927, 'auth_email', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1256, 2, 1698644927, 'auth_email', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1257, 2, 1698644927, 'auth_email', 'field_lock_middlename', 'unlocked', NULL),
(1258, 2, 1698644927, 'auth_email', 'field_lock_alternatename', 'unlocked', NULL),
(1259, 2, 1698644927, 'auth_db', 'host', '127.0.0.1', NULL),
(1260, 2, 1698644927, 'auth_db', 'type', 'mysqli', NULL),
(1261, 2, 1698644927, 'auth_db', 'sybasequoting', '0', NULL),
(1262, 2, 1698644927, 'auth_db', 'name', '', NULL),
(1263, 2, 1698644927, 'auth_db', 'user', '', NULL),
(1264, 2, 1698644927, 'auth_db', 'pass', '', NULL),
(1265, 2, 1698644927, 'auth_db', 'table', '', NULL),
(1266, 2, 1698644927, 'auth_db', 'fielduser', '', NULL),
(1267, 2, 1698644927, 'auth_db', 'fieldpass', '', NULL),
(1268, 2, 1698644927, 'auth_db', 'passtype', 'plaintext', NULL),
(1269, 2, 1698644927, 'auth_db', 'extencoding', 'utf-8', NULL),
(1270, 2, 1698644927, 'auth_db', 'setupsql', '', NULL),
(1271, 2, 1698644927, 'auth_db', 'debugauthdb', '0', NULL),
(1272, 2, 1698644927, 'auth_db', 'changepasswordurl', '', NULL),
(1273, 2, 1698644927, 'auth_db', 'removeuser', '0', NULL),
(1274, 2, 1698644927, 'auth_db', 'updateusers', '0', NULL),
(1275, 2, 1698644927, 'auth_db', 'field_map_firstname', '', NULL),
(1276, 2, 1698644927, 'auth_db', 'field_updatelocal_firstname', 'oncreate', NULL),
(1277, 2, 1698644927, 'auth_db', 'field_updateremote_firstname', '0', NULL),
(1278, 2, 1698644927, 'auth_db', 'field_lock_firstname', 'unlocked', NULL),
(1279, 2, 1698644927, 'auth_db', 'field_map_lastname', '', NULL),
(1280, 2, 1698644927, 'auth_db', 'field_updatelocal_lastname', 'oncreate', NULL),
(1281, 2, 1698644927, 'auth_db', 'field_updateremote_lastname', '0', NULL),
(1282, 2, 1698644927, 'auth_db', 'field_lock_lastname', 'unlocked', NULL),
(1283, 2, 1698644927, 'auth_db', 'field_map_email', '', NULL),
(1284, 2, 1698644927, 'auth_db', 'field_updatelocal_email', 'oncreate', NULL),
(1285, 2, 1698644927, 'auth_db', 'field_updateremote_email', '0', NULL),
(1286, 2, 1698644927, 'auth_db', 'field_lock_email', 'unlocked', NULL),
(1287, 2, 1698644927, 'auth_db', 'field_map_city', '', NULL),
(1288, 2, 1698644927, 'auth_db', 'field_updatelocal_city', 'oncreate', NULL),
(1289, 2, 1698644927, 'auth_db', 'field_updateremote_city', '0', NULL),
(1290, 2, 1698644927, 'auth_db', 'field_lock_city', 'unlocked', NULL),
(1291, 2, 1698644927, 'auth_db', 'field_map_country', '', NULL),
(1292, 2, 1698644927, 'auth_db', 'field_updatelocal_country', 'oncreate', NULL),
(1293, 2, 1698644927, 'auth_db', 'field_updateremote_country', '0', NULL),
(1294, 2, 1698644927, 'auth_db', 'field_lock_country', 'unlocked', NULL),
(1295, 2, 1698644927, 'auth_db', 'field_map_lang', '', NULL),
(1296, 2, 1698644927, 'auth_db', 'field_updatelocal_lang', 'oncreate', NULL),
(1297, 2, 1698644927, 'auth_db', 'field_updateremote_lang', '0', NULL),
(1298, 2, 1698644927, 'auth_db', 'field_lock_lang', 'unlocked', NULL),
(1299, 2, 1698644927, 'auth_db', 'field_map_description', '', NULL),
(1300, 2, 1698644927, 'auth_db', 'field_updatelocal_description', 'oncreate', NULL),
(1301, 2, 1698644927, 'auth_db', 'field_updateremote_description', '0', NULL),
(1302, 2, 1698644927, 'auth_db', 'field_lock_description', 'unlocked', NULL),
(1303, 2, 1698644927, 'auth_db', 'field_map_idnumber', '', NULL),
(1304, 2, 1698644927, 'auth_db', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1305, 2, 1698644927, 'auth_db', 'field_updateremote_idnumber', '0', NULL),
(1306, 2, 1698644927, 'auth_db', 'field_lock_idnumber', 'unlocked', NULL),
(1307, 2, 1698644927, 'auth_db', 'field_map_institution', '', NULL),
(1308, 2, 1698644927, 'auth_db', 'field_updatelocal_institution', 'oncreate', NULL),
(1309, 2, 1698644927, 'auth_db', 'field_updateremote_institution', '0', NULL),
(1310, 2, 1698644927, 'auth_db', 'field_lock_institution', 'unlocked', NULL),
(1311, 2, 1698644927, 'auth_db', 'field_map_department', '', NULL),
(1312, 2, 1698644927, 'auth_db', 'field_updatelocal_department', 'oncreate', NULL),
(1313, 2, 1698644927, 'auth_db', 'field_updateremote_department', '0', NULL),
(1314, 2, 1698644927, 'auth_db', 'field_lock_department', 'unlocked', NULL),
(1315, 2, 1698644927, 'auth_db', 'field_map_phone1', '', NULL),
(1316, 2, 1698644927, 'auth_db', 'field_updatelocal_phone1', 'oncreate', NULL),
(1317, 2, 1698644927, 'auth_db', 'field_updateremote_phone1', '0', NULL),
(1318, 2, 1698644927, 'auth_db', 'field_lock_phone1', 'unlocked', NULL),
(1319, 2, 1698644927, 'auth_db', 'field_map_phone2', '', NULL),
(1320, 2, 1698644927, 'auth_db', 'field_updatelocal_phone2', 'oncreate', NULL),
(1321, 2, 1698644927, 'auth_db', 'field_updateremote_phone2', '0', NULL),
(1322, 2, 1698644927, 'auth_db', 'field_lock_phone2', 'unlocked', NULL),
(1323, 2, 1698644927, 'auth_db', 'field_map_address', '', NULL),
(1324, 2, 1698644927, 'auth_db', 'field_updatelocal_address', 'oncreate', NULL),
(1325, 2, 1698644927, 'auth_db', 'field_updateremote_address', '0', NULL),
(1326, 2, 1698644927, 'auth_db', 'field_lock_address', 'unlocked', NULL),
(1327, 2, 1698644927, 'auth_db', 'field_map_firstnamephonetic', '', NULL),
(1328, 2, 1698644927, 'auth_db', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1329, 2, 1698644927, 'auth_db', 'field_updateremote_firstnamephonetic', '0', NULL),
(1330, 2, 1698644927, 'auth_db', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1331, 2, 1698644927, 'auth_db', 'field_map_lastnamephonetic', '', NULL),
(1332, 2, 1698644927, 'auth_db', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1333, 2, 1698644927, 'auth_db', 'field_updateremote_lastnamephonetic', '0', NULL),
(1334, 2, 1698644927, 'auth_db', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1335, 2, 1698644927, 'auth_db', 'field_map_middlename', '', NULL),
(1336, 2, 1698644927, 'auth_db', 'field_updatelocal_middlename', 'oncreate', NULL),
(1337, 2, 1698644927, 'auth_db', 'field_updateremote_middlename', '0', NULL),
(1338, 2, 1698644927, 'auth_db', 'field_lock_middlename', 'unlocked', NULL),
(1339, 2, 1698644927, 'auth_db', 'field_map_alternatename', '', NULL),
(1340, 2, 1698644927, 'auth_db', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1341, 2, 1698644927, 'auth_db', 'field_updateremote_alternatename', '0', NULL),
(1342, 2, 1698644927, 'auth_db', 'field_lock_alternatename', 'unlocked', NULL),
(1343, 2, 1698644927, 'auth_ldap', 'host_url', '', NULL),
(1344, 2, 1698644927, 'auth_ldap', 'ldap_version', '3', NULL),
(1345, 2, 1698644927, 'auth_ldap', 'start_tls', '0', NULL),
(1346, 2, 1698644927, 'auth_ldap', 'ldapencoding', 'utf-8', NULL),
(1347, 2, 1698644927, 'auth_ldap', 'pagesize', '250', NULL),
(1348, 2, 1698644927, 'auth_ldap', 'preventpassindb', '0', NULL),
(1349, 2, 1698644927, 'auth_ldap', 'bind_dn', '', NULL),
(1350, 2, 1698644927, 'auth_ldap', 'bind_pw', '', NULL),
(1351, 2, 1698644927, 'auth_ldap', 'user_type', 'default', NULL),
(1352, 2, 1698644927, 'auth_ldap', 'contexts', '', NULL),
(1353, 2, 1698644927, 'auth_ldap', 'search_sub', '0', NULL),
(1354, 2, 1698644927, 'auth_ldap', 'opt_deref', '0', NULL),
(1355, 2, 1698644927, 'auth_ldap', 'user_attribute', '', NULL),
(1356, 2, 1698644927, 'auth_ldap', 'suspended_attribute', '', NULL),
(1357, 2, 1698644927, 'auth_ldap', 'memberattribute', '', NULL),
(1358, 2, 1698644927, 'auth_ldap', 'memberattribute_isdn', '0', NULL),
(1359, 2, 1698644927, 'auth_ldap', 'objectclass', '', NULL),
(1360, 2, 1698644927, 'auth_ldap', 'forcechangepassword', '0', NULL),
(1361, 2, 1698644927, 'auth_ldap', 'stdchangepassword', '0', NULL),
(1362, 2, 1698644927, 'auth_ldap', 'passtype', 'plaintext', NULL),
(1363, 2, 1698644927, 'auth_ldap', 'changepasswordurl', '', NULL),
(1364, 2, 1698644927, 'auth_ldap', 'expiration', '0', NULL),
(1365, 2, 1698644927, 'auth_ldap', 'expiration_warning', '', NULL),
(1366, 2, 1698644927, 'auth_ldap', 'expireattr', '', NULL),
(1367, 2, 1698644927, 'auth_ldap', 'gracelogins', '0', NULL),
(1368, 2, 1698644927, 'auth_ldap', 'graceattr', '', NULL),
(1369, 2, 1698644927, 'auth_ldap', 'auth_user_create', '0', NULL),
(1370, 2, 1698644927, 'auth_ldap', 'create_context', '', NULL),
(1371, 2, 1698644927, 'auth_ldap', 'managercontext', '', NULL),
(1372, 2, 1698644927, 'auth_ldap', 'coursecreatorcontext', '', NULL),
(1373, 2, 1698644927, 'auth_ldap', 'removeuser', '0', NULL),
(1374, 2, 1698644927, 'auth_ldap', 'sync_suspended', '0', NULL),
(1375, 2, 1698644927, 'auth_ldap', 'ntlmsso_enabled', '0', NULL),
(1376, 2, 1698644927, 'auth_ldap', 'ntlmsso_subnet', '', NULL),
(1377, 2, 1698644927, 'auth_ldap', 'ntlmsso_ie_fastpath', '0', NULL),
(1378, 2, 1698644927, 'auth_ldap', 'ntlmsso_type', 'ntlm', NULL),
(1379, 2, 1698644927, 'auth_ldap', 'ntlmsso_remoteuserformat', '', NULL),
(1380, 2, 1698644927, 'auth_ldap', 'field_map_firstname', '', NULL),
(1381, 2, 1698644927, 'auth_ldap', 'field_updatelocal_firstname', 'oncreate', NULL),
(1382, 2, 1698644927, 'auth_ldap', 'field_updateremote_firstname', '0', NULL),
(1383, 2, 1698644927, 'auth_ldap', 'field_lock_firstname', 'unlocked', NULL),
(1384, 2, 1698644927, 'auth_ldap', 'field_map_lastname', '', NULL),
(1385, 2, 1698644927, 'auth_ldap', 'field_updatelocal_lastname', 'oncreate', NULL),
(1386, 2, 1698644927, 'auth_ldap', 'field_updateremote_lastname', '0', NULL),
(1387, 2, 1698644927, 'auth_ldap', 'field_lock_lastname', 'unlocked', NULL),
(1388, 2, 1698644927, 'auth_ldap', 'field_map_email', '', NULL),
(1389, 2, 1698644927, 'auth_ldap', 'field_updatelocal_email', 'oncreate', NULL),
(1390, 2, 1698644927, 'auth_ldap', 'field_updateremote_email', '0', NULL),
(1391, 2, 1698644927, 'auth_ldap', 'field_lock_email', 'unlocked', NULL),
(1392, 2, 1698644927, 'auth_ldap', 'field_map_city', '', NULL),
(1393, 2, 1698644927, 'auth_ldap', 'field_updatelocal_city', 'oncreate', NULL),
(1394, 2, 1698644927, 'auth_ldap', 'field_updateremote_city', '0', NULL),
(1395, 2, 1698644927, 'auth_ldap', 'field_lock_city', 'unlocked', NULL),
(1396, 2, 1698644927, 'auth_ldap', 'field_map_country', '', NULL),
(1397, 2, 1698644927, 'auth_ldap', 'field_updatelocal_country', 'oncreate', NULL),
(1398, 2, 1698644927, 'auth_ldap', 'field_updateremote_country', '0', NULL),
(1399, 2, 1698644927, 'auth_ldap', 'field_lock_country', 'unlocked', NULL),
(1400, 2, 1698644927, 'auth_ldap', 'field_map_lang', '', NULL),
(1401, 2, 1698644927, 'auth_ldap', 'field_updatelocal_lang', 'oncreate', NULL),
(1402, 2, 1698644927, 'auth_ldap', 'field_updateremote_lang', '0', NULL),
(1403, 2, 1698644927, 'auth_ldap', 'field_lock_lang', 'unlocked', NULL),
(1404, 2, 1698644927, 'auth_ldap', 'field_map_description', '', NULL),
(1405, 2, 1698644927, 'auth_ldap', 'field_updatelocal_description', 'oncreate', NULL),
(1406, 2, 1698644927, 'auth_ldap', 'field_updateremote_description', '0', NULL),
(1407, 2, 1698644927, 'auth_ldap', 'field_lock_description', 'unlocked', NULL),
(1408, 2, 1698644927, 'auth_ldap', 'field_map_idnumber', '', NULL),
(1409, 2, 1698644927, 'auth_ldap', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1410, 2, 1698644927, 'auth_ldap', 'field_updateremote_idnumber', '0', NULL),
(1411, 2, 1698644927, 'auth_ldap', 'field_lock_idnumber', 'unlocked', NULL),
(1412, 2, 1698644927, 'auth_ldap', 'field_map_institution', '', NULL),
(1413, 2, 1698644927, 'auth_ldap', 'field_updatelocal_institution', 'oncreate', NULL),
(1414, 2, 1698644927, 'auth_ldap', 'field_updateremote_institution', '0', NULL),
(1415, 2, 1698644927, 'auth_ldap', 'field_lock_institution', 'unlocked', NULL),
(1416, 2, 1698644927, 'auth_ldap', 'field_map_department', '', NULL),
(1417, 2, 1698644927, 'auth_ldap', 'field_updatelocal_department', 'oncreate', NULL),
(1418, 2, 1698644927, 'auth_ldap', 'field_updateremote_department', '0', NULL),
(1419, 2, 1698644927, 'auth_ldap', 'field_lock_department', 'unlocked', NULL),
(1420, 2, 1698644927, 'auth_ldap', 'field_map_phone1', '', NULL),
(1421, 2, 1698644927, 'auth_ldap', 'field_updatelocal_phone1', 'oncreate', NULL),
(1422, 2, 1698644927, 'auth_ldap', 'field_updateremote_phone1', '0', NULL),
(1423, 2, 1698644927, 'auth_ldap', 'field_lock_phone1', 'unlocked', NULL),
(1424, 2, 1698644927, 'auth_ldap', 'field_map_phone2', '', NULL),
(1425, 2, 1698644927, 'auth_ldap', 'field_updatelocal_phone2', 'oncreate', NULL),
(1426, 2, 1698644927, 'auth_ldap', 'field_updateremote_phone2', '0', NULL),
(1427, 2, 1698644927, 'auth_ldap', 'field_lock_phone2', 'unlocked', NULL),
(1428, 2, 1698644927, 'auth_ldap', 'field_map_address', '', NULL),
(1429, 2, 1698644927, 'auth_ldap', 'field_updatelocal_address', 'oncreate', NULL),
(1430, 2, 1698644927, 'auth_ldap', 'field_updateremote_address', '0', NULL),
(1431, 2, 1698644927, 'auth_ldap', 'field_lock_address', 'unlocked', NULL),
(1432, 2, 1698644927, 'auth_ldap', 'field_map_firstnamephonetic', '', NULL),
(1433, 2, 1698644927, 'auth_ldap', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1434, 2, 1698644927, 'auth_ldap', 'field_updateremote_firstnamephonetic', '0', NULL),
(1435, 2, 1698644927, 'auth_ldap', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1436, 2, 1698644927, 'auth_ldap', 'field_map_lastnamephonetic', '', NULL),
(1437, 2, 1698644927, 'auth_ldap', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1438, 2, 1698644927, 'auth_ldap', 'field_updateremote_lastnamephonetic', '0', NULL),
(1439, 2, 1698644927, 'auth_ldap', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1440, 2, 1698644927, 'auth_ldap', 'field_map_middlename', '', NULL),
(1441, 2, 1698644927, 'auth_ldap', 'field_updatelocal_middlename', 'oncreate', NULL),
(1442, 2, 1698644927, 'auth_ldap', 'field_updateremote_middlename', '0', NULL),
(1443, 2, 1698644927, 'auth_ldap', 'field_lock_middlename', 'unlocked', NULL),
(1444, 2, 1698644927, 'auth_ldap', 'field_map_alternatename', '', NULL),
(1445, 2, 1698644927, 'auth_ldap', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1446, 2, 1698644927, 'auth_ldap', 'field_updateremote_alternatename', '0', NULL),
(1447, 2, 1698644927, 'auth_ldap', 'field_lock_alternatename', 'unlocked', NULL),
(1448, 2, 1698644927, 'auth_manual', 'expiration', '0', NULL),
(1449, 2, 1698644927, 'auth_manual', 'expirationtime', '30', NULL),
(1450, 2, 1698644927, 'auth_manual', 'expiration_warning', '0', NULL),
(1451, 2, 1698644927, 'auth_manual', 'field_lock_firstname', 'unlocked', NULL),
(1452, 2, 1698644927, 'auth_manual', 'field_lock_lastname', 'unlocked', NULL),
(1453, 2, 1698644927, 'auth_manual', 'field_lock_email', 'unlocked', NULL),
(1454, 2, 1698644927, 'auth_manual', 'field_lock_city', 'unlocked', NULL),
(1455, 2, 1698644927, 'auth_manual', 'field_lock_country', 'unlocked', NULL),
(1456, 2, 1698644927, 'auth_manual', 'field_lock_lang', 'unlocked', NULL),
(1457, 2, 1698644927, 'auth_manual', 'field_lock_description', 'unlocked', NULL),
(1458, 2, 1698644927, 'auth_manual', 'field_lock_idnumber', 'unlocked', NULL),
(1459, 2, 1698644927, 'auth_manual', 'field_lock_institution', 'unlocked', NULL),
(1460, 2, 1698644927, 'auth_manual', 'field_lock_department', 'unlocked', NULL),
(1461, 2, 1698644927, 'auth_manual', 'field_lock_phone1', 'unlocked', NULL),
(1462, 2, 1698644927, 'auth_manual', 'field_lock_phone2', 'unlocked', NULL),
(1463, 2, 1698644927, 'auth_manual', 'field_lock_address', 'unlocked', NULL),
(1464, 2, 1698644927, 'auth_manual', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1465, 2, 1698644927, 'auth_manual', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1466, 2, 1698644927, 'auth_manual', 'field_lock_middlename', 'unlocked', NULL),
(1467, 2, 1698644927, 'auth_manual', 'field_lock_alternatename', 'unlocked', NULL),
(1468, 2, 1698644927, 'auth_mnet', 'rpc_negotiation_timeout', '30', NULL),
(1469, 2, 1698644927, 'auth_none', 'field_lock_firstname', 'unlocked', NULL),
(1470, 2, 1698644927, 'auth_none', 'field_lock_lastname', 'unlocked', NULL),
(1471, 2, 1698644927, 'auth_none', 'field_lock_email', 'unlocked', NULL),
(1472, 2, 1698644927, 'auth_none', 'field_lock_city', 'unlocked', NULL),
(1473, 2, 1698644927, 'auth_none', 'field_lock_country', 'unlocked', NULL),
(1474, 2, 1698644927, 'auth_none', 'field_lock_lang', 'unlocked', NULL),
(1475, 2, 1698644927, 'auth_none', 'field_lock_description', 'unlocked', NULL),
(1476, 2, 1698644927, 'auth_none', 'field_lock_idnumber', 'unlocked', NULL),
(1477, 2, 1698644927, 'auth_none', 'field_lock_institution', 'unlocked', NULL),
(1478, 2, 1698644927, 'auth_none', 'field_lock_department', 'unlocked', NULL),
(1479, 2, 1698644927, 'auth_none', 'field_lock_phone1', 'unlocked', NULL),
(1480, 2, 1698644927, 'auth_none', 'field_lock_phone2', 'unlocked', NULL),
(1481, 2, 1698644927, 'auth_none', 'field_lock_address', 'unlocked', NULL),
(1482, 2, 1698644927, 'auth_none', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1483, 2, 1698644927, 'auth_none', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1484, 2, 1698644927, 'auth_none', 'field_lock_middlename', 'unlocked', NULL),
(1485, 2, 1698644927, 'auth_none', 'field_lock_alternatename', 'unlocked', NULL),
(1486, 2, 1698644927, 'auth_oauth2', 'field_lock_firstname', 'unlocked', NULL),
(1487, 2, 1698644927, 'auth_oauth2', 'field_lock_lastname', 'unlocked', NULL),
(1488, 2, 1698644927, 'auth_oauth2', 'field_lock_email', 'unlocked', NULL),
(1489, 2, 1698644927, 'auth_oauth2', 'field_lock_city', 'unlocked', NULL),
(1490, 2, 1698644927, 'auth_oauth2', 'field_lock_country', 'unlocked', NULL),
(1491, 2, 1698644927, 'auth_oauth2', 'field_lock_lang', 'unlocked', NULL),
(1492, 2, 1698644927, 'auth_oauth2', 'field_lock_description', 'unlocked', NULL),
(1493, 2, 1698644927, 'auth_oauth2', 'field_lock_idnumber', 'unlocked', NULL),
(1494, 2, 1698644927, 'auth_oauth2', 'field_lock_institution', 'unlocked', NULL),
(1495, 2, 1698644927, 'auth_oauth2', 'field_lock_department', 'unlocked', NULL),
(1496, 2, 1698644927, 'auth_oauth2', 'field_lock_phone1', 'unlocked', NULL),
(1497, 2, 1698644927, 'auth_oauth2', 'field_lock_phone2', 'unlocked', NULL),
(1498, 2, 1698644927, 'auth_oauth2', 'field_lock_address', 'unlocked', NULL),
(1499, 2, 1698644927, 'auth_oauth2', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1500, 2, 1698644927, 'auth_oauth2', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1501, 2, 1698644927, 'auth_oauth2', 'field_lock_middlename', 'unlocked', NULL),
(1502, 2, 1698644927, 'auth_oauth2', 'field_lock_alternatename', 'unlocked', NULL),
(1503, 2, 1698644927, 'auth_shibboleth', 'user_attribute', '', NULL),
(1504, 2, 1698644927, 'auth_shibboleth', 'convert_data', '', NULL),
(1505, 2, 1698644927, 'auth_shibboleth', 'alt_login', 'off', NULL),
(1506, 2, 1698644927, 'auth_shibboleth', 'organization_selection', 'urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai', NULL),
(1507, 2, 1698644927, 'auth_shibboleth', 'logout_handler', '', NULL),
(1508, 2, 1698644927, 'auth_shibboleth', 'logout_return_url', '', NULL),
(1509, 2, 1698644927, 'auth_shibboleth', 'login_name', 'Shibboleth Login', NULL),
(1510, 2, 1698644927, 'auth_shibboleth', 'auth_logo', '', NULL),
(1511, 2, 1698644927, 'auth_shibboleth', 'auth_instructions', 'Use the <a href="https://astitt.tech/unilearn/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.', NULL),
(1512, 2, 1698644927, 'auth_shibboleth', 'changepasswordurl', '', NULL),
(1513, 2, 1698644927, 'auth_shibboleth', 'field_map_firstname', '', NULL),
(1514, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_firstname', 'oncreate', NULL),
(1515, 2, 1698644927, 'auth_shibboleth', 'field_lock_firstname', 'unlocked', NULL),
(1516, 2, 1698644927, 'auth_shibboleth', 'field_map_lastname', '', NULL),
(1517, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_lastname', 'oncreate', NULL),
(1518, 2, 1698644927, 'auth_shibboleth', 'field_lock_lastname', 'unlocked', NULL),
(1519, 2, 1698644927, 'auth_shibboleth', 'field_map_email', '', NULL),
(1520, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_email', 'oncreate', NULL),
(1521, 2, 1698644927, 'auth_shibboleth', 'field_lock_email', 'unlocked', NULL),
(1522, 2, 1698644927, 'auth_shibboleth', 'field_map_city', '', NULL),
(1523, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_city', 'oncreate', NULL),
(1524, 2, 1698644927, 'auth_shibboleth', 'field_lock_city', 'unlocked', NULL),
(1525, 2, 1698644927, 'auth_shibboleth', 'field_map_country', '', NULL),
(1526, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_country', 'oncreate', NULL),
(1527, 2, 1698644927, 'auth_shibboleth', 'field_lock_country', 'unlocked', NULL),
(1528, 2, 1698644927, 'auth_shibboleth', 'field_map_lang', '', NULL),
(1529, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_lang', 'oncreate', NULL),
(1530, 2, 1698644927, 'auth_shibboleth', 'field_lock_lang', 'unlocked', NULL),
(1531, 2, 1698644927, 'auth_shibboleth', 'field_map_description', '', NULL),
(1532, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_description', 'oncreate', NULL),
(1533, 2, 1698644927, 'auth_shibboleth', 'field_lock_description', 'unlocked', NULL),
(1534, 2, 1698644927, 'auth_shibboleth', 'field_map_idnumber', '', NULL),
(1535, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1536, 2, 1698644927, 'auth_shibboleth', 'field_lock_idnumber', 'unlocked', NULL),
(1537, 2, 1698644927, 'auth_shibboleth', 'field_map_institution', '', NULL),
(1538, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_institution', 'oncreate', NULL),
(1539, 2, 1698644927, 'auth_shibboleth', 'field_lock_institution', 'unlocked', NULL),
(1540, 2, 1698644927, 'auth_shibboleth', 'field_map_department', '', NULL),
(1541, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_department', 'oncreate', NULL),
(1542, 2, 1698644927, 'auth_shibboleth', 'field_lock_department', 'unlocked', NULL),
(1543, 2, 1698644927, 'auth_shibboleth', 'field_map_phone1', '', NULL),
(1544, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_phone1', 'oncreate', NULL),
(1545, 2, 1698644927, 'auth_shibboleth', 'field_lock_phone1', 'unlocked', NULL),
(1546, 2, 1698644927, 'auth_shibboleth', 'field_map_phone2', '', NULL),
(1547, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_phone2', 'oncreate', NULL),
(1548, 2, 1698644927, 'auth_shibboleth', 'field_lock_phone2', 'unlocked', NULL),
(1549, 2, 1698644927, 'auth_shibboleth', 'field_map_address', '', NULL),
(1550, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_address', 'oncreate', NULL),
(1551, 2, 1698644927, 'auth_shibboleth', 'field_lock_address', 'unlocked', NULL),
(1552, 2, 1698644927, 'auth_shibboleth', 'field_map_firstnamephonetic', '', NULL),
(1553, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1554, 2, 1698644927, 'auth_shibboleth', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1555, 2, 1698644927, 'auth_shibboleth', 'field_map_lastnamephonetic', '', NULL),
(1556, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1557, 2, 1698644927, 'auth_shibboleth', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1558, 2, 1698644927, 'auth_shibboleth', 'field_map_middlename', '', NULL),
(1559, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_middlename', 'oncreate', NULL),
(1560, 2, 1698644927, 'auth_shibboleth', 'field_lock_middlename', 'unlocked', NULL),
(1561, 2, 1698644927, 'auth_shibboleth', 'field_map_alternatename', '', NULL),
(1562, 2, 1698644927, 'auth_shibboleth', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1563, 2, 1698644927, 'auth_shibboleth', 'field_lock_alternatename', 'unlocked', NULL),
(1564, 2, 1698644927, 'block_accessreview', 'whattoshow', 'showboth', NULL),
(1565, 2, 1698644927, 'block_accessreview', 'errordisplay', 'showint', NULL),
(1566, 2, 1698644927, 'block_accessreview', 'toolpage', 'errors', NULL),
(1567, 2, 1698644927, 'block_activity_results', 'config_showbest', '3', NULL),
(1568, 2, 1698644927, 'block_activity_results', 'config_showbest_locked', '', NULL),
(1569, 2, 1698644927, 'block_activity_results', 'config_showworst', '0', NULL),
(1570, 2, 1698644927, 'block_activity_results', 'config_showworst_locked', '', NULL),
(1571, 2, 1698644927, 'block_activity_results', 'config_usegroups', '0', NULL),
(1572, 2, 1698644927, 'block_activity_results', 'config_usegroups_locked', '', NULL),
(1573, 2, 1698644927, 'block_activity_results', 'config_nameformat', '1', NULL),
(1574, 2, 1698644927, 'block_activity_results', 'config_nameformat_locked', '', NULL),
(1575, 2, 1698644927, 'block_activity_results', 'config_gradeformat', '1', NULL),
(1576, 2, 1698644927, 'block_activity_results', 'config_gradeformat_locked', '', NULL),
(1577, 2, 1698644927, 'block_activity_results', 'config_decimalpoints', '2', NULL),
(1578, 2, 1698644927, 'block_activity_results', 'config_decimalpoints_locked', '', NULL),
(1579, 2, 1698644927, 'block_myoverview', 'displaycategories', '1', NULL),
(1580, 2, 1698644927, 'block_myoverview', 'layouts', 'card,list,summary', NULL),
(1581, 2, 1698644927, 'block_myoverview', 'displaygroupingallincludinghidden', '0', NULL),
(1582, 2, 1698644927, 'block_myoverview', 'displaygroupingall', '1', NULL),
(1583, 2, 1698644927, 'block_myoverview', 'displaygroupinginprogress', '1', NULL),
(1584, 2, 1698644927, 'block_myoverview', 'displaygroupingpast', '1', NULL),
(1585, 2, 1698644927, 'block_myoverview', 'displaygroupingfuture', '1', NULL),
(1586, 2, 1698644927, 'block_myoverview', 'displaygroupingcustomfield', '0', NULL),
(1587, 2, 1698644927, 'block_myoverview', 'customfiltergrouping', '', NULL),
(1588, 2, 1698644927, 'block_myoverview', 'displaygroupingfavourites', '1', NULL),
(1589, 2, 1698644927, 'block_myoverview', 'displaygroupinghidden', '1', NULL),
(1590, 2, 1698644927, NULL, 'block_course_list_adminview', 'all', NULL),
(1591, 2, 1698644927, NULL, 'block_course_list_hideallcourseslink', '0', NULL),
(1592, 2, 1698644927, NULL, 'block_online_users_timetosee', '5', NULL),
(1593, 2, 1698644927, NULL, 'block_online_users_onlinestatushiding', '1', NULL),
(1594, 2, 1698644927, 'block_recentlyaccessedcourses', 'displaycategories', '1', NULL),
(1595, 2, 1698644927, NULL, 'block_rss_client_num_entries', '5', NULL),
(1596, 2, 1698644927, NULL, 'block_rss_client_timeout', '30', NULL),
(1597, 2, 1698644927, 'block_section_links', 'numsections1', '22', NULL),
(1598, 2, 1698644927, 'block_section_links', 'incby1', '2', NULL),
(1599, 2, 1698644927, 'block_section_links', 'numsections2', '40', NULL),
(1600, 2, 1698644927, 'block_section_links', 'incby2', '5', NULL),
(1601, 2, 1698644927, 'block_section_links', 'showsectionname', '0', NULL),
(1602, 2, 1698644927, 'block_starredcourses', 'displaycategories', '1', NULL),
(1603, 2, 1698644927, NULL, 'block_html_allowcssclasses', '0', NULL),
(1604, 2, 1698644927, 'block_tag_youtube', 'apikey', '', NULL),
(1605, 2, 1698644927, 'format_singleactivity', 'activitytype', 'forum', NULL),
(1606, 2, 1698644927, 'format_topics', 'indentation', '1', NULL),
(1607, 2, 1698644927, 'format_weeks', 'indentation', '1', NULL),
(1608, 2, 1698644927, 'fileconverter_googledrive', 'issuerid', '', NULL),
(1609, 2, 1698644927, NULL, 'pathtounoconv', '/usr/bin/unoconv', NULL),
(1610, 2, 1698644927, 'enrol_cohort', 'roleid', '5', NULL),
(1611, 2, 1698644927, 'enrol_cohort', 'unenrolaction', '0', NULL),
(1612, 2, 1698644927, 'enrol_meta', 'nosyncroleids', '', NULL),
(1613, 2, 1698644927, 'enrol_meta', 'syncall', '1', NULL),
(1614, 2, 1698644927, 'enrol_meta', 'unenrolaction', '3', NULL),
(1615, 2, 1698644927, 'enrol_meta', 'coursesort', 'sortorder', NULL),
(1616, 2, 1698644927, 'enrol_fee', 'expiredaction', '3', NULL),
(1617, 2, 1698644927, 'enrol_fee', 'status', '1', NULL),
(1618, 2, 1698644927, 'enrol_fee', 'cost', '0', NULL),
(1619, 2, 1698644927, 'enrol_fee', 'currency', 'USD', NULL),
(1620, 2, 1698644927, 'enrol_fee', 'roleid', '5', NULL),
(1621, 2, 1698644927, 'enrol_fee', 'enrolperiod', '0', NULL),
(1622, 2, 1698644927, 'enrol_database', 'dbtype', '', NULL),
(1623, 2, 1698644927, 'enrol_database', 'dbhost', 'localhost', NULL),
(1624, 2, 1698644927, 'enrol_database', 'dbuser', '', NULL),
(1625, 2, 1698644927, 'enrol_database', 'dbpass', '', NULL),
(1626, 2, 1698644927, 'enrol_database', 'dbname', '', NULL),
(1627, 2, 1698644927, 'enrol_database', 'dbencoding', 'utf-8', NULL),
(1628, 2, 1698644927, 'enrol_database', 'dbsetupsql', '', NULL),
(1629, 2, 1698644927, 'enrol_database', 'dbsybasequoting', '0', NULL),
(1630, 2, 1698644927, 'enrol_database', 'debugdb', '0', NULL),
(1631, 2, 1698644927, 'enrol_database', 'localcoursefield', 'idnumber', NULL),
(1632, 2, 1698644927, 'enrol_database', 'localuserfield', 'idnumber', NULL),
(1633, 2, 1698644927, 'enrol_database', 'localrolefield', 'shortname', NULL),
(1634, 2, 1698644927, 'enrol_database', 'localcategoryfield', 'id', NULL),
(1635, 2, 1698644927, 'enrol_database', 'remoteenroltable', '', NULL),
(1636, 2, 1698644927, 'enrol_database', 'remotecoursefield', '', NULL),
(1637, 2, 1698644927, 'enrol_database', 'remoteuserfield', '', NULL),
(1638, 2, 1698644927, 'enrol_database', 'remoterolefield', '', NULL),
(1639, 2, 1698644927, 'enrol_database', 'remoteotheruserfield', '', NULL),
(1640, 2, 1698644927, 'enrol_database', 'defaultrole', '5', NULL),
(1641, 2, 1698644927, 'enrol_database', 'ignorehiddencourses', '0', NULL),
(1642, 2, 1698644927, 'enrol_database', 'unenrolaction', '0', NULL),
(1643, 2, 1698644927, 'enrol_database', 'newcoursetable', '', NULL),
(1644, 2, 1698644927, 'enrol_database', 'newcoursefullname', 'fullname', NULL),
(1645, 2, 1698644927, 'enrol_database', 'newcourseshortname', 'shortname', NULL),
(1646, 2, 1698644927, 'enrol_database', 'newcourseidnumber', 'idnumber', NULL),
(1647, 2, 1698644927, 'enrol_database', 'newcoursecategory', '', NULL),
(1648, 2, 1698644927, 'enrol_database', 'defaultcategory', '1', NULL),
(1649, 2, 1698644927, 'enrol_database', 'templatecourse', '', NULL),
(1650, 2, 1698644927, 'enrol_flatfile', 'location', '', NULL),
(1651, 2, 1698644927, 'enrol_flatfile', 'encoding', 'UTF-8', NULL),
(1652, 2, 1698644927, 'enrol_flatfile', 'mailstudents', '0', NULL),
(1653, 2, 1698644927, 'enrol_flatfile', 'mailteachers', '0', NULL),
(1654, 2, 1698644927, 'enrol_flatfile', 'mailadmins', '0', NULL),
(1655, 2, 1698644927, 'enrol_flatfile', 'unenrolaction', '3', NULL),
(1656, 2, 1698644927, 'enrol_flatfile', 'expiredaction', '3', NULL),
(1657, 2, 1698644927, 'enrol_guest', 'requirepassword', '0', NULL),
(1658, 2, 1698644927, 'enrol_guest', 'usepasswordpolicy', '0', NULL),
(1659, 2, 1698644927, 'enrol_guest', 'showhint', '0', NULL),
(1660, 2, 1698644927, 'enrol_guest', 'defaultenrol', '1', NULL),
(1661, 2, 1698644927, 'enrol_guest', 'status', '1', NULL),
(1662, 2, 1698644927, 'enrol_guest', 'status_adv', '', NULL),
(1663, 2, 1698644927, 'enrol_imsenterprise', 'imsfilelocation', '', NULL),
(1664, 2, 1698644927, 'enrol_imsenterprise', 'logtolocation', '', NULL),
(1665, 2, 1698644927, 'enrol_imsenterprise', 'mailadmins', '0', NULL),
(1666, 2, 1698644927, 'enrol_imsenterprise', 'createnewusers', '0', NULL),
(1667, 2, 1698644927, 'enrol_imsenterprise', 'imsupdateusers', '0', NULL),
(1668, 2, 1698644927, 'enrol_imsenterprise', 'imsdeleteusers', '0', NULL),
(1669, 2, 1698644927, 'enrol_imsenterprise', 'fixcaseusernames', '0', NULL),
(1670, 2, 1698644927, 'enrol_imsenterprise', 'fixcasepersonalnames', '0', NULL),
(1671, 2, 1698644927, 'enrol_imsenterprise', 'imssourcedidfallback', '0', NULL),
(1672, 2, 1698644927, 'enrol_imsenterprise', 'imsrolemap01', '5', NULL),
(1673, 2, 1698644927, 'enrol_imsenterprise', 'imsrolemap02', '3', NULL),
(1674, 2, 1698644927, 'enrol_imsenterprise', 'imsrolemap03', '3', NULL),
(1675, 2, 1698644927, 'enrol_imsenterprise', 'imsrolemap04', '5', NULL),
(1676, 2, 1698644927, 'enrol_imsenterprise', 'imsrolemap05', '0', NULL),
(1677, 2, 1698644927, 'enrol_imsenterprise', 'imsrolemap06', '4', NULL),
(1678, 2, 1698644927, 'enrol_imsenterprise', 'imsrolemap07', '0', NULL),
(1679, 2, 1698644927, 'enrol_imsenterprise', 'imsrolemap08', '4', NULL),
(1680, 2, 1698644927, 'enrol_imsenterprise', 'truncatecoursecodes', '0', NULL),
(1681, 2, 1698644927, 'enrol_imsenterprise', 'createnewcourses', '0', NULL),
(1682, 2, 1698644927, 'enrol_imsenterprise', 'updatecourses', '0', NULL),
(1683, 2, 1698644927, 'enrol_imsenterprise', 'createnewcategories', '0', NULL),
(1684, 2, 1698644927, 'enrol_imsenterprise', 'nestedcategories', '0', NULL),
(1685, 2, 1698644927, 'enrol_imsenterprise', 'categoryidnumber', '0', NULL),
(1686, 2, 1698644927, 'enrol_imsenterprise', 'categoryseparator', '', NULL),
(1687, 2, 1698644927, 'enrol_imsenterprise', 'imsunenrol', '0', NULL),
(1688, 2, 1698644927, 'enrol_imsenterprise', 'unenrolaction', '0', NULL),
(1689, 2, 1698644927, 'enrol_imsenterprise', 'imscoursemapshortname', 'coursecode', NULL),
(1690, 2, 1698644927, 'enrol_imsenterprise', 'imscoursemapfullname', 'short', NULL),
(1691, 2, 1698644927, 'enrol_imsenterprise', 'imscoursemapsummary', 'ignore', NULL),
(1692, 2, 1698644927, 'enrol_imsenterprise', 'imsrestricttarget', '', NULL),
(1693, 2, 1698644927, 'enrol_imsenterprise', 'imscapitafix', '0', NULL),
(1694, 2, 1698644927, 'enrol_ldap', 'host_url', '', NULL),
(1695, 2, 1698644927, 'enrol_ldap', 'start_tls', '0', NULL),
(1696, 2, 1698644927, 'enrol_ldap', 'ldap_version', '3', NULL),
(1697, 2, 1698644927, 'enrol_ldap', 'ldapencoding', 'utf-8', NULL),
(1698, 2, 1698644927, 'enrol_ldap', 'pagesize', '250', NULL),
(1699, 2, 1698644927, 'enrol_ldap', 'bind_dn', '', NULL),
(1700, 2, 1698644927, 'enrol_ldap', 'bind_pw', '', NULL),
(1701, 2, 1698644927, 'enrol_ldap', 'course_search_sub', '0', NULL),
(1702, 2, 1698644927, 'enrol_ldap', 'memberattribute_isdn', '0', NULL),
(1703, 2, 1698644927, 'enrol_ldap', 'user_contexts', '', NULL),
(1704, 2, 1698644927, 'enrol_ldap', 'user_search_sub', '0', NULL),
(1705, 2, 1698644927, 'enrol_ldap', 'user_type', 'default', NULL),
(1706, 2, 1698644927, 'enrol_ldap', 'opt_deref', '0', NULL),
(1707, 2, 1698644927, 'enrol_ldap', 'idnumber_attribute', '', NULL),
(1708, 2, 1698644927, 'enrol_ldap', 'objectclass', '', NULL),
(1709, 2, 1698644927, 'enrol_ldap', 'course_idnumber', '', NULL),
(1710, 2, 1698644927, 'enrol_ldap', 'course_shortname', '', NULL),
(1711, 2, 1698644927, 'enrol_ldap', 'course_fullname', '', NULL),
(1712, 2, 1698644927, 'enrol_ldap', 'course_summary', '', NULL),
(1713, 2, 1698644927, 'enrol_ldap', 'ignorehiddencourses', '0', NULL),
(1714, 2, 1698644927, 'enrol_ldap', 'unenrolaction', '0', NULL),
(1715, 2, 1698644927, 'enrol_ldap', 'autocreate', '0', NULL),
(1716, 2, 1698644927, 'enrol_ldap', 'category', '1', NULL),
(1717, 2, 1698644927, 'enrol_ldap', 'template', '', NULL),
(1718, 2, 1698644927, 'enrol_ldap', 'course_shortname_updateonsync', '0', NULL),
(1719, 2, 1698644927, 'enrol_ldap', 'course_fullname_updateonsync', '0', NULL),
(1720, 2, 1698644927, 'enrol_ldap', 'course_summary_updateonsync', '0', NULL),
(1721, 2, 1698644927, 'enrol_ldap', 'nested_groups', '0', NULL),
(1722, 2, 1698644927, 'enrol_ldap', 'group_memberofattribute', '', NULL),
(1723, 2, 1698644927, 'enrol_manual', 'expiredaction', '1', NULL),
(1724, 2, 1698644927, 'enrol_manual', 'expirynotifyhour', '6', NULL),
(1725, 2, 1698644927, 'enrol_manual', 'defaultenrol', '1', NULL),
(1726, 2, 1698644927, 'enrol_manual', 'status', '0', NULL),
(1727, 2, 1698644927, 'enrol_manual', 'roleid', '5', NULL),
(1728, 2, 1698644927, 'enrol_manual', 'enrolstart', '4', NULL),
(1729, 2, 1698644927, 'enrol_manual', 'enrolperiod', '0', NULL),
(1730, 2, 1698644927, 'enrol_manual', 'expirynotify', '0', NULL),
(1731, 2, 1698644927, 'enrol_manual', 'expirythreshold', '86400', NULL),
(1732, 2, 1698644927, 'enrol_mnet', 'roleid', '5', NULL),
(1733, 2, 1698644927, 'enrol_mnet', 'roleid_adv', '1', NULL),
(1734, 2, 1698644927, 'enrol_paypal', 'paypalbusiness', '', NULL),
(1735, 2, 1698644927, 'enrol_paypal', 'mailstudents', '0', NULL),
(1736, 2, 1698644927, 'enrol_paypal', 'mailteachers', '0', NULL),
(1737, 2, 1698644927, 'enrol_paypal', 'mailadmins', '0', NULL),
(1738, 2, 1698644927, 'enrol_paypal', 'expiredaction', '3', NULL),
(1739, 2, 1698644927, 'enrol_paypal', 'status', '1', NULL),
(1740, 2, 1698644927, 'enrol_paypal', 'cost', '0', NULL),
(1741, 2, 1698644927, 'enrol_paypal', 'currency', 'USD', NULL),
(1742, 2, 1698644927, 'enrol_paypal', 'roleid', '5', NULL),
(1743, 2, 1698644927, 'enrol_paypal', 'enrolperiod', '0', NULL),
(1744, 2, 1698644927, 'enrol_lti', 'emaildisplay', '2', NULL),
(1745, 2, 1698644927, 'enrol_lti', 'city', '', NULL),
(1746, 2, 1698644927, 'enrol_lti', 'country', '', NULL),
(1747, 2, 1698644927, 'enrol_lti', 'timezone', '99', NULL),
(1748, 2, 1698644927, 'enrol_lti', 'lang', 'en', NULL),
(1749, 2, 1698644927, 'enrol_lti', 'institution', '', NULL),
(1750, 2, 1698644927, 'enrol_self', 'requirepassword', '0', NULL),
(1751, 2, 1698644927, 'enrol_self', 'usepasswordpolicy', '0', NULL),
(1752, 2, 1698644927, 'enrol_self', 'showhint', '0', NULL),
(1753, 2, 1698644927, 'enrol_self', 'expiredaction', '1', NULL),
(1754, 2, 1698644927, 'enrol_self', 'expirynotifyhour', '6', NULL),
(1755, 2, 1698644927, 'enrol_self', 'defaultenrol', '1', NULL),
(1756, 2, 1698644927, 'enrol_self', 'status', '1', NULL),
(1757, 2, 1698644927, 'enrol_self', 'newenrols', '1', NULL),
(1758, 2, 1698644927, 'enrol_self', 'groupkey', '0', NULL),
(1759, 2, 1698644927, 'enrol_self', 'roleid', '5', NULL),
(1760, 2, 1698644927, 'enrol_self', 'enrolperiod', '0', NULL),
(1761, 2, 1698644927, 'enrol_self', 'expirynotify', '0', NULL),
(1762, 2, 1698644927, 'enrol_self', 'expirythreshold', '86400', NULL),
(1763, 2, 1698644927, 'enrol_self', 'longtimenosee', '0', NULL),
(1764, 2, 1698644927, 'enrol_self', 'maxenrolled', '0', NULL),
(1765, 2, 1698644927, 'enrol_self', 'sendcoursewelcomemessage', '1', NULL),
(1766, 2, 1698644927, 'filter_urltolink', 'formats', '1,4,0', NULL),
(1767, 2, 1698644927, 'filter_urltolink', 'embedimages', '1', NULL),
(1768, 2, 1698644927, 'filter_emoticon', 'formats', '1,4,0', NULL),
(1769, 2, 1698644927, 'filter_displayh5p', 'allowedsources', '', NULL),
(1770, 2, 1698644927, 'filter_mathjaxloader', 'httpsurl', 'https://cdn.jsdelivr.net/npm/mathjax@2.7.9/MathJax.js', NULL),
(1771, 2, 1698644927, 'filter_mathjaxloader', 'texfiltercompatibility', '0', NULL),
(1772, 2, 1698644927, 'filter_mathjaxloader', 'mathjaxconfig', '\nMathJax.Hub.Config({\n    config: ["Accessible.js", "Safe.js"],\n    errorSettings: { message: ["!"] },\n    skipStartupTypeset: true,\n    messageStyle: "none"\n});\n', NULL),
(1773, 2, 1698644927, 'filter_mathjaxloader', 'additionaldelimiters', '', NULL),
(1774, 2, 1698644927, NULL, 'filter_multilang_force_old', '0', NULL),
(1775, 2, 1698644927, 'filter_tex', 'latexpreamble', '\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n', NULL),
(1776, 2, 1698644927, 'filter_tex', 'latexbackground', '#FFFFFF', NULL),
(1777, 2, 1698644927, 'filter_tex', 'density', '120', NULL),
(1778, 2, 1698644927, 'filter_tex', 'pathlatex', '/usr/bin/latex', NULL),
(1779, 2, 1698644927, 'filter_tex', 'pathdvips', '/usr/bin/dvips', NULL),
(1780, 2, 1698644927, 'filter_tex', 'pathconvert', '/usr/bin/convert', NULL),
(1781, 2, 1698644927, 'filter_tex', 'pathdvisvgm', '/usr/bin/dvisvgm', NULL),
(1782, 2, 1698644927, 'filter_tex', 'pathmimetex', '', NULL),
(1783, 2, 1698644927, 'filter_tex', 'convertformat', 'gif', NULL),
(1784, 2, 1698644927, 'logstore_database', 'dbdriver', '', NULL),
(1785, 2, 1698644927, 'logstore_database', 'dbhost', '', NULL),
(1786, 2, 1698644927, 'logstore_database', 'dbuser', '', NULL),
(1787, 2, 1698644927, 'logstore_database', 'dbpass', '', NULL),
(1788, 2, 1698644927, 'logstore_database', 'dbname', '', NULL),
(1789, 2, 1698644927, 'logstore_database', 'dbtable', '', NULL),
(1790, 2, 1698644927, 'logstore_database', 'dbpersist', '0', NULL),
(1791, 2, 1698644927, 'logstore_database', 'dbsocket', '', NULL),
(1792, 2, 1698644927, 'logstore_database', 'dbport', '', NULL),
(1793, 2, 1698644927, 'logstore_database', 'dbschema', '', NULL),
(1794, 2, 1698644927, 'logstore_database', 'dbcollation', '', NULL),
(1795, 2, 1698644927, 'logstore_database', 'dbhandlesoptions', '0', NULL),
(1796, 2, 1698644927, 'logstore_database', 'buffersize', '50', NULL),
(1797, 2, 1698644927, 'logstore_database', 'jsonformat', '1', NULL),
(1798, 2, 1698644927, 'logstore_database', 'logguests', '0', NULL),
(1799, 2, 1698644927, 'logstore_database', 'includelevels', '1,2,0', NULL),
(1800, 2, 1698644927, 'logstore_database', 'includeactions', 'c,r,u,d', NULL),
(1801, 2, 1698644927, 'logstore_standard', 'logguests', '1', NULL),
(1802, 2, 1698644927, 'logstore_standard', 'jsonformat', '1', NULL),
(1803, 2, 1698644927, 'logstore_standard', 'loglifetime', '0', NULL),
(1804, 2, 1698644927, 'logstore_standard', 'buffersize', '50', NULL),
(1805, 2, 1698644927, 'mlbackend_python', 'useserver', '0', NULL),
(1806, 2, 1698644927, 'mlbackend_python', 'host', '', NULL),
(1807, 2, 1698644927, 'mlbackend_python', 'port', '0', NULL),
(1808, 2, 1698644927, 'mlbackend_python', 'secure', '0', NULL),
(1809, 2, 1698644927, 'mlbackend_python', 'username', 'default', NULL),
(1810, 2, 1698644927, 'mlbackend_python', 'password', '', NULL),
(1811, 2, 1698644927, 'media_videojs', 'videoextensions', 'html_video,media_source,.f4v,.flv', NULL),
(1812, 2, 1698644927, 'media_videojs', 'audioextensions', 'html_audio', NULL),
(1813, 2, 1698644927, 'media_videojs', 'youtube', '1', NULL),
(1814, 2, 1698644927, 'media_videojs', 'videocssclass', 'video-js', NULL),
(1815, 2, 1698644927, 'media_videojs', 'audiocssclass', 'video-js', NULL),
(1816, 2, 1698644927, 'media_videojs', 'limitsize', '1', NULL),
(1817, 2, 1698644927, 'media_vimeo', 'donottrack', '0', NULL),
(1818, 2, 1698644927, 'media_youtube', 'nocookie', '0', NULL),
(1819, 2, 1698644927, 'paygw_paypal', 'surcharge', '0', NULL),
(1820, 2, 1698644927, 'qtype_multichoice', 'answerhowmany', '1', NULL),
(1821, 2, 1698644927, 'qtype_multichoice', 'shuffleanswers', '1', NULL),
(1822, 2, 1698644927, 'qtype_multichoice', 'answernumbering', 'abc', NULL),
(1823, 2, 1698644927, 'qtype_multichoice', 'showstandardinstruction', '0', NULL),
(1824, 2, 1698644927, 'editor_atto', 'toolbar', 'collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist, indent\nlinks = link\nfiles = emojipicker, image, media, recordrtc, managefiles, h5p\naccessibility = accessibilitychecker, accessibilityhelper\nstyle2 = underline, strike, subscript, superscript\nalign = align\ninsert = equation, charmap, table, clear\nundo = undo\nother = html', NULL),
(1825, 2, 1698644927, 'editor_atto', 'autosavefrequency', '60', NULL),
(1826, 2, 1698644927, 'atto_collapse', 'showgroups', '6', NULL),
(1827, 2, 1698644927, 'atto_equation', 'librarygroup1', '\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n', NULL),
(1828, 2, 1698644927, 'atto_equation', 'librarygroup2', '\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n', NULL),
(1829, 2, 1698644927, 'atto_equation', 'librarygroup3', '\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n', NULL),
(1830, 2, 1698644927, 'atto_equation', 'librarygroup4', '\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\\\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n', NULL),
(1831, 2, 1698644927, 'atto_recordrtc', 'allowedtypes', 'both', NULL),
(1832, 2, 1698644927, 'atto_recordrtc', 'audiobitrate', '128000', NULL),
(1833, 2, 1698644927, 'atto_recordrtc', 'videobitrate', '2500000', NULL),
(1834, 2, 1698644927, 'atto_recordrtc', 'audiotimelimit', '120', NULL),
(1835, 2, 1698644927, 'atto_recordrtc', 'videotimelimit', '120', NULL),
(1836, 2, 1698644927, 'atto_table', 'allowborders', '0', NULL),
(1837, 2, 1698644927, 'atto_table', 'allowbackgroundcolour', '0', NULL),
(1838, 2, 1698644927, 'atto_table', 'allowwidth', '0', NULL),
(1839, 2, 1698644927, 'editor_tiny', 'branding', '1', NULL),
(1840, 2, 1698644927, 'tiny_equation', 'librarygroup1', '\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n', NULL),
(1841, 2, 1698644927, 'tiny_equation', 'librarygroup2', '\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n', NULL),
(1842, 2, 1698644927, 'tiny_equation', 'librarygroup3', '\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n', NULL),
(1843, 2, 1698644927, 'tiny_equation', 'librarygroup4', '\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\\\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n', NULL),
(1844, 2, 1698644927, 'tiny_premium', 'apikey', '', NULL),
(1845, 2, 1698644927, 'tiny_recordrtc', 'allowedtypes', 'both', NULL),
(1846, 2, 1698644927, 'tiny_recordrtc', 'audiobitrate', '128000', NULL),
(1847, 2, 1698644927, 'tiny_recordrtc', 'videobitrate', '2500000', NULL),
(1848, 2, 1698644927, 'tiny_recordrtc', 'audiotimelimit', '120', NULL),
(1849, 2, 1698644927, 'tiny_recordrtc', 'videotimelimit', '120', NULL),
(1850, 2, 1698644927, NULL, 'profileroles', '5,4,3', NULL),
(1851, 2, 1698644927, NULL, 'coursecontact', '3', NULL),
(1852, 2, 1698644927, NULL, 'frontpage', '6', NULL),
(1853, 2, 1698644927, NULL, 'frontpageloggedin', '6', NULL),
(1854, 2, 1698644927, NULL, 'maxcategorydepth', '2', NULL),
(1855, 2, 1698644927, NULL, 'frontpagecourselimit', '200', NULL),
(1856, 2, 1698644927, NULL, 'commentsperpage', '15', NULL),
(1857, 2, 1698644927, NULL, 'defaultfrontpageroleid', '8', NULL),
(1858, 2, 1698644927, NULL, 'messageinbound_enabled', '0', NULL),
(1859, 2, 1698644927, NULL, 'messageinbound_mailbox', '', NULL),
(1860, 2, 1698644927, NULL, 'messageinbound_domain', '', NULL),
(1861, 2, 1698644927, NULL, 'messageinbound_host', '', NULL),
(1862, 2, 1698644927, NULL, 'messageinbound_hostssl', 'ssl', NULL),
(1863, 2, 1698644927, NULL, 'messageinbound_hostuser', '', NULL),
(1864, 2, 1698644927, NULL, 'messageinbound_hostpass', '', NULL),
(1865, 2, 1698644927, 'tool_mobile', 'apppolicy', '', NULL),
(1866, 2, 1698644927, 'tool_mobile', 'typeoflogin', '1', NULL),
(1867, 2, 1698644927, 'tool_mobile', 'autologout', '0', NULL),
(1868, 2, 1698644927, 'tool_mobile', 'autologouttime', '86400', NULL),
(1869, 2, 1698644927, 'tool_mobile', 'qrcodetype', '1', NULL),
(1870, 2, 1698644927, 'tool_mobile', 'qrkeyttl', '600', NULL),
(1871, 2, 1698644927, 'tool_mobile', 'qrsameipcheck', '1', NULL),
(1872, 2, 1698644927, 'tool_mobile', 'forcedurlscheme', 'moodlemobile', NULL),
(1873, 2, 1698644927, 'tool_mobile', 'minimumversion', '', NULL),
(1874, 2, 1698644927, 'tool_mobile', 'autologinmintimebetweenreq', '360', NULL),
(1875, 2, 1698644927, NULL, 'mobilecssurl', '', NULL),
(1876, 2, 1698644927, 'tool_mobile', 'enablesmartappbanners', '0', NULL),
(1877, 2, 1698644927, 'tool_mobile', 'iosappid', '633359593', NULL),
(1878, 2, 1698644927, 'tool_mobile', 'androidappid', 'com.moodle.moodlemobile', NULL),
(1879, 2, 1698644927, 'tool_mobile', 'setuplink', 'https://download.moodle.org/mobile', NULL),
(1880, 2, 1698644927, 'tool_mobile', 'forcelogout', '0', NULL),
(1881, 2, 1698644927, 'tool_mobile', 'disabledfeatures', '', NULL),
(1882, 2, 1698644927, 'tool_mobile', 'custommenuitems', '', NULL),
(1883, 2, 1698644927, 'tool_mobile', 'filetypeexclusionlist', '', NULL),
(1884, 2, 1698644927, 'tool_mobile', 'customlangstrings', '', NULL),
(1885, 2, 1698644927, NULL, 'enablemobilewebservice', '0', NULL),
(1886, 2, 1698644927, 'tool_moodlenet', 'defaultmoodlenetname', 'MoodleNet Central', NULL),
(1887, 2, 1698644927, 'tool_moodlenet', 'defaultmoodlenet', 'https://moodle.net', NULL),
(1888, 2, 1698644927, NULL, 'timezone', 'America/New_York', NULL),
(1889, 2, 1698644927, NULL, 'registerauth', '', NULL),
(1890, 2, 1698644927, NULL, 'supportemail', 'ftech868@gmail.com', NULL),
(1891, 2, 1698645517, 'theme_boosted', 'unaddableblocks', 'navigation,settings,course_list,section_links', NULL),
(1892, 2, 1698645517, 'theme_boosted', 'preset', 'default.scss', NULL),
(1893, 2, 1698645517, 'theme_boosted', 'favicon', '/WhatsApp_Image_2023-10-24_at_9.16.09_AM-removebg-preview.png', NULL),
(1894, 2, 1698645517, 'theme_boosted', 'backgroundimage', '/pexels-andrea-piacquadio-3762800.jpg', NULL),
(1895, 2, 1698645517, 'theme_boosted', 'contentwidth', '80%', NULL),
(1896, 2, 1698645517, 'theme_boosted', 'brandcolor', '#3a89e4', NULL),
(1897, 2, 1698645517, 'theme_boosted', 'pagebgcolor', '#89e43a', NULL),
(1898, 2, 1698645517, 'theme_boosted', 'focusborder', '#3a89e4', NULL),
(1899, 2, 1698645517, 'theme_boosted', 'selectiontext', '#000', NULL),
(1900, 2, 1698645517, 'theme_boosted', 'selectionbg', '#fff000', NULL),
(1901, 2, 1698645517, 'theme_boosted', 'customfontmain', 'lexend-deca-v17-latin-regular.woff2', NULL),
(1902, 2, 1698645517, 'theme_boosted', 'fontsize', '1rem', NULL),
(1903, 2, 1698645517, 'theme_boosted', 'fontmaincolor', '#333', NULL),
(1904, 2, 1698645517, 'theme_boosted', 'customfontheader', 'montserrat-v25-latin-700.woff2', NULL),
(1905, 2, 1698645517, 'theme_boosted', 'fontheadercolor', '#e43a89', NULL),
(1906, 2, 1698645517, 'theme_boosted', 'headerbgcolor', '#fff', NULL),
(1907, 2, 1698645517, 'theme_boosted', 'headertextcolor', '#333', NULL),
(1908, 2, 1698645517, 'theme_boosted', 'footerbgcolor', '#424242', NULL),
(1909, 2, 1698645517, 'theme_boosted', 'footertextcolor', '#fff', NULL),
(1910, 2, 1698645517, 'theme_boosted', 'footnote', '', NULL),
(1911, 2, 1698645517, 'theme_boosted', 'socialiconslist', '', NULL),
(1912, 2, 1698645517, 'theme_boosted', 'footerlayout', '4', NULL),
(1913, 2, 1698645517, 'theme_boosted', 'loginbackgroundimage', '/pexels-andrea-piacquadio-3762800.jpg', NULL),
(1914, 2, 1698645517, 'theme_boosted', 'loginboxalign', 'center', NULL),
(1915, 2, 1698645517, 'theme_boosted', 'bannerimage', '', NULL),
(1916, 2, 1698645517, 'theme_boosted', 'bannertext', '', NULL),
(1917, 2, 1698645517, 'theme_boosted', 'bannerbutton', '', NULL),
(1918, 2, 1698645517, 'theme_boosted', 'bannerbuttonlink', '', NULL),
(1919, 2, 1698645517, 'theme_boosted', 'bannertextvalign', 'start', NULL),
(1920, 2, 1698645517, 'theme_boosted', 'infoblockslayout', '4', NULL),
(1921, 2, 1698645517, 'theme_boosted', 'scsspre', '', NULL),
(1922, 2, 1698645517, 'theme_boosted', 'scss', '', NULL),
(1923, 2, 1698645539, 'theme_boosted', 'footerblocktitle1', '', NULL),
(1924, 2, 1698645539, 'theme_boosted', 'footerblockcontent1', '', NULL),
(1925, 2, 1698645539, 'theme_boosted', 'footerblocktitle2', '', NULL),
(1926, 2, 1698645539, 'theme_boosted', 'footerblockcontent2', '', NULL),
(1927, 2, 1698645539, 'theme_boosted', 'footerblocktitle3', '', NULL),
(1928, 2, 1698645539, 'theme_boosted', 'footerblockcontent3', '', NULL),
(1929, 2, 1698645539, 'theme_boosted', 'footerblocktitle4', '', NULL),
(1930, 2, 1698645539, 'theme_boosted', 'footerblockcontent4', '', NULL),
(1931, 2, 1698645539, 'theme_boosted', 'infoblockcontent1', '', NULL),
(1932, 2, 1698645539, 'theme_boosted', 'infoblockcontent2', '', NULL),
(1933, 2, 1698645539, 'theme_boosted', 'infoblockcontent3', '', NULL),
(1934, 2, 1698645539, 'theme_boosted', 'infoblockcontent4', '', NULL),
(1935, 2, 1698730029, 'theme_boosted', 'preset', 'plain.scss', 'default.scss'),
(1936, 2, 1698730072, 'theme_boosted', 'brandcolor', '#0413F0', '#3a89e4'),
(1937, 2, 1698730096, 'theme_boosted', 'fontheadercolor', '#03003C', '#e43a89'),
(1938, 2, 1698981626, NULL, 'navshowfullcoursenames', '1', '0'),
(1939, 2, 1699170339, 'theme_academi', 'logo', '/WhatsApp_Image_2023-10-24_at_9.16.09_AM-removebg-preview.png', NULL),
(1940, 2, 1699170340, 'theme_academi', 'favicon', '/rsz_2whatsapp_image_2023-10-24_at_91609_am-removebg-preview.png', NULL),
(1941, 2, 1699170340, 'theme_academi', 'primarycolor', '', NULL),
(1942, 2, 1699170340, 'theme_academi', 'secondarycolor', '', NULL),
(1943, 2, 1699170340, 'theme_academi', 'themestyleheader', '1', NULL),
(1944, 2, 1699170340, 'theme_academi', 'pagesize', 'container', NULL),
(1945, 2, 1699170340, 'theme_academi', 'pagesizecustomval', '0', NULL),
(1946, 2, 1699170340, 'theme_academi', 'fontsize', '16', NULL),
(1947, 2, 1699170340, 'theme_academi', 'availablecoursetype', '1', NULL),
(1948, 2, 1699170340, 'theme_academi', 'comboListboxType', '1', NULL),
(1949, 2, 1699170340, 'theme_academi', 'loginbg', '', NULL),
(1950, 2, 1699170340, 'theme_academi', 'backToTop_status', '1', NULL),
(1951, 2, 1699170340, 'theme_academi', 'customcss', '', NULL),
(1952, 2, 1699170340, 'theme_academi', 'preset', 'academi', NULL),
(1953, 2, 1699170340, 'theme_academi', 'presetfiles', '', NULL),
(1954, 2, 1699170340, 'theme_academi', 'toggleslideshow', '1', NULL),
(1955, 2, 1699170340, 'theme_academi', 'autoslideshow', '1', NULL),
(1956, 2, 1699170340, 'theme_academi', 'slideinterval', '3500', NULL),
(1957, 2, 1699170340, 'theme_academi', 'slideOverlay', '0.4', NULL),
(1958, 2, 1699170340, 'theme_academi', 'numberofslides', '3', NULL),
(1959, 2, 1699170340, 'theme_academi', 'pcoursestatus', '1', NULL),
(1960, 2, 1699170340, 'theme_academi', 'promotedtitle', 'lang:promotedtitledefault', NULL),
(1961, 2, 1699170340, 'theme_academi', 'promotedcoursedesc', 'lang:description_default', NULL),
(1962, 2, 1699170340, 'theme_academi', 'promotedcourses', '3,2', NULL),
(1963, 2, 1699170340, 'theme_academi', 'sitefblockstatus', '0', NULL),
(1964, 2, 1699170340, 'theme_academi', 'sitefeaturetitle', 'lang:sitefeaturesdefault', NULL),
(1965, 2, 1699170340, 'theme_academi', 'sitefeaturedesc', 'lang:description_default', NULL),
(1966, 2, 1699170340, 'theme_academi', 'numberofsitefeature', '4', NULL),
(1967, 2, 1699170340, 'theme_academi', 'mspotstatus', '0', NULL),
(1968, 2, 1699170340, 'theme_academi', 'mspottitle', 'lang:aboutus', NULL),
(1969, 2, 1699170340, 'theme_academi', 'mspotdesc', 'lang:description_default', NULL),
(1970, 2, 1699170340, 'theme_academi', 'mspotcontent', '<p>Ipsum in aspernatur ut possimus sint. Quia omnis est occaecati possimus ea. Quas molestiae perspiciatis occaecati qui rerum. Deleniti quod porro sed quisquam saepe. Numquam mollitia recusandae non ad at et a.</p>\r\n<p>Ad vitae recusandae odit possimus. Quaerat cum ipsum corrupti. Odit qui asperiores ea corporis deserunt veritatis quidem expedita perferendis. Qui rerum eligendi ex doloribus quia sit. Porro rerum eum eum.</p>\r\n<p>Ad vitae recusandae odit possimus. Quaerat cum ipsum corrupti. Odit qui asperiores ea corporis deserunt veritatis quidem expedita perferendis.</p>', NULL),
(1971, 2, 1699170340, 'theme_academi', 'mspotmedia', '/mspotmedia.png', NULL),
(1972, 2, 1699170340, 'theme_academi', 'jumbotronstatus', '0', NULL),
(1973, 2, 1699170340, 'theme_academi', 'jumbotrontitle', 'lang:learnanytime', NULL),
(1974, 2, 1699170340, 'theme_academi', 'jumbotrondesc', 'lang:learnanytimedesc', NULL),
(1975, 2, 1699170340, 'theme_academi', 'jumbotronbtntext', 'lang:viewallcourses', NULL),
(1976, 2, 1699170340, 'theme_academi', 'jumbotronbtnlink', 'http://www.example.com/', NULL),
(1977, 2, 1699170340, 'theme_academi', 'jumbotronbtntarget', '1', NULL),
(1978, 2, 1699170340, 'theme_academi', 'footerbgimg', '', NULL),
(1979, 2, 1699170340, 'theme_academi', 'footerbgOverlay', '0.4', NULL),
(1980, 2, 1699170340, 'theme_academi', 'copyright_footer', 'Copyright &copy; 2017 - Developed by <a href="http://lmsace.com">LMSACE.com</a>. Powered by <a href="https://moodle.org">Moodle</a>', NULL),
(1981, 2, 1699170340, 'theme_academi', 'footerb1_status', '1', NULL),
(1982, 2, 1699170340, 'theme_academi', 'footerbtitle1', '', NULL),
(1983, 2, 1699170340, 'theme_academi', 'footlogostatus', '1', NULL),
(1984, 2, 1699170340, 'theme_academi', 'footerlogo', '/rsz_2whatsapp_image_2023-10-24_at_91609_am-removebg-preview.png', NULL),
(1985, 2, 1699170340, 'theme_academi', 'footnote', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and tronic typesetting, sheets taining Lorem Ipsum passages.<br><a href="#">Read More »</a></p>', NULL),
(1986, 2, 1699170340, 'theme_academi', 'footerb2_status', '1', NULL),
(1987, 2, 1699170340, 'theme_academi', 'footerbtitle2', 'lang:footerbtitle2default', NULL),
(1988, 2, 1699170340, 'theme_academi', 'infolink', 'Moodle community|https://moodle.org Moodle free\r\nsupport|https://moodle.org/support\r\nMoodle development|https://moodle.org/development\r\nMoodle Docs|http://docs.moodle.org|Moodle Docs\r\nMoodle.com|http://moodle.com/', NULL),
(1989, 2, 1699170340, 'theme_academi', 'footerb3_status', '1', NULL),
(1990, 2, 1699170340, 'theme_academi', 'footerbtitle3', 'lang:footerbtitle3default', NULL),
(1991, 2, 1699170340, 'theme_academi', 'address', '308 Negra Narrow Lane, Albeeze, New york, 87104', NULL),
(1992, 2, 1699170340, 'theme_academi', 'emailid', 'info@example.com', NULL),
(1993, 2, 1699170340, 'theme_academi', 'phoneno', '(000) 123-456', NULL),
(1994, 2, 1699170340, 'theme_academi', 'footerb4_status', '1', NULL),
(1995, 2, 1699170340, 'theme_academi', 'footerbtitle4', 'lang:footerbtitle4default', NULL),
(1996, 2, 1699170340, 'theme_academi', 'numofsocialmedia', '4', NULL),
(1997, 2, 1699170448, 'theme_academi', 'slide1status', '1', NULL),
(1998, 2, 1699170448, 'theme_academi', 'slide1image', '/314436626_137438765719481_7225773790124219650_n.jpg', NULL),
(1999, 2, 1699170448, 'theme_academi', 'slide1contentstatus', '1', NULL),
(2000, 2, 1699170448, 'theme_academi', 'slide1caption', 'Bootstrap Based Slider - 01', NULL),
(2001, 2, 1699170448, 'theme_academi', 'slide1desc', 'Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.', NULL),
(2002, 2, 1699170448, 'theme_academi', 'slide1btntext', 'lang:knowmore', NULL),
(2003, 2, 1699170448, 'theme_academi', 'slide1btnurl', 'http://www.example.com/', NULL),
(2004, 2, 1699170448, 'theme_academi', 'slide1btntarget', '1', NULL),
(2005, 2, 1699170448, 'theme_academi', 'slide1contFullwidth', '50', NULL),
(2006, 2, 1699170448, 'theme_academi', 'slide1contentPosition', 'centerRight', NULL),
(2007, 2, 1699170448, 'theme_academi', 'slide2status', '1', NULL),
(2008, 2, 1699170448, 'theme_academi', 'slide2image', '/366646385_260312243432132_384136990631417121_n.jpg', NULL),
(2009, 2, 1699170448, 'theme_academi', 'slide2contentstatus', '1', NULL),
(2010, 2, 1699170448, 'theme_academi', 'slide2caption', 'Bootstrap Based Slider - 02', NULL),
(2011, 2, 1699170448, 'theme_academi', 'slide2desc', 'Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.', NULL),
(2012, 2, 1699170448, 'theme_academi', 'slide2btntext', 'lang:knowmore', NULL),
(2013, 2, 1699170448, 'theme_academi', 'slide2btnurl', 'http://www.example.com/', NULL),
(2014, 2, 1699170448, 'theme_academi', 'slide2btntarget', '1', NULL),
(2015, 2, 1699170448, 'theme_academi', 'slide2contFullwidth', '50', NULL),
(2016, 2, 1699170448, 'theme_academi', 'slide2contentPosition', 'centerRight', NULL),
(2017, 2, 1699170448, 'theme_academi', 'slide3status', '1', NULL),
(2018, 2, 1699170448, 'theme_academi', 'slide3image', '/366709971_260312230098800_2506756069623135961_n.jpg', NULL),
(2019, 2, 1699170448, 'theme_academi', 'slide3contentstatus', '1', NULL),
(2020, 2, 1699170448, 'theme_academi', 'slide3caption', 'Bootstrap Based Slider - 03', NULL),
(2021, 2, 1699170448, 'theme_academi', 'slide3desc', 'Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.', NULL),
(2022, 2, 1699170448, 'theme_academi', 'slide3btntext', 'lang:knowmore', NULL),
(2023, 2, 1699170448, 'theme_academi', 'slide3btnurl', 'http://www.example.com/', NULL),
(2024, 2, 1699170448, 'theme_academi', 'slide3btntarget', '1', NULL),
(2025, 2, 1699170448, 'theme_academi', 'slide3contFullwidth', '50', NULL),
(2026, 2, 1699170448, 'theme_academi', 'slide3contentPosition', 'centerRight', NULL),
(2027, 2, 1699170448, 'theme_academi', 'sitefblock1status', '1', NULL),
(2028, 2, 1699170448, 'theme_academi', 'sitefblock1title', 'lang:sb1_default_title', NULL),
(2029, 2, 1699170448, 'theme_academi', 'sitefblock1content', 'lang:sb_default_content', NULL),
(2030, 2, 1699170448, 'theme_academi', 'sitefblock1icon', 'lang:sitefblockicon1_default', NULL),
(2031, 2, 1699170448, 'theme_academi', 'sitefblock2status', '1', NULL),
(2032, 2, 1699170448, 'theme_academi', 'sitefblock2title', 'lang:sb2_default_title', NULL),
(2033, 2, 1699170448, 'theme_academi', 'sitefblock2content', 'lang:sb_default_content', NULL),
(2034, 2, 1699170448, 'theme_academi', 'sitefblock2icon', 'lang:sitefblockicon2_default', NULL),
(2035, 2, 1699170448, 'theme_academi', 'sitefblock3status', '1', NULL),
(2036, 2, 1699170448, 'theme_academi', 'sitefblock3title', 'lang:sb3_default_title', NULL),
(2037, 2, 1699170448, 'theme_academi', 'sitefblock3content', 'lang:sb_default_content', NULL),
(2038, 2, 1699170448, 'theme_academi', 'sitefblock3icon', 'lang:sitefblockicon3_default', NULL),
(2039, 2, 1699170448, 'theme_academi', 'sitefblock4status', '1', NULL),
(2040, 2, 1699170448, 'theme_academi', 'sitefblock4title', 'lang:sb4_default_title', NULL),
(2041, 2, 1699170448, 'theme_academi', 'sitefblock4content', 'lang:sb_default_content', NULL),
(2042, 2, 1699170448, 'theme_academi', 'sitefblock4icon', 'lang:sitefblockicon4_default', NULL),
(2043, 2, 1699170448, 'theme_academi', 'socialmedia1_status', '1', NULL),
(2044, 2, 1699170448, 'theme_academi', 'socialmedia1_icon', 'twitter', NULL),
(2045, 2, 1699170448, 'theme_academi', 'socialmedia1_url', 'https://twitter.com/yourtwittername', NULL),
(2046, 2, 1699170448, 'theme_academi', 'socialmedia1_iconcolor', '#47caf6', NULL),
(2047, 2, 1699170448, 'theme_academi', 'socialmedia2_status', '1', NULL),
(2048, 2, 1699170448, 'theme_academi', 'socialmedia2_icon', 'google-plus', NULL),
(2049, 2, 1699170448, 'theme_academi', 'socialmedia2_url', 'https://www.google.com/+yourgoogleplusid', NULL),
(2050, 2, 1699170448, 'theme_academi', 'socialmedia2_iconcolor', '#e84c3d', NULL),
(2051, 2, 1699170448, 'theme_academi', 'socialmedia3_status', '1', NULL),
(2052, 2, 1699170448, 'theme_academi', 'socialmedia3_icon', 'pinterest-p', NULL),
(2053, 2, 1699170448, 'theme_academi', 'socialmedia3_url', 'https://in.pinterest.com/yourpinterestname/', NULL),
(2054, 2, 1699170448, 'theme_academi', 'socialmedia3_iconcolor', '#cd2129', NULL),
(2055, 2, 1699170448, 'theme_academi', 'socialmedia4_status', '1', NULL),
(2056, 2, 1699170448, 'theme_academi', 'socialmedia4_icon', 'facebook-f', NULL),
(2057, 2, 1699170448, 'theme_academi', 'socialmedia4_url', 'https://www.facebook.com/yourfacebookid', NULL),
(2058, 2, 1699170448, 'theme_academi', 'socialmedia4_iconcolor', '#3598dc', NULL),
(2059, 2, 1699170666, 'theme_academi', 'loginbg', '/pexels-andrea-piacquadio-3762800.jpg', ''),
(2060, 2, 1699171296, 'theme_academi', 'primarycolor', '#133a5e', ''),
(2061, 2, 1699171296, 'theme_academi', 'secondarycolor', '#f3dc7f', ''),
(2062, 2, 1699171880, 'theme_academi', 'footnote', '<p>Elevate Your Career With Our Internationally Recognized Programs.<br><a href="#">Read More »</a></p>', '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and tronic typesetting, sheets taining Lorem Ipsum passages.<br><a href="#">Read More »</a></p>'),
(2063, 2, 1699171880, 'theme_academi', 'infolink', 'ASTI Home|https://astitt.tech/\r\nASTI Student Portal|https://astitt.tech/sis/\r\nASTI UniLearn|https://astitt.tech/unilearn/', 'Moodle community|https://moodle.org Moodle free\r\nsupport|https://moodle.org/support\r\nMoodle development|https://moodle.org/development\r\nMoodle Docs|http://docs.moodle.org|Moodle Docs\r\nMoodle.com|http://moodle.com/');
INSERT INTO `mdlxd_config_log` VALUES
(2064, 2, 1699171880, 'theme_academi', 'address', '#46 Boundary Road, San Juan', '308 Negra Narrow Lane, Albeeze, New york, 87104'),
(2065, 2, 1699171880, 'theme_academi', 'emailid', 'education@astitnt.com', 'info@example.com'),
(2066, 2, 1699171880, 'theme_academi', 'phoneno', '(868) 727-8562', '(000) 123-456'),
(2067, 2, 1699172150, 'theme_academi', 'copyright_footer', 'Copyright &copy; 2023 - Developed by <a href="https://foresiteltd.com/">Foresite</a>. Powered by <a href="https://moodle.org">Moodle</a>', 'Copyright &copy; 2017 - Developed by <a href="http://lmsace.com">LMSACE.com</a>. Powered by <a href="https://moodle.org">Moodle</a>'),
(2068, 2, 1699172150, 'theme_academi', 'socialmedia1_status', '0', '1'),
(2069, 2, 1699172151, 'theme_academi', 'socialmedia2_status', '0', '1'),
(2070, 2, 1699172151, 'theme_academi', 'socialmedia3_url', 'https://www.instagram.com/astitt_university/', 'https://in.pinterest.com/yourpinterestname/'),
(2071, 2, 1699172151, 'theme_academi', 'socialmedia4_url', 'https://www.facebook.com/ASTIUniversity', 'https://www.facebook.com/yourfacebookid'),
(2072, 2, 1699172213, 'theme_academi', 'socialmedia3_icon', 'instagram-p', 'pinterest-p'),
(2073, 2, 1699172251, 'theme_academi', 'socialmedia3_status', '0', '1'),
(2074, 2, 1699172821, 'theme_academi', 'slide1caption', '', 'Bootstrap Based Slider - 01'),
(2075, 2, 1699172821, 'theme_academi', 'slide1desc', '', 'Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.'),
(2076, 2, 1699172821, 'theme_academi', 'slide1btnurl', '', 'http://www.example.com/'),
(2077, 2, 1699172821, 'theme_academi', 'slide2caption', '', 'Bootstrap Based Slider - 02'),
(2078, 2, 1699172821, 'theme_academi', 'slide2desc', '', 'Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.'),
(2079, 2, 1699172821, 'theme_academi', 'slide2btnurl', '', 'http://www.example.com/'),
(2080, 2, 1699172821, 'theme_academi', 'slide3caption', '', 'Bootstrap Based Slider - 03'),
(2081, 2, 1699172821, 'theme_academi', 'slide3desc', '', 'Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.'),
(2082, 2, 1699172821, 'theme_academi', 'slide3btnurl', '', 'http://www.example.com/'),
(2083, 2, 1699927808, NULL, 'guestloginbutton', '0', '1'),
(2084, 2, 1699928100, 'moodlecourse', 'visible', '0', '1'),
(2085, 2, 1699928100, 'moodlecourse', 'maxbytes', '5242880', '0');

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_config_plugins`
--

CREATE TABLE `mdlxd_config_plugins` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `plugin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'core',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_confplug_plunam_uix` (`plugin`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Moodle modules and plugins configuration variables';

--
-- Dumping data for table `mdlxd_config_plugins`
--

INSERT INTO `mdlxd_config_plugins` VALUES
(1, 'question', 'multichoice_sortorder', '1'),
(2, 'question', 'truefalse_sortorder', '2'),
(3, 'question', 'match_sortorder', '3'),
(4, 'question', 'shortanswer_sortorder', '4'),
(5, 'question', 'numerical_sortorder', '5'),
(6, 'question', 'essay_sortorder', '6'),
(7, 'core_competency', 'enabled', '1'),
(8, 'moodlecourse', 'visible', '0'),
(9, 'moodlecourse', 'downloadcontentsitedefault', '0'),
(10, 'moodlecourse', 'participantsperpage', '20'),
(11, 'moodlecourse', 'format', 'topics'),
(12, 'moodlecourse', 'maxsections', '52'),
(13, 'moodlecourse', 'numsections', '4'),
(14, 'moodlecourse', 'hiddensections', '1'),
(15, 'moodlecourse', 'coursedisplay', '0'),
(16, 'moodlecourse', 'courseenddateenabled', '1'),
(17, 'moodlecourse', 'courseduration', '31536000'),
(18, 'moodlecourse', 'lang', ''),
(19, 'moodlecourse', 'newsitems', '5'),
(20, 'moodlecourse', 'showgrades', '1'),
(21, 'moodlecourse', 'showreports', '0'),
(22, 'moodlecourse', 'showactivitydates', '1'),
(23, 'moodlecourse', 'maxbytes', '5242880'),
(24, 'moodlecourse', 'enablecompletion', '1'),
(25, 'moodlecourse', 'showcompletionconditions', '1'),
(26, 'moodlecourse', 'groupmode', '0'),
(27, 'moodlecourse', 'groupmodeforce', '0'),
(28, 'moodlecourse', 'coursecommunicationprovider', 'none'),
(29, 'backup', 'loglifetime', '30'),
(30, 'backup', 'backup_general_users', '1'),
(31, 'backup', 'backup_general_users_locked', ''),
(32, 'backup', 'backup_general_anonymize', '0'),
(33, 'backup', 'backup_general_anonymize_locked', ''),
(34, 'backup', 'backup_general_role_assignments', '1'),
(35, 'backup', 'backup_general_role_assignments_locked', ''),
(36, 'backup', 'backup_general_activities', '1'),
(37, 'backup', 'backup_general_activities_locked', ''),
(38, 'backup', 'backup_general_blocks', '1'),
(39, 'backup', 'backup_general_blocks_locked', ''),
(40, 'backup', 'backup_general_files', '1'),
(41, 'backup', 'backup_general_files_locked', ''),
(42, 'backup', 'backup_general_filters', '1'),
(43, 'backup', 'backup_general_filters_locked', ''),
(44, 'backup', 'backup_general_comments', '1'),
(45, 'backup', 'backup_general_comments_locked', ''),
(46, 'backup', 'backup_general_badges', '1'),
(47, 'backup', 'backup_general_badges_locked', ''),
(48, 'backup', 'backup_general_calendarevents', '1'),
(49, 'backup', 'backup_general_calendarevents_locked', ''),
(50, 'backup', 'backup_general_userscompletion', '1'),
(51, 'backup', 'backup_general_userscompletion_locked', ''),
(52, 'backup', 'backup_general_logs', '0'),
(53, 'backup', 'backup_general_logs_locked', ''),
(54, 'backup', 'backup_general_histories', '0'),
(55, 'backup', 'backup_general_histories_locked', ''),
(56, 'backup', 'backup_general_questionbank', '1'),
(57, 'backup', 'backup_general_questionbank_locked', ''),
(58, 'backup', 'backup_general_groups', '1'),
(59, 'backup', 'backup_general_groups_locked', ''),
(60, 'backup', 'backup_general_competencies', '1'),
(61, 'backup', 'backup_general_competencies_locked', ''),
(62, 'backup', 'backup_general_contentbankcontent', '1'),
(63, 'backup', 'backup_general_contentbankcontent_locked', ''),
(64, 'backup', 'backup_general_xapistate', '1'),
(65, 'backup', 'backup_general_xapistate_locked', ''),
(66, 'backup', 'backup_general_legacyfiles', '1'),
(67, 'backup', 'backup_general_legacyfiles_locked', ''),
(68, 'backup', 'import_general_maxresults', '10'),
(69, 'backup', 'import_general_duplicate_admin_allowed', '0'),
(70, 'backup', 'backup_import_permissions', '0'),
(71, 'backup', 'backup_import_permissions_locked', ''),
(72, 'backup', 'backup_import_activities', '1'),
(73, 'backup', 'backup_import_activities_locked', ''),
(74, 'backup', 'backup_import_blocks', '1'),
(75, 'backup', 'backup_import_blocks_locked', ''),
(76, 'backup', 'backup_import_filters', '1'),
(77, 'backup', 'backup_import_filters_locked', ''),
(78, 'backup', 'backup_import_calendarevents', '1'),
(79, 'backup', 'backup_import_calendarevents_locked', ''),
(80, 'backup', 'backup_import_questionbank', '1'),
(81, 'backup', 'backup_import_questionbank_locked', ''),
(82, 'backup', 'backup_import_groups', '1'),
(83, 'backup', 'backup_import_groups_locked', ''),
(84, 'backup', 'backup_import_competencies', '1'),
(85, 'backup', 'backup_import_competencies_locked', ''),
(86, 'backup', 'backup_import_contentbankcontent', '1'),
(87, 'backup', 'backup_import_contentbankcontent_locked', ''),
(88, 'backup', 'backup_import_legacyfiles', '1'),
(89, 'backup', 'backup_import_legacyfiles_locked', ''),
(90, 'backup', 'backup_auto_active', '0'),
(91, 'backup', 'backup_auto_weekdays', '0000000'),
(92, 'backup', 'backup_auto_hour', '0'),
(93, 'backup', 'backup_auto_minute', '0'),
(94, 'backup', 'backup_auto_storage', '0'),
(95, 'backup', 'backup_auto_destination', ''),
(96, 'backup', 'backup_auto_max_kept', '1'),
(97, 'backup', 'backup_auto_delete_days', '0'),
(98, 'backup', 'backup_auto_min_kept', '0'),
(99, 'backup', 'backup_shortname', '0'),
(100, 'backup', 'backup_auto_skip_hidden', '1'),
(101, 'backup', 'backup_auto_skip_modif_days', '30'),
(102, 'backup', 'backup_auto_skip_modif_prev', '0'),
(103, 'backup', 'backup_auto_users', '1'),
(104, 'backup', 'backup_auto_role_assignments', '1'),
(105, 'backup', 'backup_auto_activities', '1'),
(106, 'backup', 'backup_auto_blocks', '1'),
(107, 'backup', 'backup_auto_files', '1'),
(108, 'backup', 'backup_auto_filters', '1'),
(109, 'backup', 'backup_auto_comments', '1'),
(110, 'backup', 'backup_auto_badges', '1'),
(111, 'backup', 'backup_auto_calendarevents', '1'),
(112, 'backup', 'backup_auto_userscompletion', '1'),
(113, 'backup', 'backup_auto_logs', '0'),
(114, 'backup', 'backup_auto_histories', '0'),
(115, 'backup', 'backup_auto_questionbank', '1'),
(116, 'backup', 'backup_auto_groups', '1'),
(117, 'backup', 'backup_auto_competencies', '1'),
(118, 'backup', 'backup_auto_contentbankcontent', '1'),
(119, 'backup', 'backup_auto_xapistate', '1'),
(120, 'backup', 'backup_auto_legacyfiles', '1'),
(121, 'restore', 'restore_general_users', '1'),
(122, 'restore', 'restore_general_users_locked', ''),
(123, 'restore', 'restore_general_enrolments', '1'),
(124, 'restore', 'restore_general_enrolments_locked', ''),
(125, 'restore', 'restore_general_role_assignments', '1'),
(126, 'restore', 'restore_general_role_assignments_locked', ''),
(127, 'restore', 'restore_general_permissions', '1'),
(128, 'restore', 'restore_general_permissions_locked', ''),
(129, 'restore', 'restore_general_activities', '1'),
(130, 'restore', 'restore_general_activities_locked', ''),
(131, 'restore', 'restore_general_blocks', '1'),
(132, 'restore', 'restore_general_blocks_locked', ''),
(133, 'restore', 'restore_general_filters', '1'),
(134, 'restore', 'restore_general_filters_locked', ''),
(135, 'restore', 'restore_general_comments', '1'),
(136, 'restore', 'restore_general_comments_locked', ''),
(137, 'restore', 'restore_general_badges', '1'),
(138, 'restore', 'restore_general_badges_locked', ''),
(139, 'restore', 'restore_general_calendarevents', '1'),
(140, 'restore', 'restore_general_calendarevents_locked', ''),
(141, 'restore', 'restore_general_userscompletion', '1'),
(142, 'restore', 'restore_general_userscompletion_locked', ''),
(143, 'restore', 'restore_general_logs', '1'),
(144, 'restore', 'restore_general_logs_locked', ''),
(145, 'restore', 'restore_general_histories', '1'),
(146, 'restore', 'restore_general_histories_locked', ''),
(147, 'restore', 'restore_general_groups', '1'),
(148, 'restore', 'restore_general_groups_locked', ''),
(149, 'restore', 'restore_general_competencies', '1'),
(150, 'restore', 'restore_general_competencies_locked', ''),
(151, 'restore', 'restore_general_contentbankcontent', '1'),
(152, 'restore', 'restore_general_contentbankcontent_locked', ''),
(153, 'restore', 'restore_general_xapistate', '1'),
(154, 'restore', 'restore_general_xapistate_locked', ''),
(155, 'restore', 'restore_general_legacyfiles', '1'),
(156, 'restore', 'restore_general_legacyfiles_locked', ''),
(157, 'restore', 'restore_merge_overwrite_conf', '0'),
(158, 'restore', 'restore_merge_overwrite_conf_locked', ''),
(159, 'restore', 'restore_merge_course_fullname', '1'),
(160, 'restore', 'restore_merge_course_fullname_locked', ''),
(161, 'restore', 'restore_merge_course_shortname', '1'),
(162, 'restore', 'restore_merge_course_shortname_locked', ''),
(163, 'restore', 'restore_merge_course_startdate', '1'),
(164, 'restore', 'restore_merge_course_startdate_locked', ''),
(165, 'restore', 'restore_replace_overwrite_conf', '0'),
(166, 'restore', 'restore_replace_overwrite_conf_locked', ''),
(167, 'restore', 'restore_replace_course_fullname', '1'),
(168, 'restore', 'restore_replace_course_fullname_locked', ''),
(169, 'restore', 'restore_replace_course_shortname', '1'),
(170, 'restore', 'restore_replace_course_shortname_locked', ''),
(171, 'restore', 'restore_replace_course_startdate', '1'),
(172, 'restore', 'restore_replace_course_startdate_locked', ''),
(173, 'restore', 'restore_replace_keep_roles_and_enrolments', '0'),
(174, 'restore', 'restore_replace_keep_roles_and_enrolments_locked', ''),
(175, 'restore', 'restore_replace_keep_groups_and_groupings', '0'),
(176, 'restore', 'restore_replace_keep_groups_and_groupings_locked', ''),
(177, 'backup', 'backup_async_message_users', '0'),
(178, 'backup', 'backup_async_message_subject', 'Moodle {operation} completed successfully'),
(179, 'backup', 'backup_async_message', 'Your {operation} (ID: {backupid}) has completed successfully. You can access it here: <a href="{link}">{link}</a>.'),
(180, 'analytics', 'modeinstruction', ''),
(181, 'analytics', 'percentonline', '0'),
(182, 'analytics', 'typeinstitution', ''),
(183, 'analytics', 'levelinstitution', ''),
(184, 'analytics', 'predictionsprocessor', '\\mlbackend_php\\processor'),
(185, 'analytics', 'defaulttimesplittingsevaluation', '\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range'),
(186, 'analytics', 'modeloutputdir', ''),
(187, 'analytics', 'onlycli', '1'),
(188, 'analytics', 'modeltimelimit', '1200'),
(189, 'analytics', 'calclifetime', '35'),
(190, 'antivirus', 'notifyemail', ''),
(191, 'antivirus', 'notifylevel', '2'),
(192, 'antivirus', 'threshold', '1200'),
(193, 'antivirus', 'enablequarantine', '0'),
(194, 'antivirus', 'quarantinetime', '2419200'),
(195, 'cachestore_apcu', 'testperformance', '0'),
(196, 'cachestore_redis', 'test_server', ''),
(197, 'cachestore_redis', 'test_encryption', '0'),
(198, 'cachestore_redis', 'test_cafile', ''),
(199, 'cachestore_redis', 'test_password', ''),
(200, 'cachestore_redis', 'test_serializer', '1'),
(201, 'cachestore_redis', 'test_ttl', '0'),
(202, 'question_preview', 'behaviour', 'deferredfeedback'),
(203, 'question_preview', 'correctness', '1'),
(204, 'question_preview', 'marks', '2'),
(205, 'question_preview', 'markdp', '2'),
(206, 'question_preview', 'feedback', '1'),
(207, 'question_preview', 'generalfeedback', '1'),
(208, 'question_preview', 'rightanswer', '1'),
(209, 'question_preview', 'history', '0'),
(210, 'tool_task', 'enablerunnow', '1'),
(211, 'adminpresets', 'sensiblesettings', 'recaptchapublickey@@none, recaptchaprivatekey@@none, googlemapkey3@@none, secretphrase@@url, cronremotepassword@@none, smtpuser@@none, smtppass@@none, proxypassword@@none, quizpassword@@quiz, allowedip@@none, blockedip@@none, dbpass@@logstore_database, messageinbound_hostpass@@none, bind_pw@@auth_cas, pass@@auth_db, bind_pw@@auth_ldap, dbpass@@enrol_database, bind_pw@@enrol_ldap, server_password@@search_solr, ssl_keypassword@@search_solr, alternateserver_password@@search_solr, alternatessl_keypassword@@search_solr, test_password@@cachestore_redis, password@@mlbackend_python, badges_badgesalt@@none, calendar_exportsalt@@none'),
(212, 'theme_boost', 'unaddableblocks', 'navigation,settings,course_list,section_links'),
(213, 'theme_boost', 'preset', 'default.scss'),
(214, 'theme_boost', 'presetfiles', ''),
(215, 'theme_boost', 'backgroundimage', ''),
(216, 'theme_boost', 'loginbackgroundimage', ''),
(217, 'theme_boost', 'brandcolor', ''),
(218, 'theme_boost', 'scsspre', ''),
(219, 'theme_boost', 'scss', ''),
(220, 'theme_classic', 'navbardark', '0'),
(221, 'theme_classic', 'unaddableblocks', ''),
(222, 'theme_classic', 'preset', 'default.scss'),
(223, 'theme_classic', 'presetfiles', ''),
(224, 'theme_classic', 'backgroundimage', ''),
(225, 'theme_classic', 'loginbackgroundimage', ''),
(226, 'theme_classic', 'brandcolor', ''),
(227, 'theme_classic', 'scsspre', ''),
(228, 'theme_classic', 'scss', ''),
(229, 'core_admin', 'logo', ''),
(230, 'core_admin', 'logocompact', ''),
(231, 'core_admin', 'favicon', ''),
(232, 'core_admin', 'coursecolor1', '#81ecec'),
(233, 'core_admin', 'coursecolor2', '#74b9ff'),
(234, 'core_admin', 'coursecolor3', '#a29bfe'),
(235, 'core_admin', 'coursecolor4', '#dfe6e9'),
(236, 'core_admin', 'coursecolor5', '#00b894'),
(237, 'core_admin', 'coursecolor6', '#0984e3'),
(238, 'core_admin', 'coursecolor7', '#b2bec3'),
(239, 'core_admin', 'coursecolor8', '#fdcb6e'),
(240, 'core_admin', 'coursecolor9', '#fd79a8'),
(241, 'core_admin', 'coursecolor10', '#6c5ce7'),
(242, 'core_competency', 'pushcourseratingstouserplans', '1'),
(243, 'antivirus_clamav', 'version', '2023100900'),
(244, 'availability_completion', 'version', '2023100900'),
(245, 'availability_date', 'version', '2023100900'),
(246, 'availability_grade', 'version', '2023100900'),
(247, 'availability_group', 'version', '2023100900'),
(248, 'availability_grouping', 'version', '2023100900'),
(249, 'availability_profile', 'version', '2023100900'),
(250, 'qtype_calculated', 'version', '2023100900'),
(251, 'qtype_calculatedmulti', 'version', '2023100900'),
(252, 'qtype_calculatedsimple', 'version', '2023100900'),
(253, 'qtype_ddimageortext', 'version', '2023100900'),
(254, 'qtype_ddmarker', 'version', '2023100900'),
(255, 'qtype_ddwtos', 'version', '2023100900'),
(256, 'qtype_description', 'version', '2023100900'),
(257, 'qtype_essay', 'version', '2023100900'),
(258, 'qtype_gapselect', 'version', '2023100900'),
(259, 'qtype_match', 'version', '2023100900'),
(260, 'qtype_missingtype', 'version', '2023100900'),
(261, 'qtype_multianswer', 'version', '2023100900'),
(262, 'qtype_multichoice', 'version', '2023100900'),
(263, 'qtype_numerical', 'version', '2023100900'),
(264, 'qtype_random', 'version', '2023100900'),
(265, 'qtype_randomsamatch', 'version', '2023100900'),
(266, 'qtype_shortanswer', 'version', '2023100900'),
(267, 'qtype_truefalse', 'version', '2023100900'),
(268, 'mod_assign', 'version', '2023100900'),
(269, 'mod_bigbluebuttonbn', 'version', '2023100900'),
(271, 'mod_book', 'version', '2023100900'),
(272, 'mod_chat', 'version', '2023100900'),
(273, 'mod_choice', 'version', '2023100900'),
(274, 'mod_data', 'version', '2023100900'),
(275, 'mod_feedback', 'version', '2023100900'),
(277, 'mod_folder', 'version', '2023100900'),
(279, 'mod_forum', 'version', '2023100900'),
(280, 'mod_glossary', 'version', '2023100900'),
(281, 'mod_h5pactivity', 'version', '2023100900'),
(282, 'mod_imscp', 'version', '2023100900'),
(284, 'mod_label', 'version', '2023100900'),
(285, 'mod_lesson', 'version', '2023100900'),
(286, 'mod_lti', 'version', '2023100900'),
(288, 'mod_lti', 'kid', '79f904d03e187fa8b337'),
(289, 'mod_lti', 'privatekey', '-----BEGIN PRIVATE KEY-----\nMIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDAwtxnrsH9N3uJ\nxxZxbKF0fE+gXvY0vUCd65a3RQmRxsXULmW9sBhH7TO23WigeQF66yNDVcx+XR2V\ncsQ4pwzuiBGeeylVbqNIDPtJfW3mP1DMVTEHp70wSOaCaNRHdrIB6gv++V108Vbo\neqmEL9DLYRfC4boxmp9flZ926dJVXoOiSRXbEGQOMz+/MNdmvGO5ThB+M2XamQvC\n/imxgAPWZbNKdl7GFgSS6+ceeSL3leu7I+IgOefU7ANY8IrIr1Ckz3iKxMGImXi5\nDQn0ogK3k8mNobaJwAyKSRf7SXdrEWvHyn3dkJqFnWEUFf50pPyefXoAMX4rswRy\nWj0w4oxjAgMBAAECggEBAKZhi80S0u62DTQHXB/bHCFni3NphCpRkIy+5QCb3n6t\ni+Rxh/ALJ2ouHA0jX0PkLpriizV7wV7xELAGt8gOqOLbIBojRLIxJU7zpZLxaQLs\nc9lrTz7EUlBzHEREJ7bnhQ6R7njO1RQznEheWCN5AkgKLnBQVl6qkBX5GAOUH7D+\nueW2+T8vmfjBneM9G7hIDUNYG6xbG8WRsa2HFID69LOkf4ukY+37fkBL4rD6uXxC\nHIAzphxXDiU3EKRYx6PfWL6Lh32Cx8IBfiUDG0yXg5b72pD26qMKDELWFio9SkYP\nyXen5hZVfgHs9pf+I8sPcd4ms0qrltcS4UJDMJdHp4ECgYEA991KcCvNOnfgKQ59\nG/CyW91ha5CAmkvhJj9m0Qda+gdhxFCsqciXr5V5yAe0GFE1hLhLzPsWcSYyg4FY\nRf1UQoZl8gr4rrNLT1wtXT6WwjVqADhdXwAycnsOlpIaU/UgHEI7Y5MIDzfRZzXn\nLuzKnZ48A1tWprlxyz5PHjWqC+sCgYEAxxaPEg1ab7/VpazHSYnKJDENadv2v/gV\nhifYpklDv/6eVH3hGMtjs+Z7jqX4FBFOuzYuVCP05Mvhsh1IDvAI/tmkHNnBHbWD\nKfLl+Qfs1vGaMYsPSVYfN+NEGFhC2XGyiN8ogpp+Bnkn7rHPr2A7H2asxCam6vwK\nTNbC4XWNu2kCgYAWWCihvBEgODZI/TliD2zEw0xI+hndzwFZBVYredJFv+ycWfl2\nxNKHzZ3Q3oDpwEhm0oZi0C/Ru3PKTxq6FIBIDv2ZuEt61EbxvImKYl4M2+vWYT5p\nlgb2Mwm5oSomb26ZnY7lBxgu5wVFnKJepJIPa3hVhSJmnUkY3WEchBH0SQKBgQCB\npBr+MlvVsSG6hMwxAtzyvE5zxJzlXPMHLSNTBRptB6yqcF4H+0mteES1GzZ0OuD9\n38ZDXDa4Vltd1Nt7fqsc6TSI5PNwGSaURmuiwppjTWiPInKN2trxVbid8bt2RSdx\nIYALq/as2HA8auVG2m8lf4K5KEJBemZqqt60Wgw1IQKBgQC/3LNWQqg3erPKRsfg\naAm57GSeybobeZGISTc0H+FR2+3hzz6rKs7qN0Zj3mQEhPAwpTahDmxfjWEA6q4u\nXOdbD/KH3T6S8XsmYxA0a+mivHuyY+9TfW3ZUZ43KLAI63miImYLTY8DJsAOEC3B\nzui0Xl6Xa+eM5DXCEVzZOg0J6Q==\n-----END PRIVATE KEY-----\n'),
(290, 'mod_page', 'version', '2023100900'),
(292, 'mod_quiz', 'version', '2023100900'),
(293, 'mod_resource', 'version', '2023100900'),
(294, 'mod_scorm', 'version', '2023100900'),
(295, 'mod_survey', 'version', '2023100900'),
(297, 'mod_url', 'version', '2023100900'),
(299, 'mod_wiki', 'version', '2023100900'),
(301, 'mod_workshop', 'version', '2023100900'),
(302, 'auth_cas', 'version', '2023100900'),
(304, 'auth_db', 'version', '2023100900'),
(306, 'auth_email', 'version', '2023100900'),
(307, 'auth_ldap', 'version', '2023100900'),
(309, 'auth_lti', 'version', '2023100900'),
(310, 'auth_manual', 'version', '2023100900'),
(311, 'auth_mnet', 'version', '2023100900'),
(313, 'auth_nologin', 'version', '2023100900'),
(314, 'auth_none', 'version', '2023100900'),
(315, 'auth_oauth2', 'version', '2023100900'),
(316, 'auth_shibboleth', 'version', '2023100900'),
(318, 'auth_webservice', 'version', '2023100900'),
(319, 'calendartype_gregorian', 'version', '2023100900'),
(320, 'communication_customlink', 'version', '2023100900'),
(321, 'communication_matrix', 'version', '2023100900'),
(322, 'customfield_checkbox', 'version', '2023100900'),
(323, 'customfield_date', 'version', '2023100900'),
(324, 'customfield_select', 'version', '2023100900'),
(325, 'customfield_text', 'version', '2023100900'),
(326, 'customfield_textarea', 'version', '2023100900'),
(327, 'enrol_category', 'version', '2023100900'),
(329, 'enrol_cohort', 'version', '2023100900'),
(330, 'enrol_database', 'version', '2023100900'),
(332, 'enrol_fee', 'version', '2023100900'),
(333, 'enrol_flatfile', 'version', '2023100900'),
(335, 'enrol_flatfile', 'map_1', 'manager'),
(336, 'enrol_flatfile', 'map_2', 'coursecreator'),
(337, 'enrol_flatfile', 'map_3', 'editingteacher'),
(338, 'enrol_flatfile', 'map_4', 'teacher'),
(339, 'enrol_flatfile', 'map_5', 'student'),
(340, 'enrol_flatfile', 'map_6', 'guest'),
(341, 'enrol_flatfile', 'map_7', 'user'),
(342, 'enrol_flatfile', 'map_8', 'frontpage'),
(343, 'enrol_guest', 'version', '2023100900'),
(344, 'enrol_imsenterprise', 'version', '2023100900'),
(346, 'enrol_ldap', 'version', '2023100900'),
(348, 'enrol_lti', 'version', '2023100900'),
(350, 'enrol_lti', 'lti_13_kid', '741410fa1e4b2a3eeb8b'),
(351, 'enrol_lti', 'lti_13_privatekey', '-----BEGIN PRIVATE KEY-----\nMIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDKyBY+HHHRq+pz\ndrgsKNnLq+Qs0tKvJMvxv6ZisasrZ4J7czTTRcinN/k9f+cnbfXTNzeZJ0BdTBKi\n3VLZgMttKUL3CVtyc6Ch0wuIzoWoh9dXJLs/qgWpMCDE8IcnNIe2kaEW59O0EDHD\nt6LdtLVs2yBe1d8fch5lt+Esll9PWtRJgr3Ax88OSzQqE0YM56/Xw1DjQTG51Atu\nBAt7CNTuflSX1F8CYtqfcWMTodYfQj1+iCy0gGycFpolwqGl261Y/YWRgWaM7J6g\nBiSiW9WCrLYlmcXcDLWnoUXzEgdiCPW0s6Z+k7kIcQ5vZ6K0BqHf0wZhlj3vBRXS\n4IS66uzLAgMBAAECggEBALywDjJhWW+WnqQuFhXRNUgVfE5RJgYfIT6j7Hjtha7v\ntDSW8NKenqUqqlsVhsvjv9h4Ct4R7gxiWvz9ILiO5bt/p3YjWNpYyWGK9bKpKSm2\nrSPDZBFLbdUOmY9nmPtcH+Q8Aj9EHHPylbveRkgyfJb8F1TngaTLFYnk3jwU+D7n\nRvTYTQ9luttYZbDutgIbXpOM4kRW5y+p8RR1/6FCkH9Zh16nujHbywRTkAXZmjG6\nhZxfTns9mEPABeRSzWjdHusAdZviltxzMxUM5bky46mFuQOovgBpgB0mzYJAZt6d\ns/5LmepZYNOZrAT7gJ3OlJfsbQksOo9qizp3nM6M9iECgYEA8LbotwPbHZKuyaui\nGiRpvuw5+UDbY30MIbmDNsp0z8XOeN1JcVOOcCFUZijvEO/NQXtmpkJKb2L0nvVI\nGdENDIGSzpZ+T3k5WUCgLsl/Nu50rlYc4uJI8+tUWkAIVIjyqZomaiTHqX8j3dXK\nmHaYKWYTGKSvsvTTylQrquwRe4MCgYEA16iI8ObGYbNHcebk3yqA19ze/45X4x2e\ncT0d/DqwtcR5H06B/dru/mlUtdBv/Snt8FaQ1a89kp94KrV1bU9aDUY2R5lKhyQu\nZAZtQvRwmAuT7hRgnE+MQe4cD+PGzbo6zNjFeIH7oqu0tpAG/WOCqT7Qga8gPaK1\n+RFlfLrrHxkCgYEA4hxegzObCq9zgjq33Wig8FfDqU/0BQM8dx1klP4eNeFwLnZm\n+43qeYfFWOVQk48+NiltZfVVKEZC1GJBJQcLA9lfBrG02oBbj2w2S1y5I+dgMTbw\nkWrP7lf693+4k3fEwe3r8b600pF8JnAhi4+zJQgeHgLsi+SQYTkpf7eaQHMCgYEA\nzyOOBPVkbssoQHsqMkA86Rm5B3XNbNQyL0oo1u/4c153iF579TyoeazqNIg0SNJR\nPJupGdXsKj0JytvoIkopkL5zvGm8b/mMpX6Wy8zFqQTV3cOs1/aAHYN7aLe7aDcL\n6136rjkLXb/XH9NPI2rFQZKX6zgum4UBjG3tMNTIqWECgYBJ2bQF0R63HTZu7/Cq\nvXa+fxFDkrxMVNt6rAp75cXpdrM20cs8xxu6irBdk8bGKLA25ntp/Kx1ShYsnLV9\n1qiCgOLroEtA3dkSHDYmz4oC7bf6vrsHVWm1QKRUOXkgkqH9q/vIBgZ2xlMfSXsb\nGioyD1JD7p7bkQ3D9ymMOG+Mow==\n-----END PRIVATE KEY-----\n'),
(352, 'enrol_manual', 'version', '2023100900'),
(354, 'enrol_meta', 'version', '2023100900'),
(356, 'enrol_mnet', 'version', '2023100900'),
(357, 'enrol_paypal', 'version', '2023100900'),
(358, 'enrol_self', 'version', '2023100900'),
(360, 'message_airnotifier', 'version', '2023100900'),
(362, 'message', 'airnotifier_provider_enrol_flatfile_flatfile_enrolment_locked', '0'),
(363, 'message', 'airnotifier_provider_enrol_imsenterprise_imsenterprise_enrolment_locked', '0'),
(364, 'message', 'airnotifier_provider_enrol_manual_expiry_notification_locked', '0'),
(365, 'message', 'airnotifier_provider_enrol_paypal_paypal_enrolment_locked', '0'),
(366, 'message', 'airnotifier_provider_enrol_self_expiry_notification_locked', '0'),
(367, 'message', 'airnotifier_provider_mod_assign_assign_notification_locked', '0'),
(368, 'message', 'airnotifier_provider_mod_bigbluebuttonbn_recording_ready_locked', '0'),
(369, 'message', 'airnotifier_provider_mod_bigbluebuttonbn_instance_updated_locked', '0'),
(370, 'message', 'airnotifier_provider_mod_feedback_submission_locked', '0'),
(371, 'message', 'airnotifier_provider_mod_feedback_message_locked', '0'),
(372, 'message', 'airnotifier_provider_mod_forum_posts_locked', '0'),
(373, 'message', 'message_provider_mod_forum_posts_enabled', 'email,airnotifier'),
(374, 'message', 'airnotifier_provider_mod_forum_digests_locked', '0'),
(375, 'message', 'airnotifier_provider_mod_lesson_graded_essay_locked', '0'),
(376, 'message', 'message_provider_mod_lesson_graded_essay_enabled', 'email,airnotifier'),
(377, 'message', 'airnotifier_provider_mod_quiz_submission_locked', '0'),
(378, 'message', 'airnotifier_provider_mod_quiz_confirmation_locked', '0'),
(379, 'message', 'message_provider_mod_quiz_confirmation_enabled', 'email,airnotifier'),
(380, 'message', 'airnotifier_provider_mod_quiz_attempt_overdue_locked', '0'),
(381, 'message', 'message_provider_mod_quiz_attempt_overdue_enabled', 'email,airnotifier'),
(382, 'message', 'airnotifier_provider_mod_quiz_attempt_grading_complete_locked', '0'),
(383, 'message', 'message_provider_mod_quiz_attempt_grading_complete_enabled', 'email,airnotifier'),
(384, 'message', 'airnotifier_provider_moodle_newlogin_locked', '0'),
(385, 'message', 'message_provider_moodle_newlogin_enabled', 'email,airnotifier'),
(386, 'message', 'airnotifier_provider_moodle_notices_locked', '0'),
(387, 'message', 'airnotifier_provider_moodle_errors_locked', '0'),
(388, 'message', 'airnotifier_provider_moodle_availableupdate_locked', '0'),
(389, 'message', 'airnotifier_provider_moodle_instantmessage_locked', '0'),
(390, 'message', 'airnotifier_provider_moodle_backup_locked', '0'),
(391, 'message', 'airnotifier_provider_moodle_courserequested_locked', '0'),
(392, 'message', 'airnotifier_provider_moodle_courserequestapproved_locked', '0'),
(393, 'message', 'message_provider_moodle_courserequestapproved_enabled', 'email,airnotifier'),
(394, 'message', 'airnotifier_provider_moodle_courserequestrejected_locked', '0'),
(395, 'message', 'message_provider_moodle_courserequestrejected_enabled', 'email,airnotifier'),
(396, 'message', 'airnotifier_provider_moodle_coursecompleted_locked', '0'),
(397, 'message', 'message_provider_moodle_coursecompleted_enabled', 'email,airnotifier'),
(398, 'message', 'airnotifier_provider_moodle_coursecontentupdated_locked', '0'),
(399, 'message', 'message_provider_moodle_coursecontentupdated_enabled', 'popup,email,airnotifier'),
(400, 'message', 'airnotifier_provider_moodle_badgerecipientnotice_locked', '0'),
(401, 'message', 'message_provider_moodle_badgerecipientnotice_enabled', 'popup,email,airnotifier'),
(402, 'message', 'airnotifier_provider_moodle_badgecreatornotice_locked', '0'),
(403, 'message', 'airnotifier_provider_moodle_competencyplancomment_locked', '0'),
(404, 'message', 'airnotifier_provider_moodle_competencyusercompcomment_locked', '0'),
(405, 'message', 'airnotifier_provider_moodle_insights_locked', '0'),
(406, 'message', 'message_provider_moodle_insights_enabled', 'popup,email,airnotifier'),
(407, 'message', 'airnotifier_provider_moodle_messagecontactrequests_locked', '0'),
(408, 'message', 'message_provider_moodle_messagecontactrequests_enabled', 'email,airnotifier'),
(409, 'message', 'airnotifier_provider_moodle_asyncbackupnotification_locked', '0'),
(410, 'message', 'airnotifier_provider_moodle_gradenotifications_locked', '0'),
(411, 'message', 'airnotifier_provider_moodle_infected_locked', '0'),
(412, 'message', 'airnotifier_provider_moodle_reportbuilderschedule_locked', '0'),
(413, 'message_email', 'version', '2023100900'),
(415, 'message', 'email_provider_enrol_flatfile_flatfile_enrolment_locked', '0'),
(416, 'message', 'message_provider_enrol_flatfile_flatfile_enrolment_enabled', 'email'),
(417, 'message', 'email_provider_enrol_imsenterprise_imsenterprise_enrolment_locked', '0'),
(418, 'message', 'message_provider_enrol_imsenterprise_imsenterprise_enrolment_enabled', 'email'),
(419, 'message', 'email_provider_enrol_manual_expiry_notification_locked', '0'),
(420, 'message', 'message_provider_enrol_manual_expiry_notification_enabled', 'email'),
(421, 'message', 'email_provider_enrol_paypal_paypal_enrolment_locked', '0'),
(422, 'message', 'message_provider_enrol_paypal_paypal_enrolment_enabled', 'email'),
(423, 'message', 'email_provider_enrol_self_expiry_notification_locked', '0'),
(424, 'message', 'message_provider_enrol_self_expiry_notification_enabled', 'email'),
(425, 'message', 'email_provider_mod_assign_assign_notification_locked', '0'),
(426, 'message', 'message_provider_mod_assign_assign_notification_enabled', 'email'),
(427, 'message', 'email_provider_mod_bigbluebuttonbn_recording_ready_locked', '0'),
(428, 'message', 'message_provider_mod_bigbluebuttonbn_recording_ready_enabled', 'email'),
(429, 'message', 'email_provider_mod_bigbluebuttonbn_instance_updated_locked', '0'),
(430, 'message', 'message_provider_mod_bigbluebuttonbn_instance_updated_enabled', 'email'),
(431, 'message', 'email_provider_mod_feedback_submission_locked', '0'),
(432, 'message', 'message_provider_mod_feedback_submission_enabled', 'email'),
(433, 'message', 'email_provider_mod_feedback_message_locked', '0'),
(434, 'message', 'message_provider_mod_feedback_message_enabled', 'email'),
(435, 'message', 'email_provider_mod_forum_posts_locked', '0'),
(436, 'message', 'email_provider_mod_forum_digests_locked', '0'),
(437, 'message', 'message_provider_mod_forum_digests_enabled', 'email'),
(438, 'message', 'email_provider_mod_lesson_graded_essay_locked', '0'),
(439, 'message', 'email_provider_mod_quiz_submission_locked', '0'),
(440, 'message', 'message_provider_mod_quiz_submission_enabled', 'email'),
(441, 'message', 'email_provider_mod_quiz_confirmation_locked', '0'),
(442, 'message', 'email_provider_mod_quiz_attempt_overdue_locked', '0'),
(443, 'message', 'email_provider_mod_quiz_attempt_grading_complete_locked', '0'),
(444, 'message', 'email_provider_moodle_newlogin_locked', '0'),
(445, 'message', 'email_provider_moodle_notices_locked', '0'),
(446, 'message', 'message_provider_moodle_notices_enabled', 'email'),
(447, 'message', 'email_provider_moodle_errors_locked', '0'),
(448, 'message', 'message_provider_moodle_errors_enabled', 'email'),
(449, 'message', 'email_provider_moodle_availableupdate_locked', '0'),
(450, 'message', 'message_provider_moodle_availableupdate_enabled', 'email'),
(451, 'message', 'email_provider_moodle_instantmessage_locked', '0'),
(452, 'message', 'message_provider_moodle_instantmessage_enabled', 'popup,email'),
(453, 'message', 'email_provider_moodle_backup_locked', '0'),
(454, 'message', 'message_provider_moodle_backup_enabled', 'email'),
(455, 'message', 'email_provider_moodle_courserequested_locked', '0'),
(456, 'message', 'message_provider_moodle_courserequested_enabled', 'email'),
(457, 'message', 'email_provider_moodle_courserequestapproved_locked', '0'),
(458, 'message', 'email_provider_moodle_courserequestrejected_locked', '0'),
(459, 'message', 'email_provider_moodle_coursecompleted_locked', '0'),
(460, 'message', 'email_provider_moodle_coursecontentupdated_locked', '0'),
(461, 'message', 'email_provider_moodle_badgerecipientnotice_locked', '0'),
(462, 'message', 'email_provider_moodle_badgecreatornotice_locked', '0'),
(463, 'message', 'message_provider_moodle_badgecreatornotice_enabled', 'email'),
(464, 'message', 'email_provider_moodle_competencyplancomment_locked', '0'),
(465, 'message', 'message_provider_moodle_competencyplancomment_enabled', 'email'),
(466, 'message', 'email_provider_moodle_competencyusercompcomment_locked', '0'),
(467, 'message', 'message_provider_moodle_competencyusercompcomment_enabled', 'email'),
(468, 'message', 'email_provider_moodle_insights_locked', '0'),
(469, 'message', 'email_provider_moodle_messagecontactrequests_locked', '0'),
(470, 'message', 'email_provider_moodle_asyncbackupnotification_locked', '0'),
(471, 'message', 'message_provider_moodle_asyncbackupnotification_enabled', 'popup,email'),
(472, 'message', 'email_provider_moodle_gradenotifications_locked', '0'),
(473, 'message', 'message_provider_moodle_gradenotifications_enabled', 'popup,email'),
(474, 'message', 'email_provider_moodle_infected_locked', '0'),
(475, 'message', 'message_provider_moodle_infected_enabled', 'email'),
(476, 'message', 'email_provider_moodle_reportbuilderschedule_locked', '1'),
(477, 'message', 'message_provider_moodle_reportbuilderschedule_enabled', 'email'),
(478, 'message_popup', 'version', '2023100900'),
(480, 'message', 'popup_provider_enrol_flatfile_flatfile_enrolment_locked', '0'),
(481, 'message', 'popup_provider_enrol_imsenterprise_imsenterprise_enrolment_locked', '0'),
(482, 'message', 'popup_provider_enrol_manual_expiry_notification_locked', '0'),
(483, 'message', 'popup_provider_enrol_paypal_paypal_enrolment_locked', '0'),
(484, 'message', 'popup_provider_enrol_self_expiry_notification_locked', '0'),
(485, 'message', 'popup_provider_mod_assign_assign_notification_locked', '0'),
(486, 'message', 'popup_provider_mod_bigbluebuttonbn_recording_ready_locked', '0'),
(487, 'message', 'popup_provider_mod_bigbluebuttonbn_instance_updated_locked', '0'),
(488, 'message', 'popup_provider_mod_feedback_submission_locked', '0'),
(489, 'message', 'popup_provider_mod_feedback_message_locked', '0'),
(490, 'message', 'popup_provider_mod_forum_posts_locked', '0'),
(491, 'message', 'popup_provider_mod_forum_digests_locked', '0'),
(492, 'message', 'popup_provider_mod_lesson_graded_essay_locked', '0'),
(493, 'message', 'popup_provider_mod_quiz_submission_locked', '0'),
(494, 'message', 'popup_provider_mod_quiz_confirmation_locked', '0'),
(495, 'message', 'popup_provider_mod_quiz_attempt_overdue_locked', '0'),
(496, 'message', 'popup_provider_mod_quiz_attempt_grading_complete_locked', '0'),
(497, 'message', 'popup_provider_moodle_newlogin_locked', '0'),
(498, 'message', 'popup_provider_moodle_notices_locked', '0'),
(499, 'message', 'popup_provider_moodle_errors_locked', '0'),
(500, 'message', 'popup_provider_moodle_availableupdate_locked', '0'),
(501, 'message', 'popup_provider_moodle_instantmessage_locked', '0'),
(502, 'message', 'popup_provider_moodle_backup_locked', '0'),
(503, 'message', 'popup_provider_moodle_courserequested_locked', '0'),
(504, 'message', 'popup_provider_moodle_courserequestapproved_locked', '0'),
(505, 'message', 'popup_provider_moodle_courserequestrejected_locked', '0'),
(506, 'message', 'popup_provider_moodle_coursecompleted_locked', '0'),
(507, 'message', 'popup_provider_moodle_coursecontentupdated_locked', '0'),
(508, 'message', 'popup_provider_moodle_badgerecipientnotice_locked', '0'),
(509, 'message', 'popup_provider_moodle_badgecreatornotice_locked', '0'),
(510, 'message', 'popup_provider_moodle_competencyplancomment_locked', '0'),
(511, 'message', 'popup_provider_moodle_competencyusercompcomment_locked', '0'),
(512, 'message', 'popup_provider_moodle_insights_locked', '0'),
(513, 'message', 'popup_provider_moodle_messagecontactrequests_locked', '0'),
(514, 'message', 'popup_provider_moodle_asyncbackupnotification_locked', '0'),
(515, 'message', 'popup_provider_moodle_gradenotifications_locked', '0'),
(516, 'message', 'popup_provider_moodle_infected_locked', '0'),
(517, 'message', 'popup_provider_moodle_reportbuilderschedule_locked', '0'),
(518, 'block_accessreview', 'version', '2023100900'),
(519, 'block_activity_modules', 'version', '2023100900'),
(520, 'block_activity_results', 'version', '2023100900'),
(521, 'block_admin_bookmarks', 'version', '2023100900'),
(522, 'block_badges', 'version', '2023100900'),
(523, 'block_blog_menu', 'version', '2023100900'),
(524, 'block_blog_recent', 'version', '2023100900'),
(525, 'block_blog_tags', 'version', '2023100900'),
(526, 'block_calendar_month', 'version', '2023100900'),
(527, 'block_calendar_upcoming', 'version', '2023100900'),
(528, 'block_comments', 'version', '2023100900'),
(529, 'block_completionstatus', 'version', '2023100900'),
(530, 'block_course_list', 'version', '2023100900'),
(531, 'block_course_summary', 'version', '2023100900'),
(533, 'block_feedback', 'version', '2023100900'),
(535, 'block_globalsearch', 'version', '2023100900'),
(536, 'block_glossary_random', 'version', '2023100900'),
(537, 'block_html', 'version', '2023100900'),
(538, 'block_login', 'version', '2023100900'),
(539, 'block_lp', 'version', '2023100900'),
(540, 'block_mentees', 'version', '2023100900'),
(541, 'block_mnet_hosts', 'version', '2023100900'),
(542, 'block_myoverview', 'version', '2023100900'),
(543, 'block_myprofile', 'version', '2023100900'),
(544, 'block_navigation', 'version', '2023100900'),
(545, 'block_news_items', 'version', '2023100900'),
(546, 'block_online_users', 'version', '2023100900'),
(547, 'block_private_files', 'version', '2023100900'),
(548, 'block_recent_activity', 'version', '2023100900'),
(549, 'block_recentlyaccessedcourses', 'version', '2023100900'),
(551, 'block_recentlyaccesseditems', 'version', '2023100900'),
(552, 'block_rss_client', 'version', '2023100900'),
(554, 'block_search_forums', 'version', '2023100900'),
(555, 'block_section_links', 'version', '2023100900'),
(556, 'block_selfcompletion', 'version', '2023100900'),
(558, 'block_settings', 'version', '2023100900'),
(559, 'block_site_main_menu', 'version', '2023100900'),
(560, 'block_social_activities', 'version', '2023100900'),
(561, 'block_starredcourses', 'version', '2023100900'),
(562, 'block_tag_flickr', 'version', '2023100900'),
(563, 'block_tag_youtube', 'version', '2023100900'),
(565, 'block_tags', 'version', '2023100900'),
(566, 'block_timeline', 'version', '2023100900'),
(568, 'media_html5audio', 'version', '2023100900'),
(569, 'media_html5video', 'version', '2023100900'),
(570, 'media_videojs', 'version', '2023100900'),
(571, 'media_vimeo', 'version', '2023100900'),
(572, 'media_youtube', 'version', '2023100900'),
(573, 'filter_activitynames', 'version', '2023100900'),
(575, 'filter_algebra', 'version', '2023100900'),
(576, 'filter_codehighlighter', 'version', '2023100900'),
(577, 'filter_data', 'version', '2023100900'),
(579, 'filter_displayh5p', 'version', '2023100900'),
(581, 'filter_emailprotect', 'version', '2023100900'),
(582, 'filter_emoticon', 'version', '2023100900'),
(584, 'filter_glossary', 'version', '2023100900'),
(586, 'filter_mathjaxloader', 'version', '2023100900'),
(588, 'filter_mediaplugin', 'version', '2023100900'),
(590, 'filter_multilang', 'version', '2023100900'),
(591, 'filter_tex', 'version', '2023100900'),
(593, 'filter_tidy', 'version', '2023100900'),
(594, 'filter_urltolink', 'version', '2023100900'),
(596, 'editor_atto', 'version', '2023100900'),
(597, 'editor_textarea', 'version', '2023100900'),
(598, 'editor_tiny', 'version', '2023100900'),
(600, 'format_singleactivity', 'version', '2023100900'),
(601, 'format_social', 'version', '2023100900'),
(602, 'format_topics', 'version', '2023100900'),
(603, 'format_weeks', 'version', '2023100900'),
(604, 'dataformat_csv', 'version', '2023100900'),
(605, 'dataformat_excel', 'version', '2023100900'),
(606, 'dataformat_html', 'version', '2023100900'),
(607, 'dataformat_json', 'version', '2023100900'),
(608, 'dataformat_ods', 'version', '2023100900'),
(609, 'dataformat_pdf', 'version', '2023100900'),
(610, 'profilefield_checkbox', 'version', '2023100900'),
(611, 'profilefield_datetime', 'version', '2023100900'),
(612, 'profilefield_menu', 'version', '2023100900'),
(613, 'profilefield_social', 'version', '2023100900'),
(614, 'profilefield_text', 'version', '2023100900'),
(615, 'profilefield_textarea', 'version', '2023100900'),
(616, 'report_backups', 'version', '2023100900'),
(617, 'report_competency', 'version', '2023100900'),
(618, 'report_completion', 'version', '2023100900'),
(620, 'report_configlog', 'version', '2023100900'),
(621, 'report_courseoverview', 'version', '2023100900'),
(622, 'report_eventlist', 'version', '2023100900'),
(623, 'report_infectedfiles', 'version', '2023100900'),
(624, 'report_insights', 'version', '2023100900'),
(625, 'report_log', 'version', '2023100900'),
(627, 'report_loglive', 'version', '2023100900'),
(628, 'report_outline', 'version', '2023100900'),
(630, 'report_participation', 'version', '2023100900'),
(632, 'report_performance', 'version', '2023100900'),
(633, 'report_progress', 'version', '2023100900'),
(635, 'report_questioninstances', 'version', '2023100900'),
(636, 'report_security', 'version', '2023100900'),
(637, 'report_stats', 'version', '2023100900'),
(639, 'report_status', 'version', '2023100900'),
(640, 'report_usersessions', 'version', '2023100900'),
(641, 'gradeexport_ods', 'version', '2023100900'),
(642, 'gradeexport_txt', 'version', '2023100900'),
(643, 'gradeexport_xls', 'version', '2023100900'),
(644, 'gradeexport_xml', 'version', '2023100900'),
(645, 'gradeimport_csv', 'version', '2023100900'),
(646, 'gradeimport_direct', 'version', '2023100900'),
(647, 'gradeimport_xml', 'version', '2023100900'),
(648, 'gradereport_grader', 'version', '2023100900'),
(649, 'gradereport_history', 'version', '2023100900'),
(650, 'gradereport_outcomes', 'version', '2023100900'),
(651, 'gradereport_overview', 'version', '2023100900'),
(652, 'gradereport_singleview', 'version', '2023100900'),
(653, 'gradereport_summary', 'version', '2023100900'),
(654, 'gradereport_user', 'version', '2023100900'),
(655, 'gradingform_guide', 'version', '2023100900'),
(656, 'gradingform_rubric', 'version', '2023100900'),
(657, 'mlbackend_php', 'version', '2023100900'),
(658, 'mlbackend_python', 'version', '2023100900'),
(659, 'mnetservice_enrol', 'version', '2023100900'),
(660, 'webservice_rest', 'version', '2023100900'),
(661, 'webservice_soap', 'version', '2023100900'),
(662, 'repository_areafiles', 'version', '2023100900'),
(664, 'areafiles', 'enablecourseinstances', '0'),
(665, 'areafiles', 'enableuserinstances', '0'),
(666, 'repository_contentbank', 'version', '2023100900'),
(668, 'contentbank', 'enablecourseinstances', '0'),
(669, 'contentbank', 'enableuserinstances', '0'),
(670, 'repository_coursefiles', 'version', '2023100900'),
(671, 'repository_dropbox', 'version', '2023100900'),
(672, 'repository_equella', 'version', '2023100900'),
(673, 'repository_filesystem', 'version', '2023100900'),
(674, 'repository_flickr', 'version', '2023100900'),
(675, 'repository_flickr_public', 'version', '2023100900'),
(676, 'repository_googledocs', 'version', '2023100900'),
(677, 'repository_local', 'version', '2023100900'),
(679, 'local', 'enablecourseinstances', '0'),
(680, 'local', 'enableuserinstances', '0'),
(681, 'repository_merlot', 'version', '2023100900'),
(682, 'repository_nextcloud', 'version', '2023100900'),
(683, 'repository_onedrive', 'version', '2023100900'),
(684, 'repository_recent', 'version', '2023100900'),
(686, 'recent', 'enablecourseinstances', '0'),
(687, 'recent', 'enableuserinstances', '0'),
(688, 'repository_s3', 'version', '2023100900'),
(689, 'repository_upload', 'version', '2023100900'),
(691, 'upload', 'enablecourseinstances', '0'),
(692, 'upload', 'enableuserinstances', '0'),
(693, 'repository_url', 'version', '2023100900'),
(695, 'url', 'enablecourseinstances', '0'),
(696, 'url', 'enableuserinstances', '0'),
(697, 'repository_user', 'version', '2023100900'),
(699, 'user', 'enablecourseinstances', '0'),
(700, 'user', 'enableuserinstances', '0'),
(701, 'repository_webdav', 'version', '2023100900'),
(702, 'repository_wikimedia', 'version', '2023100900'),
(704, 'wikimedia', 'enablecourseinstances', '0'),
(705, 'wikimedia', 'enableuserinstances', '0'),
(706, 'repository_youtube', 'version', '2023100900'),
(708, 'portfolio_download', 'version', '2023100900'),
(709, 'portfolio_flickr', 'version', '2023100900'),
(710, 'portfolio_googledocs', 'version', '2023100900'),
(711, 'portfolio_mahara', 'version', '2023100900'),
(712, 'search_simpledb', 'version', '2023100900'),
(714, 'search_solr', 'version', '2023100900'),
(715, 'qbank_bulkmove', 'version', '2023100900'),
(716, 'qbank_columnsortorder', 'version', '2023100900'),
(717, 'qbank_comment', 'version', '2023100900'),
(718, 'qbank_customfields', 'version', '2023100900'),
(719, 'qbank_deletequestion', 'version', '2023100900'),
(720, 'qbank_editquestion', 'version', '2023100900'),
(721, 'qbank_exportquestions', 'version', '2023100900'),
(722, 'qbank_exporttoxml', 'version', '2023100900'),
(723, 'qbank_history', 'version', '2023100900'),
(724, 'qbank_importquestions', 'version', '2023100900'),
(725, 'qbank_managecategories', 'version', '2023100900'),
(726, 'qbank_previewquestion', 'version', '2023100900'),
(727, 'qbank_statistics', 'version', '2023100900'),
(728, 'qbank_tagquestion', 'version', '2023100900'),
(729, 'qbank_usage', 'version', '2023100900'),
(730, 'qbank_viewcreator', 'version', '2023100900'),
(731, 'qbank_viewquestionname', 'version', '2023100900'),
(732, 'qbank_viewquestiontext', 'version', '2023100900'),
(733, 'qbank_viewquestiontype', 'version', '2023100900'),
(734, 'qbehaviour_adaptive', 'version', '2023100900'),
(735, 'qbehaviour_adaptivenopenalty', 'version', '2023100900'),
(736, 'qbehaviour_deferredcbm', 'version', '2023100900'),
(737, 'qbehaviour_deferredfeedback', 'version', '2023100900'),
(738, 'qbehaviour_immediatecbm', 'version', '2023100900'),
(739, 'qbehaviour_immediatefeedback', 'version', '2023100900'),
(740, 'qbehaviour_informationitem', 'version', '2023100900'),
(741, 'qbehaviour_interactive', 'version', '2023100900'),
(742, 'qbehaviour_interactivecountback', 'version', '2023100900'),
(743, 'qbehaviour_manualgraded', 'version', '2023100900'),
(745, 'question', 'disabledbehaviours', 'manualgraded'),
(746, 'qbehaviour_missing', 'version', '2023100900'),
(747, 'qformat_aiken', 'version', '2023100900'),
(748, 'qformat_blackboard_six', 'version', '2023100900'),
(749, 'qformat_gift', 'version', '2023100900'),
(750, 'qformat_missingword', 'version', '2023100900'),
(751, 'qformat_multianswer', 'version', '2023100900'),
(752, 'qformat_xhtml', 'version', '2023100900'),
(753, 'qformat_xml', 'version', '2023100900'),
(754, 'tool_admin_presets', 'version', '2023100900'),
(755, 'tool_analytics', 'version', '2023100900'),
(756, 'tool_availabilityconditions', 'version', '2023100900'),
(757, 'tool_behat', 'version', '2023100900'),
(758, 'tool_brickfield', 'version', '2023100900'),
(760, 'tool_capability', 'version', '2023100900'),
(761, 'tool_cohortroles', 'version', '2023100900'),
(762, 'tool_componentlibrary', 'version', '2023100900'),
(763, 'tool_customlang', 'version', '2023100900'),
(765, 'tool_dataprivacy', 'version', '2023100900'),
(766, 'message', 'airnotifier_provider_tool_dataprivacy_contactdataprotectionofficer_locked', '0'),
(767, 'message', 'email_provider_tool_dataprivacy_contactdataprotectionofficer_locked', '0'),
(768, 'message', 'popup_provider_tool_dataprivacy_contactdataprotectionofficer_locked', '0'),
(769, 'message', 'message_provider_tool_dataprivacy_contactdataprotectionofficer_enabled', 'email,popup'),
(770, 'message', 'airnotifier_provider_tool_dataprivacy_datarequestprocessingresults_locked', '0'),
(771, 'message', 'email_provider_tool_dataprivacy_datarequestprocessingresults_locked', '0'),
(772, 'message', 'popup_provider_tool_dataprivacy_datarequestprocessingresults_locked', '0'),
(773, 'message', 'message_provider_tool_dataprivacy_datarequestprocessingresults_enabled', 'email,popup'),
(774, 'message', 'airnotifier_provider_tool_dataprivacy_notifyexceptions_locked', '0'),
(775, 'message', 'email_provider_tool_dataprivacy_notifyexceptions_locked', '0'),
(776, 'message', 'popup_provider_tool_dataprivacy_notifyexceptions_locked', '0'),
(777, 'message', 'message_provider_tool_dataprivacy_notifyexceptions_enabled', 'email'),
(778, 'tool_dbtransfer', 'version', '2023100900'),
(779, 'tool_filetypes', 'version', '2023100900'),
(780, 'tool_generator', 'version', '2023100900'),
(781, 'tool_httpsreplace', 'version', '2023100900'),
(782, 'tool_innodb', 'version', '2023100900'),
(783, 'tool_installaddon', 'version', '2023100900'),
(784, 'tool_langimport', 'version', '2023100900'),
(785, 'tool_licensemanager', 'version', '2023100900'),
(786, 'tool_log', 'version', '2023100900'),
(788, 'tool_log', 'enabled_stores', 'logstore_standard'),
(789, 'tool_lp', 'version', '2023100900'),
(790, 'tool_lpimportcsv', 'version', '2023100900'),
(791, 'tool_lpmigrate', 'version', '2023100900'),
(792, 'tool_messageinbound', 'version', '2023100900'),
(793, 'message', 'airnotifier_provider_tool_messageinbound_invalidrecipienthandler_locked', '0'),
(794, 'message', 'email_provider_tool_messageinbound_invalidrecipienthandler_locked', '0'),
(795, 'message', 'popup_provider_tool_messageinbound_invalidrecipienthandler_locked', '0'),
(796, 'message', 'message_provider_tool_messageinbound_invalidrecipienthandler_enabled', 'email'),
(797, 'message', 'airnotifier_provider_tool_messageinbound_messageprocessingerror_locked', '0'),
(798, 'message', 'email_provider_tool_messageinbound_messageprocessingerror_locked', '0'),
(799, 'message', 'popup_provider_tool_messageinbound_messageprocessingerror_locked', '0'),
(800, 'message', 'message_provider_tool_messageinbound_messageprocessingerror_enabled', 'email'),
(801, 'message', 'airnotifier_provider_tool_messageinbound_messageprocessingsuccess_locked', '0'),
(802, 'message', 'email_provider_tool_messageinbound_messageprocessingsuccess_locked', '0'),
(803, 'message', 'popup_provider_tool_messageinbound_messageprocessingsuccess_locked', '0'),
(804, 'message', 'message_provider_tool_messageinbound_messageprocessingsuccess_enabled', 'email'),
(805, 'tool_mfa', 'version', '2023100900'),
(806, 'tool_mobile', 'version', '2023100900'),
(807, 'tool_monitor', 'version', '2023100900'),
(808, 'message', 'airnotifier_provider_tool_monitor_notification_locked', '0'),
(809, 'message', 'email_provider_tool_monitor_notification_locked', '0'),
(810, 'message', 'popup_provider_tool_monitor_notification_locked', '0'),
(811, 'message', 'message_provider_tool_monitor_notification_enabled', 'email'),
(812, 'tool_moodlenet', 'version', '2023100900'),
(814, 'tool_multilangupgrade', 'version', '2023100900'),
(815, 'tool_oauth2', 'version', '2023100900'),
(816, 'tool_phpunit', 'version', '2023100900'),
(817, 'tool_policy', 'version', '2023100900'),
(818, 'tool_profiling', 'version', '2023100900'),
(819, 'tool_recyclebin', 'version', '2023100900'),
(820, 'tool_replace', 'version', '2023100900'),
(821, 'tool_spamcleaner', 'version', '2023100900'),
(822, 'tool_task', 'version', '2023100900'),
(823, 'tool_templatelibrary', 'version', '2023100900'),
(824, 'tool_unsuproles', 'version', '2023100900'),
(826, 'tool_uploadcourse', 'version', '2023100900'),
(827, 'tool_uploaduser', 'version', '2023100900'),
(828, 'tool_usertours', 'version', '2023100900'),
(830, 'tool_xmldb', 'version', '2023100900'),
(831, 'cachestore_apcu', 'version', '2023100900'),
(832, 'cachestore_file', 'version', '2023100900'),
(833, 'cachestore_redis', 'version', '2023100900'),
(834, 'cachestore_session', 'version', '2023100900'),
(835, 'cachestore_static', 'version', '2023100900'),
(836, 'cachelock_file', 'version', '2023100900'),
(837, 'fileconverter_googledrive', 'version', '2023100900'),
(838, 'fileconverter_unoconv', 'version', '2023100900'),
(840, 'contenttype_h5p', 'version', '2023100900'),
(841, 'theme_boost', 'version', '2023100900'),
(842, 'theme_classic', 'version', '2023100900'),
(843, 'h5plib_v124', 'version', '2023100900'),
(844, 'paygw_paypal', 'version', '2023100900'),
(846, 'assignsubmission_comments', 'version', '2023100900'),
(848, 'assignsubmission_file', 'sortorder', '1'),
(849, 'assignsubmission_comments', 'sortorder', '2'),
(850, 'assignsubmission_onlinetext', 'sortorder', '0'),
(851, 'assignsubmission_file', 'version', '2023100900'),
(852, 'assignsubmission_onlinetext', 'version', '2023100900'),
(854, 'assignfeedback_comments', 'version', '2023100900'),
(856, 'assignfeedback_comments', 'sortorder', '0'),
(857, 'assignfeedback_editpdf', 'sortorder', '1'),
(858, 'assignfeedback_file', 'sortorder', '3'),
(859, 'assignfeedback_offline', 'sortorder', '2'),
(860, 'assignfeedback_editpdf', 'version', '2023100900'),
(862, 'assignfeedback_file', 'version', '2023100900'),
(864, 'assignfeedback_offline', 'version', '2023100900'),
(865, 'booktool_exportimscp', 'version', '2023100900'),
(866, 'booktool_importhtml', 'version', '2023100900'),
(867, 'booktool_print', 'version', '2023100900'),
(868, 'datafield_checkbox', 'version', '2023100900'),
(869, 'datafield_date', 'version', '2023100900'),
(870, 'datafield_file', 'version', '2023100900'),
(871, 'datafield_latlong', 'version', '2023100900'),
(872, 'datafield_menu', 'version', '2023100900'),
(873, 'datafield_multimenu', 'version', '2023100900'),
(874, 'datafield_number', 'version', '2023100900'),
(875, 'datafield_picture', 'version', '2023100900'),
(876, 'datafield_radiobutton', 'version', '2023100900'),
(877, 'datafield_text', 'version', '2023100900'),
(878, 'datafield_textarea', 'version', '2023100900'),
(879, 'datafield_url', 'version', '2023100900'),
(880, 'datapreset_imagegallery', 'version', '2023100900'),
(881, 'datapreset_journal', 'version', '2023100900'),
(882, 'datapreset_proposals', 'version', '2023100900'),
(883, 'datapreset_resources', 'version', '2023100900'),
(884, 'forumreport_summary', 'version', '2023100900'),
(885, 'ltiservice_basicoutcomes', 'version', '2023100900'),
(886, 'ltiservice_gradebookservices', 'version', '2023100900'),
(887, 'ltiservice_memberships', 'version', '2023100900'),
(888, 'ltiservice_profile', 'version', '2023100900'),
(889, 'ltiservice_toolproxy', 'version', '2023100900'),
(890, 'ltiservice_toolsettings', 'version', '2023100900'),
(891, 'quiz_grading', 'version', '2023100900'),
(893, 'quiz_overview', 'version', '2023100900'),
(895, 'quiz_responses', 'version', '2023100900'),
(897, 'quiz_statistics', 'version', '2023100900'),
(899, 'quizaccess_delaybetweenattempts', 'version', '2023100900'),
(900, 'quizaccess_ipaddress', 'version', '2023100900'),
(901, 'quizaccess_numattempts', 'version', '2023100900'),
(902, 'quizaccess_offlineattempts', 'version', '2023100900'),
(903, 'quizaccess_openclosedate', 'version', '2023100900'),
(904, 'quizaccess_password', 'version', '2023100900'),
(905, 'quizaccess_seb', 'version', '2023100900'),
(907, 'quizaccess_securewindow', 'version', '2023100900'),
(908, 'quizaccess_timelimit', 'version', '2023100900'),
(909, 'scormreport_basic', 'version', '2023100900'),
(910, 'scormreport_graphs', 'version', '2023100900'),
(911, 'scormreport_interactions', 'version', '2023100900'),
(912, 'scormreport_objectives', 'version', '2023100900'),
(913, 'workshopform_accumulative', 'version', '2023100900'),
(915, 'workshopform_comments', 'version', '2023100900'),
(917, 'workshopform_numerrors', 'version', '2023100900'),
(919, 'workshopform_rubric', 'version', '2023100900'),
(921, 'workshopallocation_manual', 'version', '2023100900'),
(922, 'workshopallocation_random', 'version', '2023100900'),
(923, 'workshopallocation_scheduled', 'version', '2023100900'),
(924, 'workshopeval_best', 'version', '2023100900'),
(925, 'atto_accessibilitychecker', 'version', '2023100900'),
(926, 'atto_accessibilityhelper', 'version', '2023100900'),
(927, 'atto_align', 'version', '2023100900'),
(928, 'atto_backcolor', 'version', '2023100900'),
(929, 'atto_bold', 'version', '2023100900'),
(930, 'atto_charmap', 'version', '2023100900'),
(931, 'atto_clear', 'version', '2023100900'),
(932, 'atto_collapse', 'version', '2023100900'),
(933, 'atto_emojipicker', 'version', '2023100900'),
(934, 'atto_emoticon', 'version', '2023100900'),
(935, 'atto_equation', 'version', '2023100900'),
(936, 'atto_fontcolor', 'version', '2023100900'),
(937, 'atto_h5p', 'version', '2023100900'),
(938, 'atto_html', 'version', '2023100900'),
(939, 'atto_image', 'version', '2023100900'),
(940, 'atto_indent', 'version', '2023100900'),
(941, 'atto_italic', 'version', '2023100900'),
(942, 'atto_link', 'version', '2023100900'),
(943, 'atto_managefiles', 'version', '2023100900'),
(944, 'atto_media', 'version', '2023100900'),
(945, 'atto_noautolink', 'version', '2023100900'),
(946, 'atto_orderedlist', 'version', '2023100900'),
(947, 'atto_recordrtc', 'version', '2023100900'),
(948, 'atto_rtl', 'version', '2023100900'),
(949, 'atto_strike', 'version', '2023100900'),
(950, 'atto_subscript', 'version', '2023100900'),
(951, 'atto_superscript', 'version', '2023100900'),
(952, 'atto_table', 'version', '2023100900'),
(953, 'atto_title', 'version', '2023100900'),
(954, 'atto_underline', 'version', '2023100900'),
(955, 'atto_undo', 'version', '2023100900'),
(956, 'atto_unorderedlist', 'version', '2023100900'),
(957, 'tiny_accessibilitychecker', 'version', '2023100900'),
(958, 'tiny_autosave', 'version', '2023100900'),
(959, 'tiny_equation', 'version', '2023100900'),
(960, 'tiny_h5p', 'version', '2023100900'),
(961, 'tiny_html', 'version', '2023100900'),
(962, 'tiny_link', 'version', '2023100900'),
(963, 'tiny_media', 'version', '2023100900'),
(964, 'tiny_noautolink', 'version', '2023100900'),
(966, 'tiny_noautolink', 'disabled', '1'),
(967, 'tiny_premium', 'version', '2023100900'),
(968, 'tiny_recordrtc', 'version', '2023100900'),
(969, 'logstore_database', 'version', '2023100900'),
(970, 'logstore_standard', 'version', '2023100900'),
(971, 'factor_admin', 'version', '2023100900'),
(972, 'factor_auth', 'version', '2023100900'),
(973, 'factor_capability', 'version', '2023100900'),
(974, 'factor_cohort', 'version', '2023100900'),
(975, 'factor_email', 'version', '2023100900'),
(976, 'factor_grace', 'version', '2023100900'),
(977, 'factor_iprange', 'version', '2023100900'),
(978, 'factor_nosetup', 'version', '2023100900'),
(979, 'factor_role', 'version', '2023100900'),
(980, 'factor_token', 'version', '2023100900'),
(981, 'factor_totp', 'version', '2023100900'),
(982, 'factor_webauthn', 'version', '2023100900'),
(983, 'tool_moodlenet', 'enablemoodlenet', '1'),
(984, 'tool_dataprivacy', 'contactdataprotectionofficer', '0'),
(985, 'tool_dataprivacy', 'automaticdataexportapproval', '0'),
(986, 'tool_dataprivacy', 'automaticdatadeletionapproval', '0'),
(987, 'tool_dataprivacy', 'automaticdeletionrequests', '1'),
(988, 'tool_dataprivacy', 'privacyrequestexpiry', '604800'),
(989, 'tool_dataprivacy', 'requireallenddatesforuserdeletion', '1'),
(990, 'tool_dataprivacy', 'showdataretentionsummary', '1'),
(991, 'tool_dataprivacy', 'allowfiltering', '0'),
(992, 'tool_log', 'exportlog', '1'),
(993, 'analytics', 'logstore', 'logstore_standard'),
(994, 'message_airnotifier', 'encryptnotifications', '0'),
(995, 'message_airnotifier', 'encryptprocessing', '0'),
(996, 'assign', 'feedback_plugin_for_gradebook', 'assignfeedback_comments'),
(997, 'assign', 'showrecentsubmissions', '0'),
(998, 'assign', 'submissionreceipts', '1'),
(999, 'assign', 'submissionstatement', 'This submission is my own work, except where I have acknowledged the use of the works of other people.'),
(1000, 'assign', 'submissionstatementteamsubmission', 'This submission is the work of my group, except where we have acknowledged the use of the works of other people.'),
(1001, 'assign', 'submissionstatementteamsubmissionallsubmit', 'This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.'),
(1002, 'assign', 'maxperpage', '-1'),
(1003, 'assign', 'alwaysshowdescription', '1'),
(1004, 'assign', 'alwaysshowdescription_adv', ''),
(1005, 'assign', 'alwaysshowdescription_locked', ''),
(1006, 'assign', 'allowsubmissionsfromdate', '0'),
(1007, 'assign', 'allowsubmissionsfromdate_enabled', '1'),
(1008, 'assign', 'allowsubmissionsfromdate_adv', ''),
(1009, 'assign', 'duedate', '604800'),
(1010, 'assign', 'duedate_enabled', '1'),
(1011, 'assign', 'duedate_adv', ''),
(1012, 'assign', 'cutoffdate', '1209600'),
(1013, 'assign', 'cutoffdate_enabled', ''),
(1014, 'assign', 'cutoffdate_adv', ''),
(1015, 'assign', 'enabletimelimit', '0'),
(1016, 'assign', 'gradingduedate', '1209600'),
(1017, 'assign', 'gradingduedate_enabled', '1'),
(1018, 'assign', 'gradingduedate_adv', ''),
(1019, 'assign', 'submissiondrafts', '0'),
(1020, 'assign', 'submissiondrafts_adv', ''),
(1021, 'assign', 'submissiondrafts_locked', ''),
(1022, 'assign', 'requiresubmissionstatement', '0'),
(1023, 'assign', 'requiresubmissionstatement_adv', ''),
(1024, 'assign', 'requiresubmissionstatement_locked', ''),
(1025, 'assign', 'attemptreopenmethod', 'none'),
(1026, 'assign', 'attemptreopenmethod_adv', ''),
(1027, 'assign', 'attemptreopenmethod_locked', ''),
(1028, 'assign', 'maxattempts', '-1'),
(1029, 'assign', 'maxattempts_adv', ''),
(1030, 'assign', 'maxattempts_locked', ''),
(1031, 'assign', 'teamsubmission', '0'),
(1032, 'assign', 'teamsubmission_adv', ''),
(1033, 'assign', 'teamsubmission_locked', ''),
(1034, 'assign', 'preventsubmissionnotingroup', '0'),
(1035, 'assign', 'preventsubmissionnotingroup_adv', ''),
(1036, 'assign', 'preventsubmissionnotingroup_locked', ''),
(1037, 'assign', 'requireallteammemberssubmit', '0'),
(1038, 'assign', 'requireallteammemberssubmit_adv', ''),
(1039, 'assign', 'requireallteammemberssubmit_locked', ''),
(1040, 'assign', 'teamsubmissiongroupingid', ''),
(1041, 'assign', 'teamsubmissiongroupingid_adv', ''),
(1042, 'assign', 'sendnotifications', '0'),
(1043, 'assign', 'sendnotifications_adv', ''),
(1044, 'assign', 'sendnotifications_locked', ''),
(1045, 'assign', 'sendlatenotifications', '0'),
(1046, 'assign', 'sendlatenotifications_adv', ''),
(1047, 'assign', 'sendlatenotifications_locked', ''),
(1048, 'assign', 'sendstudentnotifications', '1'),
(1049, 'assign', 'sendstudentnotifications_adv', ''),
(1050, 'assign', 'sendstudentnotifications_locked', ''),
(1051, 'assign', 'blindmarking', '0'),
(1052, 'assign', 'blindmarking_adv', ''),
(1053, 'assign', 'blindmarking_locked', ''),
(1054, 'assign', 'hidegrader', '0'),
(1055, 'assign', 'hidegrader_adv', ''),
(1056, 'assign', 'hidegrader_locked', ''),
(1057, 'assign', 'markingworkflow', '0'),
(1058, 'assign', 'markingworkflow_adv', ''),
(1059, 'assign', 'markingworkflow_locked', ''),
(1060, 'assign', 'markingallocation', '0'),
(1061, 'assign', 'markingallocation_adv', ''),
(1062, 'assign', 'markingallocation_locked', ''),
(1063, 'assignsubmission_file', 'default', '1'),
(1064, 'assignsubmission_file', 'maxfiles', '20'),
(1065, 'assignsubmission_file', 'filetypes', ''),
(1066, 'assignsubmission_file', 'maxbytes', '0'),
(1067, 'assignsubmission_onlinetext', 'default', '0'),
(1068, 'assignfeedback_comments', 'default', '1'),
(1069, 'assignfeedback_comments', 'inline', '0'),
(1070, 'assignfeedback_comments', 'inline_adv', ''),
(1071, 'assignfeedback_comments', 'inline_locked', ''),
(1072, 'assignfeedback_editpdf', 'default', '1'),
(1073, 'assignfeedback_editpdf', 'stamps', ''),
(1074, 'assignfeedback_file', 'default', '0'),
(1075, 'assignfeedback_offline', 'default', '0'),
(1076, 'mod_bigbluebuttonbn', 'presentationdefault', ''),
(1077, 'book', 'numberingoptions', '0,1,2,3'),
(1078, 'book', 'numbering', '1'),
(1079, 'resource', 'framesize', '130'),
(1080, 'resource', 'displayoptions', '0,1,4,5,6'),
(1081, 'resource', 'printintro', '1'),
(1082, 'resource', 'display', '0'),
(1083, 'resource', 'showsize', '0'),
(1084, 'resource', 'showtype', '1'),
(1085, 'resource', 'showdate', '0'),
(1086, 'resource', 'popupwidth', '620'),
(1087, 'resource', 'popupheight', '450'),
(1088, 'resource', 'filterfiles', '0'),
(1089, 'folder', 'showexpanded', '1'),
(1090, 'folder', 'maxsizetodownload', '0'),
(1091, 'mod_h5pactivity', 'enablesavestate', '1'),
(1092, 'mod_h5pactivity', 'savestatefreq', '60'),
(1093, 'imscp', 'keepold', '1'),
(1094, 'imscp', 'keepold_adv', ''),
(1095, 'mod_lesson', 'mediafile', ''),
(1096, 'mod_lesson', 'mediafile_adv', '1'),
(1097, 'mod_lesson', 'mediawidth', '640'),
(1098, 'mod_lesson', 'mediaheight', '480'),
(1099, 'mod_lesson', 'mediaclose', '0'),
(1100, 'mod_lesson', 'progressbar', '0'),
(1101, 'mod_lesson', 'progressbar_adv', ''),
(1102, 'mod_lesson', 'ongoing', '0'),
(1103, 'mod_lesson', 'ongoing_adv', '1'),
(1104, 'mod_lesson', 'displayleftmenu', '0'),
(1105, 'mod_lesson', 'displayleftmenu_adv', ''),
(1106, 'mod_lesson', 'displayleftif', '0'),
(1107, 'mod_lesson', 'displayleftif_adv', '1'),
(1108, 'mod_lesson', 'slideshow', '0'),
(1109, 'mod_lesson', 'slideshow_adv', '1'),
(1110, 'mod_lesson', 'slideshowwidth', '640'),
(1111, 'mod_lesson', 'slideshowheight', '480'),
(1112, 'mod_lesson', 'slideshowbgcolor', '#FFFFFF'),
(1113, 'mod_lesson', 'maxanswers', '5'),
(1114, 'mod_lesson', 'maxanswers_adv', '1'),
(1115, 'mod_lesson', 'defaultfeedback', '0'),
(1116, 'mod_lesson', 'defaultfeedback_adv', '1'),
(1117, 'mod_lesson', 'activitylink', ''),
(1118, 'mod_lesson', 'activitylink_adv', '1'),
(1119, 'mod_lesson', 'timelimit', '0'),
(1120, 'mod_lesson', 'timelimit_adv', ''),
(1121, 'mod_lesson', 'password', '0'),
(1122, 'mod_lesson', 'password_adv', '1'),
(1123, 'mod_lesson', 'modattempts', '0'),
(1124, 'mod_lesson', 'modattempts_adv', ''),
(1125, 'mod_lesson', 'displayreview', '0'),
(1126, 'mod_lesson', 'displayreview_adv', ''),
(1127, 'mod_lesson', 'maximumnumberofattempts', '1'),
(1128, 'mod_lesson', 'maximumnumberofattempts_adv', ''),
(1129, 'mod_lesson', 'defaultnextpage', '0'),
(1130, 'mod_lesson', 'defaultnextpage_adv', '1'),
(1131, 'mod_lesson', 'numberofpagestoshow', '1'),
(1132, 'mod_lesson', 'numberofpagestoshow_adv', '1'),
(1133, 'mod_lesson', 'practice', '0'),
(1134, 'mod_lesson', 'practice_adv', ''),
(1135, 'mod_lesson', 'customscoring', '1'),
(1136, 'mod_lesson', 'customscoring_adv', '1'),
(1137, 'mod_lesson', 'retakesallowed', '0'),
(1138, 'mod_lesson', 'retakesallowed_adv', ''),
(1139, 'mod_lesson', 'handlingofretakes', '0'),
(1140, 'mod_lesson', 'handlingofretakes_adv', '1'),
(1141, 'mod_lesson', 'minimumnumberofquestions', '0'),
(1142, 'mod_lesson', 'minimumnumberofquestions_adv', '1'),
(1143, 'page', 'displayoptions', '5'),
(1144, 'page', 'printintro', '0'),
(1145, 'page', 'printlastmodified', '1'),
(1146, 'page', 'display', '5'),
(1147, 'page', 'popupwidth', '620'),
(1148, 'page', 'popupheight', '450'),
(1149, 'quiz', 'timelimit', '0'),
(1150, 'quiz', 'timelimit_adv', ''),
(1151, 'quiz', 'timelimit_locked', ''),
(1152, 'quiz', 'notifyattemptgradeddelay', '18000'),
(1153, 'quiz', 'overduehandling', 'autosubmit'),
(1154, 'quiz', 'overduehandling_adv', ''),
(1155, 'quiz', 'overduehandling_locked', ''),
(1156, 'quiz', 'graceperiod', '86400'),
(1157, 'quiz', 'graceperiod_adv', ''),
(1158, 'quiz', 'graceperiod_locked', ''),
(1159, 'quiz', 'graceperiodmin', '60'),
(1160, 'quiz', 'attempts', '0'),
(1161, 'quiz', 'attempts_adv', ''),
(1162, 'quiz', 'attempts_locked', ''),
(1163, 'quiz', 'grademethod', '1'),
(1164, 'quiz', 'grademethod_adv', ''),
(1165, 'quiz', 'grademethod_locked', ''),
(1166, 'quiz', 'maximumgrade', '10'),
(1167, 'quiz', 'maximumgrade_locked', ''),
(1168, 'quiz', 'questionsperpage', '1'),
(1169, 'quiz', 'questionsperpage_adv', ''),
(1170, 'quiz', 'questionsperpage_locked', ''),
(1171, 'quiz', 'navmethod', 'free'),
(1172, 'quiz', 'navmethod_adv', '1'),
(1173, 'quiz', 'navmethod_locked', ''),
(1174, 'quiz', 'shuffleanswers', '1'),
(1175, 'quiz', 'shuffleanswers_adv', ''),
(1176, 'quiz', 'shuffleanswers_locked', ''),
(1177, 'quiz', 'preferredbehaviour', 'deferredfeedback'),
(1178, 'quiz', 'preferredbehaviour_locked', ''),
(1179, 'quiz', 'canredoquestions', '0'),
(1180, 'quiz', 'canredoquestions_adv', '1'),
(1181, 'quiz', 'canredoquestions_locked', ''),
(1182, 'quiz', 'attemptonlast', '0'),
(1183, 'quiz', 'attemptonlast_adv', '1'),
(1184, 'quiz', 'attemptonlast_locked', ''),
(1185, 'quiz', 'reviewattempt', '69904'),
(1186, 'quiz', 'reviewcorrectness', '69904'),
(1187, 'quiz', 'reviewmaxmarks', '69904'),
(1188, 'quiz', 'reviewmarks', '69904'),
(1189, 'quiz', 'reviewspecificfeedback', '69904'),
(1190, 'quiz', 'reviewgeneralfeedback', '69904'),
(1191, 'quiz', 'reviewrightanswer', '69904'),
(1192, 'quiz', 'reviewoverallfeedback', '4368'),
(1193, 'quiz', 'showuserpicture', '0'),
(1194, 'quiz', 'showuserpicture_adv', ''),
(1195, 'quiz', 'showuserpicture_locked', ''),
(1196, 'quiz', 'decimalpoints', '2'),
(1197, 'quiz', 'decimalpoints_adv', ''),
(1198, 'quiz', 'decimalpoints_locked', ''),
(1199, 'quiz', 'questiondecimalpoints', '-1'),
(1200, 'quiz', 'questiondecimalpoints_adv', ''),
(1201, 'quiz', 'questiondecimalpoints_locked', ''),
(1202, 'quiz', 'showblocks', '0'),
(1203, 'quiz', 'showblocks_adv', '1'),
(1204, 'quiz', 'showblocks_locked', ''),
(1205, 'quiz', 'quizpassword', ''),
(1206, 'quiz', 'quizpassword_adv', ''),
(1207, 'quiz', 'quizpassword_required', ''),
(1208, 'quiz', 'quizpassword_locked', ''),
(1209, 'quiz', 'subnet', ''),
(1210, 'quiz', 'subnet_adv', '1'),
(1211, 'quiz', 'subnet_locked', ''),
(1212, 'quiz', 'delay1', '0'),
(1213, 'quiz', 'delay1_adv', '1'),
(1214, 'quiz', 'delay1_locked', ''),
(1215, 'quiz', 'delay2', '0'),
(1216, 'quiz', 'delay2_adv', '1'),
(1217, 'quiz', 'delay2_locked', ''),
(1218, 'quiz', 'browsersecurity', '-'),
(1219, 'quiz', 'browsersecurity_adv', '1'),
(1220, 'quiz', 'browsersecurity_locked', ''),
(1221, 'quiz', 'initialnumfeedbacks', '2'),
(1222, 'quiz', 'autosaveperiod', '60'),
(1223, 'quiz_statistics', 'getstatslocktimeout', '900'),
(1224, 'quizaccess_seb', 'autoreconfigureseb', '1'),
(1225, 'quizaccess_seb', 'showseblinks', 'seb,http'),
(1226, 'quizaccess_seb', 'downloadlink', 'https://safeexambrowser.org/download_en.html'),
(1227, 'quizaccess_seb', 'quizpasswordrequired', '0'),
(1228, 'quizaccess_seb', 'displayblocksbeforestart', '0'),
(1229, 'quizaccess_seb', 'displayblockswhenfinished', '1'),
(1230, 'scorm', 'displaycoursestructure', '0'),
(1231, 'scorm', 'displaycoursestructure_adv', ''),
(1232, 'scorm', 'popup', '0'),
(1233, 'scorm', 'popup_adv', ''),
(1234, 'scorm', 'framewidth', '100'),
(1235, 'scorm', 'framewidth_adv', '1'),
(1236, 'scorm', 'frameheight', '500'),
(1237, 'scorm', 'frameheight_adv', '1'),
(1238, 'scorm', 'winoptgrp_adv', '1'),
(1239, 'scorm', 'scrollbars', '0'),
(1240, 'scorm', 'directories', '0'),
(1241, 'scorm', 'location', '0'),
(1242, 'scorm', 'menubar', '0'),
(1243, 'scorm', 'toolbar', '0'),
(1244, 'scorm', 'status', '0'),
(1245, 'scorm', 'skipview', '0'),
(1246, 'scorm', 'skipview_adv', '1'),
(1247, 'scorm', 'hidebrowse', '0'),
(1248, 'scorm', 'hidebrowse_adv', '1'),
(1249, 'scorm', 'hidetoc', '0'),
(1250, 'scorm', 'hidetoc_adv', '1'),
(1251, 'scorm', 'nav', '1'),
(1252, 'scorm', 'nav_adv', '1'),
(1253, 'scorm', 'navpositionleft', '-100'),
(1254, 'scorm', 'navpositionleft_adv', '1'),
(1255, 'scorm', 'navpositiontop', '-100'),
(1256, 'scorm', 'navpositiontop_adv', '1'),
(1257, 'scorm', 'collapsetocwinsize', '767'),
(1258, 'scorm', 'collapsetocwinsize_adv', '1'),
(1259, 'scorm', 'displayattemptstatus', '1'),
(1260, 'scorm', 'displayattemptstatus_adv', ''),
(1261, 'scorm', 'grademethod', '1'),
(1262, 'scorm', 'maxgrade', '100'),
(1263, 'scorm', 'maxattempt', '0'),
(1264, 'scorm', 'whatgrade', '0'),
(1265, 'scorm', 'forcecompleted', '0'),
(1266, 'scorm', 'forcenewattempt', '0'),
(1267, 'scorm', 'autocommit', '0');
INSERT INTO `mdlxd_config_plugins` VALUES
(1268, 'scorm', 'masteryoverride', '1'),
(1269, 'scorm', 'lastattemptlock', '0'),
(1270, 'scorm', 'auto', '0'),
(1271, 'scorm', 'updatefreq', '0'),
(1272, 'scorm', 'scormstandard', '0'),
(1273, 'scorm', 'allowtypeexternal', '0'),
(1274, 'scorm', 'allowtypelocalsync', '0'),
(1275, 'scorm', 'allowtypeexternalaicc', '0'),
(1276, 'scorm', 'allowaicchacp', '0'),
(1277, 'scorm', 'aicchacptimeout', '30'),
(1278, 'scorm', 'aicchacpkeepsessiondata', '1'),
(1279, 'scorm', 'aiccuserid', '1'),
(1280, 'scorm', 'forcejavascript', '1'),
(1281, 'scorm', 'allowapidebug', '0'),
(1282, 'scorm', 'apidebugmask', '.*'),
(1283, 'scorm', 'protectpackagedownloads', '0'),
(1284, 'label', 'dndmedia', '1'),
(1285, 'label', 'dndresizewidth', '400'),
(1286, 'label', 'dndresizeheight', '400'),
(1287, 'url', 'framesize', '130'),
(1288, 'url', 'secretphrase', ''),
(1289, 'url', 'rolesinparams', '0'),
(1290, 'url', 'displayoptions', '0,1,5,6'),
(1291, 'url', 'printintro', '1'),
(1292, 'url', 'display', '0'),
(1293, 'url', 'popupwidth', '620'),
(1294, 'url', 'popupheight', '450'),
(1295, 'workshop', 'grade', '80'),
(1296, 'workshop', 'gradinggrade', '20'),
(1297, 'workshop', 'gradedecimals', '0'),
(1298, 'workshop', 'maxbytes', '0'),
(1299, 'workshop', 'strategy', 'accumulative'),
(1300, 'workshop', 'examplesmode', '0'),
(1301, 'workshopallocation_random', 'numofreviews', '5'),
(1302, 'workshopform_numerrors', 'grade0', 'No'),
(1303, 'workshopform_numerrors', 'grade1', 'Yes'),
(1304, 'workshopeval_best', 'comparison', '5'),
(1305, 'tool_brickfield', 'analysistype', '0'),
(1306, 'tool_brickfield', 'deletehistoricaldata', '1'),
(1307, 'tool_brickfield', 'batch', '1000'),
(1308, 'tool_brickfield', 'perpage', '50'),
(1309, 'tool_mfa', 'enabled', '0'),
(1310, 'tool_mfa', 'lockout', '10'),
(1311, 'tool_mfa', 'debugmode', '0'),
(1312, 'tool_mfa', 'redir_exclusions', ''),
(1313, 'tool_mfa', 'guidance', '0'),
(1314, 'tool_mfa', 'guidancecontent', ''),
(1315, 'tool_mfa', 'guidancefiles', ''),
(1316, 'factor_admin', 'enabled', '0'),
(1317, 'factor_admin', 'weight', '100'),
(1318, 'factor_auth', 'enabled', '0'),
(1319, 'factor_auth', 'weight', '100'),
(1320, 'factor_auth', 'goodauth', ''),
(1321, 'factor_capability', 'enabled', '0'),
(1322, 'factor_capability', 'weight', '100'),
(1323, 'factor_capability', 'adminpasses', '1'),
(1324, 'factor_cohort', 'enabled', '0'),
(1325, 'factor_cohort', 'weight', '100'),
(1326, 'factor_email', 'enabled', '0'),
(1327, 'factor_email', 'weight', '100'),
(1328, 'factor_email', 'duration', '1800'),
(1329, 'factor_email', 'suspend', '0'),
(1330, 'factor_grace', 'enabled', '0'),
(1331, 'factor_grace', 'weight', '100'),
(1332, 'factor_grace', 'forcesetup', '0'),
(1333, 'factor_grace', 'graceperiod', '604800'),
(1334, 'factor_grace', 'ignorelist', ''),
(1335, 'factor_grace', 'customwarning', ''),
(1336, 'factor_iprange', 'enabled', '0'),
(1337, 'factor_iprange', 'weight', '100'),
(1338, 'factor_iprange', 'safeips', ''),
(1339, 'factor_nosetup', 'enabled', '0'),
(1340, 'factor_nosetup', 'weight', '100'),
(1341, 'factor_role', 'enabled', '0'),
(1342, 'factor_role', 'weight', '100'),
(1343, 'factor_role', 'roles', 'admin'),
(1344, 'factor_token', 'enabled', '0'),
(1345, 'factor_token', 'weight', '100'),
(1346, 'factor_token', 'expiry', '86400'),
(1347, 'factor_token', 'expireovernight', '1'),
(1348, 'factor_totp', 'enabled', '0'),
(1349, 'factor_totp', 'weight', '100'),
(1350, 'factor_totp', 'window', '30'),
(1351, 'factor_totp', 'totplink', '1'),
(1352, 'factor_webauthn', 'enabled', '0'),
(1353, 'factor_webauthn', 'weight', '100'),
(1354, 'factor_webauthn', 'authenticatortypes', 'usb,nfc,ble,hybrid,internal'),
(1355, 'factor_webauthn', 'userverification', 'preferred'),
(1356, 'tool_recyclebin', 'coursebinenable', '1'),
(1357, 'tool_recyclebin', 'coursebinexpiry', '604800'),
(1358, 'tool_recyclebin', 'categorybinenable', '1'),
(1359, 'tool_recyclebin', 'categorybinexpiry', '604800'),
(1360, 'tool_recyclebin', 'autohide', '1'),
(1361, 'antivirus_clamav', 'runningmethod', 'commandline'),
(1362, 'antivirus_clamav', 'pathtoclam', ''),
(1363, 'antivirus_clamav', 'pathtounixsocket', ''),
(1364, 'antivirus_clamav', 'tcpsockethost', ''),
(1365, 'antivirus_clamav', 'tcpsocketport', '3310'),
(1366, 'antivirus_clamav', 'clamfailureonupload', 'tryagain'),
(1367, 'antivirus_clamav', 'tries', '1'),
(1368, 'auth_cas', 'auth_name', 'CAS'),
(1369, 'auth_cas', 'auth_logo', ''),
(1370, 'auth_cas', 'hostname', ''),
(1371, 'auth_cas', 'baseuri', ''),
(1372, 'auth_cas', 'port', '0'),
(1373, 'auth_cas', 'casversion', '2.0'),
(1374, 'auth_cas', 'language', 'CAS_Languages_English'),
(1375, 'auth_cas', 'proxycas', '0'),
(1376, 'auth_cas', 'logoutcas', '0'),
(1377, 'auth_cas', 'multiauth', '0'),
(1378, 'auth_cas', 'certificate_check', '0'),
(1379, 'auth_cas', 'certificate_path', ''),
(1380, 'auth_cas', 'curl_ssl_version', ''),
(1381, 'auth_cas', 'logout_return_url', ''),
(1382, 'auth_cas', 'host_url', ''),
(1383, 'auth_cas', 'ldap_version', '3'),
(1384, 'auth_cas', 'start_tls', '0'),
(1385, 'auth_cas', 'ldapencoding', 'utf-8'),
(1386, 'auth_cas', 'pagesize', '250'),
(1387, 'auth_cas', 'bind_dn', ''),
(1388, 'auth_cas', 'bind_pw', ''),
(1389, 'auth_cas', 'user_type', 'default'),
(1390, 'auth_cas', 'contexts', ''),
(1391, 'auth_cas', 'search_sub', '0'),
(1392, 'auth_cas', 'opt_deref', '0'),
(1393, 'auth_cas', 'user_attribute', ''),
(1394, 'auth_cas', 'memberattribute', ''),
(1395, 'auth_cas', 'memberattribute_isdn', '0'),
(1396, 'auth_cas', 'objectclass', ''),
(1397, 'auth_cas', 'attrcreators', ''),
(1398, 'auth_cas', 'groupecreators', ''),
(1399, 'auth_cas', 'removeuser', '0'),
(1400, 'auth_cas', 'field_map_firstname', ''),
(1401, 'auth_cas', 'field_updatelocal_firstname', 'oncreate'),
(1402, 'auth_cas', 'field_updateremote_firstname', '0'),
(1403, 'auth_cas', 'field_lock_firstname', 'unlocked'),
(1404, 'auth_cas', 'field_map_lastname', ''),
(1405, 'auth_cas', 'field_updatelocal_lastname', 'oncreate'),
(1406, 'auth_cas', 'field_updateremote_lastname', '0'),
(1407, 'auth_cas', 'field_lock_lastname', 'unlocked'),
(1408, 'auth_cas', 'field_map_email', ''),
(1409, 'auth_cas', 'field_updatelocal_email', 'oncreate'),
(1410, 'auth_cas', 'field_updateremote_email', '0'),
(1411, 'auth_cas', 'field_lock_email', 'unlocked'),
(1412, 'auth_cas', 'field_map_city', ''),
(1413, 'auth_cas', 'field_updatelocal_city', 'oncreate'),
(1414, 'auth_cas', 'field_updateremote_city', '0'),
(1415, 'auth_cas', 'field_lock_city', 'unlocked'),
(1416, 'auth_cas', 'field_map_country', ''),
(1417, 'auth_cas', 'field_updatelocal_country', 'oncreate'),
(1418, 'auth_cas', 'field_updateremote_country', '0'),
(1419, 'auth_cas', 'field_lock_country', 'unlocked'),
(1420, 'auth_cas', 'field_map_lang', ''),
(1421, 'auth_cas', 'field_updatelocal_lang', 'oncreate'),
(1422, 'auth_cas', 'field_updateremote_lang', '0'),
(1423, 'auth_cas', 'field_lock_lang', 'unlocked'),
(1424, 'auth_cas', 'field_map_description', ''),
(1425, 'auth_cas', 'field_updatelocal_description', 'oncreate'),
(1426, 'auth_cas', 'field_updateremote_description', '0'),
(1427, 'auth_cas', 'field_lock_description', 'unlocked'),
(1428, 'auth_cas', 'field_map_idnumber', ''),
(1429, 'auth_cas', 'field_updatelocal_idnumber', 'oncreate'),
(1430, 'auth_cas', 'field_updateremote_idnumber', '0'),
(1431, 'auth_cas', 'field_lock_idnumber', 'unlocked'),
(1432, 'auth_cas', 'field_map_institution', ''),
(1433, 'auth_cas', 'field_updatelocal_institution', 'oncreate'),
(1434, 'auth_cas', 'field_updateremote_institution', '0'),
(1435, 'auth_cas', 'field_lock_institution', 'unlocked'),
(1436, 'auth_cas', 'field_map_department', ''),
(1437, 'auth_cas', 'field_updatelocal_department', 'oncreate'),
(1438, 'auth_cas', 'field_updateremote_department', '0'),
(1439, 'auth_cas', 'field_lock_department', 'unlocked'),
(1440, 'auth_cas', 'field_map_phone1', ''),
(1441, 'auth_cas', 'field_updatelocal_phone1', 'oncreate'),
(1442, 'auth_cas', 'field_updateremote_phone1', '0'),
(1443, 'auth_cas', 'field_lock_phone1', 'unlocked'),
(1444, 'auth_cas', 'field_map_phone2', ''),
(1445, 'auth_cas', 'field_updatelocal_phone2', 'oncreate'),
(1446, 'auth_cas', 'field_updateremote_phone2', '0'),
(1447, 'auth_cas', 'field_lock_phone2', 'unlocked'),
(1448, 'auth_cas', 'field_map_address', ''),
(1449, 'auth_cas', 'field_updatelocal_address', 'oncreate'),
(1450, 'auth_cas', 'field_updateremote_address', '0'),
(1451, 'auth_cas', 'field_lock_address', 'unlocked'),
(1452, 'auth_cas', 'field_map_firstnamephonetic', ''),
(1453, 'auth_cas', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1454, 'auth_cas', 'field_updateremote_firstnamephonetic', '0'),
(1455, 'auth_cas', 'field_lock_firstnamephonetic', 'unlocked'),
(1456, 'auth_cas', 'field_map_lastnamephonetic', ''),
(1457, 'auth_cas', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1458, 'auth_cas', 'field_updateremote_lastnamephonetic', '0'),
(1459, 'auth_cas', 'field_lock_lastnamephonetic', 'unlocked'),
(1460, 'auth_cas', 'field_map_middlename', ''),
(1461, 'auth_cas', 'field_updatelocal_middlename', 'oncreate'),
(1462, 'auth_cas', 'field_updateremote_middlename', '0'),
(1463, 'auth_cas', 'field_lock_middlename', 'unlocked'),
(1464, 'auth_cas', 'field_map_alternatename', ''),
(1465, 'auth_cas', 'field_updatelocal_alternatename', 'oncreate'),
(1466, 'auth_cas', 'field_updateremote_alternatename', '0'),
(1467, 'auth_cas', 'field_lock_alternatename', 'unlocked'),
(1468, 'auth_email', 'recaptcha', '0'),
(1469, 'auth_email', 'field_lock_firstname', 'unlocked'),
(1470, 'auth_email', 'field_lock_lastname', 'unlocked'),
(1471, 'auth_email', 'field_lock_email', 'unlocked'),
(1472, 'auth_email', 'field_lock_city', 'unlocked'),
(1473, 'auth_email', 'field_lock_country', 'unlocked'),
(1474, 'auth_email', 'field_lock_lang', 'unlocked'),
(1475, 'auth_email', 'field_lock_description', 'unlocked'),
(1476, 'auth_email', 'field_lock_idnumber', 'unlocked'),
(1477, 'auth_email', 'field_lock_institution', 'unlocked'),
(1478, 'auth_email', 'field_lock_department', 'unlocked'),
(1479, 'auth_email', 'field_lock_phone1', 'unlocked'),
(1480, 'auth_email', 'field_lock_phone2', 'unlocked'),
(1481, 'auth_email', 'field_lock_address', 'unlocked'),
(1482, 'auth_email', 'field_lock_firstnamephonetic', 'unlocked'),
(1483, 'auth_email', 'field_lock_lastnamephonetic', 'unlocked'),
(1484, 'auth_email', 'field_lock_middlename', 'unlocked'),
(1485, 'auth_email', 'field_lock_alternatename', 'unlocked'),
(1486, 'auth_db', 'host', '127.0.0.1'),
(1487, 'auth_db', 'type', 'mysqli'),
(1488, 'auth_db', 'sybasequoting', '0'),
(1489, 'auth_db', 'name', ''),
(1490, 'auth_db', 'user', ''),
(1491, 'auth_db', 'pass', ''),
(1492, 'auth_db', 'table', ''),
(1493, 'auth_db', 'fielduser', ''),
(1494, 'auth_db', 'fieldpass', ''),
(1495, 'auth_db', 'passtype', 'plaintext'),
(1496, 'auth_db', 'extencoding', 'utf-8'),
(1497, 'auth_db', 'setupsql', ''),
(1498, 'auth_db', 'debugauthdb', '0'),
(1499, 'auth_db', 'changepasswordurl', ''),
(1500, 'auth_db', 'removeuser', '0'),
(1501, 'auth_db', 'updateusers', '0'),
(1502, 'auth_db', 'field_map_firstname', ''),
(1503, 'auth_db', 'field_updatelocal_firstname', 'oncreate'),
(1504, 'auth_db', 'field_updateremote_firstname', '0'),
(1505, 'auth_db', 'field_lock_firstname', 'unlocked'),
(1506, 'auth_db', 'field_map_lastname', ''),
(1507, 'auth_db', 'field_updatelocal_lastname', 'oncreate'),
(1508, 'auth_db', 'field_updateremote_lastname', '0'),
(1509, 'auth_db', 'field_lock_lastname', 'unlocked'),
(1510, 'auth_db', 'field_map_email', ''),
(1511, 'auth_db', 'field_updatelocal_email', 'oncreate'),
(1512, 'auth_db', 'field_updateremote_email', '0'),
(1513, 'auth_db', 'field_lock_email', 'unlocked'),
(1514, 'auth_db', 'field_map_city', ''),
(1515, 'auth_db', 'field_updatelocal_city', 'oncreate'),
(1516, 'auth_db', 'field_updateremote_city', '0'),
(1517, 'auth_db', 'field_lock_city', 'unlocked'),
(1518, 'auth_db', 'field_map_country', ''),
(1519, 'auth_db', 'field_updatelocal_country', 'oncreate'),
(1520, 'auth_db', 'field_updateremote_country', '0'),
(1521, 'auth_db', 'field_lock_country', 'unlocked'),
(1522, 'auth_db', 'field_map_lang', ''),
(1523, 'auth_db', 'field_updatelocal_lang', 'oncreate'),
(1524, 'auth_db', 'field_updateremote_lang', '0'),
(1525, 'auth_db', 'field_lock_lang', 'unlocked'),
(1526, 'auth_db', 'field_map_description', ''),
(1527, 'auth_db', 'field_updatelocal_description', 'oncreate'),
(1528, 'auth_db', 'field_updateremote_description', '0'),
(1529, 'auth_db', 'field_lock_description', 'unlocked'),
(1530, 'auth_db', 'field_map_idnumber', ''),
(1531, 'auth_db', 'field_updatelocal_idnumber', 'oncreate'),
(1532, 'auth_db', 'field_updateremote_idnumber', '0'),
(1533, 'auth_db', 'field_lock_idnumber', 'unlocked'),
(1534, 'auth_db', 'field_map_institution', ''),
(1535, 'auth_db', 'field_updatelocal_institution', 'oncreate'),
(1536, 'auth_db', 'field_updateremote_institution', '0'),
(1537, 'auth_db', 'field_lock_institution', 'unlocked'),
(1538, 'auth_db', 'field_map_department', ''),
(1539, 'auth_db', 'field_updatelocal_department', 'oncreate'),
(1540, 'auth_db', 'field_updateremote_department', '0'),
(1541, 'auth_db', 'field_lock_department', 'unlocked'),
(1542, 'auth_db', 'field_map_phone1', ''),
(1543, 'auth_db', 'field_updatelocal_phone1', 'oncreate'),
(1544, 'auth_db', 'field_updateremote_phone1', '0'),
(1545, 'auth_db', 'field_lock_phone1', 'unlocked'),
(1546, 'auth_db', 'field_map_phone2', ''),
(1547, 'auth_db', 'field_updatelocal_phone2', 'oncreate'),
(1548, 'auth_db', 'field_updateremote_phone2', '0'),
(1549, 'auth_db', 'field_lock_phone2', 'unlocked'),
(1550, 'auth_db', 'field_map_address', ''),
(1551, 'auth_db', 'field_updatelocal_address', 'oncreate'),
(1552, 'auth_db', 'field_updateremote_address', '0'),
(1553, 'auth_db', 'field_lock_address', 'unlocked'),
(1554, 'auth_db', 'field_map_firstnamephonetic', ''),
(1555, 'auth_db', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1556, 'auth_db', 'field_updateremote_firstnamephonetic', '0'),
(1557, 'auth_db', 'field_lock_firstnamephonetic', 'unlocked'),
(1558, 'auth_db', 'field_map_lastnamephonetic', ''),
(1559, 'auth_db', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1560, 'auth_db', 'field_updateremote_lastnamephonetic', '0'),
(1561, 'auth_db', 'field_lock_lastnamephonetic', 'unlocked'),
(1562, 'auth_db', 'field_map_middlename', ''),
(1563, 'auth_db', 'field_updatelocal_middlename', 'oncreate'),
(1564, 'auth_db', 'field_updateremote_middlename', '0'),
(1565, 'auth_db', 'field_lock_middlename', 'unlocked'),
(1566, 'auth_db', 'field_map_alternatename', ''),
(1567, 'auth_db', 'field_updatelocal_alternatename', 'oncreate'),
(1568, 'auth_db', 'field_updateremote_alternatename', '0'),
(1569, 'auth_db', 'field_lock_alternatename', 'unlocked'),
(1570, 'auth_ldap', 'host_url', ''),
(1571, 'auth_ldap', 'ldap_version', '3'),
(1572, 'auth_ldap', 'start_tls', '0'),
(1573, 'auth_ldap', 'ldapencoding', 'utf-8'),
(1574, 'auth_ldap', 'pagesize', '250'),
(1575, 'auth_ldap', 'preventpassindb', '0'),
(1576, 'auth_ldap', 'bind_dn', ''),
(1577, 'auth_ldap', 'bind_pw', ''),
(1578, 'auth_ldap', 'user_type', 'default'),
(1579, 'auth_ldap', 'contexts', ''),
(1580, 'auth_ldap', 'search_sub', '0'),
(1581, 'auth_ldap', 'opt_deref', '0'),
(1582, 'auth_ldap', 'user_attribute', ''),
(1583, 'auth_ldap', 'suspended_attribute', ''),
(1584, 'auth_ldap', 'memberattribute', ''),
(1585, 'auth_ldap', 'memberattribute_isdn', '0'),
(1586, 'auth_ldap', 'objectclass', ''),
(1587, 'auth_ldap', 'forcechangepassword', '0'),
(1588, 'auth_ldap', 'stdchangepassword', '0'),
(1589, 'auth_ldap', 'passtype', 'plaintext'),
(1590, 'auth_ldap', 'changepasswordurl', ''),
(1591, 'auth_ldap', 'expiration', '0'),
(1592, 'auth_ldap', 'expiration_warning', ''),
(1593, 'auth_ldap', 'expireattr', ''),
(1594, 'auth_ldap', 'gracelogins', '0'),
(1595, 'auth_ldap', 'graceattr', ''),
(1596, 'auth_ldap', 'auth_user_create', '0'),
(1597, 'auth_ldap', 'create_context', ''),
(1598, 'auth_ldap', 'managercontext', ''),
(1599, 'auth_ldap', 'coursecreatorcontext', ''),
(1600, 'auth_ldap', 'removeuser', '0'),
(1601, 'auth_ldap', 'sync_suspended', '0'),
(1602, 'auth_ldap', 'ntlmsso_enabled', '0'),
(1603, 'auth_ldap', 'ntlmsso_subnet', ''),
(1604, 'auth_ldap', 'ntlmsso_ie_fastpath', '0'),
(1605, 'auth_ldap', 'ntlmsso_type', 'ntlm'),
(1606, 'auth_ldap', 'ntlmsso_remoteuserformat', ''),
(1607, 'auth_ldap', 'field_map_firstname', ''),
(1608, 'auth_ldap', 'field_updatelocal_firstname', 'oncreate'),
(1609, 'auth_ldap', 'field_updateremote_firstname', '0'),
(1610, 'auth_ldap', 'field_lock_firstname', 'unlocked'),
(1611, 'auth_ldap', 'field_map_lastname', ''),
(1612, 'auth_ldap', 'field_updatelocal_lastname', 'oncreate'),
(1613, 'auth_ldap', 'field_updateremote_lastname', '0'),
(1614, 'auth_ldap', 'field_lock_lastname', 'unlocked'),
(1615, 'auth_ldap', 'field_map_email', ''),
(1616, 'auth_ldap', 'field_updatelocal_email', 'oncreate'),
(1617, 'auth_ldap', 'field_updateremote_email', '0'),
(1618, 'auth_ldap', 'field_lock_email', 'unlocked'),
(1619, 'auth_ldap', 'field_map_city', ''),
(1620, 'auth_ldap', 'field_updatelocal_city', 'oncreate'),
(1621, 'auth_ldap', 'field_updateremote_city', '0'),
(1622, 'auth_ldap', 'field_lock_city', 'unlocked'),
(1623, 'auth_ldap', 'field_map_country', ''),
(1624, 'auth_ldap', 'field_updatelocal_country', 'oncreate'),
(1625, 'auth_ldap', 'field_updateremote_country', '0'),
(1626, 'auth_ldap', 'field_lock_country', 'unlocked'),
(1627, 'auth_ldap', 'field_map_lang', ''),
(1628, 'auth_ldap', 'field_updatelocal_lang', 'oncreate'),
(1629, 'auth_ldap', 'field_updateremote_lang', '0'),
(1630, 'auth_ldap', 'field_lock_lang', 'unlocked'),
(1631, 'auth_ldap', 'field_map_description', ''),
(1632, 'auth_ldap', 'field_updatelocal_description', 'oncreate'),
(1633, 'auth_ldap', 'field_updateremote_description', '0'),
(1634, 'auth_ldap', 'field_lock_description', 'unlocked'),
(1635, 'auth_ldap', 'field_map_idnumber', ''),
(1636, 'auth_ldap', 'field_updatelocal_idnumber', 'oncreate'),
(1637, 'auth_ldap', 'field_updateremote_idnumber', '0'),
(1638, 'auth_ldap', 'field_lock_idnumber', 'unlocked'),
(1639, 'auth_ldap', 'field_map_institution', ''),
(1640, 'auth_ldap', 'field_updatelocal_institution', 'oncreate'),
(1641, 'auth_ldap', 'field_updateremote_institution', '0'),
(1642, 'auth_ldap', 'field_lock_institution', 'unlocked'),
(1643, 'auth_ldap', 'field_map_department', ''),
(1644, 'auth_ldap', 'field_updatelocal_department', 'oncreate'),
(1645, 'auth_ldap', 'field_updateremote_department', '0'),
(1646, 'auth_ldap', 'field_lock_department', 'unlocked'),
(1647, 'auth_ldap', 'field_map_phone1', ''),
(1648, 'auth_ldap', 'field_updatelocal_phone1', 'oncreate'),
(1649, 'auth_ldap', 'field_updateremote_phone1', '0'),
(1650, 'auth_ldap', 'field_lock_phone1', 'unlocked'),
(1651, 'auth_ldap', 'field_map_phone2', ''),
(1652, 'auth_ldap', 'field_updatelocal_phone2', 'oncreate'),
(1653, 'auth_ldap', 'field_updateremote_phone2', '0'),
(1654, 'auth_ldap', 'field_lock_phone2', 'unlocked'),
(1655, 'auth_ldap', 'field_map_address', ''),
(1656, 'auth_ldap', 'field_updatelocal_address', 'oncreate'),
(1657, 'auth_ldap', 'field_updateremote_address', '0'),
(1658, 'auth_ldap', 'field_lock_address', 'unlocked'),
(1659, 'auth_ldap', 'field_map_firstnamephonetic', ''),
(1660, 'auth_ldap', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1661, 'auth_ldap', 'field_updateremote_firstnamephonetic', '0'),
(1662, 'auth_ldap', 'field_lock_firstnamephonetic', 'unlocked'),
(1663, 'auth_ldap', 'field_map_lastnamephonetic', ''),
(1664, 'auth_ldap', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1665, 'auth_ldap', 'field_updateremote_lastnamephonetic', '0'),
(1666, 'auth_ldap', 'field_lock_lastnamephonetic', 'unlocked'),
(1667, 'auth_ldap', 'field_map_middlename', ''),
(1668, 'auth_ldap', 'field_updatelocal_middlename', 'oncreate'),
(1669, 'auth_ldap', 'field_updateremote_middlename', '0'),
(1670, 'auth_ldap', 'field_lock_middlename', 'unlocked'),
(1671, 'auth_ldap', 'field_map_alternatename', ''),
(1672, 'auth_ldap', 'field_updatelocal_alternatename', 'oncreate'),
(1673, 'auth_ldap', 'field_updateremote_alternatename', '0'),
(1674, 'auth_ldap', 'field_lock_alternatename', 'unlocked'),
(1675, 'auth_manual', 'expiration', '0'),
(1676, 'auth_manual', 'expirationtime', '30'),
(1677, 'auth_manual', 'expiration_warning', '0'),
(1678, 'auth_manual', 'field_lock_firstname', 'unlocked'),
(1679, 'auth_manual', 'field_lock_lastname', 'unlocked'),
(1680, 'auth_manual', 'field_lock_email', 'unlocked'),
(1681, 'auth_manual', 'field_lock_city', 'unlocked'),
(1682, 'auth_manual', 'field_lock_country', 'unlocked'),
(1683, 'auth_manual', 'field_lock_lang', 'unlocked'),
(1684, 'auth_manual', 'field_lock_description', 'unlocked'),
(1685, 'auth_manual', 'field_lock_idnumber', 'unlocked'),
(1686, 'auth_manual', 'field_lock_institution', 'unlocked'),
(1687, 'auth_manual', 'field_lock_department', 'unlocked'),
(1688, 'auth_manual', 'field_lock_phone1', 'unlocked'),
(1689, 'auth_manual', 'field_lock_phone2', 'unlocked'),
(1690, 'auth_manual', 'field_lock_address', 'unlocked'),
(1691, 'auth_manual', 'field_lock_firstnamephonetic', 'unlocked'),
(1692, 'auth_manual', 'field_lock_lastnamephonetic', 'unlocked'),
(1693, 'auth_manual', 'field_lock_middlename', 'unlocked'),
(1694, 'auth_manual', 'field_lock_alternatename', 'unlocked'),
(1695, 'auth_mnet', 'rpc_negotiation_timeout', '30'),
(1696, 'auth_none', 'field_lock_firstname', 'unlocked'),
(1697, 'auth_none', 'field_lock_lastname', 'unlocked'),
(1698, 'auth_none', 'field_lock_email', 'unlocked'),
(1699, 'auth_none', 'field_lock_city', 'unlocked'),
(1700, 'auth_none', 'field_lock_country', 'unlocked'),
(1701, 'auth_none', 'field_lock_lang', 'unlocked'),
(1702, 'auth_none', 'field_lock_description', 'unlocked'),
(1703, 'auth_none', 'field_lock_idnumber', 'unlocked'),
(1704, 'auth_none', 'field_lock_institution', 'unlocked'),
(1705, 'auth_none', 'field_lock_department', 'unlocked'),
(1706, 'auth_none', 'field_lock_phone1', 'unlocked'),
(1707, 'auth_none', 'field_lock_phone2', 'unlocked'),
(1708, 'auth_none', 'field_lock_address', 'unlocked'),
(1709, 'auth_none', 'field_lock_firstnamephonetic', 'unlocked'),
(1710, 'auth_none', 'field_lock_lastnamephonetic', 'unlocked'),
(1711, 'auth_none', 'field_lock_middlename', 'unlocked'),
(1712, 'auth_none', 'field_lock_alternatename', 'unlocked'),
(1713, 'auth_oauth2', 'field_lock_firstname', 'unlocked'),
(1714, 'auth_oauth2', 'field_lock_lastname', 'unlocked'),
(1715, 'auth_oauth2', 'field_lock_email', 'unlocked'),
(1716, 'auth_oauth2', 'field_lock_city', 'unlocked'),
(1717, 'auth_oauth2', 'field_lock_country', 'unlocked'),
(1718, 'auth_oauth2', 'field_lock_lang', 'unlocked'),
(1719, 'auth_oauth2', 'field_lock_description', 'unlocked'),
(1720, 'auth_oauth2', 'field_lock_idnumber', 'unlocked'),
(1721, 'auth_oauth2', 'field_lock_institution', 'unlocked'),
(1722, 'auth_oauth2', 'field_lock_department', 'unlocked'),
(1723, 'auth_oauth2', 'field_lock_phone1', 'unlocked'),
(1724, 'auth_oauth2', 'field_lock_phone2', 'unlocked'),
(1725, 'auth_oauth2', 'field_lock_address', 'unlocked'),
(1726, 'auth_oauth2', 'field_lock_firstnamephonetic', 'unlocked'),
(1727, 'auth_oauth2', 'field_lock_lastnamephonetic', 'unlocked'),
(1728, 'auth_oauth2', 'field_lock_middlename', 'unlocked'),
(1729, 'auth_oauth2', 'field_lock_alternatename', 'unlocked'),
(1730, 'auth_shibboleth', 'user_attribute', ''),
(1731, 'auth_shibboleth', 'convert_data', ''),
(1732, 'auth_shibboleth', 'alt_login', 'off'),
(1733, 'auth_shibboleth', 'organization_selection', 'urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai'),
(1734, 'auth_shibboleth', 'logout_handler', ''),
(1735, 'auth_shibboleth', 'logout_return_url', ''),
(1736, 'auth_shibboleth', 'login_name', 'Shibboleth Login'),
(1737, 'auth_shibboleth', 'auth_logo', ''),
(1738, 'auth_shibboleth', 'auth_instructions', 'Use the <a href="https://astitt.tech/unilearn/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.'),
(1739, 'auth_shibboleth', 'changepasswordurl', ''),
(1740, 'auth_shibboleth', 'field_map_firstname', ''),
(1741, 'auth_shibboleth', 'field_updatelocal_firstname', 'oncreate'),
(1742, 'auth_shibboleth', 'field_lock_firstname', 'unlocked'),
(1743, 'auth_shibboleth', 'field_map_lastname', ''),
(1744, 'auth_shibboleth', 'field_updatelocal_lastname', 'oncreate'),
(1745, 'auth_shibboleth', 'field_lock_lastname', 'unlocked'),
(1746, 'auth_shibboleth', 'field_map_email', ''),
(1747, 'auth_shibboleth', 'field_updatelocal_email', 'oncreate'),
(1748, 'auth_shibboleth', 'field_lock_email', 'unlocked'),
(1749, 'auth_shibboleth', 'field_map_city', ''),
(1750, 'auth_shibboleth', 'field_updatelocal_city', 'oncreate'),
(1751, 'auth_shibboleth', 'field_lock_city', 'unlocked'),
(1752, 'auth_shibboleth', 'field_map_country', ''),
(1753, 'auth_shibboleth', 'field_updatelocal_country', 'oncreate'),
(1754, 'auth_shibboleth', 'field_lock_country', 'unlocked'),
(1755, 'auth_shibboleth', 'field_map_lang', ''),
(1756, 'auth_shibboleth', 'field_updatelocal_lang', 'oncreate'),
(1757, 'auth_shibboleth', 'field_lock_lang', 'unlocked'),
(1758, 'auth_shibboleth', 'field_map_description', ''),
(1759, 'auth_shibboleth', 'field_updatelocal_description', 'oncreate'),
(1760, 'auth_shibboleth', 'field_lock_description', 'unlocked'),
(1761, 'auth_shibboleth', 'field_map_idnumber', ''),
(1762, 'auth_shibboleth', 'field_updatelocal_idnumber', 'oncreate'),
(1763, 'auth_shibboleth', 'field_lock_idnumber', 'unlocked'),
(1764, 'auth_shibboleth', 'field_map_institution', ''),
(1765, 'auth_shibboleth', 'field_updatelocal_institution', 'oncreate'),
(1766, 'auth_shibboleth', 'field_lock_institution', 'unlocked'),
(1767, 'auth_shibboleth', 'field_map_department', ''),
(1768, 'auth_shibboleth', 'field_updatelocal_department', 'oncreate'),
(1769, 'auth_shibboleth', 'field_lock_department', 'unlocked'),
(1770, 'auth_shibboleth', 'field_map_phone1', ''),
(1771, 'auth_shibboleth', 'field_updatelocal_phone1', 'oncreate'),
(1772, 'auth_shibboleth', 'field_lock_phone1', 'unlocked'),
(1773, 'auth_shibboleth', 'field_map_phone2', ''),
(1774, 'auth_shibboleth', 'field_updatelocal_phone2', 'oncreate'),
(1775, 'auth_shibboleth', 'field_lock_phone2', 'unlocked'),
(1776, 'auth_shibboleth', 'field_map_address', ''),
(1777, 'auth_shibboleth', 'field_updatelocal_address', 'oncreate'),
(1778, 'auth_shibboleth', 'field_lock_address', 'unlocked'),
(1779, 'auth_shibboleth', 'field_map_firstnamephonetic', ''),
(1780, 'auth_shibboleth', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1781, 'auth_shibboleth', 'field_lock_firstnamephonetic', 'unlocked'),
(1782, 'auth_shibboleth', 'field_map_lastnamephonetic', ''),
(1783, 'auth_shibboleth', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1784, 'auth_shibboleth', 'field_lock_lastnamephonetic', 'unlocked'),
(1785, 'auth_shibboleth', 'field_map_middlename', ''),
(1786, 'auth_shibboleth', 'field_updatelocal_middlename', 'oncreate'),
(1787, 'auth_shibboleth', 'field_lock_middlename', 'unlocked'),
(1788, 'auth_shibboleth', 'field_map_alternatename', ''),
(1789, 'auth_shibboleth', 'field_updatelocal_alternatename', 'oncreate'),
(1790, 'auth_shibboleth', 'field_lock_alternatename', 'unlocked'),
(1791, 'block_accessreview', 'whattoshow', 'showboth'),
(1792, 'block_accessreview', 'errordisplay', 'showint'),
(1793, 'block_accessreview', 'toolpage', 'errors'),
(1794, 'block_activity_results', 'config_showbest', '3'),
(1795, 'block_activity_results', 'config_showbest_locked', ''),
(1796, 'block_activity_results', 'config_showworst', '0'),
(1797, 'block_activity_results', 'config_showworst_locked', ''),
(1798, 'block_activity_results', 'config_usegroups', '0'),
(1799, 'block_activity_results', 'config_usegroups_locked', ''),
(1800, 'block_activity_results', 'config_nameformat', '1'),
(1801, 'block_activity_results', 'config_nameformat_locked', ''),
(1802, 'block_activity_results', 'config_gradeformat', '1'),
(1803, 'block_activity_results', 'config_gradeformat_locked', ''),
(1804, 'block_activity_results', 'config_decimalpoints', '2'),
(1805, 'block_activity_results', 'config_decimalpoints_locked', ''),
(1806, 'block_myoverview', 'displaycategories', '1'),
(1807, 'block_myoverview', 'layouts', 'card,list,summary'),
(1808, 'block_myoverview', 'displaygroupingallincludinghidden', '0'),
(1809, 'block_myoverview', 'displaygroupingall', '1'),
(1810, 'block_myoverview', 'displaygroupinginprogress', '1'),
(1811, 'block_myoverview', 'displaygroupingpast', '1'),
(1812, 'block_myoverview', 'displaygroupingfuture', '1'),
(1813, 'block_myoverview', 'displaygroupingcustomfield', '0'),
(1814, 'block_myoverview', 'customfiltergrouping', ''),
(1815, 'block_myoverview', 'displaygroupingfavourites', '1'),
(1816, 'block_myoverview', 'displaygroupinghidden', '1'),
(1817, 'block_recentlyaccessedcourses', 'displaycategories', '1'),
(1818, 'block_section_links', 'numsections1', '22'),
(1819, 'block_section_links', 'incby1', '2'),
(1820, 'block_section_links', 'numsections2', '40'),
(1821, 'block_section_links', 'incby2', '5'),
(1822, 'block_section_links', 'showsectionname', '0'),
(1823, 'block_starredcourses', 'displaycategories', '1'),
(1824, 'block_tag_youtube', 'apikey', ''),
(1825, 'format_singleactivity', 'activitytype', 'forum'),
(1826, 'format_topics', 'indentation', '1'),
(1827, 'format_weeks', 'indentation', '1'),
(1828, 'fileconverter_googledrive', 'issuerid', ''),
(1829, 'enrol_cohort', 'roleid', '5'),
(1830, 'enrol_cohort', 'unenrolaction', '0'),
(1831, 'enrol_meta', 'nosyncroleids', ''),
(1832, 'enrol_meta', 'syncall', '1'),
(1833, 'enrol_meta', 'unenrolaction', '3'),
(1834, 'enrol_meta', 'coursesort', 'sortorder'),
(1835, 'enrol_fee', 'expiredaction', '3'),
(1836, 'enrol_fee', 'status', '1'),
(1837, 'enrol_fee', 'cost', '0'),
(1838, 'enrol_fee', 'currency', 'USD'),
(1839, 'enrol_fee', 'roleid', '5'),
(1840, 'enrol_fee', 'enrolperiod', '0'),
(1841, 'enrol_database', 'dbtype', ''),
(1842, 'enrol_database', 'dbhost', 'localhost'),
(1843, 'enrol_database', 'dbuser', ''),
(1844, 'enrol_database', 'dbpass', ''),
(1845, 'enrol_database', 'dbname', ''),
(1846, 'enrol_database', 'dbencoding', 'utf-8'),
(1847, 'enrol_database', 'dbsetupsql', ''),
(1848, 'enrol_database', 'dbsybasequoting', '0'),
(1849, 'enrol_database', 'debugdb', '0'),
(1850, 'enrol_database', 'localcoursefield', 'idnumber'),
(1851, 'enrol_database', 'localuserfield', 'idnumber'),
(1852, 'enrol_database', 'localrolefield', 'shortname'),
(1853, 'enrol_database', 'localcategoryfield', 'id'),
(1854, 'enrol_database', 'remoteenroltable', ''),
(1855, 'enrol_database', 'remotecoursefield', ''),
(1856, 'enrol_database', 'remoteuserfield', ''),
(1857, 'enrol_database', 'remoterolefield', ''),
(1858, 'enrol_database', 'remoteotheruserfield', ''),
(1859, 'enrol_database', 'defaultrole', '5'),
(1860, 'enrol_database', 'ignorehiddencourses', '0'),
(1861, 'enrol_database', 'unenrolaction', '0'),
(1862, 'enrol_database', 'newcoursetable', ''),
(1863, 'enrol_database', 'newcoursefullname', 'fullname'),
(1864, 'enrol_database', 'newcourseshortname', 'shortname'),
(1865, 'enrol_database', 'newcourseidnumber', 'idnumber'),
(1866, 'enrol_database', 'newcoursecategory', ''),
(1867, 'enrol_database', 'defaultcategory', '1'),
(1868, 'enrol_database', 'templatecourse', ''),
(1869, 'enrol_flatfile', 'location', ''),
(1870, 'enrol_flatfile', 'encoding', 'UTF-8'),
(1871, 'enrol_flatfile', 'mailstudents', '0'),
(1872, 'enrol_flatfile', 'mailteachers', '0'),
(1873, 'enrol_flatfile', 'mailadmins', '0'),
(1874, 'enrol_flatfile', 'unenrolaction', '3'),
(1875, 'enrol_flatfile', 'expiredaction', '3'),
(1876, 'enrol_guest', 'requirepassword', '0'),
(1877, 'enrol_guest', 'usepasswordpolicy', '0'),
(1878, 'enrol_guest', 'showhint', '0'),
(1879, 'enrol_guest', 'defaultenrol', '1'),
(1880, 'enrol_guest', 'status', '1'),
(1881, 'enrol_guest', 'status_adv', ''),
(1882, 'enrol_imsenterprise', 'imsfilelocation', ''),
(1883, 'enrol_imsenterprise', 'logtolocation', ''),
(1884, 'enrol_imsenterprise', 'mailadmins', '0'),
(1885, 'enrol_imsenterprise', 'createnewusers', '0'),
(1886, 'enrol_imsenterprise', 'imsupdateusers', '0'),
(1887, 'enrol_imsenterprise', 'imsdeleteusers', '0'),
(1888, 'enrol_imsenterprise', 'fixcaseusernames', '0'),
(1889, 'enrol_imsenterprise', 'fixcasepersonalnames', '0'),
(1890, 'enrol_imsenterprise', 'imssourcedidfallback', '0'),
(1891, 'enrol_imsenterprise', 'imsrolemap01', '5'),
(1892, 'enrol_imsenterprise', 'imsrolemap02', '3'),
(1893, 'enrol_imsenterprise', 'imsrolemap03', '3'),
(1894, 'enrol_imsenterprise', 'imsrolemap04', '5'),
(1895, 'enrol_imsenterprise', 'imsrolemap05', '0'),
(1896, 'enrol_imsenterprise', 'imsrolemap06', '4'),
(1897, 'enrol_imsenterprise', 'imsrolemap07', '0'),
(1898, 'enrol_imsenterprise', 'imsrolemap08', '4'),
(1899, 'enrol_imsenterprise', 'truncatecoursecodes', '0'),
(1900, 'enrol_imsenterprise', 'createnewcourses', '0'),
(1901, 'enrol_imsenterprise', 'updatecourses', '0'),
(1902, 'enrol_imsenterprise', 'createnewcategories', '0'),
(1903, 'enrol_imsenterprise', 'nestedcategories', '0'),
(1904, 'enrol_imsenterprise', 'categoryidnumber', '0'),
(1905, 'enrol_imsenterprise', 'categoryseparator', ''),
(1906, 'enrol_imsenterprise', 'imsunenrol', '0'),
(1907, 'enrol_imsenterprise', 'unenrolaction', '0'),
(1908, 'enrol_imsenterprise', 'imscoursemapshortname', 'coursecode'),
(1909, 'enrol_imsenterprise', 'imscoursemapfullname', 'short'),
(1910, 'enrol_imsenterprise', 'imscoursemapsummary', 'ignore'),
(1911, 'enrol_imsenterprise', 'imsrestricttarget', ''),
(1912, 'enrol_imsenterprise', 'imscapitafix', '0'),
(1913, 'enrol_ldap', 'host_url', ''),
(1914, 'enrol_ldap', 'start_tls', '0'),
(1915, 'enrol_ldap', 'ldap_version', '3'),
(1916, 'enrol_ldap', 'ldapencoding', 'utf-8'),
(1917, 'enrol_ldap', 'pagesize', '250'),
(1918, 'enrol_ldap', 'bind_dn', ''),
(1919, 'enrol_ldap', 'bind_pw', ''),
(1920, 'enrol_ldap', 'course_search_sub', '0'),
(1921, 'enrol_ldap', 'memberattribute_isdn', '0'),
(1922, 'enrol_ldap', 'user_contexts', ''),
(1923, 'enrol_ldap', 'user_search_sub', '0'),
(1924, 'enrol_ldap', 'user_type', 'default'),
(1925, 'enrol_ldap', 'opt_deref', '0'),
(1926, 'enrol_ldap', 'idnumber_attribute', ''),
(1927, 'enrol_ldap', 'objectclass', '(objectClass=*)'),
(1928, 'enrol_ldap', 'course_idnumber', ''),
(1929, 'enrol_ldap', 'course_shortname', ''),
(1930, 'enrol_ldap', 'course_fullname', ''),
(1931, 'enrol_ldap', 'course_summary', ''),
(1932, 'enrol_ldap', 'ignorehiddencourses', '0'),
(1933, 'enrol_ldap', 'unenrolaction', '0'),
(1934, 'enrol_ldap', 'autocreate', '0'),
(1935, 'enrol_ldap', 'category', '1'),
(1936, 'enrol_ldap', 'template', ''),
(1937, 'enrol_ldap', 'course_shortname_updateonsync', '0'),
(1938, 'enrol_ldap', 'course_fullname_updateonsync', '0'),
(1939, 'enrol_ldap', 'course_summary_updateonsync', '0'),
(1940, 'enrol_ldap', 'nested_groups', '0'),
(1941, 'enrol_ldap', 'group_memberofattribute', ''),
(1942, 'enrol_manual', 'expiredaction', '1'),
(1943, 'enrol_manual', 'expirynotifyhour', '6'),
(1944, 'enrol_manual', 'defaultenrol', '1'),
(1945, 'enrol_manual', 'status', '0'),
(1946, 'enrol_manual', 'roleid', '5'),
(1947, 'enrol_manual', 'enrolstart', '4'),
(1948, 'enrol_manual', 'enrolperiod', '0'),
(1949, 'enrol_manual', 'expirynotify', '0'),
(1950, 'enrol_manual', 'expirythreshold', '86400'),
(1951, 'enrol_mnet', 'roleid', '5'),
(1952, 'enrol_mnet', 'roleid_adv', '1'),
(1953, 'enrol_paypal', 'paypalbusiness', ''),
(1954, 'enrol_paypal', 'mailstudents', '0'),
(1955, 'enrol_paypal', 'mailteachers', '0'),
(1956, 'enrol_paypal', 'mailadmins', '0'),
(1957, 'enrol_paypal', 'expiredaction', '3'),
(1958, 'enrol_paypal', 'status', '1'),
(1959, 'enrol_paypal', 'cost', '0'),
(1960, 'enrol_paypal', 'currency', 'USD'),
(1961, 'enrol_paypal', 'roleid', '5'),
(1962, 'enrol_paypal', 'enrolperiod', '0'),
(1963, 'enrol_lti', 'emaildisplay', '2'),
(1964, 'enrol_lti', 'city', ''),
(1965, 'enrol_lti', 'country', ''),
(1966, 'enrol_lti', 'timezone', '99'),
(1967, 'enrol_lti', 'lang', 'en'),
(1968, 'enrol_lti', 'institution', ''),
(1969, 'enrol_self', 'requirepassword', '0'),
(1970, 'enrol_self', 'usepasswordpolicy', '0'),
(1971, 'enrol_self', 'showhint', '0'),
(1972, 'enrol_self', 'expiredaction', '1'),
(1973, 'enrol_self', 'expirynotifyhour', '6'),
(1974, 'enrol_self', 'defaultenrol', '1'),
(1975, 'enrol_self', 'status', '1'),
(1976, 'enrol_self', 'newenrols', '1'),
(1977, 'enrol_self', 'groupkey', '0'),
(1978, 'enrol_self', 'roleid', '5'),
(1979, 'enrol_self', 'enrolperiod', '0'),
(1980, 'enrol_self', 'expirynotify', '0'),
(1981, 'enrol_self', 'expirythreshold', '86400'),
(1982, 'enrol_self', 'longtimenosee', '0'),
(1983, 'enrol_self', 'maxenrolled', '0'),
(1984, 'enrol_self', 'sendcoursewelcomemessage', '1'),
(1985, 'filter_urltolink', 'formats', '1,4,0'),
(1986, 'filter_urltolink', 'embedimages', '1'),
(1987, 'filter_emoticon', 'formats', '1,4,0'),
(1988, 'filter_displayh5p', 'allowedsources', ''),
(1989, 'filter_mathjaxloader', 'httpsurl', 'https://cdn.jsdelivr.net/npm/mathjax@2.7.9/MathJax.js'),
(1990, 'filter_mathjaxloader', 'texfiltercompatibility', '0'),
(1991, 'filter_mathjaxloader', 'mathjaxconfig', '\nMathJax.Hub.Config({\n    config: ["Accessible.js", "Safe.js"],\n    errorSettings: { message: ["!"] },\n    skipStartupTypeset: true,\n    messageStyle: "none"\n});\n'),
(1992, 'filter_mathjaxloader', 'additionaldelimiters', ''),
(1993, 'filter_tex', 'latexpreamble', '\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n'),
(1994, 'filter_tex', 'latexbackground', '#FFFFFF'),
(1995, 'filter_tex', 'density', '120'),
(1996, 'filter_tex', 'pathlatex', '/usr/bin/latex'),
(1997, 'filter_tex', 'pathdvips', '/usr/bin/dvips'),
(1998, 'filter_tex', 'pathconvert', '/usr/bin/convert'),
(1999, 'filter_tex', 'pathdvisvgm', '/usr/bin/dvisvgm'),
(2000, 'filter_tex', 'pathmimetex', ''),
(2001, 'filter_tex', 'convertformat', 'gif'),
(2002, 'logstore_database', 'dbdriver', ''),
(2003, 'logstore_database', 'dbhost', ''),
(2004, 'logstore_database', 'dbuser', ''),
(2005, 'logstore_database', 'dbpass', ''),
(2006, 'logstore_database', 'dbname', ''),
(2007, 'logstore_database', 'dbtable', ''),
(2008, 'logstore_database', 'dbpersist', '0'),
(2009, 'logstore_database', 'dbsocket', ''),
(2010, 'logstore_database', 'dbport', ''),
(2011, 'logstore_database', 'dbschema', ''),
(2012, 'logstore_database', 'dbcollation', ''),
(2013, 'logstore_database', 'dbhandlesoptions', '0'),
(2014, 'logstore_database', 'buffersize', '50'),
(2015, 'logstore_database', 'jsonformat', '1'),
(2016, 'logstore_database', 'logguests', '0'),
(2017, 'logstore_database', 'includelevels', '1,2,0'),
(2018, 'logstore_database', 'includeactions', 'c,r,u,d'),
(2019, 'logstore_standard', 'logguests', '1'),
(2020, 'logstore_standard', 'jsonformat', '1'),
(2021, 'logstore_standard', 'loglifetime', '0'),
(2022, 'logstore_standard', 'buffersize', '50'),
(2023, 'mlbackend_python', 'useserver', '0'),
(2024, 'mlbackend_python', 'host', ''),
(2025, 'mlbackend_python', 'port', '0'),
(2026, 'mlbackend_python', 'secure', '0'),
(2027, 'mlbackend_python', 'username', 'default'),
(2028, 'mlbackend_python', 'password', ''),
(2029, 'media_videojs', 'videoextensions', 'html_video,media_source,.f4v,.flv'),
(2030, 'media_videojs', 'audioextensions', 'html_audio'),
(2031, 'media_videojs', 'youtube', '1'),
(2032, 'media_videojs', 'videocssclass', 'video-js'),
(2033, 'media_videojs', 'audiocssclass', 'video-js'),
(2034, 'media_videojs', 'limitsize', '1'),
(2035, 'media_vimeo', 'donottrack', '0'),
(2036, 'media_youtube', 'nocookie', '0'),
(2037, 'paygw_paypal', 'surcharge', '0'),
(2038, 'qtype_multichoice', 'answerhowmany', '1'),
(2039, 'qtype_multichoice', 'shuffleanswers', '1'),
(2040, 'qtype_multichoice', 'answernumbering', 'abc'),
(2041, 'qtype_multichoice', 'showstandardinstruction', '0'),
(2042, 'editor_atto', 'toolbar', 'collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist, indent\nlinks = link\nfiles = emojipicker, image, media, recordrtc, managefiles, h5p\naccessibility = accessibilitychecker, accessibilityhelper\nstyle2 = underline, strike, subscript, superscript\nalign = align\ninsert = equation, charmap, table, clear\nundo = undo\nother = html'),
(2043, 'editor_atto', 'autosavefrequency', '60'),
(2044, 'atto_collapse', 'showgroups', '6'),
(2045, 'atto_equation', 'librarygroup1', '\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n'),
(2046, 'atto_equation', 'librarygroup2', '\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n'),
(2047, 'atto_equation', 'librarygroup3', '\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n'),
(2048, 'atto_equation', 'librarygroup4', '\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\\\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n'),
(2049, 'atto_recordrtc', 'allowedtypes', 'both'),
(2050, 'atto_recordrtc', 'audiobitrate', '128000'),
(2051, 'atto_recordrtc', 'videobitrate', '2500000'),
(2052, 'atto_recordrtc', 'audiotimelimit', '120'),
(2053, 'atto_recordrtc', 'videotimelimit', '120'),
(2054, 'atto_table', 'allowborders', '0'),
(2055, 'atto_table', 'allowbackgroundcolour', '0'),
(2056, 'atto_table', 'allowwidth', '0'),
(2057, 'editor_tiny', 'branding', '1'),
(2058, 'tiny_equation', 'librarygroup1', '\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n'),
(2059, 'tiny_equation', 'librarygroup2', '\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n'),
(2060, 'tiny_equation', 'librarygroup3', '\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n'),
(2061, 'tiny_equation', 'librarygroup4', '\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\\\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n'),
(2062, 'tiny_premium', 'apikey', ''),
(2063, 'tiny_recordrtc', 'allowedtypes', 'both'),
(2064, 'tiny_recordrtc', 'audiobitrate', '128000'),
(2065, 'tiny_recordrtc', 'videobitrate', '2500000'),
(2066, 'tiny_recordrtc', 'audiotimelimit', '120'),
(2067, 'tiny_recordrtc', 'videotimelimit', '120'),
(2068, 'tool_mobile', 'apppolicy', ''),
(2069, 'tool_mobile', 'typeoflogin', '1'),
(2070, 'tool_mobile', 'autologout', '0'),
(2071, 'tool_mobile', 'autologouttime', '86400'),
(2072, 'tool_mobile', 'qrcodetype', '1'),
(2073, 'tool_mobile', 'qrkeyttl', '600'),
(2074, 'tool_mobile', 'qrsameipcheck', '1'),
(2075, 'tool_mobile', 'forcedurlscheme', 'moodlemobile'),
(2076, 'tool_mobile', 'minimumversion', ''),
(2077, 'tool_mobile', 'autologinmintimebetweenreq', '360'),
(2078, 'tool_mobile', 'enablesmartappbanners', '0'),
(2079, 'tool_mobile', 'iosappid', '633359593'),
(2080, 'tool_mobile', 'androidappid', 'com.moodle.moodlemobile'),
(2081, 'tool_mobile', 'setuplink', 'https://download.moodle.org/mobile'),
(2082, 'tool_mobile', 'forcelogout', '0'),
(2083, 'tool_mobile', 'disabledfeatures', ''),
(2084, 'tool_mobile', 'custommenuitems', ''),
(2085, 'tool_mobile', 'filetypeexclusionlist', ''),
(2086, 'tool_mobile', 'customlangstrings', ''),
(2087, 'tool_moodlenet', 'defaultmoodlenetname', 'MoodleNet Central'),
(2088, 'tool_moodlenet', 'defaultmoodlenet', 'https://moodle.net'),
(2089, 'tool_task', 'lastcronstart', '1699933681'),
(2090, 'core_plugin', 'recentfetch', '1699928042'),
(2091, 'core_plugin', 'recentresponse', '{"status":"OK","provider":"https:\\/\\/download.moodle.org\\/api\\/1.3\\/updates.php","apiver":"1.3","timegenerated":1699928043,"ticket":"JUM5JTkxZSVGNzUlODIlMkMlMkIlQjAlOUQlOEMlODclRTAxJTEwJUI1JTFBJUM5JTlDJUFGJTAzZiU5QnR3JUVGJUFFS20lRkMlN0MlMEYlOEYlMTUlMUIlODUlN0IlOEYlRjlMJTg3","forbranch":"4.3","forversion":"2023100900","updates":{"core":[{"version":2023100900.05,"release":"4.3+ (Build: 20231110)","branch":"4.03","maturity":200,"date":1696649460,"url":"https:\\/\\/download.moodle.org","download":"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/stable403\\/moodle-latest-403.zip","norelease_index_info":{"version":"4.3+","branch":"MOODLE_403_STABLE","githash":"935c250","date":1699579035,"zip":{"size":87755928,"md5":true,"sha256":true},"tgz":{"size":66741517,"md5":true,"sha256":true}},"release_index_info":{"version":"4.3","branch":"MOODLE_403_STABLE","githash":"fe7aff8","date":1696649460,"zip":{"size":87735566,"md5":true,"sha256":true},"tgz":{"size":66728529,"md5":true,"sha256":true}},"windows":{"size":228124186}},{"version":2023111000,"release":"4.4dev (Build: 20231110)","branch":"4.04","maturity":50,"date":1699579031,"url":"https:\\/\\/download.moodle.org","download":"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/moodle\\/moodle-latest.zip","norelease_index_info":{"version":"4.4dev","branch":"master","githash":"14414fe","date":1699579031,"zip":{"size":87784862,"md5":true,"sha256":true},"tgz":{"size":66758913,"md5":true,"sha256":true}},"windows":{"size":228153297}}],"theme_academi":[{"version":"2023102400","release":"v4.3","maturity":200,"url":"https:\\/\\/moodle.org\\/plugins\\/pluginversion.php?id=30362","download":"https:\\/\\/moodle.org\\/plugins\\/download.php\\/30362\\/theme_academi_moodle43_2023102400.zip","downloadmd5":"fd92797e7637276c6ffad663fc240ec6"}],"theme_boosted":[{"version":"2023100100","release":"1.3.0","maturity":200,"url":"https:\\/\\/moodle.org\\/plugins\\/pluginversion.php?id=30391","download":"https:\\/\\/moodle.org\\/plugins\\/download.php\\/30391\\/theme_boosted_moodle43_2023100100.zip","downloadmd5":"aca78c6c8844f92a45ee2d979623fd16"}]}}'),
(2092, 'tool_brickfield', 'bfregstatus', '0'),
(2093, 'tool_brickfield', 'bfregvalidationchecktime', '1698644943'),
(2094, 'tool_brickfield', 'bfregvalidationtime', '1698644943'),
(2095, 'tool_brickfield', 'bfsummarytime', '1698644943'),
(2096, 'tool_brickfield', 'key', ''),
(2097, 'tool_brickfield', 'hash', ''),
(2098, 'tool_brickfield', 'id', '0'),
(2099, 'tool_task', 'lastcroninterval', '60'),
(2100, 'theme_boosted', 'version', '2023100100'),
(2101, 'theme_boosted', 'unaddableblocks', 'navigation,settings,course_list,section_links'),
(2102, 'theme_boosted', 'preset', 'plain.scss'),
(2103, 'theme_boosted', 'favicon', '/WhatsApp_Image_2023-10-24_at_9.16.09_AM-removebg-preview.png'),
(2104, 'theme_boosted', 'backgroundimage', '/pexels-andrea-piacquadio-3762800.jpg'),
(2105, 'theme_boosted', 'contentwidth', '80%'),
(2106, 'theme_boosted', 'brandcolor', '#0413F0'),
(2107, 'theme_boosted', 'pagebgcolor', '#89e43a'),
(2108, 'theme_boosted', 'focusborder', '#3a89e4'),
(2109, 'theme_boosted', 'selectiontext', '#000'),
(2110, 'theme_boosted', 'selectionbg', '#fff000'),
(2111, 'theme_boosted', 'customfontmain', 'lexend-deca-v17-latin-regular.woff2'),
(2112, 'theme_boosted', 'fontsize', '1rem'),
(2113, 'theme_boosted', 'fontmaincolor', '#333'),
(2114, 'theme_boosted', 'customfontheader', 'montserrat-v25-latin-700.woff2'),
(2115, 'theme_boosted', 'fontheadercolor', '#03003C'),
(2116, 'theme_boosted', 'headerbgcolor', '#fff'),
(2117, 'theme_boosted', 'headertextcolor', '#333'),
(2118, 'theme_boosted', 'footerbgcolor', '#424242'),
(2119, 'theme_boosted', 'footertextcolor', '#fff'),
(2120, 'theme_boosted', 'footnote', ''),
(2121, 'theme_boosted', 'socialiconslist', ''),
(2122, 'theme_boosted', 'footerlayout', '4'),
(2123, 'theme_boosted', 'loginbackgroundimage', '/pexels-andrea-piacquadio-3762800.jpg'),
(2124, 'theme_boosted', 'loginboxalign', 'center'),
(2125, 'theme_boosted', 'bannerimage', ''),
(2126, 'theme_boosted', 'bannertext', ''),
(2127, 'theme_boosted', 'bannerbutton', ''),
(2128, 'theme_boosted', 'bannerbuttonlink', ''),
(2129, 'theme_boosted', 'bannertextvalign', 'start'),
(2130, 'theme_boosted', 'infoblockslayout', '4'),
(2131, 'theme_boosted', 'scsspre', ''),
(2132, 'theme_boosted', 'scss', ''),
(2133, 'theme_boosted', 'footerblocktitle1', ''),
(2134, 'theme_boosted', 'footerblockcontent1', ''),
(2135, 'theme_boosted', 'footerblocktitle2', ''),
(2136, 'theme_boosted', 'footerblockcontent2', ''),
(2137, 'theme_boosted', 'footerblocktitle3', ''),
(2138, 'theme_boosted', 'footerblockcontent3', ''),
(2139, 'theme_boosted', 'footerblocktitle4', ''),
(2140, 'theme_boosted', 'footerblockcontent4', ''),
(2141, 'theme_boosted', 'infoblockcontent1', ''),
(2142, 'theme_boosted', 'infoblockcontent2', ''),
(2143, 'theme_boosted', 'infoblockcontent3', ''),
(2144, 'theme_boosted', 'infoblockcontent4', ''),
(2145, 'enrol_manual', 'expirynotifylast', '1699873201'),
(2146, 'enrol_self', 'expirynotifylast', '1699873201'),
(2147, 'core_h5p', 'site_uuid', '0a4c108a-a496-4b54-91d6-edfe2013d51d'),
(2148, 'theme_academi', 'version', '2023102400'),
(2150, 'theme_academi', 'logo', '/WhatsApp_Image_2023-10-24_at_9.16.09_AM-removebg-preview.png'),
(2151, 'theme_academi', 'favicon', '/rsz_2whatsapp_image_2023-10-24_at_91609_am-removebg-preview.png'),
(2152, 'theme_academi', 'primarycolor', '#133a5e'),
(2153, 'theme_academi', 'secondarycolor', '#f3dc7f'),
(2154, 'theme_academi', 'themestyleheader', '1'),
(2155, 'theme_academi', 'pagesize', 'container'),
(2156, 'theme_academi', 'pagesizecustomval', '0'),
(2157, 'theme_academi', 'fontsize', '16'),
(2158, 'theme_academi', 'availablecoursetype', '1'),
(2159, 'theme_academi', 'comboListboxType', '1'),
(2160, 'theme_academi', 'loginbg', '/pexels-andrea-piacquadio-3762800.jpg'),
(2161, 'theme_academi', 'backToTop_status', '1'),
(2162, 'theme_academi', 'customcss', ''),
(2163, 'theme_academi', 'preset', 'academi'),
(2164, 'theme_academi', 'presetfiles', ''),
(2165, 'theme_academi', 'toggleslideshow', '1'),
(2166, 'theme_academi', 'autoslideshow', '1'),
(2167, 'theme_academi', 'slideinterval', '3500'),
(2168, 'theme_academi', 'slideOverlay', '0.4'),
(2169, 'theme_academi', 'numberofslides', '3'),
(2170, 'theme_academi', 'pcoursestatus', '1'),
(2171, 'theme_academi', 'promotedtitle', 'lang:promotedtitledefault'),
(2172, 'theme_academi', 'promotedcoursedesc', 'lang:description_default'),
(2173, 'theme_academi', 'promotedcourses', '3,2'),
(2174, 'theme_academi', 'sitefblockstatus', '0'),
(2175, 'theme_academi', 'sitefeaturetitle', 'lang:sitefeaturesdefault'),
(2176, 'theme_academi', 'sitefeaturedesc', 'lang:description_default'),
(2177, 'theme_academi', 'numberofsitefeature', '4'),
(2178, 'theme_academi', 'mspotstatus', '0'),
(2179, 'theme_academi', 'mspottitle', 'lang:aboutus'),
(2180, 'theme_academi', 'mspotdesc', 'lang:description_default'),
(2181, 'theme_academi', 'mspotcontent', '<p>Ipsum in aspernatur ut possimus sint. Quia omnis est occaecati possimus ea. Quas molestiae perspiciatis occaecati qui rerum. Deleniti quod porro sed quisquam saepe. Numquam mollitia recusandae non ad at et a.</p>\r\n<p>Ad vitae recusandae odit possimus. Quaerat cum ipsum corrupti. Odit qui asperiores ea corporis deserunt veritatis quidem expedita perferendis. Qui rerum eligendi ex doloribus quia sit. Porro rerum eum eum.</p>\r\n<p>Ad vitae recusandae odit possimus. Quaerat cum ipsum corrupti. Odit qui asperiores ea corporis deserunt veritatis quidem expedita perferendis.</p>'),
(2182, 'theme_academi', 'mspotmedia', '/mspotmedia.png'),
(2183, 'theme_academi', 'jumbotronstatus', '0'),
(2184, 'theme_academi', 'jumbotrontitle', 'lang:learnanytime'),
(2185, 'theme_academi', 'jumbotrondesc', 'lang:learnanytimedesc'),
(2186, 'theme_academi', 'jumbotronbtntext', 'lang:viewallcourses'),
(2187, 'theme_academi', 'jumbotronbtnlink', 'http://www.example.com/'),
(2188, 'theme_academi', 'jumbotronbtntarget', '1'),
(2189, 'theme_academi', 'footerbgimg', ''),
(2190, 'theme_academi', 'footerbgOverlay', '0.4'),
(2191, 'theme_academi', 'copyright_footer', 'Copyright &copy; 2023 - Developed by <a href="https://foresiteltd.com/">Foresite</a>. Powered by <a href="https://moodle.org">Moodle</a>'),
(2192, 'theme_academi', 'footerb1_status', '1'),
(2193, 'theme_academi', 'footerbtitle1', ''),
(2194, 'theme_academi', 'footlogostatus', '1'),
(2195, 'theme_academi', 'footerlogo', '/rsz_2whatsapp_image_2023-10-24_at_91609_am-removebg-preview.png'),
(2196, 'theme_academi', 'footnote', '<p>Elevate Your Career With Our Internationally Recognized Programs.<br><a href="#">Read More »</a></p>'),
(2197, 'theme_academi', 'footerb2_status', '1'),
(2198, 'theme_academi', 'footerbtitle2', 'lang:footerbtitle2default'),
(2199, 'theme_academi', 'infolink', 'ASTI Home|https://astitt.tech/\r\nASTI Student Portal|https://astitt.tech/sis/\r\nASTI UniLearn|https://astitt.tech/unilearn/'),
(2200, 'theme_academi', 'footerb3_status', '1'),
(2201, 'theme_academi', 'footerbtitle3', 'lang:footerbtitle3default'),
(2202, 'theme_academi', 'address', '#46 Boundary Road, San Juan'),
(2203, 'theme_academi', 'emailid', 'education@astitnt.com'),
(2204, 'theme_academi', 'phoneno', '(868) 727-8562'),
(2205, 'theme_academi', 'footerb4_status', '1'),
(2206, 'theme_academi', 'footerbtitle4', 'lang:footerbtitle4default'),
(2207, 'theme_academi', 'numofsocialmedia', '4'),
(2208, 'theme_academi', 'slide1status', '1'),
(2209, 'theme_academi', 'slide1image', '/314436626_137438765719481_7225773790124219650_n.jpg'),
(2210, 'theme_academi', 'slide1contentstatus', '1'),
(2211, 'theme_academi', 'slide1caption', ''),
(2212, 'theme_academi', 'slide1desc', ''),
(2213, 'theme_academi', 'slide1btntext', 'lang:knowmore'),
(2214, 'theme_academi', 'slide1btnurl', ''),
(2215, 'theme_academi', 'slide1btntarget', '1'),
(2216, 'theme_academi', 'slide1contFullwidth', '50'),
(2217, 'theme_academi', 'slide1contentPosition', 'centerRight'),
(2218, 'theme_academi', 'slide2status', '1'),
(2219, 'theme_academi', 'slide2image', '/366646385_260312243432132_384136990631417121_n.jpg'),
(2220, 'theme_academi', 'slide2contentstatus', '1'),
(2221, 'theme_academi', 'slide2caption', ''),
(2222, 'theme_academi', 'slide2desc', ''),
(2223, 'theme_academi', 'slide2btntext', 'lang:knowmore'),
(2224, 'theme_academi', 'slide2btnurl', ''),
(2225, 'theme_academi', 'slide2btntarget', '1'),
(2226, 'theme_academi', 'slide2contFullwidth', '50'),
(2227, 'theme_academi', 'slide2contentPosition', 'centerRight'),
(2228, 'theme_academi', 'slide3status', '1'),
(2229, 'theme_academi', 'slide3image', '/366709971_260312230098800_2506756069623135961_n.jpg'),
(2230, 'theme_academi', 'slide3contentstatus', '1'),
(2231, 'theme_academi', 'slide3caption', ''),
(2232, 'theme_academi', 'slide3desc', ''),
(2233, 'theme_academi', 'slide3btntext', 'lang:knowmore'),
(2234, 'theme_academi', 'slide3btnurl', ''),
(2235, 'theme_academi', 'slide3btntarget', '1'),
(2236, 'theme_academi', 'slide3contFullwidth', '50'),
(2237, 'theme_academi', 'slide3contentPosition', 'centerRight'),
(2238, 'theme_academi', 'sitefblock1status', '1'),
(2239, 'theme_academi', 'sitefblock1title', 'lang:sb1_default_title'),
(2240, 'theme_academi', 'sitefblock1content', 'lang:sb_default_content'),
(2241, 'theme_academi', 'sitefblock1icon', 'lang:sitefblockicon1_default'),
(2242, 'theme_academi', 'sitefblock2status', '1'),
(2243, 'theme_academi', 'sitefblock2title', 'lang:sb2_default_title'),
(2244, 'theme_academi', 'sitefblock2content', 'lang:sb_default_content'),
(2245, 'theme_academi', 'sitefblock2icon', 'lang:sitefblockicon2_default'),
(2246, 'theme_academi', 'sitefblock3status', '1'),
(2247, 'theme_academi', 'sitefblock3title', 'lang:sb3_default_title'),
(2248, 'theme_academi', 'sitefblock3content', 'lang:sb_default_content'),
(2249, 'theme_academi', 'sitefblock3icon', 'lang:sitefblockicon3_default'),
(2250, 'theme_academi', 'sitefblock4status', '1'),
(2251, 'theme_academi', 'sitefblock4title', 'lang:sb4_default_title'),
(2252, 'theme_academi', 'sitefblock4content', 'lang:sb_default_content'),
(2253, 'theme_academi', 'sitefblock4icon', 'lang:sitefblockicon4_default'),
(2254, 'theme_academi', 'socialmedia1_status', '0'),
(2255, 'theme_academi', 'socialmedia1_icon', 'twitter'),
(2256, 'theme_academi', 'socialmedia1_url', 'https://twitter.com/yourtwittername'),
(2257, 'theme_academi', 'socialmedia1_iconcolor', '#47caf6'),
(2258, 'theme_academi', 'socialmedia2_status', '0'),
(2259, 'theme_academi', 'socialmedia2_icon', 'google-plus'),
(2260, 'theme_academi', 'socialmedia2_url', 'https://www.google.com/+yourgoogleplusid'),
(2261, 'theme_academi', 'socialmedia2_iconcolor', '#e84c3d'),
(2262, 'theme_academi', 'socialmedia3_status', '0'),
(2263, 'theme_academi', 'socialmedia3_icon', 'instagram-p'),
(2264, 'theme_academi', 'socialmedia3_url', 'https://www.instagram.com/astitt_university/'),
(2265, 'theme_academi', 'socialmedia3_iconcolor', '#cd2129'),
(2266, 'theme_academi', 'socialmedia4_status', '1'),
(2267, 'theme_academi', 'socialmedia4_icon', 'facebook-f'),
(2268, 'theme_academi', 'socialmedia4_url', 'https://www.facebook.com/ASTIUniversity'),
(2269, 'theme_academi', 'socialmedia4_iconcolor', '#3598dc');

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_contentbank_content`
--

CREATE TABLE `mdlxd_contentbank_content` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `contenttype` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `contextid` bigint NOT NULL,
  `visibility` tinyint(1) NOT NULL DEFAULT '1',
  `instanceid` bigint DEFAULT NULL,
  `configdata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `usercreated` bigint NOT NULL,
  `usermodified` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_contcont_nam_ix` (`name`),
  KEY `mdlxd_contcont_conconins_ix` (`contextid`,`contenttype`,`instanceid`),
  KEY `mdlxd_contcont_con_ix` (`contextid`),
  KEY `mdlxd_contcont_use_ix` (`usermodified`),
  KEY `mdlxd_contcont_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='This table stores content data in the content bank.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_context`
--

CREATE TABLE `mdlxd_context` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextlevel` bigint NOT NULL DEFAULT '0',
  `instanceid` bigint NOT NULL DEFAULT '0',
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `depth` tinyint NOT NULL DEFAULT '0',
  `locked` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_cont_conins_uix` (`contextlevel`,`instanceid`),
  KEY `mdlxd_cont_ins_ix` (`instanceid`),
  KEY `mdlxd_cont_pat_ix` (`path`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='one of these must be set';

--
-- Dumping data for table `mdlxd_context`
--

INSERT INTO `mdlxd_context` VALUES
(1, 10, 0, '/1', 1, 0),
(2, 50, 1, '/1/2', 2, 0),
(4, 30, 1, '/1/4', 2, 0),
(5, 30, 2, '/1/5', 2, 0),
(6, 80, 1, '/1/6', 2, 0),
(7, 80, 2, '/1/7', 2, 0),
(8, 80, 3, '/1/8', 2, 0),
(9, 80, 4, '/1/9', 2, 0),
(10, 80, 5, '/1/10', 2, 0),
(11, 80, 6, '/1/5/11', 3, 0),
(12, 80, 7, '/1/5/12', 3, 0),
(13, 80, 8, '/1/5/13', 3, 0),
(14, 40, 2, '/1/14', 2, 0),
(15, 40, 3, '/1/15', 2, 0),
(16, 50, 2, '/1/15/16', 3, 0),
(17, 80, 9, '/1/15/16/17', 4, 0),
(19, 50, 3, '/1/14/19', 3, 0),
(21, 70, 3, '/1/15/16/21', 4, 0),
(22, 70, 4, '/1/14/19/22', 4, 0),
(23, 30, 3, '/1/23', 2, 0),
(24, 30, 4, '/1/24', 2, 0),
(25, 30, 5, '/1/25', 2, 0),
(26, 80, 10, '/1/25/26', 3, 0),
(27, 80, 11, '/1/25/27', 3, 0),
(28, 80, 12, '/1/25/28', 3, 0);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_context_temp`
--

CREATE TABLE `mdlxd_context_temp` (
  `id` bigint NOT NULL,
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `depth` tinyint NOT NULL,
  `locked` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Used by build_context_path() in upgrade and cron to keep con';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course`
--

CREATE TABLE `mdlxd_course` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `category` bigint NOT NULL DEFAULT '0',
  `sortorder` bigint NOT NULL DEFAULT '0',
  `fullname` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `shortname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `summary` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `summaryformat` tinyint NOT NULL DEFAULT '0',
  `format` varchar(21) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'topics',
  `showgrades` tinyint NOT NULL DEFAULT '1',
  `newsitems` mediumint NOT NULL DEFAULT '1',
  `startdate` bigint NOT NULL DEFAULT '0',
  `enddate` bigint NOT NULL DEFAULT '0',
  `relativedatesmode` tinyint(1) NOT NULL DEFAULT '0',
  `marker` bigint NOT NULL DEFAULT '0',
  `maxbytes` bigint NOT NULL DEFAULT '0',
  `legacyfiles` smallint NOT NULL DEFAULT '0',
  `showreports` smallint NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `downloadcontent` tinyint(1) DEFAULT NULL,
  `groupmode` smallint NOT NULL DEFAULT '0',
  `groupmodeforce` smallint NOT NULL DEFAULT '0',
  `defaultgroupingid` bigint NOT NULL DEFAULT '0',
  `lang` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `calendartype` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `theme` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `requested` tinyint(1) NOT NULL DEFAULT '0',
  `enablecompletion` tinyint(1) NOT NULL DEFAULT '0',
  `completionnotify` tinyint(1) NOT NULL DEFAULT '0',
  `cacherev` bigint NOT NULL DEFAULT '0',
  `originalcourseid` bigint DEFAULT NULL,
  `showactivitydates` tinyint(1) NOT NULL DEFAULT '0',
  `showcompletionconditions` tinyint(1) DEFAULT NULL,
  `pdfexportfont` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_cour_cat_ix` (`category`),
  KEY `mdlxd_cour_idn_ix` (`idnumber`),
  KEY `mdlxd_cour_sho_ix` (`shortname`),
  KEY `mdlxd_cour_sor_ix` (`sortorder`),
  KEY `mdlxd_cour_ori_ix` (`originalcourseid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Central course table';

--
-- Dumping data for table `mdlxd_course`
--

INSERT INTO `mdlxd_course` VALUES
(1, 0, 1, 'UniLearn', 'ASTI LMS', '', '', 0, 'site', 1, 3, 0, 0, 0, 0, 0, 0, 0, 1, 1, NULL, 0, 0, 0, '', '', '', 1698644927, 1698644927, 0, 0, 0, 1699168705, NULL, 0, NULL, NULL),
(2, 3, 20001, 'Social Media Marketing', 'SMM', '', '<p>Marketing in the digital space commonly referred to as ‘Social Media/Digital Marketing’, in the present day is an inescapable term for any organization; and has become one of the most discussed topics across industries and geographic boundaries.</p>', 1, 'topics', 1, 0, 1698811200, 1730347200, 0, 0, 0, 0, 0, 1, 1, NULL, 0, 0, 0, '', '', '', 1698729643, 1698729892, 0, 1, 0, 1699168705, NULL, 1, 1, NULL),
(3, 2, 10001, 'Hybrid Electric Vehicle Servicing', 'Hybrid', '', '<p>Certificate in Hybrid Electric Vehicle Servicing is a new course filled with technical illustrations and concise descriptions of the different configurations and vehicle platforms, the operation of various systems and the technologies involved, and the maintenance of hybrid electric vehicles.</p>', 1, 'topics', 1, 5, 1698811200, 1730347200, 0, 0, 0, 0, 0, 1, 1, NULL, 0, 0, 0, '', '', '', 1698729820, 1698729820, 0, 1, 0, 1699168705, NULL, 1, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_categories`
--

CREATE TABLE `mdlxd_course_categories` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `descriptionformat` tinyint NOT NULL DEFAULT '0',
  `parent` bigint NOT NULL DEFAULT '0',
  `sortorder` bigint NOT NULL DEFAULT '0',
  `coursecount` bigint NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `depth` bigint NOT NULL DEFAULT '0',
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `theme` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_courcate_par_ix` (`parent`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Course categories';

--
-- Dumping data for table `mdlxd_course_categories`
--

INSERT INTO `mdlxd_course_categories` VALUES
(2, 'Mechanical Engineering', '', '', 1, 0, 10000, 1, 1, 1, 1698729428, 1, '/2', NULL),
(3, 'Marketing', '', '', 1, 0, 20000, 1, 1, 1, 1698729501, 1, '/3', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_completions`
--

CREATE TABLE `mdlxd_course_completions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `course` bigint NOT NULL DEFAULT '0',
  `timeenrolled` bigint NOT NULL DEFAULT '0',
  `timestarted` bigint NOT NULL DEFAULT '0',
  `timecompleted` bigint DEFAULT NULL,
  `reaggregate` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_courcomp_usecou_uix` (`userid`,`course`),
  KEY `mdlxd_courcomp_use_ix` (`userid`),
  KEY `mdlxd_courcomp_cou_ix` (`course`),
  KEY `mdlxd_courcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion records';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_completion_aggr_methd`
--

CREATE TABLE `mdlxd_course_completion_aggr_methd` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `criteriatype` bigint DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '0',
  `value` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_courcompaggrmeth_cou_uix` (`course`,`criteriatype`),
  KEY `mdlxd_courcompaggrmeth_cou_ix` (`course`),
  KEY `mdlxd_courcompaggrmeth_cri_ix` (`criteriatype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion aggregation methods for criteria';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_completion_criteria`
--

CREATE TABLE `mdlxd_course_completion_criteria` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `criteriatype` bigint NOT NULL DEFAULT '0',
  `module` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `moduleinstance` bigint DEFAULT NULL,
  `courseinstance` bigint DEFAULT NULL,
  `enrolperiod` bigint DEFAULT NULL,
  `timeend` bigint DEFAULT NULL,
  `gradepass` decimal(10,5) DEFAULT NULL,
  `role` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_courcompcrit_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion criteria';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_completion_crit_compl`
--

CREATE TABLE `mdlxd_course_completion_crit_compl` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `course` bigint NOT NULL DEFAULT '0',
  `criteriaid` bigint NOT NULL DEFAULT '0',
  `gradefinal` decimal(10,5) DEFAULT NULL,
  `unenroled` bigint DEFAULT NULL,
  `timecompleted` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_courcompcritcomp_use_uix` (`userid`,`course`,`criteriaid`),
  KEY `mdlxd_courcompcritcomp_use_ix` (`userid`),
  KEY `mdlxd_courcompcritcomp_cou_ix` (`course`),
  KEY `mdlxd_courcompcritcomp_cri_ix` (`criteriaid`),
  KEY `mdlxd_courcompcritcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion user records';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_completion_defaults`
--

CREATE TABLE `mdlxd_course_completion_defaults` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL,
  `module` bigint NOT NULL,
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionusegrade` tinyint(1) NOT NULL DEFAULT '0',
  `completionpassgrade` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint NOT NULL DEFAULT '0',
  `customrules` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_courcompdefa_coumod_uix` (`course`,`module`),
  KEY `mdlxd_courcompdefa_mod_ix` (`module`),
  KEY `mdlxd_courcompdefa_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Default settings for activities completion';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_format_options`
--

CREATE TABLE `mdlxd_course_format_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseid` bigint NOT NULL,
  `format` varchar(21) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `sectionid` bigint NOT NULL DEFAULT '0',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_courformopti_coufors_uix` (`courseid`,`format`,`sectionid`,`name`),
  KEY `mdlxd_courformopti_cou_ix` (`courseid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stores format-specific options for the course or course sect';

--
-- Dumping data for table `mdlxd_course_format_options`
--

INSERT INTO `mdlxd_course_format_options` VALUES
(1, 1, 'site', 0, 'numsections', '1'),
(3, 3, 'topics', 0, 'hiddensections', '1'),
(4, 3, 'topics', 0, 'coursedisplay', '0'),
(6, 2, 'topics', 0, 'hiddensections', '1'),
(7, 2, 'topics', 0, 'coursedisplay', '0');

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_modules`
--

CREATE TABLE `mdlxd_course_modules` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `module` bigint NOT NULL DEFAULT '0',
  `instance` bigint NOT NULL DEFAULT '0',
  `section` bigint NOT NULL DEFAULT '0',
  `idnumber` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `added` bigint NOT NULL DEFAULT '0',
  `score` smallint NOT NULL DEFAULT '0',
  `indent` mediumint NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleoncoursepage` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `groupmode` smallint NOT NULL DEFAULT '0',
  `groupingid` bigint NOT NULL DEFAULT '0',
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completiongradeitemnumber` bigint DEFAULT NULL,
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint NOT NULL DEFAULT '0',
  `completionpassgrade` tinyint(1) NOT NULL DEFAULT '0',
  `showdescription` tinyint(1) NOT NULL DEFAULT '0',
  `availability` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `deletioninprogress` tinyint(1) NOT NULL DEFAULT '0',
  `downloadcontent` tinyint(1) DEFAULT '1',
  `lang` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_courmodu_vis_ix` (`visible`),
  KEY `mdlxd_courmodu_cou_ix` (`course`),
  KEY `mdlxd_courmodu_mod_ix` (`module`),
  KEY `mdlxd_courmodu_ins_ix` (`instance`),
  KEY `mdlxd_courmodu_idncou_ix` (`idnumber`,`course`),
  KEY `mdlxd_courmodu_gro_ix` (`groupingid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='course_modules table retrofitted from MySQL';

--
-- Dumping data for table `mdlxd_course_modules`
--

INSERT INTO `mdlxd_course_modules` VALUES
(3, 2, 18, 1, 1, '', 1698730323, 0, 0, 1, 1, 1, 0, 0, 0, NULL, 0, 0, 0, 0, NULL, 0, 1, ''),
(4, 3, 18, 2, 2, '', 1698730496, 0, 0, 1, 1, 1, 0, 0, 0, NULL, 0, 0, 0, 0, NULL, 0, 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_modules_completion`
--

CREATE TABLE `mdlxd_course_modules_completion` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `coursemoduleid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `completionstate` tinyint(1) NOT NULL,
  `overrideby` bigint DEFAULT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_courmoducomp_usecou_uix` (`userid`,`coursemoduleid`),
  KEY `mdlxd_courmoducomp_cou_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the completion state (completed or not completed, etc';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_modules_viewed`
--

CREATE TABLE `mdlxd_course_modules_viewed` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `coursemoduleid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_courmoduview_usecou_uix` (`userid`,`coursemoduleid`),
  KEY `mdlxd_courmoduview_cou_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Tracks the completion viewed (viewed with cmid/userid and ot';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_published`
--

CREATE TABLE `mdlxd_course_published` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `huburl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `courseid` bigint NOT NULL,
  `timepublished` bigint NOT NULL,
  `enrollable` tinyint(1) NOT NULL DEFAULT '1',
  `hubcourseid` bigint NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  `timechecked` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_courpubl_hub_ix` (`hubcourseid`),
  KEY `mdlxd_courpubl_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Information about how and when an local courses were publish';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_request`
--

CREATE TABLE `mdlxd_course_request` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `fullname` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `shortname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `summary` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `summaryformat` tinyint NOT NULL DEFAULT '0',
  `category` bigint NOT NULL DEFAULT '0',
  `reason` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `requester` bigint NOT NULL DEFAULT '0',
  `password` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdlxd_courrequ_sho_ix` (`shortname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='course requests';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_course_sections`
--

CREATE TABLE `mdlxd_course_sections` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `section` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `summary` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `summaryformat` tinyint NOT NULL DEFAULT '0',
  `sequence` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `availability` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_coursect_cousec_uix` (`course`,`section`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='to define the sections for each course';

--
-- Dumping data for table `mdlxd_course_sections`
--

INSERT INTO `mdlxd_course_sections` VALUES
(1, 2, 0, NULL, '', 1, '3', 1, NULL, 1698729643),
(2, 3, 0, NULL, '', 1, '4', 1, NULL, 1698729820),
(3, 3, 1, NULL, '', 1, '', 1, NULL, 1698729820),
(4, 3, 2, NULL, '', 1, '', 1, NULL, 1698729820),
(5, 3, 3, NULL, '', 1, '', 1, NULL, 1698729820),
(6, 3, 4, NULL, '', 1, '', 1, NULL, 1698729820);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_customfield_category`
--

CREATE TABLE `mdlxd_customfield_category` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `descriptionformat` bigint DEFAULT NULL,
  `sortorder` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `area` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL DEFAULT '0',
  `contextid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_custcate_comareitesor_ix` (`component`,`area`,`itemid`,`sortorder`),
  KEY `mdlxd_custcate_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='core_customfield category table';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_customfield_data`
--

CREATE TABLE `mdlxd_customfield_data` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `fieldid` bigint NOT NULL,
  `instanceid` bigint NOT NULL,
  `intvalue` bigint DEFAULT NULL,
  `decvalue` decimal(10,5) DEFAULT NULL,
  `shortcharvalue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `charvalue` varchar(1333) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `valueformat` bigint NOT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `contextid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_custdata_insfie_uix` (`instanceid`,`fieldid`),
  KEY `mdlxd_custdata_fieint_ix` (`fieldid`,`intvalue`),
  KEY `mdlxd_custdata_fiesho_ix` (`fieldid`,`shortcharvalue`),
  KEY `mdlxd_custdata_fiedec_ix` (`fieldid`,`decvalue`),
  KEY `mdlxd_custdata_fie_ix` (`fieldid`),
  KEY `mdlxd_custdata_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='core_customfield data table';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_customfield_field`
--

CREATE TABLE `mdlxd_customfield_field` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `name` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `descriptionformat` bigint DEFAULT NULL,
  `sortorder` bigint DEFAULT NULL,
  `categoryid` bigint DEFAULT NULL,
  `configdata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_custfiel_catsor_ix` (`categoryid`,`sortorder`),
  KEY `mdlxd_custfiel_cat_ix` (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='core_customfield field table';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_data`
--

CREATE TABLE `mdlxd_data` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `comments` smallint NOT NULL DEFAULT '0',
  `timeavailablefrom` bigint NOT NULL DEFAULT '0',
  `timeavailableto` bigint NOT NULL DEFAULT '0',
  `timeviewfrom` bigint NOT NULL DEFAULT '0',
  `timeviewto` bigint NOT NULL DEFAULT '0',
  `requiredentries` int NOT NULL DEFAULT '0',
  `requiredentriestoview` int NOT NULL DEFAULT '0',
  `maxentries` int NOT NULL DEFAULT '0',
  `rssarticles` smallint NOT NULL DEFAULT '0',
  `singletemplate` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `listtemplate` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `listtemplateheader` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `listtemplatefooter` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `addtemplate` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `rsstemplate` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `rsstitletemplate` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `csstemplate` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `jstemplate` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `asearchtemplate` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `approval` smallint NOT NULL DEFAULT '0',
  `manageapproved` smallint NOT NULL DEFAULT '1',
  `scale` bigint NOT NULL DEFAULT '0',
  `assessed` bigint NOT NULL DEFAULT '0',
  `assesstimestart` bigint NOT NULL DEFAULT '0',
  `assesstimefinish` bigint NOT NULL DEFAULT '0',
  `defaultsort` bigint NOT NULL DEFAULT '0',
  `defaultsortdir` smallint NOT NULL DEFAULT '0',
  `editany` smallint NOT NULL DEFAULT '0',
  `notification` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `config` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `completionentries` bigint DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_data_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='all database activities';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_data_content`
--

CREATE TABLE `mdlxd_data_content` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `fieldid` bigint NOT NULL DEFAULT '0',
  `recordid` bigint NOT NULL DEFAULT '0',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `content1` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `content2` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `content3` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `content4` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `mdlxd_datacont_rec_ix` (`recordid`),
  KEY `mdlxd_datacont_fie_ix` (`fieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='the content introduced in each record/fields';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_data_fields`
--

CREATE TABLE `mdlxd_data_fields` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `dataid` bigint NOT NULL DEFAULT '0',
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `param1` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `param2` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `param3` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `param4` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `param5` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `param6` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `param7` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `param8` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `param9` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `param10` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `mdlxd_datafiel_typdat_ix` (`type`,`dataid`),
  KEY `mdlxd_datafiel_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='every field available';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_data_records`
--

CREATE TABLE `mdlxd_data_records` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `dataid` bigint NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `approved` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_datareco_dat_ix` (`dataid`),
  KEY `mdlxd_datareco_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='every record introduced';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_editor_atto_autosave`
--

CREATE TABLE `mdlxd_editor_atto_autosave` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `elementid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `contextid` bigint NOT NULL,
  `pagehash` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `userid` bigint NOT NULL,
  `drafttext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `draftid` bigint DEFAULT NULL,
  `pageinstance` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_editattoauto_eleconu_uix` (`elementid`,`contextid`,`userid`,`pagehash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Draft text that is auto-saved every 5 seconds while an edito';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol`
--

CREATE TABLE `mdlxd_enrol` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `enrol` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `status` bigint NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL,
  `sortorder` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `enrolperiod` bigint DEFAULT '0',
  `enrolstartdate` bigint DEFAULT '0',
  `enrolenddate` bigint DEFAULT '0',
  `expirynotify` tinyint(1) DEFAULT '0',
  `expirythreshold` bigint DEFAULT '0',
  `notifyall` tinyint(1) DEFAULT '0',
  `password` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `cost` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `roleid` bigint DEFAULT '0',
  `customint1` bigint DEFAULT NULL,
  `customint2` bigint DEFAULT NULL,
  `customint3` bigint DEFAULT NULL,
  `customint4` bigint DEFAULT NULL,
  `customint5` bigint DEFAULT NULL,
  `customint6` bigint DEFAULT NULL,
  `customint7` bigint DEFAULT NULL,
  `customint8` bigint DEFAULT NULL,
  `customchar1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `customchar2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `customchar3` varchar(1333) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `customdec1` decimal(12,7) DEFAULT NULL,
  `customdec2` decimal(12,7) DEFAULT NULL,
  `customtext1` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `customtext2` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `customtext3` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `customtext4` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `timecreated` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_enro_enr_ix` (`enrol`),
  KEY `mdlxd_enro_cou_ix` (`courseid`),
  KEY `mdlxd_enro_rol_ix` (`roleid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Instances of enrolment plugins used in courses, fields marke';

--
-- Dumping data for table `mdlxd_enrol`
--

INSERT INTO `mdlxd_enrol` VALUES
(1, 'manual', 0, 2, 0, NULL, 0, 0, 0, 0, 86400, 0, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1698729643, 1698729643),
(2, 'guest', 1, 2, 1, NULL, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1698729643, 1698729643),
(3, 'self', 1, 2, 2, NULL, 0, 0, 0, 0, 86400, 0, NULL, NULL, NULL, 5, 0, 0, 0, 1, 0, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1698729643, 1698729643),
(4, 'manual', 0, 3, 0, NULL, 0, 0, 0, 0, 86400, 0, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1698729820, 1698729820),
(5, 'guest', 1, 3, 1, NULL, 0, 0, 0, 0, 0, 0, '', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1698729820, 1698729820),
(6, 'self', 1, 3, 2, NULL, 0, 0, 0, 0, 86400, 0, NULL, NULL, NULL, 5, 0, 0, 0, 1, 0, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1698729820, 1698729820);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_flatfile`
--

CREATE TABLE `mdlxd_enrol_flatfile` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `roleid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `courseid` bigint NOT NULL,
  `timestart` bigint NOT NULL DEFAULT '0',
  `timeend` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_enroflat_cou_ix` (`courseid`),
  KEY `mdlxd_enroflat_use_ix` (`userid`),
  KEY `mdlxd_enroflat_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='enrol_flatfile table retrofitted from MySQL';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_app_registration`
--

CREATE TABLE `mdlxd_enrol_lti_app_registration` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `platformid` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `clientid` varchar(1333) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `uniqueid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `platformclienthash` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `platformuniqueidhash` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `authenticationrequesturl` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `jwksurl` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `accesstokenurl` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_enroltiappregi_uni_uix` (`uniqueid`),
  UNIQUE KEY `mdlxd_enroltiappregi_pla_uix` (`platformclienthash`),
  UNIQUE KEY `mdlxd_enroltiappregi_pla2_uix` (`platformuniqueidhash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Details of each application that has been registered with th';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_context`
--

CREATE TABLE `mdlxd_enrol_lti_context` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `ltideploymentid` bigint NOT NULL,
  `type` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_enrolticont_lticon_uix` (`ltideploymentid`,`contextid`),
  KEY `mdlxd_enrolticont_lti_ix` (`ltideploymentid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Each row represents a context in the platform, where resourc';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_deployment`
--

CREATE TABLE `mdlxd_enrol_lti_deployment` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `deploymentid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `platformid` bigint NOT NULL,
  `legacyconsumerkey` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_enroltidepl_pladep_uix` (`platformid`,`deploymentid`),
  KEY `mdlxd_enroltidepl_pla_ix` (`platformid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Each row represents a deployment of a tool within a platform';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_lti2_consumer`
--

CREATE TABLE `mdlxd_enrol_lti_lti2_consumer` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `consumerkey256` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `consumerkey` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `secret` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `ltiversion` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `consumername` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `consumerversion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `consumerguid` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `profile` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `toolproxy` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `protected` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `enablefrom` bigint DEFAULT NULL,
  `enableuntil` bigint DEFAULT NULL,
  `lastaccess` bigint DEFAULT NULL,
  `created` bigint NOT NULL,
  `updated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_enroltilti2cons_con_uix` (`consumerkey256`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='LTI consumers interacting with moodle';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_lti2_context`
--

CREATE TABLE `mdlxd_enrol_lti_lti2_context` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `consumerid` bigint NOT NULL,
  `lticontextkey` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created` bigint NOT NULL,
  `updated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_enroltilti2cont_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Information about a specific LTI contexts from the consumers';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_lti2_nonce`
--

CREATE TABLE `mdlxd_enrol_lti_lti2_nonce` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `consumerid` bigint NOT NULL,
  `value` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `expires` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_enroltilti2nonc_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Nonce used for authentication between moodle and a consumer';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_lti2_resource_link`
--

CREATE TABLE `mdlxd_enrol_lti_lti2_resource_link` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contextid` bigint DEFAULT NULL,
  `consumerid` bigint DEFAULT NULL,
  `ltiresourcelinkkey` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `primaryresourcelinkid` bigint DEFAULT NULL,
  `shareapproved` tinyint(1) DEFAULT NULL,
  `created` bigint NOT NULL,
  `updated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_enroltilti2resolink_c_ix` (`contextid`),
  KEY `mdlxd_enroltilti2resolink_p_ix` (`primaryresourcelinkid`),
  KEY `mdlxd_enroltilti2resolink_2_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Link from the consumer to the tool';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_lti2_share_key`
--

CREATE TABLE `mdlxd_enrol_lti_lti2_share_key` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `sharekey` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `resourcelinkid` bigint NOT NULL,
  `autoapprove` tinyint(1) NOT NULL,
  `expires` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_enroltilti2sharkey_s_uix` (`sharekey`),
  UNIQUE KEY `mdlxd_enroltilti2sharkey_r_uix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Resource link share key';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_lti2_tool_proxy`
--

CREATE TABLE `mdlxd_enrol_lti_lti2_tool_proxy` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `toolproxykey` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `consumerid` bigint NOT NULL,
  `toolproxy` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `created` bigint NOT NULL,
  `updated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_enroltilti2toolprox__uix` (`toolproxykey`),
  KEY `mdlxd_enroltilti2toolprox_c_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='A tool proxy between moodle and a consumer';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_lti2_user_result`
--

CREATE TABLE `mdlxd_enrol_lti_lti2_user_result` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `resourcelinkid` bigint NOT NULL,
  `ltiuserkey` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `ltiresultsourcedid` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `created` bigint NOT NULL,
  `updated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_enroltilti2userresu_r_ix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Results for each user for each resource link';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_resource_link`
--

CREATE TABLE `mdlxd_enrol_lti_resource_link` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `resourcelinkid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `ltideploymentid` bigint NOT NULL,
  `resourceid` bigint NOT NULL,
  `lticontextid` bigint DEFAULT NULL,
  `lineitemsservice` varchar(1333) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lineitemservice` varchar(1333) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `lineitemscope` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `resultscope` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `scorescope` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contextmembershipsurl` varchar(1333) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `nrpsserviceversions` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_enroltiresolink_resl_uix` (`resourcelinkid`,`ltideploymentid`),
  KEY `mdlxd_enroltiresolink_lti_ix` (`ltideploymentid`),
  KEY `mdlxd_enroltiresolink_lti2_ix` (`lticontextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Each row represents a resource link for a platform and deplo';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_tools`
--

CREATE TABLE `mdlxd_enrol_lti_tools` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `enrolid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `ltiversion` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'LTI-1p3',
  `institution` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `lang` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'en',
  `timezone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '99',
  `maxenrolled` bigint NOT NULL DEFAULT '0',
  `maildisplay` tinyint NOT NULL DEFAULT '2',
  `city` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `gradesync` tinyint(1) NOT NULL DEFAULT '0',
  `gradesynccompletion` tinyint(1) NOT NULL DEFAULT '0',
  `membersync` tinyint(1) NOT NULL DEFAULT '0',
  `membersyncmode` tinyint(1) NOT NULL DEFAULT '0',
  `roleinstructor` bigint NOT NULL,
  `rolelearner` bigint NOT NULL,
  `secret` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `uuid` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `provisioningmodelearner` tinyint DEFAULT NULL,
  `provisioningmodeinstructor` tinyint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_enroltitool_uui_uix` (`uuid`),
  KEY `mdlxd_enroltitool_enr_ix` (`enrolid`),
  KEY `mdlxd_enroltitool_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='List of tools provided to the remote system';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_tool_consumer_map`
--

CREATE TABLE `mdlxd_enrol_lti_tool_consumer_map` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `toolid` bigint NOT NULL,
  `consumerid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_enroltitoolconsmap_to_ix` (`toolid`),
  KEY `mdlxd_enroltitoolconsmap_co_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Table that maps the published tool to tool consumers.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_users`
--

CREATE TABLE `mdlxd_enrol_lti_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` bigint NOT NULL,
  `toolid` bigint NOT NULL,
  `serviceurl` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `sourceid` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `ltideploymentid` bigint DEFAULT NULL,
  `consumerkey` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `consumersecret` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `membershipsurl` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `membershipsid` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `lastgrade` decimal(10,5) DEFAULT NULL,
  `lastaccess` bigint DEFAULT NULL,
  `timecreated` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_enroltiuser_use_ix` (`userid`),
  KEY `mdlxd_enroltiuser_too_ix` (`toolid`),
  KEY `mdlxd_enroltiuser_lti_ix` (`ltideploymentid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='User access log and gradeback data';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_lti_user_resource_link`
--

CREATE TABLE `mdlxd_enrol_lti_user_resource_link` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `ltiuserid` bigint NOT NULL,
  `resourcelinkid` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_enroltiuserresolink__uix` (`ltiuserid`,`resourcelinkid`),
  KEY `mdlxd_enroltiuserresolink_l_ix` (`ltiuserid`),
  KEY `mdlxd_enroltiuserresolink_r_ix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Join table mapping users to resource links as this is a many';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_enrol_paypal`
--

CREATE TABLE `mdlxd_enrol_paypal` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `business` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `receiver_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `receiver_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `item_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `courseid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `instanceid` bigint NOT NULL DEFAULT '0',
  `memo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `tax` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `option_name1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `option_selection1_x` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `option_name2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `option_selection2_x` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `payment_status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `pending_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `reason_code` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `txn_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `parent_txn_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `payment_type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `timeupdated` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_enropayp_bus_ix` (`business`),
  KEY `mdlxd_enropayp_rec_ix` (`receiver_email`),
  KEY `mdlxd_enropayp_cou_ix` (`courseid`),
  KEY `mdlxd_enropayp_use_ix` (`userid`),
  KEY `mdlxd_enropayp_ins_ix` (`instanceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Holds all known information about PayPal transactions';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_event`
--

CREATE TABLE `mdlxd_event` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `format` smallint NOT NULL DEFAULT '0',
  `categoryid` bigint NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `repeatid` bigint NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `modulename` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `instance` bigint NOT NULL DEFAULT '0',
  `type` smallint NOT NULL DEFAULT '0',
  `eventtype` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `timestart` bigint NOT NULL DEFAULT '0',
  `timeduration` bigint NOT NULL DEFAULT '0',
  `timesort` bigint DEFAULT NULL,
  `visible` smallint NOT NULL DEFAULT '1',
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `sequence` bigint NOT NULL DEFAULT '1',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `subscriptionid` bigint DEFAULT NULL,
  `priority` bigint DEFAULT NULL,
  `location` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `mdlxd_even_cou_ix` (`courseid`),
  KEY `mdlxd_even_use_ix` (`userid`),
  KEY `mdlxd_even_tim_ix` (`timestart`),
  KEY `mdlxd_even_tim2_ix` (`timeduration`),
  KEY `mdlxd_even_uui_ix` (`uuid`),
  KEY `mdlxd_even_typtim_ix` (`type`,`timesort`),
  KEY `mdlxd_even_grocoucatvisuse_ix` (`groupid`,`courseid`,`categoryid`,`visible`,`userid`),
  KEY `mdlxd_even_eve_ix` (`eventtype`),
  KEY `mdlxd_even_comeveins_ix` (`component`,`eventtype`,`instance`),
  KEY `mdlxd_even_modinseve_ix` (`modulename`,`instance`,`eventtype`),
  KEY `mdlxd_even_cat_ix` (`categoryid`),
  KEY `mdlxd_even_sub_ix` (`subscriptionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='For everything with a time associated to it';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_events_handlers`
--

CREATE TABLE `mdlxd_events_handlers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `eventname` varchar(166) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `component` varchar(166) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `handlerfile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `handlerfunction` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `schedule` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` bigint NOT NULL DEFAULT '0',
  `internal` tinyint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_evenhand_evecom_uix` (`eventname`,`component`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='This table is for storing which components requests what typ';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_events_queue`
--

CREATE TABLE `mdlxd_events_queue` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `eventdata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `stackdump` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `userid` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_evenqueu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='This table is for storing queued events. It stores only one ';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_events_queue_handlers`
--

CREATE TABLE `mdlxd_events_queue_handlers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `queuedeventid` bigint NOT NULL,
  `handlerid` bigint NOT NULL,
  `status` bigint DEFAULT NULL,
  `errormessage` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_evenqueuhand_que_ix` (`queuedeventid`),
  KEY `mdlxd_evenqueuhand_han_ix` (`handlerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='This is the list of queued handlers for processing. The even';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_event_subscriptions`
--

CREATE TABLE `mdlxd_event_subscriptions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `categoryid` bigint NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL DEFAULT '0',
  `groupid` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `eventtype` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `pollinterval` bigint NOT NULL DEFAULT '0',
  `lastupdated` bigint DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdlxd_evensubs_cou_ix` (`courseid`),
  KEY `mdlxd_evensubs_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Tracks subscriptions to remote calendars.';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_external_functions`
--

CREATE TABLE `mdlxd_external_functions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `classname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `methodname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `classpath` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `capabilities` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `services` varchar(1333) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_extefunc_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='list of all external functions';

--
-- Dumping data for table `mdlxd_external_functions`
--

INSERT INTO `mdlxd_external_functions` VALUES
(1, 'core_auth_confirm_user', 'core_auth_external', 'confirm_user', NULL, 'moodle', '', NULL),
(2, 'core_auth_request_password_reset', 'core_auth_external', 'request_password_reset', NULL, 'moodle', '', NULL),
(3, 'core_auth_is_minor', 'core_auth_external', 'is_minor', NULL, 'moodle', '', NULL),
(4, 'core_auth_is_age_digital_consent_verification_enabled', 'core_auth_external', 'is_age_digital_consent_verification_enabled', NULL, 'moodle', '', NULL),
(5, 'core_auth_resend_confirmation_email', 'core_auth_external', 'resend_confirmation_email', NULL, 'moodle', '', NULL),
(6, 'core_backup_get_async_backup_progress', 'core_backup_external', 'get_async_backup_progress', 'backup/externallib.php', 'moodle', '', NULL),
(7, 'core_backup_get_async_backup_links_backup', 'core_backup_external', 'get_async_backup_links_backup', 'backup/externallib.php', 'moodle', '', NULL),
(8, 'core_backup_get_async_backup_links_restore', 'core_backup_external', 'get_async_backup_links_restore', 'backup/externallib.php', 'moodle', '', NULL),
(9, 'core_backup_get_copy_progress', 'core_backup_external', 'get_copy_progress', 'backup/externallib.php', 'moodle', '', NULL),
(10, 'core_backup_submit_copy_form', 'core_backup_external', 'submit_copy_form', 'backup/externallib.php', 'moodle', '', NULL),
(11, 'core_badges_get_user_badges', 'core_badges_external', 'get_user_badges', NULL, 'moodle', 'moodle/badges:viewotherbadges', 'moodle_mobile_app'),
(12, 'core_badges_get_user_badge_by_hash', 'core_badges\\external\\get_user_badge_by_hash', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(13, 'core_blog_get_entries', 'core_blog\\external', 'get_entries', NULL, 'moodle', '', 'moodle_mobile_app'),
(14, 'core_blog_view_entries', 'core_blog\\external', 'view_entries', NULL, 'moodle', '', 'moodle_mobile_app'),
(15, 'core_calendar_get_calendar_monthly_view', 'core_calendar_external', 'get_calendar_monthly_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(16, 'core_calendar_get_calendar_day_view', 'core_calendar_external', 'get_calendar_day_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(17, 'core_calendar_get_calendar_upcoming_view', 'core_calendar_external', 'get_calendar_upcoming_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(18, 'core_calendar_update_event_start_day', 'core_calendar_external', 'update_event_start_day', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(19, 'core_calendar_create_calendar_events', 'core_calendar_external', 'create_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(20, 'core_calendar_delete_calendar_events', 'core_calendar_external', 'delete_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(21, 'core_calendar_get_calendar_events', 'core_calendar_external', 'get_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(22, 'core_calendar_get_action_events_by_timesort', 'core_calendar_external', 'get_calendar_action_events_by_timesort', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(23, 'core_calendar_get_action_events_by_course', 'core_calendar_external', 'get_calendar_action_events_by_course', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(24, 'core_calendar_get_action_events_by_courses', 'core_calendar_external', 'get_calendar_action_events_by_courses', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(25, 'core_calendar_get_calendar_event_by_id', 'core_calendar_external', 'get_calendar_event_by_id', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(26, 'core_calendar_submit_create_update_form', 'core_calendar_external', 'submit_create_update_form', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(27, 'core_calendar_get_calendar_access_information', 'core_calendar_external', 'get_calendar_access_information', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(28, 'core_calendar_get_allowed_event_types', 'core_calendar_external', 'get_allowed_event_types', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(29, 'core_calendar_get_timestamps', 'core_calendar_external', 'get_timestamps', 'calendar/externallib.php', 'moodle', '', NULL),
(30, 'core_calendar_get_calendar_export_token', 'core_calendar\\external\\export\\token', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(31, 'core_calendar_delete_subscription', 'core_calendar\\external\\subscription\\delete', 'execute', NULL, 'moodle', '', NULL),
(32, 'core_cohort_add_cohort_members', 'core_cohort_external', 'add_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:assign', NULL),
(33, 'core_cohort_create_cohorts', 'core_cohort_external', 'create_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(34, 'core_cohort_delete_cohort_members', 'core_cohort_external', 'delete_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:assign', NULL),
(35, 'core_cohort_delete_cohorts', 'core_cohort_external', 'delete_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(36, 'core_cohort_get_cohort_members', 'core_cohort_external', 'get_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(37, 'core_cohort_search_cohorts', 'core_cohort_external', 'search_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(38, 'core_cohort_get_cohorts', 'core_cohort_external', 'get_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(39, 'core_cohort_update_cohorts', 'core_cohort_external', 'update_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(40, 'core_comment_get_comments', 'core_comment_external', 'get_comments', NULL, 'moodle', 'moodle/comment:view', 'moodle_mobile_app'),
(41, 'core_comment_add_comments', 'core_comment_external', 'add_comments', NULL, 'moodle', '', 'moodle_mobile_app'),
(42, 'core_comment_delete_comments', 'core_comment_external', 'delete_comments', NULL, 'moodle', '', 'moodle_mobile_app'),
(43, 'core_completion_get_activities_completion_status', 'core_completion_external', 'get_activities_completion_status', NULL, 'moodle', '', 'moodle_mobile_app'),
(44, 'core_completion_get_course_completion_status', 'core_completion_external', 'get_course_completion_status', NULL, 'moodle', 'report/completion:view', 'moodle_mobile_app'),
(45, 'core_completion_mark_course_self_completed', 'core_completion_external', 'mark_course_self_completed', NULL, 'moodle', '', 'moodle_mobile_app'),
(46, 'core_completion_update_activity_completion_status_manually', 'core_completion_external', 'update_activity_completion_status_manually', NULL, 'moodle', '', 'moodle_mobile_app'),
(47, 'core_completion_override_activity_completion_status', 'core_completion_external', 'override_activity_completion_status', NULL, 'moodle', 'moodle/course:overridecompletion', NULL),
(48, 'core_course_create_categories', 'core_course_external', 'create_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(49, 'core_course_create_courses', 'core_course_external', 'create_courses', 'course/externallib.php', 'moodle', 'moodle/course:create, moodle/course:visibility', NULL),
(50, 'core_course_delete_categories', 'core_course_external', 'delete_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(51, 'core_course_delete_courses', 'core_course_external', 'delete_courses', 'course/externallib.php', 'moodle', 'moodle/course:delete', NULL),
(52, 'core_course_delete_modules', 'core_course_external', 'delete_modules', 'course/externallib.php', 'moodle', 'moodle/course:manageactivities', NULL),
(53, 'core_course_duplicate_course', 'core_course_external', 'duplicate_course', 'course/externallib.php', 'moodle', 'moodle/backup:backupcourse, moodle/restore:restorecourse, moodle/course:create', NULL),
(54, 'core_course_get_categories', 'core_course_external', 'get_categories', 'course/externallib.php', 'moodle', 'moodle/category:viewhiddencategories', 'moodle_mobile_app'),
(55, 'core_course_get_contents', 'core_course_external', 'get_course_contents', 'course/externallib.php', 'moodle', 'moodle/course:update, moodle/course:viewhiddencourses', 'moodle_mobile_app'),
(56, 'core_course_get_course_module', 'core_course_external', 'get_course_module', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(57, 'core_course_get_course_module_by_instance', 'core_course_external', 'get_course_module_by_instance', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(58, 'core_course_get_module', 'core_course_external', 'get_module', 'course/externallib.php', 'moodle', '', NULL),
(59, 'core_courseformat_file_handlers', 'core_courseformat\\external\\file_handlers', 'execute', NULL, 'moodle', '', NULL),
(60, 'core_courseformat_get_state', 'core_courseformat\\external\\get_state', 'execute', NULL, 'moodle', '', NULL),
(61, 'core_courseformat_update_course', 'core_courseformat\\external\\update_course', 'execute', NULL, 'moodle', 'moodle/course:sectionvisibility, moodle/course:activityvisibility', NULL),
(62, 'core_course_edit_module', 'core_course_external', 'edit_module', 'course/externallib.php', 'moodle', '', NULL),
(63, 'core_course_edit_section', 'core_course_external', 'edit_section', 'course/externallib.php', 'moodle', '', NULL),
(64, 'core_course_get_courses', 'core_course_external', 'get_courses', 'course/externallib.php', 'moodle', 'moodle/course:view, moodle/course:update, moodle/course:viewhiddencourses', 'moodle_mobile_app'),
(65, 'core_course_import_course', 'core_course_external', 'import_course', 'course/externallib.php', 'moodle', 'moodle/backup:backuptargetimport, moodle/restore:restoretargetimport', NULL),
(66, 'core_course_search_courses', 'core_course_external', 'search_courses', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(67, 'core_course_update_categories', 'core_course_external', 'update_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(68, 'core_course_update_courses', 'core_course_external', 'update_courses', 'course/externallib.php', 'moodle', 'moodle/course:update, moodle/course:changecategory, moodle/course:changefullname, moodle/course:changeshortname, moodle/course:changeidnumber, moodle/course:changesummary, moodle/course:visibility', NULL),
(69, 'core_course_view_course', 'core_course_external', 'view_course', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(70, 'core_course_get_user_navigation_options', 'core_course_external', 'get_user_navigation_options', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(71, 'core_course_get_user_administration_options', 'core_course_external', 'get_user_administration_options', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(72, 'core_course_get_courses_by_field', 'core_course_external', 'get_courses_by_field', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(73, 'core_course_check_updates', 'core_course_external', 'check_updates', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(74, 'core_course_get_updates_since', 'core_course_external', 'get_updates_since', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(75, 'core_course_get_enrolled_courses_by_timeline_classification', 'core_course_external', 'get_enrolled_courses_by_timeline_classification', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(76, 'core_course_get_enrolled_courses_with_action_events_by_timeline_classification', '\\core_course\\external\\get_enrolled_courses_with_action_events_by_timeline_classification', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(77, 'core_course_get_recent_courses', 'core_course_external', 'get_recent_courses', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(78, 'core_course_set_favourite_courses', 'core_course_external', 'set_favourite_courses', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(79, 'core_course_get_enrolled_users_by_cmid', 'core_course_external', 'get_enrolled_users_by_cmid', 'course/externallib.php', 'moodle', '', NULL),
(80, 'core_course_add_content_item_to_user_favourites', 'core_course_external', 'add_content_item_to_user_favourites', 'course/externallib.php', 'moodle', '', NULL),
(81, 'core_course_remove_content_item_from_user_favourites', 'core_course_external', 'remove_content_item_from_user_favourites', 'course/externallib.php', 'moodle', '', NULL),
(82, 'core_course_get_course_content_items', 'core_course_external', 'get_course_content_items', 'course/externallib.php', 'moodle', '', NULL),
(83, 'core_course_get_activity_chooser_footer', 'core_course_external', 'get_activity_chooser_footer', 'course/externallib.php', 'moodle', '', NULL),
(84, 'core_course_toggle_activity_recommendation', 'core_course_external', 'toggle_activity_recommendation', 'course/externallib.php', 'moodle', '', NULL),
(85, 'core_enrol_get_course_enrolment_methods', 'core_enrol_external', 'get_course_enrolment_methods', 'enrol/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(86, 'core_enrol_get_enrolled_users', 'core_enrol_external', 'get_enrolled_users', 'enrol/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups', 'moodle_mobile_app'),
(87, 'core_enrol_get_enrolled_users_with_capability', 'core_enrol_external', 'get_enrolled_users_with_capability', 'enrol/externallib.php', 'moodle', '', NULL),
(88, 'core_enrol_get_potential_users', 'core_enrol_external', 'get_potential_users', 'enrol/externallib.php', 'moodle', 'moodle/course:enrolreview', NULL),
(89, 'core_enrol_search_users', 'core_enrol_external', 'search_users', 'enrol/externallib.php', 'moodle', 'moodle/course:viewparticipants', 'moodle_mobile_app'),
(90, 'core_enrol_get_users_courses', 'core_enrol_external', 'get_users_courses', 'enrol/externallib.php', 'moodle', 'moodle/course:viewparticipants', 'moodle_mobile_app'),
(91, 'core_enrol_submit_user_enrolment_form', 'core_enrol_external', 'submit_user_enrolment_form', 'enrol/externallib.php', 'moodle', '', NULL),
(92, 'core_enrol_unenrol_user_enrolment', 'core_enrol_external', 'unenrol_user_enrolment', 'enrol/externallib.php', 'moodle', '', NULL),
(93, 'core_fetch_notifications', 'core_external', 'fetch_notifications', 'lib/external/externallib.php', 'moodle', '', NULL),
(94, 'core_session_touch', 'core\\session\\external', 'touch_session', NULL, 'moodle', '', NULL),
(95, 'core_session_time_remaining', 'core\\session\\external', 'time_remaining', NULL, 'moodle', '', NULL),
(96, 'core_files_get_files', 'core_files_external', 'get_files', 'files/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(97, 'core_files_upload', 'core_files_external', 'upload', 'files/externallib.php', 'moodle', '', NULL),
(98, 'core_files_delete_draft_files', 'core_files\\external\\delete\\draft', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(99, 'core_files_get_unused_draft_itemid', 'core_files\\external\\get\\unused_draft', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(100, 'core_form_get_filetypes_browser_data', 'core_form\\external', 'get_filetypes_browser_data', NULL, 'moodle', '', NULL),
(101, 'core_form_dynamic_form', 'core_form\\external\\dynamic_form', 'execute', NULL, 'moodle', '', NULL),
(102, 'core_get_component_strings', 'core_external', 'get_component_strings', 'lib/external/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(103, 'core_get_fragment', 'core_external', 'get_fragment', 'lib/external/externallib.php', 'moodle', '', NULL),
(104, 'core_get_string', 'core_external', 'get_string', 'lib/external/externallib.php', 'moodle', '', NULL),
(105, 'core_get_strings', 'core_external', 'get_strings', 'lib/external/externallib.php', 'moodle', '', NULL),
(106, 'core_get_user_dates', 'core_external', 'get_user_dates', 'lib/external/externallib.php', 'moodle', '', NULL),
(107, 'core_grades_update_grades', 'core_grades_external', 'update_grades', NULL, 'moodle', '', NULL),
(108, 'core_grades_grader_gradingpanel_point_fetch', 'core_grades\\grades\\grader\\gradingpanel\\point\\external\\fetch', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(109, 'core_grades_grader_gradingpanel_point_store', 'core_grades\\grades\\grader\\gradingpanel\\point\\external\\store', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(110, 'core_grades_grader_gradingpanel_scale_fetch', 'core_grades\\grades\\grader\\gradingpanel\\scale\\external\\fetch', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(111, 'core_grades_grader_gradingpanel_scale_store', 'core_grades\\grades\\grader\\gradingpanel\\scale\\external\\store', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(112, 'core_grades_create_gradecategories', 'core_grades\\external\\create_gradecategories', 'execute', NULL, 'moodle', 'moodle/grade:manage', NULL),
(113, 'core_grades_get_enrolled_users_for_search_widget', 'core_grades\\external\\get_enrolled_users_for_search_widget', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(114, 'core_grades_get_enrolled_users_for_selector', 'core_grades\\external\\get_enrolled_users_for_selector', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(115, 'core_grades_get_groups_for_search_widget', 'core_group\\external\\get_groups_for_selector', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(116, 'core_grades_get_groups_for_selector', 'core_group\\external\\get_groups_for_selector', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(117, 'core_grades_get_feedback', 'core_grades\\external\\get_feedback', 'execute', NULL, 'moodle', '', NULL),
(118, 'core_grades_get_gradeitems', 'core_grades\\external\\get_gradeitems', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(119, 'core_grades_get_grade_tree', 'core_grades\\external\\get_grade_tree', 'execute', NULL, 'moodle', '', NULL),
(120, 'core_grading_get_definitions', 'core_grading_external', 'get_definitions', NULL, 'moodle', '', NULL),
(121, 'core_grading_get_gradingform_instances', 'core_grading_external', 'get_gradingform_instances', NULL, 'moodle', '', NULL),
(122, 'core_grading_save_definitions', 'core_grading_external', 'save_definitions', NULL, 'moodle', '', NULL),
(123, 'core_group_add_group_members', 'core_group_external', 'add_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(124, 'core_group_assign_grouping', 'core_group_external', 'assign_grouping', 'group/externallib.php', 'moodle', '', NULL),
(125, 'core_group_create_groupings', 'core_group_external', 'create_groupings', 'group/externallib.php', 'moodle', '', NULL),
(126, 'core_group_create_groups', 'core_group_external', 'create_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(127, 'core_group_delete_group_members', 'core_group_external', 'delete_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(128, 'core_group_delete_groupings', 'core_group_external', 'delete_groupings', 'group/externallib.php', 'moodle', '', NULL),
(129, 'core_group_delete_groups', 'core_group_external', 'delete_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(130, 'core_group_get_activity_allowed_groups', 'core_group_external', 'get_activity_allowed_groups', 'group/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(131, 'core_group_get_activity_groupmode', 'core_group_external', 'get_activity_groupmode', 'group/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(132, 'core_group_get_course_groupings', 'core_group_external', 'get_course_groupings', 'group/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(133, 'core_group_get_course_groups', 'core_group_external', 'get_course_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', 'moodle_mobile_app'),
(134, 'core_group_get_course_user_groups', 'core_group_external', 'get_course_user_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', 'moodle_mobile_app'),
(135, 'core_group_get_group_members', 'core_group_external', 'get_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(136, 'core_group_get_groupings', 'core_group_external', 'get_groupings', 'group/externallib.php', 'moodle', '', NULL),
(137, 'core_group_get_groups', 'core_group_external', 'get_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(138, 'core_group_get_groups_for_selector', 'core_group\\external\\get_groups_for_selector', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(139, 'core_group_unassign_grouping', 'core_group_external', 'unassign_grouping', 'group/externallib.php', 'moodle', '', NULL),
(140, 'core_group_update_groupings', 'core_group_external', 'update_groupings', 'group/externallib.php', 'moodle', '', NULL),
(141, 'core_group_update_groups', 'core_group_external', 'update_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(142, 'core_message_mute_conversations', 'core_message_external', 'mute_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(143, 'core_message_unmute_conversations', 'core_message_external', 'unmute_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(144, 'core_message_block_user', 'core_message_external', 'block_user', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(145, 'core_message_get_contact_requests', 'core_message_external', 'get_contact_requests', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(146, 'core_message_create_contact_request', 'core_message_external', 'create_contact_request', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(147, 'core_message_confirm_contact_request', 'core_message_external', 'confirm_contact_request', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(148, 'core_message_decline_contact_request', 'core_message_external', 'decline_contact_request', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(149, 'core_message_get_received_contact_requests_count', 'core_message_external', 'get_received_contact_requests_count', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(150, 'core_message_delete_contacts', 'core_message_external', 'delete_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(151, 'core_message_delete_conversations_by_id', 'core_message_external', 'delete_conversations_by_id', 'message/externallib.php', 'moodle', 'moodle/site:deleteownmessage', 'moodle_mobile_app'),
(152, 'core_message_delete_message', 'core_message_external', 'delete_message', 'message/externallib.php', 'moodle', 'moodle/site:deleteownmessage', 'moodle_mobile_app'),
(153, 'core_message_get_blocked_users', 'core_message_external', 'get_blocked_users', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(154, 'core_message_data_for_messagearea_search_messages', 'core_message_external', 'data_for_messagearea_search_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(155, 'core_message_message_search_users', 'core_message_external', 'message_search_users', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(156, 'core_message_get_user_contacts', 'core_message_external', 'get_user_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(157, 'core_message_get_conversations', 'core_message_external', 'get_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(158, 'core_message_get_conversation', 'core_message_external', 'get_conversation', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(159, 'core_message_get_conversation_between_users', 'core_message_external', 'get_conversation_between_users', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(160, 'core_message_get_self_conversation', 'core_message_external', 'get_self_conversation', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(161, 'core_message_get_messages', 'core_message_external', 'get_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(162, 'core_message_get_conversation_counts', 'core_message_external', 'get_conversation_counts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(163, 'core_message_get_unread_conversation_counts', 'core_message_external', 'get_unread_conversation_counts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(164, 'core_message_get_conversation_members', 'core_message_external', 'get_conversation_members', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(165, 'core_message_get_member_info', 'core_message_external', 'get_member_info', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(166, 'core_message_get_unread_conversations_count', 'core_message_external', 'get_unread_conversations_count', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(167, 'core_message_mark_all_notifications_as_read', 'core_message_external', 'mark_all_notifications_as_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(168, 'core_message_mark_all_conversation_messages_as_read', 'core_message_external', 'mark_all_conversation_messages_as_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(169, 'core_message_mark_message_read', 'core_message_external', 'mark_message_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(170, 'core_message_mark_notification_read', 'core_message_external', 'mark_notification_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(171, 'core_message_message_processor_config_form', 'core_message_external', 'message_processor_config_form', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(172, 'core_message_get_message_processor', 'core_message_external', 'get_message_processor', 'message/externallib.php', 'moodle', '', NULL),
(173, 'core_message_search_contacts', 'core_message_external', 'search_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(174, 'core_message_send_instant_messages', 'core_message_external', 'send_instant_messages', 'message/externallib.php', 'moodle', 'moodle/site:sendmessage', 'moodle_mobile_app'),
(175, 'core_message_send_messages_to_conversation', 'core_message_external', 'send_messages_to_conversation', 'message/externallib.php', 'moodle', 'moodle/site:sendmessage', 'moodle_mobile_app'),
(176, 'core_message_get_conversation_messages', 'core_message_external', 'get_conversation_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(177, 'core_message_unblock_user', 'core_message_external', 'unblock_user', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(178, 'core_message_get_user_notification_preferences', 'core_message_external', 'get_user_notification_preferences', 'message/externallib.php', 'moodle', 'moodle/user:editownmessageprofile', 'moodle_mobile_app'),
(179, 'core_message_get_user_message_preferences', 'core_message_external', 'get_user_message_preferences', 'message/externallib.php', 'moodle', 'moodle/user:editownmessageprofile', 'moodle_mobile_app'),
(180, 'core_message_set_favourite_conversations', 'core_message_external', 'set_favourite_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(181, 'core_message_unset_favourite_conversations', 'core_message_external', 'unset_favourite_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(182, 'core_message_delete_message_for_all_users', 'core_message_external', 'delete_message_for_all_users', 'message/externallib.php', 'moodle', 'moodle/site:deleteanymessage', 'moodle_mobile_app'),
(183, 'core_message_get_unread_notification_count', '\\core_message\\external\\get_unread_notification_count', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(184, 'core_my_view_page', '\\core_my\\external\\view_page', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(185, 'core_notes_create_notes', 'core_notes_external', 'create_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', 'moodle_mobile_app'),
(186, 'core_notes_delete_notes', 'core_notes_external', 'delete_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', 'moodle_mobile_app'),
(187, 'core_notes_get_course_notes', 'core_notes_external', 'get_course_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', 'moodle_mobile_app'),
(188, 'core_notes_get_notes', 'core_notes_external', 'get_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', NULL),
(189, 'core_notes_update_notes', 'core_notes_external', 'update_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', NULL),
(190, 'core_notes_view_notes', 'core_notes_external', 'view_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', 'moodle_mobile_app'),
(191, 'core_output_load_template', 'core\\output\\external', 'load_template', NULL, 'moodle', '', NULL),
(192, 'core_output_load_template_with_dependencies', 'core\\output\\external', 'load_template_with_dependencies', NULL, 'moodle', '', NULL),
(193, 'core_output_load_fontawesome_icon_map', 'core\\output\\external', 'load_fontawesome_icon_map', NULL, 'moodle', '', NULL),
(194, 'core_output_load_fontawesome_icon_system_map', 'core\\external\\output\\icon_system\\load_fontawesome_map', 'execute', NULL, 'moodle', '', NULL),
(195, 'core_question_update_flag', 'core_question_external', 'update_flag', NULL, 'moodle', 'moodle/question:flag', 'moodle_mobile_app'),
(196, 'core_question_submit_tags_form', 'core_question_external', 'submit_tags_form', NULL, 'moodle', '', NULL),
(197, 'core_question_get_random_question_summaries', 'core_question_external', 'get_random_question_summaries', NULL, 'moodle', '', NULL),
(198, 'core_rating_get_item_ratings', 'core_rating_external', 'get_item_ratings', NULL, 'moodle', 'moodle/rating:view', 'moodle_mobile_app'),
(199, 'core_rating_add_rating', 'core_rating_external', 'add_rating', NULL, 'moodle', 'moodle/rating:rate', 'moodle_mobile_app'),
(200, 'core_role_assign_roles', 'core_role_external', 'assign_roles', 'enrol/externallib.php', 'moodle', 'moodle/role:assign', NULL),
(201, 'core_role_unassign_roles', 'core_role_external', 'unassign_roles', 'enrol/externallib.php', 'moodle', 'moodle/role:assign', NULL),
(202, 'core_search_get_relevant_users', '\\core_search\\external', 'get_relevant_users', NULL, 'moodle', '', NULL),
(203, 'core_search_get_results', '\\core_search\\external\\get_results', 'execute', NULL, 'moodle', 'moodle/search:query', 'moodle_mobile_app'),
(204, 'core_search_get_search_areas_list', '\\core_search\\external\\get_search_areas_list', 'execute', NULL, 'moodle', 'moodle/search:query', 'moodle_mobile_app'),
(205, 'core_search_view_results', '\\core_search\\external\\view_results', 'execute', NULL, 'moodle', 'moodle/search:query', 'moodle_mobile_app'),
(206, 'core_search_get_top_results', '\\core_search\\external\\get_top_results', 'execute', NULL, 'moodle', 'moodle/search:query', 'moodle_mobile_app'),
(207, 'core_tag_get_tagindex', 'core_tag_external', 'get_tagindex', NULL, 'moodle', '', 'moodle_mobile_app'),
(208, 'core_tag_get_tags', 'core_tag_external', 'get_tags', NULL, 'moodle', '', NULL),
(209, 'core_tag_update_tags', 'core_tag_external', 'update_tags', NULL, 'moodle', '', NULL),
(210, 'core_tag_get_tagindex_per_area', 'core_tag_external', 'get_tagindex_per_area', NULL, 'moodle', '', 'moodle_mobile_app'),
(211, 'core_tag_get_tag_areas', 'core_tag_external', 'get_tag_areas', NULL, 'moodle', '', 'moodle_mobile_app'),
(212, 'core_tag_get_tag_collections', 'core_tag_external', 'get_tag_collections', NULL, 'moodle', '', 'moodle_mobile_app'),
(213, 'core_tag_get_tag_cloud', 'core_tag_external', 'get_tag_cloud', NULL, 'moodle', '', 'moodle_mobile_app'),
(214, 'core_update_inplace_editable', 'core_external', 'update_inplace_editable', 'lib/external/externallib.php', 'moodle', '', NULL),
(215, 'core_user_add_user_device', 'core_user_external', 'add_user_device', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(216, 'core_user_update_user_device_public_key', '\\core_user\\external\\update_user_device_public_key', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(217, 'core_user_add_user_private_files', 'core_user_external', 'add_user_private_files', 'user/externallib.php', 'moodle', 'moodle/user:manageownfiles', 'moodle_mobile_app'),
(218, 'core_user_create_users', 'core_user_external', 'create_users', 'user/externallib.php', 'moodle', 'moodle/user:create', NULL),
(219, 'core_user_delete_users', 'core_user_external', 'delete_users', 'user/externallib.php', 'moodle', 'moodle/user:delete', NULL),
(220, 'core_user_get_course_user_profiles', 'core_user_external', 'get_course_user_profiles', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups', 'moodle_mobile_app'),
(221, 'core_user_get_users', 'core_user_external', 'get_users', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update', NULL),
(222, 'core_user_get_users_by_field', 'core_user_external', 'get_users_by_field', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update', 'moodle_mobile_app'),
(223, 'core_user_search_identity', '\\core_user\\external\\search_identity', 'execute', NULL, 'moodle', 'moodle/user:viewalldetails', NULL),
(224, 'core_user_remove_user_device', 'core_user_external', 'remove_user_device', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(225, 'core_user_update_users', 'core_user_external', 'update_users', 'user/externallib.php', 'moodle', 'moodle/user:update', NULL),
(226, 'core_user_update_user_preferences', 'core_user_external', 'update_user_preferences', 'user/externallib.php', 'moodle', 'moodle/user:editownmessageprofile, moodle/user:editmessageprofile', 'moodle_mobile_app'),
(227, 'core_user_view_user_list', 'core_user_external', 'view_user_list', 'user/externallib.php', 'moodle', 'moodle/course:viewparticipants', 'moodle_mobile_app'),
(228, 'core_user_view_user_profile', 'core_user_external', 'view_user_profile', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails', 'moodle_mobile_app'),
(229, 'core_user_get_user_preferences', 'core_user_external', 'get_user_preferences', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(230, 'core_user_update_picture', 'core_user_external', 'update_picture', 'user/externallib.php', 'moodle', 'moodle/user:editownprofile, moodle/user:editprofile', 'moodle_mobile_app'),
(231, 'core_user_set_user_preferences', 'core_user_external', 'set_user_preferences', 'user/externallib.php', 'moodle', 'moodle/site:config', 'moodle_mobile_app'),
(232, 'core_user_agree_site_policy', 'core_user_external', 'agree_site_policy', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(233, 'core_user_get_private_files_info', 'core_user_external', 'get_private_files_info', 'user/externallib.php', 'moodle', 'moodle/user:manageownfiles', 'moodle_mobile_app'),
(234, 'core_competency_create_competency_framework', 'core_competency\\external', 'create_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(235, 'core_competency_read_competency_framework', 'core_competency\\external', 'read_competency_framework', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(236, 'core_competency_duplicate_competency_framework', 'core_competency\\external', 'duplicate_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(237, 'core_competency_delete_competency_framework', 'core_competency\\external', 'delete_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(238, 'core_competency_update_competency_framework', 'core_competency\\external', 'update_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(239, 'core_competency_list_competency_frameworks', 'core_competency\\external', 'list_competency_frameworks', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(240, 'core_competency_count_competency_frameworks', 'core_competency\\external', 'count_competency_frameworks', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(241, 'core_competency_competency_framework_viewed', 'core_competency\\external', 'competency_framework_viewed', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(242, 'core_competency_create_competency', 'core_competency\\external', 'create_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(243, 'core_competency_read_competency', 'core_competency\\external', 'read_competency', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(244, 'core_competency_competency_viewed', 'core_competency\\external', 'competency_viewed', NULL, 'moodle', 'moodle/competency:competencyview', 'moodle_mobile_app'),
(245, 'core_competency_delete_competency', 'core_competency\\external', 'delete_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(246, 'core_competency_update_competency', 'core_competency\\external', 'update_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(247, 'core_competency_list_competencies', 'core_competency\\external', 'list_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(248, 'core_competency_list_competencies_in_template', 'core_competency\\external', 'list_competencies_in_template', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(249, 'core_competency_count_competencies', 'core_competency\\external', 'count_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(250, 'core_competency_count_competencies_in_template', 'core_competency\\external', 'count_competencies_in_template', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(251, 'core_competency_search_competencies', 'core_competency\\external', 'search_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(252, 'core_competency_set_parent_competency', 'core_competency\\external', 'set_parent_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(253, 'core_competency_move_up_competency', 'core_competency\\external', 'move_up_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(254, 'core_competency_move_down_competency', 'core_competency\\external', 'move_down_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(255, 'core_competency_list_course_module_competencies', 'core_competency\\external', 'list_course_module_competencies', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(256, 'core_competency_count_course_module_competencies', 'core_competency\\external', 'count_course_module_competencies', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(257, 'core_competency_list_course_competencies', 'core_competency\\external', 'list_course_competencies', NULL, 'moodle', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(258, 'core_competency_count_competencies_in_course', 'core_competency\\external', 'count_competencies_in_course', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(259, 'core_competency_count_courses_using_competency', 'core_competency\\external', 'count_courses_using_competency', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(260, 'core_competency_add_competency_to_course', 'core_competency\\external', 'add_competency_to_course', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(261, 'core_competency_add_competency_to_template', 'core_competency\\external', 'add_competency_to_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(262, 'core_competency_remove_competency_from_course', 'core_competency\\external', 'remove_competency_from_course', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(263, 'core_competency_set_course_competency_ruleoutcome', 'core_competency\\external', 'set_course_competency_ruleoutcome', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(264, 'core_competency_remove_competency_from_template', 'core_competency\\external', 'remove_competency_from_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(265, 'core_competency_reorder_course_competency', 'core_competency\\external', 'reorder_course_competency', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(266, 'core_competency_reorder_template_competency', 'core_competency\\external', 'reorder_template_competency', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(267, 'core_competency_create_template', 'core_competency\\external', 'create_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(268, 'core_competency_duplicate_template', 'core_competency\\external', 'duplicate_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(269, 'core_competency_read_template', 'core_competency\\external', 'read_template', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(270, 'core_competency_delete_template', 'core_competency\\external', 'delete_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(271, 'core_competency_update_template', 'core_competency\\external', 'update_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(272, 'core_competency_list_templates', 'core_competency\\external', 'list_templates', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(273, 'core_competency_list_templates_using_competency', 'core_competency\\external', 'list_templates_using_competency', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(274, 'core_competency_count_templates', 'core_competency\\external', 'count_templates', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(275, 'core_competency_count_templates_using_competency', 'core_competency\\external', 'count_templates_using_competency', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(276, 'core_competency_create_plan', 'core_competency\\external', 'create_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(277, 'core_competency_update_plan', 'core_competency\\external', 'update_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(278, 'core_competency_complete_plan', 'core_competency\\external', 'complete_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(279, 'core_competency_reopen_plan', 'core_competency\\external', 'reopen_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(280, 'core_competency_read_plan', 'core_competency\\external', 'read_plan', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(281, 'core_competency_delete_plan', 'core_competency\\external', 'delete_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(282, 'core_competency_list_user_plans', 'core_competency\\external', 'list_user_plans', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(283, 'core_competency_list_plan_competencies', 'core_competency\\external', 'list_plan_competencies', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(284, 'core_competency_add_competency_to_plan', 'core_competency\\external', 'add_competency_to_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(285, 'core_competency_remove_competency_from_plan', 'core_competency\\external', 'remove_competency_from_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(286, 'core_competency_reorder_plan_competency', 'core_competency\\external', 'reorder_plan_competency', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(287, 'core_competency_plan_request_review', 'core_competency\\external', 'plan_request_review', NULL, 'moodle', 'moodle/competency:planmanagedraft', NULL),
(288, 'core_competency_plan_start_review', 'core_competency\\external', 'plan_start_review', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(289, 'core_competency_plan_stop_review', 'core_competency\\external', 'plan_stop_review', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(290, 'core_competency_plan_cancel_review_request', 'core_competency\\external', 'plan_cancel_review_request', NULL, 'moodle', 'moodle/competency:planmanagedraft', NULL),
(291, 'core_competency_approve_plan', 'core_competency\\external', 'approve_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(292, 'core_competency_unapprove_plan', 'core_competency\\external', 'unapprove_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(293, 'core_competency_template_has_related_data', 'core_competency\\external', 'template_has_related_data', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(294, 'core_competency_get_scale_values', 'core_competency\\external', 'get_scale_values', NULL, 'moodle', 'moodle/competency:competencymanage', 'moodle_mobile_app'),
(295, 'core_competency_add_related_competency', 'core_competency\\external', 'add_related_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(296, 'core_competency_remove_related_competency', 'core_competency\\external', 'remove_related_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(297, 'core_competency_read_user_evidence', 'core_competency\\external', 'read_user_evidence', NULL, 'moodle', 'moodle/competency:userevidenceview', NULL),
(298, 'core_competency_delete_user_evidence', 'core_competency\\external', 'delete_user_evidence', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(299, 'core_competency_create_user_evidence_competency', 'core_competency\\external', 'create_user_evidence_competency', NULL, 'moodle', 'moodle/competency:userevidencemanageown, moodle/competency:competencyview', NULL),
(300, 'core_competency_delete_user_evidence_competency', 'core_competency\\external', 'delete_user_evidence_competency', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(301, 'core_competency_user_competency_cancel_review_request', 'core_competency\\external', 'user_competency_cancel_review_request', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(302, 'core_competency_user_competency_request_review', 'core_competency\\external', 'user_competency_request_review', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(303, 'core_competency_user_competency_start_review', 'core_competency\\external', 'user_competency_start_review', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(304, 'core_competency_user_competency_stop_review', 'core_competency\\external', 'user_competency_stop_review', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(305, 'core_competency_user_competency_viewed', 'core_competency\\external', 'user_competency_viewed', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(306, 'core_competency_user_competency_viewed_in_plan', 'core_competency\\external', 'user_competency_viewed_in_plan', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(307, 'core_competency_user_competency_viewed_in_course', 'core_competency\\external', 'user_competency_viewed_in_course', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(308, 'core_competency_user_competency_plan_viewed', 'core_competency\\external', 'user_competency_plan_viewed', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(309, 'core_competency_grade_competency', 'core_competency\\external', 'grade_competency', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(310, 'core_competency_grade_competency_in_plan', 'core_competency\\external', 'grade_competency_in_plan', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(311, 'core_competency_grade_competency_in_course', 'core_competency\\external', 'grade_competency_in_course', NULL, 'moodle', 'moodle/competency:competencygrade', 'moodle_mobile_app'),
(312, 'core_competency_unlink_plan_from_template', 'core_competency\\external', 'unlink_plan_from_template', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(313, 'core_competency_template_viewed', 'core_competency\\external', 'template_viewed', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(314, 'core_competency_request_review_of_user_evidence_linked_competencies', 'core_competency\\external', 'request_review_of_user_evidence_linked_competencies', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(315, 'core_competency_update_course_competency_settings', 'core_competency\\external', 'update_course_competency_settings', NULL, 'moodle', 'moodle/competency:coursecompetencyconfigure', NULL),
(316, 'core_competency_delete_evidence', 'core_competency\\external', 'delete_evidence', NULL, 'moodle', 'moodle/competency:evidencedelete', 'moodle_mobile_app'),
(317, 'core_webservice_get_site_info', 'core_webservice_external', 'get_site_info', 'webservice/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(318, 'core_block_get_course_blocks', 'core_block_external', 'get_course_blocks', NULL, 'moodle', '', 'moodle_mobile_app'),
(319, 'core_block_get_dashboard_blocks', 'core_block_external', 'get_dashboard_blocks', NULL, 'moodle', '', 'moodle_mobile_app'),
(320, 'core_block_fetch_addable_blocks', 'core_block\\external\\fetch_addable_blocks', 'execute', NULL, 'moodle', 'moodle/site:manageblocks', 'moodle_mobile_app'),
(321, 'core_filters_get_available_in_context', 'core_filters\\external', 'get_available_in_context', NULL, 'moodle', '', 'moodle_mobile_app'),
(322, 'core_customfield_delete_field', 'core_customfield_external', 'delete_field', 'customfield/externallib.php', 'moodle', '', NULL),
(323, 'core_customfield_reload_template', 'core_customfield_external', 'reload_template', 'customfield/externallib.php', 'moodle', '', NULL),
(324, 'core_customfield_create_category', 'core_customfield_external', 'create_category', 'customfield/externallib.php', 'moodle', '', NULL),
(325, 'core_customfield_delete_category', 'core_customfield_external', 'delete_category', 'customfield/externallib.php', 'moodle', '', NULL),
(326, 'core_customfield_move_field', 'core_customfield_external', 'move_field', 'customfield/externallib.php', 'moodle', '', NULL),
(327, 'core_customfield_move_category', 'core_customfield_external', 'move_category', 'customfield/externallib.php', 'moodle', '', NULL),
(328, 'core_h5p_get_trusted_h5p_file', 'core_h5p\\external', 'get_trusted_h5p_file', NULL, 'moodle', '', 'moodle_mobile_app'),
(329, 'core_table_get_dynamic_table_content', 'core_table\\external\\dynamic\\get', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(330, 'core_xapi_statement_post', 'core_xapi\\external\\post_statement', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(331, 'core_xapi_post_state', 'core_xapi\\external\\post_state', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(332, 'core_xapi_get_state', 'core_xapi\\external\\get_state', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(333, 'core_xapi_get_states', 'core_xapi\\external\\get_states', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(334, 'core_xapi_delete_state', 'core_xapi\\external\\delete_state', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(335, 'core_xapi_delete_states', 'core_xapi\\external\\delete_states', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(336, 'core_contentbank_delete_content', 'core_contentbank\\external\\delete_content', 'execute', NULL, 'moodle', 'moodle/contentbank:deleteanycontent', NULL),
(337, 'core_contentbank_rename_content', 'core_contentbank\\external\\rename_content', 'execute', NULL, 'moodle', 'moodle/contentbank:manageowncontent', NULL),
(338, 'core_contentbank_copy_content', 'core_contentbank\\external\\copy_content', 'execute', NULL, 'moodle', 'moodle/contentbank:copycontent, moodle/contentbank:copyanycontent', NULL),
(339, 'core_contentbank_set_content_visibility', 'core_contentbank\\external\\set_content_visibility', 'execute', NULL, 'moodle', 'moodle/contentbank:manageowncontent', NULL),
(340, 'core_create_userfeedback_action_record', 'core\\external\\record_userfeedback_action', 'execute', NULL, 'moodle', '', NULL),
(341, 'core_payment_get_available_gateways', 'core_payment\\external\\get_available_gateways', 'execute', NULL, 'moodle', '', NULL),
(342, 'core_reportbuilder_filters_reset', 'core_reportbuilder\\external\\filters\\reset', 'execute', NULL, 'moodle', '', NULL),
(343, 'core_reportbuilder_set_filters', 'core_reportbuilder\\external\\filters\\set', 'execute', NULL, 'moodle', '', NULL),
(344, 'core_dynamic_tabs_get_content', 'core\\external\\dynamic_tabs_get_content', 'execute', NULL, 'moodle', '', NULL),
(345, 'core_change_editmode', 'core\\external\\editmode', 'change_editmode', NULL, 'moodle', '', NULL),
(346, 'core_reportbuilder_reports_delete', 'core_reportbuilder\\external\\reports\\delete', 'execute', NULL, 'moodle', '', NULL),
(347, 'core_reportbuilder_reports_get', 'core_reportbuilder\\external\\reports\\get', 'execute', NULL, 'moodle', '', NULL),
(348, 'core_reportbuilder_list_reports', 'core_reportbuilder\\external\\reports\\listing', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(349, 'core_reportbuilder_retrieve_report', 'core_reportbuilder\\external\\reports\\retrieve', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(350, 'core_reportbuilder_retrieve_system_report', 'core_reportbuilder\\external\\systemreports\\retrieve', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(351, 'core_reportbuilder_can_view_system_report', 'core_reportbuilder\\external\\systemreports\\can_view', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(352, 'core_reportbuilder_view_report', 'core_reportbuilder\\external\\reports\\view', 'execute', NULL, 'moodle', '', 'moodle_mobile_app'),
(353, 'core_reportbuilder_columns_add', 'core_reportbuilder\\external\\columns\\add', 'execute', NULL, 'moodle', '', NULL),
(354, 'core_reportbuilder_columns_delete', 'core_reportbuilder\\external\\columns\\delete', 'execute', NULL, 'moodle', '', NULL),
(355, 'core_reportbuilder_columns_reorder', 'core_reportbuilder\\external\\columns\\reorder', 'execute', NULL, 'moodle', '', NULL),
(356, 'core_reportbuilder_columns_sort_get', 'core_reportbuilder\\external\\columns\\sort\\get', 'execute', NULL, 'moodle', '', NULL),
(357, 'core_reportbuilder_columns_sort_reorder', 'core_reportbuilder\\external\\columns\\sort\\reorder', 'execute', NULL, 'moodle', '', NULL),
(358, 'core_reportbuilder_columns_sort_toggle', 'core_reportbuilder\\external\\columns\\sort\\toggle', 'execute', NULL, 'moodle', '', NULL),
(359, 'core_reportbuilder_conditions_add', 'core_reportbuilder\\external\\conditions\\add', 'execute', NULL, 'moodle', '', NULL),
(360, 'core_reportbuilder_conditions_delete', 'core_reportbuilder\\external\\conditions\\delete', 'execute', NULL, 'moodle', '', NULL),
(361, 'core_reportbuilder_conditions_reorder', 'core_reportbuilder\\external\\conditions\\reorder', 'execute', NULL, 'moodle', '', NULL),
(362, 'core_reportbuilder_conditions_reset', 'core_reportbuilder\\external\\conditions\\reset', 'execute', NULL, 'moodle', '', NULL),
(363, 'core_reportbuilder_filters_add', 'core_reportbuilder\\external\\filters\\add', 'execute', NULL, 'moodle', '', NULL),
(364, 'core_reportbuilder_filters_delete', 'core_reportbuilder\\external\\filters\\delete', 'execute', NULL, 'moodle', '', NULL),
(365, 'core_reportbuilder_filters_reorder', 'core_reportbuilder\\external\\filters\\reorder', 'execute', NULL, 'moodle', '', NULL),
(366, 'core_reportbuilder_audiences_delete', 'core_reportbuilder\\external\\audiences\\delete', 'execute', NULL, 'moodle', '', NULL),
(367, 'core_reportbuilder_schedules_delete', 'core_reportbuilder\\external\\schedules\\delete', 'execute', NULL, 'moodle', '', NULL),
(368, 'core_reportbuilder_schedules_send', 'core_reportbuilder\\external\\schedules\\send', 'execute', NULL, 'moodle', '', NULL),
(369, 'core_reportbuilder_schedules_toggle', 'core_reportbuilder\\external\\schedules\\toggle', 'execute', NULL, 'moodle', '', NULL),
(370, 'core_admin_set_plugin_state', 'core_admin\\external\\set_plugin_state', 'execute', NULL, 'moodle', '', NULL),
(371, 'core_admin_set_plugin_order', 'core_admin\\external\\set_plugin_order', 'execute', NULL, 'moodle', '', NULL),
(372, 'core_admin_set_block_protection', 'core_admin\\external\\set_block_protection', 'execute', NULL, 'moodle', '', NULL),
(373, 'core_moodlenet_send_activity', 'core\\external\\moodlenet_send_activity', 'execute', NULL, 'moodle', '', NULL),
(374, 'core_moodlenet_get_share_info_activity', 'core\\external\\moodlenet_get_share_info_activity', 'execute', NULL, 'moodle', '', NULL),
(375, 'core_moodlenet_auth_check', 'core\\external\\moodlenet_auth_check', 'execute', NULL, 'moodle', '', NULL),
(376, 'core_moodlenet_get_shared_course_info', 'core\\external\\moodlenet_get_shared_course_info', 'execute', NULL, 'moodle', '', NULL),
(377, 'core_moodlenet_send_course', 'core\\external\\moodlenet_send_course', 'execute', NULL, 'moodle', '', NULL),
(378, 'mod_assign_copy_previous_attempt', 'mod_assign_external', 'copy_previous_attempt', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:submit', NULL),
(379, 'mod_assign_get_grades', 'mod_assign_external', 'get_grades', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(380, 'mod_assign_get_assignments', 'mod_assign_external', 'get_assignments', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(381, 'mod_assign_get_submissions', 'mod_assign_external', 'get_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(382, 'mod_assign_get_user_flags', 'mod_assign_external', 'get_user_flags', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(383, 'mod_assign_set_user_flags', 'mod_assign_external', 'set_user_flags', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:grade', 'moodle_mobile_app'),
(384, 'mod_assign_get_user_mappings', 'mod_assign_external', 'get_user_mappings', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(385, 'mod_assign_revert_submissions_to_draft', 'mod_assign_external', 'revert_submissions_to_draft', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(386, 'mod_assign_lock_submissions', 'mod_assign_external', 'lock_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(387, 'mod_assign_unlock_submissions', 'mod_assign_external', 'unlock_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(388, 'mod_assign_save_submission', 'mod_assign_external', 'save_submission', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(389, 'mod_assign_submit_for_grading', 'mod_assign_external', 'submit_for_grading', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(390, 'mod_assign_save_grade', 'mod_assign_external', 'save_grade', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(391, 'mod_assign_save_grades', 'mod_assign_external', 'save_grades', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(392, 'mod_assign_save_user_extensions', 'mod_assign_external', 'save_user_extensions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(393, 'mod_assign_reveal_identities', 'mod_assign_external', 'reveal_identities', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(394, 'mod_assign_view_grading_table', 'mod_assign_external', 'view_grading_table', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(395, 'mod_assign_view_submission_status', 'mod_assign_external', 'view_submission_status', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(396, 'mod_assign_get_submission_status', 'mod_assign_external', 'get_submission_status', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(397, 'mod_assign_list_participants', 'mod_assign_external', 'list_participants', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(398, 'mod_assign_submit_grading_form', 'mod_assign_external', 'submit_grading_form', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:grade', 'moodle_mobile_app'),
(399, 'mod_assign_get_participant', 'mod_assign_external', 'get_participant', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(400, 'mod_assign_view_assign', 'mod_assign_external', 'view_assign', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(401, 'mod_assign_start_submission', 'mod_assign\\external\\start_submission', 'execute', NULL, 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(402, 'mod_bigbluebuttonbn_can_join', 'mod_bigbluebuttonbn\\external\\can_join', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(403, 'mod_bigbluebuttonbn_get_recordings', 'mod_bigbluebuttonbn\\external\\get_recordings', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(404, 'mod_bigbluebuttonbn_get_recordings_to_import', 'mod_bigbluebuttonbn\\external\\get_recordings_to_import', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:importrecordings', 'moodle_mobile_app'),
(405, 'mod_bigbluebuttonbn_update_recording', 'mod_bigbluebuttonbn\\external\\update_recording', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:managerecordings', 'moodle_mobile_app'),
(406, 'mod_bigbluebuttonbn_end_meeting', 'mod_bigbluebuttonbn\\external\\end_meeting', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:join', 'moodle_mobile_app'),
(407, 'mod_bigbluebuttonbn_completion_validate', 'mod_bigbluebuttonbn\\external\\completion_validate', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(408, 'mod_bigbluebuttonbn_meeting_info', 'mod_bigbluebuttonbn\\external\\meeting_info', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(409, 'mod_bigbluebuttonbn_get_bigbluebuttonbns_by_courses', 'mod_bigbluebuttonbn\\external\\get_bigbluebuttonbns_by_courses', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(410, 'mod_bigbluebuttonbn_view_bigbluebuttonbn', 'mod_bigbluebuttonbn\\external\\view_bigbluebuttonbn', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:view', 'moodle_mobile_app'),
(411, 'mod_bigbluebuttonbn_get_join_url', 'mod_bigbluebuttonbn\\external\\get_join_url', 'execute', NULL, 'mod_bigbluebuttonbn', 'mod/bigbluebuttonbn:join', 'moodle_mobile_app'),
(412, 'mod_book_view_book', 'mod_book_external', 'view_book', NULL, 'mod_book', 'mod/book:read', 'moodle_mobile_app');
INSERT INTO `mdlxd_external_functions` VALUES
(413, 'mod_book_get_books_by_courses', 'mod_book_external', 'get_books_by_courses', NULL, 'mod_book', '', 'moodle_mobile_app'),
(414, 'mod_chat_login_user', 'mod_chat_external', 'login_user', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(415, 'mod_chat_get_chat_users', 'mod_chat_external', 'get_chat_users', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(416, 'mod_chat_send_chat_message', 'mod_chat_external', 'send_chat_message', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(417, 'mod_chat_get_chat_latest_messages', 'mod_chat_external', 'get_chat_latest_messages', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(418, 'mod_chat_view_chat', 'mod_chat_external', 'view_chat', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(419, 'mod_chat_get_chats_by_courses', 'mod_chat_external', 'get_chats_by_courses', NULL, 'mod_chat', '', 'moodle_mobile_app'),
(420, 'mod_chat_get_sessions', 'mod_chat_external', 'get_sessions', NULL, 'mod_chat', '', 'moodle_mobile_app'),
(421, 'mod_chat_get_session_messages', 'mod_chat_external', 'get_session_messages', NULL, 'mod_chat', '', 'moodle_mobile_app'),
(422, 'mod_chat_view_sessions', 'mod_chat\\external\\view_sessions', 'execute', NULL, 'mod_chat', 'mod/chat:readlog', 'moodle_mobile_app'),
(423, 'mod_choice_get_choice_results', 'mod_choice_external', 'get_choice_results', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(424, 'mod_choice_get_choice_options', 'mod_choice_external', 'get_choice_options', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(425, 'mod_choice_submit_choice_response', 'mod_choice_external', 'submit_choice_response', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(426, 'mod_choice_view_choice', 'mod_choice_external', 'view_choice', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(427, 'mod_choice_get_choices_by_courses', 'mod_choice_external', 'get_choices_by_courses', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(428, 'mod_choice_delete_choice_responses', 'mod_choice_external', 'delete_choice_responses', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(429, 'mod_data_get_databases_by_courses', 'mod_data_external', 'get_databases_by_courses', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(430, 'mod_data_view_database', 'mod_data_external', 'view_database', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(431, 'mod_data_get_data_access_information', 'mod_data_external', 'get_data_access_information', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(432, 'mod_data_get_entries', 'mod_data_external', 'get_entries', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(433, 'mod_data_get_entry', 'mod_data_external', 'get_entry', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(434, 'mod_data_get_fields', 'mod_data_external', 'get_fields', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(435, 'mod_data_search_entries', 'mod_data_external', 'search_entries', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(436, 'mod_data_approve_entry', 'mod_data_external', 'approve_entry', NULL, 'mod_data', 'mod/data:approve', 'moodle_mobile_app'),
(437, 'mod_data_delete_entry', 'mod_data_external', 'delete_entry', NULL, 'mod_data', 'mod/data:manageentries', 'moodle_mobile_app'),
(438, 'mod_data_add_entry', 'mod_data_external', 'add_entry', NULL, 'mod_data', 'mod/data:writeentry', 'moodle_mobile_app'),
(439, 'mod_data_update_entry', 'mod_data_external', 'update_entry', NULL, 'mod_data', 'mod/data:writeentry', 'moodle_mobile_app'),
(440, 'mod_data_delete_saved_preset', 'mod_data\\external\\delete_saved_preset', 'execute', NULL, 'mod_data', 'mod/data:manageuserpresets', NULL),
(441, 'mod_data_get_mapping_information', 'mod_data\\external\\get_mapping_information', 'execute', NULL, 'mod_data', 'mod/data:managetemplates', NULL),
(442, 'mod_feedback_get_feedbacks_by_courses', 'mod_feedback_external', 'get_feedbacks_by_courses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(443, 'mod_feedback_get_feedback_access_information', 'mod_feedback_external', 'get_feedback_access_information', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(444, 'mod_feedback_view_feedback', 'mod_feedback_external', 'view_feedback', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(445, 'mod_feedback_get_current_completed_tmp', 'mod_feedback_external', 'get_current_completed_tmp', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(446, 'mod_feedback_get_items', 'mod_feedback_external', 'get_items', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(447, 'mod_feedback_launch_feedback', 'mod_feedback_external', 'launch_feedback', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(448, 'mod_feedback_get_page_items', 'mod_feedback_external', 'get_page_items', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(449, 'mod_feedback_process_page', 'mod_feedback_external', 'process_page', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(450, 'mod_feedback_get_analysis', 'mod_feedback_external', 'get_analysis', NULL, 'mod_feedback', 'mod/feedback:viewanalysepage', 'moodle_mobile_app'),
(451, 'mod_feedback_get_unfinished_responses', 'mod_feedback_external', 'get_unfinished_responses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(452, 'mod_feedback_get_finished_responses', 'mod_feedback_external', 'get_finished_responses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(453, 'mod_feedback_get_non_respondents', 'mod_feedback_external', 'get_non_respondents', NULL, 'mod_feedback', 'mod/feedback:viewreports', 'moodle_mobile_app'),
(454, 'mod_feedback_get_responses_analysis', 'mod_feedback_external', 'get_responses_analysis', NULL, 'mod_feedback', 'mod/feedback:viewreports', 'moodle_mobile_app'),
(455, 'mod_feedback_get_last_completed', 'mod_feedback_external', 'get_last_completed', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(456, 'mod_folder_view_folder', 'mod_folder_external', 'view_folder', NULL, 'mod_folder', 'mod/folder:view', 'moodle_mobile_app'),
(457, 'mod_folder_get_folders_by_courses', 'mod_folder_external', 'get_folders_by_courses', NULL, 'mod_folder', 'mod/folder:view', 'moodle_mobile_app'),
(458, 'mod_forum_get_forums_by_courses', 'mod_forum_external', 'get_forums_by_courses', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(459, 'mod_forum_get_discussion_posts', 'mod_forum_external', 'get_discussion_posts', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', 'moodle_mobile_app'),
(460, 'mod_forum_get_forum_discussions_paginated', 'mod_forum_external', 'get_forum_discussions_paginated', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', 'moodle_mobile_app'),
(461, 'mod_forum_get_forum_discussions', 'mod_forum_external', 'get_forum_discussions', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', 'moodle_mobile_app'),
(462, 'mod_forum_view_forum', 'mod_forum_external', 'view_forum', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(463, 'mod_forum_view_forum_discussion', 'mod_forum_external', 'view_forum_discussion', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(464, 'mod_forum_add_discussion_post', 'mod_forum_external', 'add_discussion_post', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:replypost', 'moodle_mobile_app'),
(465, 'mod_forum_add_discussion', 'mod_forum_external', 'add_discussion', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:startdiscussion', 'moodle_mobile_app'),
(466, 'mod_forum_can_add_discussion', 'mod_forum_external', 'can_add_discussion', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(467, 'mod_forum_get_forum_access_information', 'mod_forum_external', 'get_forum_access_information', NULL, 'mod_forum', '', 'moodle_mobile_app'),
(468, 'mod_forum_set_subscription_state', 'mod_forum_external', 'set_subscription_state', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(469, 'mod_forum_set_lock_state', 'mod_forum_external', 'set_lock_state', 'mod/forum/externallib.php', 'mod_forum', 'moodle/course:manageactivities', 'moodle_mobile_app'),
(470, 'mod_forum_toggle_favourite_state', 'mod_forum_external', 'toggle_favourite_state', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(471, 'mod_forum_set_pin_state', 'mod_forum_external', 'set_pin_state', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(472, 'mod_forum_delete_post', 'mod_forum_external', 'delete_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(473, 'mod_forum_get_discussion_posts_by_userid', 'mod_forum_external', 'get_discussion_posts_by_userid', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', NULL),
(474, 'mod_forum_get_discussion_post', 'mod_forum_external', 'get_discussion_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(475, 'mod_forum_prepare_draft_area_for_post', 'mod_forum_external', 'prepare_draft_area_for_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(476, 'mod_forum_update_discussion_post', 'mod_forum_external', 'update_discussion_post', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(477, 'mod_glossary_get_glossaries_by_courses', 'mod_glossary_external', 'get_glossaries_by_courses', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(478, 'mod_glossary_view_glossary', 'mod_glossary_external', 'view_glossary', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(479, 'mod_glossary_view_entry', 'mod_glossary_external', 'view_entry', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(480, 'mod_glossary_get_entries_by_letter', 'mod_glossary_external', 'get_entries_by_letter', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(481, 'mod_glossary_get_entries_by_date', 'mod_glossary_external', 'get_entries_by_date', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(482, 'mod_glossary_get_categories', 'mod_glossary_external', 'get_categories', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(483, 'mod_glossary_get_entries_by_category', 'mod_glossary_external', 'get_entries_by_category', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(484, 'mod_glossary_get_authors', 'mod_glossary_external', 'get_authors', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(485, 'mod_glossary_get_entries_by_author', 'mod_glossary_external', 'get_entries_by_author', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(486, 'mod_glossary_get_entries_by_author_id', 'mod_glossary_external', 'get_entries_by_author_id', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(487, 'mod_glossary_get_entries_by_search', 'mod_glossary_external', 'get_entries_by_search', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(488, 'mod_glossary_get_entries_by_term', 'mod_glossary_external', 'get_entries_by_term', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(489, 'mod_glossary_get_entries_to_approve', 'mod_glossary_external', 'get_entries_to_approve', NULL, 'mod_glossary', 'mod/glossary:approve', 'moodle_mobile_app'),
(490, 'mod_glossary_get_entry_by_id', 'mod_glossary_external', 'get_entry_by_id', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(491, 'mod_glossary_add_entry', 'mod_glossary_external', 'add_entry', NULL, 'mod_glossary', 'mod/glossary:write', 'moodle_mobile_app'),
(492, 'mod_glossary_delete_entry', 'mod_glossary\\external\\delete_entry', 'execute', NULL, 'mod_glossary', '', 'moodle_mobile_app'),
(493, 'mod_glossary_update_entry', 'mod_glossary\\external\\update_entry', 'execute', NULL, 'mod_glossary', '', 'moodle_mobile_app'),
(494, 'mod_glossary_prepare_entry_for_edition', 'mod_glossary\\external\\prepare_entry', 'execute', NULL, 'mod_glossary', '', 'moodle_mobile_app'),
(495, 'mod_h5pactivity_get_h5pactivity_access_information', 'mod_h5pactivity\\external\\get_h5pactivity_access_information', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(496, 'mod_h5pactivity_view_h5pactivity', 'mod_h5pactivity\\external\\view_h5pactivity', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(497, 'mod_h5pactivity_get_attempts', 'mod_h5pactivity\\external\\get_attempts', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(498, 'mod_h5pactivity_get_results', 'mod_h5pactivity\\external\\get_results', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(499, 'mod_h5pactivity_get_h5pactivities_by_courses', 'mod_h5pactivity\\external\\get_h5pactivities_by_courses', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:view', 'moodle_mobile_app'),
(500, 'mod_h5pactivity_log_report_viewed', 'mod_h5pactivity\\external\\log_report_viewed', 'execute', NULL, 'mod_h5pactivity', '', 'moodle_mobile_app'),
(501, 'mod_h5pactivity_get_user_attempts', 'mod_h5pactivity\\external\\get_user_attempts', 'execute', NULL, 'mod_h5pactivity', 'mod/h5pactivity:reviewattempts', 'moodle_mobile_app'),
(502, 'mod_imscp_view_imscp', 'mod_imscp_external', 'view_imscp', NULL, 'mod_imscp', 'mod/imscp:view', 'moodle_mobile_app'),
(503, 'mod_imscp_get_imscps_by_courses', 'mod_imscp_external', 'get_imscps_by_courses', NULL, 'mod_imscp', 'mod/imscp:view', 'moodle_mobile_app'),
(504, 'mod_label_get_labels_by_courses', 'mod_label_external', 'get_labels_by_courses', NULL, 'mod_label', 'mod/label:view', 'moodle_mobile_app'),
(505, 'mod_lesson_get_lessons_by_courses', 'mod_lesson_external', 'get_lessons_by_courses', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(506, 'mod_lesson_get_lesson_access_information', 'mod_lesson_external', 'get_lesson_access_information', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(507, 'mod_lesson_view_lesson', 'mod_lesson_external', 'view_lesson', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(508, 'mod_lesson_get_questions_attempts', 'mod_lesson_external', 'get_questions_attempts', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(509, 'mod_lesson_get_user_grade', 'mod_lesson_external', 'get_user_grade', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(510, 'mod_lesson_get_user_attempt_grade', 'mod_lesson_external', 'get_user_attempt_grade', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(511, 'mod_lesson_get_content_pages_viewed', 'mod_lesson_external', 'get_content_pages_viewed', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(512, 'mod_lesson_get_user_timers', 'mod_lesson_external', 'get_user_timers', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(513, 'mod_lesson_get_pages', 'mod_lesson_external', 'get_pages', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(514, 'mod_lesson_launch_attempt', 'mod_lesson_external', 'launch_attempt', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(515, 'mod_lesson_get_page_data', 'mod_lesson_external', 'get_page_data', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(516, 'mod_lesson_process_page', 'mod_lesson_external', 'process_page', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(517, 'mod_lesson_finish_attempt', 'mod_lesson_external', 'finish_attempt', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(518, 'mod_lesson_get_attempts_overview', 'mod_lesson_external', 'get_attempts_overview', NULL, 'mod_lesson', 'mod/lesson:viewreports', 'moodle_mobile_app'),
(519, 'mod_lesson_get_user_attempt', 'mod_lesson_external', 'get_user_attempt', NULL, 'mod_lesson', 'mod/lesson:viewreports', 'moodle_mobile_app'),
(520, 'mod_lesson_get_pages_possible_jumps', 'mod_lesson_external', 'get_pages_possible_jumps', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(521, 'mod_lesson_get_lesson', 'mod_lesson_external', 'get_lesson', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(522, 'mod_lti_get_tool_launch_data', 'mod_lti_external', 'get_tool_launch_data', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(523, 'mod_lti_get_ltis_by_courses', 'mod_lti_external', 'get_ltis_by_courses', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(524, 'mod_lti_view_lti', 'mod_lti_external', 'view_lti', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(525, 'mod_lti_get_tool_proxies', 'mod_lti_external', 'get_tool_proxies', NULL, 'mod_lti', 'moodle/site:config', NULL),
(526, 'mod_lti_create_tool_proxy', 'mod_lti_external', 'create_tool_proxy', NULL, 'mod_lti', 'moodle/site:config', NULL),
(527, 'mod_lti_delete_tool_proxy', 'mod_lti_external', 'delete_tool_proxy', NULL, 'mod_lti', 'moodle/site:config', NULL),
(528, 'mod_lti_get_tool_proxy_registration_request', 'mod_lti_external', 'get_tool_proxy_registration_request', NULL, 'mod_lti', 'moodle/site:config', NULL),
(529, 'mod_lti_get_tool_types', 'mod_lti_external', 'get_tool_types', NULL, 'mod_lti', 'moodle/site:config', NULL),
(530, 'mod_lti_get_tool_types_and_proxies', 'mod_lti\\external\\get_tool_types_and_proxies', 'execute', NULL, 'mod_lti', 'moodle/site:config', NULL),
(531, 'mod_lti_get_tool_types_and_proxies_count', 'mod_lti\\external\\get_tool_types_and_proxies_count', 'execute', NULL, 'mod_lti', 'moodle/site:config', NULL),
(532, 'mod_lti_create_tool_type', 'mod_lti_external', 'create_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(533, 'mod_lti_update_tool_type', 'mod_lti_external', 'update_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(534, 'mod_lti_delete_tool_type', 'mod_lti_external', 'delete_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(535, 'mod_lti_delete_course_tool_type', 'mod_lti\\external\\delete_course_tool_type', 'execute', NULL, 'mod_lti', 'mod/lti:addcoursetool', NULL),
(536, 'mod_lti_toggle_showinactivitychooser', 'mod_lti\\external\\toggle_showinactivitychooser', 'execute', NULL, 'mod_lti', 'mod/lti:addcoursetool', NULL),
(537, 'mod_lti_is_cartridge', 'mod_lti_external', 'is_cartridge', NULL, 'mod_lti', 'moodle/site:config', NULL),
(538, 'mod_page_view_page', 'mod_page_external', 'view_page', NULL, 'mod_page', 'mod/page:view', 'moodle_mobile_app'),
(539, 'mod_page_get_pages_by_courses', 'mod_page_external', 'get_pages_by_courses', NULL, 'mod_page', 'mod/page:view', 'moodle_mobile_app'),
(540, 'mod_quiz_get_quizzes_by_courses', 'mod_quiz_external', 'get_quizzes_by_courses', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(541, 'mod_quiz_view_quiz', 'mod_quiz_external', 'view_quiz', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(542, 'mod_quiz_get_user_attempts', 'mod_quiz_external', 'get_user_attempts', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(543, 'mod_quiz_get_user_best_grade', 'mod_quiz_external', 'get_user_best_grade', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(544, 'mod_quiz_get_combined_review_options', 'mod_quiz_external', 'get_combined_review_options', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(545, 'mod_quiz_start_attempt', 'mod_quiz_external', 'start_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(546, 'mod_quiz_get_attempt_data', 'mod_quiz_external', 'get_attempt_data', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(547, 'mod_quiz_get_attempt_summary', 'mod_quiz_external', 'get_attempt_summary', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(548, 'mod_quiz_save_attempt', 'mod_quiz_external', 'save_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(549, 'mod_quiz_process_attempt', 'mod_quiz_external', 'process_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(550, 'mod_quiz_get_attempt_review', 'mod_quiz_external', 'get_attempt_review', NULL, 'mod_quiz', 'mod/quiz:reviewmyattempts', 'moodle_mobile_app'),
(551, 'mod_quiz_view_attempt', 'mod_quiz_external', 'view_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(552, 'mod_quiz_view_attempt_summary', 'mod_quiz_external', 'view_attempt_summary', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(553, 'mod_quiz_view_attempt_review', 'mod_quiz_external', 'view_attempt_review', NULL, 'mod_quiz', 'mod/quiz:reviewmyattempts', 'moodle_mobile_app'),
(554, 'mod_quiz_get_quiz_feedback_for_grade', 'mod_quiz_external', 'get_quiz_feedback_for_grade', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(555, 'mod_quiz_get_quiz_access_information', 'mod_quiz_external', 'get_quiz_access_information', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(556, 'mod_quiz_get_attempt_access_information', 'mod_quiz_external', 'get_attempt_access_information', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(557, 'mod_quiz_get_quiz_required_qtypes', 'mod_quiz_external', 'get_quiz_required_qtypes', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(558, 'mod_quiz_set_question_version', 'mod_quiz\\external\\submit_question_version', 'execute', NULL, 'mod_quiz', 'mod/quiz:view', NULL),
(559, 'mod_quiz_reopen_attempt', 'mod_quiz\\external\\reopen_attempt', 'execute', NULL, 'mod_quiz', 'mod/quiz:reopenattempts', NULL),
(560, 'mod_quiz_get_reopen_attempt_confirmation', 'mod_quiz\\external\\get_reopen_attempt_confirmation', 'execute', NULL, 'mod_quiz', 'mod/quiz:reopenattempts', NULL),
(561, 'mod_quiz_add_random_questions', 'mod_quiz\\external\\add_random_questions', 'execute', NULL, 'mod_quiz', 'mod/quiz:manage', NULL),
(562, 'mod_quiz_update_filter_condition', 'mod_quiz\\external\\update_filter_condition', 'execute', NULL, 'mod_quiz', 'mod/quiz:manage', NULL),
(563, 'mod_resource_view_resource', 'mod_resource_external', 'view_resource', NULL, 'mod_resource', 'mod/resource:view', 'moodle_mobile_app'),
(564, 'mod_resource_get_resources_by_courses', 'mod_resource_external', 'get_resources_by_courses', NULL, 'mod_resource', 'mod/resource:view', 'moodle_mobile_app'),
(565, 'mod_scorm_view_scorm', 'mod_scorm_external', 'view_scorm', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(566, 'mod_scorm_get_scorm_attempt_count', 'mod_scorm_external', 'get_scorm_attempt_count', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(567, 'mod_scorm_get_scorm_scoes', 'mod_scorm_external', 'get_scorm_scoes', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(568, 'mod_scorm_get_scorm_user_data', 'mod_scorm_external', 'get_scorm_user_data', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(569, 'mod_scorm_insert_scorm_tracks', 'mod_scorm_external', 'insert_scorm_tracks', NULL, 'mod_scorm', 'mod/scorm:savetrack', 'moodle_mobile_app'),
(570, 'mod_scorm_get_scorm_sco_tracks', 'mod_scorm_external', 'get_scorm_sco_tracks', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(571, 'mod_scorm_get_scorms_by_courses', 'mod_scorm_external', 'get_scorms_by_courses', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(572, 'mod_scorm_launch_sco', 'mod_scorm_external', 'launch_sco', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(573, 'mod_scorm_get_scorm_access_information', 'mod_scorm_external', 'get_scorm_access_information', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(574, 'mod_survey_get_surveys_by_courses', 'mod_survey_external', 'get_surveys_by_courses', NULL, 'mod_survey', '', 'moodle_mobile_app'),
(575, 'mod_survey_view_survey', 'mod_survey_external', 'view_survey', NULL, 'mod_survey', 'mod/survey:participate', 'moodle_mobile_app'),
(576, 'mod_survey_get_questions', 'mod_survey_external', 'get_questions', NULL, 'mod_survey', 'mod/survey:participate', 'moodle_mobile_app'),
(577, 'mod_survey_submit_answers', 'mod_survey_external', 'submit_answers', NULL, 'mod_survey', 'mod/survey:participate', 'moodle_mobile_app'),
(578, 'mod_url_view_url', 'mod_url_external', 'view_url', NULL, 'mod_url', 'mod/url:view', 'moodle_mobile_app'),
(579, 'mod_url_get_urls_by_courses', 'mod_url_external', 'get_urls_by_courses', NULL, 'mod_url', 'mod/url:view', 'moodle_mobile_app'),
(580, 'mod_wiki_get_wikis_by_courses', 'mod_wiki_external', 'get_wikis_by_courses', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(581, 'mod_wiki_view_wiki', 'mod_wiki_external', 'view_wiki', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(582, 'mod_wiki_view_page', 'mod_wiki_external', 'view_page', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(583, 'mod_wiki_get_subwikis', 'mod_wiki_external', 'get_subwikis', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(584, 'mod_wiki_get_subwiki_pages', 'mod_wiki_external', 'get_subwiki_pages', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(585, 'mod_wiki_get_subwiki_files', 'mod_wiki_external', 'get_subwiki_files', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(586, 'mod_wiki_get_page_contents', 'mod_wiki_external', 'get_page_contents', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(587, 'mod_wiki_get_page_for_editing', 'mod_wiki_external', 'get_page_for_editing', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(588, 'mod_wiki_new_page', 'mod_wiki_external', 'new_page', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(589, 'mod_wiki_edit_page', 'mod_wiki_external', 'edit_page', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(590, 'mod_workshop_get_workshops_by_courses', 'mod_workshop_external', 'get_workshops_by_courses', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(591, 'mod_workshop_get_workshop_access_information', 'mod_workshop_external', 'get_workshop_access_information', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(592, 'mod_workshop_get_user_plan', 'mod_workshop_external', 'get_user_plan', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(593, 'mod_workshop_view_workshop', 'mod_workshop_external', 'view_workshop', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(594, 'mod_workshop_add_submission', 'mod_workshop_external', 'add_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(595, 'mod_workshop_update_submission', 'mod_workshop_external', 'update_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(596, 'mod_workshop_delete_submission', 'mod_workshop_external', 'delete_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(597, 'mod_workshop_get_submissions', 'mod_workshop_external', 'get_submissions', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(598, 'mod_workshop_get_submission', 'mod_workshop_external', 'get_submission', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(599, 'mod_workshop_get_submission_assessments', 'mod_workshop_external', 'get_submission_assessments', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(600, 'mod_workshop_get_assessment', 'mod_workshop_external', 'get_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(601, 'mod_workshop_get_assessment_form_definition', 'mod_workshop_external', 'get_assessment_form_definition', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(602, 'mod_workshop_get_reviewer_assessments', 'mod_workshop_external', 'get_reviewer_assessments', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(603, 'mod_workshop_update_assessment', 'mod_workshop_external', 'update_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(604, 'mod_workshop_get_grades', 'mod_workshop_external', 'get_grades', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(605, 'mod_workshop_evaluate_assessment', 'mod_workshop_external', 'evaluate_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(606, 'mod_workshop_get_grades_report', 'mod_workshop_external', 'get_grades_report', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(607, 'mod_workshop_view_submission', 'mod_workshop_external', 'view_submission', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(608, 'mod_workshop_evaluate_submission', 'mod_workshop_external', 'evaluate_submission', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(609, 'auth_email_get_signup_settings', 'auth_email_external', 'get_signup_settings', NULL, 'auth_email', '', NULL),
(610, 'auth_email_signup_user', 'auth_email_external', 'signup_user', NULL, 'auth_email', '', NULL),
(611, 'enrol_guest_get_instance_info', 'enrol_guest_external', 'get_instance_info', NULL, 'enrol_guest', '', 'moodle_mobile_app'),
(612, 'enrol_guest_validate_password', 'enrol_guest\\external\\validate_password', 'execute', NULL, 'enrol_guest', '', 'moodle_mobile_app'),
(613, 'enrol_manual_enrol_users', 'enrol_manual_external', 'enrol_users', 'enrol/manual/externallib.php', 'enrol_manual', 'enrol/manual:enrol', NULL),
(614, 'enrol_manual_unenrol_users', 'enrol_manual_external', 'unenrol_users', 'enrol/manual/externallib.php', 'enrol_manual', 'enrol/manual:unenrol', NULL),
(615, 'enrol_meta_add_instances', 'enrol_meta\\external\\add_instances', 'execute', NULL, 'enrol_meta', 'enrol/meta:config', NULL),
(616, 'enrol_meta_delete_instances', 'enrol_meta\\external\\delete_instances', 'execute', NULL, 'enrol_meta', 'enrol/meta:config', NULL),
(617, 'enrol_self_get_instance_info', 'enrol_self_external', 'get_instance_info', 'enrol/self/externallib.php', 'enrol_self', '', 'moodle_mobile_app'),
(618, 'enrol_self_enrol_user', 'enrol_self_external', 'enrol_user', 'enrol/self/externallib.php', 'enrol_self', '', 'moodle_mobile_app'),
(619, 'message_airnotifier_is_system_configured', 'message_airnotifier_external', 'is_system_configured', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(620, 'message_airnotifier_are_notification_preferences_configured', 'message_airnotifier_external', 'are_notification_preferences_configured', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(621, 'message_airnotifier_get_user_devices', 'message_airnotifier_external', 'get_user_devices', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(622, 'message_airnotifier_enable_device', 'message_airnotifier_external', 'enable_device', 'message/output/airnotifier/externallib.php', 'message_airnotifier', 'message/airnotifier:managedevice', 'moodle_mobile_app'),
(623, 'message_popup_get_popup_notifications', 'message_popup_external', 'get_popup_notifications', 'message/output/popup/externallib.php', 'message_popup', '', 'moodle_mobile_app'),
(624, 'message_popup_get_unread_popup_notification_count', 'message_popup_external', 'get_unread_popup_notification_count', 'message/output/popup/externallib.php', 'message_popup', '', 'moodle_mobile_app'),
(625, 'block_accessreview_get_module_data', 'block_accessreview\\external\\get_module_data', 'execute', NULL, 'block_accessreview', 'block/accessreview:view', NULL),
(626, 'block_accessreview_get_section_data', 'block_accessreview\\external\\get_section_data', 'execute', NULL, 'block_accessreview', 'block/accessreview:view', NULL),
(627, 'block_recentlyaccesseditems_get_recent_items', 'block_recentlyaccesseditems\\external', 'get_recent_items', NULL, 'block_recentlyaccesseditems', '', 'moodle_mobile_app'),
(628, 'block_starredcourses_get_starred_courses', 'block_starredcourses_external', 'get_starred_courses', 'block/starredcourses/classes/external.php', 'block_starredcourses', '', 'moodle_mobile_app'),
(629, 'media_videojs_get_language', 'media_videojs\\external\\get_language', 'execute', NULL, 'media_videojs', '', NULL),
(630, 'report_competency_data_for_report', 'report_competency\\external', 'data_for_report', NULL, 'report_competency', 'moodle/competency:coursecompetencyview', NULL),
(631, 'report_insights_set_notuseful_prediction', 'report_insights\\external', 'set_notuseful_prediction', NULL, 'report_insights', '', 'moodle_mobile_app'),
(632, 'report_insights_set_fixed_prediction', 'report_insights\\external', 'set_fixed_prediction', NULL, 'report_insights', '', 'moodle_mobile_app'),
(633, 'report_insights_action_executed', 'report_insights\\external', 'action_executed', NULL, 'report_insights', '', 'moodle_mobile_app'),
(634, 'gradereport_grader_get_users_in_report', 'gradereport_grader\\external\\get_users_in_report', 'execute', NULL, 'gradereport_grader', 'gradereport/grader:view', 'moodle_mobile_app'),
(635, 'gradereport_overview_get_course_grades', 'gradereport_overview_external', 'get_course_grades', NULL, 'gradereport_overview', '', 'moodle_mobile_app'),
(636, 'gradereport_overview_view_grade_report', 'gradereport_overview_external', 'view_grade_report', NULL, 'gradereport_overview', 'gradereport/overview:view', 'moodle_mobile_app'),
(637, 'gradereport_singleview_get_grade_items_for_search_widget', 'gradereport_singleview\\external\\singleview', 'get_grade_items_for_search_widget', NULL, 'gradereport_singleview', 'gradereport/singleview:view', 'moodle_mobile_app'),
(638, 'gradereport_user_get_grades_table', 'gradereport_user\\external\\user', 'get_grades_table', NULL, 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(639, 'gradereport_user_view_grade_report', 'gradereport_user\\external\\user', 'view_grade_report', NULL, 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(640, 'gradereport_user_get_grade_items', 'gradereport_user\\external\\user', 'get_grade_items', NULL, 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(641, 'gradereport_user_get_access_information', 'gradereport_user\\external\\get_access_information', 'execute', NULL, 'gradereport_user', '', 'moodle_mobile_app'),
(642, 'gradingform_guide_grader_gradingpanel_fetch', 'gradingform_guide\\grades\\grader\\gradingpanel\\external\\fetch', 'execute', NULL, 'gradingform_guide', '', NULL),
(643, 'gradingform_guide_grader_gradingpanel_store', 'gradingform_guide\\grades\\grader\\gradingpanel\\external\\store', 'execute', NULL, 'gradingform_guide', '', NULL),
(644, 'gradingform_rubric_grader_gradingpanel_fetch', 'gradingform_rubric\\grades\\grader\\gradingpanel\\external\\fetch', 'execute', NULL, 'gradingform_rubric', '', NULL),
(645, 'gradingform_rubric_grader_gradingpanel_store', 'gradingform_rubric\\grades\\grader\\gradingpanel\\external\\store', 'execute', NULL, 'gradingform_rubric', '', NULL),
(646, 'qbank_columnsortorder_set_columnbank_order', 'qbank_columnsortorder\\external\\set_columnbank_order', 'execute', NULL, 'qbank_columnsortorder', '', NULL),
(647, 'qbank_columnsortorder_set_hidden_columns', 'qbank_columnsortorder\\external\\set_hidden_columns', 'execute', NULL, 'qbank_columnsortorder', '', NULL),
(648, 'qbank_columnsortorder_set_column_size', 'qbank_columnsortorder\\external\\set_column_size', 'execute', NULL, 'qbank_columnsortorder', '', NULL),
(649, 'qbank_editquestion_set_status', 'qbank_editquestion\\external\\update_question_version_status', 'execute', NULL, 'qbank_editquestion', '', NULL),
(650, 'qbank_tagquestion_submit_tags_form', 'qbank_tagquestion\\external\\submit_tags', 'execute', NULL, 'qbank_tagquestion', '', NULL),
(651, 'qbank_viewquestiontext_set_question_text_format', 'qbank_viewquestiontext\\external\\set_question_text_format', 'execute', NULL, 'qbank_viewquestiontext', '', NULL),
(652, 'tool_analytics_potential_contexts', 'tool_analytics\\external', 'potential_contexts', NULL, 'tool_analytics', '', 'moodle_mobile_app'),
(653, 'tool_behat_get_entity_generator', 'tool_behat\\external\\get_entity_generator', 'execute', NULL, 'tool_behat', 'moodle/site:config', NULL),
(654, 'tool_dataprivacy_cancel_data_request', 'tool_dataprivacy\\external', 'cancel_data_request', NULL, 'tool_dataprivacy', '', NULL),
(655, 'tool_dataprivacy_contact_dpo', 'tool_dataprivacy\\external', 'contact_dpo', NULL, 'tool_dataprivacy', '', NULL),
(656, 'tool_dataprivacy_mark_complete', 'tool_dataprivacy\\external', 'mark_complete', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(657, 'tool_dataprivacy_get_data_request', 'tool_dataprivacy\\external', 'get_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(658, 'tool_dataprivacy_approve_data_request', 'tool_dataprivacy\\external', 'approve_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(659, 'tool_dataprivacy_submit_selected_courses_form', 'tool_dataprivacy\\external\\submit_selected_courses_form', 'execute', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(660, 'tool_dataprivacy_bulk_approve_data_requests', 'tool_dataprivacy\\external', 'bulk_approve_data_requests', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(661, 'tool_dataprivacy_deny_data_request', 'tool_dataprivacy\\external', 'deny_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(662, 'tool_dataprivacy_bulk_deny_data_requests', 'tool_dataprivacy\\external', 'bulk_deny_data_requests', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(663, 'tool_dataprivacy_get_users', 'tool_dataprivacy\\external', 'get_users', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(664, 'tool_dataprivacy_create_purpose_form', 'tool_dataprivacy\\external', 'create_purpose_form', NULL, 'tool_dataprivacy', '', NULL),
(665, 'tool_dataprivacy_create_category_form', 'tool_dataprivacy\\external', 'create_category_form', NULL, 'tool_dataprivacy', '', NULL),
(666, 'tool_dataprivacy_delete_purpose', 'tool_dataprivacy\\external', 'delete_purpose', NULL, 'tool_dataprivacy', '', NULL),
(667, 'tool_dataprivacy_delete_category', 'tool_dataprivacy\\external', 'delete_category', NULL, 'tool_dataprivacy', '', NULL),
(668, 'tool_dataprivacy_set_contextlevel_form', 'tool_dataprivacy\\external', 'set_contextlevel_form', NULL, 'tool_dataprivacy', '', NULL),
(669, 'tool_dataprivacy_set_context_form', 'tool_dataprivacy\\external', 'set_context_form', NULL, 'tool_dataprivacy', '', NULL),
(670, 'tool_dataprivacy_tree_extra_branches', 'tool_dataprivacy\\external', 'tree_extra_branches', NULL, 'tool_dataprivacy', '', NULL),
(671, 'tool_dataprivacy_confirm_contexts_for_deletion', 'tool_dataprivacy\\external', 'confirm_contexts_for_deletion', NULL, 'tool_dataprivacy', '', NULL),
(672, 'tool_dataprivacy_set_context_defaults', 'tool_dataprivacy\\external', 'set_context_defaults', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(673, 'tool_dataprivacy_get_category_options', 'tool_dataprivacy\\external', 'get_category_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(674, 'tool_dataprivacy_get_purpose_options', 'tool_dataprivacy\\external', 'get_purpose_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(675, 'tool_dataprivacy_get_activity_options', 'tool_dataprivacy\\external', 'get_activity_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(676, 'tool_lp_data_for_competency_frameworks_manage_page', 'tool_lp\\external', 'data_for_competency_frameworks_manage_page', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(677, 'tool_lp_data_for_competency_summary', 'tool_lp\\external', 'data_for_competency_summary', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(678, 'tool_lp_data_for_competencies_manage_page', 'tool_lp\\external', 'data_for_competencies_manage_page', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(679, 'tool_lp_list_courses_using_competency', 'tool_lp\\external', 'list_courses_using_competency', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', NULL),
(680, 'tool_lp_data_for_course_competencies_page', 'tool_lp\\external', 'data_for_course_competencies_page', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(681, 'tool_lp_data_for_template_competencies_page', 'tool_lp\\external', 'data_for_template_competencies_page', NULL, 'tool_lp', 'moodle/competency:templateview', NULL),
(682, 'tool_lp_data_for_templates_manage_page', 'tool_lp\\external', 'data_for_templates_manage_page', NULL, 'tool_lp', 'moodle/competency:templateview', NULL),
(683, 'tool_lp_data_for_plans_page', 'tool_lp\\external', 'data_for_plans_page', NULL, 'tool_lp', 'moodle/competency:planviewown', 'moodle_mobile_app'),
(684, 'tool_lp_data_for_plan_page', 'tool_lp\\external', 'data_for_plan_page', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(685, 'tool_lp_data_for_related_competencies_section', 'tool_lp\\external', 'data_for_related_competencies_section', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(686, 'tool_lp_search_users', 'tool_lp\\external', 'search_users', NULL, 'tool_lp', '', NULL),
(687, 'tool_lp_search_cohorts', 'core_cohort_external', 'search_cohorts', 'cohort/externallib.php', 'tool_lp', 'moodle/cohort:view', NULL),
(688, 'tool_lp_data_for_user_evidence_list_page', 'tool_lp\\external', 'data_for_user_evidence_list_page', NULL, 'tool_lp', 'moodle/competency:userevidenceview', 'moodle_mobile_app'),
(689, 'tool_lp_data_for_user_evidence_page', 'tool_lp\\external', 'data_for_user_evidence_page', NULL, 'tool_lp', 'moodle/competency:userevidenceview', 'moodle_mobile_app'),
(690, 'tool_lp_data_for_user_competency_summary', 'tool_lp\\external', 'data_for_user_competency_summary', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(691, 'tool_lp_data_for_user_competency_summary_in_plan', 'tool_lp\\external', 'data_for_user_competency_summary_in_plan', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(692, 'tool_lp_data_for_user_competency_summary_in_course', 'tool_lp\\external', 'data_for_user_competency_summary_in_course', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(693, 'tool_mobile_get_plugins_supporting_mobile', 'tool_mobile\\external', 'get_plugins_supporting_mobile', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(694, 'tool_mobile_get_public_config', 'tool_mobile\\external', 'get_public_config', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(695, 'tool_mobile_get_config', 'tool_mobile\\external', 'get_config', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(696, 'tool_mobile_get_autologin_key', 'tool_mobile\\external', 'get_autologin_key', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(697, 'tool_mobile_get_content', 'tool_mobile\\external', 'get_content', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(698, 'tool_mobile_call_external_functions', 'tool_mobile\\external', 'call_external_functions', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(699, 'tool_mobile_validate_subscription_key', 'tool_mobile\\external', 'validate_subscription_key', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(700, 'tool_mobile_get_tokens_for_qr_login', 'tool_mobile\\external', 'get_tokens_for_qr_login', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(701, 'tool_moodlenet_verify_webfinger', 'tool_moodlenet\\external', 'verify_webfinger', NULL, 'tool_moodlenet', '', 'moodle_mobile_app'),
(702, 'tool_moodlenet_search_courses', 'tool_moodlenet\\external', 'search_courses', NULL, 'tool_moodlenet', '', 'moodle_mobile_app'),
(703, 'tool_policy_get_policy_version', 'tool_policy\\external', 'get_policy_version', NULL, 'tool_policy', '', NULL),
(704, 'tool_policy_submit_accept_on_behalf', 'tool_policy\\external', 'submit_accept_on_behalf', NULL, 'tool_policy', '', NULL),
(705, 'tool_templatelibrary_list_templates', 'tool_templatelibrary\\external', 'list_templates', NULL, 'tool_templatelibrary', '', NULL),
(706, 'tool_templatelibrary_load_canonical_template', 'tool_templatelibrary\\external', 'load_canonical_template', NULL, 'tool_templatelibrary', '', NULL),
(707, 'tool_usertours_fetch_and_start_tour', 'tool_usertours\\external\\tour', 'fetch_and_start_tour', NULL, 'tool_usertours', '', NULL),
(708, 'tool_usertours_step_shown', 'tool_usertours\\external\\tour', 'step_shown', NULL, 'tool_usertours', '', NULL),
(709, 'tool_usertours_complete_tour', 'tool_usertours\\external\\tour', 'complete_tour', NULL, 'tool_usertours', '', NULL),
(710, 'tool_usertours_reset_tour', 'tool_usertours\\external\\tour', 'reset_tour', NULL, 'tool_usertours', '', NULL),
(711, 'tool_xmldb_invoke_move_action', 'tool_xmldb_external', 'invoke_move_action', NULL, 'tool_xmldb', '', NULL),
(712, 'paygw_paypal_get_config_for_js', 'paygw_paypal\\external\\get_config_for_js', 'execute', NULL, 'paygw_paypal', '', NULL),
(713, 'paygw_paypal_create_transaction_complete', 'paygw_paypal\\external\\transaction_complete', 'execute', NULL, 'paygw_paypal', '', NULL),
(714, 'quizaccess_seb_validate_quiz_keys', 'quizaccess_seb\\external\\validate_quiz_keys', 'execute', NULL, 'quizaccess_seb', '', NULL),
(715, 'tiny_autosave_resume_session', 'tiny_autosave\\external\\resume_autosave_session', 'execute', NULL, 'tiny_autosave', '', NULL),
(716, 'tiny_autosave_reset_session', 'tiny_autosave\\external\\reset_autosave_session', 'execute', NULL, 'tiny_autosave', '', NULL),
(717, 'tiny_autosave_update_session', 'tiny_autosave\\external\\update_autosave_session_content', 'execute', NULL, 'tiny_autosave', '', NULL),
(718, 'tiny_equation_filter', 'tiny_equation\\external\\filter', 'execute', NULL, 'tiny_equation', '', NULL),
(719, 'tiny_premium_get_api_key', 'tiny_premium\\external\\get_api_key', 'execute', NULL, 'tiny_premium', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_external_services`
--

CREATE TABLE `mdlxd_external_services` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL,
  `requiredcapability` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `restrictedusers` tinyint(1) NOT NULL,
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint DEFAULT NULL,
  `shortname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `downloadfiles` tinyint(1) NOT NULL DEFAULT '0',
  `uploadfiles` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_exteserv_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='built in and custom external services';

--
-- Dumping data for table `mdlxd_external_services`
--

INSERT INTO `mdlxd_external_services` VALUES
(1, 'Moodle mobile web service', 0, NULL, 0, 'moodle', 1698644927, 1698644927, 'moodle_mobile_app', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_external_services_functions`
--

CREATE TABLE `mdlxd_external_services_functions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint NOT NULL,
  `functionname` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdlxd_exteservfunc_ext_ix` (`externalserviceid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='lists functions available in each service group';

--
-- Dumping data for table `mdlxd_external_services_functions`
--

INSERT INTO `mdlxd_external_services_functions` VALUES
(1, 1, 'core_badges_get_user_badges'),
(2, 1, 'core_badges_get_user_badge_by_hash'),
(3, 1, 'core_blog_get_entries'),
(4, 1, 'core_blog_view_entries'),
(5, 1, 'core_calendar_get_calendar_monthly_view'),
(6, 1, 'core_calendar_get_calendar_day_view'),
(7, 1, 'core_calendar_get_calendar_upcoming_view'),
(8, 1, 'core_calendar_update_event_start_day'),
(9, 1, 'core_calendar_create_calendar_events'),
(10, 1, 'core_calendar_delete_calendar_events'),
(11, 1, 'core_calendar_get_calendar_events'),
(12, 1, 'core_calendar_get_action_events_by_timesort'),
(13, 1, 'core_calendar_get_action_events_by_course'),
(14, 1, 'core_calendar_get_action_events_by_courses'),
(15, 1, 'core_calendar_get_calendar_event_by_id'),
(16, 1, 'core_calendar_submit_create_update_form'),
(17, 1, 'core_calendar_get_calendar_access_information'),
(18, 1, 'core_calendar_get_allowed_event_types'),
(19, 1, 'core_calendar_get_calendar_export_token'),
(20, 1, 'core_comment_get_comments'),
(21, 1, 'core_comment_add_comments'),
(22, 1, 'core_comment_delete_comments'),
(23, 1, 'core_completion_get_activities_completion_status'),
(24, 1, 'core_completion_get_course_completion_status'),
(25, 1, 'core_completion_mark_course_self_completed'),
(26, 1, 'core_completion_update_activity_completion_status_manually'),
(27, 1, 'core_course_get_categories'),
(28, 1, 'core_course_get_contents'),
(29, 1, 'core_course_get_course_module'),
(30, 1, 'core_course_get_course_module_by_instance'),
(31, 1, 'core_course_get_courses'),
(32, 1, 'core_course_search_courses'),
(33, 1, 'core_course_view_course'),
(34, 1, 'core_course_get_user_navigation_options'),
(35, 1, 'core_course_get_user_administration_options'),
(36, 1, 'core_course_get_courses_by_field'),
(37, 1, 'core_course_check_updates'),
(38, 1, 'core_course_get_updates_since'),
(39, 1, 'core_course_get_enrolled_courses_by_timeline_classification'),
(40, 1, 'core_course_get_enrolled_courses_with_action_events_by_timeline_classification'),
(41, 1, 'core_course_get_recent_courses'),
(42, 1, 'core_course_set_favourite_courses'),
(43, 1, 'core_enrol_get_course_enrolment_methods'),
(44, 1, 'core_enrol_get_enrolled_users'),
(45, 1, 'core_enrol_search_users'),
(46, 1, 'core_enrol_get_users_courses'),
(47, 1, 'core_files_get_files'),
(48, 1, 'core_files_delete_draft_files'),
(49, 1, 'core_files_get_unused_draft_itemid'),
(50, 1, 'core_get_component_strings'),
(51, 1, 'core_grades_grader_gradingpanel_point_fetch'),
(52, 1, 'core_grades_grader_gradingpanel_point_store'),
(53, 1, 'core_grades_grader_gradingpanel_scale_fetch'),
(54, 1, 'core_grades_grader_gradingpanel_scale_store'),
(55, 1, 'core_grades_get_enrolled_users_for_search_widget'),
(56, 1, 'core_grades_get_enrolled_users_for_selector'),
(57, 1, 'core_grades_get_groups_for_search_widget'),
(58, 1, 'core_grades_get_groups_for_selector'),
(59, 1, 'core_grades_get_gradeitems'),
(60, 1, 'core_group_get_activity_allowed_groups'),
(61, 1, 'core_group_get_activity_groupmode'),
(62, 1, 'core_group_get_course_groupings'),
(63, 1, 'core_group_get_course_groups'),
(64, 1, 'core_group_get_course_user_groups'),
(65, 1, 'core_group_get_groups_for_selector'),
(66, 1, 'core_message_mute_conversations'),
(67, 1, 'core_message_unmute_conversations'),
(68, 1, 'core_message_block_user'),
(69, 1, 'core_message_get_contact_requests'),
(70, 1, 'core_message_create_contact_request'),
(71, 1, 'core_message_confirm_contact_request'),
(72, 1, 'core_message_decline_contact_request'),
(73, 1, 'core_message_get_received_contact_requests_count'),
(74, 1, 'core_message_delete_contacts'),
(75, 1, 'core_message_delete_conversations_by_id'),
(76, 1, 'core_message_delete_message'),
(77, 1, 'core_message_get_blocked_users'),
(78, 1, 'core_message_data_for_messagearea_search_messages'),
(79, 1, 'core_message_message_search_users'),
(80, 1, 'core_message_get_user_contacts'),
(81, 1, 'core_message_get_conversations'),
(82, 1, 'core_message_get_conversation'),
(83, 1, 'core_message_get_conversation_between_users'),
(84, 1, 'core_message_get_self_conversation'),
(85, 1, 'core_message_get_messages'),
(86, 1, 'core_message_get_conversation_counts'),
(87, 1, 'core_message_get_unread_conversation_counts'),
(88, 1, 'core_message_get_conversation_members'),
(89, 1, 'core_message_get_member_info'),
(90, 1, 'core_message_get_unread_conversations_count'),
(91, 1, 'core_message_mark_all_notifications_as_read'),
(92, 1, 'core_message_mark_all_conversation_messages_as_read'),
(93, 1, 'core_message_mark_message_read'),
(94, 1, 'core_message_mark_notification_read'),
(95, 1, 'core_message_message_processor_config_form'),
(96, 1, 'core_message_search_contacts'),
(97, 1, 'core_message_send_instant_messages'),
(98, 1, 'core_message_send_messages_to_conversation'),
(99, 1, 'core_message_get_conversation_messages'),
(100, 1, 'core_message_unblock_user'),
(101, 1, 'core_message_get_user_notification_preferences'),
(102, 1, 'core_message_get_user_message_preferences'),
(103, 1, 'core_message_set_favourite_conversations'),
(104, 1, 'core_message_unset_favourite_conversations'),
(105, 1, 'core_message_delete_message_for_all_users'),
(106, 1, 'core_message_get_unread_notification_count'),
(107, 1, 'core_my_view_page'),
(108, 1, 'core_notes_create_notes'),
(109, 1, 'core_notes_delete_notes'),
(110, 1, 'core_notes_get_course_notes'),
(111, 1, 'core_notes_view_notes'),
(112, 1, 'core_question_update_flag'),
(113, 1, 'core_rating_get_item_ratings'),
(114, 1, 'core_rating_add_rating'),
(115, 1, 'core_search_get_results'),
(116, 1, 'core_search_get_search_areas_list'),
(117, 1, 'core_search_view_results'),
(118, 1, 'core_search_get_top_results'),
(119, 1, 'core_tag_get_tagindex'),
(120, 1, 'core_tag_get_tagindex_per_area'),
(121, 1, 'core_tag_get_tag_areas'),
(122, 1, 'core_tag_get_tag_collections'),
(123, 1, 'core_tag_get_tag_cloud'),
(124, 1, 'core_user_add_user_device'),
(125, 1, 'core_user_update_user_device_public_key'),
(126, 1, 'core_user_add_user_private_files'),
(127, 1, 'core_user_get_course_user_profiles'),
(128, 1, 'core_user_get_users_by_field'),
(129, 1, 'core_user_remove_user_device'),
(130, 1, 'core_user_update_user_preferences'),
(131, 1, 'core_user_view_user_list'),
(132, 1, 'core_user_view_user_profile'),
(133, 1, 'core_user_get_user_preferences'),
(134, 1, 'core_user_update_picture'),
(135, 1, 'core_user_set_user_preferences'),
(136, 1, 'core_user_agree_site_policy'),
(137, 1, 'core_user_get_private_files_info'),
(138, 1, 'core_competency_competency_viewed'),
(139, 1, 'core_competency_list_course_competencies'),
(140, 1, 'core_competency_get_scale_values'),
(141, 1, 'core_competency_user_competency_viewed'),
(142, 1, 'core_competency_user_competency_viewed_in_plan'),
(143, 1, 'core_competency_user_competency_viewed_in_course'),
(144, 1, 'core_competency_user_competency_plan_viewed'),
(145, 1, 'core_competency_grade_competency_in_course'),
(146, 1, 'core_competency_delete_evidence'),
(147, 1, 'core_webservice_get_site_info'),
(148, 1, 'core_block_get_course_blocks'),
(149, 1, 'core_block_get_dashboard_blocks'),
(150, 1, 'core_block_fetch_addable_blocks'),
(151, 1, 'core_filters_get_available_in_context'),
(152, 1, 'core_h5p_get_trusted_h5p_file'),
(153, 1, 'core_table_get_dynamic_table_content'),
(154, 1, 'core_xapi_statement_post'),
(155, 1, 'core_xapi_post_state'),
(156, 1, 'core_xapi_get_state'),
(157, 1, 'core_xapi_get_states'),
(158, 1, 'core_xapi_delete_state'),
(159, 1, 'core_xapi_delete_states'),
(160, 1, 'core_reportbuilder_list_reports'),
(161, 1, 'core_reportbuilder_retrieve_report'),
(162, 1, 'core_reportbuilder_retrieve_system_report'),
(163, 1, 'core_reportbuilder_can_view_system_report'),
(164, 1, 'core_reportbuilder_view_report'),
(165, 1, 'mod_assign_get_grades'),
(166, 1, 'mod_assign_get_assignments'),
(167, 1, 'mod_assign_get_submissions'),
(168, 1, 'mod_assign_get_user_flags'),
(169, 1, 'mod_assign_set_user_flags'),
(170, 1, 'mod_assign_get_user_mappings'),
(171, 1, 'mod_assign_revert_submissions_to_draft'),
(172, 1, 'mod_assign_lock_submissions'),
(173, 1, 'mod_assign_unlock_submissions'),
(174, 1, 'mod_assign_save_submission'),
(175, 1, 'mod_assign_submit_for_grading'),
(176, 1, 'mod_assign_save_grade'),
(177, 1, 'mod_assign_save_grades'),
(178, 1, 'mod_assign_save_user_extensions'),
(179, 1, 'mod_assign_reveal_identities'),
(180, 1, 'mod_assign_view_grading_table'),
(181, 1, 'mod_assign_view_submission_status'),
(182, 1, 'mod_assign_get_submission_status'),
(183, 1, 'mod_assign_list_participants'),
(184, 1, 'mod_assign_submit_grading_form'),
(185, 1, 'mod_assign_get_participant'),
(186, 1, 'mod_assign_view_assign'),
(187, 1, 'mod_assign_start_submission'),
(188, 1, 'mod_bigbluebuttonbn_can_join'),
(189, 1, 'mod_bigbluebuttonbn_get_recordings'),
(190, 1, 'mod_bigbluebuttonbn_get_recordings_to_import'),
(191, 1, 'mod_bigbluebuttonbn_update_recording'),
(192, 1, 'mod_bigbluebuttonbn_end_meeting'),
(193, 1, 'mod_bigbluebuttonbn_completion_validate'),
(194, 1, 'mod_bigbluebuttonbn_meeting_info'),
(195, 1, 'mod_bigbluebuttonbn_get_bigbluebuttonbns_by_courses'),
(196, 1, 'mod_bigbluebuttonbn_view_bigbluebuttonbn'),
(197, 1, 'mod_bigbluebuttonbn_get_join_url'),
(198, 1, 'mod_book_view_book'),
(199, 1, 'mod_book_get_books_by_courses'),
(200, 1, 'mod_chat_login_user'),
(201, 1, 'mod_chat_get_chat_users'),
(202, 1, 'mod_chat_send_chat_message'),
(203, 1, 'mod_chat_get_chat_latest_messages'),
(204, 1, 'mod_chat_view_chat'),
(205, 1, 'mod_chat_get_chats_by_courses'),
(206, 1, 'mod_chat_get_sessions'),
(207, 1, 'mod_chat_get_session_messages'),
(208, 1, 'mod_chat_view_sessions'),
(209, 1, 'mod_choice_get_choice_results'),
(210, 1, 'mod_choice_get_choice_options'),
(211, 1, 'mod_choice_submit_choice_response'),
(212, 1, 'mod_choice_view_choice'),
(213, 1, 'mod_choice_get_choices_by_courses'),
(214, 1, 'mod_choice_delete_choice_responses'),
(215, 1, 'mod_data_get_databases_by_courses'),
(216, 1, 'mod_data_view_database'),
(217, 1, 'mod_data_get_data_access_information'),
(218, 1, 'mod_data_get_entries'),
(219, 1, 'mod_data_get_entry'),
(220, 1, 'mod_data_get_fields'),
(221, 1, 'mod_data_search_entries'),
(222, 1, 'mod_data_approve_entry'),
(223, 1, 'mod_data_delete_entry'),
(224, 1, 'mod_data_add_entry'),
(225, 1, 'mod_data_update_entry'),
(226, 1, 'mod_feedback_get_feedbacks_by_courses'),
(227, 1, 'mod_feedback_get_feedback_access_information'),
(228, 1, 'mod_feedback_view_feedback'),
(229, 1, 'mod_feedback_get_current_completed_tmp'),
(230, 1, 'mod_feedback_get_items'),
(231, 1, 'mod_feedback_launch_feedback'),
(232, 1, 'mod_feedback_get_page_items'),
(233, 1, 'mod_feedback_process_page'),
(234, 1, 'mod_feedback_get_analysis'),
(235, 1, 'mod_feedback_get_unfinished_responses'),
(236, 1, 'mod_feedback_get_finished_responses'),
(237, 1, 'mod_feedback_get_non_respondents'),
(238, 1, 'mod_feedback_get_responses_analysis'),
(239, 1, 'mod_feedback_get_last_completed'),
(240, 1, 'mod_folder_view_folder'),
(241, 1, 'mod_folder_get_folders_by_courses'),
(242, 1, 'mod_forum_get_forums_by_courses'),
(243, 1, 'mod_forum_get_discussion_posts'),
(244, 1, 'mod_forum_get_forum_discussions_paginated'),
(245, 1, 'mod_forum_get_forum_discussions'),
(246, 1, 'mod_forum_view_forum'),
(247, 1, 'mod_forum_view_forum_discussion'),
(248, 1, 'mod_forum_add_discussion_post'),
(249, 1, 'mod_forum_add_discussion'),
(250, 1, 'mod_forum_can_add_discussion'),
(251, 1, 'mod_forum_get_forum_access_information'),
(252, 1, 'mod_forum_set_subscription_state'),
(253, 1, 'mod_forum_set_lock_state'),
(254, 1, 'mod_forum_toggle_favourite_state'),
(255, 1, 'mod_forum_set_pin_state'),
(256, 1, 'mod_forum_delete_post'),
(257, 1, 'mod_forum_get_discussion_post'),
(258, 1, 'mod_forum_prepare_draft_area_for_post'),
(259, 1, 'mod_forum_update_discussion_post'),
(260, 1, 'mod_glossary_get_glossaries_by_courses'),
(261, 1, 'mod_glossary_view_glossary'),
(262, 1, 'mod_glossary_view_entry'),
(263, 1, 'mod_glossary_get_entries_by_letter'),
(264, 1, 'mod_glossary_get_entries_by_date'),
(265, 1, 'mod_glossary_get_categories'),
(266, 1, 'mod_glossary_get_entries_by_category'),
(267, 1, 'mod_glossary_get_authors'),
(268, 1, 'mod_glossary_get_entries_by_author'),
(269, 1, 'mod_glossary_get_entries_by_author_id'),
(270, 1, 'mod_glossary_get_entries_by_search'),
(271, 1, 'mod_glossary_get_entries_by_term'),
(272, 1, 'mod_glossary_get_entries_to_approve'),
(273, 1, 'mod_glossary_get_entry_by_id'),
(274, 1, 'mod_glossary_add_entry'),
(275, 1, 'mod_glossary_delete_entry'),
(276, 1, 'mod_glossary_update_entry'),
(277, 1, 'mod_glossary_prepare_entry_for_edition'),
(278, 1, 'mod_h5pactivity_get_h5pactivity_access_information'),
(279, 1, 'mod_h5pactivity_view_h5pactivity'),
(280, 1, 'mod_h5pactivity_get_attempts'),
(281, 1, 'mod_h5pactivity_get_results'),
(282, 1, 'mod_h5pactivity_get_h5pactivities_by_courses'),
(283, 1, 'mod_h5pactivity_log_report_viewed'),
(284, 1, 'mod_h5pactivity_get_user_attempts'),
(285, 1, 'mod_imscp_view_imscp'),
(286, 1, 'mod_imscp_get_imscps_by_courses'),
(287, 1, 'mod_label_get_labels_by_courses'),
(288, 1, 'mod_lesson_get_lessons_by_courses'),
(289, 1, 'mod_lesson_get_lesson_access_information'),
(290, 1, 'mod_lesson_view_lesson'),
(291, 1, 'mod_lesson_get_questions_attempts'),
(292, 1, 'mod_lesson_get_user_grade'),
(293, 1, 'mod_lesson_get_user_attempt_grade'),
(294, 1, 'mod_lesson_get_content_pages_viewed'),
(295, 1, 'mod_lesson_get_user_timers'),
(296, 1, 'mod_lesson_get_pages'),
(297, 1, 'mod_lesson_launch_attempt'),
(298, 1, 'mod_lesson_get_page_data'),
(299, 1, 'mod_lesson_process_page'),
(300, 1, 'mod_lesson_finish_attempt'),
(301, 1, 'mod_lesson_get_attempts_overview'),
(302, 1, 'mod_lesson_get_user_attempt'),
(303, 1, 'mod_lesson_get_pages_possible_jumps'),
(304, 1, 'mod_lesson_get_lesson'),
(305, 1, 'mod_lti_get_tool_launch_data'),
(306, 1, 'mod_lti_get_ltis_by_courses'),
(307, 1, 'mod_lti_view_lti'),
(308, 1, 'mod_page_view_page'),
(309, 1, 'mod_page_get_pages_by_courses'),
(310, 1, 'mod_quiz_get_quizzes_by_courses'),
(311, 1, 'mod_quiz_view_quiz'),
(312, 1, 'mod_quiz_get_user_attempts'),
(313, 1, 'mod_quiz_get_user_best_grade'),
(314, 1, 'mod_quiz_get_combined_review_options'),
(315, 1, 'mod_quiz_start_attempt'),
(316, 1, 'mod_quiz_get_attempt_data'),
(317, 1, 'mod_quiz_get_attempt_summary'),
(318, 1, 'mod_quiz_save_attempt'),
(319, 1, 'mod_quiz_process_attempt'),
(320, 1, 'mod_quiz_get_attempt_review'),
(321, 1, 'mod_quiz_view_attempt'),
(322, 1, 'mod_quiz_view_attempt_summary'),
(323, 1, 'mod_quiz_view_attempt_review'),
(324, 1, 'mod_quiz_get_quiz_feedback_for_grade'),
(325, 1, 'mod_quiz_get_quiz_access_information'),
(326, 1, 'mod_quiz_get_attempt_access_information'),
(327, 1, 'mod_quiz_get_quiz_required_qtypes'),
(328, 1, 'mod_resource_view_resource'),
(329, 1, 'mod_resource_get_resources_by_courses'),
(330, 1, 'mod_scorm_view_scorm'),
(331, 1, 'mod_scorm_get_scorm_attempt_count'),
(332, 1, 'mod_scorm_get_scorm_scoes'),
(333, 1, 'mod_scorm_get_scorm_user_data'),
(334, 1, 'mod_scorm_insert_scorm_tracks'),
(335, 1, 'mod_scorm_get_scorm_sco_tracks'),
(336, 1, 'mod_scorm_get_scorms_by_courses'),
(337, 1, 'mod_scorm_launch_sco'),
(338, 1, 'mod_scorm_get_scorm_access_information'),
(339, 1, 'mod_survey_get_surveys_by_courses'),
(340, 1, 'mod_survey_view_survey'),
(341, 1, 'mod_survey_get_questions'),
(342, 1, 'mod_survey_submit_answers'),
(343, 1, 'mod_url_view_url'),
(344, 1, 'mod_url_get_urls_by_courses'),
(345, 1, 'mod_wiki_get_wikis_by_courses'),
(346, 1, 'mod_wiki_view_wiki'),
(347, 1, 'mod_wiki_view_page'),
(348, 1, 'mod_wiki_get_subwikis'),
(349, 1, 'mod_wiki_get_subwiki_pages'),
(350, 1, 'mod_wiki_get_subwiki_files'),
(351, 1, 'mod_wiki_get_page_contents'),
(352, 1, 'mod_wiki_get_page_for_editing'),
(353, 1, 'mod_wiki_new_page'),
(354, 1, 'mod_wiki_edit_page'),
(355, 1, 'mod_workshop_get_workshops_by_courses'),
(356, 1, 'mod_workshop_get_workshop_access_information'),
(357, 1, 'mod_workshop_get_user_plan'),
(358, 1, 'mod_workshop_view_workshop'),
(359, 1, 'mod_workshop_add_submission'),
(360, 1, 'mod_workshop_update_submission'),
(361, 1, 'mod_workshop_delete_submission'),
(362, 1, 'mod_workshop_get_submissions'),
(363, 1, 'mod_workshop_get_submission'),
(364, 1, 'mod_workshop_get_submission_assessments'),
(365, 1, 'mod_workshop_get_assessment'),
(366, 1, 'mod_workshop_get_assessment_form_definition'),
(367, 1, 'mod_workshop_get_reviewer_assessments'),
(368, 1, 'mod_workshop_update_assessment'),
(369, 1, 'mod_workshop_get_grades'),
(370, 1, 'mod_workshop_evaluate_assessment'),
(371, 1, 'mod_workshop_get_grades_report'),
(372, 1, 'mod_workshop_view_submission'),
(373, 1, 'mod_workshop_evaluate_submission'),
(374, 1, 'enrol_guest_get_instance_info'),
(375, 1, 'enrol_guest_validate_password'),
(376, 1, 'enrol_self_get_instance_info'),
(377, 1, 'enrol_self_enrol_user'),
(378, 1, 'message_airnotifier_is_system_configured'),
(379, 1, 'message_airnotifier_are_notification_preferences_configured'),
(380, 1, 'message_airnotifier_get_user_devices'),
(381, 1, 'message_airnotifier_enable_device'),
(382, 1, 'message_popup_get_popup_notifications'),
(383, 1, 'message_popup_get_unread_popup_notification_count'),
(384, 1, 'block_recentlyaccesseditems_get_recent_items'),
(385, 1, 'block_starredcourses_get_starred_courses'),
(386, 1, 'report_insights_set_notuseful_prediction'),
(387, 1, 'report_insights_set_fixed_prediction'),
(388, 1, 'report_insights_action_executed'),
(389, 1, 'gradereport_grader_get_users_in_report'),
(390, 1, 'gradereport_overview_get_course_grades'),
(391, 1, 'gradereport_overview_view_grade_report'),
(392, 1, 'gradereport_singleview_get_grade_items_for_search_widget'),
(393, 1, 'gradereport_user_get_grades_table'),
(394, 1, 'gradereport_user_view_grade_report'),
(395, 1, 'gradereport_user_get_grade_items'),
(396, 1, 'gradereport_user_get_access_information'),
(397, 1, 'tool_analytics_potential_contexts'),
(398, 1, 'tool_lp_data_for_course_competencies_page'),
(399, 1, 'tool_lp_data_for_plans_page'),
(400, 1, 'tool_lp_data_for_plan_page'),
(401, 1, 'tool_lp_data_for_user_evidence_list_page'),
(402, 1, 'tool_lp_data_for_user_evidence_page'),
(403, 1, 'tool_lp_data_for_user_competency_summary'),
(404, 1, 'tool_lp_data_for_user_competency_summary_in_plan'),
(405, 1, 'tool_lp_data_for_user_competency_summary_in_course'),
(406, 1, 'tool_mobile_get_plugins_supporting_mobile'),
(407, 1, 'tool_mobile_get_public_config'),
(408, 1, 'tool_mobile_get_config'),
(409, 1, 'tool_mobile_get_autologin_key'),
(410, 1, 'tool_mobile_get_content'),
(411, 1, 'tool_mobile_call_external_functions'),
(412, 1, 'tool_mobile_validate_subscription_key'),
(413, 1, 'tool_mobile_get_tokens_for_qr_login'),
(414, 1, 'tool_moodlenet_verify_webfinger'),
(415, 1, 'tool_moodlenet_search_courses');

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_external_services_users`
--

CREATE TABLE `mdlxd_external_services_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `iprestriction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `validuntil` bigint DEFAULT NULL,
  `timecreated` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_exteservuser_ext_ix` (`externalserviceid`),
  KEY `mdlxd_exteservuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='users allowed to use services with restricted users flag';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_external_tokens`
--

CREATE TABLE `mdlxd_external_tokens` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `token` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `privatetoken` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `tokentype` smallint NOT NULL,
  `userid` bigint NOT NULL,
  `externalserviceid` bigint NOT NULL,
  `sid` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `contextid` bigint NOT NULL,
  `creatorid` bigint NOT NULL DEFAULT '1',
  `iprestriction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `validuntil` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `lastaccess` bigint DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdlxd_extetoke_tok_ix` (`token`),
  KEY `mdlxd_extetoke_sid_ix` (`sid`),
  KEY `mdlxd_extetoke_use_ix` (`userid`),
  KEY `mdlxd_extetoke_ext_ix` (`externalserviceid`),
  KEY `mdlxd_extetoke_con_ix` (`contextid`),
  KEY `mdlxd_extetoke_cre_ix` (`creatorid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Security tokens for accessing of external services';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_favourite`
--

CREATE TABLE `mdlxd_favourite` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `itemtype` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `contextid` bigint NOT NULL,
  `userid` bigint NOT NULL,
  `ordering` bigint DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_favo_comiteiteconuse_uix` (`component`,`itemtype`,`itemid`,`contextid`,`userid`),
  KEY `mdlxd_favo_con_ix` (`contextid`),
  KEY `mdlxd_favo_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the relationship between an arbitrary item (itemtype,';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_feedback`
--

CREATE TABLE `mdlxd_feedback` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `intro` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `introformat` smallint NOT NULL DEFAULT '0',
  `anonymous` tinyint(1) NOT NULL DEFAULT '1',
  `email_notification` tinyint(1) NOT NULL DEFAULT '1',
  `multiple_submit` tinyint(1) NOT NULL DEFAULT '1',
  `autonumbering` tinyint(1) NOT NULL DEFAULT '1',
  `site_after_submit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `page_after_submit` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `page_after_submitformat` tinyint NOT NULL DEFAULT '0',
  `publish_stats` tinyint(1) NOT NULL DEFAULT '0',
  `timeopen` bigint NOT NULL DEFAULT '0',
  `timeclose` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_feed_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='all feedbacks';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_feedback_completed`
--

CREATE TABLE `mdlxd_feedback_completed` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `feedback` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `random_response` bigint NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_feedcomp_use_ix` (`userid`),
  KEY `mdlxd_feedcomp_fee_ix` (`feedback`),
  KEY `mdlxd_feedcomp_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='filled out feedback';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_feedback_completedtmp`
--

CREATE TABLE `mdlxd_feedback_completedtmp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `feedback` bigint NOT NULL DEFAULT '0',
  `userid` bigint NOT NULL DEFAULT '0',
  `guestid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `timemodified` bigint NOT NULL DEFAULT '0',
  `random_response` bigint NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_feedcomp_use2_ix` (`userid`),
  KEY `mdlxd_feedcomp_fee2_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='filled out feedback';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_feedback_item`
--

CREATE TABLE `mdlxd_feedback_item` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `feedback` bigint NOT NULL DEFAULT '0',
  `template` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `presentation` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `typ` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `hasvalue` tinyint(1) NOT NULL DEFAULT '0',
  `position` smallint NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `dependitem` bigint NOT NULL DEFAULT '0',
  `dependvalue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `options` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdlxd_feeditem_fee_ix` (`feedback`),
  KEY `mdlxd_feeditem_tem_ix` (`template`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='feedback_items';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_feedback_sitecourse_map`
--

CREATE TABLE `mdlxd_feedback_sitecourse_map` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `feedbackid` bigint NOT NULL DEFAULT '0',
  `courseid` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdlxd_feedsitemap_cou_ix` (`courseid`),
  KEY `mdlxd_feedsitemap_fee_ix` (`feedbackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='feedback sitecourse map';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_feedback_template`
--

CREATE TABLE `mdlxd_feedback_template` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course` bigint NOT NULL DEFAULT '0',
  `ispublic` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdlxd_feedtemp_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='templates of feedbackstructures';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_feedback_value`
--

CREATE TABLE `mdlxd_feedback_value` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course_id` bigint NOT NULL DEFAULT '0',
  `item` bigint NOT NULL DEFAULT '0',
  `completed` bigint NOT NULL DEFAULT '0',
  `tmp_completed` bigint NOT NULL DEFAULT '0',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_feedvalu_comitecou_uix` (`completed`,`item`,`course_id`),
  KEY `mdlxd_feedvalu_cou_ix` (`course_id`),
  KEY `mdlxd_feedvalu_ite_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='values of the completeds';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_feedback_valuetmp`
--

CREATE TABLE `mdlxd_feedback_valuetmp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `course_id` bigint NOT NULL DEFAULT '0',
  `item` bigint NOT NULL DEFAULT '0',
  `completed` bigint NOT NULL DEFAULT '0',
  `tmp_completed` bigint NOT NULL DEFAULT '0',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_feedvalu_comitecou2_uix` (`completed`,`item`,`course_id`),
  KEY `mdlxd_feedvalu_cou2_ix` (`course_id`),
  KEY `mdlxd_feedvalu_ite2_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='values of the completedstmp';

-- --------------------------------------------------------

--
-- Table structure for table `mdlxd_files`
--

CREATE TABLE `mdlxd_files` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `contenthash` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `pathnamehash` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `contextid` bigint NOT NULL,
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `filearea` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `itemid` bigint NOT NULL,
  `filepath` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `filename` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `userid` bigint DEFAULT NULL,
  `filesize` bigint NOT NULL,
  `mimetype` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` bigint NOT NULL DEFAULT '0',
  `source` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `author` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `license` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `timecreated` bigint NOT NULL,
  `timemodified` bigint NOT NULL,
  `sortorder` bigint NOT NULL DEFAULT '0',
  `referencefileid` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdlxd_file_pat_uix` (`pathnamehash`),
  KEY `mdlxd_file_comfilconite_ix` (`component`,`filearea`,`contextid`,`itemid`),
  KEY `mdlxd_file_con_ix` (`contenthash`),
  KEY `mdlxd_file_lic_ix` (`license`),
  KEY `mdlxd_file_fil_ix` (`filename`),
  KEY `mdlxd_file_con2_ix` (`contextid`),
  KEY `mdlxd_file_use_ix` (`userid`),
  KEY `mdlxd_file_ref_ix` (`referencefileid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=COMPRESSED COMMENT='description of files, content is stored in sha1 file pool';

--
-- Dumping data for table `mdlxd_files`
--

INSERT INTO `mdlxd_files` VALUES
(1, '5f8e911d0da441e36f47c5c46f4393269211ca56', '508e674d49c30d4fde325fe6c7f6fd3d56b247e1', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'smile.png', 2, 1085, 'image/png', 0, NULL, NULL, NULL, 1698644927, 1698644927, 0, NULL),
(2, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '70b7cdade7b4e27d4e83f0cdaad10d6a3c0cccb5', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, 1698644927, 1698644927, 0, NULL),
(3, '75c101cb8cb34ea573cd25ac38f8157b1de901b8', '68317eab56c67d32aeaee5acf509a0c4aa828b6b', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'sad.png', 2, 966, 'image/png', 0, NULL, NULL, NULL, 1698644927, 1698644927, 0, NULL),
(4, '0c5190a24c3943966541401c883eacaa20ca20cb', '695a55ff780e61c9e59428aa425430b0d6bde53b', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'tick.png', 2, 1039, 'image/png', 0, NULL, NULL, NULL, 1698644927, 1698644927, 0, NULL),
(5, '8c96a486d5801e0f4ab8c411f561f1c687e1f865', '373e63af262a9b8466ba8632551520be793c37ff', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'cross.png', 2, 861, 'image/png', 0, NULL, NULL, NULL, 1698644927, 1698644927, 0, NULL),
(10, 'bc9a4feda7b7bd5b880a3ae649fcd7a63ecd0906', 'b3865119ac3994995ccc2bea8339050e3c3cf7f8', 1, 'core', 'preview', 0, '/thumb/', '49ff4394e6c6631d9968eff79ea6098544f140e8', NULL, 10472, 'image/png', 0, NULL, NULL, NULL, 1698645396, 1698645396, 0, NULL),
(11, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '74c104d54c05b5f8c633a36da516d37e6c5279e4', 1, 'core', 'preview', 0, '/thumb/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698645396, 1698645396, 0, NULL),
(12, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '884555719c50529b9df662a38619d04b5b11e25c', 1, 'core', 'preview', 0, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698645396, 1698645396, 0, NULL),
(15, '74e0f6dbb7d259067f1c59e166b8fcb4b1eab200', '17a6d1d3394001e8f8520edbed39d5a87ef25437', 1, 'core', 'preview', 0, '/thumb/', '13596084d2a0f8bb876a6f86a9fe936d3e58b26e', NULL, 11688, 'image/png', 0, NULL, NULL, NULL, 1698645457, 1698645457, 0, NULL),
(18, '49ff4394e6c6631d9968eff79ea6098544f140e8', 'ba1daef79e33052244748ce73de26401e2d9723e', 1, 'theme_boosted', 'favicon', 0, '/', 'WhatsApp_Image_2023-10-24_at_9.16.09_AM-removebg-preview.png', 2, 174129, 'image/png', 0, 'WhatsApp_Image_2023-10-24_at_9.16.09_AM-removebg-preview.png', 'Foresite Technology', 'unknown', 1698645395, 1698645517, 0, NULL),
(19, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'cfcf8a151cb90a28994cd26b72b5ffda1a189747', 1, 'theme_boosted', 'favicon', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, 1698645395, 1698730072, 0, NULL),
(20, '13596084d2a0f8bb876a6f86a9fe936d3e58b26e', '83a9788122f9617eafc637faf74ea0427a58d707', 1, 'theme_boosted', 'backgroundimage', 0, '/', 'pexels-andrea-piacquadio-3762800.jpg', 2, 966967, 'image/jpeg', 0, 'pexels-andrea-piacquadio-3762800.jpg', 'Foresite Technology', 'unknown', 1698645455, 1698645517, 0, NULL),
(21, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'e4aa2591b64536c96e6e9ff828a69db7a0c54c94', 1, 'theme_boosted', 'backgroundimage', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, 1698645455, 1698730072, 0, NULL),
(22, '13596084d2a0f8bb876a6f86a9fe936d3e58b26e', '5b1bf6b495ca57e8aa6e8332c4d26f7bc7a9c9e5', 1, 'theme_boosted', 'loginbackgroundimage', 0, '/', 'pexels-andrea-piacquadio-3762800.jpg', 2, 966967, 'image/jpeg', 0, 'pexels-andrea-piacquadio-3762800.jpg', 'Foresite Technology', 'unknown', 1698645496, 1698645517, 0, NULL),
(23, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '80b7db965e2fe03f8831a15cd727e41afee3bc05', 1, 'theme_boosted', 'loginbackgroundimage', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, 1698645496, 1698730072, 0, NULL),
(26, 'c78bc179624cadbe1e1b9d6a50b9a56f5643934a', '48f01dff213032dfc7d7b83d2cb5752cc96adf97', 1, 'core', 'preview', 0, '/thumb/', 'a58cb050d22f0b302d72f06c207c9e07ea6b23be', NULL, 14723, 'image/png', 0, NULL, NULL, NULL, 1698729617, 1698729617, 0, NULL),
(27, 'a58cb050d22f0b302d72f06c207c9e07ea6b23be', '5a0f74d68d5af974c4370458b1460493f345dd5d', 16, 'course', 'overviewfiles', 0, '/', 'about us 1.jpg', 2, 161593, 'image/jpeg', 0, 'about us 1.jpg', 'Foresite Technology', 'unknown', 1698729616, 1698729643, 0, NULL),
(28, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'caacb460889d8099985521622526ef756a9f08a8', 16, 'course', 'overviewfiles', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, 1698729616, 1698729884, 0, NULL),
(33, 'b8157cf56776ddcf60a045fd762c638efd4feca2', 'c45e145300a34300cafa3d58ad5ad72f467f0f9e', 1, 'core', 'preview', 0, '/thumb/', 'e33cebda3080c2223357713f4c251c87c6283057', NULL, 3534, 'image/png', 0, NULL, NULL, NULL, 1698729801, 1698729801, 0, NULL),
(34, 'e33cebda3080c2223357713f4c251c87c6283057', '8c3cb94ceb7ab9841580e152039524d08e9750ad', 19, 'course', 'overviewfiles', 0, '/', '08-17-20_hybrid-car.png', 2, 14654, 'image/png', 0, '08-17-20_hybrid-car.png', 'Foresite Technology', 'unknown', 1698729799, 1698729820, 0, NULL),
(35, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'a3da9056f2ee40dea86843f575d3c9a167b9862a', 19, 'course', 'overviewfiles', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, 1698729799, 1698729820, 0, NULL),
(76, '0fe9de50701b98e44d2220933e71588a0dcae114', '2f4888ba1bd5d691b2cbda3c8921cafde5079a43', 21, 'mod_resource', 'content', 0, '/', 'Certificate in Social Media Marketing.docx.pdf', 2, 256052, 'application/pdf', 0, 'Certificate in Social Media Marketing.docx.pdf', 'Foresite Technology', 'unknown', 1698730316, 1698730323, 1, NULL),
(77, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '2bcced7dcce6b96fb96c1638b2da698c7c2c3217', 21, 'mod_resource', 'content', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, 1698730316, 1698730323, 0, NULL),
(88, '38070d0ee32d61168d26d7445e3b35b85810566f', '05d4ff2b98a51a5bb66b38806aa993d19e1b7d9e', 22, 'mod_resource', 'content', 0, '/', '_Certificate in Hybrid Electrical Vehicle Servicing.pdf', 2, 73083, 'application/pdf', 0, '_Certificate in Hybrid Electrical Vehicle Servicing.pdf', 'Foresite Technology', 'unknown', 1698730491, 1698730496, 1, NULL),
(89, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'e75af4038fbce5408eb20ae9d0028c4838c82013', 22, 'mod_resource', 'content', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, 1698730491, 1698730496, 0, NULL),
(91, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'a5b5759d18b676a692c4a0382fb0ebc3c0768576', 1, 'core_h5p', 'library_sources', 0, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(92, '638c652d623280a58144f93e7b552c66d1667a11', '02d9edad8b866c1b7a955e39e8d0bd6bc9dd7da4', 1, 'core_h5p', 'libraries', 1, '/FontAwesome-4.5/', 'fontawesome-webfont.woff2', NULL, 66624, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(93, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '56178ff85cd31c58d868552b7301dbe01fa24c8c', 1, 'core_h5p', 'libraries', 1, '/FontAwesome-4.5/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(94, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8bca203021aa09ca18174e18029a87a9f7fb07ea', 1, 'core_h5p', 'libraries', 1, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(95, '7d4ae573efb74117cffcd645bfeaf1a5c47f2f0f', '8baf925bf318cf793cfc0d350e0674e8884c4653', 1, 'core_h5p', 'libraries', 1, '/FontAwesome-4.5/', 'h5p-font-awesome.min.css', NULL, 27420, 'text/css', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(96, '986eed8dca049714e43eeebcb3932741a4bec76d', 'b696370de254ec70a539fd4d0040c16fc4519b55', 1, 'core_h5p', 'libraries', 1, '/FontAwesome-4.5/', 'fontawesome-webfont.eot', NULL, 70807, 'document/unknown', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(97, '81f03a8f024fdef0889f286ca8a0f6a7dbef744b', '9dcd9bbe860b4d9d0307865b1e13e52d57a1b00b', 1, 'core_h5p', 'libraries', 1, '/FontAwesome-4.5/', 'library.json', NULL, 290, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(98, '4a313eb93b959cc4154c684b915b0a31ddb68d84', 'ac5401f6eff55ae1c975edb860b023544e422191', 1, 'core_h5p', 'libraries', 1, '/FontAwesome-4.5/', 'fontawesome-webfont.woff', NULL, 83588, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(99, '42c179eef588854b5ec151bcf6a3f58aa8b79b11', '6274fdfe6691e0ccd9ca4c1eadc049bf823bb66e', 1, 'core_h5p', 'libraries', 1, '/FontAwesome-4.5/', 'FontAwesome.otf', NULL, 109688, 'document/unknown', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(100, '6484f1af6b485d5096b71b344e67f4164c33dd1f', 'a889bde43d5a98e8bf35e822109e07b2c116fe8d', 1, 'core_h5p', 'libraries', 1, '/FontAwesome-4.5/', 'fontawesome-webfont.ttf', NULL, 142072, 'document/unknown', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(101, 'b06b5c8f67fd632cdc62a33b62ae4f74194131b3', '41680fdab472c45e5ca6f4f1654895d56a2e5d69', 1, 'core_h5p', 'libraries', 1, '/FontAwesome-4.5/', 'fontawesome-webfont.svg', NULL, 365616, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(102, '266ed697d7410c75f47eca788f98f8dbf6ec0818', '45b9d792bb742023c7e10104d1680b9d6dc8830e', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/', 'h5p-accordion.js', NULL, 7928, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(103, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '85d683fa9ceb72ac4c9dd6cfd604474411d20125', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(104, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'aa8de241385cb92312c65ef431e575525a259cb6', 1, 'core_h5p', 'libraries', 2, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(105, '149fa7cb8414ab48508886f68b12ed2a5ce3f229', '211db407d47d1a888a5983e5199133d39c4ac872', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'el.json', NULL, 1235, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(106, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '13121e93ed236c2e34012650a876ee1ac0a2d01b', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(107, '73b72f90a26795421fe748d05cc13c968abc6771', '3b660f3e6d1b43a694c8e7406cc22e44262d2a03', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'sw.json', NULL, 838, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(108, 'cc4d898ec287129dc4427216ac373b59fa687860', 'e68089c7eb82efe9fc361be673b59278a3ca8e08', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'da.json', NULL, 768, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(109, '0f1d4711c0ebab10961826140044842b906d4080', '34d056cc767e9b3c055f55eef1c258f03e176400', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'sl.json', NULL, 803, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(110, '89fd223dd75eac780e6344e2c2c837c60b3be1f4', 'ae76f03c9f64218da4f0ff388a1f0b5e1ba986e5', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'te.json', NULL, 1297, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(111, '51bb6ec4b14315932239ac4883a681504b201cc2', '5fc860dc8bd554751a4761633e8515b104a84cde', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'it.json', NULL, 891, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(112, '3c041dd1fc49e8c8ad841de029953552ef4eddff', 'f18491255b59880b805ae7bfc3081b62725c43eb', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'lt.json', NULL, 838, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(113, '35470cf75f417d5672d2f8a68affc6709e060b81', '9b67698c418b9ee39d4c9a03b488227d94ef76b6', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'lv.json', NULL, 789, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(114, '0164270cb87c5718e7cddfad5264a0dd777d2080', '15e78751338964afd980cec9f67c34367975932c', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'th.json', NULL, 1202, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(115, 'ae64ac3f911031090f81c754cb9e3d63fe2a8e40', '43f34b81432058169b2d9c7bc5512b9899766655', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'eu.json', NULL, 802, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(116, 'cf47554466f2472fb90e594559188ad6667488f3', 'c0d78ac496938dc42a9ebe92b6f234554e40de5a', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'bg.json', NULL, 1049, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(117, 'cc4d898ec287129dc4427216ac373b59fa687860', '3e2d74488cba7ce4799138343fb1ebb4bfbd84cf', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'bs.json', NULL, 768, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(118, '77abf612e6a5f0f7d817a7c17e09e9b6ab439c86', 'df78a238d9297742f6eb25fcf5dc35682053ec8c', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'ja.json', NULL, 920, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(119, '8654172c83b65d943c5080c1440502841febfa60', '57524535123b796de4d658e7ea62acda6644cf15', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'gl.json', NULL, 800, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(120, '9bfb05aa3f6ec8e3fbd3b609f3dd338f1154f435', '62f2cbe958a3f8791fda9dfae24c2b5e383eeff9', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'fr.json', NULL, 852, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(121, 'd204061266b05f4b15252ede3d750462707ce5a2', '43565b6cf2bf8188295ea5501d80426c9d9d8bc8', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'sv.json', NULL, 834, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(122, 'a33818c622db10e61bf80561416d6034ed57e676', 'cebe6094d0ea26b9d32a44e4c111be2b74e2f1ca', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'cs.json', NULL, 771, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(123, '3a5eb47fa1dc53bf3f0a8d3f35a790f8b3822bb2', '34cb4401f28fe6b2cefffad965bed95fbed05b7d', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'sme.json', NULL, 784, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(124, 'ee442815465c052daafc445138a55c285226be53', '1ed2c0d7d68d56f24e1550b0c9b7e524184e6d8a', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'af.json', NULL, 815, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(125, '797953fdad675d206c07e71a551e9ad3be544832', 'd32ba20cc44ec453e337423236fde2d4731acdab', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'uk.json', NULL, 1198, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(126, '6b4fb5723d707a0581e9318e829861cdf25ca8b5', '4b08d098c855b677f499c2a3119ed947da18b87d', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'zh-hans.json', NULL, 778, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(127, '59964cdfa4c022c9a54170a05afaa4ff58e481ac', '2fc29e421e182ee1f1a4079a0aebae561bd9d92e', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'es.json', NULL, 821, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(128, 'aed2f2917344aebb1e9aa32b7d246d534a638fcf', 'b2f99b9a4b607277ea24875ec6212c7df9c361e4', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'fa.json', NULL, 1048, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(129, '9807af0d5e5a9f6f3a2f46d2c62ceb50deb2c22b', '78ad84c8a0aeb9fa6b731f6e38256dd16d61e7b8', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'zh-cn.json', NULL, 763, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(130, '81c3020422afebdcce170a761fa25e4417b9ee76', '547d0cb75da4677ecc087e6c64b424c03bb542a5', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'sr.json', NULL, 971, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(131, '7f95b63363356583a49e3a805b53051111303197', '303494126c1321d3fdaa245178c45f98e4becf3d', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'he.json', NULL, 805, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(132, '9a1229d9adfe3b5451f2689995ea3c0a57e42da7', '169571da6f3186ae2ca98aae21b548013527e17a', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'pl.json', NULL, 789, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(133, '4a1c27152d38a7c0f307400eee1cf4884351d488', '14da775f4c619ea701ba5eefa249e264a1feb386', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'ar.json', NULL, 980, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(134, 'cc4d898ec287129dc4427216ac373b59fa687860', 'd9e3c273661d07a42f80708ab2ccecb739202efb', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'ro.json', NULL, 768, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(135, 'cc4d898ec287129dc4427216ac373b59fa687860', '252b9e8c00c6c56ffd66555b898646c9d96b31ea', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'hu.json', NULL, 768, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(136, 'f1acdc46820f29dd42b171c9cd754ba8153d94d1', '429c1ceadd11a1255c7399df7cf5c883bc5a16e1', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'zh-hant.json', NULL, 780, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(137, '1c3f8c78e1163fa2a958a0751fb39134cfbe7c70', '24d165c6428bcf41678ced622e0213dcfa50d03e', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'ka.json', NULL, 1625, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(138, '8d5da2402f301954e42d7380c4ddaf88dbba3522', 'e552498f9fbec7ffc96d165c99b5c480796016f5', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'pt.json', NULL, 810, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(139, 'e42d13b28265d0299294ce3ad3e48873fa8235a7', '384e7859fcc4864db7206f06be27fe7fa740335b', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'ca.json', NULL, 880, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(140, '59964cdfa4c022c9a54170a05afaa4ff58e481ac', '02d7116c81753d20940bf93116787289775e82da', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'es-mx.json', NULL, 821, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(141, '2adfcf23159810997c515190f9627439e7663a0f', '8a5f5185a76b906a5398de95daedc7ebde142593', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'ru.json', NULL, 1202, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(142, 'a951ae9b60046a0118565889a2b3e92417ec3a4c', '0c872f99d96b2e9503ac1f84a1f6abd71558fa6b', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'tr.json', NULL, 833, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(143, 'cc6cb16fa875b0752db7e61b7bb192c0a0c631dd', 'f6f0f46b4d38b45f90d597516a9b82d72a600782', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'pt-br.json', NULL, 813, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(144, '3a5eb47fa1dc53bf3f0a8d3f35a790f8b3822bb2', '128bdc181833a01a95e381f7390ee75a1ccccb5b', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'sma.json', NULL, 784, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(145, '133d290df0a57241608919950938bf0763f67ff4', '478db2e15a736010d65f5c92beab74438f0668a5', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'et.json', NULL, 774, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(146, '862d4d80102492c78c9a1c9ca560981fd03dd071', '43d70f7f2fab28588eed5c6acf2afda4282f707a', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'fi.json', NULL, 780, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(147, '6e2288ff73b30db17c93c3c3e24014eb43dfbe99', '6a0204f711e7798f8d757955f45359c3ffdb6fb9', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'vi.json', NULL, 805, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(148, 'cc4d898ec287129dc4427216ac373b59fa687860', '35e8ea5de3d405635a48186b0ed091b9cc5e273b', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'nn.json', NULL, 768, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(149, '3a5eb47fa1dc53bf3f0a8d3f35a790f8b3822bb2', '116031c5aa37414e3621a54f8e1b4834ef3c462d', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'smj.json', NULL, 784, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(150, '39a7276a64dd32b2e9c3b31ca3cb782b88a8c490', 'f37a7834b9306c7fd16182e1231166c2d2bfb775', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'nl.json', NULL, 856, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(151, '65ef8fc3a9f7c7fb7b8e1277bd07c8e5932de9e5', '2cf1e1499910bfb4b3c50168c69417fd301906aa', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'ko.json', NULL, 848, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(152, '57c10f6a096f403931cf8e90922dce5c220047f6', 'ded78bbb9daaebe850945e64a9af3c2aa2f6debe', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'nb.json', NULL, 831, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(153, 'bf10b5cc2ac916418600b40f9af5881b4be80188', 'ae71d7dd286bec8a73d6ed7b25b8d0973c8db464', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'de.json', NULL, 887, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(154, '261f0a5b0ac7c41bc8eb4b41d20b7c5d5f9aa299', '04b98c73aecbd85bd0417923f85117a0b7874d48', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/language/', 'mn.json', NULL, 984, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(155, 'ffe248cae4f4d96e6eba785f4a40e1b9e6c77bcd', '1df53b0a597d9220af5729fa31d70a1efe07e5cc', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/', 'icon.svg', NULL, 2453, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(156, 'bc421dca627fa9a0b615356e10d41114b8fc7aed', '5e4e934397470c0bc52bf19b4018c010d026c96d', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/', 'library.json', NULL, 574, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(157, '4594eea8e3ab5f30ddba142e1aafb69f33c2230f', '820304a745ebfb9e552e4ac97738ffa7047bc875', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/', 'h5p-accordion.css', NULL, 1551, 'text/css', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(158, 'b7aef541088715684b49a5751ad4d140842d8016', '8ee1d917a3da21f3f63bf9a56d725b6ca2e27293', 1, 'core_h5p', 'libraries', 2, '/H5P.Accordion-1.0/', 'semantics.json', NULL, 1253, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(159, '19386a3f3cfd291ec1d7514192afb915f64c196e', 'b24bc847c0100ce0c13dd3149815530f32b5bb7c', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/', 'text.js', NULL, 892, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(160, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '1ece9ea9d98a86096da49bf21cbec4ea1b6a4414', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(161, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '99cef98b6b23a457a6c222a981b822003cd31184', 1, 'core_h5p', 'libraries', 3, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(162, 'ab6311355eea09473732e326681fb7c16d53f251', '0c55dfc345563c5e22cbaaa6985df440fe706ac3', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'el.json', NULL, 67, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(163, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8d6312ab204c79d8387beef46383591dd6d89370', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(164, '7324e2f721d2de3b503f7636e0a32aa8a9d9678e', 'c562b9e48becfae012eb9b8c0e0c75ffd5939d1c', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'sw.json', NULL, 64, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(165, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', 'f17ab7f999519ed4723989c02c93f5e3bbad8a73', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'da.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(166, 'e2adbd51e27fe6ecca94f77a29dcf6593c4dfe79', 'ec749be89b2f45560cf39869cb9501dc1758640f', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'sl.json', NULL, 63, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(167, '1fe4609f60f7a539ee7e629e1d7607573e06cb52', '4f81d599c1beea894f5ffd684a6a8bf3ebe9fde6', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'te.json', NULL, 79, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(168, '8d9bd343f08b3d161a6005ebbc32ef5823e3299f', '49c18f3334cf87676737f5ce58508b2ec09a7419', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'it.json', NULL, 57, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(169, 'e328a2543fa5527649bfad9f9beca6a7b1a84a6b', '6212a53ef9653b82e60a99aa3dc733db674d0662', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'lt.json', NULL, 62, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(170, 'b40b362062ecf0d1929e5d739b63378c539c66d9', '26c0fc36691e7135cc9aaba3241897aa1455dcb9', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'lv.json', NULL, 61, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(171, '1c67884a30269595013670ae2c6e7e807c92d435', '3b377a4a27c802642e41e4df383c9f6f6aad4e2d', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'th.json', NULL, 76, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(172, '30405578c9383a49431189a6e4176897d4ad6908', '30eca240bddeeebb6a569a77679bb1c899c1096a', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'eu.json', NULL, 61, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(173, 'bc003373a3aa3491af7d9779e3397f547a4dee75', '8f7136d59cf2ec49ab63fab809c046c1348e9774', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'bg.json', NULL, 70, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(174, '349c9521a23e6bfcbe64f2f421f499e5b4b43051', 'b47133cbb7f875707401034df02b5ac7c1ba1516', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'ja.json', NULL, 64, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(175, '6bcee9b671dc19cdc90b30fcd712e03f3d32efcd', '0cc2aef2216c0f9ba69d91a3f3e8f5d063cf6be1', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'km.json', NULL, 73, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(176, '3ef75005626aeb0e05fe60d28d43659bb0c8276c', 'a345c52e8b5ff37681523869eaa5a071fc0ee0b1', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'gl.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(177, '32c2780340015be28decbf6ae560b29a0ab57c43', 'd295959a3bd8d584698fe40c156eff37ca1343de', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'fr.json', NULL, 57, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(178, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '89a02b4b0df4004648d095d0de147473911977ad', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'sv.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(179, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '6b1cba3ece6e5e96afc9463b1347e8616c9be1d3', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'cs.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(180, '67df1191437b37ac9fad77bb73c1abb0f35b22b6', '5b41c994053774ac19812db20f1d2cc91efdd6ef', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'sme.json', NULL, 59, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(181, '67cb8751bc2a87c22bf96ebda71fe6d021e45fd2', '261e88e58dc30ced95d22b972c006d05319e7a90', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'af.json', NULL, 59, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(182, '46b8272ecc50cee61d9730478e805d6149722213', '7902b5d676f94e0a5726dd9cab798565ebc762a1', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'uk.json', NULL, 63, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(183, '6a26d3ab80b883cbb31ef793e8087390c7201a35', '34d9234cbc865d7cc9a06f8c0f9c50c297aeaa0e', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'es.json', NULL, 58, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(184, 'bf5e8b0b816189ed634e896eb5e4eb9338e8be5e', '52d733114e0d2166b62f8d06d8eedfc6f3135b4a', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'fa.json', NULL, 61, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(185, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', 'f13995aeabccbe021debcc65f1f06168e002ff9c', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'sr.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(186, '602a94a74ddb46477f73d943de230fd8f00d1ba1', 'c4f77e49a165ef3a50dd0c946ee11bcb3624968a', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'he.json', NULL, 63, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(187, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '0f7dbd4ac33e49e8ad9133228e07a7e831eca699', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'pl.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(188, '76349517f4532378a769e322f51a2abf72f81d0a', '33704ba568b70689f8b3f628c167a424f76b4acb', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'ar.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(189, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '289b3a1bf8c0c98036d522b4663676331602d8fe', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'ro.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(190, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '76d2168b09931473e5facd55404474546088fdfa', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'hu.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(191, 'a3e72ab53fa870394a866c1497850c13c4c6885e', '665cd2ced6381c6d4ba1e6a5469ae76dbed50d7d', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'ka.json', NULL, 73, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(192, '6da83af18e98b75adb0f2737d3d63f7b78a72f3e', '188a05e85bd54e8598d5e2bf8a2257aefda20997', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'pt.json', NULL, 57, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(193, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '9e80c31c76276706ac95bad9c7c54fd986f1662e', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'ca.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(194, '3ef75005626aeb0e05fe60d28d43659bb0c8276c', '13a2579d71ddb3df4062db2fdb067cede56a903d', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'es-mx.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(195, '82b0a30d7ee4741b58c58301e779d04c400681d2', '214a7b6f50ace262b622ba162f1fc24f6209329c', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'ru.json', NULL, 65, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(196, '44a1523e316ca97435e9f919ceb5c4b19aabd7fb', 'd1e02fcfe76fd93a1a4da869139e823cb671d24a', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'tr.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(197, '3ef75005626aeb0e05fe60d28d43659bb0c8276c', 'ba02eb8ea0634b423182e48dc828f21ad7873877', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'pt-br.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(198, '67df1191437b37ac9fad77bb73c1abb0f35b22b6', 'eec3f38f162c5dcb1938f724a2dbacc316034e06', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'sma.json', NULL, 59, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(199, 'f510e22377a03e12ae00d4aaeef5867cf9da78e1', '3568c049095d25657ee103a717f57d9ac80e2da0', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'et.json', NULL, 57, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(200, 'a8c039d4759b0ea579b3c574818f69ea36bba1c7', '5c1abb43cb6965bebc8dae001dec1a6619fec9bc', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'fi.json', NULL, 58, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(201, '2ccf078f460e159c191594b7b58b314281378158', 'ffec7b37f062618d9cb6b606cf9c5eefd5317304', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'vi.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(202, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '7d5da285e249e22d9f5d5d662ab41daaf6bdbc14', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'nn.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(203, '67df1191437b37ac9fad77bb73c1abb0f35b22b6', 'd1b36be20463db3ecca55c881cde7faf206f78fa', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'smj.json', NULL, 59, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(204, 'f795d3fa8cca3ea514d1deebef868f65e706e8a0', '090e6916a10114bd94d79c38d580304a8daaf07b', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'nl.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(205, 'e376ba9bbcfe6b2b2cbde798692455f297231351', 'cd8a5d0e89cbc17bf3f9913b04aee3b6ca068a9e', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'ko.json', NULL, 62, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(206, 'f510e22377a03e12ae00d4aaeef5867cf9da78e1', 'f93110cee9d8dbc68b21dfbac64570f93984851a', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'nb.json', NULL, 57, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(207, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', 'ec91c91f7b8a24fad914b88a5a0e6d0da67f48dd', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'de.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(208, '82b0a30d7ee4741b58c58301e779d04c400681d2', '862c07d80dbfcdb2a3af8c035d936ff80b0d53dc', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/language/', 'mn.json', NULL, 65, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(209, 'a29b4bc5136ba48b47ed996c1e87bb99f94ca80f', '5ef757fc62d5ca04d8388e134ba8d2c7e2c0dfb3', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/', 'library.json', NULL, 445, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(210, 'fcd5e231664ab67bfd4dd4b06544c0d7c1a727f3', 'd6c3a020166d10314f4387ddc43385155cb797ca', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/', 'semantics.json', NULL, 388, 'application/json', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(211, '4bae06c15b37f4111a55db70affede77af9b1de3', '36d3d343427adc86868d81ec14650cd38a299bf7', 1, 'core_h5p', 'libraries', 3, '/H5P.AdvancedText-1.1/', 'text.css', NULL, 445, 'text/css', 0, NULL, NULL, NULL, 1698731332, 1698731332, 0, NULL),
(213, '3d42b68c08f05c77aa71bcc5ae3fa903c24407cc', '2291f41e418ad5ba7d40d1a16e7b529396bf5b94', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/js/', 'result-page.js', NULL, 4018, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(214, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '5159b3b5396d17426a6b2e2da87c220cbcdf27b3', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/js/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(215, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '64b34430acd34f2cf011b7bd6cae816b1455ac9f', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(216, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '07b5cca1bf8e12cbea1fcc54e1d00699bdfe161a', 1, 'core_h5p', 'libraries', 4, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(217, 'c6ab66c1c0d399ba816c5bd3aaca5034fc996bb1', 'd49d1e99c05c985a2c5f14a0834491909505510d', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/js/', 'qe-generator.js', NULL, 7477, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(218, '7925ff8759ab662005402047cfcc37566b171978', '6e2955780dd8334f92c28460371a8f4a8d040e80', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/js/', 'arithmetic-quiz.js', NULL, 4474, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(219, 'ae9d6f07d4fdf82e2acab374a02af72a2a1f3810', '2e0748456d889442cbcaf3a9a03ac0af06d7cb92', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/js/', 'qa-generator.js', NULL, 6419, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(220, 'ea975b2ecb712bdca1d9f74e00ea0c97eba6e0e2', '2438a86c22b57ef93ada79a3eee6b516cf627573', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/js/', 'game-page.js', NULL, 14866, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(221, '95e7952988321456acadf3df66f2e415fef1312b', 'e9eedf196dead098607a17c537a06d17528bd762', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/js/', 'algebra.min.js', NULL, 28806, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(222, '4c9d64f83b5dc882ad46c379af0651cede2fa57d', '860aef623a3147ca2887d227872f1b41e8d29e96', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/js/', 'intro-page.js', NULL, 1454, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(223, 'e8f79ccee9247ca21f51db26437590174aeaca05', '94fa1b3250b66a6d88ca8521f112ae7628e837c3', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/js/', 'countdown-widget.js', NULL, 2362, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(224, 'c19101c349e4c6a0ba3cfd3fc57347212c0c6b92', '795957e78ceb24bbeca64c6887f3634cd21baaba', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/js/', 'sound-effects.js', NULL, 1363, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(225, '51be18e67d949fe0ddd49e52c47a1eb4ab72fc3c', '38a9d94f6c587a9702d68befac580f73de4fea5d', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/js/', 'timer-widget.js', NULL, 3978, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(226, '78feb4da5ec97b19fda89193ffa1140c549b8a98', '3ba33ae7c78000a910aace3a9c5ff14d42cfe623', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/', 'presave.js', NULL, 618, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(227, '2d5ac4e43066dd417443f7dab540b7df7191102e', 'dc68cc99908d8482c6baf13481406b4f88bed398', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'el.json', NULL, 4673, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(228, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '08e5c7ea64285e809796766c988da116a15b742c', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(229, '38dba397039f7f4e1b567bc1da71cf7af8e21621', 'a139776ce99ae0dc7b30c1eafb84a2849e5500e7', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'sw.json', NULL, 3358, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(230, 'd9123997ec9cc32229f823f5e73c9839cd486739', '0ce8ba1d9ea6143b16288b94ccf372021f743aeb', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'da.json', NULL, 3156, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(231, '24ba311257ef954a1d247f331b7d23a0d1e30eda', '8d3d2cb705e44af028a4d8104d4c9e18a2777cfa', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'sl.json', NULL, 3435, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(232, '4dad95af68e7a9b3f1b6d7e8e10715a7ae4d46e8', '4fda5bccb8522dcc00145c769ce0cb594835ca37', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'te.json', NULL, 5410, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(233, 'c64f17748c366f3658a06d24e63e63116e72a7c0', '7ba734115f198a57b3bf529de438f908e7adbccb', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'it.json', NULL, 3478, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(234, '894a70be95d2d7d52e781a9ca54e9a9958a6e0c6', '6c8a9519341f91d9bbd79aee4100b6660220a536', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'lt.json', NULL, 3293, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(235, '66de9fcece25f46e6614a1e28de8119fb34b433c', 'b2b26eecd0a978acdf3af3e17f89b18e16be7ab6', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'cy.json', NULL, 3265, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(236, '45e34c9afbec69508794851a88a04a16df1c6890', 'eaaf14297e870ad63e29130768e15e04e8289698', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'lv.json', NULL, 3474, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(237, '8f128f64096553ea2d1affc44f8bd680700c3a50', 'd2d93432ca6281ecd3f31d7304795416bf2e9913', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'th.json', NULL, 4278, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(238, '85388bbc0a2e9e0c31b95ad5eb6d683d45000d1f', 'e99e9e0f954b24eeee695300ea693ccf3872b22b', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'eu.json', NULL, 3361, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(239, '96f32663fcc75665fd965f92c829a6fd7e6c7091', '32b047d6fdbf4d37fc5a9460e9fb7f2a8ed8c314', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'bg.json', NULL, 4396, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(240, '79dd8178053dcf5acc87fd6ddd4a50eb66d2b980', '7d8fdd363530acf8ee1b5a10e9a5dbd7416cc2bc', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'bs.json', NULL, 3173, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(241, 'c3184aca543d8d6f35daf7fc37e29f89acf86e7c', '6eb7552e7087e8ebd6c4d1c60144291bcdfb7ccc', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'ja.json', NULL, 3182, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(242, '2c54f03347b0903fda2e72b042adf49c3216de44', '6f4ad57f0489bba484065ba8db3d6e9c74f39aea', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'km.json', NULL, 3561, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(243, '357084ccbd78259d007ce5c22c794f4dda55d8d6', '8445ecf6fb89701afd28e96d02c891009286804f', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'gl.json', NULL, 3374, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(244, 'c555fa7cca3db22bee742598f90a6e5456b53033', 'c9a506cd25aa244d78f5c062d0019b8b4b041afb', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'fr.json', NULL, 3527, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(245, '86bc1b1943c71f821131af5debf5fb22b28cf8f3', 'c794a85bd827ba9f59f29ed3443c6f300c1a9324', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'sv.json', NULL, 3168, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(246, 'b7cdb578442cad52c9a78648daff3a89bc8c4e4b', '6991e3835bb0548f60566f7aa327520a7fd978b1', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'cs.json', NULL, 3351, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(247, '66e5c12c27bf4186992f6ffa36869d1b33f21c95', 'c052e9d6f823abf72db939873c57a7224b4f7f5e', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'sme.json', NULL, 3157, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(248, 'e570e195229200ffa68e0b02a24f37577ce7dd3e', 'cbf0f695b3c520efc5546bf3bc20ddfdb9b80fc3', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'af.json', NULL, 3216, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(249, '1f6f29885bd3bd058953008b5dfa253a87c6c420', 'f8fc26680721c3cf38754f8f694cc381c66663cf', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'uk.json', NULL, 4163, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(250, '9e673b562d9b1e5fb7ecba1467ccd8daae2f3487', '991447ebee112f986dfe9d1cbd49bfb7efae0cdb', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'zh-tw.json', NULL, 3109, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(251, 'b93463e0da17165637c1cce454aeb05da7fd167b', 'a4dd26d564d92b74366f02ae24c1a7dbf026ebb3', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'es.json', NULL, 3490, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(252, '640603fb852029cc528768a31573445745e9dd6c', '54ba84c246157ff4e67c6e60f8b57a99fefd02c0', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'fa.json', NULL, 3746, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(253, 'd9123997ec9cc32229f823f5e73c9839cd486739', 'a6c9e9ccfdab8d84b8a18d472e2aab6902586355', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'sr.json', NULL, 3156, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(254, '16f46ce6e5cff1a2d1fdfc602ab1f6069503ee0e', 'd25d98712d5b77cc829a9752cef86c792ed8038f', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'he.json', NULL, 3641, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(255, 'd9123997ec9cc32229f823f5e73c9839cd486739', 'ab5d7f350fc8f3a4084195a17b564bd51bcbe76b', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'pl.json', NULL, 3156, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(256, '4cbfd2aa9daeece8216a4e16a0d04dd597332712', 'd61a2d8e416be2ec22c5ee1eec03c5fb395918bd', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'ar.json', NULL, 3528, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(257, 'd9123997ec9cc32229f823f5e73c9839cd486739', '2b0325919803a2358fb4d96a446f35366e949a25', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'ro.json', NULL, 3156, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(258, 'd9123997ec9cc32229f823f5e73c9839cd486739', 'b1b43c4def1368947d3a498fe2370f0e7c6c3b2e', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'hu.json', NULL, 3156, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(259, 'e7ff02bda9b5095c326c99cd5b812d04436ebc1f', 'f08d0920dd24fdaa58fccda1bf19d269590a0b57', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'pt.json', NULL, 3457, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(260, '44109fbee3d0b98ff416472b308ff44cb5363518', '7c4a0538196554e807aa7171dc75575c320034f4', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'ca.json', NULL, 3575, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(261, '19c7675fd966f78145dd045fb0aac0d630a1d0cc', '5732e432f0dde75b282244a4629d781bb3020ee0', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'es-mx.json', NULL, 3446, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(262, 'a8ee2619ee22ca6025ee7776445cf745ec845ffe', '65d087dc1a5b92524c026ee8e5bba4c1ec27b055', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'ru.json', NULL, 4362, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(263, '4295579fa01280ddc3470f73f8e7c6648369aebb', 'fb10e287641b31f6a647dd96e61cde92080d3b4b', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'tr.json', NULL, 3437, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(264, 'bdd250fd5b9b28acda32e84ed495b588adc9e59f', '04087e52c8b57d2003b5613d764f13a303042a2d', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'pt-br.json', NULL, 3430, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(265, '66e5c12c27bf4186992f6ffa36869d1b33f21c95', '222ccaf716ee0c78c1b8f6c4f32bf140783bf29c', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'sma.json', NULL, 3157, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(266, '9b0661009c0a91d742f3d13d07553267f201a9b3', '8a402bd20a72a493ce555d9f36f50c32036d9ca7', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'et.json', NULL, 3167, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(267, '271a07545fb2927b10704bbfa307df2c3540183d', 'fab308ed17870a87197db35e6006a8d6448f9899', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'fi.json', NULL, 3298, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(268, 'd9123997ec9cc32229f823f5e73c9839cd486739', '42d1ecc5c87e658625a75c0985e5cae15d6c39fe', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'vi.json', NULL, 3156, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(269, 'cee6b0d3bd58b74010821bdda5ceebb573999dbb', '72095cb5c9500a1befabe6f89ecbe9bd94784c04', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'nn.json', NULL, 3159, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(270, '66e5c12c27bf4186992f6ffa36869d1b33f21c95', 'dd21d7158ce5e8bb7d5111347e92a489e288a49a', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'smj.json', NULL, 3157, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(271, 'a3268a4b9c0d61482622f59c07420eb98e7ebfed', 'e47b521ca32baf45286cd4718d1500e6f50b44be', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'zh.json', NULL, 3235, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(272, '2469f9f2a56f720ba4054ad181e5e9b218dab73a', 'f2e08f6d0546ed219722d0523674024a36718b61', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'nl.json', NULL, 3241, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(273, 'b61401d1813121a25a5858202d8e5aed2252b493', '925517dd0e6b8111bda97801a491e3c19678f89a', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'ko.json', NULL, 3201, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(274, '04c25fbf04364af3fd2b7fa627df5d2574e49b49', '1b36ae76788d154a15649ef2733ad40124af9e12', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'nb.json', NULL, 3269, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(275, 'd267d64743613a90f8d0d89de52eefc8044bf1d6', '79a4bf3dc37f231de19e80ff7b00e2467a02dd23', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'de.json', NULL, 3947, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(276, '1fbe4d724355e18d911a11121db9c82568c11f26', '098a7cb04452e96e0d07488fa11f0b6f2b5aca71', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/language/', 'mn.json', NULL, 4393, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(277, '757b71d0f6d504d3e7af9036e72bc2f62f2b0da7', '12d7b895d97c06883724f2cc035d015624f003b8', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/', 'icon.svg', NULL, 2282, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(278, '2e7aef7e916a1d0e8e2b63091e4d09bde6bfbadd', 'cb725adfb41331f452a4139725eb069d7afb533c', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/sounds/', 'negative-short.ogg', NULL, 36864, 'audio/ogg', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(279, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'b85ca643d217d2d03e8f8724275baf289d3de5f4', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/sounds/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(280, '93193f647b5ac11ff16a25293060fdec66385bb8', 'f8e971eee810f06b8998cedca8dd156ca8ee4b95', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/sounds/', 'negative-short.mp3', NULL, 45395, 'audio/mp3', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(281, 'f7059a4a2dc9da80925c8796bc94d8cf972f6880', '90de76cb87aa9ff7fe8de4d219debb4c27aaa2fb', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/sounds/', 'positive-short.ogg', NULL, 8192, 'audio/ogg', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(282, '09ae0c5337fa7653f947c4e969aa12da4437c1ec', '743a33a9102e68b0bc62a51f841ca66b9990c372', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/sounds/', 'positive-short.mp3', NULL, 12868, 'audio/mp3', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(283, '27c523f2265c1505276cfb24466969858c85e411', '3d5e3a3e54cc54989e1971bed419feba77540078', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/', 'library.json', NULL, 1416, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(284, '0c505ef7282fa6e570106bb9f73ded24425836c6', '1747456a5fb7b5bcbb10443ad7a95fb1c1f115f7', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/fonts/lato/', 'lato-v22-latin-ext_latin-900italic.woff2', NULL, 25604, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(285, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '3eac1af5dbea704b27adf03f023325ccdfd08d6c', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/fonts/lato/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(286, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '7a4e1df531d830a7d8a77aae0a1c63fa17f80099', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/fonts/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(287, '15e1a857e1c059d0cf265f21fbd3d44607dc1c8a', '872870749159fbd1e4aec0e9e69fa149a77e557c', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/fonts/lato/', 'lato-v22-latin-ext_latin-900.woff2', NULL, 24304, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(288, '4dc2e90e40d35482883aea5fa535cfa4e15fd392', '130f7c1527c36a8075152494226383d313b525ab', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/fonts/lato/', 'lato-v22-latin-ext_latin-regular.woff2', NULL, 25284, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(289, '76897b37e127e2332a1a79aab2e0d6f30ccdc47a', 'f9d34ef0d8d2f6abe956540d9e8357ebcc1ce197', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/fonts/lato/', 'OFL.txt', NULL, 4407, 'text/plain', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(290, '54a677e2d0e39ac9c7063068f42cf1eaed464c02', 'd479618e1547e69467e624d79ce91ec58063fecc', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/fonts/lato/', 'lato-v22-latin-ext_latin-700.woff2', NULL, 24780, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(291, '765753204af8ec324539e7465b0f9f8dacaa0086', '26f400b5b8cc4b6a4d3687d163cfcd0a584b503e', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/fonts/lato/', 'lato-v22-latin-ext_latin-300italic.woff2', NULL, 18828, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(292, 'a0cd323509a1bd6394c17825633483ab9bb9ecb5', 'f6daca19370ae5867985e293ccefa9cc2bb936c9', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/fonts/lato/', 'lato-v22-latin-ext_latin-italic.woff2', NULL, 26328, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(293, '79299111da97074845b1eff5ae6c9ba2010c13ca', '600ef10db7a77552f400bf7f0d0ec0651a9d2f71', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/fonts/lato/', 'lato-v22-latin-ext_latin-700italic.woff2', NULL, 26368, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(294, '655fd06821848f4dd82d0948ddac88a742dfcb1e', '59c037803480419f29d075f68470df1c9acf50af', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/fonts/lato/', 'lato-v22-latin-ext_latin-300.woff2', NULL, 24876, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(295, '864d90e0389e5fd3d6bac6ac3a7c5e4a715dc0ac', 'ff072864bdfe4c49800b46766214933b1fb1d7a8', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/css/', 'arithmetic-quiz.css', NULL, 7818, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(296, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'd5de0e3f0b0fbfcadb861e614ae05b871332147a', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/css/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(297, '7d25e8626627b1d5f4ae0a0df1efae90e7853dd1', '5fa000c10e636bd3e8465f675faa40f1bfaa90b6', 1, 'core_h5p', 'libraries', 4, '/H5P.ArithmeticQuiz-1.1/', 'semantics.json', NULL, 5969, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(298, '8292ac4bfc5772180d921c4e3d9d381c96d8267d', '2e4397c6c35ea126f74ab327bcb27670e80c8525', 1, 'core_h5p', 'libraries', 5, '/H5PEditor.ShowWhen-1.0/', 'h5p-show-when.css', NULL, 57, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(299, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '7b1e8a653411e93698f2d846760d351bc62d2a7c', 1, 'core_h5p', 'libraries', 5, '/H5PEditor.ShowWhen-1.0/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(300, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8bd6e5077003b3e437a3578f64369a73614c1112', 1, 'core_h5p', 'libraries', 5, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(301, '02c8144328c5974334e886e8e006d44dc09a06e8', '2e29ebec1dec518cef738b76720aed480120cbcc', 1, 'core_h5p', 'libraries', 5, '/H5PEditor.ShowWhen-1.0/', 'library.json', NULL, 361, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(302, '349099789ae5c3f9d550ec1e493402ba699e00f1', 'a5e5e57071b0fc9d8fc96e1994e7a5039ab4a8ac', 1, 'core_h5p', 'libraries', 5, '/H5PEditor.ShowWhen-1.0/', 'h5p-show-when.js', NULL, 4351, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(303, '391a7a93aefa7f47e36c58b1c5b6009fb06e03fb', '3eceaf582ad4e24db37ef7c75c6f9083c26a3e8a', 1, 'core_h5p', 'libraries', 6, '/H5P.FontIcons-1.0/styles/', 'h5p-font-icons.css', NULL, 360, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(304, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '25548a29beabfd239d0e7b6623501de10a030d11', 1, 'core_h5p', 'libraries', 6, '/H5P.FontIcons-1.0/styles/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(305, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'da16b2d0d1cddd5c5dd91f51aba5457ca63209b6', 1, 'core_h5p', 'libraries', 6, '/H5P.FontIcons-1.0/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(306, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '4d821029f4515650fea554023b4d4d295d256377', 1, 'core_h5p', 'libraries', 6, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(307, '081d5cf9d31f69b16b1fbac6e03c76518d8de3ba', '3801719298dcb6a983a5299ab93ce688b7a3ab21', 1, 'core_h5p', 'libraries', 6, '/H5P.FontIcons-1.0/', 'library.json', NULL, 246, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(308, 'cb54001c5951d1c64cf521194a6f353f16d45d30', '10e63cd4ab5d6ce7f3cf4f5ab285b8b47eb7f443', 1, 'core_h5p', 'libraries', 6, '/H5P.FontIcons-1.0/fonts/', 'h5p.woff', NULL, 16728, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(309, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'bce9ba6db01e214198038a53c07995ae80ebb458', 1, 'core_h5p', 'libraries', 6, '/H5P.FontIcons-1.0/fonts/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(310, 'f6caca29d53b395e72c54ce392be54bdab0601f4', '82feab12e64b472d9ace078733d07a0be999596b', 1, 'core_h5p', 'libraries', 6, '/H5P.FontIcons-1.0/fonts/', 'h5p.ttf', NULL, 16652, 'document/unknown', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(311, '0e0daa7d1eb4f4ee57b8da5a1d4ed8a610401b77', 'c5605b0ad08b04af5e3d57325696de7a70469630', 1, 'core_h5p', 'libraries', 6, '/H5P.FontIcons-1.0/fonts/', 'h5p.eot', NULL, 16800, 'document/unknown', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(312, '1547d8246b70dade7896c1990c7a7fcfc826b933', '84f69b4a4cf203b4e0fe3500311c371e03c522cd', 1, 'core_h5p', 'libraries', 6, '/H5P.FontIcons-1.0/fonts/', 'h5p.svg', NULL, 63288, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(313, 'd5e20767919a1cc9ee85002199daae5c6d5ed0d0', '4a90f22b414c4f83bcd6544d53aaef65af304014', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/', 'README.md', NULL, 1664, 'text/plain', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(314, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'e5043239890b8ca3c8346d9ecdd0fcd030e98c7a', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(315, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '10790ec31bc5580ed12611c0af9cb4899719123e', 1, 'core_h5p', 'libraries', 7, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(316, '2dee09dca73ddf546fa19c1a19d35391dd09a999', 'd1e47118ff37e571b4e429c0dc1203e8ef5853a0', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', 'joubel-score-bar.js', NULL, 8520, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(317, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '272a9890e1119722d9f4d8882c4f854bb1ba24a7', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(318, '799f77d2c0fc711bacd205aacc587f5900fd15e2', '962f841ad1789252fc79b6e80d81ba82442645bf', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', 'joubel-throbber.js', NULL, 312, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(319, '0d16530493105099f90f733a396caf06bb04b774', '91bcad1728b2664d6a4aadcd2108917d64bb97f7', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', 'joubel-simple-rounded-button.js', NULL, 689, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(320, 'be1e404a5ed0df18d48702bf1dcd1bfbc4239e96', '62f2cf165b44c660f27e4882bebf4c4d734dbb53', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', 'joubel-tip.js', NULL, 3658, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(321, '61d65dafba1e035a9a3c7f5b3b2e8763c9f842f6', '0ca06228434ce33b8ad8b34677515a9d48bbe0cf', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', 'joubel-speech-bubble.js', NULL, 10766, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(322, 'c78fc21f9d083cd6478537033bf363afc28f4da4', 'bc11e69ae0ff01391e06f2c1080649af52a574e0', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', 'joubel-ui.js', NULL, 6015, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(323, '314c35ba550e2b117c382ac3dc711227dfb0c53f', '9033a1264d10ad00e3fdbd1c1b136d5fda4c593e', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', 'joubel-message-dialog.js', NULL, 968, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(324, '07d49ef78f9f9bd0742bc4c165d5d6b87ed405bc', '2ec416eb22ecab254c2cf7c81d8abc7cb60005c3', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', 'joubel-help-dialog.js', NULL, 2483, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(325, '15f2ef7221e01c95edee8d00ba3360535ec183ab', '8d13676fb941edd917027761b0a2194955089ceb', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', 'joubel-progressbar.js', NULL, 2804, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(326, 'f27ac7a69adb497d171a43db900216a2c87f4a44', '015ea84d50abfee53723b207620b52f13fd46dfd', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', 'joubel-slider.js', NULL, 2237, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(327, 'beb8c14ca69cd864960f4eec56a35ed2498cbcae', '092529b37c31e8cba35639e0d99c4b6ab167e028', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/js/', 'joubel-progress-circle.js', NULL, 4622, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(328, 'f4114fbaafd7e264ed0fe0a54347afd2c781ca1a', '9b150d94dac50bed50aad4d9a409368723f5b2af', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/', 'library.json', NULL, 1864, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(329, 'dbaee24fe01c47f7e94a4327af9e03830a52906e', '1d24bd5fb0729ba7cf01c04d1c4450274725d693', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/fonts/', 'joubel.svg', NULL, 14092, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(330, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '98f4102b4ce487a7ad7fff9cccdaa5142af35270', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/fonts/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(331, '0b411a97d059882412923006451a9efae82776a7', '9f43adfcc813c36f9f44fa55d57cdd8131cba71c', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/fonts/', 'joubel.eot', NULL, 4752, 'document/unknown', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(332, '1529174d6fe54e566f024390e2c26e2b151ce9c1', '4ea77f5461f98e169bc6ce69a3294d5f43ed37c3', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/fonts/', 'joubel.ttf', NULL, 4592, 'document/unknown', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(333, '7efa588e47e4f779b589f3c0fdb811d626caccbc', 'f0b0a2340085add1e823d3302eed464937ba711e', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/fonts/', 'joubel.woff', NULL, 4668, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(334, '1f99b772a519c5cfe4d99a1ace15c70bc3d1bc45', '6d64bf124ddfb2871ed8f5d791076aef2ec60130', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', 'joubel-progress-circle.css', NULL, 1465, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(335, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '72bb18e68da44ceafb9b9a030f1de79d9853b68d', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(336, '062b5c0ea946458e99172484d4496a3568b75289', 'e6cf77ef40102a429e90cba1b6bbe6ad6c6c1b6c', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', 'joubel-ui.css', NULL, 1841, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(337, '718d17effef968ebe140e40ef774f0d0cd429d02', '08a323630815088e47cd91c6981fe5259929ab54', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', 'joubel-slider.css', NULL, 639, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(338, '76e52a42393f8ccaf2729fa4ca431588a43633ca', '3f352e8a72065b5f2ed45dfa603dc2dede107a64', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', 'joubel-simple-rounded-button.css', NULL, 633, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(339, '73a1a23de7d4ea0be2162aecbc298a0b83b47825', '48ae82dee650adaa8ef461883392e3ee3257a029', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', 'joubel-help-dialog.css', NULL, 1169, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(340, '77a20b1ea1ebe9fb1db219ee5c979dc3e1cd0f4f', 'e18afc191671090e36822a30f7cd0dcd4d7c9697', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', 'joubel-speech-bubble.css', NULL, 1127, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(341, '964a746cfce656ef48e92437cf89a2dc571b9216', '424898babf36f5a3827aa0d56f5f7a6acbefcb7b', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', 'joubel-icon.css', NULL, 3601, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(342, '168117d476de40c708b7ab39d602f2cb6b8ea378', '5133d138c65acf98fb47b316951d000750dd5c6e', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', 'joubel-tip.css', NULL, 1074, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(343, '4781356fc047284ce06f604fef1f5effc257cfa1', 'e589f9d75dc88f18bc1a4860f4afd3b8d57ca5b2', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', 'joubel-score-bar.css', NULL, 3539, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(344, '7c2d79534d3113f6e7254558c6a82819cc80c0e6', 'aaa3a004dc40fee20cb37d9730ddb80af4472b58', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', 'joubel-progressbar.css', NULL, 835, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(345, '1895b7c4c5fd305258183f32e77290a3aaed2275', 'b07e4325245023d88c6453e12b2506ffa02892ed', 1, 'core_h5p', 'libraries', 7, '/H5P.JoubelUI-1.3/css/', 'joubel-message-dialog.css', NULL, 478, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(346, '0d40bfa605935580c9c050e601c21ef1ee4f6553', 'e92cd9687dd9b8e5b3455af8c73eeb7f27195051', 1, 'core_h5p', 'libraries', 8, '/H5P.SoundJS-1.0/', 'library.json', NULL, 347, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL);
INSERT INTO `mdlxd_files` VALUES
(347, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'd026ec6b722422b0051c1e21d410c3dbc3bbc83b', 1, 'core_h5p', 'libraries', 8, '/H5P.SoundJS-1.0/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(348, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '585941022845415abb2690b8e2240675d78e9a1d', 1, 'core_h5p', 'libraries', 8, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(349, '16ad85f0dc820a467d72c5485fb11b1dfad692cc', '62174046167a219ce2cd67df6937d6b7b222a1d2', 1, 'core_h5p', 'libraries', 8, '/H5P.SoundJS-1.0/', 'soundjs-0.6.2.min.js', NULL, 59855, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(350, 'e7cf1cbd98663969148ef7016b1d9e603c20e7e9', '9594bf02852cc2388da05f5e497164e1d0d7223b', 1, 'core_h5p', 'libraries', 9, '/H5P.Transition-1.0/', 'library.json', NULL, 322, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(351, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'c6e2fdd2ef41ac5ae503dc809c956083c985fecd', 1, 'core_h5p', 'libraries', 9, '/H5P.Transition-1.0/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(352, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'c67d8eac461abdf1fd8425c87ad30959061495e3', 1, 'core_h5p', 'libraries', 9, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(353, '18df714ab8f9a929aa83f928fc7dc8626248f41a', '0889d44b57a50951fa30c23b593e49c679e85673', 1, 'core_h5p', 'libraries', 9, '/H5P.Transition-1.0/', 'transition.js', NULL, 4591, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(354, 'f4f379520ba533ce66e62c211babf6b19e1e55c1', '5086c7291d61c3163488d6b653fad3e09ecaf37b', 1, 'core_h5p', 'libraries', 10, '/Odometer-1.0/themes/', 'odometer-theme-digital.css', NULL, 4686, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(355, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '4abe2e3b4fc024944c39118203fa15f184f0cfd2', 1, 'core_h5p', 'libraries', 10, '/Odometer-1.0/themes/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(356, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '976c2f624390193389b5b947be319dbf58366650', 1, 'core_h5p', 'libraries', 10, '/Odometer-1.0/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(357, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'bf5ca917a82526608e3beba4deecca61ddc13ab9', 1, 'core_h5p', 'libraries', 10, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(358, '8cac7e09ca2e2c784dcd4e8b80531d42497879dc', 'f26247dcbd5f58935bc5040eefa27bbaa7be3fbb', 1, 'core_h5p', 'libraries', 10, '/Odometer-1.0/themes/', 'odometer-theme-slot-machine.css', NULL, 8015, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(359, 'fa8ffa64bcd070065f5f05f8d3761ab2bd917c5e', '08ae401c044210eb41cb4c93ea4aed7870140af6', 1, 'core_h5p', 'libraries', 10, '/Odometer-1.0/themes/', 'odometer-theme-train-station.css', NULL, 5700, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(360, 'cbf50bdd8ebdb2e2764dcb635ce39ef26bff2044', '37b714acbb1a99e8ae9bb9e9683df8215fcb14d0', 1, 'core_h5p', 'libraries', 10, '/Odometer-1.0/themes/', 'odometer-theme-car.css', NULL, 7374, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(361, '3f60e6f1fe883de9c0969b42e0a508c9112ef8c0', 'ea116e5474420424eaf29ebf24e9f934ee945600', 1, 'core_h5p', 'libraries', 10, '/Odometer-1.0/themes/', 'odometer-theme-plaza.css', NULL, 4677, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(362, '69c3318a8ccb7302b196eb62723bcbe735b9a09c', 'ad8967d6c37faa14fda593baa1b6847a848cd4e6', 1, 'core_h5p', 'libraries', 10, '/Odometer-1.0/themes/', 'odometer-theme-minimal.css', NULL, 3754, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(363, 'eef9563a2cbd611be559de69b73926ec7e04b3c0', 'c5eea24c0e9ee046db8fc5312a58abeb7098c1b5', 1, 'core_h5p', 'libraries', 10, '/Odometer-1.0/themes/', 'odometer-theme-default.css', NULL, 4012, 'text/css', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(364, '27c2624c609faebfc2d355f3a3c3af62210b73a2', '16a62e6f9408950b022bc8607f621aec588b8784', 1, 'core_h5p', 'libraries', 10, '/Odometer-1.0/', 'library.json', NULL, 400, 'application/json', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(365, 'fe5beb60997c84ab2f91b54535c4221443cdd21f', 'f50ba4e16693bd5fcfd60af031b031e0efad972b', 1, 'core_h5p', 'libraries', 10, '/Odometer-1.0/', 'odometer.min.js', NULL, 9896, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731334, 1698731334, 0, NULL),
(367, '8eb26acd34b807947d7fa7a9001db1f330637271', '3c356576e4a8c7fe13aa005ad124cef6e038a75b', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/', 'chart.js', NULL, 3910, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(368, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '7a7df308d77d9d2d9494d5a06fad58ad2526e71c', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(369, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'b76d9bc227d76a046b098074b410f6867fc6a089', 1, 'core_h5p', 'libraries', 11, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(370, 'cba0d0ff98ffd58f13d82e24dc4e146d70a279e0', '7fd7c3feab8a88c63fc5690b4a0197c9a9a0a416', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/', 'd3.js', NULL, 335543, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(371, '05904f9be11843976c84cb52132d8d35bc71ae78', '19f245d54f819d73d81c7e6dfcee767f08f731e0', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/', 'chart.css', NULL, 487, 'text/css', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(372, '59d2633362ded2575ce6a0cee5e20b67e4070921', '5af18b060aa8c8f167c9e4da7120a0fe7db73279', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/', 'bar.js', NULL, 3498, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(373, '2ab82d8383113d2a423624f3f6f3db1dd7f83279', '08cf8216e398cbd161b021b5241ed51bbe12e529', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'el.json', NULL, 910, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(374, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '86e517bfb7d22f88a264874b038fd198d653a606', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(375, 'd9c0ec7d00d68cd3bcddb6e5d0f33b7e5c764ee7', '17bab4071d3f864b077a872f2d04ffed931f2603', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'sw.json', NULL, 728, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(376, '2e7bad2b112a2e101bedc8b4fcec488847656171', '00fa97c05c0f22df6bf6fb658107e167b43c5d41', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'sl.json', NULL, 691, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(377, '65d92ebb777238697dacffed4201ad0a62472750', 'a82db52ba8b7d911558bcb50cd507c9ea0bab3d6', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'it.json', NULL, 737, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(378, '2ae9f5f14027d8b843498dcfe4c50eac692263d1', 'c9bf73a7afb333410c7675e1c6225debf82b0ce4', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'lt.json', NULL, 759, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(379, '16c6ebbb4f914585305d58ffad1e6d7658e6ca99', 'b5360c30b99d79d8b265a56edfb41942b88e5ce3', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'lv.json', NULL, 750, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(380, '1e962dbe1fb04bdbe7b0e51987aa7136a9015501', 'c633ac7bf97b86d77806427040985ae58e71fed7', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'eu.json', NULL, 735, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(381, 'd4831dbb673ce4084d146201125ecbd24dafe2f6', '9f954c6591caa58f34cda068659f0724f643f811', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'bg.json', NULL, 962, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(382, '95b44d4320ff0a4078acdd570fb2fa2d2e5ae3ed', '0e74eb918bbfc835e07f2376a030ee9f8b3e1307', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'bs.json', NULL, 701, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(383, '381821e85ddd34ec59aea529c26cde6c192911ff', 'e74d566d31d01a876e2b1da48ccb45e4a6aecb68', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'ja.json', NULL, 699, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(384, '93e421e7c13fd1b702fb53deceb94eb9d2401912', 'a07bf3842f4b921570b3a962557fceab67e3be9b', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'km.json', NULL, 704, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(385, 'bcad269d09ff307fc33ab3d8d156642ddf5ddbd5', 'b5ca56b6cb1bc9bd9d0e0e7805cbdc26ffefc8de', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'gl.json', NULL, 735, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(386, '3b02ca0bd16d3c0cd928f292594fbb3afdc7c965', '20dccafc4f801b58f71a7bb143e058959f7b65b7', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'fr.json', NULL, 744, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(387, 'e9ba4cc18b57de1b1df434d7cf856f0eca58ad37', '81cda316a8014bee0fc08fd2027b5c11d4019c9c', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'sv.json', NULL, 709, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(388, '683bba48972fd47c5424975c0c1a15eeaebcbef4', '06c6843fb8612466a785dc28d83ddecb4b1f53ea', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'cs.json', NULL, 714, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(389, 'b01a14e93f5ff9137d5f234cea031c0cedfc72d8', 'ebb51e979a21ed92cd641868cb3195e15db3b790', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'sme.json', NULL, 691, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(390, 'd659024ca87c7c64fb55e4825f179d768c1116e0', 'aed68c6eaa474215390ef43278d9a30978458807', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'uk.json', NULL, 947, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(391, 'a2b4302c5da9a73a6f30fdeef5318244ac1de58b', '792e01a5e2d419072c9f2db0e87c44602bb5078e', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'zh-hans.json', NULL, 687, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(392, 'bec824b09a62f2efdc27ece1b872a1a33081e4d9', '7facff29dad93eb88bcc9409c440a956a62a3cb7', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'zh-tw.json', NULL, 683, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(393, '77e6b04304b67a9d8a231775a0294ea7dda8a0f2', '2edc4fa8085e79f6ec74c897e7b38c3c89f7c020', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'es.json', NULL, 745, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(394, '1d9b5bf3fc599e221553dc2739cf89fa67d92878', '68ed79dfcb53acde2d6d06b533f98b99be3ff5a1', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'fa.json', NULL, 853, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(395, '55d965702db69cf8f4f4bcd6379ce83b7fdc45a2', '339e3c5ee5e028a525c3fbd572f3b94df1316861', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'zh-cn.json', NULL, 691, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(396, 'f4603fc43cd364659c4bb9cb04c09ea96cbcac83', '9e7b9e3a340fda4a34bbda1296344b04ebef44de', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'he.json', NULL, 771, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(397, 'e76ecd89477312b27e8781c4e1c6dc226ef22cfb', 'bc8cfb923d676aa07f6096587f01e3538e4f2ab0', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'ar.json', NULL, 820, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(398, 'cdec2e14f3871d66d7e692b47b2b2531270c2b80', '19b474106f3e4e2abacaf5770d3d0b18741f66ae', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'pt.json', NULL, 720, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(399, '6f96cc68ff03e1be554dd302904b4e499f42c2f3', 'd52ad7f16e63f41efdf6f3777585e819bb7c9542', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'ca.json', NULL, 761, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(400, '5476cfa3bb7de882a19d8b100b44190586864a7b', '6f0c455c674d9020a59653bb13ba0f60cdd65b8a', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'es-mx.json', NULL, 760, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(401, '88d66ee6de50d3e2eb2b5d547bfed883365bc6ed', '0ff4af7bb2111e6e545ef0cb20a97ff2fd213730', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'ru.json', NULL, 905, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(402, '79ecc61663cbd9bc33a37004d025bee4654a95fb', '07e0b447a7a77812e498988eab6e87f38675f460', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'tr.json', NULL, 725, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(403, '723eadc3f9d216fc6736edafb8641c586530316b', '3283f5d5e43bd7739ca024a9e1434b4b3072bbfd', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'pt-br.json', NULL, 711, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(404, 'b01a14e93f5ff9137d5f234cea031c0cedfc72d8', '1ab6151bd9684c2e050d2c0f40a47f1e9fc72f56', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'sma.json', NULL, 691, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(405, 'f8a3da1d8b1f746f5133be81f4a95de815d77b12', 'd80818599263e69e4418328ac80857baa6329287', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'et.json', NULL, 713, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(406, 'c3a1e65000cb80e90426f9b6063115562b5b9d37', '1ccd6624db35b3750d40b06a6c42987ac12781f5', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'fi.json', NULL, 651, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(407, '9dbee79085b4345dc8043eee77610715ddc3034f', 'b3e5f69470da68020c40a6adb39e343d9d8a4d17', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'nn.json', NULL, 678, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(408, 'b01a14e93f5ff9137d5f234cea031c0cedfc72d8', 'fcc74f1ddcdcec3e65a39d2f71bbf97fae253a48', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'smj.json', NULL, 691, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(409, '67f054efb444cc0b5ce5859d07253ddc19b77849', '83e19bb26e4728eedc044e08878e1012883d6e43', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'zh.json', NULL, 650, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(410, '238ffbdd186f2774531acbbd4fab677b92d4337f', '1d46326311b321eea7b4f76ad8a3335ef621283a', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'nl.json', NULL, 731, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(411, '0a8bd73882f0a8c1845b93a5e464871eee27a0a9', '09cd9e63052cdb8da8a0fd879a44b2eac0173976', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'ko.json', NULL, 736, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(412, 'c5e8f56f4cb7dbc89efc5241abe24e6ef7fab303', 'f3d1a48e82acbef5a5891e13e0c943a8b4eb7313', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'nb.json', NULL, 687, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(413, '75ef0e9c852091b82fad3322f3c49700daa27df6', '523bba209836deed039058a0fb2c79a3e6172dc6', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'de.json', NULL, 746, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(414, '6767f7a223bfe155b8b73e4e583d76b8f2ddd9a4', '78692a2b8aafcb0eab26e2faab50216336ee7a7a', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/language/', 'mn.json', NULL, 871, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(415, '2ada3bb3f4c9a9e0415ca0d1949538fff6c7ebf1', '2fc6355ee47f13f2f2dd2e0e56a0908d8045fa8f', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/', 'icon.svg', NULL, 2095, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(416, '386682100fb6e2e592584d7fcb5c4547dc153897', '296d324030cf23e9ed0728c9afa345e809e6ef4b', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/', 'library.json', NULL, 692, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(417, '1e35051f466802bf51eef9e4c4dd567dd3296f4b', '60d4c6088a2fe17a2d50e47262eb05d40298250d', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/', 'pie.js', NULL, 2467, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(418, '7580fc62423d63ffa8979e87377535374d9791e8', '6b55318a1a18d170a14dad164427bd89ec7e1bb2', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/', 'upgrades.js', NULL, 563, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(419, '9a50a44a63aed1b70090dd9d87a839adbe02a242', 'f357161a9c2139ced9231c9d3365a00d6f0fa0a1', 1, 'core_h5p', 'libraries', 11, '/H5P.Chart-1.2/', 'semantics.json', NULL, 1850, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(420, 'be5702de7307181d4c808c4df477bee47d45ab20', '8707de406839e1f96f48b74d5ec4817f35d8708a', 1, 'core_h5p', 'libraries', 12, '/H5PEditor.ColorSelector-1.3/', 'README.md', NULL, 1689, 'text/plain', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(421, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'f188430d7b5b2d0bb4d0c823ac5d8c9b408cbf60', 1, 'core_h5p', 'libraries', 12, '/H5PEditor.ColorSelector-1.3/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(422, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'bfd41c9f1b6b01841e83787935dba3b574d98427', 1, 'core_h5p', 'libraries', 12, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(423, '4ed48a0fee604c51f38739cd0df4d50040a24c10', '24003588fb9e3c88b6c2789b93607e0a598b5e4c', 1, 'core_h5p', 'libraries', 12, '/H5PEditor.ColorSelector-1.3/styles/', 'spectrum.css', NULL, 14921, 'text/css', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(424, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '2dfa3cb3e8750161c89fac5d357e69655eec3392', 1, 'core_h5p', 'libraries', 12, '/H5PEditor.ColorSelector-1.3/styles/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(425, '1807f8176558e6b20d1225b5204adbde7e8a6ed1', '7065ce0ce547fe9f3111a123e35e1628a5648c75', 1, 'core_h5p', 'libraries', 12, '/H5PEditor.ColorSelector-1.3/styles/', 'color-selector.css', NULL, 385, 'text/css', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(426, 'dfd80abb34dc4154909ddea9ddcb5358c578591b', 'e04b09b57b5b57123be5f6227c39f3c1d7325e9a', 1, 'core_h5p', 'libraries', 12, '/H5PEditor.ColorSelector-1.3/', 'library.json', NULL, 508, 'application/json', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(427, '18dec97c7c309159caede5cf4c66d9a744954baf', '29688faa337ad02fa3356f44ebb0ddc999c26154', 1, 'core_h5p', 'libraries', 12, '/H5PEditor.ColorSelector-1.3/scripts/', 'spectrum.js', NULL, 79889, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(428, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '7322ab08bf3dd1fa9ee2efe3bc14dee2d3bbc96d', 1, 'core_h5p', 'libraries', 12, '/H5PEditor.ColorSelector-1.3/scripts/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(429, '1a2143e492ea10b139fce6668fe125932b83bf69', '9e10104238bb6fb16222d863fdf1898d83915597', 1, 'core_h5p', 'libraries', 12, '/H5PEditor.ColorSelector-1.3/scripts/', 'color-selector.js', NULL, 2957, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731336, 1698731336, 0, NULL),
(431, '8bf7bf761e79d1ede92fe8b55b472e0b8fcca102', '2cdc4f7b43569df00763cbd64d5969513afde20e', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'el.json', NULL, 3088, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(432, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '0ae21228161958f091e1dc2de28d3c94287eee5f', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(433, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '9b7722efe93519359a5edc2642263be6db06dc67', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(434, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '88332ed8c3efd54dcc5121d48f18f1383d4809c2', 1, 'core_h5p', 'libraries', 13, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(435, 'ec88d58746d7d953648e18f7d47294b40e2f8612', '4c506beaa20325f9ec8953fd0bb65d9d76c62899', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'da.json', NULL, 2303, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(436, '1b900be2ac454f5e3b6c0448e682a606de6aa159', '44a5eddd2c9372c454b235c63f5f3b9fec7eee4c', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'sl.json', NULL, 2349, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(437, '40c7ea312771b19525cd594948b5e0c09f7bdef1', '831c91e3a35ae23eaaa6b438d5140cb383ac8233', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'it.json', NULL, 2374, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(438, '8f49079bf5765837a8f427fcf4ea4106de8f108a', '48dc261de3749366b8145b099ba74a0fa69bb28a', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'cy.json', NULL, 2373, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(439, '16a1018fb6debdc4c8e8efda07f79142784d8af2', '1677e0f9d7abe886a8833e4caae4f3a1a55f4a3b', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'lv.json', NULL, 2422, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(440, 'b5ce64d1436ebc8a1b110bb8be409d0918417f66', '00f5dd3b28f5f38edbbb06cb13b255bed5392869', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'eu.json', NULL, 2349, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(441, '19c079723b3e461ed0b10b5862cc08274ca4308c', 'b5ac72ad653c00593a5ce3c8c1592d8cb48921ee', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'bg.json', NULL, 3047, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(442, '117a267710e93ebd41e0416169a73aafe1182f36', 'f94d151925e8ed01d2dc8e40d676d6b60c7fc2d1', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'bs.json', NULL, 2278, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(443, '152fd59007d858c89eb688ca77dc0c443967830f', '73d327fb618f7864f7410d602f8a0cf59f745959', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'gl.json', NULL, 2337, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(444, 'c27653a851b06b4855207a618f6ab14549da1c10', 'b7cbcacac00461429ef2812a7d4dedbc5ad4108b', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'fr.json', NULL, 2373, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(445, 'da5629a7db373d5a68301edcd6db4e95ae7599e9', '269e800a7035d12c2b8d531f485a6b85e4325a95', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'cs.json', NULL, 2409, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(446, '16eb05e9e81adad8729d0083811a3be2652758ee', 'b0e697fd7584369d4e4600ded7ee495b5517ac03', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'sme.json', NULL, 2293, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(447, '65598123bdec810559702e1ab2f91dc9f0822b04', '067221d40ce64a9a8a51edf300c27f72c61762e0', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'zh-hans.json', NULL, 2183, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(448, 'c42271b0905db268c2b67d6eb6ff29ed48a8f1aa', '76c95d5c3effabf692cbb51277ac8c58bd3de622', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'es.json', NULL, 2429, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(449, '606a4037378c7fefc910b91f9b8d553f824cf0ce', '3dfeddaca2dbcf56b918c8a817057c67bd31390e', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'fa.json', NULL, 2769, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(450, '95c166beea1913b703b5b733031178c1a34c6334', 'a9cddf6c4ab803989b7c0703e419ea329bf6000a', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'ar.json', NULL, 2622, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(451, '00ce5d73d21a5bfe2ed725a483da9c327fc0099a', '8711e3c6b33d03993c6525b529aefd9ce010b48d', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'zh-hant.json', NULL, 2178, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(452, '7e32ffea28301266e697b19c5ace5711208acfe6', 'ee49de3598cc76db752c0b40c19c96259cd11349', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'pt.json', NULL, 2402, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(453, 'abda101ea2b85062f1f190a8c250a144eedb5a30', '7db1586de86b2619aacb77fd5f96f9433fa4ba2c', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'ca.json', NULL, 2411, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(454, 'c95a8304e995480831dcb8742728fd05a5eb81ea', '2c73f639e876f629fc410156f013cf104b8aaea6', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'es-mx.json', NULL, 2429, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(455, '75a3bc9aff842cf29e6650e82a7b5609930b60dd', '6d9cad772ad5c4a70d103b91fffdc5b4d940378a', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'ru.json', NULL, 2739, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(456, 'b7179b597472e3832d8050fea06d01cac65c0ca3', '8d0153cf46a2dc5162efc22a1ce456161e268f12', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'pt-br.json', NULL, 2382, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(457, '16eb05e9e81adad8729d0083811a3be2652758ee', 'e7b52fe28f395bbf04bba92d0f5803bda9328c62', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'sma.json', NULL, 2293, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(458, '5d23fa93654ac55782a270574612f8bf3f88a275', 'a6276213eb2be44dec6a08f288f6cdc18a1f1a23', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'et.json', NULL, 2302, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(459, 'ac405cbd1be8537b22652aca4ecb37e77e09ab75', 'e5768b22c5abcffcc79d67f6a4438c83fe1fea04', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'fi.json', NULL, 2312, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(460, '4c34417971fec25ebbe55629a2858d0becb620e0', '3feb74fe973edf963a1ee48a2ed3377a63b1b27c', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'nn.json', NULL, 2293, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(461, '16eb05e9e81adad8729d0083811a3be2652758ee', 'aacc8b8e519aa2237b858fd7aa27ac3f90a363a9', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'smj.json', NULL, 2293, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(462, 'be449e725f4de85f55e85df7315738ecb31a7036', 'df5a046ba13d8ee4a9930fee54b75c4dd4983b7a', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'nl.json', NULL, 2341, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(463, '0e7d4536a2f6bf4d26f3d5521ebf4c0b47e8d7b5', '585a7e6f569eeb2c5490ef94e3e162454f47e16c', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'ko.json', NULL, 2429, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(464, '08bd971ada532d7a5cbefbb67ec4bfc291fcf6a9', '0b881c4fdec70dc12724cc29d0bdeb6dd5330265', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'nb.json', NULL, 2243, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(465, '7c98d79de55c3dadf054d55f08778ed7c7d21172', 'bad5632c3c90293cc6142f735fbbc22c073aed7f', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'de.json', NULL, 2358, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(466, 'e1ddf20eae73e219370d127990c5f32984e4e4d6', '74eff98bd0783c7c0abafc8ff88803e3b63623ee', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/language/', 'mn.json', NULL, 2734, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(467, '0afa8feb82da610c5b3622963c4570969c5d19ac', '86b672add5a7cb4cdbce113cf797275e47b296a6', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/', 'template.js', NULL, 3444, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(468, 'b2c378516ee353df4d30797b670e2ad183059462', 'a77f9c03682a2134581852d1d2206fd8287c9414', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/', 'icon.svg', NULL, 3032, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(469, 'b55cf499f462557c5112e3d1fc970a99e2e06496', '33090b437fe45d3a4ab96773298ef451495c0252', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/', 'clip.js', NULL, 3248, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(470, 'a797d49a074793d53e7e8e123cfc88a0d33dc668', '265abb4c569579b984881f03e74b50bfa2f6ac27', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/', 'library.json', NULL, 585, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(471, 'c1fd13e8f6945d9b2e1f810acfce2b80e5b02274', 'f63d5f1c5b8d70c24ce0931a6a9b677913a987c7', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/', 'collage.js', NULL, 5011, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(472, '656aa053329a4b611191f3dd040cdeb4632e3f2a', '01588302cbabda13bb92ee0bc992cc780701dbfe', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/', 'collage.css', NULL, 669, 'text/css', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(473, '418bc5d9a97f8ef486a4078c906883cb15971bc1', 'feb5af05ecbd8ea8e9db9692a9c08cf9b7dded55', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/', 'h5p.svg', NULL, 1261, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(474, '83ee66877a18a45468630a9d02290626947f1f2c', 'b934f9a67acc04906f49f41eda0816a4ce0938ed', 1, 'core_h5p', 'libraries', 13, '/H5P.Collage-0.3/', 'semantics.json', NULL, 4254, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(475, 'b0289149dd3558bef1f32ac966ad55e64f285e8c', '5c9c54100c0a274a0f8b857e778fde172e656dd1', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'el.json', NULL, 1008, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(476, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '363e07cadacd9e5a07894cff27e57787f15153fa', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(477, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'af7daffbce9f237acab0f5c135c43912b8a96e15', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(478, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '064420816581635d7ced9f9a1591fd06464c810c', 1, 'core_h5p', 'libraries', 14, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(479, 'c594db6fb489fe8249cc3af8609c53b05ee2c83d', '929eb1bcc88c9d176953c346d29602ff2a07cc7c', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'sl.json', NULL, 680, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(480, '3faf429bc74d97c5af7a212fe229e10022990379', '78da1643993c75e34389e0dc0e0de9d8318a892a', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'it.json', NULL, 668, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(481, '7c2ba4376a5880b2ea22ea4fb9ac67c513710e6e', '63b2ac415fd6e3a2dd04f98175eed681fa90af7e', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'lv.json', NULL, 708, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(482, '900a750edb85615216927d8ed64bc657684de5b3', '21c162d9d45dfa1731b4990d55ec85eccad0500a', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'eu.json', NULL, 658, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(483, '61f27df95c09c737a1476c838b1f45169c338c98', 'd2b589271de3d0ef8c4f82771058bc66e867b6ec', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'bg.json', NULL, 1025, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(484, '00280c80284fed96034eeb86d997b975e03316a4', '8f53aa016118b4ef9679330c0b8dcd6f869ff99d', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'gl.json', NULL, 658, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(485, '467abc3bea0edb4ca9e2f57ca3af1310171bc59f', '0d36c9f247a35b5ebf7ba2ab16e8e4fe44a35ad9', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'fr.json', NULL, 669, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(486, 'da1a724085d007aaee48b8c42e1f9e535e769e6c', '7184e455994f06d23d78c8086e09a3ea32873e55', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'sv.json', NULL, 646, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(487, '696fff31485edf0dfe04bff1563c66b775a17a41', '06b6229745ea62d9b81858fab82d3da05bb69f1a', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'cs.json', NULL, 665, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(488, '48fcf7e0a55eb4534d4eefc4fe2bee44356bca42', '55d6c92cc23b8133180fdba7ef74ecbe996478b0', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'sme.json', NULL, 598, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(489, '9c5b7fde8ef48f253b4259bdc98890288002cd52', 'd9b0bfebd837dc4dd29ddbc732951e4751b1b5a7', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'zh-hans.json', NULL, 575, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(490, '8041337ee09247ae6addd81b6953425d7b04218f', '80acc8a93680de0c303ccef28aad3987ee96a30f', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'es.json', NULL, 682, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(491, '6826f7eb33064ebcc2b9e6efb6f9117c7f6d1fdf', '03219d59ba11b35dd15634cb5e3ebd50de5bf466', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'zh-hant.json', NULL, 580, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(492, 'a0e54e494250a06c64d1372cd3dea429647040b3', 'd9021eb731beb31718897c8dc120314e5e98f7b3', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'pt.json', NULL, 708, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(493, '44a6f5294df4731772426c694a6e12c612c96727', '65a193d5c19b9e225f6d6a166b707507f7c4dff5', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'ca.json', NULL, 718, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(494, '8041337ee09247ae6addd81b6953425d7b04218f', 'cadd187a45f5ac1f49694d8bedcaefed1c94186b', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'es-mx.json', NULL, 682, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(495, 'cfc1a8804a192ae86d1c64a2bb9a8e882898d87a', '952454dbaa41641d81123101dcd5270baf0a4150', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'tr.json', NULL, 664, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(496, '669ac7b0478e08351be8f191526410660aec38a3', '06ad007a61aa8a239ebd9a7e3cdf87a0b0b2d822', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'pt-br.json', NULL, 700, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(497, '48fcf7e0a55eb4534d4eefc4fe2bee44356bca42', '2f8bbe924b08fe277b17b0aa86882d9c5c4c77a6', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'sma.json', NULL, 598, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(498, 'c2a57207785fb0dae3b3d466e8dd1736811ce0ff', 'd8397dec3a9e598e94f9f23769234d5f19b73e01', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'et.json', NULL, 643, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(499, '48fcf7e0a55eb4534d4eefc4fe2bee44356bca42', '9f3bb9d4680be6d46885e554d4834fae77eadb34', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'en.json', NULL, 598, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(500, '48fcf7e0a55eb4534d4eefc4fe2bee44356bca42', '46d25d04bd30f7d2c2daaf9ba6aceac2f09966c0', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'nn.json', NULL, 598, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(501, '48fcf7e0a55eb4534d4eefc4fe2bee44356bca42', '9dcece4e6f25c5721b616fa244952b8e3dcdfae5', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'smj.json', NULL, 598, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(502, '07b2d9f835f8f3205b8ec33db5a204768fe724ac', 'c572fa104e770cf16d5e84fd8a539fdf1e24b08e', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'nl.json', NULL, 673, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(503, '24c6b43827f69bbceb7e68daf2ac71889bbd691b', '1c5f136ff17bd33fdaa4b7b37988b2aea6b5a7f0', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'ko.json', NULL, 679, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(504, '548574ec254494d997701986514cba02a3668a79', 'a9ad3e6e40fc1391cd4d8bfc30a73209c6d2ab6b', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'nb.json', NULL, 598, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(505, '6252f53c9f9a65db808b2f56c731fc42180f8471', 'daede84dcc7b7ee962922b26be36758043d847f3', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'de.json', NULL, 698, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(506, '5fea7636554a4377049b6d4377dc6f3a20f7a663', 'd00646acff4bc9719467ffa359528cedaac789ff', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/language/', 'mn.json', NULL, 925, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(507, 'e3e7b0d2c0c76ef53b9412da77351f16e41dbb27', 'b1319326b024f98ee65d3130c346128280279fc7', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/', 'library.json', NULL, 721, 'application/json', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(508, '4655e81de83a09f7e6ee44563f3928c649168209', '01bde97fe376735b20105b8a1e8bf603a4d71223', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/', 'collage-editor.css', NULL, 6947, 'text/css', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(509, 'f686a7992e04cdd44a2805222c3b5195807a372a', 'fb9bd82cc4ce98cd768cdffc562f517148abda26', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/', 'layout-selector.js', NULL, 3225, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(510, '6021f39383518828c996c22713325581f4d35a43', '53813e8623cce75c47228fb99fefc320699fc259', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/', 'clip-editor.js', NULL, 16222, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(511, 'fa7d87834a2c0b00efe78b1349a25b0c035317a7', 'f24584462c1f48ac1167f6890857543e07fd5e12', 1, 'core_h5p', 'libraries', 14, '/H5PEditor.Collage-0.3/', 'collage-editor.js', NULL, 10099, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731338, 1698731338, 0, NULL),
(513, 'b16c31841f43ce3680a70e5f417f5d55c7c27611', 'b7cfb45292672d5f3b11a73bc8225bd646d97bb9', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'el.json', NULL, 2089, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(514, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'e48282ec4522810119054b50fc4aa4a440064868', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(515, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'a3c16dd816b39585274ef48fe4c341f31e5a42af', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(516, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8599ff1849416ca841723f7a39574aeb38f0bf2b', 1, 'core_h5p', 'libraries', 15, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(517, '6b2b57de52f9b77f4258e2d3e73c9abfae00c1e6', '78c8bf9725fb5cba1a61940ee90b8db009f896f3', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'sw.json', NULL, 1086, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(518, 'ac235aa41dbe7fc9b3a96223bb2e8ebde261612d', 'a2730b5d12a5d7dac3eee07daa088c0e2da6b2c8', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'da.json', NULL, 1155, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(519, '281f589d09788ed7bfa95151c27576cb312882c3', '99bb72efef3797ac727170dc23c7c5de90afe86d', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'sl.json', NULL, 1163, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(520, '575e0b4c914d625f493f38fba01efae4912321f3', '887c145ba015d0844236d813b45c6e6933acde03', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'it.json', NULL, 1175, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(521, '559da9e22444deb7e5a66bc9bf834bdd44342348', 'c42c83df4ffb6f9612b4a40cb9dd6a21a9fafa9f', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'lt.json', NULL, 1162, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(522, '5f8cfc3b3300867fd37e0c06a51b3148c967227c', '38a5f4586280972ebe1c4f408d9f23318dbc90ba', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'lv.json', NULL, 1194, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(523, '88b8aabb268eddfcbeb4ea92a11e9744819b0196', 'b69e2bdf7abcf99b05b2e4b7977fb8728eac5757', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'th.json', NULL, 1614, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(524, '1e116f648765d775a055bf61eead14078a6cff35', '498ea816ecc90244a9ede90ebd8bcb73773b3763', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'eu.json', NULL, 1174, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(525, '1fe373cc3b491bfe65371e0cddb2181ffc54800d', 'a998a5813cd53ffc10b3c006164bf2e4dc56d5f4', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'bg.json', NULL, 1922, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(526, '919175486830dfaa21a0ac701f87c195a28b36b0', '14ace7dd0d6f300d2de98d5cc657cf345cd7609a', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'bs.json', NULL, 1079, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(527, '95c8072fdc25881864a6954320b76f3c6057dc28', '3c26f7c84b8466516196875a9aa249a66066bfde', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'ja.json', NULL, 1335, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(528, '0d35baddc00f41e7436fc0e0b0d0d305e02e1d35', 'cd27bb536d49d242a5dd0d51c7c446448a5ea0e2', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'km.json', NULL, 1874, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(529, '53bde08ed8fee172c0ef4829373396001fba2a33', 'eab4b160b504df41f647e5335d9cc75421d4b446', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'gl.json', NULL, 1180, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(530, '8460119b4d817c29e1be4ba9b9bd73038a49b8d0', '40b68118cfbe53958d1ba76805886b7f1435a16b', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'fr.json', NULL, 1186, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(531, '495245f3b228c614793a02e9e2ae848ad493702f', 'f08eae71e60f3d7faab81f14047b98d72d24c3e0', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'sv.json', NULL, 1124, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(532, 'c05fe21b85ab8b84802632988bf9b91bc9de4168', 'edfe6174f3eae2211fc9f1f579665bc7f2f73bd3', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'cs.json', NULL, 1195, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(533, '9d8dad590163ea939c4b840da432976d41edeed1', 'dccf1469f4e2a03b6ff10484c3f32c0082d6c861', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'sme.json', NULL, 1062, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(534, '9f7a5a1fe53dcada8d820aeb9d7e4d8097818e7b', 'dde25812601eede51b9313a88df92293356f4f45', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'af.json', NULL, 1142, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(535, '8a654195e5a49afc40b406f4f4a6ec42e45644a2', '4f479e19597a8521b00646c8d70d0b9b585b9a51', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'uk.json', NULL, 1606, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(536, 'aa7dc211aa5dc6bd771ede4f334908fee908ad21', '59c893eba7b892e2354d34911f99be7ccf4fe6ac', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'zh-hans.json', NULL, 1059, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(537, '996cba35678d2d499b9ecf35b85fdb52def8ca36', '5e9028998016af636238e146520f22e3ec53abfa', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'es.json', NULL, 1214, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(538, 'a38e13351c2439b2d3ccb1b6e757baa89ce1ae8e', '6d1c0e08c8026ae87c0c4c3dbcfdbec4bffcc1bb', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'fa.json', NULL, 1479, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(539, '26b08d40d9e02035ea68405bfba26307f49989cd', '6eea1c1795becc2ffd65fbabd305c441ce55c902', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'sr.json', NULL, 1668, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(540, 'b2ed36962372f03588e45be0d0c0f8e216760be9', 'bc7ceac900f16ceb21bd107762a9c45bfc4ea5f8', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'he.json', NULL, 1254, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(541, '9d8dad590163ea939c4b840da432976d41edeed1', 'edcededaac81670a41769dc208541ac7275af458', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'pl.json', NULL, 1062, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(542, 'b8c0d06ba3e1939332f79d0cd4e57397660810ad', '25450a5fe1be036a17552fbe008120c3fb61cd8b', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'ar.json', NULL, 1425, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(543, '9d8dad590163ea939c4b840da432976d41edeed1', 'c423c41f16d4703f1fffd7d8e1d6284db2a76b09', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'ro.json', NULL, 1062, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(544, '9d8dad590163ea939c4b840da432976d41edeed1', '4c512bb87db82b4255c9260069eca4875a6abc8f', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'hu.json', NULL, 1062, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(545, '6e8a186eb82f51ca5f3ed5c4ef745cd4888d3786', '030ac443c9420d6720ced55d943c1a4f8bb47770', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'zh-hant.json', NULL, 1059, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(546, '4dd59061088f6fde390e4431fe5d4a7279949bdd', '7223f3fa132ae24d366d3459b0a194d1de2b35b3', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'ka.json', NULL, 2147, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(547, '4ff7309cb7d8461f1bf278d0c6cd7d32b049e3e4', '29025c464e067159e432ad3ffe799cf3d4166078', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'pt.json', NULL, 1131, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(548, 'c735d1012594af1e1fc9d9d12440ab553d7933ce', 'd7fce295a511be0cbc0d3c75b27a188eac6c7fdf', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'ca.json', NULL, 1322, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(549, '37a5d5cd8dff0076dda5a58e607f6e5a7edb63af', '9f0ed2bbdf55a460fdcec322de9aec9e42835dd2', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'es-mx.json', NULL, 1223, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(550, 'c6876828d9dbbd148241dbf2556b55474fbe4d64', '8fcc45b4473b417f8c9664db9520e4f2e671bd80', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'ru.json', NULL, 1806, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(551, 'c1c03bf48a9e3599722f1e75fe646388825a40a6', 'a8d401e19247f4f18cd38ba4562c603a7ffd48ca', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'tr.json', NULL, 1219, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(552, '407edb7481ae7252a23cd6889f0250e5cc2cda7c', '13d5aa2b96a9da5dc5b5b41aaa5354c090735eaf', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'pt-br.json', NULL, 1202, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(553, '9d8dad590163ea939c4b840da432976d41edeed1', '0a9a58fd918bfee16853862bad3f7eba75f717bf', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'sma.json', NULL, 1062, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(554, 'f197ad64588bfe166035e87bf38a5f4f0467773a', '04eed8df847eeb325a34d2386070825578296a63', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'et.json', NULL, 1114, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(555, '06bdc2c9911596957315712f66ec86b6ac6462c3', '502e4f405d1a94b90807cf3bc310f1f2fdd6996c', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'fi.json', NULL, 1091, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(556, '99aae6b0580787c46a2f6426c3fb95cf31fe1ad6', 'a8fd7afd6deb6045f1065ad1dc5642ba86916fcc', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'vi.json', NULL, 1318, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(557, '64be9208d77667804492e0b2b5d9ec7aa0d126f0', '60802706559c2ce653c9c118687ce02c46afe6fc', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'nn.json', NULL, 1138, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(558, '9d8dad590163ea939c4b840da432976d41edeed1', '040eef70c33d9508e4b2d28ba36bacacbcbf4739', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'smj.json', NULL, 1062, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(559, '6e8a186eb82f51ca5f3ed5c4ef745cd4888d3786', 'e4376ab730c9063578e80df1a33bd25907d17a33', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'zh.json', NULL, 1059, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(560, 'a0f66c9a9a65e17e2d3133d60b2f7583d7721682', '7a70ee9bc4860b451462a6f29f23dc05554b3e7f', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'nl.json', NULL, 1170, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(561, '6b238cd8897d7c4c0f61c9f4e5f4636ee040c4bf', '23568cf6736b1168f64b5ce55da44da3f619323a', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'ko.json', NULL, 1314, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(562, 'ae1e2e7a584121342b2405e8d07b17a0e2023fb0', 'fbbdd6cda83e1062e9052c08f0f7b46c98bd1615', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'nb.json', NULL, 1152, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(563, 'de330dbccc08924fae9e3a08c069683ea8dd56cf', 'f0573182d783daddd676aa7732ee105729179185', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'de.json', NULL, 1276, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(564, '1edb9e9db9d22a5a35bc67e4d3e002c97bdad63a', 'c97a97f15947ce76836bddcb9fcbe0cddb334923', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/language/', 'mn.json', NULL, 1494, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(565, '37229a6dd696b9a8bbf335d81ac17f130703842b', '93f955d3a055db418ce5a34abd59ec666f0d8b3e', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/styles/', 'audio.css', NULL, 3560, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(566, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '9380a6c8bd3a9a7115b4d70495f7673a65bf57cc', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/styles/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(567, 'bf956e0da3a869287d27b39e8adc1499d0c803ae', 'f0fe0e5daac7edf7731f7bc0a6279868df10c0e8', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/', 'library.json', NULL, 753, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(568, 'da63aa46fda9deafc1692997401b8c0f12912acd', 'df9ab048fdd96559c1b25792bb666654909dafad', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/scripts/', 'audio.js', NULL, 10077, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(569, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'a8d1f3c26aabc3bacd49b5045b1ba73513255c0b', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/scripts/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(570, '0f38b4f3bb0acba4b0735328664b1cda0d72dc8c', 'ad6c4ff3ee99e6b5040993b5359be09eef5489e6', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/', 'upgrades.js', NULL, 1773, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(571, '1b8b216d73ab8a7c143eccc2793cf37d4bc5930e', 'acc5752e8c8c71064ca42d8adc3857abe4080ee4', 1, 'core_h5p', 'libraries', 15, '/H5P.Audio-1.5/', 'semantics.json', NULL, 2347, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(572, '72a5644509ad02fbc2b81166bb374e72039205b2', 'f6a838af93cb6554d2035f376d0612cf9997d7ad', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/dist/', 'h5p-audio-recorder.js', NULL, 135787, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(573, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '19e9d67ad2bfbad2f5c2acc7f1c1183f5b716367', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/dist/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(574, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'ef6615f7505d523a82d71b1874845237a2542be6', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(575, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'bbd582691f0a12bcd74c859be2547cc4f61563a8', 1, 'core_h5p', 'libraries', 16, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(576, 'cc9f6e82821b6244f778a474693a678eac3eb8a5', 'b7e4ede433d74340792b73b01b1b374684d24c62', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'el.json', NULL, 5131, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(577, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '45b1b053aafeeb2dc14e18797644394bee395b9d', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(578, '053ce4d3aa61d724c340169c729fb77d9c31ccb1', '2f7392534c64e8c4bc4423872b096197de3c3807', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'sw.json', NULL, 3275, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(579, 'a4a55510e7c921d8c45ba0b7ea8c2530f0a64b18', '79b530e839fff3aa5089177ee1c61e0aa5ad69f3', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'da.json', NULL, 2881, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(580, '9f765bd864a8bd50226e5a7f88d1c61a22453f45', '42e4cfc1bbb1bc89ea3960ec02a096d82d82eb31', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'sl.json', NULL, 3108, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(581, 'ac403ebee244f6386d606d27eb471c791e1d76a2', '542a7f5cbc51317a22466250f6c02757c2713992', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'it.json', NULL, 3335, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(582, '974eb365388a90bc772b5f71fa8c6451ff6c269c', '6b5f4250ed5e6c6c86e756f4a0511f3571652153', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'lt.json', NULL, 3342, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(583, '4808cb504862bde34845803634bd3d9ecc7d5777', '0c55e22b3e9b11c1703231ffe81c7b7f2023c160', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'cy.json', NULL, 2956, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(584, '8719e5fa56daf38730a4e618318953f66f2fb59c', '535850a708f2f727ef8e77c132e08c79b3ec8e50', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'lv.json', NULL, 3340, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(585, '226f5cc07381df590cd931ad53bafcfd12dc1e35', '729ec8375eb5357202ef98933cd19228f5eda848', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'eu.json', NULL, 3010, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(586, 'b832d69f5336521f7875f2ceb33e49d17b46edce', 'a7f69233f130e77302bfd6dc3bb0fb025143c3fc', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'bg.json', NULL, 4683, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(587, 'cdb1117d39001a9decac9036fc74f1528ac84a99', 'f93cd253ebb31ac5ef44d1725e6a27dc8bac099a', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'bs.json', NULL, 3047, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(588, '0c348f0143ce8b0e1be9b3909a01b6d5683990f8', 'a5f90c8689f3e97624a5274e8cbc796145bc5d82', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'ja.json', NULL, 3839, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(589, 'd35dbe258bd0afdb01975cbe10dd93e5621a7c0a', '9d293ef25c44dbceceb64357a7685a638f3e7a2f', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'km.json', NULL, 3839, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(590, '9a7776ab4a434f747ed93cc162e4ba706c16a6b6', 'cff5bcf18ac4b5dc5c16e745cb587e51fc2bc628', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'gl.json', NULL, 3167, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(591, '9430a899ba15d224ee757e08a5f4ffa704c57d9b', '319ac223c72441950d07e30094c8efb82e46dc35', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'fr.json', NULL, 3321, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(592, 'ce1de8139615997d2bf35c1e883452838a32fe18', '71ca49bb2d6088b45320f101baa8769a9623d283', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'sv.json', NULL, 3159, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(593, '1ffe9d29b8a5fa21eb7e16c44b1136eb1cdba59e', '13cbfcb9fb91f5776bf8902be7058d7fdc9d1c41', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'cs.json', NULL, 3180, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(594, 'a4a55510e7c921d8c45ba0b7ea8c2530f0a64b18', 'a9f0d0eab8464ee4570061e9cca30cd18241cb12', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'sme.json', NULL, 2881, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(595, '249ec0658f520a55eb4ad45b33f87b424ed8ecd4', 'a01b809cc57afc321c2ab2b5ec6f709e46e04b6c', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'af.json', NULL, 3085, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(596, '229cab30f55f650f5454c58716ee142b328cca67', '9f5170b60ef511b0edd2c7130b7bb29a84f2b2a7', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'zh-hans.json', NULL, 2741, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(597, '0a40aee0ea82ce33035dd9819f8607dbf5bb74a2', 'c31e8d1916d0a2336b3825316d346370b110c537', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'es.json', NULL, 3276, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(598, '241c7c94c502d7627ea0fc0da4e4380eb348b411', 'cdd520583218d3cb96d3645cbd4b4105971ff1a7', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'fa.json', NULL, 3963, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(599, '777074494252e69e5246d827c306d79731547227', '2221180676482b2bb98ffda2d7114dd78f069f95', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'ar.json', NULL, 3245, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(600, '8ffccab6326c950d9d2c34804a169660eabeb13a', '6f99e31e226d7fbcf0efd89152f2cc301ce8184c', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'ka.json', NULL, 5435, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(601, '8266956d72b44e13f0d90212d1a474355e2efae4', '1df9e4dfc1db98a9f3528b3a4b99af7fc463b756', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'pt.json', NULL, 3205, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(602, '136d9fc4bbafff5132d425f9a9df0583a40320c0', '67f046b1f6c2d3a7933e57cf81d33374d85797f6', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'ca.json', NULL, 3323, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(603, '62a83726023742ee79595a482b4375e75bfa5028', '01d0f41eadfec9bd68c11e50c8bdf929d56968be', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'es-mx.json', NULL, 3196, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(604, '70c70960125c1b6ab3a079c18515aae4d170a83f', '607fb7ac54cc0a9a00b520a028356cdfd4dd0a6b', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'ru.json', NULL, 4126, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(605, '2495d6ae06e8441aa7b7fba0d3f4fe6f8c9c8d0b', '6b686f540a204e44db13ed227f7f0f2d4199284a', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'tr.json', NULL, 3200, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(606, 'db9463f098e7712807138d2c462a8aff7a12e0b0', '921cef34831939e4649c5a729015cb25001cace2', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'pt-br.json', NULL, 3216, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(607, 'a4a55510e7c921d8c45ba0b7ea8c2530f0a64b18', 'c424bbfca25603f9697bf7eff9c8f4d54ba1579c', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'sma.json', NULL, 2881, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(608, 'ed8fc89c5d822cee23043faa0b3b88c55f006b17', '3fb5ca25982256e0aab8c33251485c8a89f2a8ee', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'et.json', NULL, 3102, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(609, '043b6b1365fd15f7c920b99eb546e05cbf880a07', 'ff3b0a4defdaac39a4e9137f20a095f0a934c014', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'fi.json', NULL, 3397, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(610, '53442a309265b4fae8103830c3807d9de4c3c4ab', '93ff7b2a885e91a5d88a3d4d65b5acf90f21cf85', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'nn.json', NULL, 2903, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(611, 'a4a55510e7c921d8c45ba0b7ea8c2530f0a64b18', 'd95f134fcb0d834029c04e66441918d14abe80ce', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'smj.json', NULL, 2881, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(612, '914bd33180e77b958857d3ea43611c4a6c8e4d55', 'a9ea466e23285d4351e32e4d337e9e9b846ece39', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'zh.json', NULL, 2738, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(613, '738d8c67b5914b9cc226a3ddddd4119a34ca0337', '430c15e70a7d3365210dbc63998029b7dc64d265', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'nl.json', NULL, 3053, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(614, '357fd05314c9dc37f76e732f3f2064b05b0dcdee', 'c69354c82b5f07e4a5138ede7043d982b6c89f77', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'ko.json', NULL, 3368, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(615, '2f32fc4a6d9dce71d7d593911d25a4c4b2e2ebe0', '600e8a097d82ec127c7b2e97350a725590130680', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'nb.json', NULL, 3092, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(616, '6f924bc39ffcc2a4bba2501166252a6f80098948', 'abf7ef238f934cabbed8dc1bdfde0d6c5285e43e', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'de.json', NULL, 3471, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(617, '2622651febfcfd097079895f1ab0a3b28f77f66f', 'c55d67025dd9e770ad75bb4f8c01bd29c94e4100', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/language/', 'mn.json', NULL, 4445, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(618, 'd6956ac20fba5b55b4152e2344dfc90336864a84', 'bb280bf962dfbd55d29807fbf79f5908ce091c72', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/', 'icon.svg', NULL, 2788, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(619, '09ab4ac3792798e7322c57adcc315b1054c039e8', 'f08696ddf1091e7641c96e9b5c835d4a46ad209b', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/', 'library.json', NULL, 684, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(620, '3688585907c75c7c238c7268c8e7e1f5be42ea72', '562d3bb0c6dc957566da1042cd748301c49b9183', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/fonts/', 'h5p-audio-recorder-font-open-sans.css', NULL, 307, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(621, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '636461657d4acd261206fb3ea99649078785f13e', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/fonts/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(622, '8033a128504f11145ea791e481e3cf79dcd290e2', '7d2661af55e8386de35503ac2912edb0dea45732', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/fonts/', 'open-sans-v16-latin-regular.woff', NULL, 18100, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(623, '600db9374e47e4f73a59ccc0a99bcc42f4a3e02a', '8fc9adf09fab847714e76f7d70204215ee1fa22c', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/fonts/', 'open-sans-v16-latin-regular.woff2', NULL, 14380, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(624, '8b9dca00f3eefd6ae07ee1ab8c21937fff070721', '36844236457a90d9a0660e098775ca73bde60938', 1, 'core_h5p', 'libraries', 16, '/H5P.AudioRecorder-1.0/', 'semantics.json', NULL, 3999, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(625, '6ee2b4df8113d5e7597a69c42e7323f848cdfa59', '46225f0b137ca884a2947cccb027a5abc5b05c05', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/js/', 'cloze.js', NULL, 7302, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(626, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '2a7264c8fc7fb31433f18b94833a46d37530a431', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/js/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(627, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'ada035e8b94cf805a9380fb6b59debb3d14b45eb', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(628, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '3398cf7b08598fb2e8e6a7cc68da1aa08c645c2a', 1, 'core_h5p', 'libraries', 17, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(629, '8465eea73a958cfb79e00c1863d0669aeb776344', 'f8c71bbf13ca2beb79382ea6e0eb0b7698e12e5d', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/js/', 'blanks.js', NULL, 29701, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(630, '1b3f8579a2e3f1d098d787298639a9012eb2f798', 'f252c7dd4b27ef262cd4214af1c61a4562e4dcf3', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/', 'presave.js', NULL, 1027, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(631, '36c76e9c4a6d8dfd3b2b9f3037768c04635326f7', '89b9d02b5255963a1f994be3f50438a539b5ee88', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'el.json', NULL, 10271, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(632, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '369c9996d050f0508976d920eb9c5a994282ce57', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(633, 'e7c84e075a5e56cfbe810182661d112ed0568e62', '1bf49bd092079d8ccf41eb96e8b88a69c465bb13', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'sw.json', NULL, 6819, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(634, 'd497899f49d0733f829c381004ab37c697aa58ce', 'ed112255deca240935bf4e443c6d3f85f44aa55a', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'da.json', NULL, 6390, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL);
INSERT INTO `mdlxd_files` VALUES
(635, '73072d64715a09f04e13063bf6f8783cad57ba3b', '11b0ce50cd7761c7b3b6694f5e97a91db3defa01', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'sl.json', NULL, 6631, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(636, '20787c18a0b7d32d0f7106779e246dcc435fe6f2', 'aeda3afe8f41cf16a03d801adcb352c690f90e2c', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'te.json', NULL, 11994, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(637, 'c3d63e5fc64776d1055f590b6f7cbcb52f1a48c7', '94e60f28b40865a3b20be99a0ffc659e7887f663', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'it.json', NULL, 6930, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(638, 'b6e191200e9824d2e231c5442e359d31f5347a05', 'ff5af5c4a7107f727a7f94c119115e205230ac91', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'lt.json', NULL, 6874, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(639, 'bae48c4084b6876c69dff005bbda5d5dd8788c79', '1743418a0c2215fa8bdd48b69abee42e98e38fb1', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'lv.json', NULL, 7018, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(640, '0ec886e77818feabfad77eb6732fb56758b5c629', '143369e7c5c9d34340cbf57406633f2a5fd0a22f', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'eu.json', NULL, 6697, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(641, '937058b0420467aa09d270bc7fde87705d6bdd4c', '1168dd97b0aaa2193a2cdfda5671c5f64447a50f', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'bg.json', NULL, 10069, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(642, '49ee020228ee2bbe0fdd355444501e36fedd9c54', '6296e0a5511f671650fd3a6cf1e17af209c698e0', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'bs.json', NULL, 6608, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(643, '02efdd409baaf1975c92026e0be4af5fc32ac663', '6247a8c982fab2355063dad5ff1e23b9ba492529', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'ja.json', NULL, 6874, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(644, '20a9bed499f14147801080287e4c24550f64a4ac', 'ab655ad78389bf86db6197f7fc0549edeebdf6cd', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'km.json', NULL, 10339, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(645, '7ba58617f6f0407cb63f922cf43da9b270b67e14', '2d593df59a016c23f35aad126fd8ac3889eb3b31', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'gl.json', NULL, 7099, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(646, '357501fbf5a902fd931da3bbd897ab4dc1055e18', 'b1e66547b28280f148709820a9b474360cef23b3', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'fr.json', NULL, 7215, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(647, '683eba7064b6d939abcac5a44a1d2c5f5627fd75', 'fb09c40c3bf33bd7cd3741efe05fa59288b1bb29', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'sv.json', NULL, 6609, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(648, 'b9ccbeda6c8127a327ac4aea176b3d2f82a0a85e', '0e9c58a9f15d74aaf77c123a901d4585730b8d6b', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'cs.json', NULL, 6826, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(649, 'e02f9cfa92ba209dd595135dcf0573ce7604767a', '3f1f9a269bbf2d6460ba7a7e04d2aad55f86f561', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'sme.json', NULL, 6287, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(650, '2ea9205739ec5e3fe1cca9a75747f2636e5364af', '8061ac7c182197cf1622fd2e2ec3e4d6de8e7477', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'hsb.json', NULL, 6831, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(651, '8ecbb764bb720074e087607726c458343a68ad05', '04d7e500fa6149778119085f2e46ef96f0852859', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'af.json', NULL, 6479, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(652, 'dacaa62c59b51032c0a2c1bf641ede09983c685a', '710572beaeab1b436212b881555ba7e95df5902e', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'uk.json', NULL, 9653, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(653, '99700980f4d592c6d77288e1feeb8d05be8847a7', 'a5bf35dfc6b0077a6ca16f90331d26bfcd4539c5', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'zh-hans.json', NULL, 5857, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(654, '3ffe779ed82b1d9a5797643200a17bbd82a4c3fa', '1e984689366aedc8ef008af854048c11729427db', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'tg.json', NULL, 6366, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(655, '54e2d3f5c54a59c0a30cbea939664e1effdb769f', 'a215c426e09c6f491232171ea7bf74c87ba49270', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'es.json', NULL, 7309, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(656, '91f01788e9090271cf79c39bfe0f2ae68628154c', '0d8d6da4039305ff36217f371d83c71e81f7e0a5', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'sr.json', NULL, 8875, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(657, '29077637cd6ea9cc54c6427308f86d541dfb7d4b', 'cd90ce36288e68b6d74311f668f866349c19960e', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'he.json', NULL, 7755, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(658, 'e3e43d51f0e6c16187c0bbc0c5676cc48b54f1b6', 'ee0f3b968a9a4797e697fa32f74095af94f19064', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'pl.json', NULL, 6804, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(659, 'df766f21c261343f7b7f4682b5a7c2f334593376', '75ed83baa40a767499c4f125895ae0da3c434e4a', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'ar.json', NULL, 7945, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(660, 'f476bebb2d3d91e5a0e838eef7f0ec36a4074832', 'e61b719ddbcead2863d3326a5c5be95c05f01bba', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'ro.json', NULL, 6300, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(661, 'e02f9cfa92ba209dd595135dcf0573ce7604767a', 'da968bbf2c79010387d4a800636a5ebc9e241667', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'hu.json', NULL, 6287, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(662, '45933e21e1d58002b10f8eca2b7db6b2f4dfeeef', 'ca2fc458bc8450ce486aa4acee812947af7461bc', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'pt.json', NULL, 7244, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(663, '03634392e8e94afb0fef2521ffacd971a8ca69ee', '4c43cb366583cd9814aa11f1c9899ac85f071e30', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'ca.json', NULL, 7318, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(664, '4f92c9a36623799d0d4a236783ff703adc52bd84', '75ca5c5268aedd77ed7336f81fc143f39ee2f416', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'es-mx.json', NULL, 7180, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(665, 'ea81ff9b569b4ab2c721cb88ff7dcf7b9b8a5802', 'ba5f899f6d4d905bd2dd98b9f5b4203af3faf7ff', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'ru.json', NULL, 9560, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(666, '3519929dc82383fc9738fac20d0d3ca1d5503818', '5146e264e946f3a44b8aa51e93239da0e9f9ab90', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'tr.json', NULL, 6884, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(667, 'ba6ec0aada385c27ca2f02324aa0bf8b7ea6253e', '0714e22dbdc0d4c7b2c2d0f71b9a25b3145475c8', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'pt-br.json', NULL, 7209, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(668, 'e02f9cfa92ba209dd595135dcf0573ce7604767a', 'fccf5daabf65cceac404e498c370dc0c6300c05d', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'sma.json', NULL, 6287, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(669, 'beb04c88af929fb4c05e8f6eb5e7938d8f94985e', '0568a5f6bf80f78213043d244f2722f49de47015', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'et.json', NULL, 6459, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(670, '4f48fcbc6fc7e51096921b442238bc682d56f74f', '5a6933b89de8f24ab935398d64895342bcaff3dc', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'fi.json', NULL, 6554, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(671, 'e02f9cfa92ba209dd595135dcf0573ce7604767a', '24d978cacd9c5de6ca1a397ccb272ddf13c26597', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'vi.json', NULL, 6287, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(672, '7e261d6e0f0af94ab95a5fd05886fe800b0a4b9a', 'fdd425e2b1ab1352052d5f1e8407b4ef420d2cea', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'nn.json', NULL, 6466, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(673, 'e02f9cfa92ba209dd595135dcf0573ce7604767a', '4607a80b8dc55cf9d95533a4a4e9323d4d62ed94', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'smj.json', NULL, 6287, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(674, '1f2f7a34de54a4aefb1a65244c4c6109111cf5fa', '69a5ec9f6ba6434d76d5cca3c78b5be302ca7084', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'nl.json', NULL, 6732, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(675, 'e8225e9c41b14b26f30811bfc21c13e434d398ac', 'edf37992b41fe2d8bf5244e8ac5042f7c2c8e15d', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'ko.json', NULL, 6882, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(676, '04eed05f5a707f43285bccd6b879d291849486bf', 'af68fb269b71b2af573dd36c6dbadfab63ed969e', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'nb.json', NULL, 6494, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(677, '3f982edf5dcee3524bd3ddf878da013e172e98c6', '37db699cb28a4cf6b86d272f63ca97fce30b4fb6', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'de.json', NULL, 7329, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(678, 'fd6d64617d50c863e52d4e67c679354e6a69dd51', '6a729aa671d14f8a604fd1780f5c3d65549942e0', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/language/', 'mn.json', NULL, 9417, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(679, 'ab70b4f267fbff5ac441b9b9b2de19be14cd66e6', '03e2683ba66b37654d95965722bf4972e0173532', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/', 'icon.svg', NULL, 3674, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(680, 'fc1e334f26f36023b24ebd7c44a9a5bc807f6563', '29c3cd84345d2b3cdeb60bafd08806fba123164e', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/', 'library.json', NULL, 1219, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(681, '288e9a55d8b038be56da45188a0a8059b2853cba', '2f29a6a1cc5e725d0ed76b1970c06e6fc796d2ab', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/css/', 'blanks.css', NULL, 2478, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(682, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'd66bb69cbf918e0d88d198818fc6fa6785066468', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/css/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(683, '013ca5953ceab66afe8b648589331735009cd97c', '5bdd1ea99b830c31292d8216f0325d0d4a12ffd5', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/', 'upgrades.js', NULL, 4034, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(684, '75b32e134010b2ae18e05ac7587288bc12239e40', 'e13211e8d6fd9be12753291f6ff64adc7d1cce8e', 1, 'core_h5p', 'libraries', 17, '/H5P.Blanks-1.14/', 'semantics.json', NULL, 12509, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(685, '343e98f51d116874cd06e0e2a96aecb8d5628bd4', '6bf0aa040247a85adfe9ce09e230f8c4b2840a88', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/', 'styles.js', NULL, 5577, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(686, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '154d7de8b2f4c07e3690e63c70e088b6336802f1', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(687, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8110e8cbd814227751bbd59c9b2abd333bbd22e9', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(688, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'f7b6041f9c845e157f1b17d115b2da7dee2d702d', 1, 'core_h5p', 'libraries', 18, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(689, '2d67c3d55a72f6fdfc59914774e46efba774c535', 'b32c32088c837c058bc789b4c495311fa44c40dd', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/vendor/', 'promise.js', NULL, 6297, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(690, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '10db3a37c7a7f2f925b1c6dc2f4b60d6e9d261ff', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/vendor/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(691, '993e470e02fc85117803c3313af1853c21caf853', 'ca0bb5277ccd10a6fbe542fdfb623d4c41c587a6', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'fi.js', NULL, 12638, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(692, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '1a64c52bd7636c2f49d034ccfbd953012ece21b0', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(693, '5c26780247a5b238aa85251ff4e4b8b1d42e0b3d', 'a0fe0e463e3e6d64cb7d8a6210fbc0ecc92d1b1d', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'bs.js', NULL, 11956, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(694, 'a8260b5cf7c7e2230de86046a072c5fc81ef55fc', 'f938c0126b84707b4b50f04c39fd523c8afd87e6', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'de.js', NULL, 13220, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(695, '00cdf281640dede7b1cb000678fb41b388f72193', '2c4259dfb1c9e2fae1740fd2f895c722ad05f6e3', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'fo.js', NULL, 12571, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(696, 'aab79812c66c29afc353032cea669c272d2b2e8a', '6c964e2a002d96a53a0cbf18a31539a985fd9e7c', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'cs.js', NULL, 13149, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(697, 'fa0416bdf3448fddf3b2d984b12a90402b836fb2', 'b5d37a062c89f68051a8bb0637407a284262d345', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'sr-latn.js', NULL, 12506, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(698, '1788886de77937cb2f52a32f3c6f9d5ad0aae9f1', '4b600036b20503e580594ec27f6fe164db4057e7', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'en-gb.js', NULL, 11912, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(699, '41a5aae4675b9642070c0685d90f62dcb98d1640', 'c1c6a480ead5467592b326ccaa2aadf42de982ec', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'gl.js', NULL, 13280, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(700, '72f8edd2b1917f3306b99704eba8834a4f85a597', '8ea1bcab345d8e758d7cb6c207aa0a06031d1b0a', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'si.js', NULL, 17020, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(701, '340b4e43ff95e3eebf5ea4ece9667a4895e58c35', 'cda7955a712923b44c47a1cf61eabff40ffd879f', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'lt.js', NULL, 13062, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(702, '12a99d58efc25da3b130bc66e7b48423c4493a7c', 'e4ff07710073e2463b8006c403dbdbdcf0aef4d7', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'en-ca.js', NULL, 11892, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(703, '7c46b7128908e55d84621ccde7760f57a3c8ee06', 'dcc32c797d7c77b3489a77cccf130f73c3df197b', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'af.js', NULL, 11874, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(704, '10c54d46bf0d3a224f03c8fec46e63877eae5c6a', '65180004e8a773445e60f21abcbd583a60770838', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'oc.js', NULL, 13497, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(705, 'b3c17f12818d41ce5b4925b2351f6708a60a28db', 'a4e0828804746ad1a71786d0432208a6a24efb60', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'pt.js', NULL, 13212, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(706, '887f66f7e2402ac96c9fa1c2f3d2cf7922efffd7', '48bb88eab646d3d71ed9846e189078e7b7430ac1', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'fr-ca.js', NULL, 13044, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(707, 'ba1c7f0a81fa7e62f7aa627f0d69916f57685baa', '73d1da6c65533cbd64bd24367e76cba4d1a60326', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'sv.js', NULL, 12307, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(708, 'a5fda2de98eec5fa898d4331d4e541c3f5b262de', 'cec56fd771f1c13f4f1136599b57160814556b5d', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'fr.js', NULL, 13770, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(709, '0ce17af4cca5b6c1ac19c247babdce27d34aa58e', 'e4224315512bd94ab7e64519e6ef7dfbc331d317', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'uk.js', NULL, 18763, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(710, 'b828776e41dd37744a9e2f1ccd0cef94f117c063', '230bb090fe0dd1782b32b90d35fed63a94ac655d', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'eu.js', NULL, 13013, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(711, '9a099533d09b8d667cf0d28454c501aacfea3039', '3f7dea3130ebc531cff84b007e0c20776138e872', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'ca.js', NULL, 13199, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(712, 'f92e1fac8d7f1a35b3cf25f1ce1d9bff528d35ce', '40fdf471b9d5c6a769c65374e4c0a67b007632af', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'da.js', NULL, 12526, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(713, 'f72b4f5ed4d89c5fd0bd8abc3796fa0c8af06131', '09bfb9eada8c4999d0c25485c5c5e27ff6a09fcd', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'en.js', NULL, 11910, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(714, '4cf66e9ec26e2a9ae021b270e0e5657ff91d1307', '77bbc8273126a2bc561fc5443b2e4e3e5cc8c607', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'hr.js', NULL, 12228, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(715, '697ad796f428fc17f7a28d9f5dac6c7eac9711a9', '7725dbd5780508f66790da2281e760513de6e079', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'el.js', NULL, 19729, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(716, 'bb8ac6cffe7ff2c0eefba593fa9fa50c78a4e173', '2741ecec89e48aa7c577f157d34e14bb7b379231', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'cy.js', NULL, 12254, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(717, '57925f355e2171ad849761db73903f14e6dfb9e9', '7ce99e5eeab8ec87c8dc4a9bbe3eeef782f84616', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'km.js', NULL, 23123, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(718, '4def2c40ff167d65c83d64e9cbcc2bfc803ffc0d', '6c818dda58aa52de25543031fc09602c5baec466', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'sr.js', NULL, 17388, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(719, '4c275e4e1ef4bf550b5e98b63bf1185abc2d243f', '253c5610546aef8b1e0132da2fd355f90397aabc', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'tr.js', NULL, 13173, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(720, 'fd58e42da5a138c53ba80b14901f3f50c95512da', '8d1863956d4a8539b82c393dd2dfe60aa39dbda5', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'mn.js', NULL, 15288, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(721, 'd913f947b5a54c133dc8d82b499b1dfed27bbf0e', '16148f1fbf0238ed4a7dd4e6df5ade199d9ae17f', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'fa.js', NULL, 16404, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(722, 'fd3d71b28ec6a48f3ebc1cd3fdce667458cccc36', '69cc749c45c88f650e893593e259c76047df3887', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'bn.js', NULL, 15796, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(723, 'd375a7e6aaa7e4f87204135579b0542cc301fa2d', '33bcd5dd35d58d5c7fb3d70567a3f0a58ecccb59', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'eo.js', NULL, 12594, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(724, 'b543b7830dbca651cb0c2522fff95d67ddf80f23', '5dd77aeb4aa299891f776974df560669e3a8795e', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'zh.js', NULL, 11569, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(725, 'a983ef9f65366325750903e8c366e003358ffa9a', '556a583f510d9158da131bff3b441efcfb29ff47', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'nb.js', NULL, 12147, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(726, 'fba0c659f4d43ca6e38abe45647d9aa4003082db', '2fdfe1ce08679b47c9402db4de0ac3869ae4a5f9', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'sq.js', NULL, 13484, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(727, '74420253b09083ec92019296766359e93ec66805', '42a79d91afb547c1756526b4d1784d8b6552ca4d', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'gu.js', NULL, 19833, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(728, '0899f46aee803bd8f2198c1aef2b20b59ffd43be', '47a74531f019f69d472af855e6e386d98c3f53b7', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'lv.js', NULL, 13288, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(729, '37df854dc5a884443955ba43d272eeaf3364e47f', '9e252405ec2fe51b140ba28e1730d8a973665371', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'et.js', NULL, 12297, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(730, 'a64d2d1dba860205635545ddd738f1115a8b86b4', 'f83b17d96fd14b07c05e3cb232fe42f1800a061d', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'no.js', NULL, 12192, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(731, '3b4a324b244ad17e40c7787a34e5b47b8ee6739b', 'fc86d60b54ce5a81e95cfcc493a332c1b29447a0', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'az.js', NULL, 12887, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(732, 'da9a43b4be5fbf72948cf6b4a8ac8c3f46afdbcf', '8d8869b3d27c7a6be3c30a404adece74a4780e11', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'nl.js', NULL, 12549, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(733, '4043a521d0889cfaa97ecd9ccbf9ac4096416005', 'b79d8c9bcb4a50607820d775ed719a0615c32d94', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'ru.js', NULL, 18663, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(734, '4af5a78feb0d828813e51192b521550b0307bc86', 'a7ce45cb4b8ca468fe948d6f501d677fc1e09e05', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'it.js', NULL, 13330, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(735, 'ca108c9240c802c86bc5d5d558e2198bd7275ff3', '472a6877e584b8ebf17ccf7dbf60fe7c63338b4f', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'hi.js', NULL, 15943, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(736, '5496ddfaa17fa4b2fda21344106bcb268d88d335', 'c798d33e18a61795d3b4242dda477136806c17a6', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'ar.js', NULL, 15078, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(737, '590a1f5be2b41bdbe0c60c4efbe8ec1642cf9cea', '4d1dc17b288337a4bd03604fb2314f11e7665543', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'pt-br.js', NULL, 13289, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(738, '3c5f4a99726ac585abfa9a1083c67ad30a3f235e', 'cf3157982880940580e500f7212322ed30464e4a', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'mk.js', NULL, 13347, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(739, '7922faf3c222be7404975856f4e55e3ba1a85166', '6347dc8bcdd49b5104eaa662a9519d91803de965', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'sk.js', NULL, 13243, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(740, 'ed511ba57cf347068704345b296f48e52c04ce01', 'ad51f53e53c783a52651cc52667ed70902338f49', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'pl.js', NULL, 13283, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(741, '7425643bd17db30a1937422a4909981f99d48ba9', '0da3f030b15de4d73605fe7fb796ac8e88810294', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'ku.js', NULL, 17808, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(742, 'e7d8cdaa94642c0b697ae6d64acb9409d5abb363', 'e29b61ec3ee018a8ecacf5180391af693a0a7a3a', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'ro.js', NULL, 13837, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(743, '420bd8f092bac5d3fd18ab250091367f961d6b06', 'd1403c531a978618623039c0e9cf6f5c5ef2e2d1', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'ug.js', NULL, 17742, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(744, 'b4e4c7401d914e2fd1e120e62234e5f86f153314', 'c9fba4fe5618477e569b38b205c0db5e3383b4a9', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'hu.js', NULL, 13433, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(745, 'fca6815996cb9879e2adc3eea331cf65cf448409', '8902dc0223d6635c696a545f65e5e2724f97aa78', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'vi.js', NULL, 14353, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(746, '7749149aa0bd9d5af046421e69d2ab1c357b72fb', '0eaff31a132469f3c418afbcabb692dee6527598', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'ko.js', NULL, 12879, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(747, 'f32b545c0dc723f76141357c64cf47c3cc1d7ac4', '2d6c38997e8f59636612556f53428587525ef438', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'bg.js', NULL, 18244, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(748, '878a580f81ca62a6326f20ce516c5b7a2b6637f0', '143967c381a2f500e836ff3cad67e56650a2c006', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'ka.js', NULL, 20871, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(749, '096193cdadb1db1912f0fa129f2fdac5dc762942', '0a7257375c0efd8d75867d09f269f8b2475874e2', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'tt.js', NULL, 15481, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(750, '8fb9d169b699138e0ad8cde69d3d891fba2ab85e', 'c6f8e87416dd0c64e1860c1f690cf6d1b3b923d1', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'th.js', NULL, 18863, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(751, 'a1b82c316d702126243e86a1124dfe864d0963fb', 'ec74cb0ab8ee9632a2fb48d12ea8f04d316e5aa7', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'ja.js', NULL, 14628, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(752, '7dda721f2d03a953de4309ade516f73b2c352d87', '64bbf87d60414d68ddb415f4e714cab15aa3138c', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'he.js', NULL, 14670, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(753, 'f5ab8ffbf2634ea77b3829cfb71f8a94cbfe4042', '5f860abf21d955226ca6b14480833ce380063a25', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'is.js', NULL, 12341, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(754, '11570828d979dc35939fdea95487ce1a028be661', '753471f43ecaa2406a6fd2f052bf7c02deca06ae', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'sl.js', NULL, 12432, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(755, '10948f32d9b7e969a91ee395f45d3bb241177591', '1ca6cade22857cf5b532cfeea8aa232ce64ea65f', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'es.js', NULL, 13306, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(756, '861714c1d64f91556edf919a4818c2393d6431ca', '52b30c4847b60eaaa4dd7770649f5784b4005220', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'id.js', NULL, 12228, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(757, '3fe1ac78e02335568190b113f15dcab7d66c8374', '83d7bbc7826205d3ea23a35630ae0d8c59f105f8', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'ms.js', NULL, 12076, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(758, '220eff836c3e16b189637d5cc40445fb66868329', '981307be607a2f2f7574c8d8d3b4f8658788eff7', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'en-au.js', NULL, 11902, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(759, '7a984294ddd493d1f442f124efb1176593154be9', 'e8e7d243c5316745e81eb0f03cda740f771f2c08', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'es-mx.js', NULL, 13350, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(760, '6acde1ed7465e9323ffb268c15db73a2e7dba782', '18a05981a2ad70e2ffa7259873965ff12a39dda9', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'de-ch.js', NULL, 13227, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(761, 'cd51261c71cb8cb8cf950c3bdf9f968d6ab91c37', '297dc19f24030a549bbb6a5bdc451cb3f7ad3edd', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/lang/', 'zh-cn.js', NULL, 11628, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(762, '338b2e71fbb73611cd9137ab745e71cebcece416', '1ca674d206e1e75e367e9d08582312a152ea9d43', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/tableselection/styles/', 'tableselection.css', NULL, 1145, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(763, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '574ef653f69d73cdf9c3df365152ad051252f149', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/tableselection/styles/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(764, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'c0cac6140dc03c7c6d665e4a639c7c29d8b7d70c', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/tableselection/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(765, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '7c0cd4ab4ef3217f0d71db71f1afe9f8ad114036', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(766, '82845cae28d80022842f48f405d16400377d336c', 'c17f170a38a2d34c547a58c181cf152523c48630', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/', 'icons.png', NULL, 12345, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(767, '9c573d85adf5b5636d265b22fe649c979e45c595', '35c193d303eb9e6e2d486b6ba4120e7c39598990', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/clipboard/dialogs/', 'paste.js', NULL, 3809, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(768, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '71379de744d276d6ad19634fc941e95dccd6fab5', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/clipboard/dialogs/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(769, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '1001e6eb13c181d679c647e561becdaada1d5ae7', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/clipboard/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(770, 'd1a359bd67710214bdb6755e8d528d6ef3a4fa2d', 'da02d88fdf7278582c095a7e3ebf2e29c0a8df62', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/', 'icons_hidpi.png', NULL, 38261, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(771, '31b53eda5c1e788e617ec727e02b8a18389b1f7d', 'e9fc50f60de15033af562a84a9bd8c18a3d53bb7', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/about/dialogs/', 'about.js', NULL, 1827, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(772, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'bb1bfacf9100ea0cbb9758b0714fa761991dedb4', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/about/dialogs/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(773, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'f96526e566d78f26161b751f6d54431ff2637f17', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/about/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(774, 'aefb41a490753d72965600685583c3fa82988ee8', 'd7f4e857d0d3b06008aa39d113ced3cbf5dbda13', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/about/dialogs/hidpi/', 'logo_ckeditor.png', NULL, 12236, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(775, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '7a73de5d2903cc4f49cf32fbe71e64a0013db94a', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/about/dialogs/hidpi/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(776, 'cb6445a702e59e7c72e8ff6e471a6351f680a1b5', 'bfdcdf4255e74c730a42813201e6b2f18e8d2fce', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/about/dialogs/', 'logo_ckeditor.png', NULL, 5650, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(777, 'f83ee036a82c524af5b5c7b9b18bf7340c194939', 'd408d42f535096fff1c1793be7c810f34612bbc6', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/scayt/dialogs/', 'options.js', NULL, 16136, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(778, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '3490880ff48617e0745baf84fd18975706d12447', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/scayt/dialogs/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(779, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'db7c3db22953b4cc4e87f5ff7d8d64abbd5f2b51', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/scayt/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(780, '21dc38df67bdaefe288b651c2256b846d1ad9a7f', 'b626651daf867faf33364ee21b8f059414130bab', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/scayt/dialogs/', 'toolbar.css', NULL, 1302, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(781, '64351615a528917dfd007e83999733572df68724', '3a439bed59adb951155259459890a87edecd523a', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/scayt/dialogs/', 'dialog.css', NULL, 419, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(782, 'a754040fbab295d2a8bc839169217070644876c9', '6a6cfdb2a5d8292d37a1e39c1668fc9cc395eb35', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/scayt/skins/moono-lisa/', 'scayt.css', NULL, 381, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(783, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '19916d8903d141c9df22bc7f07759a0e8b830ac9', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/scayt/skins/moono-lisa/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(784, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '382db4027e690afe84bb01fcfaf9d7c7ab8152c9', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/scayt/skins/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(785, '04286faa028b38a36c70c1c430fece7d55deb1db', 'f1b2521a809e48785c501b44f4cbf7e97ddda018', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/dialog/styles/', 'dialog.css', NULL, 249, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(786, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '30a26bb6393d8cd768cce9c8d8a6adae784de4c5', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/dialog/styles/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(787, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '3b514b53965cc5595af3489ac2048ecc4527afbc', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/dialog/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(788, '891bc4982ca35d70e5ece3c149969f9785a14e86', 'da525c5841337ebabcb347c3cbac9701f3efedc0', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/dialog/', 'dialogDefinition.js', NULL, 166, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(789, '9df5461c0b5270d789dbf179e8ab57d3a67869b4', '52f87cf3a08b5ae84811e88a7626e19f577f3b5c', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/link/images/', 'anchor.png', NULL, 752, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(790, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'eab8222d1f09a6fb36ee97ef1aa84268f2218df3', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/link/images/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(791, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '4069acc9c3864c318159049c40f67acef3cbc27c', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/link/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(792, 'bdfb9486360990a381d357d304b7b77eb23a5d21', 'ec7e6b8a9a1f48fbc39f9cc3e9a117971f24489b', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/link/images/hidpi/', 'anchor.png', NULL, 1109, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(793, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '1b1de7ad5c259df80b949ca5157b1c6af9baf424', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/link/images/hidpi/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(794, '3d007b19122412de83bb20b3feb8c846cd6104c6', '046c050522a9e166b9c6abe9f37c0919c3570eb7', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/link/dialogs/', 'link.js', NULL, 13234, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(795, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'f541f69d770e84d62ae74e9330941023e2f03c9f', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/link/dialogs/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(796, '2108c54013c77ca63b3b658828cae101b597cd87', 'd339281ebee180c4dbabc128396fbb10049b909a', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/link/dialogs/', 'anchor.js', NULL, 2107, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(797, '2f16cb4acdd7bf2cb74c9ae61b1f38925fa791af', '7c99ca309d6ebcff7cd1ec265450fb57cd36bb88', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/table/dialogs/', 'table.js', NULL, 8956, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(798, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '7179e60ad048f84a3dfd627c4f1fd07cfa18ec0c', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/table/dialogs/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(799, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'b17c233ec6217afb3a8b5b6b17ab27e58bd3fee9', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/plugins/table/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(800, '865e98c74090b814ce2d5981db2bc1843d5f8f91', 'e6118e78c08b5305593cb4e702ad5db19f0ec716', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/', 'contents.css', NULL, 3092, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(801, '8e43d461891f4cb71a7eaf5001514f6b3af038dd', 'c1fac0e3c3535ea6cde7a5fb59be1444427549b2', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', 'dialog_ie.css', NULL, 14657, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(802, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '38497cb6dd055941d131a194d449466b857d10b7', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(803, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '1e1bd67f7f490e8180e9b237184b80b5593be91b', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(804, '82845cae28d80022842f48f405d16400377d336c', '01c8fb1c8cdfcab3c22243f2a9382d61bbdac88b', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', 'icons.png', NULL, 12345, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(805, '7a06e75792c84191a6a8447e789b16db7b10d460', 'b8ceadb474ec1cb8286972aa577c7040a1bf30b9', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', 'dialog_ie8.css', NULL, 15206, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(806, '432bf891a4d33a9bce1eb9ca251eca5f3b96cb10', '3638ce611bcad110e696162ac9191841eaa81546', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', 'editor_gecko.css', NULL, 51351, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(807, 'ee56a339e87807b97f7354baa0c36185f1af0ddd', '470459b855b9af679f0824ac5747e4fc7971aada', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', 'editor_iequirks.css', NULL, 52918, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(808, '9e877ae3123c27f93cd61c93005ecdb3445c6685', 'bae1aa6d091dfe72bdba8f376eeec28006ca443b', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', 'editor_ie.css', NULL, 52269, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(809, '8c03e06c9da78da3dfc9e6db94410ef1acbc6639', '0846a402b77a2474a37d6d6c6d4c47cd8b2905fa', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/', 'lock-open.png', NULL, 511, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(810, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '82105f4c4866959d5585a8fe5dd8531aec5450ed', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(811, 'a4f2d59f7e999d8407a44e8fedf730e3ad525a1e', 'c0b880ef446e3a3c75281648509201d2b0ef0744', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/', 'spinner.gif', NULL, 2984, 'image/gif', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(812, '4a38c174c93f1d88c9144073bc91b66a7f0c46bc', '128612f163bb6ef406aee7519c7c0f9a55376f0d', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/', 'lock.png', NULL, 506, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(813, 'f73230c2ce2448b6a2cfc8278b608c068a7dbcb1', '82c9f934f621d61b7b2856377843258e3040e1b6', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/', 'arrow.png', NULL, 191, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(814, 'de12f47aa7ee36912866b43079048780a6b2e1ea', 'be511c0fd21b2407fda4096547e16e655c85636d', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/', 'close.png', NULL, 615, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(815, 'c1b77793391cbfa7a7beca2d84ad1ee69fc33a49', '7d246eaffd396a3601af0df3e4d8259a269d7bfa', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/hidpi/', 'lock-open.png', NULL, 1071, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(816, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '676fb90cd033e18aa3bff3b41379020209c3688f', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/hidpi/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(817, '3bfbc3f9af7f31dc2d50baa3d3caec8fa74e372c', '1c78f0fd60630454dff321fb0d84287d1fd882bc', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/hidpi/', 'lock.png', NULL, 1062, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(818, '63df89dde40d4bdbaf4c1799be473442a19057fa', 'a0ea6b44b2c58c93e7211734c1f59cf85f8cbbe7', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/hidpi/', 'close.png', NULL, 1238, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(819, '633254f0d6d5753b911be6661a760d028674ac1c', 'aa2d8c345dfdfcbe483d1ce26b8a10e3f633ceb0', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/hidpi/', 'refresh.png', NULL, 1623, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(820, 'efd9cd7de4d466c916166fe60dc3d923d4dc0760', 'aebe35bbc7e7ab483f0baa0ebbb485b4ee45c72a', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/images/', 'refresh.png', NULL, 757, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(821, 'd1a359bd67710214bdb6755e8d528d6ef3a4fa2d', '3d6b7f38a168c5cd71d4200c558242c1ab041738', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', 'icons_hidpi.png', NULL, 38261, 'image/png', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(822, '3cb40ef98ebe89b2e65d3dbc23840d571c8e23cd', '2ed81fe4de7767f3d9e2d84a6adfa63dac77741f', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', 'editor_ie8.css', NULL, 53075, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(823, '2c5299331213efba852290e37c00a2aa22797352', 'bacf4b518860fe755c0a25bda09f2006b96557ba', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', 'editor.css', NULL, 51270, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(824, '3542e1bae91e18e25f517c98b4a622c41f219d8c', 'b0c7bdbddef960b2cb9ea6a3cfbb679da9a17252', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', 'dialog.css', NULL, 13634, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(825, 'd4439420cb4b53cd97494a4ffea51700dc6e0709', '7461ca0a0c22974cf700967969677759cf55817a', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/skins/moono-lisa/', 'dialog_iequirks.css', NULL, 14686, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(826, '31cbb1889d3d71d7b5c4604c02822eadc4f6b0ac', '194d6bcc9c8087e9bebb2d420f86321e4f3a9f45', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/adapters/', 'jquery.js', NULL, 3180, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(827, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '1f6868cd098d33657ec0e1d34cc6fd775a2e6dd4', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/adapters/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(828, '946e512600ea05af32deb79edbf51c87abf7badd', 'ab8281479e123121f2d6c9446e63d652a914ca91', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/ckeditor/', 'ckeditor.js', NULL, 678083, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(829, 'ef21241c374614910950d7dcf2086745e732ce47', '631d037b239f62b157716682804039bba6d84837', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/', 'build.js', NULL, 760, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(830, 'fc6fcf3b5666aabd9b842646daaff06f13740eba', '0b80a54b33fdc1ba3fa6ae3cac2f1b673cde7fba', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/', 'package.json', NULL, 107, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(831, 'cc7a8d492f3df59ced47f04b3cd1e8274d7a65bf', '6a72c2f262ea564fc8d737ba7180a85ad72cf862', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/', 'h5p-ckeditor.js', NULL, 8826, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(832, 'c419c30d011a30b344a86d6638c9c8f0e1f14796', '86ac432aa3311764cd8f624f7ef6453229fddf48', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/', 'build-config.js', NULL, 2644, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(833, '3041ef4ac939c52a5c5274de6f04b5b102ad59d7', '2408c33c78e1b091345e347a000109af1b8f3fa1', 1, 'core_h5p', 'libraries', 18, '/H5P.CKEditor-1.0/', 'library.json', NULL, 338, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(834, '1ff13348f0c16e5034227e32b2a5873ca2223804', '6cf8348d5d1ebaf6ee4cb38c50ccd90f1f3a3e1b', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/', 'presave.js', NULL, 1177, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(835, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '29e91ccba1e87df4e10c65cd7ea7e85601b252ff', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(836, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '8d1eb5ffa36c1d8e3635b718604355bd286a5ab3', 1, 'core_h5p', 'libraries', 19, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(837, '4456b5ca81d9dd740e13134d449f4aa6101c4f58', 'bc29e5ac12b427a53365f80901c042c2ed632a0e', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'el.json', NULL, 739, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(838, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '2a22b215af7c075caa23c0bf4b4749d801b1c00c', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(839, 'e033df6e5923caf40c712056e2f2286a8cb58e89', 'd6afacc37370d8c34c5489dce17d1d488df3cc3b', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'sw.json', NULL, 611, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(840, '91f185a3d79dbd7f17b18133c58f04b395d65041', 'b447920206ecc89c9b40bb3798d546907a78af1d', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'da.json', NULL, 577, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(841, '5b0364a970a46ab63d7bf08315b29e29648ed8df', 'f15f6d66a7870ffc5bd19c6e449a7b440a194f0d', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'sl.json', NULL, 593, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(842, 'cb239337e8d49eb1d2986d2b36dd09d51aaaa3ae', 'b76346cc21c7f3d66f704d529121873de76450b2', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'te.json', NULL, 929, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(843, 'b480ed573abf9b52fc0f1c5a4cb46a72642e665e', '1afe4d8798a88da9af7f7419213eecb1d04f747f', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'it.json', NULL, 662, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(844, '4f0d744b8e748cced693768b74673906d732403f', '210c5b0841a0b8f1accbaa0676e2bf2a954062cb', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'lt.json', NULL, 628, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(845, '9b0976800abbd335c46ae43e2b77fc4a1fd4d7b8', 'ec8f34ea8a21b9a3117fd8a29b0fdfbc76e8aa23', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'cy.json', NULL, 619, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(846, '6b0f956e184def25b19f891dac2da464f03cbf52', '001735563a654bf3b85373083e3f4bfa0310a15b', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'lv.json', NULL, 625, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(847, '6d12624b4ccb5a7a2529ef6ba42206a057f7883d', '02333f9e420a220a63508df5be430fbe665ece24', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'eu.json', NULL, 615, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(848, '7b244fa6ead99c9eb419bd11dac2cbb3bd895c18', 'dcae83ef313b1b1a509fe067ba1f980b9104c258', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'bg.json', NULL, 837, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(849, '6627753345ecc429a3d51a2850a6e75698575a6e', 'b8a948aa633013a73150424d98021bd6ba3ceaf1', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'bs.json', NULL, 590, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(850, '1d7f63d91b2e696e07ddf71d5eafb6faae957d67', '8da8265b760bf5ca416bbfecf17c5de710cf4204', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'ja.json', NULL, 610, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(851, 'ec57c4451ad3c9166efacf41bdc3df0b7b7c4354', '42679296159d74c8d3e8413b2e1cd2f378d167e0', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'gl.json', NULL, 605, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(852, '46c92bd2c831d50f20d6decb591065b588397b3e', '09433da979f570cb52348db0864f83cd9c77bd38', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'fr.json', NULL, 647, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(853, '611aff0c7e8039134d406083db8962cfe964e1ac', '1b40ba1916aba2beccb6a9484ef0678e5ed989aa', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'sv.json', NULL, 615, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(854, '5ef8b8343e5eff554a2f637d156c97c89660987d', '27702d40e79903bee6db94839c310f52c23afe49', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'cs.json', NULL, 599, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(855, 'c2d09a03ea9cb439c7b1663e99da894f6b7c29a7', '9da69ff1b32bbf29c0323232d8a74762dce151ed', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'sme.json', NULL, 588, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(856, 'aa019a05529022fc08dbc191a2683617777d6372', '7f0db0ad65742e3eb422d6ca005d48cbc18abed9', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'af.json', NULL, 612, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(857, '4118c9e5958cfd31f9682766d6579c1a6d08c6ea', 'e385160b4b08f164bb5f725b84ecb3874afe2ffe', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'uk.json', NULL, 788, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(858, 'b46c8539f35b9835883308ff46488639ac6eab7f', 'f592970defa7125e275b5db0e095a000d2e9db8d', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'es.json', NULL, 615, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(859, '5df77fc0e64a0000452f249b3df98d4d3eceb6fe', 'dfc56e801125fe1f2e3765628670eadd22835373', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'fa.json', NULL, 713, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(860, '8f7ad21122416002c3f057a1823f51cca227828b', '587bad97008cba99566f370d755ccf0a61361b9c', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'sr.json', NULL, 704, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(861, '024ad08bcf9be68f43f561c0136fe8141b7a5943', '6574483e24c1213fea8257fc0504cc790b4927f0', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'he.json', NULL, 624, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(862, '2a15a82a468ea795a9d6c631b3fd760b931121f6', 'a731b38d2fadde99277c45ede97e60bfc5ba001f', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'pl.json', NULL, 598, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(863, 'db75938632cb6879536be779388f2cf180d9be1f', '1f48e53e799634b2542ffc4bb36eea753d6b675a', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'ar.json', NULL, 700, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(864, '91f185a3d79dbd7f17b18133c58f04b395d65041', 'b79465f95a80652379f657655d84844f964d3306', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'ro.json', NULL, 577, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(865, '91f185a3d79dbd7f17b18133c58f04b395d65041', 'db58edd94edffba8bba1f33893b38ab1cf97edd5', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'hu.json', NULL, 577, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(866, 'bdf311b46dd667e679af8486e0aeaf7755c2ae3f', '420c5b487ef24ff6565749922564a6bcf6603d46', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'ka.json', NULL, 913, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(867, 'b45955a711165c6efb88a31a75aa5144cce2c36b', 'f3319ff74378b890889333d8ca351a282d8648d1', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'pt.json', NULL, 622, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(868, 'f9e92ff6ef3c83906cbdc157529251f9a8a1833a', 'b51863f0c716573913ad7e2f15cb93863b02a541', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'ca.json', NULL, 669, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(869, 'b46c8539f35b9835883308ff46488639ac6eab7f', 'fb7a2dc53e42387c3730761115d7f20f4b87d3ba', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'es-mx.json', NULL, 615, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(870, '6dd5fe66744e24a57aad65cbfaa4f8fdecd1e8b2', 'f609c0a995273443bd019f3bcee19cab6327cdc2', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'ru.json', NULL, 786, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(871, '606d36b513d8fb3e2297d7d3ced610e4a0258b30', '032238e52debc0e2bf4e9b59b8a1abc04bfd1b46', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'tr.json', NULL, 618, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(872, 'dccb761f009cc9629174fa361ededb62f3e28497', 'f29824947f99515bea6cf5194b0f7786cac0d5e5', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'pt-br.json', NULL, 616, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(873, 'c2d09a03ea9cb439c7b1663e99da894f6b7c29a7', 'c893fdfae5024e81a18cc6fb90f5f62bf1f7df05', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'sma.json', NULL, 588, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(874, 'a105a4c4f4c6b5487f592f0b14c993021d8c2d2e', '09b7eb2a3e8b8128ee7500837465da566c8a1b6a', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'et.json', NULL, 567, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(875, '02d2d877317a067cb98d5cee758032b9f7a50c80', '33108c72c27bc5477c1ddf59a1b377b153a134a6', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'fi.json', NULL, 551, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(876, '9a7ee33d3f49c3da3d8799920cd8a3243e5d36a3', '259b2ec54fff5ab20c8d1f104b198450a9c52165', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'vi.json', NULL, 677, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(877, '91f185a3d79dbd7f17b18133c58f04b395d65041', '7e5671d028cd7fe1a0cb133cf1c7d7f2bffe5d06', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'nn.json', NULL, 577, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(878, 'c2d09a03ea9cb439c7b1663e99da894f6b7c29a7', 'dccc4dc606f87390fca58cbbf488153d619b18a8', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'smj.json', NULL, 588, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(879, '1f90ac32640747b493a2d5de9c58b3a54f299e34', '469a882a1c94a8048b5b89c6904f2f43b1097836', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'zh.json', NULL, 541, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(880, '63b3af3f5b6fa9aa9204c2824131e67068b90ade', '224ce5951ab0918b628539936dc8a55cfbf19e01', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'nl.json', NULL, 608, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(881, 'a88a37247470155947f471cf9c7b8bc4c272f3cb', '589386333d708356002c0a1a78a41efd260b10b9', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'ko.json', NULL, 595, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(882, 'bd2e79bf25c450cd9ccc9f185b6b6e8575220f12', '3a55f255b295a73749e06f983888bb6dece156ec', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'nb.json', NULL, 576, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(883, 'bb83a5f57b4611a6cab6d1d83ca3cb646060d318', '739a29269a0d886ef0db5f59027b04cded3197f5', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'de.json', NULL, 650, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(884, '9681533adc7e68c10d37b0eb44fbe0c199f97551', 'd00b7bce73b5d8d8c85a40da2b971edaf2322c95', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/language/', 'mn.json', NULL, 772, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(885, '8278ba6a6e4c15a3f7af8ecc54c7a337fb4758a6', '4ae9b483a9d70403f180e4fcea1cec323e311ebe', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/', 'icon.svg', NULL, 5074, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(886, '79330bea50923e00d2d933565390e3f80ef09de7', '806c5e713117bdd12dc067cf3151d6dc86093f0b', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/styles/', 'h5p-column.css', NULL, 2253, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(887, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'e71fc231ed2b1f6eac72d311143dfcadc8cf52c0', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/styles/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(888, 'd61fc8b3ab86ab5f0f4a2d6c41b37e727498c9ef', '19685fb2ac4937fe6c4bdabcc87239bf841ef275', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/', 'library.json', NULL, 548, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(889, 'a53e07f3737f1abd0ec78407c958bda29030be2d', 'a9a3d23b3321fb4f101c582b198f92e6644a0456', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/scripts/', 'h5p-column.js', NULL, 17647, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(890, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'dde39441c995d47b0b7a2c7578af3fcc5a09520d', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/scripts/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(891, 'c7755bfe4d242c5197e1546722f1cc020ff10590', '5004368abb261a2ae748e0a7ab8eb5eac794bd4f', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/', 'upgrades.js', NULL, 1443, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(892, '80ae2562a01161a274d566a919920cb274edd50b', '38e76a8706edfb1232757b620a514328733d0d6f', 1, 'core_h5p', 'libraries', 19, '/H5P.Column-1.16/', 'semantics.json', NULL, 2173, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(893, 'ab6311355eea09473732e326681fb7c16d53f251', 'b36ccf3fbbc606fe09f10b16da5c867d38af3783', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'el.json', NULL, 67, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(894, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '6386c4ae070c5ca82551add7dfbc95ed3bfb64b1', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(895, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '0502b28694668a1910933c393fdb7baf40e2c75b', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(896, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'a4c7266f861385f1192bef50809eb05dffe42f35', 1, 'core_h5p', 'libraries', 20, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(897, '7324e2f721d2de3b503f7636e0a32aa8a9d9678e', '2828a5c75b2a7127f03e42f98c777ddf37a2cda3', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'sw.json', NULL, 64, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(898, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '6d819afca56cc3effa70a69003db487ca6802920', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'da.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(899, 'e2adbd51e27fe6ecca94f77a29dcf6593c4dfe79', '15bea65678bbbd55e3f18e815be35f544169dfe9', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'sl.json', NULL, 63, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(900, '8d9bd343f08b3d161a6005ebbc32ef5823e3299f', 'ec298a3b5647c20e7788b03c0c5723a39843b14b', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'it.json', NULL, 57, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(901, 'e328a2543fa5527649bfad9f9beca6a7b1a84a6b', '97ae0271a4065c1117c2c5c30a8d1e65714f0fde', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'lt.json', NULL, 62, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(902, 'b40b362062ecf0d1929e5d739b63378c539c66d9', 'b362c5d098aaaab160bf0738ec443d74452d2c5b', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'lv.json', NULL, 61, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(903, '30405578c9383a49431189a6e4176897d4ad6908', '37539d0deb146858af719024c00acf35433d6e32', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'eu.json', NULL, 61, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(904, 'bc003373a3aa3491af7d9779e3397f547a4dee75', '55238bcb3ba3ec8a2464ccc3638f73c71ee0fe81', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'bg.json', NULL, 70, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(905, 'f510e22377a03e12ae00d4aaeef5867cf9da78e1', '2a8fd4d63c4c596ff3b49be2a29fe35f29983870', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'bs.json', NULL, 57, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(906, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '7c24a7166a0cd91c8e6d49a9d0fc9b582184aa7d', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'ja.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(907, '6bcee9b671dc19cdc90b30fcd712e03f3d32efcd', '0f43bf976a568c30b991767264e26f91a8efb23d', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'km.json', NULL, 73, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(908, '3ef75005626aeb0e05fe60d28d43659bb0c8276c', 'e23786e95d3201187724671ea5dbae7b039b44f7', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'gl.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL);
INSERT INTO `mdlxd_files` VALUES
(909, '32c2780340015be28decbf6ae560b29a0ab57c43', '4ab334c5a669f4c2b8b0fe68c2bbda06f494901e', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'fr.json', NULL, 57, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(910, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', 'fef04a62b104fa7318392aa9fa7409c372d198b5', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'sv.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(911, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '6ce00391e0418aa3d3d4bbebcfdfc8c0ce09e77f', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'cs.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(912, '0d5ac850fb811dee4b4878259689a236e60ecfd1', '441a072751b7be4bab2d91bb7f9f2e5039b74476', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'sme.json', NULL, 58, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(913, '67cb8751bc2a87c22bf96ebda71fe6d021e45fd2', '02e334f72120922e23f88ff6058a0878bcf79db1', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'af.json', NULL, 59, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(914, '82b0a30d7ee4741b58c58301e779d04c400681d2', '0064ad0e2c3b048be45c440394eb38fe69da18e0', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'uk.json', NULL, 65, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(915, '6a26d3ab80b883cbb31ef793e8087390c7201a35', 'ee52333a8f9687d2cd8308d0cb3d227d7997eb3a', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'es.json', NULL, 58, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(916, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '49490113cb8bd000c022477cf37a13ad662bab43', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'sr.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(917, '602a94a74ddb46477f73d943de230fd8f00d1ba1', '2d5d45759f3f32841d5ecbf6293b96442a68c15f', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'he.json', NULL, 63, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(918, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '60687ac8856bdaa7988351e408b3c3ac94514dfb', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'pl.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(919, '76349517f4532378a769e322f51a2abf72f81d0a', '75aae8d58e3995c3da224bcd1eec1339455fbbd7', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'ar.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(920, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', 'c7ca45b7fe2adcbe4b498c5c26bc8db10c9c4c22', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'ro.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(921, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '1c7c11e0acf26d48e09a5abae8e60c88cb13eaed', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'hu.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(922, 'a3e72ab53fa870394a866c1497850c13c4c6885e', '7d297e8d437c3d9584214c4cd118eb2552730b68', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'ka.json', NULL, 73, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(923, '6a26d3ab80b883cbb31ef793e8087390c7201a35', '056ec9a05c30875c9c315cf203b64c59c9f50938', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'pt.json', NULL, 58, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(924, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '46397a7070471bab6fec25b379b2350c1556c037', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'ca.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(925, '3ef75005626aeb0e05fe60d28d43659bb0c8276c', 'd5f33a92ba6684958b6d3a2ba21c6200fdf186bf', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'es-mx.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(926, '82b0a30d7ee4741b58c58301e779d04c400681d2', '9015aea14e3f7c2926e0055dd5d28be2dcb3a7b7', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'ru.json', NULL, 65, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(927, '44a1523e316ca97435e9f919ceb5c4b19aabd7fb', 'f2beecb943a32883ab74af481b43ddd15a80efc8', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'tr.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(928, '3ef75005626aeb0e05fe60d28d43659bb0c8276c', '504df075068cd411f09e5b3f6db5059d90c51bd8', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'pt-br.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(929, '0d5ac850fb811dee4b4878259689a236e60ecfd1', 'fc97ac5273e0803e28ebba0bc86891b06bbd888b', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'sma.json', NULL, 58, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(930, 'f510e22377a03e12ae00d4aaeef5867cf9da78e1', '1106555f87b38f78ce4be9f8b51dd975420a1752', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'et.json', NULL, 57, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(931, '4a50a9c390d53df0cfd048d9a263bdaccb13f6cb', '95ef733f9381f928869b14bfb5d543243708b703', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'fi.json', NULL, 59, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(932, '2ccf078f460e159c191594b7b58b314281378158', '77e073a6c677ce36aeddb5c7e3fa257773e30691', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'vi.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(933, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', '93cc7f78d0a0fe9e18dc8c847c8e624b5a43d254', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'nn.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(934, '0d5ac850fb811dee4b4878259689a236e60ecfd1', 'c884673ba094cfa3e6c24b8e2612b434bb125868', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'smj.json', NULL, 58, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(935, 'f795d3fa8cca3ea514d1deebef868f65e706e8a0', '1c6e12ccd699252e8deb33d2f0909675b7906fae', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'nl.json', NULL, 60, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(936, 'e376ba9bbcfe6b2b2cbde798692455f297231351', '1134eafd383b871e348d5152cc3d2143f54a55aa', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'ko.json', NULL, 62, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(937, 'f510e22377a03e12ae00d4aaeef5867cf9da78e1', '00d964e60a508321f4c7c8855d6e6c4ecdf94951', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'nb.json', NULL, 57, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(938, 'f7da727c1a6ea64ec166440a46c4a06e483824fd', 'cbc6bd86563feb8b58c31f40188744dcc92092ca', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'de.json', NULL, 56, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(939, '82b0a30d7ee4741b58c58301e779d04c400681d2', 'a68ee3740cd87773fe5915426a716d2a932ef309', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/language/', 'mn.json', NULL, 65, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(940, '0f298cfcf45e3793f96b8a8847a4f8b8b875f0f5', '085541669051981e9e88f9852f86741762737a7d', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/', 'library.json', NULL, 398, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(941, 'e00d5c423cb6c91f8d92191a5c4315440e8e6b54', 'f42703fb7706eeba4599ada0a33a90c096a6d38a', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/scripts/', 'ct.js', NULL, 4359, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(942, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '6096633be42987d8fcb10cff300467a41dca20c7', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/scripts/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(943, '64f52dc368977d67a8e20fb86d40f552c5708e98', '78bc93e6c8d81e209a44ad211e760d37cfee3b3b', 1, 'core_h5p', 'libraries', 20, '/H5P.ContinuousText-1.2/', 'semantics.json', NULL, 266, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(944, '031c40652bb4769f2f475757e5dc335d11669d63', '12f1fa7128b0b657cb284bcba8762ac2cd6333b8', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', '61a1a8420fdf703c7ba1.woff', NULL, 8096, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(945, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '39fe5079f5877f627cebf524c3dbcfcf7b95715c', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(946, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '7cfdd9eabb4f401fa7d76fed5f130d64d049a08e', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(947, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '693526938b626ee4584519269140f5ea3f2a163a', 1, 'core_h5p', 'libraries', 21, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(948, '1c7cf1839d5a08786a8d496d75532b533d9a62cf', '29567cc06efb9a3d41ac1749a7e389fd4cc1b369', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', 'd90853a4f553e6c2b974.ttf', NULL, 42480, 'document/unknown', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(949, '0e8319a6b6a95a539c3758b8fe020de7847f25c6', 'eee7758309ae4a2f54584228bcff3f565c41496c', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', '8f9e23fa0b1424e71ae6.svg', NULL, 29617, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(950, 'dcfb1ad5ee64c96d24fdebc1316215bd02805ff2', '98ce1c425abeda6856927aa5386fe30f2fdbcdbd', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', 'h5p-course-presentation.css', NULL, 38171, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(951, '8c9078d7ea537b24814dc1afa3aacd8224d9d0fb', '5127c34368681c92de36787445cfd6767546e458', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', '02d95842a0c03186d030.eot', NULL, 8168, 'document/unknown', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(952, '8c5ff57b1f8a1e88229e512a15b6cf3cf0dbdfbc', 'f71499a3030d9086262284ead827eba8a32bb82b', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', '6382a85b843d1e96f72c.ttf', NULL, 8020, 'document/unknown', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(953, 'f786fc2b26717edabaace5e8647d0bd9641e4d3d', '4687f3c2e8909f22600e1ee00ede6d614391c553', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', '500391a5880cb0fbf3b6.ttf', NULL, 41028, 'document/unknown', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(954, 'cc046d336b61a71a3647463b98b77325956b0992', '4b6807488397236ce6656cde12a6c1a59452b334', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', '41245d17721f912e3aad.ttf', NULL, 7472, 'document/unknown', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(955, '179670f9b4518fbc0d0e251b9363cd0648af7806', '388286a61929c3a4f1392b7b9099910b7826baff', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', 'h5p-course-presentation.js', NULL, 69211, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(956, 'a4a6705a547bcb455b917b68976ca6f278d0b111', 'acbc3f7571f830b0eeff1244bb61b7a4ebe85ae5', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', '54554adb1b5ae70e99c0.woff', NULL, 7548, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(957, 'de7d4fd8cc09c509ac4df19f13d8c8986785f44e', '3f80323d483039568fb72df7be6d4406d7428aa7', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', '6c165c549b0dc4025352.svg', NULL, 1419, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(958, '149a3abf09a967c31794937de4efda9aeaff4567', 'af623a28db8cbcd24c4842c54bb587bf61c48510', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/fonts/', 'H5P.eot', NULL, 7620, 'document/unknown', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(959, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'dc422083de0df54bb3fdae2acb3cca998cb17547', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/fonts/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(960, 'f786fc2b26717edabaace5e8647d0bd9641e4d3d', '9f2c174cdfd5b984ff1a15eac1c0330dcdc43a28', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/fonts/', 'DroidSans.ttf', NULL, 41028, 'document/unknown', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(961, 'd49935bdf788ec43794057f33aa82f2aa19fa6d9', '07cdfa8803135b9e89751799580068f0d14336fd', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/fonts/', 'summary-icon.svg', NULL, 1419, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(962, 'cc046d336b61a71a3647463b98b77325956b0992', '55a53b4c4d6c141665db6b9c68306addd89f2e20', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/fonts/', 'H5P.ttf', NULL, 7472, 'document/unknown', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(963, 'f231e9ed54e5e93583ccd91bf41f4ab975c25c78', 'd99d513b6d984f2a713ba105bd75c0ab1f506176', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/fonts/', 'H5P.svg', NULL, 26884, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(964, 'a4a6705a547bcb455b917b68976ca6f278d0b111', '30cac530fcf2194e45b7335aa156e9b586db3fb8', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/fonts/', 'H5P.woff', NULL, 7548, 'application/octet-stream', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(965, '1c7cf1839d5a08786a8d496d75532b533d9a62cf', '0c4d865d7c76d198150494e4ef4225fa3ca55dfb', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/fonts/', 'DroidSans-Bold.ttf', NULL, 42480, 'document/unknown', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(966, 'd49935bdf788ec43794057f33aa82f2aa19fa6d9', '47874a6e2cf0edf27093cd0dd10cef82e957cc68', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', 'e9124eab8eb09ecd01ea.svg', NULL, 1419, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(967, '149a3abf09a967c31794937de4efda9aeaff4567', '515d057b2e47fb65404a766f9f10755a4f41a9d3', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', '0650862d5d3b3cf00361.eot', NULL, 7620, 'document/unknown', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(968, 'f231e9ed54e5e93583ccd91bf41f4ab975c25c78', 'b1b8ed6924d04eba1166e51ae8bd3cf18f61813d', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/dist/', '515d9d92daf54ec52fcf.svg', NULL, 26884, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(969, 'b00650fc8dae030c2bc345e46571d1b611df0714', 'bc3266bf297a783d61674249c13d0543a5e69ffe', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/', 'presave.js', NULL, 1781, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(970, 'dac6ccec930a2907fba3b2194443b2f205bc5e02', '3ec523f8d5ce8b982840f8fbfab4cc8a965619f4', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'el.json', NULL, 19585, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(971, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'fc65b3c328a4f399fda7c39a69b1addf0befddd4', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(972, '94596278b3d88aac8be9df49138bd319cdaf3df5', 'fc4281faec75f59de75b93e764b9855e99ecaa94', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'sw.json', NULL, 13401, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(973, '3203a98157dca17a661680cc50e196f4d8641999', 'd5e8afc984f50c645e07394e59fd92a78ac37cdb', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'da.json', NULL, 12920, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(974, '955f813ff488dad26b252167c82257f981c31d74', '3af936e1648d58f1310ee1fc17d68688826711f0', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'sl.json', NULL, 13303, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(975, 'c51ff97ede1f9065c391350cea665d6a385201f3', 'c98d85a81c74dfaab6344f04a22d7c76e643853b', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'it.json', NULL, 13868, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(976, '0a3dd7209029a34bf1fba25923834d3c5d8307b6', '4e49ae7a5b7b7745db75c86c03b58db994e7ca6c', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'lt.json', NULL, 13782, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(977, '3d7a6b51e046463aaf02e1c5764e1d57ee6a703c', '6835f5106cb6c74b8c1b5cfafcbbfbd2db49b8bb', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'lv.json', NULL, 13761, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(978, '92692198ea5d4113820dcd4b96f7a853357d0d4f', '21ac9c6fc82a8646fefe384d8ded3b69c396041d', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'eu.json', NULL, 13775, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(979, 'e45473857f5b888870c16b8ed5118dab16f3ff9b', '42339fcaacbec7db510096b0e4b11fdd9bfef4eb', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'bg.json', NULL, 18095, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(980, '323412efed0f44ba2785679a39f3668a160e782f', '7a648aa722e2a3f9585bda162207adaa1893f375', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'bs.json', NULL, 13049, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(981, '0a8f959178e093c53409adc53d7e48338af7cdb9', '08a1b09c72450379caee957a9ceb2a2760f2adc0', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'ja.json', NULL, 13823, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(982, '9cc6f94fc08a7cb9515f7fd324f69a459a9b6269', '3689aaeadc13c63e13025fc3b75f25e6034fbc2c', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'km.json', NULL, 21642, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(983, '48fb4081052cddf4fad5cb5e8f9f169fac28d7cd', 'eb675fa9d0d47a95e65ce93ddbf5cae0d47ef876', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'gl.json', NULL, 14115, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(984, '8dfba1aa3d730a566c9fcb26bb3fe55749bbc3c5', '6270616c366c18fe7a002e5b304c5ee4b909d962', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'fr.json', NULL, 14493, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(985, 'a25829660172bd4652eaa59b6af674c90321d5f8', 'b728227bbd12a36aaecffb3185b18eca9190dbf3', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'sv.json', NULL, 13287, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(986, '226253318f5ce6b965363a1a6632c924e19e61ac', 'dd276d853429fd7dec5d16f0718cb952b0b170c7', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'cs.json', NULL, 13543, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(987, '2d73da31063267539b7e90da54e7094c6838e047', '6526feba6f890696487eac6a9137e6e9cd2d4a85', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'sme.json', NULL, 12685, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(988, '266ba1de27ff43c83a310fab262194755ccde4dc', '854e535e03880e7682c3d3654fcce05d5cf719ea', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'af.json', NULL, 13110, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(989, '0d05bd8ea07b6c86a71aca27936fcbc14efb28c9', 'c3d4addfe795d3942254acb1cee0f48e5b11640f', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'uk.json', NULL, 18319, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(990, '72bb7e5caa9dd61238d0612b4c152c1b2391b24a', '242fea8fe228b9ec1d4a82fc14de49d90f7e463e', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'zh-hans.json', NULL, 11938, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(991, '209035550e4652337aaddd089ca330569626fd65', '54540d5a69cbf94b3cfb0df94ed9f2c49faf9ab0', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'zh-tw.json', NULL, 12099, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(992, '50a9ff742af1e8405e3a98da4c621749a95d4009', 'a00cbc085bc4bed2a2c6790bdc9c578aa9f23d74', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'es.json', NULL, 14457, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(993, '326c7f43bbda688eca523c3068003f9903f256ce', '461c53a76f5f0a58d9af936fce708824860dab70', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'fa.json', NULL, 16537, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(994, '46a0da281cf6b909b83b9558c582091df223b3fc', '4adf8f34fe636bae21a4d787882963c8373c69d3', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'sr.json', NULL, 16461, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(995, '6cd9527fd5f2ba961270af632c4e8d9cc81e7acb', '319c69f5a6f3c874e71256c1ba18669261dcaf84', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'he.json', NULL, 15200, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(996, '95205b0c0ea4a07e0f3f85d50862d398af321e67', 'cd9e49ecd2f0fe22426d959a6af36a8b70334045', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'pl.json', NULL, 13901, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(997, 'a45fb3df938f7bc18795c32799cb5573fbc409a0', 'a1958087980bfcb8a5ee966d9ad5114c9581b0b2', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'ar.json', NULL, 14755, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(998, '5189df3abf31166ce8feb81c90235c350561a2d1', 'aa5da16a115df1a14e69d46b5d274e6f39b93419', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'pt.json', NULL, 14001, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(999, '4ed0626f17ecfcb459c70bbc6f2f58928cbbec97', 'db8e73bd7ceb48e834c62eec868d10b10ddc3bff', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'ca.json', NULL, 14147, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1000, '1f44393e7dd4401741ce506cad3ec33e63fdfab4', 'a290980acbcb4fcd634c6e9b30cf6582e90b081b', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'es-mx.json', NULL, 14342, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1001, '502e21237961e51f9f4e5f2ef6ca81bd1b427c5c', '5bd7c83132289e1ab324b7cb19fc579cde9c1a72', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'ru.json', NULL, 18263, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1002, 'e095e2084d66a8e0a63d2d8ea69e9705e1fe6805', '7ea8d348a98271a0251b5c9e38dc7c23adbde557', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'tr.json', NULL, 13637, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1003, '8520b75dda56626682496624355aa6413829a400', '27cf8f4e2e0107204c1e4bc82682dbf110620641', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'pt-br.json', NULL, 13974, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1004, '2d73da31063267539b7e90da54e7094c6838e047', '83e4dad8c001aff91f518942ac0e7042780c4828', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'sma.json', NULL, 12685, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1005, 'ad0fb591c75e7f19f3a976b315a6e844f5b64e95', 'aeca5216911581da7b9f7bcf99a371c03a1ff221', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'et.json', NULL, 13140, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1006, 'f4d2c3e7c24b9826eb144997c7242a080ac5591a', '9f8589153c2885227a5d3146f4ebf25db41c8d9d', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'fi.json', NULL, 13896, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1007, 'a13cff9369f648b20ef6d719ae5a6442c5055525', '79f107024d3c88852c1838533a3e2552d54539a4', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'nn.json', NULL, 12919, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1008, 'c72ecfc2e4dcb67ed2c69b11d2fc9fdedeeb1d8b', '04f1c36cae0b37c94935e83a9aff9319591ca783', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'id.json', NULL, 13336, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1009, '2d73da31063267539b7e90da54e7094c6838e047', '42da8a8b78f298cb1f5e49ef843abdb8ea54fe14', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'smj.json', NULL, 12685, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1010, '78588e63f1f444a04864ddd9ea6458bbfb113bc7', 'dfdcbcfd626f438c31279db53d6f2f882a2776d4', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'zh.json', NULL, 12104, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1011, '06974e37ca39010585fb452995e24869267c6bef', '10189aad8d035d777ac7ee6237f113b3498114c4', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'nl.json', NULL, 13546, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1012, '79c9c6862cc054c15df94c0a88bdc420e2a4b96f', '410e7c2dd9ee6ef537f3163731722d3873775359', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'ko.json', NULL, 13674, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1013, 'ed7ac45023744b063db7ee3dac2b3fe9c673a34a', '232fee3bc4876fb7b22323f5c7827bb19b146628', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'nb.json', NULL, 12782, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1014, 'd263b98a37dfa02f007208e72f593b63937e7c20', '23e8ae397d9f4beea5cf022495b60906ec79c567', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'de.json', NULL, 14126, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1015, '70c2d5ed44d17b96932f22f723ac24e6a2883b76', '8878c2b698ebad02cf57f1a80057a1cd2c286103', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/language/', 'mn.json', NULL, 18043, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1016, '0419bf5d5c846b7fe245bbc8759ff9dddb1100b5', 'bbc265563eec0ffba83ad5c90c9441006d04cd84', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/', 'icon.svg', NULL, 3385, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1017, '2cf2e29f89af0976413acdd2a92d60aaa8ddc311', '6d3a0528033a69d95ab7d7d0d909c718c71a438f', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/', 'library.json', NULL, 1213, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1018, 'bf90937fcbbf1955b6370caf6939b34669d25436', '27ad5e7c833fa3d4d03dbaf2684cb77ceb7e8189', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/', 'upgrades.js', NULL, 12017, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1019, 'dd2882f3e30a8817b4f4552c08eb813c0189b920', '2c2f91f0c432b402db1a4daa7b6be8fef4e456c5', 1, 'core_h5p', 'libraries', 21, '/H5P.CoursePresentation-1.25/', 'semantics.json', NULL, 27819, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1020, 'a682dd36ae4555554e68a29f9bbcf5bbace3ec60', '1dd93bfde60fedbdc609414614013f50457bf723', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/dist/', 'h5p-dialogcards.css', NULL, 12828, 'text/css', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1021, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '7d220833e773e8525fecc411569db95a7ca8979d', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/dist/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1022, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '0956b80fbf11b9fe160a1d76947c75e5464599ec', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1023, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '23cfa12d1ce8820d54bfb8a9b7d688d2d77a61ff', 1, 'core_h5p', 'libraries', 22, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1024, '45a9d621843c1cb1abf94087756cadcb0eca6ee8', '19bf03132290538f85981699dca496616b6ea483', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/dist/', '2aecfafb6066a6b8c73d.svg', NULL, 1243, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1025, '3d49691bae12e6ff9468e4d502c62f8ec56068b3', '18e214c7c68a4c5e1832489c7cf2bf060dd8bf57', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/dist/', 'h5p-dialogcards.js', NULL, 30732, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1026, 'af6147add037cf703779a40c3b961fa8bde8e2f6', '4f2ff75a43a50c3d8b22b5fc9f3eecc0c66e9c79', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'el.json', NULL, 9238, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1027, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '07ae992f004938e5dd988ddcaca30d09d5a4ce52', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1028, '0c6596a1ddcf2207de64140a049f454ec0430d81', 'c3adbb0db3ee2d5a8470c9941a131bf16d678437', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'da.json', NULL, 6064, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1029, '72dd73e68bd138118d30881bfa11557a3756ff86', '26ef0805d3f1d82d56276a8e786f4e425f994144', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'sl.json', NULL, 6282, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1030, 'd26cbdf00a85ccbf3398fc98875584e4dd4522b7', 'cb961488d3d22bf685f7324b22007ebdaf34a957', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'it.json', NULL, 6523, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1031, '2d7a9ce07126fc3cecb7a15c052393868067a018', '3cf4557c7622f1667095753bb486ba43effaac04', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'lt.json', NULL, 6427, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1032, 'a976330dd917209cc298debe0b3b971e5544d1fb', '5db76050ceaad47ed4158375c884e17270b587ba', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'lv.json', NULL, 6400, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1033, '5f8f80b5719717d8743d79066f4408f09ac4755b', 'f671c848d169f7f0e78499b815759b0df8829267', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'eu.json', NULL, 6467, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1034, 'c3652273b2049040bd1bdcad77ccb1fca5bf00dd', '9ef3956d4fb4307284930bae35a09a8d2e6d07cc', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'bg.json', NULL, 9439, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1035, '8720207648e0fb1aa07cedf427a99056954f3736', '9d7c3b51ddfb8ed32dccbbc80be10a36e0115e3c', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'bs.json', NULL, 5985, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1036, '8720207648e0fb1aa07cedf427a99056954f3736', '8aa776ad28c9a80a1622138149ca53bfa21a9f7f', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'ja.json', NULL, 5985, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1037, 'c7c13808e6e395bd2007e46c160cbe78c10c01af', 'cc20b8deab3b0c6874270ddc73b3c0e76989eb05', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'km.json', NULL, 6840, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1038, '6563091f65a421125c079b4b7b3af941b45b1633', 'b68d9a0c0ad5db38d74176dc73db2e96ac36bdeb', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'gl.json', NULL, 6344, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1039, '752fbf0b65a937268306661016de2d8457e52739', '63530a6bdec51042dcbe7346fa5c32913882c5f5', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'fr.json', NULL, 6522, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1040, '39ec99b419827bea3ed2c60fff30d51abf6dcdee', '6b6c8f6d96c1ca533bd096c39c820c65b1baf48f', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'sv.json', NULL, 5995, 'application/json', 0, NULL, NULL, NULL, 1698731341, 1698731341, 0, NULL),
(1041, '824a18cf69903a3a1773b2f8124436fdd27b2326', 'd7c1d95596ad4c8f106448d5f50cd373b630dfc3', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'cs.json', NULL, 6296, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1042, '8720207648e0fb1aa07cedf427a99056954f3736', '977683385188c8f7380868a6b5c0a92d0a4500bd', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'sme.json', NULL, 5985, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1043, '8ce1801ba4f0cf36dd4fb689f999ec64bf8a4823', '601f308b2c80e924952a8fde1508e164ccbeb981', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'af.json', NULL, 6291, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1044, '1e9bd972c7dcbe819e1276b7eb964885862d4626', '01d8850103c2db91648e66b7bf6cc590cd330e48', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'uk.json', NULL, 8644, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1045, '6348a9d7e64c933b1d0cb86fbb4d31a93c505867', '64ece5235f591e955284bbeb94e2d0154acfc188', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'es.json', NULL, 6533, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1046, '6945eb83424135811e72fc295e9e611e9d6a01c1', 'bea05f0908f0da3869a7b267ae654b14b557503a', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'fa.json', NULL, 7797, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1047, '3169e07bf12f29d2375652302b4938f07887071a', '4f0e7c114f535d50a20310464b74f512600558c6', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'he.json', NULL, 7218, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1048, '895e5c58571157bcd47643b24406c9accd2a83ca', '9d7786b197cf0a25c511f0c1e13cf0278a246484', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'ar.json', NULL, 6118, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1049, '5a94415ae0f501d4ce398db4d6ba438c9253ebcf', '44e803e9a8b877965e771872501f17f014c5df97', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'ka.json', NULL, 11176, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1050, '16997b72dedf5e3c774cd69a451c5850be64c71f', '52e4ccdbe7b98c208fc2d84690232d5609456dd5', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'pt.json', NULL, 6404, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1051, '78f69389a2f6994aa5fe79c9754acdbb48b3648c', '0ff0a96a07efb94328432c48294b5e2d94c50e2e', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'ca.json', NULL, 6670, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1052, 'c544f47e57ec72ef9ef17043b3ba139e222af529', '5b69388af977b16ed7101ddfd6449ee6571e94ac', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'es-mx.json', NULL, 6574, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1053, '119db0e05e6b96b1785c87ec42b26a1a4d19f07d', '864f51ab81cf329a0be773eb1650c14b315d4236', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'ru.json', NULL, 8713, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1054, 'd0917add1f513ccf938ce23ec6dc51bd7d601426', '2c1ff3a3d9801de4defaf4acbd0a24ea75dae8e4', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'tr.json', NULL, 6160, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1055, 'a40e0c6f0b60a060ec1b4207fe4104e6c05b2bfb', '204a6531f5f904a8371484ffc10417880f922c37', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'pt-br.json', NULL, 6524, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1056, '8720207648e0fb1aa07cedf427a99056954f3736', 'c82af13673764d4e095c9362bf218a659e4107ab', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'sma.json', NULL, 5985, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1057, '23646e83f23e14b68f59e3cf2b1ac1c6f6a397fa', 'b338c8bb1ba127c8015370fcd48dfd19d81bb596', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'et.json', NULL, 5857, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1058, '16dd6256787b7bc08038de2ecebc1ff3eed64d94', 'a3eee0408a38a184cdcb3dee41dd013eb268ff22', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'fi.json', NULL, 6220, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1059, '948220a454d3a37846e20291863e0ee1803f40b4', 'a6bc748b2307e889b0a410bd0ecc64ba670ddc0d', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'vi.json', NULL, 6876, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1060, '5d1d6ab2f1e2da49952940eef39dae907ec68a64', '03f1399c4dff8fd50a789624b0715cd0cc4f13e2', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'hr.json', NULL, 6245, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1061, '3d7f473d6549cf1b515c79de0ef92b4c24cdae55', '1cd0d2581b4a07d6f7ab7ac860b779349b0ffddc', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'nn.json', NULL, 6010, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1062, '8720207648e0fb1aa07cedf427a99056954f3736', 'f8317477db7a05bfd1a6582251f769b7e36e543c', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'smj.json', NULL, 5985, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1063, 'e03a8521778a53118e607ccc2ce94a0db94c59d5', 'cf52a130c3c7dc23a7d6c69e3f514419e973ab83', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'zh.json', NULL, 5840, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1064, '590df113b56fc5a69e30a12f0671e9f44879a0c9', '9624fcf983b98939ab58187eb99455875c7b94d2', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'nl.json', NULL, 6404, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1065, 'f080f40d171f98c1bfb2486a228bd1aa85d88104', 'a23ce5beb204cfee915812c5f4aa7dcc79bafb20', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'ko.json', NULL, 6466, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1066, '1cf3e4914a424e2d6775757438c3789727cdac60', '7a2bd067eec762fb29823b12d1b33b69192db0dd', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'nb.json', NULL, 5986, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1067, '3cf2aa9c85709d3884fc0c394ab3cd171b7d599b', '693420b47c904047fdcca219f43843e2b10244fa', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'de.json', NULL, 6710, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1068, 'cceaa34e0eeb307292847f98b21fbfb8284980ec', 'be5092ec1407a05be317671968c3caef940f60e9', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/language/', 'mn.json', NULL, 8530, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1069, 'aee4bd40a28fba1e863b86f5f95fcfc77edb86b5', '22983328a390bf942ca1db77a2de5f61c1defd3d', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/', 'icon.svg', NULL, 2536, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1070, 'aeb68ac6c0c64c754d5a98c4cfcd4a9e7cd4b899', '21a9d94ad5634c220dafaf7b913351b5b4ef15d7', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/', 'library.json', NULL, 1101, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1071, 'e673a3f880b1685f027f4afe55f5ff5445d2e29f', '6aa92d139e1ff81da3aa2d5b1fd72142d9706d49', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/', 'upgrades.js', NULL, 2568, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1072, '0f9963638b306259f6d9f759209e45d1ba671dd4', '066f385497d494040d2047986f3779eb0f7ddc3c', 1, 'core_h5p', 'libraries', 22, '/H5P.Dialogcards-1.9/', 'semantics.json', NULL, 12127, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1073, '75ddc43667aec2c3d8cf3bc36218706ad385d3be', '88d5503de38e39882fcbb1edc7c0d297aa781f36', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/', 'navigation-menu.css', NULL, 5223, 'text/css', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1074, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '968100b1c2ca1771a0943c618b019f41e15ae573', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1075, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '76878a67f27c159ae5a7eaf70768747542225550', 1, 'core_h5p', 'libraries', 23, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1076, '6a2e4e6a96e24a4045aeddc78cca0304c732059b', '8d9f838a699d84d7703581286f98486e7cbc58c3', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'el.json', NULL, 1192, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1077, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '5a94735e32e5c490a2f87ccd956c6ec12d372b6f', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1078, '8640f48b6de596f8db332ce398a5a8b93eeab1f3', '5717d75810c7427997edde0c900479639f0ecca4', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'da.json', NULL, 885, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1079, 'a674febcf53b63e9a0fd99bdda0d4451fd80af46', 'f115e837de5cb21a29ca5b6be5df3149b70db381', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'sl.json', NULL, 813, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1080, 'c7d3ce8ba0fe80c814e7a0dd8643407c819a1fa3', '2f19a8826bad4f73acc994378af27ee6e1f4ab6b', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'it.json', NULL, 896, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1081, 'b72394ff770f1986b5ad414173f75a359a751153', '9246954f7471e9ccc8a67c860871619f8cf2c0b7', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'lv.json', NULL, 870, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1082, 'b0eeb026c0181080452ebd1b6bef2927a106a91a', '9dca98d81e85834830fc11171edd479ff874b01e', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'eu.json', NULL, 855, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1083, '88f4ff375a069900cc227b85a3be2493338e6367', '8cc688949f167cf4ebba38fbcec892a2d199809c', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'bg.json', NULL, 1168, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1084, 'b2a8595a17a0e8dc13e0baf7653d0fb90a18829f', 'e899bd450d9fff848d03ce216c1b1e6dbfed47ad', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'km.json', NULL, 836, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1085, '8ab46cf2e2e9bdf417fda1ba8cbcd2be5408787f', '2c181b2408b16a23a56825566e859916a3d89772', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'gl.json', NULL, 928, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1086, '5957b34093153087133684543ef27042e3bbbbe5', '5e0e0e35c363c4cdf81df689c80c0250e63f0f18', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'fr.json', NULL, 880, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1087, 'c29c9f853409ba4dbfc37d8b53694273bdeaaa5e', '0570423d77b8d9dbc66591da089f5929a198ea6c', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'cs.json', NULL, 870, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1088, '25d51fe37699433533a659b8e92efe7c17175748', '253994225fa8dff51d464e8612d4cbd921bb5508', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'sme.json', NULL, 810, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1089, '1c9254be3d70b25008406534bd927ccf1b72c46d', 'cfde9ef45d8bb2dfeb1f2ed7022078572035fcfe', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'af.json', NULL, 853, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1090, '6f63a29418f62a7af4c9d3a5002d89c511adaa19', '6dafa1bb6cd7076a803329a4a6bdffc0a8336d97', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'es.json', NULL, 918, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1091, '6414779ffbbf9550351962e5b4e0d18735307c26', 'd859d63fb0280513aea80a57b64217ddbeb5b9e8', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'ka.json', NULL, 1476, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1092, 'fb331c3aafe4f1b524e80b8ab2ec68a9162e14ae', '19c3aa69dffe6bd7d2e7587040a064310745c6e9', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'pt.json', NULL, 892, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1093, 'd9deed8a81f3cc0f579092f346f16dfff1c49e02', '018be87964770dd6d65a00524a930f2b912afc15', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'ca.json', NULL, 912, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1094, '61d1065b26467c63949c16a20aaf5c548aec25cc', 'b070f1d588aea3642f40e22b362ec43cf805e536', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'es-mx.json', NULL, 919, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1095, 'a345b931c53f640369c3a2010224a0e796edcad4', 'd5a6b47f0cd547e41fb3df1ceffb344521412459', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'ru.json', NULL, 1111, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1096, '83445b44bbaefab9b49441b9b7155cf4baa90cb3', '658404835edb569c8a9003797194e769b6f9a80a', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'pt-br.json', NULL, 889, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1097, '25d51fe37699433533a659b8e92efe7c17175748', '9e86bca53fb304319d81971ab8a0987e69920860', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'sma.json', NULL, 810, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1098, 'dfa80b628be50e486dbdb7f385d688a171e41ec6', '3ea1e10227ee60d6b77b4d20df617effa37d74e5', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'et.json', NULL, 828, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1099, 'a7d1cf0930de9a78e8d734b0371d593f3998835d', '8c17d79f9a0d2374263a32c9727156c4240adec8', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'fi.json', NULL, 814, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1100, '3ca26924fd8a53e94493f3c8e622b7757f7e9d65', '1ac92dcb63a3490909526f210af4bbc269c2b26f', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'nn.json', NULL, 848, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1101, '25d51fe37699433533a659b8e92efe7c17175748', 'b33e03f07d6dafc242849abf83848636b7f37635', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'smj.json', NULL, 810, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1102, '9a052ede5bc049d2308f98ccb668be479c1aaef9', '58530b4ba685b29cfd4da355295205780d773948', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'zh.json', NULL, 811, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1103, 'f859f7c8671f390d9b239b6ad3f23ca6770ec5e5', '8599ab23e42bdbf9421faae4f0537bb578508dee', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'nl.json', NULL, 849, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1104, '57b8c25a60ba8f13875437c841f053c11547cda2', 'afb3b447019242c94e170cbf85362a62a1f4ec32', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'ko.json', NULL, 863, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1105, '722cab55364a2985ec0168217ec8c79fd8426469', '28c0fd6f3acd4c493847865844a3b7864e067163', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'nb.json', NULL, 847, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1106, '38705c6d9c0bb50d404272beffaa0a597b634893', 'a25d4d96dc46a800b897086cfb7b789d68286d8b', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'de.json', NULL, 912, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1107, '26a34833c3da67c0f340fd9445381afdc552544d', 'f20c4b358e6d3fe2923cb90fa672224c2673e3c8', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/language/', 'mn.json', NULL, 1134, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1108, 'c1acdc751ffb2882aed4f114a669395f3099bbbb', 'fc66be1eb5cedba22749fc32ccf321df75df8c05', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/', 'documentation-tool.js', NULL, 24086, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1109, '28a19e2ad0a9625d5160301e5ef4e235a3abd65c', '61ce04c11097d12b2c497ffaabc83f6f9ec4b1ab', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/', 'icon.svg', NULL, 2137, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1110, 'd7ea7f58f2d0441297f8f3375599205b5de20507', '378a2c58d2a11b22b12993ae6d4bfb3bff584b6d', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/', 'library.json', NULL, 985, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1111, '84f91dbf5e47bd56adebdce514c3744332e40eb4', 'b0978599ddd681d39e4ae6a157133e4eb809cc3c', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/', 'upgrades.js', NULL, 507, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1112, '1f64d24ad31e835bded8a1795272137928a3e2b4', '03d41551047ebf961406f0998a378f1ad6307e28', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/', 'documentation-tool.css', NULL, 3650, 'text/css', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1113, '876770fd9887c946019d1ccbbe2f3780cb641552', '642adec79732b48388669f41402f212d9297df01', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/', 'semantics.json', NULL, 1536, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1114, 'cd2a8ab27bfa863cf497b9ae40b65541efd3c1c4', '71ca6381708f746aa783f08f77a73d134b0a311c', 1, 'core_h5p', 'libraries', 23, '/H5P.DocumentationTool-1.8/', 'navigation-menu.js', NULL, 5741, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1115, '399355baed03847d9e9e03951ba091b6eea16492', '036feec1365acba756fa200a6933e34f4e7d38cb', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/dist/', 'h5p-document-export-page.css', NULL, 5342, 'text/css', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1116, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'f257453125414764a77b4d902b906b46189cec79', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/dist/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1117, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '7b39d930110c973616ea918e14215683f62a552d', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1118, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '3d5006309fb2ff2ffb2271693dfad63f52a508da', 1, 'core_h5p', 'libraries', 24, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1119, '4e09bb6a2f7e57caf44ba33df94d256371e70a13', '8292763e2bd0378dca514cf3b7d02dc75254b9e9', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/dist/', 'h5p-document-export-page.js', NULL, 344521, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1120, '61c87a110bd04d239f7a2a2658aedb69d9a3fdb0', 'dd4dc711aa30a168c3bf15726ff51126bd3a7d1a', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'el.json', NULL, 2753, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1121, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '4381b6475f1b06797ee3425a9df233e338514aaa', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1122, '849204716176972f9ddef5b677e030285d240181', 'c1dc3f87d1b1be6e67e2954a983c698fe1a9bd42', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'da.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1123, '3ab1b03aef8356e6cdd9d388f179ba78d18c7e51', 'b8480346f80072baae2537eae9fa34db89cb8813', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'sl.json', NULL, 1677, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1124, '464c81b82bd6c72dd60c01adc4a680c2324e5d3b', 'd7a6a429fdd3e3341e3036b43cd9f96ad849c862', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'it.json', NULL, 1903, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1125, '7f10e042d410dcaca375c996316f639335781f4d', 'bd5e6eeb647f1fb65e5a9e0c7b56f565d54aca72', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'lv.json', NULL, 1823, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1126, 'f9fc9944eba1678d066473cb51a08e48a09aefb2', '5aa087de1cc8507b382b337775c6b6949154bc46', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'eu.json', NULL, 1723, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1127, 'dfdd2b073a86ccef058f3b9f8c09b9ee510b97dc', '78edf12ee9f660473913e8eaee9518aae9d24edb', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'bg.json', NULL, 2841, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1128, '849204716176972f9ddef5b677e030285d240181', 'e79ce1ac0ef77885f6975fea45aa937b77eee40a', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'bs.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1129, '849204716176972f9ddef5b677e030285d240181', '12c6b3212f3ccbc1a05da326a7d16e28374260ce', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'ja.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1130, 'eb3eecb306e5d0b26a0983548ce7bc8c717a1d76', '5cfb631f941c9e3e5e9fe2a82d9633ca0666f9e1', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'km.json', NULL, 2305, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1131, '0d48902343e48bd489b74dd7bce8cbf02daed394', 'c00cea862039e3332cc3271e669ed4fe085af1e2', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'gl.json', NULL, 1795, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1132, '88eb9c4c582caa2b00fc0647a1119dc5cf40bfcc', 'f09057f4423aae92653137a3378a8943b98fbbc6', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'fr.json', NULL, 2067, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1133, '4d3d501f5efd91d4f46751ff5477b58ac93e48d3', '6640fa69c7dc704c6ba243291ce1c0a9a56787f0', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'sv.json', NULL, 1776, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1134, '8423175c915e47891ba755851b73387254923826', 'f0824c0558735f6cf04e7831444792295f914485', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'cs.json', NULL, 1817, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1135, '849204716176972f9ddef5b677e030285d240181', '957452f5f0ec0c88f821fc6504250a0460499521', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'sme.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1136, '0cdce170a7f022438af2c4a3584704028d9d534a', '1da0fad1e04ffb250c777ad7cf8ef0d42fb494be', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'af.json', NULL, 1749, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1137, '09e8e854b7cd966f5f24685a33b0a7ae017f0322', 'e19f379b4a98fe40fc7b2032eb86b2a11893eeeb', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'es.json', NULL, 1806, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1138, '849204716176972f9ddef5b677e030285d240181', 'aef69e6473c5a65f18636c312bdfeeee5f0beaf1', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'sr.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1139, '41bc67fa036108d9d358e1f86cec3033f203b2d8', '7ed142e9fb96ef900e5a482e304983d405932f8d', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'he.json', NULL, 1903, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1140, '849204716176972f9ddef5b677e030285d240181', 'b3ed9d48f0ae9a8078bad3f0e228d43ed51bd3d3', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'pl.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1141, '849204716176972f9ddef5b677e030285d240181', 'e2a95552260a06c73e1f9b0f307186dcf6171e84', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'ar.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1142, '849204716176972f9ddef5b677e030285d240181', '7686715bcf91f0b76bc1a3d6f369ad23723710e1', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'ro.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1143, '849204716176972f9ddef5b677e030285d240181', 'e7b832076b794096747379e68251b15d8684674c', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'hu.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1144, '5d60d0b296dc5aaaba9f2960d91cf48b833dbb42', 'dcc87c3282f1e2b61f5a4866f788be40974a4637', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'ka.json', NULL, 3570, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1145, '0a44c25d45f5373a771af8ab4831c5aa701c248e', 'f315add3395b63efec7852b3dde5e7f522deecc2', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'pt.json', NULL, 1815, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1146, '8892c7d1b6c732beb107dd5baa8dce0fb9ddf3ce', '57d06fc87e99e3489fa51a5673088cb28a2f06c5', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'ca.json', NULL, 1857, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1147, '09e8e854b7cd966f5f24685a33b0a7ae017f0322', '144b0410cb5d204e0d61b8c35dd31def6cf9906a', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'es-mx.json', NULL, 1806, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1148, '849204716176972f9ddef5b677e030285d240181', '7f2e22c8070d346d3f6fc30a6663240dbe4e454d', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'ru.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1149, '849204716176972f9ddef5b677e030285d240181', 'b0d00eb273dcf9b588b1a368629b350662e69b0f', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'tr.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1150, '5d95c1de8e439ee63b7a57097ac4971744e8ce3d', '37952b614e8490a5f8c442edf2619b1cfab7e661', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'pt-br.json', NULL, 1862, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1151, '849204716176972f9ddef5b677e030285d240181', 'a41f3d69ad57e0b525b3078d39c03a7e000a987a', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'sma.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1152, '91d50523f700590c27270a4f6b942235abc8dacc', 'c88c83a7cccda1219d0d474786d44d7add624e16', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'et.json', NULL, 1594, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1153, '595944736c204fb580a478bc7be1ab660192f99b', '99a001c3032eaf6cd468b421971051929c012b12', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'fi.json', NULL, 1707, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1154, '849204716176972f9ddef5b677e030285d240181', '7d79d4ca11d0c546cd0351e6369deb081e13771e', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'vi.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1155, 'afaaf305df701ec69d5346fec300bc36889a6161', '779f891962d129954ae404c90640c8eda03f2383', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'nn.json', NULL, 1861, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1156, '849204716176972f9ddef5b677e030285d240181', '72691607260624f38661bea09bb96b8661558034', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'smj.json', NULL, 1724, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1157, 'cd137e1376dac8a4bfad1ef37184132c36336306', '56df715e8aac11f2cd775f9212f63113311316c8', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'zh.json', NULL, 1719, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1158, 'af199f364d374b66d384590bf7e4eb7f905ecd79', '13b0d7cfe0565b81ea3ef72f6168a4e8c4b54ab4', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'nl.json', NULL, 1852, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1159, 'abee65bc87c333f973c5d7c5d23d9dfebb999364', '87a0b2c2163766b51290d922570aa93e21fc0a0a', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'ko.json', NULL, 1833, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1160, '47d7f80785465eb56f0f847876772c53cbb7b5b5', 'd5d52962ddd7ba6ca4f7c7117f122ebc29d7418f', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'nb.json', NULL, 1859, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1161, '9f8fe06c135be2df2e871f2838a65f450b847070', 'dabfc46598e8a462f4df52761c0a2815aea8a23f', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'de.json', NULL, 1913, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1162, '552e84bc9b31e7242a08aeca634f7e35fd366f28', '5c98d5c6faf0663fc9dc9d11cfc37013dfd69a98', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/language/', 'mn.json', NULL, 2605, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1163, 'dace4659da90f91b2144724352321d62bdf52a14', '00cceadd81e778958b21723df5e20e0501b579b2', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/', 'library.json', NULL, 755, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1164, '3687b198b73fa84287107b4e3c48ad7ccc005215', '83822182d89a4aba7957fbcc844d824ef0b82a32', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/', 'upgrades.js', NULL, 589, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1165, 'b0cbd710c072ab2d0db240cd4589e31890b70b5f', 'b4cf668ce1d45d882bd194cef126a2e0eac0754c', 1, 'core_h5p', 'libraries', 24, '/H5P.DocumentExportPage-1.5/', 'semantics.json', NULL, 2759, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1166, '843704f776b0ca326e86b44926af29a8824d9d66', '1f934f555ca424272fd50d13046f084bc12ca72b', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/', 'README.md', NULL, 1199, 'text/plain', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1167, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '5d348397eebec4b53c7abd7270e19c6f882dc5b6', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1168, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '91784cafae7957a12141cc23932ee3f06a78f7b0', 1, 'core_h5p', 'libraries', 25, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1169, 'e51db894d043402bc1f38e1c9e283797339d6baf', '090f993f88cb32fcf4a34dd7569bccf4814dd07e', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'el.json', NULL, 857, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1170, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'a19d8acc109fb6246edcc134a05d34fc7cb1660e', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1171, '56e9a77c5e5269840fe778d7cd43b034fe9612ac', '5b0aadc7ecd8d4885990b56689110259986089f8', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'sw.json', NULL, 544, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1172, '2b8222ab92e1cc303fcfe4c10ced645cbc0b51f7', '4c316a5532ec2ce02a23fec631ba8a965c1f2e5e', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'sl.json', NULL, 536, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1173, '2e1084d91a8ffc8b3cd2e10278cfea7ad8ae03f6', '1ccb44e4bc5d8938965897b0a72b61a8227de5ca', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'it.json', NULL, 617, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1174, '52c7f3d1fe67ab48e2c618a77ae4a2f13cd54d13', 'd6aa05b8debc06a3094329863d55b890ae939031', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'lt.json', NULL, 574, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1175, '2ef1304603c1b99ef4f858ed4544f48ce118ed02', '00cfd0042cdf1a7ad531ee00ca8f3ab13c1757b5', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'cy.json', NULL, 553, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1176, 'b0c14d73a644edeb9c33c5ddd597e08c66d8bd57', 'f701a41f6585b4d385acdb5ea6b5e07628c93240', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'lv.json', NULL, 570, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1177, 'ca2df36b80196b584208882b7299e94ae2281c9e', 'e47668f659d6a68c48ba4d7e73d3f75b9e252b25', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'eu.json', NULL, 552, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1178, '7caaeba62399df51842eb0ae41a4373d2f639f4b', '96e172d52817bb02ce83012195d7bd4664667159', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'bg.json', NULL, 855, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL);
INSERT INTO `mdlxd_files` VALUES
(1179, 'e2f3961cf5ffb0036d6e4abee0e0782519cd54c0', '51877fc77f147bb4c48a19170e865fb2872ccebb', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'bs.json', NULL, 562, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1180, '64e29acd5e856f8e8e847fec428ce83ab32021aa', '8b41ecb3a234234987bd2d344afafe6fdb2ef066', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'km.json', NULL, 855, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1181, 'fa49a9aec6edc67fb664d48410fc8c39ecbd929f', 'bfd1342cbbdcd606834aaed23ad4c77bd8172f81', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'gl.json', NULL, 582, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1182, '558357dab83ec09d25c8a7b01b55ddb5e22e6cbc', 'e71b3be33f02402e51055ee47b5f37ce7af3f1d6', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'fr.json', NULL, 607, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1183, '488dd19209eaca5459c90234c4fb6748d737a471', 'f970b03c93ef947d706cd8a3e213a0e1a79e0ac2', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'sv.json', NULL, 564, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1184, '49150061659e54ccb30196d35baed6069546c612', '8ff3e37e5c244d374de9f6584920da8ec6c65f36', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'cs.json', NULL, 564, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1185, '2c43be6e93ab7962294068305341dfe2fbdd30eb', '2e5df7259d9a29fabad29805d25dc8e9a5be0ba2', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'sme.json', NULL, 548, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1186, '09671263f13b479afdfc480b7a24abece8ccf983', '0209930862ab9befcd377efa58c729d31363ca4e', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'af.json', NULL, 574, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1187, 'c145bd41f30ba55e20620500a01adc4d13add801', '663c8346b53bb9884747a5af9a53ffab5b42ac33', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'uk.json', NULL, 764, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1188, '8bf9eb3d195feab03dc55939fe419d08d7ec1d42', 'd344d18639a613cf51146d49d25d7915cae7be21', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'es.json', NULL, 586, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1189, 'fed08df4bfd6142e17095b832e0c273eaa739844', 'e811da402a7f32322242e365ff05ebbd008d2012', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'fa.json', NULL, 713, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1190, '525aaa3aa67cc8c35ecd29acda56367abdea38b8', 'dbcc3317f846e1df3c262fd0ea7216387262a7da', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'ar.json', NULL, 655, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1191, '46051e4da525e6f62ca475a3536e300f6bec0e7b', '1484c5fd677d4daf230e36eaeb91d4a46445844b', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'ka.json', NULL, 975, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1192, '76c687ad4010f0884351c1bff0ba51bf14c35304', 'e21ad269b7dd742085651791dedc56ed90fc1016', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'pt.json', NULL, 584, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1193, 'bc4e7e794e2c59a3673a8c52c055e5c7600f38f1', '0fca33e5c6a6e06795438e062db8ed868aac027b', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'ca.json', NULL, 584, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1194, 'f3d291aa373d3b1503a40278e2eef77d3de109b9', '223a762c88c143b09ecfb6971ee0037cf651a3c4', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'es-mx.json', NULL, 583, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1195, 'f72c0ec5718f965ef716ac4ee319707f6f35c18b', '99aa41e94e0e6bfba77bd87a7e2b0c5e84dd1dad', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'ru.json', NULL, 831, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1196, '24440f815dda881bb8bc0f02c3a5f96097968dfe', '6913c705b0408332f289d388e8f033a20f1a9945', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'tr.json', NULL, 587, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1197, '9cbb7fdda730025a7bd712d7b0bed7efeda9ec8f', 'fcfab98c8757b16093a7e56ec98dd2ab66992cd3', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'pt-br.json', NULL, 596, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1198, '2c43be6e93ab7962294068305341dfe2fbdd30eb', 'b048bdeed8ee3e1223b199e379c0ca5f40cbc73e', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'sma.json', NULL, 548, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1199, '59a516bf704388e712d33c93125dfa8b36fbc767', '95bdd31f3072533a89cea6e95b8e346a58b7187e', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'et.json', NULL, 538, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1200, '2c43be6e93ab7962294068305341dfe2fbdd30eb', '58dac010de9bdbffcdb9e92b73a2b9a27f53bd2b', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'en.json', NULL, 548, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1201, 'f591b7fab839c9a507c96dc7c3eed8d349f40aca', '82ea18a41a076b31199a5c7345d18e6c31bf4b31', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'fi.json', NULL, 582, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1202, 'd8c23f4b553664c3732275ec6d2eb861964a5f2f', '3c63e904f3551a841cfcc0601a9f956cfc570ef5', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'nn.json', NULL, 548, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1203, '2c43be6e93ab7962294068305341dfe2fbdd30eb', 'c6af9933d4ad550514167619bc4b22c29982cfab', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'smj.json', NULL, 548, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1204, '152d9c61bb9118026c9508c43573bff68ac90846', 'dd35417aad86b7e97c671a163d7b600fdb90b974', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'zh.json', NULL, 504, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1205, 'b9aa5edf58373aa94bbcca149b3952e8ded088e6', 'e5e2452bfdefc8a107e1b08ce7dc2c3921e23e66', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'nl.json', NULL, 582, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1206, '1d1d9be230b78361c30ddef5b186d53b4adfe325', '7d3c9372d1285dbd72abd11ba5f642c60fd26e71', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'ko.json', NULL, 580, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1207, '8e5b3beadd8a1c093caba606d0173d2e9f979b7c', 'b7fc70c5b951084986e0ec287059145375eaac4b', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'nb.json', NULL, 552, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1208, '4a9964d4ee161ec287ffbcb4c4e36ab0f984d0f2', '29d352b227f142434f25c12325f8151f75413770', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'de.json', NULL, 560, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1209, '58d19bb368121bf1f4847950b8334c38fcd43858', '1e74cc1cbb9303d93da7485d70165d1bfc56fa55', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/language/', 'mn.json', NULL, 735, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1210, 'd224ae7eda4f12a2ceb7ae54de7195a00c7647f6', '4a8fe029f8e4d7c2f9c65b6246192598c394cdad', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/styles/', 'drag-n-bar-form-manager.css', NULL, 15989, 'text/css', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1211, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '49c887d393798575ce52740af07916f15bf4f3be', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/styles/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1212, 'a46e2c5aaae5f08871f7739fec91b6b108aeaa9e', '234223df98714a198287dcd1a1e09bb96a2c155b', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/styles/', 'context-menu.css', NULL, 9737, 'text/css', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1213, 'ed0a53414db00cae50b7e5fadbb58973dd121ec8', 'ae412679aff7c8bbfc45877ee893e4c30d4df24f', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/styles/', 'drag-n-bar.css', NULL, 4016, 'text/css', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1214, '4e47e508955331981064ad56eb877a8198330894', '379416c2216e806fda7d8f85d4dc6fc49d1a665c', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/styles/', 'dialog.css', NULL, 3529, 'text/css', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1215, '949eb78bb30492cb5566bbfd1c8125255b5a5a9f', 'f9c643770cd802bd83fe70fb28988901c7d430bb', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/', 'library.json', NULL, 1225, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1216, 'bb18d57038fbb6021b6e79ea8b6854ffe291d3f0', '6b43209a9af842e20df1fb517d13d655021c9999', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/fonts/', 'H5PDragNBar.ttf', NULL, 1128, 'document/unknown', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1217, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '5ed87a5ae566343aa8909cd14248d759ae5a4a4b', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/fonts/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1218, '0c0c2f741e30e2d0a68a80f7f39df3602e7eb83b', '3ee292b8adb6acc76a77d7fab7e6384eb4caf279', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/fonts/', 'H5PDragNBar.eot', NULL, 1308, 'document/unknown', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1219, '9564d20ca92be0cdfcdbcdd40510e2a32c1aac3c', 'fe70d29f8a4be5b3fe1e5a33289b037a0c6b4e2f', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/fonts/', 'H5PDragNBar.svg', NULL, 640, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1220, '651e0e4ef9d95e1c2b758b71c03b3357ec1b9e91', 'feeecd167f2a1eb8d7c55e0392add60d19386abe', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/scripts/', 'drag-n-bar-form-manager.js', NULL, 28562, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1221, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '147f021d8d4b0f24472aba7def28216bdac82b8a', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/scripts/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1222, '6f089cdc9dd14bcd456cea48b0f79226fb6ca0d6', 'bda8744204cf3525537a9bf1fe83b9c0f81d9cf3', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/scripts/', 'context-menu.js', NULL, 16818, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1223, '221711c27ee69922210b0b0fc5a966b6c69ac9c8', 'da721745a8a3c7110a264256c5c075dad3b29e0f', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/scripts/', 'drag-n-bar.js', NULL, 34918, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1224, 'c7b1d180701e9bee13a7ab6e210cc5b643d4aad8', '5351deda59b1034fbf2042b269cb2d65625e7821', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/scripts/', 'dialog.js', NULL, 13790, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1225, 'fed785474e03077285d2896a4013df3cd3ac6937', '475e214797b53c45e366953b8c3914276d62c22c', 1, 'core_h5p', 'libraries', 25, '/H5P.DragNBar-1.5/scripts/', 'drag-n-bar-element.js', NULL, 5877, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1226, '4f21cddc5e8ce33c55b2dcbfc9e52381d346029e', '53a0db0c7e0ba9d1b2da274a87fbfc671a89725a', 1, 'core_h5p', 'libraries', 26, '/H5P.DragNDrop-1.1/', 'library.json', NULL, 375, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1227, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'fa2bf31675053d0f194e055806c4bc395aedde7e', 1, 'core_h5p', 'libraries', 26, '/H5P.DragNDrop-1.1/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1228, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '5c594e386c7f094e80d018f81ef4e73995125b4d', 1, 'core_h5p', 'libraries', 26, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1229, 'd300ee7390e907cde3ab27b9cfaa467947018fcf', '0ba5a04921d1e2e8510a7095bf778d7a98bbf236', 1, 'core_h5p', 'libraries', 26, '/H5P.DragNDrop-1.1/', 'drag-n-drop.js', NULL, 5527, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1230, '23fba68db28e0dba1e455329f9858def2a59503e', '63e72def45a68e09a12873b93a74141f00b5ca41', 1, 'core_h5p', 'libraries', 27, '/H5P.DragNResize-1.2/', 'H5P.DragNResize.css', NULL, 1091, 'text/css', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1231, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'f32d12a01ce615a46ecbd6d46d54cad61166c16b', 1, 'core_h5p', 'libraries', 27, '/H5P.DragNResize-1.2/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1232, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '97e73bda0eefd0e688460518e3f2deab8b50ab3a', 1, 'core_h5p', 'libraries', 27, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1233, 'ded10f2b84624fb3e86b5ccdaea5716b926e81a0', 'e48bb8c2a5ff9400f2f15c874fbb2cfacbb05bb0', 1, 'core_h5p', 'libraries', 27, '/H5P.DragNResize-1.2/', 'H5P.DragNResize.js', NULL, 13826, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1234, '6779099851dd4058da8426ea1dbaf1d0da07be7e', '026e919c31db4ffcd3dd86482377be468bd98062', 1, 'core_h5p', 'libraries', 27, '/H5P.DragNResize-1.2/', 'library.json', NULL, 440, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1235, '5b9c1009efd9ccb06ee01b4d92af866c42a7c53e', 'ce640dd96cf52886e01bf8f7ac8f6e98a15e1e64', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/', 'presave.js', NULL, 2556, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1236, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'ac7f129d3d49f868547b1d7fbe8e59e85384430f', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1237, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '5e04e2346b78bd4ce1dd78ad85de6a45ab98c551', 1, 'core_h5p', 'libraries', 28, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1238, '8c0a65ca7964d3a8ca605e4cf5c3af26c905f943', 'be1ba265ba9f54f13fd2b23e06d5640f277be187', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'el.json', NULL, 13731, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1239, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '029dd8454456474aca36be00016086890f4ebe37', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1240, '536abc02e163b36cb44426bdaac82815a48fa45f', '53ef758b2385e4b6d34bda63482a51b79c0232e9', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'sw.json', NULL, 9302, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1241, '7ede259fc57b9116f0b1c15652a18101430673c3', '410747b746f2bb2dc685e73a144fade3cecde0da', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'da.json', NULL, 8672, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1242, 'b5e8a7c69706b6b31b2c35ea9ccb2e88f0bc5351', '464e2ae85c03663971cabbb510ed99afc18011e7', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'sl.json', NULL, 8951, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1243, '85201a075d6d41e0451e6f9ccd4382c113beaa46', '10545e4b2331ab14d481da520a4166743027d8c2', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'it.json', NULL, 9463, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1244, '649b870d5617bcfcfd4701d8bff5e978a2f30c16', 'c4ece8ee8e0cb8d705d85ef83e748e93626b740b', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'lt.json', NULL, 9217, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1245, '844ed2e006014542143fdd3f7f7fcad3043dbecd', '5dd14fe50445b4d3ac196a92da276e87b5a1dc15', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'lv.json', NULL, 9598, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1246, '72b5a0f6feeef229d2d1adca5c376d96771bb331', '8b47f0eaaf435ac9c36d9d479bce4f3591490910', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'eu.json', NULL, 9202, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1247, '68ff6fcfe2a2554da361f124332a27afaf313b95', '81f42cc1d5ee03dc2bdbd447332bb50f93d2db31', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'bg.json', NULL, 13328, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1248, 'efa8d64b8c6cf5177566be121f91f30a2a0a0c86', '2bbe7d093164454711b90c6f6901423ec93ac0f1', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'bs.json', NULL, 9069, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1249, '79b6ce81d66ad7b7ebfa51b1438ee193f3b3986e', 'a68ce4c45eb925c7558f897e21568299c8dd98f6', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'ja.json', NULL, 9976, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1250, 'e74dc9edcbc4829605aaf596b302c4134b7558ef', '486136db509cceb92756d3f4842c9af59f333939', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'km.json', NULL, 9207, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1251, '9f4905f9a40a57e6e0a06210175b1b18839268f4', '0fb644225f89ff2dd8ffb671335bf060bb559de4', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'gl.json', NULL, 9628, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1252, '49db504fa261a7967dc3eb2b37987154f26470aa', '214b312ad2bc95779a00d604fbc8bb7da57f786d', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'fr.json', NULL, 10070, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1253, 'aef2a743105ea621bc321b2d79a8bda7863079ed', '364212aa5a0233301b6a582053c0ed88116db458', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'sv.json', NULL, 9169, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1254, '26c7b18e8feada39276bcb678b509d11b9470d7f', '6373966736cf2465adcdd76f8fefa85c41b07530', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'cs.json', NULL, 9388, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1255, '19b589b7d90f16405906dfce1a21ded2ef3d4b7f', 'c1ae3069530a767300b5a5605ca72bd9abdd09fb', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'sme.json', NULL, 8594, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1256, '9bc9864644a3747b1a7b73899bf399eb98ee3050', '84eed323df649b2f9aef77a198410f52d253ca7f', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'af.json', NULL, 8906, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1257, '8b378e461b11f5789a0e99ae3e3077bccd2cebda', '30fb233412e534170901447bfda87f7a1a9bf416', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'uk.json', NULL, 13255, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1258, '4307b1f25326297556820a2bd541f0381017335e', 'f7e02c27e79ff65673e58e1ab6d1791a4452f7d9', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'zh-hans.json', NULL, 8144, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1259, '3718890cdc55c6556cfdc2988f1e51ae8d7bc378', '9dae128a3955e9345d9a79036e5b24a30050872a', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'zh-tw.json', NULL, 8156, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1260, '7964e8e8a72585e0c2d2d41c73400034214bec42', '4c567cb6143fe357c4df54677c1c951b095e869b', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'es.json', NULL, 9786, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1261, 'bca92880b917e4446bf3ccfed9962ddcf400c60b', '917d61455a20779ebdf45f9a836bbdcbd7c948e0', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'sr.json', NULL, 12485, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1262, 'ae66d234efd0fcfc4db17575ff013e8fa34f7991', '8af7c526ea1649a8119e922f21211279fb4816c5', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'he.json', NULL, 10171, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1263, '46716b62ac5b418ebb8e3b1a2decb2b7109c20ee', 'd47ced70ce27144d8b71e6ef1ed271edfdd2097c', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'pl.json', NULL, 9986, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1264, 'b31e605d3463f1e6c70250a7db8ccf71102c5b48', '2e0f43dfe2bd7a8360d407bea78214e68cc4f589', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'ar.json', NULL, 11064, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1265, '19b589b7d90f16405906dfce1a21ded2ef3d4b7f', '49d467607cfb40c1167d4a53a01f3b2d599be831', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'ro.json', NULL, 8594, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1266, '45a181238b688962752dff3e8a31aca314d2826e', 'f119b70d058bb2cdf95d78ac03c002655da98148', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'hu.json', NULL, 8605, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1267, 'beb1aafe22a28c41a202122ef3aa4b91cbaf96b3', 'e897957ae3c8989191801289b6f686d97fbb79b6', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'ka.json', NULL, 16622, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1268, 'c2c35e0b41e21de075be4ae1365dc5da294de68e', '3014fdcafdb74ad64f3a5fd42b5b0cdfcc86169b', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'pt.json', NULL, 9607, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1269, '8bdbc60507a9399b3a51006bdb4b51c7092571b5', 'ac6d4f8f43cb84ab069e822733c00e949d574b40', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'ca.json', NULL, 10092, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1270, '7e50a16d2513e43fdb91ea7d14c48f3ce1ffe297', 'd76073bb71df418756f69621fba9f75f0f6afe04', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'es-mx.json', NULL, 9612, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1271, '5a2ae86f274a4585f3217956ed006180af509775', 'd072fb1345c3fc5feff9daa5accccf4eeee8c36a', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'ru.json', NULL, 12698, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1272, '5178cc95efa927eda53bcff90f430caec998930e', 'aa3e46aaa51a66675618728499c8ce0df4ae30d4', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'tr.json', NULL, 8752, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1273, 'c83432c7fe10ff6517b8d4c2beb499f7a0fefbfa', 'dfd63d78f2c110482aba8f82711a5035051cc2f8', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'pt-br.json', NULL, 9677, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1274, '19b589b7d90f16405906dfce1a21ded2ef3d4b7f', '08147e3156019679d07901bea28beb22083aaea2', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'sma.json', NULL, 8594, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1275, '1a3a2cd6e5447738c49f79082b757274bdb5d022', 'd1452b9021f7399dbf68998842bf8abb62a3c601', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'et.json', NULL, 8623, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1276, '8cfa4dd48aeabe17cf1dce76c77529b834ce096c', 'ebe5f6f2b399196e4b59d5e959a0efdbcb9308dc', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'fi.json', NULL, 9060, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1277, '19b589b7d90f16405906dfce1a21ded2ef3d4b7f', 'cfda85556680e3392c45688d51afb3f3bdbe6c89', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'vi.json', NULL, 8594, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1278, '14a406ddd00e3f5de263d30b918ccbd929d9e36f', '8b365453b17da34f0fbca56733ec0caa5797882f', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'nn.json', NULL, 8726, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1279, '19b589b7d90f16405906dfce1a21ded2ef3d4b7f', 'c239cd6727d476d65e3e042e0cc96e4de97f7a68', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'smj.json', NULL, 8594, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1280, 'f4d0ef7a7682794bb0ac35bf9b7ea5f55fb2c26e', 'b7e45e6bb8fe3234c261823a87d43dd2222b9588', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'nl.json', NULL, 9402, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1281, 'd109a926ddaeefdd51a9280e2387ca58ea1fd961', '72ab163d391eb0b15661136ce3f25a6e65a4de75', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'ko.json', NULL, 9310, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1282, 'e8adaea4afbac44f64f5bcb10f89eb53fea2771f', '45db12a00a2055dbdcc9cd058ae6d5ff66f9c9eb', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'nb.json', NULL, 8699, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1283, 'f753e5f03318534f491c4413ec37bf31222d7cf8', '9d8f97b578d30c732f6255bdb9f2c0009ade8afd', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'de.json', NULL, 9982, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1284, '4f165d0bea81ebbecb48b2206cf8a1cc332599bf', 'daea8ea35031e664f99302ed508d361928f15257', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/language/', 'mn.json', NULL, 11982, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1285, 'fad52f26082da3af1129012037c3709fcc576662', 'e875aaf229a0abb3897102daa02ca6c4b2d39a95', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/', 'icon.svg', NULL, 5676, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1286, '506d396556e4d1e24905c4690eec50d16680ef93', '066cbe1c6da4d0c3f1e9680cf6a5746b6b8e2a38', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/', 'library.json', NULL, 1340, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1287, 'c431e50d84d65f32890a4aaa84bcdffd2c195dd3', '3afabb779185dff869e03598977be24c87003528', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/', 'h5p-drag-question.js', NULL, 38383, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1288, '5748e1923edba053a40b39c559ce8f27ca968efd', '4161d47cdf4d2d34ba0a348e7f8c7b3b03998960', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/css/', 'dragquestion.css', NULL, 6511, 'text/css', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1289, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '1914292eeb9c7b43185b58bc9babc9c676e7689b', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/css/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1290, '13046c12e6f257579159cf89e12297227405b5ed', '63a6338ad1968c01451d415dcea8dd9da124ad92', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/', 'upgrades.js', NULL, 6415, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1291, '3397820a9fafe59c46a9b1a87ef98200cbeee826', '931ee3559fc31350ff146d42b99897aadeb5fc7d', 1, 'core_h5p', 'libraries', 28, '/H5P.DragQuestion-1.14/', 'semantics.json', NULL, 17660, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1292, '4f75ecb243175fdbf5192c8dcff4c73d2ffdbf2a', 'cddec1d742177e3ee442c4a3a22ebe5bf4d86e17', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/dist/', 'h5p-drag-text.css', NULL, 4898, 'text/css', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1293, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '434e4a46a0f802af48c0abfb3f684739641fd857', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/dist/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1294, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'ee880b3b498d744db57b404b2bad192b4787c1a7', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1295, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'ee525147f48cfc4561eeb28dd2efa3f5732b0c5a', 1, 'core_h5p', 'libraries', 29, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1296, 'd51d4b4999f1c41b30fae1dab931d3d53b95c101', '0832d56c317bb7c278bafa7b7afbbb4304f94e18', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/dist/', 'h5p-drag-text.js', NULL, 36595, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1297, '1825e24c21a776a2a305d477a3a75c5b8a3edfc7', 'dbe104799419b8da97208f25d95b9a96c6429201', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/', 'presave.js', NULL, 690, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1298, '0e39a105852d19f9222b7127acc7d64c90200cf7', '72493b8208b078cf11b2797705283eb5b74ed8c2', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'el.json', NULL, 10569, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1299, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'd00feaaba5b3e55b614cc37eef6e528fd066a608', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1300, '3d742ac1135c9c2de12cdc3e7db076a390b6aa7b', '144fe26a2b53df020e91672e29b6764f79d9f350', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'sw.json', NULL, 6232, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1301, '1399739e9b516e3058a7e5240e207a74b6de1b1e', '41c5cc74a3bc4037e018b1c3dc806f8673131805', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'da.json', NULL, 5736, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1302, '46e6cc19b388c23a49407378a9a46a779fabd687', '2e97659a1fd69e74540ef0e09081f3ff94569831', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'sl.json', NULL, 5792, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1303, 'df0717d9df2b5b270950f146f8a9648d4e48ad80', '1cbd163317268b7207a62d9794633de2919d7adc', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'te.json', NULL, 12055, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1304, 'f62e9c9c865940c01d29ce55252a10674d3537cf', '9c97a189fb4bff4359224000464e32ca9509941f', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'it.json', NULL, 6408, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1305, 'bafbb24d766d1e8fd747830b05838d2adb0d55c6', '38985f28644b1cff8bb4db950154e2ebb76ce586', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'lt.json', NULL, 6070, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1306, '091bb110026e3de74c38d18a055127e3c323f198', 'f98dd94ba4678c4e656e2cb39df611f83c4cda7e', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'ga.json', NULL, 5799, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1307, '2ef6ecaa6294bb0cbf065eb8e218b65272b10bd0', '6a3d46dd2b1df32ca019d7e6e95f6464684d81bf', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'lv.json', NULL, 6595, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1308, '18b522505da914497ce412594d3c36c4c93eb537', '98f1e3c2fa45705a9856ddb977267fb24ce19b0e', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'eu.json', NULL, 6265, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1309, 'b920eba517147b3c65b01886f1d664139ed851bd', '64f813f9ec587a7dce59b9261e91f5c9998a9b04', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'bg.json', NULL, 9259, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1310, 'c74faaea30337962c6bc0710d8ba8bda81a1ad56', '3b2793519530e619ca7f85c6fabff6e224314f17', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'bs.json', NULL, 6005, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1311, '8e59f6b4680cc516dee8d250edede312f7533c0d', '5052fb98db1f9fa5045a249abfabd3b3489ffdb3', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'ja.json', NULL, 7041, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1312, 'e1db5307031ef1dc0631a47351e91eeca9a9e007', 'dd6949e3dd686e24c148d5423c9ae8aa09c423aa', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'km.json', NULL, 9743, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1313, 'db222000f423e9aad4b3247cdbff780aef324245', 'b6d96d40158712bbf58d2cc7db98634e72f6c62e', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'gl.json', NULL, 6441, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1314, '84c23e2ede159397c7fb718feec79f2760dcb24a', 'd9850f04107218c4bad7b779a88f64691f543a7c', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'fr.json', NULL, 6687, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1315, '4c51f9881489c909976fc1215d4842f940178f09', 'f3656d59600a8457de29fa57b096ac40469fac5d', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'sv.json', NULL, 6328, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1316, '6ae059fa96c85d65d4127f3fc2d5c120afa48c0a', '36292573d63469ffcf2acf9a3f7b46be25e78ff3', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'cs.json', NULL, 6477, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1317, '628e530e6cb9f79fa77c0c7579ef093cd332b77d', 'a03ee7c49c6f7cd8b7c6bc43877c3d266dc883fb', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'sme.json', NULL, 5738, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1318, 'd1338386562305b5dd1d7fedf65ccb53e2134a8a', 'b42501f6474d9224da390ee60d27155d740650fb', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'af.json', NULL, 5898, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1319, 'b12771184a360caa3cd83bdaad208f18b45d4afd', 'd832488f68c914159ec5bd6fe87a0fbabe207353', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'uk.json', NULL, 9367, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1320, '21b2858455a1df0ede6295698738feed52d80665', '653e4b2a35fed801ff33c90ae0e395988b0aa3cf', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'zh-tw.json', NULL, 5264, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1321, '9b5763cd8f07d1f4a19c5c3524926d03268b1f23', '74b4aaabf0372870a4bd6dc024304852a064df32', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'es.json', NULL, 6822, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1322, '01fb6810180b9637a28ed9f3ba4d6a76cd6ad17b', '0fba2658bc5dca62d63af6b35647f4c882ed3dff', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'fa.json', NULL, 8611, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1323, '8b5bb4024bc96334b58fa5520761cebba6b24797', 'e6ad76575a9158a237f3e2327305e9c8da7b7e15', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'sr.json', NULL, 7413, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1324, '318ccc49cc7bdba019a4324912fb9d370d95e8d6', '25d3f53270c398f31195f8a364ff16b9832b809d', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'he.json', NULL, 7148, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1325, '5ba4e6971e41fc92eaf81f7a159faf8cf5d0c47c', 'f7ecbbe49f995b5af605a3bcb9ef8bd099a4ad60', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'pl.json', NULL, 6156, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1326, '8136ac43f6edbfd258d07140c382f0f1d3a3be52', 'cc2bb5e6d21043b132b1795fbe6c61b6a690e85c', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'ar.json', NULL, 6943, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1327, '628e530e6cb9f79fa77c0c7579ef093cd332b77d', 'ba2006a552fbaf4ce1fa7ec7e20ce1492c033b90', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'ro.json', NULL, 5738, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1328, '9afec706be4056b0af1fc13438e017225cae5888', '2820acc2a3d8eaec6599c4a9b2a3f596391b91eb', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'hu.json', NULL, 5758, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1329, '33dec719fdf68bd94c396da2e9d512cb23e026c5', '05f7cd4980a0e5d869fd52ab2d5e43efa98e3c98', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'pt.json', NULL, 6378, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1330, '818a9c53685a03ca505c46221d4fcafe1789afa0', '0589b5356f5dd9f137056bb6cb2908ac798c81c0', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'ca.json', NULL, 6991, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1331, '94992a292be5d5fa0fd6db54e6870f2d45d7a8fc', '440e363ff6a532541a5960af5ee57f15f58e5792', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'es-mx.json', NULL, 6703, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1332, '79480a508e7f8fb8bd79121b7633564ac4392064', '174cf3aecfc64be5ebff6ad4c81920899a312114', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'ru.json', NULL, 9251, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1333, '51cc716090a144177ac87378a3f58d09a06269bb', 'f952d62a0147655ff957404554c185043fcb67be', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'tr.json', NULL, 6587, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1334, '7b798c5058063da228932dbec00ba1f172fddc80', 'bb1b8c6e2867fe57e01aa9574f8db3ad29deb860', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'pt-br.json', NULL, 6430, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1335, '175dd6405a8ce614abdf975d245b3424e107a7b8', '1fc5fc067ad7133d3d7340ab1ec1383e20ca8f7c', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'sma.json', NULL, 5739, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1336, '9b905c7a9e2bb997c441f79e568fd42d4c0c4ae2', 'a34b75b0ec73bd17f7e135c328e0e3d4d4a0ecba', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'et.json', NULL, 5789, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1337, 'ace02a5bf94a11d3715e62ae5f779375a025608e', 'c979b4bdf9c73287127fa5ef13ed983075dc157c', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'fi.json', NULL, 5705, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1338, '175dd6405a8ce614abdf975d245b3424e107a7b8', '54705c65f19d2d850c4fb1950b7f7611fbf1bc67', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'vi.json', NULL, 5739, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1339, 'dee6d7b52c4ecec02d8d0bc7242176a1b4194caa', '631dfb841266788627aec4fa9d50cfb0cbc64f10', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'nn.json', NULL, 5801, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1340, '628e530e6cb9f79fa77c0c7579ef093cd332b77d', '8f1e9de454807540c7b10ec4213f1cf1dc4e6688', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'smj.json', NULL, 5738, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1341, '0e96904dfad286e7f41488a3a4dc3c22a88ffaba', '2af4a8094c305fd05b09e12ab58c8cc7df519d41', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'nl.json', NULL, 6086, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1342, '0947699cafc3cc079d84eebaa3b76f52d0247e17', 'a45c5716277690d2fb3fe8c3f81510fd5868b040', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'ko.json', NULL, 6414, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1343, 'd7dd9ab9eb2773265a39d810ce3248cf91567e79', '78180f73e75fb52bfa6b3a883a0644e19f016dbe', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'nb.json', NULL, 5846, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1344, '98110028fec977a145321fb2459ea984b6b1303a', '73c8739fa5792fe52be7fe2a56ab69a0512772a1', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'de.json', NULL, 6662, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1345, '6360006b6476187ffc799e326095e454ad2dff45', '6315736d3d36c03bfcf6329937220fce911ea16c', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/language/', 'mn.json', NULL, 8851, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1346, '3906115fc29e411b9ac87ef9950937d32e8b21fb', '990b5813e86478294bec91455bca51d676172a9c', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/', 'icon.svg', NULL, 3752, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1347, 'b6ffa92de0510cf448054112587eb325d4d69893', 'efbcc6c02d8003514a2afdd43ebe5019c2766f11', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/', 'library.json', NULL, 1185, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1348, '8b7e4a01d3c5878a93a758b0db0c8a1d5d4e7462', '7b61eba2ab00d16a46f5004870ed3b5a912d1db7', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/', 'upgrades.js', NULL, 1846, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1349, '55b29c2eef62434d4f024778ff769cbf3c7abe4a', '8938a535943cad4d20f54f6a22a9942032990a47', 1, 'core_h5p', 'libraries', 29, '/H5P.DragText-1.10/', 'semantics.json', NULL, 9883, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1350, 'a4260d597b924b9c8e0ac6193ef961df73d8bfa4', '1c617c813dc077ae9f9c8cfe227aa28292fc2446', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/dist/', 'h5p-editor-audio-recorder.js', NULL, 132847, 'application/x-javascript', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1351, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'cfa02d2ee265670a715ada527df6a339c7e6a2ad', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/dist/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1352, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'dc0a0dfb391a1bcc8dc5550be0dda60c9a4fc96e', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1353, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'eb6d0e9f1573724164ecd7aeaef7cac313e5d419', 1, 'core_h5p', 'libraries', 30, '/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1354, 'f72cb6c796f074ba17b6bae894b2c59be9ce2af9', '9f5a1dbbea3f12cd8ad669ae118ffbf3b6bbb24c', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/dist/', 'bdfbcf13eecdd619c277.svg', NULL, 1519, 'image/svg+xml', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1355, 'a462165ab8861b5aa4d9c1dc026d1484773246e1', 'd104b8e790cba042ee52c252158d802e36d6fc81', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'el.json', NULL, 1715, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1356, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '24f20e230f1c754290ca237b85dfb128ff21f1b3', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', '.', NULL, 0, NULL, 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1357, '2578c1c2db4bcc7dc7d5ca11cdf2d10bc677ca49', '703adae2049a829b6cf78439fa197b0fd8cf1ecf', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'da.json', NULL, 1294, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1358, '911c6bf8098af63427fcdacb345a14fd5ebf3c86', 'a6e40937b86d64941bcb20ed88398af070dbf787', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'sl.json', NULL, 1254, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1359, '4501eabde0e0454890ce7863fe1a5cbcf3dbe6ed', '6017ba6b44b1ad83d350300ab806e561f4cf8e6f', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'it.json', NULL, 1319, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1360, '5b4f9431df0d3b00215b702d401015523014e91d', '6c0f0b7bdac0e31e2c8d0f041fc2023ca2e5210b', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'lv.json', NULL, 1368, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1361, 'ded69e244302e2f1a0d6bf446d9caa4b2ec57cdd', 'e0f508b708d7a01b588e74fdce3a56a77a1b46b5', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'eu.json', NULL, 1363, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1362, '87f1fbe55fe790bb60f667a9ed783ebb0bc66ab5', '905763a02e99b714967223c8ceb42a35ecc3df67', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'bg.json', NULL, 1756, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1363, 'e2066e9905e15846b8dd77a0c54fadd268e3a8de', 'a33a463f6a8ada192fe62c9e2791151803074913', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'gl.json', NULL, 1289, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1364, '3f2d838191a8347d9abb0f743c9fc2486a69bfab', '04ddc6e64fea675743dadce52ab8399f45815c94', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'cs.json', NULL, 1347, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1365, 'c3658e59dacc6d07aaefe1a7f8ab7b01d6bc3778', 'cabb8c91c12401a9a57ba4005939184ed72a034a', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'sme.json', NULL, 1194, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1366, '2c9aa4473a44162d1cd8bc47abd5cab2f8533c66', 'e27cd47a5d66813a02fc26ec80b62e3ebe2c53d5', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'es.json', NULL, 1341, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1367, 'c88cfd16fb95e5157c8608d8c4722587b823f6e0', 'a4b6fe28fe324671259e1f0a608bef24e5013ef9', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'ka.json', NULL, 2402, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1368, '1f5739574efcd9bec517f10e86170cfca9b45d3f', 'a89e9fd6a86572ae6fa1ecd6a45b6a75bef0a2e8', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder-1.0/language/', 'ca.json', NULL, 1344, 'application/json', 0, NULL, NULL, NULL, 1698731342, 1698731342, 0, NULL),
(1369, 'afb94e45326a5a2d9e9bb6561ad6af7230cfbed0', '911e894fcd04bdceb7f2d3d05ed53413e7558391', 1, 'core_h5p', 'libraries', 30, '/H5PEditor.AudioRecorder